/*******************************************************************************
 * Settings_Bathroom_Shower generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Settings_Bathroom_Shower extends Settings_Bathroom
    collapsecategories;

var SoftParticleSystem ShowerParticles;
var bool bTurnedOn;
var dnHUDEffects_WaterSplatter_Medium Splatter;
var() deprecated array<SoftParticleSystem> AdditionalShowerParticles;
var Pawn User;
var transient bool bNotCheckpointLoad;

event PreBeginPlay()
{
    bNotCheckpointLoad = true;
    super(dnDecoration).PreBeginPlay();
    return;
}

event PreGameInit()
{
    super(dnDecoration).PreGameInit();
    // End:0x37
    if(bNotCheckpointLoad / )
    {
        {
            DecoActivity(0, 'TurnOn');            
        }
        else
        {
            DecoActivity(0, 'TurnOff');
        }
    }
    return;
}

function PostVerifySelf()
{
    super(dnDecoration).PostVerifySelf();
    ShowerParticles = SoftParticleSystem(FindMountedActor('ShowerParticles'));
    Splatter = __NFUN_615__(class'dnHUDEffects_WaterSplatter_Medium', self);
    // End:0x7C
    if(__NFUN_340__(Splatter, none))
    {
        Splatter.MountType = 2;
        Splatter.MountMeshItem = 'Water';
        Splatter.__NFUN_635__(self);
        Splatter.StopEffect();
    }
    UpdateParticles();
    return;
}

function Used(Actor Other, Pawn EventInstigator)
{
    User = EventInstigator;
    super(dnDecoration).Used(Other, EventInstigator);
    return;
}

final function SetParticleState(SoftParticleSystem ParticleSystem, bool bEnabled)
{
    // End:0x72
    if(__NFUN_340__(ParticleSystem, none))
    {
        ParticleSystem.Enabled = bEnabled;
        // End:0x60
        if(bEnabled)
        {
            ParticleSystem.DisableTickWhenEmpty = false;
            ParticleSystem.TickStyle = ParticleSystem.default.TickStyle;            
        }
        else
        {
            ParticleSystem.DisableTickWhenEmpty = true;
        }
    }
    return;
}

final function UpdateParticles()
{
    local int i;

    SetParticleState(ShowerParticles, bTurnedOn);
    i = -- string(AdditionalShowerParticles);    
    J0x20:

    // End:0x4C [Loop If]
    if(i / 0)
    {
        SetParticleState(AdditionalShowerParticles[i], bTurnedOn);
        // [Loop Continue]
        i -= ;
    }
    return;
}

final function TurnOn()
{
    // End:0x28
    if(__NFUN_340__(User, none))
    {
        User.HandQuickAction('HandQuickAction_SlideSwitch_Left');
        User = none;
    }
    bUsable = false;
    __NFUN_607__(0.5, false, 'TurnOnDelayed');
    return;
}

function TurnOnDelayed()
{
    DecoActivity(0, 'TurnOn');
    bTurnedOn = true;
    // End:0x31
    if(__NFUN_340__(Splatter, none))
    {
        Splatter.StartEffect();
    }
    UpdateParticles();
    bUsable = true;
    return;
}

final function TurnOff()
{
    // End:0x28
    if(__NFUN_340__(User, none))
    {
        User.HandQuickAction('RoundSwitch_Down');
        User = none;
    }
    bUsable = false;
    __NFUN_607__(0.5, false, 'TurnOffDelayed');
    return;
}

function TurnOffDelayed()
{
    DecoActivity(0, 'TurnOff');
    bTurnedOn = false;
    // End:0x31
    if(__NFUN_340__(Splatter, none))
    {
        Splatter.StopEffect();
    }
    UpdateParticles();
    bUsable = true;
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(dnDecoration).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(class'dnHUDEffects_WaterSplatter_Medium');
    PrecacheIndex.__NFUN_1281__('HandQuickAction_SlideSwitch_Left');
    PrecacheIndex.__NFUN_1281__('RoundSwitch_Down');
    return;
}

defaultproperties
{
    DecoActivities_Default(0)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(TurnOn),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Sound'Settings_Bathroom_Shower.DA_Sound_Settings_Bathroom_Shower_TurnHandle',DecoActivities_Sound'Settings_Bathroom_Shower.DA_Sound_Settings_Bathroom_Shower_TurnOn',DecoActivities_Animation'Settings_Bathroom_Shower.DA_Anim_Settings_Bathroom_Shower_TurnOn','dnGame.DecoActivityDeclarations.DA_HUD_UsePhrase_TurnOff'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(1)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(TurnOff),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Sound'Settings_Bathroom_Shower.DA_Sound_Settings_Bathroom_Shower_TurnHandle','dnGame.DecoActivityDeclarations.DA_Sound_Ambient_Clear',DecoActivities_Animation'Settings_Bathroom_Shower.DA_Anim_Settings_Bathroom_Shower_TurnOff','dnGame.DecoActivityDeclarations.DA_HUD_UsePhrase_TurnOn'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(2)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=none,ActivityID=(3),ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=('dnGame.DecoActivityDeclarations.DAR_Anim_NoneAllowed'),ActivityElements=(DecoActivities_Events'Settings_Bathroom_Shower.DA_Events_Settings_Bathroom_Shower_UsedOn'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=1),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0)),(ActivityRules=('dnGame.DecoActivityDeclarations.DAR_Anim_NoneAllowed'),ActivityElements=(DecoActivities_Events'Settings_Bathroom_Shower.DA_Events_Settings_Bathroom_Shower_UsedOff'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=1),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    StartupActivities(0)='dnGame.DecoActivityDeclarations.DA_HUD_UsePhrase_TurnOn'
    HealthPrefab=0
    bForceUsePhrase=true
    bUsable=true
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='p_Decorations.Shower.Shower_Main',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=ShowerParticles,ForceEvent=None,MountMeshItem=Water,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    bCollideWorld=false
    CollisionRadius=11
    CollisionHeight=46
    DrawType=2
    Mesh='c_generic.Shower'
    SoundRadius=300
    SoundInnerRadius=150
    TransientSoundRadius=300
    TransientSoundInnerRadius=150
}