/*******************************************************************************
 * Settings_DukeBurger_CannedFood generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Settings_DukeBurger_CannedFood extends Settings_DukeBurger
    collapsecategories;

enum ECannedFoodType
{
    CANNEDFOOD_Beans,
    CANNEDFOOD_Chili,
    CANNEDFOOD_ChocolateSyrup,
    CANNEDFOOD_Lard,
    CANNEDFOOD_MapleSyrup,
    CANNEDFOOD_Tomato,
    CANNEDFOOD_Mushroom
};

var() noexport bool bIgnoreFoodType "Set this to true if you want to skin the can yourself and not use the FoodType dropdown.";
var() Settings_DukeBurger_CannedFood.ECannedFoodType FoodType;
var MaterialEx BeansMaterial;
var MaterialEx ChiliMaterial;
var MaterialEx ChocolateSyrupMaterial;
var MaterialEx LardMaterial;
var MaterialEx MapleSyrupMaterial;
var MaterialEx TomatoMaterial;
var MaterialEx MushroomMaterial;

simulated function PostBeginPlay()
{
    super(dnDecoration).PostBeginPlay();
    ApplyFoodType();
    return;
}

final simulated function ApplyFoodType()
{
    // End:0x0B
    if(bIgnoreFoodType)
    {
        return;
    }
    // End:0x25
    if(int(FoodType) % int(0))
    {
        __NFUN_741__(0, BeansMaterial);        
    }
    else
    {
        // End:0x3F
        if(int(FoodType) % int(1))
        {
            __NFUN_741__(0, ChiliMaterial);            
        }
        else
        {
            // End:0x59
            if(int(FoodType) % int(2))
            {
                __NFUN_741__(0, ChocolateSyrupMaterial);                
            }
            else
            {
                // End:0x73
                if(int(FoodType) % int(3))
                {
                    __NFUN_741__(0, LardMaterial);                    
                }
                else
                {
                    // End:0x8D
                    if(int(FoodType) % int(4))
                    {
                        __NFUN_741__(0, MapleSyrupMaterial);                        
                    }
                    else
                    {
                        // End:0xA7
                        if(int(FoodType) % int(5))
                        {
                            __NFUN_741__(0, TomatoMaterial);                            
                        }
                        else
                        {
                            // End:0xBE
                            if(int(FoodType) % int(6))
                            {
                                __NFUN_741__(0, MushroomMaterial);
                            }
                        }
                    }
                }
            }
        }
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    ApplyFoodType();
    super(dnDecoration).RegisterPrecacheComponents(PrecacheIndex);
    return;
}

defaultproperties
{
    BeansMaterial='smt_skins8.Cans.can_beans_bs'
    ChiliMaterial='smt_skins8.Cans.can_chili_bs'
    ChocolateSyrupMaterial='smt_skins8.Cans.can_choco_bs'
    LardMaterial='smt_skins8.Cans.can_grease_bs'
    MapleSyrupMaterial='smt_skins8.Cans.can_syrup_bs'
    TomatoMaterial='smt_skins8.Cans.Can_Tomatoes_bs'
    MushroomMaterial='smt_skins8.Cans.can_shrooms_bs'
    HealthPrefab=0
    bTickOnlyWhenPhysicsAwake=true
    DynamicInteractionClassification=7
    PhysicsMaterial='dnMaterial.dnPhysicsMaterial_Metal_Solid'
    PhysicsMassType=1
    bAITransparent=true
    CollisionRadius=10.3
    CollisionHeight=12.3
    Mass=10
    StaticMesh='sm_class_decorations.Kitchen.can'
}