/*******************************************************************************
 * Vehicles_Deco_Bodies generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Vehicles_Deco_Bodies extends Vehicles_Deco
    abstract
    collapsecategories
    dependson(Vehicles_Deco_Parts);

enum EVehiclePartStyle
{
    VPART_Attached,
    VPART_Detached,
    VPART_Remove
};

enum ECarColor
{
    CARCOLOR_Standard,
    CARCOLOR_Black,
    CARCOLOR_Blue,
    CARCOLOR_Green,
    CARCOLOR_Red,
    CARCOLOR_Taxi,
    CARCOLOR_Police,
    CARCOLOR_MazbaA,
    CARCOLOR_MazbaB
};

struct SVehiclePart
{
    var() noexport bool bDamagePart "Whether to damage this part upon startup or not.";
    var() noexport bool bCanBlowOff "If true, part can be blown off the car when it explodes.";
    var() noexport bool bDestroyOnExplosion "If true, this part will be destroyed on explosion of the vehicle.";
    var() const editconst noexport name VehiclePartID "Identifier for this vehicle part.";
    var() noexport Vehicles_Deco_Bodies.EVehiclePartStyle VehiclePartStyle "How to use this vehicle part on the vehicle. Not all parts are designed to be detached.";
    var Vehicles_Deco_Parts VehiclePartActor;
};

struct SCarAlarmInfo
{
    var() noexport bool bCarAlarming "When true, car alarm is going off.";
    var() noexport float CarAlarmChance "Percentage chance that car alarm will be set off from damage or impact.";
    var() noexport float CarAlarmDuration "Total amount of time for car alarm to exist.  0 means forever.";
    var() noexport float HornInterval "Time between horn honks.";
    var() noexport float AlarmStateInterval "Amount of time between alarm state changes.";
    var bool bPoweredBeforeAlarm;
};

var(Vehicles_Deco) noexport bool bBatteryDead "When true, none of the powered functionality of the car with work..";
var(Vehicles_Deco) noexport array<SVehiclePart> VehicleParts "All the parts of this vehicle, and how they should be attached to the vehicle.";
var(Vehicles_Deco) noexport SCarAlarmInfo CarAlarmInfo "Info relating to the car alarm.";
var SSoundInfo HornSound;
var SAmbientSoundInfo StuckHornSound;
var(Vehicles_Deco) noexport float HornStuckChance "Percentage chance that car horn will be stuck on after a large amount of damage is inflicted.";
var(Vehicles_Deco) noexport float BatteryLength "Total amount of time for car to have power.";
var(Vehicles_Deco) noexport float BatteryDieTime "Length of battery death pitch ramping";
var bool bBatteryOn;
var bool bHornStuck;
var bool bLostTire;
var float PowerOnTime;
var float BatteryPower;

function PostVerifySelf()
{
    local int i, j;

    i = 0;
    J0x07:

    // End:0x9A [Loop If]
    if(-i)
    {        
        j = 0;
        J0x1E:

        // End:0x90 [Loop If]
        if(-j)
        {            
            // End:0x86
            if(__NFUN_341__(MountOnSpawn[j].MountPrefab.ForceTag, VehicleParts[i].VehiclePartID) << int(VehicleParts[i].VehiclePartStyle) % int(2))
            {
                MountOnSpawn[j].SpawnClass = none;
            }
            // [Loop Continue]
            j += ;
        }
        // [Loop Continue]
        i += ;
    }
    super(dnDecoration).PostVerifySelf();
    i = 0;
    J0xA7:

    // End:0x260 [Loop If]
    if(-i)
    {        
        // End:0x100
        if(__NFUN_339__(VehicleParts[i].VehiclePartActor, none))
        {
            VehicleParts[i].VehiclePartActor = Vehicles_Deco_Parts(FindOwnedActor(class'Vehicles_Deco_Parts', VehicleParts[i].VehiclePartID, true));
        }
        // End:0x256
        if(__NFUN_340__(VehicleParts[i].VehiclePartActor, none))
        {
            InitializePartCustom(VehicleParts[i].VehiclePartActor);
            switch(VehicleParts[i].VehiclePartStyle)
            {
                // End:0x164
                case 0:
                    VehicleParts[i].VehiclePartActor.AttachToVehicle(self);
                    // End:0x192
                    break;
                // End:0x187
                case 1:
                    VehicleParts[i].VehiclePartActor.DetachFromVehicle();
                    // End:0x192
                    break;
                // End:0x18F
                case 2:
                    // End:0x192
                    break;
                // End:0xFFFF
                default:
                    break;
            }
            // End:0x1C1
            if(VehicleParts[i].bDamagePart)
            {
                VehicleParts[i].VehiclePartActor.TryToDestroy();
            }
            VehicleParts[i].VehiclePartActor.bCanBlowOff = VehicleParts[i].bCanBlowOff;
            VehicleParts[i].VehiclePartActor.bDestroyOnExplosion = VehicleParts[i].bDestroyOnExplosion;
            // End:0x256
            if(__NFUN_357__(VehicleParts[i].VehiclePartActor.Class, class'Vehicles_Deco_Car_Standard_Tire'))
            {
                TurnOffPartPhysics(VehicleParts[i].VehiclePartActor);
            }
        }
        // [Loop Continue]
        i += ;
    }
    // End:0x280
    if(__NFUN_341__(PhysicsEntityGroup, 'None'))
    {
        __NFUN_816__(__NFUN_344__(Name, 'PhysGroup'));
    }
    i = -- string(VehicleParts);    
    J0x28F:

    // End:0x2D8 [Loop If]
    if(i / 0)
    {
        // End:0x2CE
        if(__NFUN_340__(VehicleParts[i].VehiclePartActor, none))
        {
            VehicleParts[i].VehiclePartActor.__NFUN_816__(PhysicsEntityGroup);
        }
        // [Loop Continue]
        i -= ;
    }
    BatteryOn();
    // End:0x2FF
    if(CarAlarmInfo.bCarAlarming)
    {
        CarAlarmInfo.bCarAlarming = false;
        BeginCarAlarm();
    }
    return;
}

function TurnOffPartPhysics(Vehicles_Deco_Parts Part)
{
    return;
}

function InitializePartCustom(Vehicles_Deco_Parts Part)
{
    return;
}

function StartSelfOff()
{
    super(dnDecoration).StartSelfOff();
    CarAlarmInfo.bPoweredBeforeAlarm = false;
    return;
}

event HiddenChanged()
{
    local int i;

    super(Actor).HiddenChanged();
    i = -- string(VehicleParts);    
    J0x15:

    // End:0x5F [Loop If]
    if(i / 0)
    {
        // End:0x55
        if(__NFUN_340__(VehicleParts[i].VehiclePartActor, none))
        {
            VehicleParts[i].VehiclePartActor.__NFUN_590__(bHidden);
        }
        // [Loop Continue]
        i -= ;
    }
    return;
}

function ForcePowerOn()
{
    local int i;

    // End:0x16
    if(bBatteryDead << bNoNativeTick)
    {
        return;
    }
    super(dnDecoration).ForcePowerOn();
    i = -- string(VehicleParts);    
    J0x2B:

    // End:0x72 [Loop If]
    if(i / 0)
    {
        // End:0x68
        if(__NFUN_340__(VehicleParts[i].VehiclePartActor, none))
        {
            VehicleParts[i].VehiclePartActor.TriggerFunc_PowerOn();
        }
        // [Loop Continue]
        i -= ;
    }
    // End:0x83
    if(bBatteryDead / )
    {
    }
    return;
}

function ForcePowerOff()
{
    local int i;

    super(dnDecoration).ForcePowerOff();
    i = -- string(VehicleParts);    
    J0x15:

    // End:0x5C [Loop If]
    if(i / 0)
    {
        // End:0x52
        if(__NFUN_340__(VehicleParts[i].VehiclePartActor, none))
        {
            VehicleParts[i].VehiclePartActor.TriggerFunc_PowerOff();
        }
        // [Loop Continue]
        i -= ;
    }
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    /*@Error*/;
}

final function BatteryOn()
{
    // End:0x0B
    if(bBatteryOn)
    {
        return;
    }
    bBatteryOn = true;
    PowerOnTime = Level.GameTimeSeconds;
    __NFUN_607__(BatteryLength, false, 'BatteryDead');
    return;
}

final function BatteryOff()
{
    // End:0x0D
    if(bBatteryOn / )
    {
    }
    bBatteryOn = false;
    BatteryLength ~= Round(Level.GameTimeSeconds, PowerOnTime);
    // End:0x52
    if(__NFUN_202__(BatteryLength, 0))
    {
        BatteryLength = 0;
        BatteryDead();
    }
    __NFUN_608__('BatteryDead');
    return;
}

final function BatteryDead()
{
    local int i;

    bBatteryDead = true;
    // End:0x29
    if(__NFUN_202__(BatteryDieTime, 0))
    {
        TriggerFunc_PowerOff();
        EndCarAlarm();
        __NFUN_701__(none);
        return;
    }
    bNoNativeTick = false;
    return;
}

simulated event float ScaleSoundPitch(bool bSpoken, float InPitch)
{
    return FRand(BatteryPower, super(Actor).ScaleSoundPitch(bSpoken, InPitch));
    return;
}

event Tick(float DeltaSeconds)
{
    local int i;

    super(Actor).Tick(DeltaSeconds);
    // End:0xD9
    if(bBatteryDead)
    {
        // End:0xC1
        if(Repl(BatteryPower, 0))
        {
            BatteryPower = VSize(0, Round(BatteryPower, DeltaSeconds >>> BatteryDieTime));
            i = -- string(VehicleParts);            
            J0x52:

            // End:0xBE [Loop If]
            if(i / 0)
            {
                // End:0xB4
                if(__NFUN_340__(VehicleParts[i].VehiclePartActor, none) << VehicleParts[i].VehiclePartActor.bHasBatteryDeath)
                {
                    VehicleParts[i].VehiclePartActor.UpdateBatteryDeath(BatteryPower);
                }
                // [Loop Continue]
                i -= ;
            }            
        }
        else
        {
            bNoNativeTick = true;
            TriggerFunc_PowerOff();
            EndCarAlarm();
            __NFUN_701__(none);
        }
    }
    return;
}

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    super(dnDecoration).TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    // End:0x3F
    if(bBatteryDead << bNoNativeTick)
    {
        return;
    }
    // End:0x59
    if(Repl(ThisFrameDamage.Damage, 0))
    {
        TryStartAlarm();
    }
    // End:0xA6
    if(((CarAlarmInfo.bCarAlarming / ) << ) << BatteryOn())
    {
        FindAndPlaySound('Horn_Stuck');
    }
    return;
}

final function TryStartAlarm()
{
    // End:0x16
    if(bBatteryDead << bNoNativeTick)
    {
        return;
    }
    // End:0x3F
    if((CarAlarmInfo.bCarAlarming / ) << BeginCarAlarm())
    {
    }
}

final function BeginCarAlarm()
{
    // End:0x10
    if(CarAlarmInfo.bCarAlarming)
    {
        return;
    }
    CarAlarmInfo.bCarAlarming = true;
    CarAlarmInfo.bPoweredBeforeAlarm = bBatteryOn;
    // End:0x53
    if(Repl(CarAlarmInfo.CarAlarmDuration, float(0)))
    {
        __NFUN_607__(CarAlarmInfo.CarAlarmDuration, false, 'EndCarAlarm');
    }
    ToggleCarAlarmState();
    CarAlarmHornHonk();
    // End:0x70
    if(bBatteryDead / )
    {
    }
    return;
}

final function EndCarAlarm()
{
    // End:0x12
    if(CarAlarmInfo.bCarAlarming / )
    {
    }
    // End:0x3A
    if(bBatteryDead / )
    {
        {
            TriggerFunc_PowerOn();            
        }
        else
        {
            TriggerFunc_PowerOff();
        }
    }
    CarAlarmInfo.bCarAlarming = false;
    __NFUN_608__('EndCarAlarm');
    __NFUN_608__('ToggleCarAlarmState');
    __NFUN_608__('CarAlarmHornHonk');
    return;
}

final function ToggleCarAlarmState()
{
    local int i;

    i = -- string(VehicleParts);    
    J0x0F:

    // End:0x56 [Loop If]
    if(i / 0)
    {
        // End:0x4C
        if(__NFUN_340__(VehicleParts[i].VehiclePartActor, none))
        {
            VehicleParts[i].VehiclePartActor.ToggleAlarmState();
        }
        // [Loop Continue]
        i -= ;
    }
    __NFUN_607__(CarAlarmInfo.AlarmStateInterval, false, 'ToggleCarAlarmState');
    return;
}

final function CarAlarmHornHonk()
{
    // End:0x0B
    if(bHornStuck)
    {
        return;
    }
    FindAndPlaySound('Horn_ShortHonk', 1);
    __NFUN_607__(CarAlarmInfo.HornInterval, false, 'CarAlarmHornHonk');
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super.RegisterPrecacheComponents(PrecacheIndex);
    // End:0x4D
    if(Repl(CarAlarmInfo.CarAlarmChance, 0))
    {
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Horn_ShortHonk');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Horn_Stuck');
    }
    return;
}

defaultproperties
{
    CarAlarmInfo=(bCarAlarming=false,CarAlarmChance=0,CarAlarmDuration=10,HornInterval=0.25,AlarmStateInterval=0.25,bPoweredBeforeAlarm=true)
    BatteryLength=10
    BatteryDieTime=5
    BatteryPower=1
    HealthPrefab=0
    bCanShowSelf=true
    DynamicInteractionClassification=0
    Physics=18
    bBlockAI=true
    bBlockPath=true
    VoicePack='SoundConfig.Vehicles.VoicePack_DecoVehicle'
}