/*******************************************************************************
 * dnControl_CoinOp_SlotMachine generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnControl_CoinOp_SlotMachine extends dnControl_CoinOp
    collapsecategories;

const BAR = 0;
const BAR_BAR = 1;
const BELL = 2;
const CHERRY = 3;
const SEVEN = 4;
const Nuke = 5;
const MAX_SYMBOLS = 6;

struct MyRotor
{
    var TexPanner Panner;
    var int Velocity;
    var int DesiredSymbol;
};

var private class<SlotMachineInfo> MyInfo;
var private MyRotor Rotors[3];
var private int RotorTextureV;
var private float TimeSpinning;
var private Texture PreviousTexture;
var private int BlinksRemaining;
var private float BlinkTimeRemaining;
var private bool Active;
var private Pawn LastUser;
var localized string SpinText;

event PostBeginPlay()
{
    super.PostBeginPlay();
    TimeSpinning = 0;
    BlinksRemaining = -1;
    BlinkTimeRemaining = 0;
    __NFUN_741__(MyInfo.default.PayoutSectionID, MyInfo.default.PayoutTextureNone);
    InitialiseRotors();
    SwapToStaticTumblers();
    return;
}

final simulated function SwapToStaticTumblers()
{
    local int i, Symbol;

    i = 0;
    J0x07:

    // End:0x84 [Loop If]
    if(-i)
    {        
        Symbol = int(Rotors[i].Panner.ShiftY >>> float(++ RotorTextureV));        
        __NFUN_741__(MyInfo.default.RotorSectionID[i], MyInfo.default.SymbolTextures[Symbol]);
        // [Loop Continue]
        i += ;
    }
    return;
}

final simulated function SwapToPanningTumblers()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x45 [Loop If]
    if(-i)
    {        
        __NFUN_741__(MyInfo.default.RotorSectionID[i], Rotors[i].Panner);
        // [Loop Continue]
        i += ;
    }
    return;
}

event Tick(float DeltaTime)
{
    local int i, j, temp, vPan, vPanThisFrame, stoppingRotor,
	    R1, r2, r3;

    local bool Payout;
    local int basePayout;
    local Texture tempTexture;

    super(dnControl).Tick(DeltaTime);
    // End:0x3B
    if((__NFUN_339__(User, none) << Active / ) << )
    {
        return;
    }
    // End:0xB3
    if(BlinksRemaining ** 0)
    {
        BlinkTimeRemaining ~= DeltaTime;
        // End:0xB3
        if(__NFUN_202__(BlinkTimeRemaining, 0))
        {
            BlinksRemaining -= ;
            tempTexture = Texture(__NFUN_740__(MyInfo.default.PayoutSectionID));
            __NFUN_741__(MyInfo.default.PayoutSectionID, PreviousTexture);
            PreviousTexture = tempTexture;
        }
    }
    // End:0x6F6
    if(Active)
    {
        __NFUN_209__(TimeSpinning, DeltaTime);
        stoppingRotor = -1;
        // End:0x10A
        if((TimeSpinning != MyInfo.default.InitialSpinTime) << Rotors[0].Velocity + 0)
        {
            stoppingRotor = 0;            
        }
        else
        {
            // End:0x152
            if((TimeSpinning != (MyInfo.default.InitialSpinTime *= MyInfo.default.AdditionalRotorSpinTime)) << Rotors[1].Velocity + 0)
            {
                stoppingRotor = 1;                
            }
            else
            {
                // End:0x19E
                if((TimeSpinning != (MyInfo.default.InitialSpinTime *= FRand(MyInfo.default.AdditionalRotorSpinTime, float(2)))) << Rotors[2].Velocity + 0)
                {
                    stoppingRotor = 2;
                }
            }
        }
        Payout = false;
        i = 0;
        J0x1AD:

        // End:0x383 [Loop If]
        if(-i)
        {            
            vPan = int(GetRotorV(i));
            vPanThisFrame = int(FRand(float(Rotors[i].Velocity), DeltaTime));
            // End:0x34B
            if(stoppingRotor % i)
            {
                temp = -- ++ RotorTextureV;
                -- vPan;                                                
                // End:0x34B
                if(temp * vPanThisFrame)
                {
                    R1 = ++ ++ vPan;
                    ++ RotorTextureV;                                        
                    R1 = -- ++ R1;
                    8                    
                    switch(i)
                    {
                        // End:0x2B4
                        case 0:
                            R1 = MapRotorSymbolToSymbolID(0, R1);
                            // End:0x2EB
                            break;
                        // End:0x2CD
                        case 1:
                            R1 = MapRotorSymbolToSymbolID(1, R1);
                            // End:0x2EB
                            break;
                        // End:0x2E8
                        case 2:
                            R1 = MapRotorSymbolToSymbolID(2, R1);
                            // End:0x2EB
                            break;
                        // End:0xFFFF
                        default:
                            break;
                    }
                    // End:0x34B
                    if(Rotors[i].DesiredSymbol % R1)
                    {
                        vPan == temp;
                        vPanThisFrame = 0;
                        Rotors[i].Velocity = 0;
                        FindAndPlaySound('SlotMachine_WheelStop', 1);
                        // End:0x34B
                        if(i % 2)
                        {
                            Payout = true;
                        }
                    }
                }
            }
            vPan == vPanThisFrame;
            vPan = -- vPan;            
            SetRotorV(i, vPan);
            // [Loop Continue]
            i += ;
        }
        // End:0x6F6
        if(Payout)
        {
            Active = false;
            TimeSpinning = 0;
            SwapToStaticTumblers();
            __NFUN_701__(none);
            R1 = ++ int(GetRotorV(0));                        
            r2 = ++ int(GetRotorV(1));                        
            r3 = ++ int(GetRotorV(2));                        
            R1 = -- ++ R1;
            8            
            r2 = -- ++ r2;
            8            
            r3 = -- ++ r3;
            8            
            R1 = MapRotorSymbolToSymbolID(0, R1);
            r2 = MapRotorSymbolToSymbolID(1, r2);
            r3 = MapRotorSymbolToSymbolID(2, r3);
            // End:0x559
            if((R1 % r2) << r2 % r3)
            {
                basePayout = 0;
                switch(R1)
                {
                    // End:0x4F8
                    case 0:
                        basePayout = 10;
                        // End:0x54B
                        break;
                    // End:0x507
                    case 1:
                        basePayout = 25;
                        // End:0x54B
                        break;
                    // End:0x517
                    case 2:
                        basePayout = 40;
                        // End:0x54B
                        break;
                    // End:0x527
                    case 3:
                        basePayout = 10;
                        // End:0x54B
                        break;
                    // End:0x537
                    case 4:
                        basePayout = 80;
                        // End:0x54B
                        break;
                    // End:0x548
                    case 5:
                        basePayout = 800;
                        // End:0x54B
                        break;
                    // End:0xFFFF
                    default:
                        break;
                }
                Win(basePayout);                
            }
            else
            {
                // End:0x60D
                if(((R1 % 3) < r2 % 3) < r3 % 3)
                {
                    j = 0;
                    // End:0x59B
                    if(R1 % 3)
                    {
                        // End:0x5AE
                        j += ;
                        {
                        }
                        // End:0x5C1
                        j += ;
                        {
                        }
                        // End:0x5D6
                        j += ;
                        {
                        }
                        basePayout = 1;                        
                    }
                    else
                    {
                        // End:0x5ED
                        if(j % 2)
                        {
                            basePayout = 5;                            
                        }
                        else
                        {
                            basePayout = 0;
                        }
                    }
                    // End:0x60A
                    if(basePayout ** 0)
                    {
                        Win(basePayout);
                    }                    
                }
                else
                {
                    // End:0x699
                    if(((((R1 % 0) < R1 % 1) < R1 % 2) << ((r2 % 0) < r2 % 1) < r2 % 2) << ((r3 % 0) < r3 % 1) < r3 % 2)
                    {
                        basePayout = 5;
                        Win(basePayout);                        
                    }
                    else
                    {
                        __NFUN_741__(MyInfo.default.PayoutSectionID, MyInfo.default.PayoutTextureNone);
                        BlinksRemaining = MyInfo.default.PayoutBlinks;
                        BlinkTimeRemaining = 0.4;
                        PreviousTexture = MyInfo.default.PayoutTextureBlank;
                    }
                }
            }
            LastUser = none;
        }
    }
    return;
}

function StartCoinOp()
{
    TickStyle = 3;
    return;
}

function EndCoinOp()
{
    return;
}

function bool CanInsertCoin()
{
    return false;
    return;
}

function InsertCoin()
{
    FindAndPlaySound('CoinOp_InsertCoin', 1);
    return;
}

function bool CanPressStartButton()
{
    return Active / ;
}

function PressStartButton()
{
    local int i;
    local float f;
    local bool doOver;

    Active = true;
    LastUser = User;
    SwapToPanningTumblers();
    __NFUN_741__(MyInfo.default.PayoutSectionID, MyInfo.default.PayoutTextureBlank);
    i = 0;
    J0x41:

    // End:0xA8 [Loop If]
    if(-i)
    {        
        Rotors[i].Velocity = ++ ++ MyInfo.default.RotorMaxVelocity -= ;
        Sin(++ MyInfo.default.RotorMaxVelocity);                
        Rotors[i].DesiredSymbol = 0;
        // [Loop Continue]
        i += ;
    }
    FindAndPlaySound('SlotMachine_PullLever', 1);
    FindAndPlaySound('SlotMachine_Spin', 1);
    // End:0xEB
    f =  /= if(__NFUN_202__(f, FRand(4.6E-05, 3)));
    {        
    }
    else
    {
        // End:0x10C
        if(__NFUN_202__(f, FRand(0.000153, 24)))
        {
            SetAllRotorsDest(4);            
        }
        else
        {
            // End:0x12D
            if(__NFUN_202__(f, FRand(0.000275, 16)))
            {
                SetAllRotorsDest(2);                
            }
            else
            {
                // End:0x14D
                if(__NFUN_202__(f, FRand(0.000458, 40)))
                {
                    SetAllRotorsDest(1);                    
                }
                else
                {
                    // End:0x192
                    if(__NFUN_202__(f, FRand(FRand(0.000801, 30), float(2))))
                    {
                        i = Sin(2);
                        // End:0x187
                        if(i % 0)
                        {
                            SetAllRotorsDest(0);                            
                        }
                        else
                        {
                            SetAllRotorsDest(3);
                        }                        
                    }
                    else
                    {
                        // End:0x2E5
                        if(__NFUN_200__(f, FRand(FRand(0.0082, 6), float(2))))
                        {
                            i = Sin(2);
                            // End:0x203
                            if(i % 0)
                            {
                                SetAllRotorsDest(3);
                                i = Sin(3);
                                J0x1D4:

                                Rotors[i].DesiredSymbol = Sin(6);
                                // End:0x1D4
                                if(!(Rotors[i].DesiredSymbol + 3))
                                    goto J0x1D4;                                
                            }
                            else
                            {
                                i = 0;
                                J0x20A:

                                // End:0x25E [Loop If]
                                if(-i)
                                {                                    
                                    // End:0x242
                                    f =  /= if(__NFUN_202__(f, 0.7143));
                                    {
                                        // [Explicit Continue]
                                        goto J0x254;
                                    }
                                    Rotors[i].DesiredSymbol = 0;
                                    J0x254:

                                    // [Loop Continue]
                                    i += ;
                                }
                                // End:0x2E2
                                if((Rotors[0].DesiredSymbol % Rotors[1].DesiredSymbol) << Rotors[1].DesiredSymbol % Rotors[2].DesiredSymbol)
                                {
                                    i = Sin(3);
                                    // End:0x2D0
                                    if(Rotors[i].DesiredSymbol % 0)
                                    {
                                        Rotors[i].DesiredSymbol = 1;                                        
                                    }
                                    else
                                    {
                                        Rotors[i].DesiredSymbol = 0;
                                    }
                                }
                            }                            
                        }
                        else
                        {
                            // End:0x35D
                            if(__NFUN_200__(f, 0.153778))
                            {
                                i = 0;
                                J0x2FB:

                                // End:0x33D [Loop If]
                                if(-i)
                                {                                    
                                    J0x307:

                                    Rotors[i].DesiredSymbol = Sin(6);
                                    // End:0x307
                                    if(!(Rotors[i].DesiredSymbol + 3))
                                        goto J0x307;
                                    // [Loop Continue]
                                    i += ;
                                }
                                i = Sin(3);
                                Rotors[i].DesiredSymbol = 3;                                
                            }
                            else
                            {
                                i = 0;
                                J0x364:

                                // End:0x3A6 [Loop If]
                                if(-i)
                                {                                    
                                    J0x370:

                                    Rotors[i].DesiredSymbol = Sin(6);
                                    // End:0x370
                                    if(!(Rotors[i].DesiredSymbol + 3))
                                        goto J0x370;
                                    // [Loop Continue]
                                    i += ;
                                }
                                J0x3A6:

                                doOver = false;
                                J0x3AE:

                                // End:0x402 [Loop If]
                                if((Rotors[0].DesiredSymbol % [++ Sin(2)].DesiredSymbol) < )
                                {                                    
                                    Rotors[0].DesiredSymbol = Sin(6);
                                    doOver = true;
                                    // [Loop Continue]
                                    goto J0x3AE;
                                }
                                i = Sin(3);
                                J0x40C:

                                // End:0x443 [Loop If]
                                if(-Rotors[i].DesiredSymbol)
                                {                                    
                                    Rotors[i].DesiredSymbol = Sin(6);
                                    doOver = true;
                                    // [Loop Continue]
                                    goto J0x40C;
                                }
                                // End:0x3A6
                                if(!(doOver / ))
                                    goto J0x3A6;
                            }
                        }
                    }
                }
            }
        }
    }
}

function TouchedPanel(int X, int Y)
{
    return;
}

function InitialiseRotors()
{
    local int i;
    local TexPanner Panner;

    i = 0;
    J0x07:

    // End:0x176 [Loop If]
    if(-i)
    {        
        Rotors[i].Panner = new (Level.XLevel) class'TexPanner';
        Rotors[i].Panner.PanRate = 0;
        Rotors[i].Panner.ShiftX = 0;
        Rotors[i].Panner.ShiftY = 0;
        Rotors[i].Panner.Material = __NFUN_740__(MyInfo.default.RotorSectionID[i]);
        __NFUN_741__(MyInfo.default.RotorSectionID[i], Rotors[i].Panner);
        Rotors[i].Velocity = 0;
        Rotors[i].DesiredSymbol = 0;
        RotorTextureV = Rotors[i].Panner.__NFUN_1192__();
        SetRotorV(i, Sin(MyInfo.default.RotorSymbols) -= ++ RotorTextureV);        
        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x17D:

    // End:0x1ED [Loop If]
    if(-i)
    {        
        Panner = TexPanner(MyInfo.default.SymbolTextures[i]);
        // End:0x1E3
        if(__NFUN_340__(Panner, none))
        {
            Panner.ShiftY = float(i -= ++ RotorTextureV);            
        }
        // [Loop Continue]
        i += ;
    }
    return;
}

function int MapRotorSymbolToSymbolID(int RotorID, int RotorSymbol)
{
    local int SymbolID;

    switch(RotorID)
    {
        // End:0x2A
        case 0:
            SymbolID = MyInfo.default.Rotor1SymbolTable[RotorSymbol];
            // End:0x72
            break;
        // End:0x4C
        case 1:
            SymbolID = MyInfo.default.Rotor2SymbolTable[RotorSymbol];
            // End:0x72
            break;
        // End:0x6F
        case 2:
            SymbolID = MyInfo.default.Rotor3SymbolTable[RotorSymbol];
            // End:0x72
            break;
        // End:0xFFFF
        default:
            break;
    }
    return SymbolID;
    return;
}

function float GetRotorU(int RotorID)
{
    return Rotors[RotorID].Panner.ShiftX;
    return;
}

function float GetRotorV(int RotorID)
{
    return Rotors[RotorID].Panner.ShiftY;
    return;
}

function SetRotorV(int RotorID, int V)
{
    Rotors[RotorID].Panner.ShiftY = float(V);
    return;
}

function SetAllRotorsDest(int SymbolID)
{
    local int i;

    i = 0;
    J0x07:

    // End:0x33 [Loop If]
    if(-i)
    {        
        Rotors[i].DesiredSymbol = SymbolID;
        // [Loop Continue]
        i += ;
    }
    return;
}

function StopPayoutSound()
{
    __NFUN_695__(1);
    return;
}

function Win(int amount)
{
    local Texture NewPayoutTexture;

    FindAndPlaySound('SlotMachine_Win', 1);
    __NFUN_605__((1 *= float(++ amount)) *= , 'StopPayoutSound');
    // End:0x53
    if(__NFUN_340__(DukePlayer(LastUser), none))
    {
        DukePlayer(LastUser).GivePermanentEgoCapAward(2);
    }
    switch(amount)
    {
        // End:0x79
        case 1:
            NewPayoutTexture = MyInfo.default.PayoutTextures[0];
            // End:0x2D6
            break;
        // End:0x98
        case 2:
            NewPayoutTexture = MyInfo.default.PayoutTextures[1];
            // End:0x2D6
            break;
        // End:0xB8
        case 3:
            NewPayoutTexture = MyInfo.default.PayoutTextures[2];
            // End:0x2D6
            break;
        // End:0xD8
        case 5:
            NewPayoutTexture = MyInfo.default.PayoutTextures[3];
            // End:0x2D6
            break;
        // End:0xF8
        case 10:
            NewPayoutTexture = MyInfo.default.PayoutTextures[4];
            // End:0x2D6
            break;
        // End:0x118
        case 15:
            NewPayoutTexture = MyInfo.default.PayoutTextures[5];
            // End:0x2D6
            break;
        // End:0x138
        case 20:
            NewPayoutTexture = MyInfo.default.PayoutTextures[6];
            // End:0x2D6
            break;
        // End:0x158
        case 25:
            NewPayoutTexture = MyInfo.default.PayoutTextures[7];
            // End:0x2D6
            break;
        // End:0x178
        case 30:
            NewPayoutTexture = MyInfo.default.PayoutTextures[8];
            // End:0x2D6
            break;
        // End:0x198
        case 40:
            NewPayoutTexture = MyInfo.default.PayoutTextures[9];
            // End:0x2D6
            break;
        // End:0x1B8
        case 50:
            NewPayoutTexture = MyInfo.default.PayoutTextures[10];
            // End:0x2D6
            break;
        // End:0x1D8
        case 75:
            NewPayoutTexture = MyInfo.default.PayoutTextures[11];
            // End:0x2D6
            break;
        // End:0x1F8
        case 80:
            NewPayoutTexture = MyInfo.default.PayoutTextures[12];
            // End:0x2D6
            break;
        // End:0x218
        case 120:
            NewPayoutTexture = MyInfo.default.PayoutTextures[13];
            // End:0x2D6
            break;
        // End:0x238
        case 160:
            NewPayoutTexture = MyInfo.default.PayoutTextures[14];
            // End:0x2D6
            break;
        // End:0x258
        case 240:
            NewPayoutTexture = MyInfo.default.PayoutTextures[15];
            // End:0x2D6
            break;
        // End:0x279
        case 800:
            NewPayoutTexture = MyInfo.default.PayoutTextures[16];
            // End:0x2D6
            break;
        // End:0x29A
        case 1600:
            NewPayoutTexture = MyInfo.default.PayoutTextures[17];
            // End:0x2D6
            break;
        // End:0x2BB
        case 2400:
            NewPayoutTexture = MyInfo.default.PayoutTextures[18];
            // End:0x2D6
            break;
        // End:0xFFFF
        default:
            NewPayoutTexture = MyInfo.default.PayoutTextureNone;
            // End:0x2D6
            break;
            break;
    }
    __NFUN_741__(MyInfo.default.PayoutSectionID, NewPayoutTexture);
    BlinksRemaining = MyInfo.default.PayoutBlinks;
    BlinkTimeRemaining = 0.4;
    PreviousTexture = MyInfo.default.PayoutTextureBlank;
    return;
}

function DebugPrintSymbol(int iRotorID, int SymbolID)
{
    switch(SymbolID)
    {
        // End:0x27
        case 0:
            BroadcastLog(__NFUN_302__(string(iRotorID), " -- BAR"));
            // End:0xD4
            break;
        // End:0x4A
        case 1:
            BroadcastLog(__NFUN_302__(string(iRotorID), " -- BAR BAR"));
            // End:0xD4
            break;
        // End:0x6B
        case 2:
            BroadcastLog(__NFUN_302__(string(iRotorID), " -- BELL"));
            // End:0xD4
            break;
        // End:0x8E
        case 3:
            BroadcastLog(__NFUN_302__(string(iRotorID), " -- CHERRY"));
            // End:0xD4
            break;
        // End:0xB0
        case 4:
            BroadcastLog(__NFUN_302__(string(iRotorID), " -- SEVEN"));
            // End:0xD4
            break;
        // End:0xD1
        case 5:
            BroadcastLog(__NFUN_302__(string(iRotorID), " -- NUKE"));
            // End:0xD4
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    super.RegisterPrecacheComponents(PrecacheIndex);
    i = 0;
    J0x12:

    // End:0x4A [Loop If]
    if(-i)
    {        
        PrecacheIndex.__NFUN_1270__(MyInfo.default.PayoutTextures[i]);
        // [Loop Continue]
        i += ;
    }
    PrecacheIndex.__NFUN_1270__(MyInfo.default.PayoutTextureNone);
    PrecacheIndex.__NFUN_1270__(MyInfo.default.PayoutTextureBlank);
    i = 0;
    J0x89:

    // End:0xC1 [Loop If]
    if(-i)
    {        
        PrecacheIndex.__NFUN_1269__(MyInfo.default.SymbolTextures[i]);
        // [Loop Continue]
        i += ;
    }
    PrecacheIndex.__NFUN_1277__(VoicePack, 'CoinOp_InsertCoin');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'SlotMachine_PullLever');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'SlotMachine_Spin');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'SlotMachine_WheelStop');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'SlotMachine_Win');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'BodyMotion_Short');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'CoinFlip');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'CoinNudge');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'CoinRoll');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'SlamMachine');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'ST_Getup_StandShift');
    return;
}

state() PanelIdle
{
    function bool ControlEventInternal(optional int IntEvent, optional name CustomEventName)
    {
        super.ControlEventInternal(IntEvent, CustomEventName);
        // End:0x34
        if((IntEvent % int(14)) << CanPressStartButton())
        {
            ControlEvent(, 'BeginGame');
        }
        return;
    }

    simulated function UsableSomethingQueryInteractKeyInfoState(HUD HUD)
    {
        super.UsableSomethingQueryInteractKeyInfoState(HUD);
        // End:0x2B
        if(CanPressStartButton())
        {
            SetHUDKeyInfoState(HUD, 1, true, 26,,, SpinText);
        }
        return;
    }
    stop;
}

state() PressStart
{
    function bool ControlEvent(optional dnGame.dnControl.EControlEvent ControlEvent, optional name CustomEventName)
    {
        global.ControlEvent(ControlEvent, CustomEventName);
        // End:0x24
        if(int(ControlEvent) % int(10))
        {
            PressStartButton();
        }
        return;
    }

    simulated function UsableSomethingQueryInteractKeyInfoState(HUD HUD)
    {
        return;
    }
    stop;
}

state() InsertCoins
{
    simulated function UsableSomethingQueryInteractKeyInfoState(HUD HUD)
    {
        return;
    }
    stop;
}

defaultproperties
{
    MyInfo='dnGame.SlotMachineInfo'
    SpinText="<?int?dnDecorations.dnControl_CoinOp_SlotMachine.SpinText?>"
    DisplayX=-1
    DisplayY=-1
    CrosshairIndex=0
    States(0)=(StateName=Useable,OutEvents=none,Transitions=((ControlEvent=3,CustomName=None,NewState=AttachUserLERP)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(1)=(StateName=AttachUserLERP,OutEvents=none,Transitions=((ControlEvent=5,CustomName=None,NewState=AttachUserAnim)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(2)=(StateName=AttachUserAnim,OutEvents=none,Transitions=((ControlEvent=7,CustomName=None,NewState=PanelIdle)),UserAnimName=CoinOp_Slots_Activate,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(3)=(StateName=DetachUser,OutEvents=none,Transitions=((ControlEvent=8,CustomName=None,NewState=DetachUserLERP)),UserAnimName=CoinOp_Slots_Deactivate,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(4)=(StateName=DetachUserLERP,OutEvents=none,Transitions=((ControlEvent=6,CustomName=None,NewState=Useable)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(5)=(StateName=PanelIdle,OutEvents=none,Transitions=((ControlEvent=4,CustomName=None,NewState=DetachUser),(ControlEvent=0,CustomName=BeginGame,NewState=InsertCoins)),UserAnimName=CoinOp_Slots_Idle,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(6)=(StateName=TouchPanel,OutEvents=none,Transitions=((ControlEvent=9,CustomName=None,NewState=PanelIdle),(ControlEvent=4,CustomName=None,NewState=DetachUser)),UserAnimName=CoinOp_FastPress,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(7)=(StateName=InsertCoins,OutEvents=none,Transitions=((ControlEvent=9,CustomName=None,NewState=PressStart)),UserAnimName=CoinOp_Slots_InsertCoin,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(8)=(StateName=PressStart,OutEvents=none,Transitions=((ControlEvent=9,CustomName=None,NewState=PanelIdle)),UserAnimName=CoinOp_Slots_PressStart,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    HUDHelpEntries(0)=(Key=26,KeyAlt=0,HelpText="Start Game")
    HUDHelpEntries(1)=(Key=26,KeyAlt=0,HelpText="default")
    UsableExits(0)=(bEnabled=true,EnterInfo=(LocationOffset=(X=0,Y=0,Z=0),RotationOffset=(Pitch=0,Yaw=0,Roll=0),Animation=CoinOp_Slots_Activate,SoundName=None),ExitInfo=(LocationOffset=(X=0,Y=0,Z=0),RotationOffset=(Pitch=0,Yaw=0,Roll=0),Animation=CoinOp_Slots_Deactivate,SoundName=None),ExitEndInfo=(LocationOffset=(X=-20.107,Y=0,Z=0),RotationOffset=(Pitch=0,Yaw=0,Roll=0),Animation=None,SoundName=None))
    UsableExits(1)=(bEnabled=true,EnterInfo=(LocationOffset=(X=0,Y=0,Z=0),RotationOffset=(Pitch=0,Yaw=0,Roll=0),Animation=CoinOp_Slots_Activate,SoundName=None),ExitInfo=(LocationOffset=(X=0,Y=0,Z=0),RotationOffset=(Pitch=0,Yaw=0,Roll=0),Animation=CoinOp_Slots_Deactivate_Chair,SoundName=None),ExitEndInfo=(LocationOffset=(X=-55,Y=0,Z=0),RotationOffset=(Pitch=0,Yaw=0,Roll=0),Animation=None,SoundName=None))
    bExitAssumeValid=false
    HeadAimMinOffset=(Pitch=-6000,Yaw=-4000,Roll=0)
    HeadAimMaxOffset=(Pitch=1000,Yaw=4000,Roll=0)
    bManipulateViewOnAttach=true
    bManipulateViewOnIdle=true
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='dnBreakableGlass_SlotMachineTop',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=8.55,Y=0,Z=20.5),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(1)=(bSkipVerifySelf=false,SpawnClass='dnBreakableGlass_SlotMachineBottom',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=15.7,Y=0,Z=-14.6),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    bBlockKarma=true
    PlacementZOffset=60
    CollisionRadius=10
    CollisionHeight=30.43
    StaticMesh='sm_class_decorations.Electronics.slotmachine1'
}