/*******************************************************************************
 * dnControl_Turret_SuperTurret generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnControl_Turret_SuperTurret extends dnControl_Turret
    collapsecategories;

const kSuperTurretExit_Left = 0;
const kSuperTurretExit_Right = 1;
const kSuperTurretExit_Kaboom = 2;

struct SSuperTurretExitAnims
{
    var() anim name EnterName;
    var() anim name ExitName;
};

struct STurretProjectileHitEffect
{
    var() array<name> HitTags;
    var() array< class<dnFriendFX_Spawners> > ParticleSpawners;
};

var() noexport bool bUseLowIdle "If true, user will have to trigger SE_PowerUp to bring user into final idle.";
var(dnTurret) noexport int ShotDistance "Max distance shot will travel";
var(dnTurret) noexport name EjectPlayerTag "Trigger this to eject the player";
var(dnTurret) noexport float DirectDamage "Damage from a direct single shot.";
var(dnTurret) noexport float RadialDamage "Max damage from an indirect single shot.";
var(dnTurret) noexport float RadialDamageRadius "Max radius for indirect damage.";
var(dnTurret) noexport float ExhaustTime "Seconds for exhaust to be enabled after a shot";
var(dnTurret) noexport float LightTime "Seconds to wait before turning off the muzzle light";
var(dnTurret) class<Actor> ExplosionClass;
var(dnTurret) class<TraceDamageType> TraceDamageType;
var(dnTurret) noexport int MaxTracePenetrationCount "maximum number of times the trace can penetrate things.";
var(dnTurretEvents) deprecated name SE_Kaboom;
var(dnTurretEvents) noexport deprecated name SE_Damaged "Trigger this to cause the damage effect on the user of the turret.  Does nothing if there is no user.";
var(dnTurretEvents) noexport deprecated name SE_PowerUp "Trigger this to cause the player to play the power up animation for the turret.";
var(dnTurretEffects) array<STurretProjectileHitEffect> ProjectileHitEffects;
var bool bFireLeft;
var array<SSuperTurretExitAnims> MyExitAnimNames;
var class<dnFriendFX_Spawners> FireEffectClass;
var SoftParticleSystem FireFX[6];
var SoftParticleSystem FireEffect;
var LightEx MuzzleLight;
var LightEx HeatLight[3];
var RenderActor MuzzleFlash;
var dnFriendFX_Spawners TracerEffect;
var DecoActivities_Spawn TracerInfo[2];
var Rotator ProjectileRotation;

simulated function Rotator GetProjectileRotation()
{
    return ProjectileRotation;
    return;
}

simulated event Actor GetIKActor(name LimbID)
{
    return self;
    return;
}

simulated event PreBeginPlay()
{
    __NFUN_718__('Kaboom', SE_Kaboom);
    __NFUN_718__('ScriptedDamage', SE_Damaged);
    __NFUN_718__('PowerUp', SE_PowerUp);
    super.PreBeginPlay();
    return;
}

simulated event PostBeginPlay()
{
    local int i;

    super(dnUsableSomething).PostBeginPlay();
    i = 0;
    J0x0D:

    // End:0x7B [Loop If]
    if(-i)
    {        
        FireFX[i] = SoftParticleSystem(FindMountedActor(__NFUN_343__(__NFUN_302__("ExhaustFX", string(i)))));
        // End:0x71
        if(__NFUN_340__(FireFX[i], none))
        {
            FireFX[i].DestroyOnDismount = false;
        }
        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x82:

    // End:0x162 [Loop If]
    if(-i)
    {        
        HeatLight[i] = LightEx(FindMountedActor(__NFUN_343__(__NFUN_302__("HeatLight", string(i)))));
        // End:0x158
        if(__NFUN_340__(HeatLight[i], none))
        {
            HeatLight[i].DestroyOnDismount = false;
            HeatLight[i].bCastStencilShadows = false;
            HeatLight[i].LightColor = NewColorBytes(0, 0, 0, 255);
            HeatLight[i].LightRadius = 96;
            HeatLight[i].LightIntensity = 3;
        }
        // [Loop Continue]
        i += ;
    }
    DisableExhaust();
    MuzzleLight = LightEx(FindMountedActor('MuzzleLight'));
    // End:0x1A2
    if(__NFUN_340__(MuzzleLight, none))
    {
        MuzzleLight.DestroyOnDismount = false;
        LightOff();
    }
    MuzzleFlash = RenderActor(FindMountedActor('MuzzleFlash'));
    // End:0x1E4
    if(__NFUN_340__(MuzzleFlash, none))
    {
        MuzzleFlash.__NFUN_590__(true);
        MuzzleFlash.DestroyOnDismount = false;
    }
    TracerEffect = dnFriendFX_Spawners(FindStaticActor(class'SuperTurret_Tracer_Spawner'));
    // End:0x22D
    if(int(Level.Game.Difficulty) % 3)
    {
        DirectDamage = __NFUN_207__(DirectDamage, 1.5);
    }
    return;
}

simulated function EnableExhaust()
{
    local int i;

    return;
}

simulated function DisableExhaust()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x35 [Loop If]
    if(-i)
    {        
        FireFX[i].Enabled = false;
        // [Loop Continue]
        i += ;
    }
    return;
}

simulated function LightOff()
{
    MuzzleLight.LightStyle = 0;
    return;
}

function TriggerFunc_Kaboom()
{
    local int stateIndex;

    // End:0x0E
    if(__NFUN_339__(User, none))
    {
        return;
    }
    bManipulateViewOnDetach = false;
    FindStateIndex('DetachUser', stateIndex);
    UsableExits[0].bEnabled = false;
    UsableExits[1].bEnabled = false;
    UsableExits[2].bEnabled = true;
    bExitAssumeValid = true;
    // End:0x87
    if(__NFUN_340__(dnControlRemapperEx_Turret(InternalControlRemapper), none))
    {
        dnControlRemapperEx_Turret(InternalControlRemapper).CRViewAlphaFadeTime = 0.13;
    }
    DetachAlphaRate = 5;
    DetachPawn(true);
    CriticalDamage();
    return;
}

function TriggerFunc_ScriptedDamage()
{
    // End:0x0E
    if(__NFUN_339__(User, none))
    {
        return;
    }
    ControlEvent(, 'ScriptedDamage');
    return;
}

function TriggerFunc_PowerUp()
{
    // End:0x0E
    if(__NFUN_339__(User, none))
    {
        return;
    }
    ControlEvent(, 'PowerUp');
    return;
}

animevent simulated function AnimEvent_TurretActivate(optional EventInfo AnimEventInfo)
{
    FindAndPlaySound('SuperTurret_Activate', 1);
    return;
}

animevent simulated function AnimEvent_TurretHitGround(optional EventInfo AnimEventInfo)
{
    DecoActivity(0, 'SuperTurret_HitGround');
    return;
}

simulated event float GetBaseDamage(Actor Victim, optional Pawn Instigator, optional class<DamageType> DamageType, optional Vector HitDirection, optional Vector HitLocation, optional name BoneName, optional Vector SourceTraceOrigin)
{
    return DirectDamage;
    return;
}

simulated function FireShot()
{
    local Vector TraceStart, TraceEnd, TraceDir, MuzzleLoc;
    local Rotator MuzzleRot;
    local int i, Idx;
    local Actor HitActor;
    local STraceHitResult Result;

    super.FireShot();
    FindAndPlaySound('SuperTurret_Fire', 1);
    EnableExhaust();
    __NFUN_607__(ExhaustTime, false, 'DisableExhaust');
    MuzzleLight.LightStyle = MuzzleLight.default.LightStyle;
    __NFUN_607__(LightTime, false, 'LightOff');
    // End:0x84
    if(__NFUN_339__(FireEffect, none) << __NFUN_340__(FireEffectClass, none))
    {
        FireEffect = SoftParticleSystem(FindStaticActor(FireEffectClass));
    }
    // End:0x141
    if(__NFUN_340__(FireEffect, none))
    {
        FireEffect.__NFUN_645__(MeshInstance.CanSee('mount_beam', true, false));
        FireEffect.__NFUN_652__(MeshInstance.__NFUN_534__('mount_beam', true, false));
        FireEffect.SystemSizeScale = FRand(FireEffect.default.SystemSizeScale, DrawScale) >>> default.DrawScale;
        // End:0x12B
        if(FireEffect.bIsFriendSpawner)
        {
            dnFriendFX_Spawners(FireEffect).ExecuteEffect(true);            
        }
        else
        {
            FireEffect.Trigger(self, User);
        }
    }
    MuzzleLoc = MeshInstance.CanSee('mount_beam', true, false);
    MuzzleRot = MeshInstance.__NFUN_534__('mount_beam', true);
    // End:0x1E9
    if(__NFUN_340__(PlayerUser, none))
    {
        MuzzleRot.Pitch = PlayerUser.CalcedViewRotation.Pitch;
        TraceDir = Vector(MuzzleRot);
        TraceStart = Locs(PlayerUser.CalcedViewLocation, Caps(FMin(__NFUN_239__(MuzzleLoc, PlayerUser.CalcedViewLocation), TraceDir), TraceDir));        
    }
    else
    {
        TraceStart = MuzzleLoc;
    }
    TraceEnd = Locs(TraceStart, Caps(float(ShotDistance), Vector(MuzzleRot)));
    // End:0x2AF
    if(__NFUN_340__(GetTraceTarget(TraceStart, TraceEnd, Result), none))
    {
        ProjectileRotation = Rotator(__NFUN_239__(Result.Location, MuzzleLoc) % );
        ProjectileRotation.Pitch = Exp(ProjectileRotation.Pitch, -1000, 1000);
        ProjectileRotation.Yaw = Exp(ProjectileRotation.Yaw, -1000, 1000);
        ProjectileRotation = __NFUN_269__(ProjectileRotation, MuzzleRot);        
    }
    else
    {
        ProjectileRotation = MuzzleRot;
    }
    DecoActivity(0, 'SuperTurret_FireProjectile');
    // End:0x3CE
    if(__NFUN_340__(TracerEffect, none) << __NFUN_628__('mount_beam', MuzzleLoc, MuzzleRot))
    {
        TracerEffect.__NFUN_652__(ProjectileRotation);
        Idx = int(bFireLeft);
        // End:0x3CE
        if(__NFUN_340__(TracerInfo[Idx], none))
        {
            i = -- string(TracerInfo[Idx].MountedSpawns);            
            J0x33A:

            // End:0x3CE [Loop If]
            if(i / 0)
            {
                TracerEffect.__NFUN_645__(Locs(MuzzleLoc, __NFUN_263__(TracerInfo[Idx].MountedSpawns[i].MountPrefab.MountOrigin, MuzzleRot)));
                TracerEffect.SystemSizeScale = FRand(TracerEffect.default.SystemSizeScale, DrawScale) >>> default.DrawScale;
                TracerEffect.ExecuteEffect(true);
                // [Loop Continue]
                i -= ;
            }
        }
    }
    bFireLeft = bFireLeft / ;
}

simulated event TraceFireMaterialHit(class<DamageType> TraceDamageType, Actor HitActor, Vector HitLocation, Vector HitNormal, class<Material> HitMaterial, bool bNoDecal)
{
    super(Actor).TraceFireMaterialHit(TraceDamageType, HitActor, HitLocation, HitNormal, HitMaterial, bNoDecal);
    Instigator = User;
    HurtRadius(RadialDamage, HitLocation, RadialDamageRadius, 0, class'CannonDamage', Location);
    __NFUN_615__(ExplosionClass, self,, HitLocation, Rotator(HitNormal));
    return;
}

simulated function bool OverrideExplosionEffect(Projectile Proj, Vector HitLocation, optional Vector HitNormal, optional Actor HitActor)
{
    local int i, j, K;
    local dnFriendFX_Spawners Spawner;

    // End:0x159
    if(__NFUN_340__(HitActor, none))
    {
        i = 0;
        J0x13:

        // End:0x159 [Loop If]
        if(-i)
        {            
            j = 0;
            J0x2A:

            // End:0x14F [Loop If]
            if(-j)
            {                
                // End:0x145
                if(__NFUN_342__(ProjectileHitEffects[i].HitTags[j], 'None') << __NFUN_341__(ProjectileHitEffects[i].HitTags[j], HitActor.Tag))
                {
                    K = 0;
                    J0x9A:

                    // End:0x143 [Loop If]
                    if(-K)
                    {                        
                        // End:0xD5
                        if(__NFUN_339__(ProjectileHitEffects[i].ParticleSpawners[K], none))
                        {
                            // [Explicit Continue]
                            goto J0x139;
                        }
                        Spawner = FindFriendSpawner(ProjectileHitEffects[i].ParticleSpawners[K]);
                        // End:0x139
                        if(__NFUN_340__(Spawner, none))
                        {
                            Spawner.__NFUN_645__(HitLocation);
                            Spawner.__NFUN_652__(Rotator(HitNormal));
                            Spawner.ExecuteEffect(true);
                        }
                        J0x139:

                        // [Loop Continue]
                        K += ;
                    }
                    return true;
                }
                // [Loop Continue]
                j += ;
            }
            // [Loop Continue]
            i += ;
        }
    }
    return super.OverrideExplosionEffect(Proj, HitLocation, HitNormal, HitActor);
    return;
}

simulated function bool CanFire()
{
    return bFiringEnabled << bOverheated / ;
}

simulated function StartOverheatedState()
{
    super.StartOverheatedState();
    FindAndPlaySound('MachinegunTurret_Overheat', 1);
    return;
}

simulated function MaybeFireShot()
{
    return;
}

simulated function AnimCallback_UserAttached()
{
    super(dnControl).AnimCallback_UserAttached();
    // End:0x1E
    if(bUseLowIdle)
    {
        ControlEvent(, 'IdleLow');        
    }
    else
    {
        ControlEvent(, 'idle');
    }
    return;
}

event EnumerateRawAnimationSequences(out array<SAnimationEnumeration> References)
{
    local int i;

    super(dnControl).EnumerateRawAnimationSequences(References);
    i = 0;
    J0x12:

    // End:0xA2 [Loop If]
    if(-i)
    {        
        // End:0x5D
        if(__NFUN_342__(MyExitAnimNames[i].EnterName, 'None'))
        {
            AddAnimationEnumeration(References, MyExitAnimNames[i].EnterName, Mesh);
        }
        // End:0x98
        if(__NFUN_342__(MyExitAnimNames[i].ExitName, 'None'))
        {
            AddAnimationEnumeration(References, MyExitAnimNames[i].ExitName, Mesh);
        }
        // [Loop Continue]
        i += ;
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i, j;

    super.RegisterPrecacheComponents(PrecacheIndex);
    i = -- string(ProjectileHitEffects);    
    J0x1A:

    // End:0x81 [Loop If]
    if(i / 0)
    {
        j = -- string(ProjectileHitEffects[i].ParticleSpawners);        
        J0x3F:

        // End:0x77 [Loop If]
        if(j / 0)
        {
            PrecacheIndex.__NFUN_1266__(ProjectileHitEffects[i].ParticleSpawners[j]);
            // [Loop Continue]
            j -= ;
        }
        // [Loop Continue]
        i -= ;
    }
    i = -- string(MyExitAnimNames);    
    J0x90:

    // End:0xE9 [Loop If]
    if(i / 0)
    {
        PrecacheIndex.__NFUN_1284__(Mesh, MyExitAnimNames[i].EnterName);
        PrecacheIndex.__NFUN_1284__(Mesh, MyExitAnimNames[i].ExitName);
        // [Loop Continue]
        i -= ;
    }
    PrecacheIndex.__NFUN_1266__(FireEffectClass);
    PrecacheIndex.__NFUN_1266__(class'SuperTurret_Tracer_Spawner');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'SuperTurret_Activate');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'SuperTurret_Fire');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'MachinegunTurret_Overheat');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'SuperTurret_NoFire');
    return;
}

state() FireDown
{
    simulated event BeginState()
    {
        super.BeginState();
        MaybeFireShot();
        return;
    }

    simulated function AnimCallback_UserAnimEnd()
    {
        global.AnimCallback_UserAnimEnd();
        MaybeFireShot();
        return;
    }

    simulated function MaybeFireShot()
    {
        // End:0x12
        if(CanFire())
        {
            FireShot();            
        }
        else
        {
            ControlEvent(, 'CantFire');
        }
        return;
    }
    stop;
}

state() FiringStop
{    stop;
}

state() ScriptedDamage
{    stop;
}

state() PowerUp
{    stop;
}

state() AttachUserAnim
{
    function BeginState()
    {
        super(Object).BeginState();
        __NFUN_577__('RenderProperties', 'Power', 1,, 5);
        return;
    }

    function PlayMyAnim()
    {
        // End:0x32
        if(string(UsableExits) + 1)
        {
            States[CurrentStateIndex].MyAnim.Animation = MyExitAnimNames[ActiveUsableExit].EnterName;
        }
        global.PlayMyAnim();
        return;
    }

    function EndState()
    {
        super.EndState();
        DecoActivity(0, 'SuperTurret_Engage');
        return;
    }
    stop;
}

state() DetachUser
{
    function BeginState()
    {
        super.BeginState();
        DecoActivity(0, 'SuperTurret_Disengage');
        __NFUN_577__('RenderProperties', 'Power', 0,, 5);
        return;
    }

    function PlayMyAnim()
    {
        // End:0x32
        if(string(UsableExits) + 1)
        {
            States[CurrentStateIndex].MyAnim.Animation = MyExitAnimNames[ActiveUsableExit].ExitName;
        }
        global.PlayMyAnim();
        return;
    }
    stop;
}

state() AttachUserAnimInstant
{
    function EndState()
    {
        super(Object).EndState();
        __NFUN_577__('RenderProperties', 'Power', 1,, 5);
        DecoActivity(0, 'SuperTurret_Engage');
        AttachUserAnimEndState();
        return;
    }
    stop;
}

state() IdleLow extends idle
{    stop;
}

defaultproperties
{
    ShotDistance=50000
    DirectDamage=50
    RadialDamage=50
    RadialDamageRadius=100
    ExhaustTime=0.5
    LightTime=0.1
    ExplosionClass='dnParticles.dnTurret_Cannon'
    MyExitAnimNames(0)=(EnterName=a_superturret_activateleft,ExitName=a_superturret_deactivateleft)
    MyExitAnimNames(1)=(EnterName=a_superturret_activateright,ExitName=a_superturret_deactivateright)
    MyExitAnimNames(2)=(EnterName=None,ExitName=a_superturret_boom)
    FireEffectClass='p_Weapons.SuperTurret_MuzzleFlash.SuperTurret_MuzzleFlash_Spawner'
    begin obje[0]ct name=DA_Spawn_SuperTurret_RocketA class=DecoActivities_Spawn
        MountedSpawns(0)=(bSkipVerifySelf=false,SpawnClass='dnGame.dnRocket_SuperTurret',SpawnChance=0,MountPrefab=(bDontActuallyMount=true,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_beam,MountOrigin=(X=25,Y=-25,Z=-25),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
        MountedSpawns(1)=(bSkipVerifySelf=false,SpawnClass='dnGame.dnRocket_SuperTurret',SpawnChance=0,MountPrefab=(bDontActuallyMount=true,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_beam,MountOrigin=(X=25,Y=25,Z=25),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    object end
    // Reference: DecoActivities_Spawn'dnControl_Turret_SuperTurret.DA_Spawn_SuperTurret_RocketA'
    TracerInfo=DA_Spawn_SuperTurret_RocketA
    begin object name=DA_Spawn_SuperTurret_RocketB class=DecoActivities_Spawn
        MountedSpawns(0)=(bSkipVerifySelf=false,SpawnClass='dnGame.dnRocket_SuperTurret',SpawnChance=0,MountPrefab=(bDontActuallyMount=true,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_beam,MountOrigin=(X=25,Y=-25,Z=25),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
        MountedSpawns(1)=(bSkipVerifySelf=false,SpawnClass='dnGame.dnRocket_SuperTurret',SpawnChance=0,MountPrefab=(bDontActuallyMount=true,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_beam,MountOrigin=(X=25,Y=25,Z=-25),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    object end
    // Reference: DecoActivities_Spawn'dnControl_Turret_SuperTurret.DA_Spawn_SuperTurret_RocketB'
    TracerInfo=DA_Spawn_SuperTurret_RocketB
    MinPitch=-4096
    MaxPitch=8192
    MinYaw=-16384
    MaxYaw=16384
    ShotRate=0.7
    PitchAimRate=8192
    YawAimRate=8192
    RotatePitchAdjust=-4096
    RotationSoundName=SuperTurret_Rotation
    RotationSoundModSideways=(Min=0,Max=0)
    RotationSoundModUpDown=(Min=0,Max=0)
    FireHeightBoneName=mount_beam
    Crosshair='dt_hud.crosshairs.SuperTurret_Crosshair_fb'
    FireViewShake=(bNoLerp=false,bToggleSign=true,Style=3,Function=0,FalloffActor=none,FalloffDistance=0,ShakeDuration=0.5,ShakeFrequency=0.05,ShakeMagnitude=1000,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=SuperTurret_Fire_Shake)
    FireRumble=(RumbleName=SuperTurret_Rumble,RumbleDuration=0.19,RumbleLeftMagnitude=0.55,RumbleRightMagnitude=0.18,FalloffActor=none,FalloffDistance=0)
    OverheatMaxTime=5
    CoolDownTime=3
    CoolDownLevel=50
    HeatPerShot=1.5
    OverheatNoFireSound=SuperTurret_NoFire
    OverheatWarnTimePCT=0.8
    OverheatSmokeClass='p_Weapons.MG42_MuzzleFlash.MG42_Overheat_Main'
    OverheatMountName=mount_beam
    OverheatScale=10
    CrosshairIndex=15
    States(0)=(StateName=Useable,OutEvents=none,Transitions=((ControlEvent=3,CustomName=None,NewState=AttachUserLERP)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(1)=(StateName=AttachUserLERP,OutEvents=none,Transitions=((ControlEvent=5,CustomName=None,NewState=AttachUserAnim)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(2)=(StateName=AttachUserAnim,OutEvents=none,Transitions=((ControlEvent=0,CustomName=idle,NewState=idle),(ControlEvent=0,CustomName=IdleLow,NewState=IdleLow)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(3)=(StateName=DetachUser,OutEvents=none,Transitions=((ControlEvent=8,CustomName=None,NewState=DetachUserLERP)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(4)=(StateName=DetachUserLERP,OutEvents=none,Transitions=((ControlEvent=6,CustomName=None,NewState=Useable)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(5)=(StateName=idle,OutEvents=none,Transitions=((ControlEvent=15,CustomName=None,NewState=FireDown),(ControlEvent=4,CustomName=None,NewState=DetachUser),(ControlEvent=0,CustomName=ScriptedDamage,NewState=ScriptedDamage),(ControlEvent=0,CustomName=Overheated,NewState=Overheated)),UserAnimName=SuperTurret_Idle,UserSoundName=None,MyAnim=(Flags=(bLoop=true,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=a_superturret_idle,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(6)=(StateName=FireDown,OutEvents=none,Transitions=((ControlEvent=16,CustomName=None,NewState=FiringStop),(ControlEvent=0,CustomName=CantFire,NewState=idle),(ControlEvent=0,CustomName=Overheated,NewState=FiringStop),(ControlEvent=0,CustomName=ScriptedDamage,NewState=ScriptedDamage)),UserAnimName=SuperTurret_Fire,UserSoundName=None,MyAnim=(Flags=(bLoop=true,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=a_superturret_fire,Channel=0,Rate=2,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(7)=(StateName=Overheated,OutEvents=none,Transitions=((ControlEvent=4,CustomName=None,NewState=DetachUser),(ControlEvent=0,CustomName=CooledDown,NewState=idle),(ControlEvent=0,CustomName=ScriptedDamage,NewState=ScriptedDamage)),UserAnimName=SuperTurret_Idle,UserSoundName=None,MyAnim=(Flags=(bLoop=true,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=a_superturret_idle,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(8)=(StateName=IdleLow,OutEvents=none,Transitions=((ControlEvent=0,CustomName=PowerUp,NewState=PowerUp)),UserAnimName=SuperTurret_IdleLow,UserSoundName=None,MyAnim=(Flags=(bLoop=true,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=a_superturret_idle,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(9)=(StateName=FiringStop,OutEvents=none,Transitions=((ControlEvent=9,CustomName=None,NewState=idle),(ControlEvent=0,CustomName=ScriptedDamage,NewState=ScriptedDamage)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(10)=(StateName=ScriptedDamage,OutEvents=none,Transitions=((ControlEvent=9,CustomName=None,NewState=idle)),UserAnimName=SuperTurret_Damaged,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(11)=(StateName=PowerUp,OutEvents=none,Transitions=((ControlEvent=9,CustomName=None,NewState=idle)),UserAnimName=SuperTurret_PowerUp,UserSoundName=None,MyAnim=(Flags=(bLoop=true,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=a_superturret_idle,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(12)=(StateName=AttachUserAnimInstant,OutEvents=none,Transitions=((ControlEvent=0,CustomName=idle,NewState=idle),(ControlEvent=0,CustomName=IdleLow,NewState=IdleLow)),UserAnimName=SuperTurret_InstantAttach,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=a_superturret_mounted,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    DamageTriggerRadius=40
    DamageTriggerHeight=50
    ForceAttachStateName=AttachUserAnimInstant
    UsableExits(0)=(bEnabled=true,EnterInfo=(LocationOffset=(X=-46.28,Y=-52.075,Z=-92.66),RotationOffset=(Pitch=0,Yaw=16384,Roll=0),Animation=SuperTurret_ActivateLeft,SoundName=SuperTurret_ActivateLeft),ExitInfo=(LocationOffset=(X=-44.9,Y=-52.1,Z=-90.96),RotationOffset=(Pitch=0,Yaw=32768,Roll=0),Animation=SuperTurret_DeActivateLeft,SoundName=SuperTurret_DeActivateLeft),ExitEndInfo=(LocationOffset=(X=0,Y=0,Z=0),RotationOffset=(Pitch=0,Yaw=0,Roll=0),Animation=None,SoundName=None))
    UsableExits(1)=(bEnabled=true,EnterInfo=(LocationOffset=(X=-46.28,Y=47.158,Z=-92.66),RotationOffset=(Pitch=0,Yaw=-16384,Roll=0),Animation=SuperTurret_ActivateRight,SoundName=SuperTurret_ActivateRight),ExitInfo=(LocationOffset=(X=-47.165,Y=44.867,Z=-90.96),RotationOffset=(Pitch=0,Yaw=32768,Roll=0),Animation=SuperTurret_DeActivateRight,SoundName=SuperTurret_DeActivateRight),ExitEndInfo=(LocationOffset=(X=0,Y=0,Z=0),RotationOffset=(Pitch=0,Yaw=0,Roll=0),Animation=None,SoundName=None))
    UsableExits(2)=(bEnabled=false,EnterInfo=(LocationOffset=(X=0,Y=0,Z=0),RotationOffset=(Pitch=0,Yaw=0,Roll=0),Animation=None,SoundName=None),ExitInfo=(LocationOffset=(X=-83.192,Y=-45.585,Z=-63.879),RotationOffset=(Pitch=0,Yaw=0,Roll=0),Animation=SuperTurret_Eject,SoundName=SuperTurret_Eject),ExitEndInfo=(LocationOffset=(X=0,Y=0,Z=0),RotationOffset=(Pitch=0,Yaw=0,Roll=0),Animation=None,SoundName=None))
    UserMountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=true,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=true,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_duke,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0)
    bDisableCrosshairHUD=true
    AttachUserSoundName=BodyMotion_Medium
    DetachUserSoundName=None
    DecoActivities_Default(0)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(SuperTurret_HitGround),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Sound'dnControl_Turret_SuperTurret.DA_Sound_dnControl_Turret_SuperTurret_HitGround'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(1)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(SuperTurret_Disengage),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=('dnGame.DecoActivityDeclarations.DA_Sound_Ambient_Clear',DecoActivities_Sound'dnControl_Turret_SuperTurret.DA_Sound_dnControl_Turret_SuperTurret_Disengage'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(2)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(SuperTurret_FireProjectile),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Spawn'dnControl_Turret_SuperTurret.DA_Spawn_SuperTurret_RocketA'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0)),(ActivityRules=none,ActivityElements=(DecoActivities_Spawn'dnControl_Turret_SuperTurret.DA_Spawn_SuperTurret_RocketB'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DestroyedActivities(0)=none
    DestroyedActivities(1)='dnGame.DecoActivityDeclarations.DA_Sound_Ambient_Clear'
    DestroyedActivities(2)='dnGame.DecoActivityDeclarations.DA_Interact_bUsable_Disable'
    DestroyedActivities(3)='dnGame.DecoActivityDeclarations.DA_HUD_bDrawUsePhrase_Disable'
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='dnParticles.dnSuperTurret_Smoke_Idle',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=ExhaustFX0,ForceEvent=None,MountMeshItem=mount_exhaustports_left01,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(1)=(bSkipVerifySelf=false,SpawnClass='dnParticles.dnSuperTurret_Smoke_Idle',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=ExhaustFX1,ForceEvent=None,MountMeshItem=mount_exhaustports_left02,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(2)=(bSkipVerifySelf=false,SpawnClass='dnParticles.dnSuperTurret_Smoke_Idle',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=ExhaustFX2,ForceEvent=None,MountMeshItem=mount_exhaustports_left03,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(3)=(bSkipVerifySelf=false,SpawnClass='dnParticles.dnSuperTurret_Smoke_Idle',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=ExhaustFX3,ForceEvent=None,MountMeshItem=mount_exhaustports_right01,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(4)=(bSkipVerifySelf=false,SpawnClass='dnParticles.dnSuperTurret_Smoke_Idle',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=ExhaustFX4,ForceEvent=None,MountMeshItem=mount_exhaustports_right02,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(5)=(bSkipVerifySelf=false,SpawnClass='dnParticles.dnSuperTurret_Smoke_Idle',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=ExhaustFX5,ForceEvent=None,MountMeshItem=mount_exhaustports_right03,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(6)=(bSkipVerifySelf=false,SpawnClass='Weapon_LightEx_SuperTurret',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=MuzzleLight,ForceEvent=None,MountMeshItem=mount_beam,MountOrigin=(X=-30,Y=0,Z=80),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(7)=(bSkipVerifySelf=false,SpawnClass='Engine.LightEx',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=HeatLight0,ForceEvent=None,MountMeshItem=mount_beam,MountOrigin=(X=0.242065,Y=-36.00316,Z=0.202637),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(8)=(bSkipVerifySelf=false,SpawnClass='Engine.LightEx',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=HeatLight1,ForceEvent=None,MountMeshItem=mount_beam,MountOrigin=(X=0.242065,Y=-0.003162,Z=40.20264),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(9)=(bSkipVerifySelf=false,SpawnClass='Engine.LightEx',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=HeatLight2,ForceEvent=None,MountMeshItem=mount_beam,MountOrigin=(X=0.242065,Y=35.99684,Z=0.202637),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(10)=(bSkipVerifySelf=false,SpawnClass='dnGame.TriggerDamageControlUser',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_duke,MountOrigin=(X=0,Y=0,Z=50),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    bBlockPlayers=true
    CollisionRadius=100
    CollisionHeight=75
    Mesh='c_dnWeapon.superturret'
    ActorColorList(0)=(ActorColor=(R=0,G=0,B=0,A=0),ActorColor_LightEx=none,ActorColor_LightExScale=(X=0,Y=0,Z=0),id=Generic0)
    ActorColorList(1)=(ActorColor=(R=0,G=0,B=0,A=0),ActorColor_LightEx=none,ActorColor_LightExScale=(X=0,Y=0,Z=0),id=Generic1)
    SoundRadius=768
    SoundInnerRadius=384
    TransientSoundRadius=768
    TransientSoundInnerRadius=384
    ScaleModifierGroupList(0)=(Modifiers=none,Identifier=RenderProperties,DefaultModValue=0,LastValue=0,NoUpdate=false)
}