/*******************************************************************************
 * dnControl_Whiteboard generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnControl_Whiteboard extends dnControl_DrawableSurface
    collapsecategories;

const NUM_DRAWING_TOOLS = 5;
const ERASER_INDEX = 5;

var() noexport float HorizontalRate "Rate in units per second that user can move left and right.";
var() noexport float MaxHorizontal "Max distance player can move horizontally.. length of the drawing surface.";
var() noexport int BaseXOffset "X Offset when user is entirely to the right of the board.";
var() noexport float XOffsetScalar "Value is multiplied by CurrentHorizontalVal/MaxHorizontal and then added to BaseXOffset to determine XDrawOffset.";
var() noexport float AmbientDuration "Amount of time to wait before turning off the ambient drawing sound.";
var() noexport float PreDetachDuration "Amount of time it takes to 're-center' before detaching.";
var() noexport array<MaterialEx> DrawingToolMaterials "Materials to apply to the drawing tools.. order matters!.";
var array<dnControlHelper_DrawingTool_Whiteboard> DrawingTools;
var bool bQuickEraser;
var float CurrentHorizontalVal;
var float AmbientEndTime;
var int LastTool;
var float PreDetachStartTime;
var float PreDetachInputX;
var float PreDetachInputY;
var float PreDetachHoriz;
var float PreDetachVert;
var() Texture MyCopySource;
var float BoneAlpha;
var float BoneXAlpha;
var float ThisXAdjust;
var float ThisYAdjust;
var bool bAchievementAlreadyUnlocked;

function PostBeginPlay()
{
    local int i;

    string(DrawingTools) = 5;
    DrawingTools[0] = dnControlHelper_DrawingTool_Whiteboard(FindMountedActor('BLACK_PEN'));
    DrawingTools[1] = dnControlHelper_DrawingTool_Whiteboard(FindMountedActor('RED_PEN'));
    DrawingTools[2] = dnControlHelper_DrawingTool_Whiteboard(FindMountedActor('BLUE_PEN'));
    DrawingTools[3] = dnControlHelper_DrawingTool_Whiteboard(FindMountedActor('GREEN_PEN'));
    DrawingTools[4] = dnControlHelper_DrawingTool_Whiteboard(FindMountedActor('YELLOW_PEN'));
    DrawingTools[5] = dnControlHelper_DrawingTool_Whiteboard(FindMountedActor('WHITE_ERASER'));
    DrawingTools[5].CopySource = MyCopySource;
    i = 0;
    J0xBC:

    // End:0x1F6 [Loop If]
    if(-i)
    {        
        DrawingTools[i].bGrabbable = false;
        DrawingTools[i].bCanExistOutOfWorld = true;
        DrawingTools[i].__NFUN_621__(false, false, false, false, false);
        DrawingTools[i].OldMount.bSurviveDismount = true;
        DrawingTools[i].OldMount.MountOrigin = DrawingTools[i].MountOrigin;
        DrawingTools[i].OldMount.MountAngles = DrawingTools[i].MountAngles;
        // End:0x1D4
        if(-i << )
        {            
            DrawingTools[i].__NFUN_741__(0, DrawingToolMaterials[i]);
        }
        DrawingTools[i].TickStyle = 0;
        // [Loop Continue]
        i += ;
    }
    super(dnUsableSomething).PostBeginPlay();
    XDrawOffset = float(BaseXOffset) *= FRand(XOffsetScalar, CurrentHorizontalVal >>> MaxHorizontal);
    return;
}

simulated event Actor GetIKActor(name LimbID)
{
    return User;
    return;
}

simulated event PostUserAnimTick()
{
    local Vector BonePos, DesiredBonePos;
    local Rotator BoneRot, DesiredBoneRot;

    super(Decoration).PostUserAnimTick();
    // End:0x176
    if(Level.bPaused / )
    {
        {
            __NFUN_209__(BoneAlpha, FRand(4, Level.TimeDeltaSeconds));
            // End:0x86
            if(Repl(BoneAlpha, 1))
            {
                BoneAlpha = 1;
            }
            // End:0xCE
            if(__NFUN_341__(__NFUN_399__(), 'Drawing'))
            {
                __NFUN_209__(BoneXAlpha, FRand(8, Level.TimeDeltaSeconds));
                // End:0xCB
                if(Repl(BoneXAlpha, 1))
                {
                    BoneXAlpha = 1;
                }                
            }
            else
            {
                BoneXAlpha ~= FRand(8, Level.TimeDeltaSeconds);
                // End:0x105
                if(__NFUN_200__(BoneXAlpha, 0))
                {
                    BoneXAlpha = 0;
                }
            }            
        }
        else
        {
            BoneAlpha ~= FRand(4, Level.TimeDeltaSeconds);
            // End:0x13F
            if(__NFUN_200__(BoneAlpha, 0))
            {
                BoneAlpha = 0;
            }
            BoneXAlpha ~= FRand(8, Level.TimeDeltaSeconds);
            // End:0x176
            if(__NFUN_200__(BoneXAlpha, 0))
            {
                BoneXAlpha = 0;
            }
        }
    }
    // End:0x3ED
    if(Repl(BoneAlpha, 0))
    {
        BonePos = User.MeshInstance.CanSee('mount_holster_hip_right', true);
        BoneRot = User.MeshInstance.__NFUN_534__('mount_holster_hip_right', true);
        DesiredBonePos.X = VSizeSq(BoneXAlpha, DrawingTools[CurrentColor].BoneXRange.Min, DrawingTools[CurrentColor].BoneXRange.Max);
        DesiredBonePos.Y = VSizeSq(FRand(0.5, MouseInputX *= 1), DrawingTools[CurrentColor].BoneYRange.Min, DrawingTools[CurrentColor].BoneYRange.Max);
        DesiredBonePos.Z = VSizeSq(FRand(0.5, MouseInputY *= 1), DrawingTools[CurrentColor].BoneZRange.Min, DrawingTools[CurrentColor].BoneZRange.Max);
        FClamp(DesiredBonePos, User.DrawScale);
        DesiredBonePos = Locs(User.Location, __NFUN_263__(DesiredBonePos, User.Rotation));
        DesiredBoneRot = __NFUN_269__(DrawingTools[CurrentColor].BoneRot, User.Rotation);
        BonePos.X = GetAxes(BoneAlpha, BonePos.X, DesiredBonePos.X);
        BonePos.Y = GetAxes(BoneAlpha, BonePos.Y, DesiredBonePos.Y);
        BonePos.Z = GetAxes(BoneAlpha, BonePos.Z, DesiredBonePos.Z);
        User.MeshInstance.CanSeeByPoints('mount_holster_hip_right', BonePos, true);
        User.MeshInstance.__NFUN_538__('mount_holster_hip_right', BoneAlpha * BoneRot);
        true        
    }
    return;
}

function ChangeTool()
{
    local int MaxIndex;

    // End:0x1F
    CurrentColor += ;
    {
        MaxIndex = string(DrawingTools);        
    }
    else
    {
        MaxIndex = 5;
    }
    // End:0x4A
    if((CurrentColor / MaxIndex) < -CurrentColor)
    {        
        CurrentColor = 0;
    }
    DrawingTool = DrawingTools[CurrentColor];
    HUDHelpEntries[0].HelpText = DrawingTools[CurrentColor].HelpTextMessage;
    HUDHelpEntries[2].HelpText = DrawingTools[CurrentColor].HelpTextMessage2;
    User.RefreshHelpText(self);
    return;
}

simulated function InputHook_ViewRotationAdjust_NoteAdjustment(float XAdjust, float YAdjust)
{
    super(dnUsableSomething).InputHook_ViewRotationAdjust_NoteAdjustment(XAdjust, YAdjust);
    ThisXAdjust = XAdjust;
    ThisYAdjust = YAdjust;
    return;
}

function InputHook(out float aForward, out float aLookUp, out float aTurn, out float aStrafe, optional float DeltaTime)
{
    local float newForward, newStrafe;

    super(Actor).InputHook(aForward, aLookUp, aTurn, aStrafe, DeltaTime);
    // End:0x3D
    if(__NFUN_339__(User, none) < __NFUN_341__(__NFUN_399__(), 'PreDetach'))
    {
        return;
    }
    // End:0xC1
    if(__NFUN_204__(aStrafe, 0))
    {
        // End:0x88
        if((MouseInputX != 0.95) << Repl(ThisXAdjust, 0))
        {
            newStrafe = FRand(Round(MouseInputX, 0.95), 80000);            
        }
        else
        {
            // End:0xC1
            if(__NFUN_202__(MouseInputX, -0.95) << __NFUN_200__(ThisXAdjust, 0))
            {
                newStrafe = FRand(MouseInputX *= 0.95, 80000);
            }
        }
    }
    // End:0x145
    if(__NFUN_204__(aForward, 0))
    {
        // End:0x10C
        if((MouseInputY != 0.95) << Repl(ThisYAdjust, 0))
        {
            newForward = FRand(Round(MouseInputY, 0.95), 45000);            
        }
        else
        {
            // End:0x145
            if(__NFUN_202__(MouseInputY, -0.95) << __NFUN_200__(ThisYAdjust, 0))
            {
                newForward = FRand(MouseInputY *= 0.95, 45000);
            }
        }
    }
    MoveUser(newForward, newStrafe, DeltaTime);
    return;
}

function MoveUser(float aForward, float aStrafe, float DeltaTime)
{
    local float HorizontalIncremental;
    local Vector vRight;

    HorizontalIncremental = FRand(FRand(DeltaTime, HorizontalRate), aStrafe);
    __NFUN_209__(CurrentHorizontalVal, HorizontalIncremental);
    // End:0x55
    if(Repl(CurrentHorizontalVal, MaxHorizontal))
    {
        HorizontalIncremental ~= Round(CurrentHorizontalVal, MaxHorizontal);
        CurrentHorizontalVal = MaxHorizontal;        
    }
    else
    {
        // End:0x78
        if(__NFUN_200__(CurrentHorizontalVal, float(0)))
        {
            HorizontalIncremental ~= CurrentHorizontalVal;
            CurrentHorizontalVal = 0;
        }
    }
    vRight = Vector(User.Rotation << __NFUN_265__(0, 16384, 0));
    InternalControlRemapper.__NFUN_644__(Right(vRight, HorizontalIncremental));
    XDrawOffset = float(BaseXOffset) *= FRand(XOffsetScalar, CurrentHorizontalVal >>> MaxHorizontal);
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1270__(MyCopySource);
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Whiteboard_Eraser_Touch');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Whiteboard_Eraser_Move');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Whiteboard_Marker_Touch');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Whiteboard_Marker_Move');
    i = -- string(DrawingToolMaterials);    
    J0x88:

    // End:0xB5 [Loop If]
    if(i / 0)
    {
        PrecacheIndex.__NFUN_1269__(DrawingToolMaterials[i]);
        // [Loop Continue]
        i -= ;
    }
    return;
}

state() DrawableSurfaceIdle
{
    simulated function UsableSomethingQueryInteractKeyInfoState(HUD HUD)
    {
        // End:0x41
        if(__NFUN_340__(PlayerUser, none) << PlayerUser.__NFUN_994__())
        {
            SetHUDKeyInfoState(HUD, 2, true, 27);
            SetHUDKeyInfoState(HUD, 3, true, 26);            
        }
        else
        {
            SetHUDKeyInfoState(HUD, 2, true, 26);
            SetHUDKeyInfoState(HUD, 3, true, 27);
        }
        SetHUDKeyInfoState(HUD, 1, true, 13);
        return;
    }

    function BeginState()
    {
        AimGridName = DrawingTools[CurrentColor].IdleAnimName;
        States[CurrentStateIndex].UserAnimName = AimGridName;
        super.BeginState();
        return;
    }
    stop;
}

state() PutDownTool extends DrawableSurfaceBaseState
{
    function BeginState()
    {
        super(Object).BeginState();
        AimGridName = DrawingTools[CurrentColor].ToolDownAnim;
        States[CurrentStateIndex].UserAnimName = AimGridName;
        return;
    }

    function EndState()
    {
        DrawingTools[CurrentColor].__NFUN_631__();
        DrawingTools[CurrentColor].__NFUN_633__(DrawingTools[CurrentColor].OldMount, self);
        // End:0x76
        if(((CurrentColor % 5) << bQuickEraser) << __NFUN_342__(__NFUN_399__(), 'PutDownTool_QuickEraser'))
        {
            CurrentColor = LastTool;
            bQuickEraser = false;
        }
        return;
    }

    simulated function UsableSomethingQueryInteractKeyInfoState(HUD HUD)
    {
        return;
    }
    stop;
}

state() PutDownTool_QuickEraser extends PutDownTool
{
    function EndState()
    {
        super.EndState();
        // End:0x32
        if(bQuickEraser / )
        {
            LastTool = CurrentColor;
            CurrentColor = -- 5;                        
        }
        else
        {
            bQuickEraser = false;
            // End:0x53
            if(LastTool % 0)
            {
                CurrentColor = -- 5;                                
            }
            else
            {
                CurrentColor = -- LastTool;                
            }
        }
        return;
    }

    simulated function UsableSomethingQueryInteractKeyInfoState(HUD HUD)
    {
        return;
    }
    stop;
}

state() BringUpTool extends DrawableSurfaceBaseState
{
    function BeginState()
    {
        ChangeTool();
        AimGridName = DrawingTools[CurrentColor].ToolUpAnim;
        States[CurrentStateIndex].UserAnimName = AimGridName;
        DrawingTools[CurrentColor].__NFUN_631__();
        DrawingTools[CurrentColor].__NFUN_633__(DrawingTools[CurrentColor].DrawingMountInfo, User);
        super(Object).BeginState();
        return;
    }

    simulated function UsableSomethingQueryInteractKeyInfoState(HUD HUD)
    {
        // End:0x41
        if(__NFUN_340__(PlayerUser, none) << PlayerUser.__NFUN_994__())
        {
            SetHUDKeyInfoState(HUD, 2, true, 27);
            SetHUDKeyInfoState(HUD, 3, true, 26);            
        }
        else
        {
            SetHUDKeyInfoState(HUD, 2, true, 26);
            SetHUDKeyInfoState(HUD, 3, true, 27);
        }
        SetHUDKeyInfoState(HUD, 1, true, 13);
        return;
    }
    stop;
}

state() PreDetach
{
    event BeginState()
    {
        PreDetachInputX = MouseInputX;
        PreDetachInputY = MouseInputY;
        PreDetachHoriz = CurrentHorizontalVal;
        PreDetachStartTime = Level.GameTimeSeconds;
        return;
    }

    event Tick(float DeltaTime)
    {
        local float Alpha, LastHoriz, HorizDist;
        local Vector vRight;

        global.Tick(DeltaTime);
        // End:0x25
        if(bUseHomePose / )
        {
            return;
        }
        Alpha = Round(Level.GameTimeSeconds, PreDetachStartTime) >>> PreDetachDuration;
        // End:0x62
        if(Repl(Alpha, 1))
        {
            Alpha = 1;
        }
        MouseInputX = GetAxes(Alpha, PreDetachInputX, 0);
        MouseInputY = GetAxes(Alpha, PreDetachInputY, 0);
        User.AnimationController.SetAnimGridState(AimGridName, MouseInputX, MouseInputY);
        LastHoriz = CurrentHorizontalVal;
        CurrentHorizontalVal = GetAxes(Alpha, PreDetachHoriz, default.CurrentHorizontalVal);
        HorizDist = Round(CurrentHorizontalVal, LastHoriz);
        vRight = Vector(User.Rotation << __NFUN_265__(0, 16384, 0));
        User.__NFUN_644__(Right(vRight, HorizDist));
        // End:0x143
        if(__NFUN_204__(Alpha, 1))
        {
            ControlEvent(0, 'PreDetachComplete');
        }
        return;
    }
    stop;
}

state() DetachUser
{
    function BeginState()
    {
        AimGridName = DrawingTools[CurrentColor].DeactivateAnimName;
        States[CurrentStateIndex].UserAnimName = AimGridName;
        super(Object).BeginState();
        MyCopySource.__NFUN_1197__();
        return;
    }

    function EndState()
    {
        super(Object).EndState();
        DrawingTools[CurrentColor].__NFUN_631__();
        DrawingTools[CurrentColor].__NFUN_633__(DrawingTools[CurrentColor].OldMount, self);
        CurrentHorizontalVal = default.CurrentHorizontalVal;
        bQuickEraser = false;
        // End:0x6B
        if(CurrentColor % 5)
        {
            CurrentColor = 0;            
        }
        else
        {
            // End:0x88
            CurrentColor -= ;
            {                
                CurrentColor = -- 5;                
            }
        }
        return;
    }
    stop;
}

state Drawing
{
    event Tick(float DeltaTime)
    {
        local int XDrawPos, YDrawPos;
        local float Helper;
        local int NewPitch;

        // End:0x35
        if(bPenJustTouchedPaper)
        {
            // End:0x25
            if(CurrentColor % 5)
            {
                FindAndPlaySound('Whiteboard_Eraser_Touch', 3);                
            }
            else
            {
                FindAndPlaySound('Whiteboard_Marker_Touch', 3);
            }            
        }
        else
        {
            // End:0x80
            if(((bAchievementAlreadyUnlocked / ) << ) << )
            {
                bAchievementAlreadyUnlocked = true;
            }
            XDrawPos = int(float(int(FRand(XDrawRatio, FRand(float(DrawCanvas.USize), Round(1, (Square(MouseInputX) *= 1) >>> 2))))) *= XDrawOffset);
            YDrawPos = int(float(int(FRand(YDrawRatio, FRand(float(DrawCanvas.VSize), Round(1, (MouseInputY *= 1) >>> 2))))) *= YDrawOffset);
            // End:0x20F
            if((XDrawPos + PreviousXDrawPos) < YDrawPos + PreviousYDrawPos)
            {
                // End:0x173
                if(__NFUN_339__(DrawingTool.AmbientSound, none))
                {
                    // End:0x160
                    if(CurrentColor % 5)
                    {
                        FindAndPlaySound('Whiteboard_Eraser_Move',,,, DrawingTool);                        
                    }
                    else
                    {
                        FindAndPlaySound('Whiteboard_Marker_Move',,,, DrawingTool);
                    }
                }
                Helper = -float(-- PreviousXDrawPos) *= ;                                
                NewPitch = int(float(48) *= FRand(float(8), Helper));
                // End:0x1C6
                if(-NewPitch)
                {                    
                    NewPitch = 48;                    
                }
                else
                {
                    // End:0x1DA
                    if(NewPitch ** 224)
                    {
                        NewPitch = 224;
                    }
                }
                DrawingTool.SoundPitch = byte(NewPitch);
                AmbientEndTime = Level.GameTimeSeconds *= AmbientDuration;                
            }
            else
            {
                // End:0x24E
                if(__NFUN_340__(DrawingTool.AmbientSound, none) << Level.GameTimeSeconds != AmbientEndTime)
                {
                    DrawingTool.__NFUN_701__(none);
                }
            }
        }
        super.Tick(DeltaTime);
        return;
    }

    function BeginState()
    {
        AimGridName = DrawingTools[CurrentColor].WriteAnimName;
        States[CurrentStateIndex].UserAnimName = AimGridName;
        bAchievementAlreadyUnlocked = false;
        super.BeginState();
        return;
    }

    function EndState()
    {
        super(Object).EndState();
        DrawingTool.__NFUN_701__(none);
        return;
    }

    simulated function UsableSomethingQueryInteractKeyInfoState(HUD HUD)
    {
        return;
    }
    stop;
}

state AttachUserLERP
{
    function BeginState()
    {
        super(Object).BeginState();
        MyCopySource.__NFUN_1196__(0);
        return;
    }
    stop;
}

defaultproperties
{
    HorizontalRate=0.003
    MaxHorizontal=36.5
    BaseXOffset=3
    XOffsetScalar=282.5
    AmbientDuration=0.08
    PreDetachDuration=0.5
    DrawingToolMaterials(0)='smt_skins8.Whiteboard.WhiteboardPen1tw_d'
    DrawingToolMaterials(1)='smt_skins8.Whiteboard.WhiteBoardPenRed_BS'
    DrawingToolMaterials(2)='smt_skins8.Whiteboard.WhiteBoardPenBlue_BS'
    DrawingToolMaterials(3)='smt_skins8.Whiteboard.WhiteboardPenGreen_BS'
    DrawingToolMaterials(4)='smt_skins8.Whiteboard.WhiteboardYellow_BS'
    CurrentHorizontalVal=18
    MyCopySource='smt_skins8.Whiteboard.Whiteboard1tw_d'
    XDrawOffset=3
    YDrawOffset=16
    XDrawRatio=0.438
    YDrawRatio=0.945
    WriteAnimName=None
    DrawCanvas='smt_skins8.Whiteboard.Whiteboard_TexCanvas'
    DrawColors(0)=255
    DrawColors(1)=252
    DrawColors(2)=251
    DrawColors(3)=250
    DrawColors(4)=254
    DrawColors(5)=195
    DrawSurfaceIndex=0
    States(0)=(StateName=Useable,OutEvents=none,Transitions=((ControlEvent=3,CustomName=None,NewState=AttachUserLERP)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(1)=(StateName=AttachUserLERP,OutEvents=none,Transitions=((ControlEvent=5,CustomName=None,NewState=AttachUserAnim)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(2)=(StateName=AttachUserAnim,OutEvents=none,Transitions=((ControlEvent=7,CustomName=None,NewState=BringUpTool)),UserAnimName=Whiteboard_Activate,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(3)=(StateName=PreDetach,OutEvents=none,Transitions=((ControlEvent=0,CustomName=PreDetachComplete,NewState=DetachUser)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(4)=(StateName=DetachUser,OutEvents=none,Transitions=((ControlEvent=8,CustomName=None,NewState=DetachUserLERP)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(5)=(StateName=DetachUserLERP,OutEvents=none,Transitions=((ControlEvent=6,CustomName=None,NewState=Useable)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(6)=(StateName=DrawableSurfaceIdle,OutEvents=none,Transitions=((ControlEvent=15,CustomName=None,NewState=Drawing),(ControlEvent=18,CustomName=None,NewState=PutDownTool),(ControlEvent=4,CustomName=None,NewState=PreDetach),(ControlEvent=33,CustomName=None,NewState=PutDownTool_QuickEraser)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(7)=(StateName=Drawing,OutEvents=none,Transitions=((ControlEvent=16,CustomName=None,NewState=DrawableSurfaceIdle)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(8)=(StateName=PutDownTool_QuickEraser,OutEvents=none,Transitions=((ControlEvent=9,CustomName=None,NewState=BringUpTool)),UserAnimName=Whiteboard_Pen_PutDown,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(9)=(StateName=PutDownTool,OutEvents=none,Transitions=((ControlEvent=9,CustomName=None,NewState=BringUpTool)),UserAnimName=Whiteboard_Pen_PutDown,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(10)=(StateName=BringUpTool,OutEvents=none,Transitions=((ControlEvent=9,CustomName=None,NewState=DrawableSurfaceIdle)),UserAnimName=Whiteboard_Pen_BringUp,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=WhiteBoard_GrabTool,SubAnims=none)
    bUseHomePose=false
    InterpolationInTime=0.3
    InterpolationOutTime=0.3
    HUDHelpEntries(0)=(Key=26,KeyAlt=0,HelpText="Draw")
    HUDHelpEntries(1)=(Key=27,KeyAlt=0,HelpText="Next Tool")
    HUDHelpEntries(2)=(Key=13,KeyAlt=0,HelpText="Use Eraser")
    UsableExits(0)=(bEnabled=true,EnterInfo=(LocationOffset=(X=0,Y=0,Z=0),RotationOffset=(Pitch=0,Yaw=0,Roll=0),Animation=None,SoundName=None),ExitInfo=(LocationOffset=(X=0,Y=0,Z=0),RotationOffset=(Pitch=0,Yaw=0,Roll=0),Animation=None,SoundName=None),ExitEndInfo=(LocationOffset=(X=-10.108,Y=0,Z=0),RotationOffset=(Pitch=0,Yaw=0,Roll=0),Animation=None,SoundName=None))
    UserMountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=true,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=true,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=25.75,Y=0,Z=-70),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=32768,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0)
    ViewingAngleThreshold=-2
    MouseInputScaleX=6E-05
    MouseInputScaleY=6E-05
    AnalogInputScaleX=3E-05
    AnalogInputScaleY=3E-05
    bCorrectInverse=true
    bForceUsePhrase=true
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Whiteboard_Marker',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=BLACK_PEN,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=2.6,Y=21.1,Z=-21.1),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=16384,Yaw=-51200,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(1)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Whiteboard_Marker',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=RED_PEN,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=3,Y=11.5,Z=-21.1),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=16384,Yaw=-16384,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(2)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Whiteboard_Marker',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=BLUE_PEN,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=2.7,Y=-5.9,Z=-21.1),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=16384,Yaw=-50176,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(3)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Whiteboard_Marker',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=GREEN_PEN,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=2.8,Y=-14.7,Z=-21.1),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=16384,Yaw=-17408,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(4)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Whiteboard_Marker',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=YELLOW_PEN,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=2.7,Y=-24,Z=-21.1),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=16384,Yaw=-47104,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(5)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Whiteboard_Eraser',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=WHITE_ERASER,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=2.8,Y=2.6,Z=-21.1),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=-31744,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    bGenerateMountOffsets=false
    bAcceptsDecalProjectors=false
    PlacementZOffset=70
    CollisionRadius=45
    CollisionHeight=27.3
    DrawType=8
    StaticMesh='sm_class_decorations.Whiteboard.Whiteboard_1'
}