/*******************************************************************************
 * dnControl_WorkoutBench generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnControl_WorkoutBench extends dnControl_TapPowered
    collapsecategories;

var() noexport name UserLiftGridName "Name for the AnimationGrid to use for lifting the bar.";
var() noexport name UserLiftReferenceName "Name for the Animation that defines the reference position of UserLiftGridName.";
var() noexport name UserShakeAnimName "Name for the Animation to use for shaking.";
var() noexport name UserAntiShakeAnimName "Name for the Animation to use for anti-shaking.";
var() noexport name UserIdleAnimName "Name for the Animation to use for upper body idle.";
var() noexport float InitialWeight "Startup weight amount on bar.  Code will attempt to match this, but the result may be less than the number inputted.  Max is 1000.";
var dnControlHelper_WorkoutBench_Bar MyBar;
var SMountPrefab BarDefaultMountPrefab;
var SMountPrefab BarHeldMountPrefab;

function PostVerifySelf()
{
    super.PostVerifySelf();
    MyBar = dnControlHelper_WorkoutBench_Bar(FindMountedActor(, class'dnControlHelper_WorkoutBench_Bar'));
    // End:0xB3
    if(__NFUN_340__(MyBar, none))
    {
        BarDefaultMountPrefab.MountOrigin = MyBar.MountOrigin;
        BarDefaultMountPrefab.MountAngles = MyBar.MountAngles;
        BarDefaultMountPrefab.MountType = MyBar.MountType;
        BarDefaultMountPrefab.MountMeshItem = MyBar.MountMeshItem;
        BarDefaultMountPrefab.bSurviveDismount = true;
        MyBar.ChallengeTag = ChallengeTag;
    }
    // End:0xC5
    if(Repl(InitialWeight, float(0)))
    {
        CreateInitialWeight();
    }
    return;
}

final function CreateInitialWeight()
{
    local int WeightsLeft;
    local Settings_Workout_BarWeight_100lbs NewWeight;

    WeightsLeft = int(InitialWeight >>> 100);
    J0x13:

    // End:0x7F [Loop If]
    if(((WeightsLeft -= ) ** ) << )
    {
        // End:0x52
        if(__NFUN_339__(NewWeight, none))
        {            
        }
        else
        {
            NewWeight.ChallengeTag = ChallengeTag;
            MyBar.AttachWeightToBar(NewWeight);
        }
        // [Loop Continue]
        goto J0x13;
    }
    return;
}

event Used(Actor Other, Pawn EventInstigator)
{
    // End:0x3A
    if(__NFUN_339__(User, none) << MyBar.IsBalanced() / )
    {
        return;
    }
    super(dnUsableSomething).Used(Other, EventInstigator);
    return;
}

simulated function AttachToUser()
{
    // End:0x1C
    if(__NFUN_339__(MyBar, none) < __NFUN_339__(User, none))
    {
        return;
    }
    FindAndPlaySound('BenchPress_BarGrabbed', 3);
    MyBar.__NFUN_631__();
    MyBar.__NFUN_633__(BarHeldMountPrefab, User);
    return;
}

simulated function DetachFromUser()
{
    // End:0x0E
    if(__NFUN_339__(MyBar, none))
    {
        return;
    }
    FindAndPlaySound('BenchPress_BarPlaced', 3);
    MyBar.__NFUN_631__();
    MyBar.__NFUN_633__(BarDefaultMountPrefab, self);
    return;
}

function UserStraining(bool bStraining)
{
    // End:0x2B
    if(bStraining)
    {
        User.AnimationController.SetAnimState(UserShakeAnimName);        
    }
    else
    {
        User.AnimationController.SetAnimState(UserAntiShakeAnimName);
    }
    return;
}

function FullyLifted()
{
    super.FullyLifted();
    User.FindAndPlaySound(UserGruntSoundName, 1, true, false);
    // End:0x7E
    if(__NFUN_340__(DukePlayer(User), none))
    {
        // End:0x70
        if(LiftWeight != 600)
        {
            DukePlayer(User).GivePermanentEgoCapAward(3);
            DukePlayer(User).GivePermanentEgoCapAward(4);            
        }
        else
        {
            __NFUN_607__(0.3, false, 'SayTooEasy');
        }
    }
    return;
}

function UpdateUserLift()
{
    User.AnimationController.SetAnimGridState(UserLiftGridName, 0, UserLiftVal);
    return;
}

simulated function DetachComplete()
{
    // End:0x2A
    if(__NFUN_340__(MyBar, none) << __NFUN_340__(MyBar.MountParent, self))
    {
        DetachFromUser();
    }
    super(dnControl).DetachComplete();
    return;
}

function SayTooEasy()
{
    User.FindAndPlaySound('WeightBench_TooEasy');
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(class'Settings_Workout_BarWeight_100lbs');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'BenchPress_BarGrabbed');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'BenchPress_BarPlaced');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', UserGruntSoundName);
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'WeightBench_UseFail');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'WeightBench_TooEasy');
    PrecacheIndex.__NFUN_1281__(UserLiftGridName);
    PrecacheIndex.__NFUN_1281__(UserLiftReferenceName);
    PrecacheIndex.__NFUN_1281__(UserShakeAnimName);
    PrecacheIndex.__NFUN_1281__(UserAntiShakeAnimName);
    PrecacheIndex.__NFUN_1281__(UserIdleAnimName);
    return;
}

state() AttachUserAnim
{
    function EndState()
    {
        // End:0x22
        if(__NFUN_340__(MyBar, none))
        {
            LiftWeight = MyBar.GetTotalWeight();
        }
        User.AnimationController.SetAnimState(UserLiftReferenceName);
        super.EndState();
        return;
    }
    stop;
}

defaultproperties
{
    UserLiftGridName=WorkoutBench_Lift_Grid
    UserLiftReferenceName=WorkoutBench_Lift_Reference
    UserShakeAnimName=WorkoutBench_Shake
    UserAntiShakeAnimName=WorkoutBench_AntiShake
    BarHeldMountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_handleft,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0)
    TapUsePhrase="<?int?dnDecorations.dnControl_WorkoutBench.TapUsePhrase?>"
    UserGruntDelay=10
    UserGruntSoundName=Gen_Grunt
    UserLiftVal=-0.7
    States(0)=(StateName=Useable,OutEvents=none,Transitions=((ControlEvent=3,CustomName=None,NewState=AttachUserLERP)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(1)=(StateName=AttachUserLERP,OutEvents=none,Transitions=((ControlEvent=5,CustomName=None,NewState=AttachUserAnim)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(2)=(StateName=AttachUserAnim,OutEvents=none,Transitions=((ControlEvent=7,CustomName=None,NewState=idle)),UserAnimName=WorkoutBench_Activate,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(3)=(StateName=idle,OutEvents=none,Transitions=((ControlEvent=4,CustomName=None,NewState=FadeToRest)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(4)=(StateName=DetachUser,OutEvents=none,Transitions=((ControlEvent=8,CustomName=None,NewState=DetachUserLERP)),UserAnimName=WorkoutBench_Deactivate,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(5)=(StateName=DetachUserLERP,OutEvents=none,Transitions=((ControlEvent=6,CustomName=None,NewState=Useable)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(6)=(StateName=FadeToRest,OutEvents=none,Transitions=((ControlEvent=0,CustomName=ProceedWithDetach,NewState=DetachUser)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    bDelayedDetach=true
    bUseHomePose=false
    InterpolationInTime=0.3
    InterpolationOutTime=0.3
    HUDHelpEntries(0)=(Key=26,KeyAlt=13,HelpText="Lift (Tap)")
    UsableExits(0)=(bEnabled=true,EnterInfo=(LocationOffset=(X=0,Y=0,Z=0),RotationOffset=(Pitch=0,Yaw=0,Roll=0),Animation=None,SoundName=None),ExitInfo=(LocationOffset=(X=0,Y=0,Z=0),RotationOffset=(Pitch=0,Yaw=0,Roll=0),Animation=None,SoundName=None),ExitEndInfo=(LocationOffset=(X=20,Y=0,Z=0.205),RotationOffset=(Pitch=0,Yaw=0,Roll=0),Animation=None,SoundName=None))
    UserMountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=true,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=true,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=44,Y=0,Z=-22),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=32768,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0)
    HeadAimMinOffset=(Pitch=-6000,Yaw=-4000,Roll=0)
    HeadAimMaxOffset=(Pitch=-6000,Yaw=4000,Roll=0)
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_WorkoutBench_Bar',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-19.224,Y=0,Z=18.18),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    bBlockPlayers=true
    bBlockKarma=true
    CollisionRadius=30
    CollisionHeight=22
    DrawType=8
    StaticMesh='sm_class_decorations.WorkoutBenchPress.BenchPress'
}