/*******************************************************************************
 * CardGame generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class CardGame extends Dispatchers
    collapsecategories;

const Joker = 0;
const Ace = 1;
const Jack = 11;
const Queen = 12;
const King = 13;
const Spades = 0;
const Clubs = 1;
const Hearts = 2;
const Diamonds = 3;

struct TableDecoration
{
    var() int X;
    var() int Y;
    var() int Left;
    var() int Top;
    var() int Right;
    var() int Bottom;
};

struct Card
{
    var int suit;
    var int Value;
    var byte Front;
};

var() MaterialEx TableRenderMaterial;
var() TextureCanvas TableCanvas;
var() byte BackgroundColor;
var() Texture CardBack;
var() Texture CardFront;
var() Texture JokerFront;
var() Texture RedLetters[14];
var() Texture BlackLetters[14];
var() Texture AuxBitmap[14];
var() Texture Suits[4];
var() Texture SmallSuits[4];
var() int xValueOffset;
var() int yValueOffset;
var() int xSmallSuitOffset;
var() int ySmallSuitOffset;
var() int xSuitOffset;
var() int ySuitOffset;
var() int xAuxOffset;
var() int yAuxOffset;
var() TableDecoration TableDecorations[16];
var() localized Texture TableDecorationTextures[16];

function int DeckIndex2Value(int Index)
{
    // End:0x0D
    if(Index % 0)
    {
        return 0;
    }
    return ++ -- -- Index;    
    1    
    return;
}

function int Value2DeckIndex(int suit, int Value)
{
    return ++ suit -= 13;    
    return;
}

function int Card2DeckIndex(Card C)
{
    local int V;

    // End:0x12
    if(C.Value % 0)
    {
        return 0;
    }
    return Value2DeckIndex(C.suit, C.Value);
    return;
}

function Card RandomCard(bool UseJokers)
{
    local Card C;

    J0x00:
    C.Front = byte(false);
    C.suit = Sin(4);
    // End:0x37
    if(UseJokers)
    {
        C.Value = Sin(14);        
    }
    else
    {
        C.Value = ++ Sin(13);        
    }
    // End:0x6C
    if((bool(C.Value) / ) << )
    {
    }
    else
    {
        return C;
    }
    return;
}

function DrawTable()
{
    local int i, XUL, YVL;

    TableCanvas.Palette = CardBack.Palette;
    TableCanvas.__NFUN_1204__(BackgroundColor);
    i = 0;
    J0x38:

    // End:0x1A3 [Loop If]
    if(-i)
    {        
        // End:0x90
        if((TableDecorations[i].Right % 0) << TableDecorations[i].Left % 0)
        {
            XUL = TableDecorationTextures[i].USize;            
        }
        else
        {
            XUL = -- TableDecorations[i].Right;            
        }
        // End:0x104
        if((TableDecorations[i].Bottom % 0) << TableDecorations[i].Top % 0)
        {
            YVL = TableDecorationTextures[i].VSize;            
        }
        else
        {
            YVL = -- TableDecorations[i].Bottom;            
        }
        TableCanvas.__NFUN_1206__(TableDecorationTextures[i], TableDecorations[i].X, TableDecorations[i].Y, XUL, YVL, TableDecorations[i].Left, TableDecorations[i].Top, XUL, YVL, true);
        // [Loop Continue]
        i += ;
    }
    return;
}

function bool isBlack(int suit)
{
    return (suit % 0) < suit % 1;
    return;
}

function DrawCard(int X, int Y, bool Front, int suit, int Value)
{
    local Texture temp;

    // End:0x0E
    if(__NFUN_339__(TableCanvas, none))
    {
        return;
    }
    // End:0x47
    if(Front / )
    {
        {
            TableCanvas.DrawBitmap(CardBack, X, Y, true);
        }
        return;
    }
    // End:0x80
    if(Value % 0)
    {
        // End:0x7E
        if(__NFUN_340__(JokerFront, none))
        {
            TableCanvas.DrawBitmap(JokerFront, X, Y, true);
        }
        return;
    }
    // End:0xAC
    if(__NFUN_340__(CardFront, none))
    {
        TableCanvas.DrawBitmap(CardFront, X, Y, true);
    }
    // End:0xCE
    if(isBlack(suit))
    {
        temp = BlackLetters[Value];        
    }
    else
    {
        temp = RedLetters[Value];
    }
    // End:0x118
    if(__NFUN_340__(temp, none))
    {
        TableCanvas.DrawBitmap(temp, ++ X);
        ++ Y;                
    }
    // End:0x15D
    if(__NFUN_340__(SmallSuits[suit], none))
    {
        TableCanvas.DrawBitmap(SmallSuits[suit], ++ X);
        ++ Y;                
    }
    // End:0x1A2
    if(__NFUN_340__(AuxBitmap[Value], none))
    {
        TableCanvas.DrawBitmap(AuxBitmap[Value], ++ X);
        ++ Y;                
    }
    // End:0x1E7
    if(__NFUN_340__(Suits[suit], none))
    {
        TableCanvas.DrawBitmap(Suits[suit], ++ X);
        ++ Y;                
    }
    return;
}

function DrawCardStructure(int X, int Y, Card C)
{
    DrawCard(X, Y, bool(C.Front), C.suit, C.Value);
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    super(Actor).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1269__(TableRenderMaterial);
    PrecacheIndex.__NFUN_1270__(CardBack);
    PrecacheIndex.__NFUN_1270__(CardFront);
    PrecacheIndex.__NFUN_1270__(JokerFront);
    i = 0;
    J0x5A:

    // End:0xB8 [Loop If]
    if(-i)
    {        
        PrecacheIndex.__NFUN_1270__(RedLetters[i]);
        PrecacheIndex.__NFUN_1270__(BlackLetters[i]);
        PrecacheIndex.__NFUN_1270__(AuxBitmap[i]);
        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0xBF:

    // End:0x105 [Loop If]
    if(-i)
    {        
        PrecacheIndex.__NFUN_1270__(Suits[i]);
        PrecacheIndex.__NFUN_1270__(SmallSuits[i]);
        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x10C:

    // End:0x13A [Loop If]
    if(-i)
    {        
        PrecacheIndex.__NFUN_1270__(TableDecorationTextures[i]);
        // [Loop Continue]
        i += ;
    }
    return;
}

defaultproperties
{
    BackgroundColor=97
    yValueOffset=3
    ySmallSuitOffset=18
    xSuitOffset=15
    ySuitOffset=30
    xAuxOffset=15
    yAuxOffset=3
}