/*******************************************************************************
 * CigarAttachment generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class CigarAttachment extends dnDecoration
    dependson(CigarAttachment_ThirdPerson);

var() noexport float EgoPerPuff "Maximum ego to gain each puff which happesn every PuffDuration seconds";
var() noexport float PuffPeriod "Time between puffs.";
var() noexport float PuffDuration "Time it takes to complete a puff.";
var() noexport float TotalEgoBonus "The total ego to give over time.";
var Pawn Puffer;
var float GridPerSecond;
var float EgoBonusRemaining;
var float BurnGrid;
var float BurnGridTarget;
var float BurnGridMin;
var float BurnGridMax;
var Color BurningColor;
var CigarSmoke SmokeThin;
var CigarSmokeThick SmokeThick;
var float SmokeCallBack;
var SMountPrefab ThirdPersonMountPrefab;
var CigarAttachment_ThirdPerson CigarTP;

replication
{
    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        BurnGrid;
}

event PostVerifySelf()
{
    super.PostVerifySelf();
    SmokeThin = CigarSmoke(FindMountedActor('SMOKE_THIN'));
    SmokeThick = CigarSmokeThick(FindMountedActor('SMOKE_THICK'));
    __NFUN_354__(__NFUN_340__(SmokeThin, none));
    __NFUN_354__(__NFUN_340__(SmokeThick, none));
    PuffPeriod = VSize(PuffPeriod, PuffDuration);
    SmokeCallBackFunc();
    return;
}

simulated event HiddenChanged()
{
    super(Actor).HiddenChanged();
    // End:0x25
    if(__NFUN_340__(CigarTP, none))
    {
        CigarTP.__NFUN_590__(bHidden);
    }
    return;
}

event Destroyed()
{
    super.Destroyed();
    // End:0x26
    if(__NFUN_340__(CigarTP, none))
    {
        CigarTP.__NFUN_614__();
        CigarTP = none;
    }
    return;
}

final function MakePawnPuff(Pawn NewPuffer)
{
    Puffer = NewPuffer;
    __NFUN_641__(Puffer);
    BurnGrid = -1;
    AnimationController.SetAnimGridState('SmokeGrid', BurnGrid);
    // End:0x61
    if(Puffer.bIsPlayerPawn)
    {
        PlayerPawn(Puffer).CigarAttachment = self;
    }
    EgoBonusRemaining = TotalEgoBonus;
    BurnGrid = BurnGridMin;
    BurnGridTarget = BurnGridMin;
    GridPerSecond = (Round(BurnGridMax, BurnGridMin) >>> (TotalEgoBonus >>> EgoPerPuff)) >>> PuffDuration;
    __NFUN_605__(PuffPeriod, true, 'DoPuff');
    DoPuff();
    // End:0xE5
    if(__NFUN_340__(DukePlayer(Puffer), none))
    {
        DukePlayer(Puffer).GivePermanentEgoCapAward(17);
    }
    CigarTP = __NFUN_615__(class'CigarAttachment_ThirdPerson', Owner);
    // End:0x11C
    if(__NFUN_340__(CigarTP, none))
    {
        CigarTP.__NFUN_633__(ThirdPersonMountPrefab, Puffer, false);
    }
    return;
}

simulated event Tick(float DeltaTime)
{
    local byte Step;
    local Color C;

    super(Actor).Tick(DeltaTime);
    // End:0x1E4
    if(int(Role) % int(ROLE_Authority))
    {
        // End:0x2A
        if(__NFUN_339__(Puffer, none))
        {
            __NFUN_614__();
            return;
        }
        // End:0xFD
        if(__NFUN_206__(BurnGrid, BurnGridTarget))
        {
            BurnGrid = Normal2D(BurnGrid *= FRand(GridPerSecond, DeltaTime), BurnGridMin, BurnGridTarget);
            // End:0xCB
            if(__NFUN_204__(BurnGrid, BurnGridTarget))
            {
                SmokeThick.Enabled = true;
                __NFUN_605__(SmokeCallBack, false, 'SmokeCallBackFunc');
                // End:0xC8
                if(__NFUN_204__(EgoBonusRemaining, 0))
                {
                    __NFUN_614__();
                    // End:0xC8
                    if(Puffer.bIsPlayerPawn)
                    {
                        PlayerPawn(Puffer).CigarAttachment = none;
                    }
                }                
            }
            else
            {
                SmokeThin.Enabled = false;
            }
            __NFUN_601__('Generic0', __NFUN_338__(0.05, __NFUN_603__('Generic0'), BurningColor));            
        }
        else
        {
            SmokeThin.Enabled = true;
            C = __NFUN_603__('Generic0');
            Step = byte(FRand(float(255), DeltaTime));
            // End:0x15C
            if(int(C.R) / ++ 32)
            {                
                C.R == Step;                
            }
            else
            {
                C.R = 32;
            }
            // End:0x193
            if(int(C.G) / int(Step))
            {
                C.G == Step;                
            }
            else
            {
                C.G = 0;
            }
            // End:0x1CA
            if(int(C.B) / int(Step))
            {
                C.B == Step;                
            }
            else
            {
                C.B = 0;
            }
            __NFUN_601__('Generic0', C);
        }
    }
    AnimationController.SetAnimGridState('SmokeGrid', BurnGrid);
    // End:0x248
    if(__NFUN_340__(CigarTP, none))
    {
        CigarTP.AnimationController.SetAnimGridState('SmokeGrid', BurnGrid);
        CigarTP.__NFUN_601__('Generic0', __NFUN_603__('Generic0'));
    }
    return;
}

final function DoPuff()
{
    local float BonusEgo;

    // End:0x0E
    if(__NFUN_339__(Puffer, none))
    {
        return;
    }
    BonusEgo = EgoPerPuff;
    // End:0x9A
    if(Repl(BonusEgo, 1))
    {
        EgoBonusRemaining ~= BonusEgo;
        DecoActivity(0, 'PuffCigar_Cool');
        BurnGridTarget = Round(BurnGridMax, FRand(EgoBonusRemaining >>> TotalEgoBonus, Round(BurnGridMax, BurnGridMin)));
        // End:0x9A
        if(Puffer.bIsPlayerPawn)
        {
            Puffer.__NFUN_605__(PuffDuration *= 1, false, 'PlayCigarExhale');
        }
    }
    return;
}

final function SmokeCallBackFunc()
{
    SmokeThick.Enabled = false;
    return;
}

simulated event bool ShouldShowHoloDukeEffect()
{
    return true;
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(class'CigarAttachment_ThirdPerson');
    PrecacheIndex.__NFUN_1283__('SmokeGrid', AnimationControllerClass, Mesh);
    PrecacheIndex.__NFUN_1277__(class'DukePlayer'.default.VoicePack, 'Cig_Exhale');
    return;
}

defaultproperties
{
    EgoPerPuff=10
    PuffPeriod=8
    PuffDuration=1.3
    TotalEgoBonus=50
    GridPerSecond=0.05
    BurnGrid=-1
    BurnGridMin=-1
    BurnGridMax=-0.3
    BurningColor=(R=255,G=32,B=0,A=255)
    SmokeCallBack=0.6
    ThirdPersonMountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=f_Jaw,MountOrigin=(X=4.731,Y=1.463,Z=-0.413),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-15,Yaw=-30443,Roll=-3),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0)
    DecoActivities_Default(0)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(PuffCigar_Cool),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Sound'CigarAttachment.DA_Sound_Cigar_Attach_Cool'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='dnParticles.CigarSmoke',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=SMOKE_THIN,ForceEvent=None,MountMeshItem=ashtip,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=16384,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(1)=(bSkipVerifySelf=false,SpawnClass='dnParticles.CigarSmokeThick',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=SMOKE_THICK,ForceEvent=None,MountMeshItem=ashtip,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=16384,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    AnimationControllerClass='acCigar'
    bDumbMesh=false
    bDontSimulateMotion=true
    bCollideActors=false
    CollisionRadius=0
    CollisionHeight=0
    TickStyle=3
    Mesh='c_dukeitems.Cigar'
    OwnerSeeStyle=1
    ActorColorList(0)=(ActorColor=(R=32,G=0,B=0,A=255),ActorColor_LightEx=none,ActorColor_LightExScale=(X=0,Y=0,Z=0),id=Generic0)
    VoicePack='SoundConfig.Inventory.VoicePack_Cigar'
}