/*******************************************************************************
 * DukeMultiPlayer generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class DukeMultiPlayer extends DukePlayer
    native
    config(User)
    collapsecategories
    dependson(dnControl_Execution)
    dependson(PlayerProgression)
    dependson(MetagameHUD)
    dependson(dnDeathmatchGame)
    dependson(MP_Announcer)
    dependson(DukeHUD)
    dependson(DukeMultiPlayerCorpse)
    dependson(MP_Weapon)
    dependson(dnMultiplayer)
    dependson(MP_Shotgun)
    dependson(dnDeathmatchGame_TeamDM)
    dependson(MP_Detonator)
    dependson(DukeMultiplayerAssets)
    dependson(MP_PipeBomb)
    dependson(MP_Tripmine)
    dependson(MP_LaserMine)
    dependson(MP_dnPipeBombProjectile)
    dependson(JetpackVolume)
    dependson(DamageVolume)
    dependson(CustomizationDecoration)
    dependson(LaserMineBeam)
    dependson(Upgrade_SOS)
    dependson(MP_AtCaptainLaserWeaponConfig)
    dependson(MP_AtLaserWeaponConfig)
    dependson(MP_DamageBoosterWeaponConfig)
    dependson(MP_DetonatorWeaponConfig)
    dependson(MP_DevastatorWeaponConfig)
    dependson(MP_EnforcerGunWeaponConfig)
    dependson(MP_FortyOunceBeerWeaponConfig)
    dependson(MP_FreezeRayWeaponConfig)
    dependson(MP_HolodukeWeaponConfig)
    dependson(MP_InvincibilityWeaponConfig)
    dependson(MP_MachineGunWeaponConfig)
    dependson(MP_NukeWeaponConfig)
    dependson(MP_PipeBombWeaponConfig)
    dependson(MP_PistolWeaponConfig)
    dependson(MP_RailgunWeaponConfig)
    dependson(MP_RPGWeaponConfig)
    dependson(MP_ShotgunWeaponConfig)
    dependson(MP_ShrinkrayWeaponConfig)
    dependson(MP_SteroidsWeaponConfig)
    dependson(MP_TripMineWeaponConfig);

cpptext
{
// Stripped
}

const TEABAG_THRESHOLD = 300;

enum EDeathCamStatus
{
    DCS_None,
    DCS_Rising,
    DCS_Tracking
};

enum EPowerupEffect
{
    PE_Invincibility,
    PE_DamageBooster,
    PE_All
};

enum VOTrigger
{
    VOT_Kill,
    VOT_MeleeKill,
    VOT_MessyKill,
    VOT_HeadshotKill,
    VOT_ExecutionKill,
    VOT_GrabBabe,
    VOT_KillBabeCarrier,
    VOT_CaptureBabe,
    VOT_FinishPissing,
    VOT_StartedPissing,
    VOT_Beer01,
    VOT_Beer02,
    VOT_KilledDrinker,
    VOT_CFWin,
    VOT_CFLose,
    VOT_Remark_Death,
    VOT_Remark_Matchstart,
    VOT_Remark_SoloLoss,
    VOT_Remark_SoloWin,
    VOT_Remark_LeadGain,
    VOT_Remark_LeadLose,
    VOT_Remark_TeamLoss,
    VOT_Remark_TeamWin,
    VOT_Taunt,
    VOT_LevelUp
};

struct SCustomizationInfo
{
    var int HatIndex;
    var int FaceIndex;
    var int ShirtIndex;
    var int ShirtLogoIndex;
    var int TitleIndex;
    var int ShirtColorIndex;
};

var class<CharacterVoicePack> MP_VoicePack;
var class<CharacterVoicePack> SP_VoicePack;
var class<CharacterVoicePack> DLC_VoicePack;
var PlayerProgression PlayerProgress;
var bool bActive;
var bool bRespawn;
var bool bOvertime;
var bool bQuitGame;
var float SavingTime;
var float LastScorePointTime;
var DukeMultiPlayer LastPointScorer;
var int DisplayStatsStartIndex;
var class<AnimationControllerEx> StandingAnimCtrl1stClass;
var class<AnimationControllerEx> StandingAnimCtrl3rdClass;
var class<AnimationControllerEx> CrouchingAnimCtrl1stClass;
var class<AnimationControllerEx> CrouchingAnimCtrl3rdClass;
var class<AnimationControllerEx> InAirAnimCtrl1stClass;
var class<AnimationControllerEx> InAirAnimCtrl3rdClass;
var class<AnimationControllerEx> JetpackAnimCtrl1stClass;
var class<AnimationControllerEx> JetpackAnimCtrl3rdClass;
var class<AnimationControllerEx> MountedAnimCtrlClass;
var AnimationControllerEx BackUp_StandAnimCtrl1st;
var AnimationControllerEx BackUp_StandAnimCtrl3rd;
var AnimationControllerEx BackUp_CrouchAnimCtrl1st;
var AnimationControllerEx BackUp_CrouchAnimCtrl3rd;
var AnimationControllerEx BackUp_InAirAnimCtrl1st;
var AnimationControllerEx BackUp_InAirAnimCtrl3rd;
var AnimationControllerEx BackUp_JetpackAnimCtrl1st;
var AnimationControllerEx BackUp_JetpackAnimCtrl3rd;
var AnimationControllerEx BackUp_MountedAnimCtrlClass;
var DamageVolume CurrentDamageVolume;
var DamageVolume AutoTurnoffVolume;
var JetpackVolume CurrentJetPackVolume;
var bool bDukeVisionOn;
var int nStandingController;
var bool bAlone;
var bool bInitialSpawn;
var Vector DeathLocation;
var float OverrideGravityMagnitude;
var bool bOverrideGravity;
var() float RocketJumpForce;
var float MaxRocketJumpForce;
var Vector deathcamcorpseLoc;
var Vector deathcamlocTop;
var Vector deathcamtargetLoc;
var Vector deathcamwantedLoc;
var netupdate(NU_ApplyCustomization) SCustomizationInfo CustomizationInfo;
var bool bAppliedSkin;
var int BlueTeamShirtColorIdx;
var int RedTeamShirtColorIdx;
var() float SubdualDamage;
var() float SubdualDamageFactor;
var() float PostSpawnInvincibilityTime;
var bool bPostSpawnInvincible;
var bool bPowerup_Invincibility;
var() float Powerup_InvincibilityDuration;
var float Powerup_InvincibilityRemaining;
var bool bPowerup_DamageBooster;
var() float Powerup_DamageBoosterDuration;
var float Powerup_DamageBoosterRemaining;
var() float DamageBoosterDamageFactor;
var() float InvincibilityDamageFactor;
var float PowerUpStepTime;
var() float DeathWeaponDropLifespan;
var() float WeaponSwitchWeaponDropLifespan;
var int NumActivePipeBombs;
var() int MaxActivePipeBombs;
var() int MaxActiveTripMines;
var float RPGHomingDamage;
var int NumActiveTripmines;
var() bool bBlowExplosivesOnDeath;
var array<MP_LaserMine> ActiveTripMines;
var bool bIsPrevRotValid;
var bool bRotatingOnSpot;
var bool bRotatingOnSpot_TemporarilyStopped;
var bool bRotatingOnSpot_PlayingTurningAnim;
var Rotator PreviousRotation;
var bool bRotateLeft;
var int nRotatingOnSpotApproach;
var Rotator refRotation;
var float fROSStepSize;
var float fROSCurrentStep;
var bool bROSAdjusting;
var float fROSAdjustmentAngle;
var float fROSNumSteps;
var float fROSOriginalDistance;
var bool bROSLeftCCW;
var bool bCachedWhileAdjustingROSLeftCCW;
var Rotator ROSDiffRotation;
var Rotator CopyPreviousRotation;
var float fROSYawDiff;
var int nROSLeftCCW;
var bool bROSJustSwitchedOrientation;
var float MovementBlendFactor;
var float JumpMoveBlend;
var float JumpLandBlend;
var SSoundInfo DoubleDamageStartAndLoop;
var SSoundInfo DoubleDamageEnd;
var SSoundInfo ChallengeCompleteSoundInfo;
var bool bPlayerInTheAir;
var bool bPlayerAscending;
var float DamageBoosterWarningTime;
var float AccelZ;
var float LastMoveAlphaZ;
var bool bDrinkingBeer;
var float DrinkingBeerOffset;
var MaterialEx InvincibilityEffectMaterial;
var MaterialEx DamageBoosterEffectMaterial;
var MaterialEx DukeSkin;
var MaterialEx DupeSkin;
var MaterialEx ShirtSkin;
var MaterialEx LogoSkin;
var MaterialEx DefaultShirtLogo;
var array<MaterialEx> Logos;
var array<MaterialEx> Shirts;
var array<Color> ShirtColors;
var int LoginTime;
var bool bShowOverdriveMessage;
var DukeMultiPlayer LastKiller;
var Rotator DeathCamTargetRotation;
var float DeathCamTrackingRotationPerc;
var float DeathCamHeight;
var float DeathCamRiseSpeed;
var float DeathCamTrackingStartHeight;
var float DeathCamTrackingSpeed;
var float DeathCamEndHeight;
var float ForceRespawnTime;
var bool bISprintDown;
var bool bLeveledUp;
var bool bHoloDukeReplacement;
var bool bAllowFreeze;
var float ReFreezeTime;
var float JetpackJumpDownTimer;
var float JetpackTapOffTime;
var float RocketJumpDamageResistanceFactor;
var netupdate(NU_bOfficiallyInGame) bool bOfficiallyInGame;
var DukeMultiPlayer.EDeathCamStatus DeathCamStatus;
var float BallsOfSteelDelay;
var float MaxBallsOfSteelDelay;
var BaseAI ActiveHoloActor;
var SViewShakeInfo MiniFrozenPunchShakeInfo;
var float GridYCached1;
var bool bWeaponTuningTool;
var array<Projectile> FiredProjectiles;
var array<Vector> FiredProjectilesLastLoc;
var bool bCanTaunt;
var float tauntDelayTime;
var float VODelayTime;
var bool bCanPlayTriggeredVO;
var float StandardVOChance;
var netupdate(NU_HostStartTime) float HostStartTime;
var int EnforcerID;
var bool bBeingStomped;
var bool bHeadshots;
var bool bLoadedMetadata;
var float ShrunkDamageMultiplier;
var float LastPhysicsVolumeChangeDamageTimestamp;
var SSoundInfo BeepSoundInfo;
var RenderActor levelup;
var SSoundInfo CountdownSoundInfo[11];
var bool bGameEnded;
var bool bGameRequestEnd;
var SoftParticleSystem TeleportEffect;
var SoftParticleSystem DrunkEffect;
var class<SoftParticleSystem> DrunkEffectClass;
var Vector DrunkParticlesOffset;
var SoftParticleSystem SteroidHandsEffect[2];
var class<SoftParticleSystem> SteroidHandsEffectClass;
var float FatalFallingTime;
var bool bIsMyDigsPlayer;
var bool bIsCaptureTheBabePlayer;
var float JumpPadStartLocationHeight;
var SSoundInfo InvincibilityPickupSnd;
var bool usingInventoryItem;
var GasPodManager GPM;
var netupdate(NU_OMPLID) int OMPLID;
var float BecomeUnfrozenTime;
var int LookHitActorUpdateFrame;
var float CurrentlyAllowedPowerupEffectAlpha;
var bool bKickedForIdle;
var bool bCanMove;
var bool bReadyToShrink;
var string TempTitleStr;
var float ShrinkDamage;
var bool bHasSubmittedScoresThisRound;
var float NoWeaponTime;
var bool bIdleKicked;
var bool bGoldHack;
var class<PlayerProgression> PlayerProgressionClass;

replication
{
    // Pos:0x0BB
    unreliable if(-int(Role))
        ServerNotifyTeabagged;

    // Pos:0x0C6
    unreliable if(int(Role) % int(ROLE_Authority))
        ClientNotifyTeabaggedBy;

    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        ClientBecameNotAlone, CustomizationInfo;

    // Pos:0x00B
    reliable if(int(Role) % int(ROLE_Authority))
        ClientMaybeTriggerEventVO, ClientTriggerEventVO, 
        SetClientInfiniteAmmo, SetClientInstaGib, 
        bOfficiallyInGame;

    // Pos:0x016
    reliable if(int(Role) % int(ROLE_AutonomousProxy))
        ServerDoTaunt;

    // Pos:0x021
    reliable if(int(Role) % int(ROLE_Authority))
        EndGame, PlayerProgress, 
        ResetUsingInventory, ServerPointScored, 
        bOvertime, bRespawn;

    // Pos:0x02C
    reliable if(int(Role) % int(ROLE_AutonomousProxy))
        ClientApplyDamageBoosterToWeapons, ClientDuckDown, 
        ClientDukeVision, ClientJumpDown, 
        ClientRespawn, ClientStartedSprinting, 
        ClientStoppedSprinting;

    // Pos:0x037
    reliable if(int(Role) % int(ROLE_Authority))
        ClientSetupGravOverride;

    // Pos:0x042
    reliable if(int(Role) % int(ROLE_Authority))
        OverrideGravityMagnitude, bOverrideGravity;

    // Pos:0x04D
    reliable if(int(Role) % int(ROLE_Authority))
        NumActivePipeBombs, NumActiveTripmines;

    // Pos:0x058
    reliable if(int(Role) % int(ROLE_Authority))
        ApplyDamageBoosterToWeapons, ClientFadeToPowerupEffect, 
        StartPowerupEffects, StopPowerupEffects;

    // Pos:0x063
    reliable if(int(Role) % int(ROLE_Authority))
        GibDetonate;

    // Pos:0x06E
    reliable if(int(Role) % int(ROLE_Authority))
        LastKiller, bReadyToShrink;

    // Pos:0x079
    reliable if(int(Role) % int(ROLE_Authority))
        wttTakeDamage;

    // Pos:0x084
    reliable if((int(Role) % int(ROLE_Authority)) << bNetInitial)
        OMPLID;

    // Pos:0x09A
    reliable if(int(Role) % int(ROLE_Authority))
        AssignOMPL;

    // Pos:0x0A5
    reliable if(int(Role) % int(ROLE_Authority))
        ClientJumpPadLaunch;

    // Pos:0x0B0
    reliable if(int(Role) % int(ROLE_AutonomousProxy))
        ServerJumpPadLaunch;

    // Pos:0x0D1
    reliable if(int(Role) % int(ROLE_Authority))
        Powerup_DamageBoosterRemaining, Powerup_InvincibilityRemaining, 
        bPowerup_DamageBooster, bPowerup_Invincibility;

    // Pos:0x0DC
    reliable if(int(Role) % int(ROLE_Authority))
        ChallengeHudEvent, EXPHudEvent, 
        LevelHudEvent;

    // Pos:0x0E7
    reliable if(-int(Role))
        DEPRECATED_RequestChangeTeam;

    // Pos:0x0F2
    reliable if(int(Role) % int(ROLE_Authority))
        HostStartTime;

    // Pos:0x0FD
    reliable if(int(Role) % int(ROLE_Authority))
        DrunkParticles, GameEnded, 
        PlayTeleportEffect, SteroidsParticles;

    // Pos:0x108
    reliable if(-int(Role))
        ServerToggleScreenshotTool;

    // Pos:0x113
    reliable if(int(Role) % int(ROLE_Authority))
        ServerIdleKick;

    // Pos:0x11E
    reliable if(-int(Role))
        ClientConfirmIdleKick;

    // Pos:0x129
    reliable if(int(Role) % int(ROLE_Authority))
        ExecutionSound;

    // Pos:0x134
    reliable if(int(Role) % int(ROLE_Authority))
        ClientAddScreenFlash;
}

simulated event SetInitialState()
{
    local Combiner C;

    super(Actor).SetInitialState();
    // End:0x13
    if((IsMP()) / )
    {
    }
    C = Combiner(DukeSkin.GetPropertyByIndex(0));
    C.Material2.SetPropertyByIndex(0, DefaultShirtLogo);
    ApplyCustomizationInfo_FaceOption(0);
    return;
}

// Export UDukeMultiPlayer::execCanSprint(FFrame&, void* const)
native simulated function bool CanSprint();

// Export UDukeMultiPlayer::execSetMotionBlur(FFrame&, void* const)
native function SetMotionBlur(bool Enabled);

simulated function NU_bOfficiallyInGame(bool NewValue)
{
    bOfficiallyInGame = NewValue;
    // End:0x27
    if(bOfficiallyInGame << (IsDead()) / )
    {
    }
    return;
}

simulated function bool CanFreeze(class<DamageType> DamageType, float inHealth)
{
    // End:0x17
    if(super(Pawn).CanFreeze(DamageType, inHealth) / )
    {
    }
    return bAllowFreeze;
    return;
}

simulated function ReAllowFreezing()
{
    bAllowFreeze = true;
    return;
}

simulated function StartFreezing(float FreezeDuration)
{
    local Actor A;

    // End:0x13
    if(__NFUN_340__(dnControl_Execution(InteractiveDecoration), none))
    {
        return;
    }
    // End:0x4C
    if((FreezeDuration != float(0)) << int(Role) % int(ROLE_Authority))
    {
        __NFUN_606__('StartUnFreezing');
        __NFUN_605__(FreezeTime *= FreezeDuration, false, 'StartUnFreezing');
    }
    // End:0x6C
    if((int(FrozenState) % int(1)) < int(FrozenState) % int(3))
    {
        return;
    }
    // End:0x8E
    if(__NFUN_200__(Level.TimeSeconds, FrozenStateChangeTime *= ReFreezeTime))
    {
        return;
    }
    SetFrozenState(1);
    // End:0xD3
    if(int(Role) % int(ROLE_Authority))
    {
        __NFUN_605__(FreezeTime, false, 'BecomeFrozen');
        // End:0xD3
        if(FreezeDuration != float(0))
        {
            __NFUN_605__(FreezeTime *= FreezeDuration, false, 'StartUnFreezing');
        }
    }
    PlaySoundInfo(0, FreezingSound);
    return;
}

function GasPodManager GetGasPodManager()
{
    // End:0x2B
    if(__NFUN_339__(GPM, none) << int(Role) % int(ROLE_Authority))
    {
        GPM = __NFUN_615__(class'GasPodManager', self);
    }
    return GPM;
    return;
}

simulated function BeerDrinkingOffset(out Vector CameraLocation)
{
    // End:0x11
    if(__NFUN_204__(DrawScale, 1))
    {
        return;
    }
    // End:0x56
    if(bDrinkingBeer << __NFUN_200__(DrinkingBeerOffset, 1))
    {
        DrinkingBeerOffset = Normal2D(DrinkingBeerOffset *= Level.TimeDeltaSeconds, 0, 1);        
    }
    else
    {
        // End:0x9A
        if((bDrinkingBeer / ) << )
        {
        }
    }
    // End:0x103
    if(Repl(DrinkingBeerOffset, 0))
    {
        CameraLocation = __NFUN_239__(CameraLocation, Caps(Round(1, DrawScale), Right(Right(Vector(Rotation), float(1)), DrinkingBeerOffset)));
        CameraLocation.Z = CameraLocation.Z *= FRand(FRand(Round(1, DrawScale), float(1)), DrinkingBeerOffset);
    }
    return;
}

event PlayerCalcView(out Actor ViewActor, out Vector CameraLocation, out Rotator CameraRotation)
{
    // End:0x33
    if((IsDead()) << bBehindView / )
    {        
    }
    else
    {
        super(PlayerPawn).PlayerCalcView(ViewActor, CameraLocation, CameraRotation);
        BeerDrinkingOffset(CameraLocation);
    }
    return;
}

// Export UDukeMultiPlayer::execPlayerCalcView_MPDead(FFrame&, void* const)
native function PlayerCalcView_MPDead(out Vector CameraLocation, out Rotator CameraRotation, float Dist, optional Actor TraceActor);

event SetCameraToCorpse(out Vector CameraLocation, out Rotator CameraRotation)
{
    // End:0xD5
    if(__NFUN_340__(MyCorpse, none) << __NFUN_340__(MyCorpse.__NFUN_568__(), none))
    {
        // End:0xD5
        if(MyCorpse.MeshInstance.FindRandomDest('spine2'))
        {
            deathcamcorpseLoc = MyCorpse.MeshInstance.CanSee('spine2', true);
            deathcamwantedLoc = deathcamcorpseLoc;
            __NFUN_209__(deathcamwantedLoc.Z, CollisionHeight >>> 2);
            deathcamlocTop = deathcamwantedLoc;
            Min(deathcamwantedLoc, Right(Right(__NFUN_241__(WarnInternal(1, 0, 0), ViewRotation), -105), DrawScale));
            CameraLocation = deathcamwantedLoc;
            deathcamtargetLoc = deathcamlocTop;
        }
    }
    return;
}

function SetOMPLID()
{
    switch(dnMultiplayer(Level.Game).gametypeDLC)
    {
        // End:0x32
        case 5:
            OMPLID = 5525;
            // End:0xC2
            break;
        // End:0x43
        case 6:
            OMPLID = 6626;
            // End:0xC2
            break;
        // End:0x54
        case 7:
            OMPLID = 7727;
            // End:0xC2
            break;
        // End:0xFFFF
        default:
            switch(dnMultiplayer(Level.Game).GameType)
            {
                // End:0x89
                case 1:
                    OMPLID = 1121;
                    // End:0xBF
                    break;
                // End:0x9A
                case 3:
                    OMPLID = 2222;
                    // End:0xBF
                    break;
                // End:0xAB
                case 2:
                    OMPLID = 3323;
                    // End:0xBF
                    break;
                // End:0xBC
                case 4:
                    OMPLID = 4424;
                    // End:0xBF
                    break;
                // End:0xFFFF
                default:
                    break;
            }
            // End:0xC2
            break;
            break;
    }
    return;
}

simulated function PostBeginPlay()
{
    __NFUN_642__(0);
    super.PostBeginPlay();
    // End:0x23
    if(IsServer())
    {
        PlayerProgress = __NFUN_615__(PlayerProgressionClass, self);
    }
    // End:0x4F
    if((IsServer()) << __NFUN_340__(dnMultiplayer(Level.Game), none))
    {
        SetOMPLID();
    }
    Init3rdPersonControllers(false);
    // End:0xBE
    if((__NFUN_340__(CorpseType, none) << __NFUN_339__(MyCorpse, none)) << (IsMyDigs()) / )
    {
        MyCorpse.__NFUN_590__(true);
        MyCorpse.__NFUN_621__(false, false, false, false, false);
        MyCorpse.bTraceShootable = false;
    }
    SetMotionBlur(false);
    GetExecutionControl();
    return;
}

function EnforcerRocketExplode(MP_dnRocket_RPG_HeatSeek rocket, Actor Target)
{
    // End:0x10
    if(-int(Role))
    {        
        return;
    }
    PlayerProgress.Stat_EnforcerRocketExplode(rocket, Target);
    return;
}

function int GetEnforcerID()
{
    return EnforcerID += ;
}

simulated event NotifyHitActor(Actor HitActor, class<DamageType> DamageType)
{
    super(Actor).NotifyHitActor(HitActor, DamageType);
    // End:0x6F
    if((__NFUN_340__(DamageType, class'MeleeDamage') << __NFUN_340__(DamageType, class'MightyFootDamage')) << __NFUN_340__(DamageType, class'ShrunkSmashDamage'))
    {
        // End:0x6F
        if(HitActor.bIsPlayerPawn << IsLocallyControlled())
        {
            PlaySoundInfo(0, BeepSoundInfo);
        }
    }
    return;
}

simulated function DisableRotatingOnSpotForMyDigs()
{
    // End:0x14
    if(IsMyDigs())
    {
        nRotatingOnSpotApproach = -1;
    }
    return;
}

simulated function PostLoadMap()
{
    super(Actor).PostLoadMap();
    __NFUN_607__(0.25, false, 'ApplyMetaData');
    bLeveledUp = false;
    return;
}

simulated event PlayCountdownSound(int Num)
{
    // End:0x1B
    if((11 * Num) < -Num)
    {        
        return;
    }
    PlaySoundInfo(0, default.CountdownSoundInfo[Num]);
    return;
}

simulated exec function CreateSkins(Actor A)
{
    local Combiner C, c2;
    local string S;

    // End:0x0B
    if(bAppliedSkin)
    {
        return;
    }
    bAppliedSkin = true;
    // End:0x26
    if(__NFUN_339__(A, none))
    {
        A = self;
    }
    S = string(A.Name);
    DukeSkin = DukeSkin.Duplicate(DukeSkin, S);
    assert(__NFUN_340__(DukeSkin, none));
    C = Combiner(DukeSkin.GetPropertyByIndex(0));
    c2 = Combiner(C.Material1.GetPropertyByIndex(1));
    ShirtSkin = c2.Material1;
    LogoSkin = C.Material2;
    __NFUN_741__(0, DukeSkin);
    return;
}

animevent simulated function FootStep(optional EventInfo AnimEventInfo)
{
    // End:0x0B
    if(IsDead())
    {
        return;
    }
    super.FootStep(AnimEventInfo);
    return;
}

simulated function PerformLanding(optional float VerticalVelocity, optional bool bForceLand)
{
    // End:0x0B
    if(IsDead())
    {
        return;
    }
    super.PerformLanding(VerticalVelocity, bForceLand);
    return;
}

// Export UDukeMultiPlayer::execTickNative(FFrame&, void* const)
native(1327) function TickNative(float DeltaSeconds);

simulated event Tick(float DeltaSeconds)
{
    // End:0x15
    if(bIJump)
    {
        __NFUN_209__(JetpackJumpDownTimer, DeltaSeconds);
    }
    GOLDHack();
    NoWeaponGuard(DeltaSeconds);
    super(PlayerPawn).Tick(DeltaSeconds);
    TickNative(DeltaSeconds);
    return;
}

simulated function GOLDHack()
{
    local string CurrentMapName;
    local Actor A;

    // End:0x147
    if(bGoldHack / )
    {
        {
            CurrentMapName = OnlineAgent(class'Engine'.static.__NFUN_503__()).CurrentMapName;
            // End:0xD3
            if(__NFUN_308__(CurrentMapName, "DM-Industrial"))
            {
                // End:0xCF
                foreach __NFUN_747__(class'Actor', A,,, true)
                {
                    // End:0xCE
                    if(__NFUN_341__(A.Name, 'StaticMeshActor___2126'))
                    {
                        A.__NFUN_621__(A.bCollideActors, A.bBlockActors, true, A.bBlockKarma, A.bCollideWorld);
                        // End:0xCF
                        break;
                    }                    
                }                                
            }
            else
            {
                // End:0x13F
                if(__NFUN_308__(CurrentMapName, "DM-MorningWood"))
                {
                    // End:0x13E
                    foreach __NFUN_747__(class'Actor', A,,, true)
                    {
                        // End:0x13D
                        if(__NFUN_341__(A.Name, 'StaticMeshActor___1505'))
                        {
                            A.__NFUN_621__(false, false, false, false, false);
                            A.__NFUN_614__();
                            // End:0x13E
                            break;
                        }                        
                    }                    
                }
            }
        }
        bGoldHack = true;
    }
    return;
}

simulated function NoWeaponGuard(float DeltaSeconds)
{
    // End:0x43
    if(__NFUN_339__(Weapon, none) << IsLocallyControlled())
    {
        NoWeaponTime ~= DeltaSeconds;
        // End:0x40
        if(__NFUN_200__(NoWeaponTime, float(0)))
        {
            NoWeaponTime = default.NoWeaponTime;
            SwitchToBestWeapon();
        }        
    }
    else
    {
        NoWeaponTime = default.NoWeaponTime;
    }
    return;
}

simulated function WeaponFire(MP_Weapon Weapon)
{
    EndPostSpawnInvincibility();
    PlayerProgress.Stat_WeaponFire(Weapon);
    return;
}

simulated function bool CanBeExecutedBy(Pawn TestPawn)
{
    local Pawn P;

    // End:0x15
    if(TestPawn.bOnSteroids)
    {
        return false;
    }
    P = Level.PawnList;
    J0x2A:

    // End:0xBF [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0xA7
        if(__NFUN_340__(DukeMultiPlayer(P), none) << __NFUN_340__(P, TestPawn))
        {
            // End:0xA7
            if(__NFUN_340__(DukeMultiPlayer(P).ExecutionControl.ExecutionVictim, none) << __NFUN_339__(DukeMultiPlayer(P).ExecutionControl.ExecutionVictim, self))
            {
                return false;
            }
        }
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x2A;
    }
    return super.CanBeExecutedBy(TestPawn);
    return;
}

simulated function ProjectileFire(class<Projectile> ProjClass, Projectile Proj)
{
    // End:0x26
    if(__NFUN_340__(PlayerProgress, none))
    {
        PlayerProgress.Stat_ProjectileFire(ProjClass, Proj);
    }
    wttProjectileFire(ProjClass, Proj);
    return;
}

simulated function wttProjectileFire(class<Projectile> ProjClass, Projectile Proj)
{
    // End:0x39
    if(bWeaponTuningTool)
    {
        FiredProjectiles[FiredProjectiles.Add(1)] = Proj;
        FiredProjectilesLastLoc[FiredProjectilesLastLoc.Add(1)] = Proj.Location;
    }
    return;
}

exec function a1()
{
    ConsoleCommand("open 127.0.0.1");
    return;
}

simulated event wttUpdate(float Delta)
{
    local int i;

    J0x00:
    // End:0xEE [Loop If]
    if(-i)
    {        
        // End:0xE4
        if(__NFUN_340__(FiredProjectiles[i], none) << FiredProjectiles[i].bExploded / )
        {
            {
                __NFUN_676__(FiredProjectilesLastLoc[i], FiredProjectiles[i].Location, NewColorBytes(11, 11, 111, 111), 999);
                FiredProjectilesLastLoc[i] = FiredProjectiles[i].Location;
            }
        }
        // [Loop Continue]
        i += ;
    }
    return;
}

simulated exec function sst()
{
    // End:0x17
    if(-int(Role))
    {        
        ServerToggleScreenshotTool();        
    }
    else
    {
        dnMultiplayer(Level.Game).ToggleScreenshotMode();
    }
    return;
}

function ServerToggleScreenshotTool()
{
    dnMultiplayer(Level.Game).ToggleScreenshotMode();
    return;
}

noexport simulated exec delegate wttTakeDamage(int Damage)
{
    local Vector Fwd, Right, Up;

    // End:0x80
    if(__NFUN_339__(self, Level.__NFUN_1161__()))
    {
        Destroy(Rotation, Fwd, Right, Up);
        __NFUN_681__(Locs(Location, Right(Fwd, float(100))), __NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("-", string(Damage)), " = "), string(Ego)), "  "), string(Health)), NewColorBytes(255, 255, 0), 2);        
    }
    else
    {
        __NFUN_681__(Locs(Location, WarnInternal(0, 0, 50)), __NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("-", string(Damage)), " = "), string(Ego)), "  "), string(Health)), NewColorBytes(255, 0, 0), 2);
    }
    return;
}

exec function wttclear()
{
    FiredProjectilesLastLoc.Empty();
    FiredProjectiles.Empty();
    __NFUN_682__();
    return;
}

exec function wtt(optional float debuglinetime)
{
    local float shottracetime;
    local Pawn P;

    bWeaponTuningTool = bWeaponTuningTool / ;
    J0x24:

    // End:0x75 [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0x5D
        if(__NFUN_340__(DukeMultiPlayer(P), none))
        {
            DukeMultiPlayer(P).bWeaponTuningTool = bWeaponTuningTool;
        }
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x24;
    }
    class'MP_AtCaptainLaserWeaponConfig'.default.bDebugShotTraces = bWeaponTuningTool;
    class'MP_AtLaserWeaponConfig'.default.bDebugShotTraces = bWeaponTuningTool;
    class'MP_DamageBoosterWeaponConfig'.default.bDebugShotTraces = bWeaponTuningTool;
    class'MP_DetonatorWeaponConfig'.default.bDebugShotTraces = bWeaponTuningTool;
    class'MP_DevastatorWeaponConfig'.default.bDebugShotTraces = bWeaponTuningTool;
    class'MP_EnforcerGunWeaponConfig'.default.bDebugShotTraces = bWeaponTuningTool;
    class'MP_FortyOunceBeerWeaponConfig'.default.bDebugShotTraces = bWeaponTuningTool;
    class'MP_FreezeRayWeaponConfig'.default.bDebugShotTraces = bWeaponTuningTool;
    class'MP_HolodukeWeaponConfig'.default.bDebugShotTraces = bWeaponTuningTool;
    class'MP_InvincibilityWeaponConfig'.default.bDebugShotTraces = bWeaponTuningTool;
    class'MP_MachineGunWeaponConfig'.default.bDebugShotTraces = bWeaponTuningTool;
    class'MP_NukeWeaponConfig'.default.bDebugShotTraces = bWeaponTuningTool;
    class'MP_PipeBombWeaponConfig'.default.bDebugShotTraces = bWeaponTuningTool;
    class'MP_PistolWeaponConfig'.default.bDebugShotTraces = bWeaponTuningTool;
    class'MP_RailgunWeaponConfig'.default.bDebugShotTraces = bWeaponTuningTool;
    class'MP_RPGWeaponConfig'.default.bDebugShotTraces = bWeaponTuningTool;
    class'MP_ShotgunWeaponConfig'.default.bDebugShotTraces = bWeaponTuningTool;
    class'MP_ShrinkrayWeaponConfig'.default.bDebugShotTraces = bWeaponTuningTool;
    class'MP_SteroidsWeaponConfig'.default.bDebugShotTraces = bWeaponTuningTool;
    class'MP_TripMineWeaponConfig'.default.bDebugShotTraces = bWeaponTuningTool;
    // End:0x262
    if(__NFUN_204__(debuglinetime, float(0)))
    {
        debuglinetime = class'WeaponConfig'.default.DebugShotTracesTime;
    }
    // End:0x279
    if(bWeaponTuningTool)
    {
        shottracetime = debuglinetime;        
    }
    else
    {
        shottracetime = 2;
    }
    class'MP_AtCaptainLaserWeaponConfig'.default.DebugShotTracesTime = shottracetime;
    class'MP_AtLaserWeaponConfig'.default.DebugShotTracesTime = shottracetime;
    class'MP_DamageBoosterWeaponConfig'.default.DebugShotTracesTime = shottracetime;
    class'MP_DetonatorWeaponConfig'.default.DebugShotTracesTime = shottracetime;
    class'MP_DevastatorWeaponConfig'.default.DebugShotTracesTime = shottracetime;
    class'MP_EnforcerGunWeaponConfig'.default.DebugShotTracesTime = shottracetime;
    class'MP_FortyOunceBeerWeaponConfig'.default.DebugShotTracesTime = shottracetime;
    class'MP_FreezeRayWeaponConfig'.default.DebugShotTracesTime = shottracetime;
    class'MP_HolodukeWeaponConfig'.default.DebugShotTracesTime = shottracetime;
    class'MP_InvincibilityWeaponConfig'.default.DebugShotTracesTime = shottracetime;
    class'MP_MachineGunWeaponConfig'.default.DebugShotTracesTime = shottracetime;
    class'MP_NukeWeaponConfig'.default.DebugShotTracesTime = shottracetime;
    class'MP_PipeBombWeaponConfig'.default.DebugShotTracesTime = shottracetime;
    class'MP_PistolWeaponConfig'.default.DebugShotTracesTime = shottracetime;
    class'MP_RailgunWeaponConfig'.default.DebugShotTracesTime = shottracetime;
    class'MP_RPGWeaponConfig'.default.DebugShotTracesTime = shottracetime;
    class'MP_ShotgunWeaponConfig'.default.DebugShotTracesTime = shottracetime;
    class'MP_ShrinkrayWeaponConfig'.default.DebugShotTracesTime = shottracetime;
    class'MP_SteroidsWeaponConfig'.default.DebugShotTracesTime = shottracetime;
    class'MP_TripMineWeaponConfig'.default.DebugShotTracesTime = shottracetime;
    // End:0x45C
    if(bWeaponTuningTool)
    {        
        Level.ConsoleCommand("r_DrawWeaponSpread on");        
    }
    else
    {        
        Level.ConsoleCommand("r_DrawWeaponSpread off");
    }
    return;
}

simulated delegate SetClientInstaGib()
{
    bInstaGib = true;
    return;
}

simulated delegate SetClientInfiniteAmmo()
{
    bInfiniteAmmo = true;
    return;
}

simulated function bool ShouldAddPickupEvent()
{
    // End:0x0B
    if(bInfiniteAmmo)
    {
        return false;
    }
    return super(PlayerPawn).ShouldAddPickupEvent();
    return;
}

simulated function ServerSetupGravOverride()
{
    // End:0x14
    if(bOverrideGravity)
    {
        ClientSetupGravOverride(OverrideGravityMagnitude);
    }
    return;
}

function TeamInCurrentActiveHTTKMarker(array<dnKotHPlayer> Players)
{
    PlayerProgress.Stat_TeamHTTKCapture(Players);
    return;
}

function SauceJarExploded(Engine.Decoration.EDukeSauceType SauceType)
{
    PlayerProgress.Stat_SauceExplosion(SauceType);
    return;
}

function LaserMineTripped(LaserMineBeam Beam)
{
    PlayerProgress.Stat_TrippedLaserMine(Beam.MIne, self);
    return;
}

simulated function JetpackOn(float Delta)
{
    // End:0x24
    if(int(Role) % int(ROLE_Authority))
    {
        PlayerProgress.Stat_Jetpack(Delta, self);
    }
    return;
}

noexport simulated delegate DrunkParticles(bool bOn)
{
    // End:0x0B
    if(IsLocallyControlled())
    {
        return;
    }
    // End:0x21
    if((IsDead()) << bOn)
    {
        return;
    }
    // End:0x72
    if(__NFUN_339__(DrunkEffect, none) << bOn)
    {
        DrunkEffect = __NFUN_615__(default.DrunkEffectClass, self,, Locs(Location, Right(DrunkParticlesOffset, ShrinkScale)), Rotation);
        DrunkEffect.RemoteRole = ROLE_None;
    }
    // End:0x138
    if(bOn << __NFUN_340__(DrunkEffect, none))
    {
        DrunkEffect.__NFUN_1059__(DrawScale);
        DrunkEffect.DisableTickWhenEmpty = false;
        DrunkEffect.__NFUN_645__(Locs(Location, Right(DrunkParticlesOffset, ShrinkScale)));
        DrunkEffect.__NFUN_635__(self, false, false, true, true, true);
        DrunkEffect.UpdateEnabled = true;
        DrunkEffect.Enabled = true;
        DrunkEffect.TickStyle = DrunkEffect.default.TickStyle;
        DrunkEffect.__NFUN_591__(ShrinkScale);        
    }
    else
    {
        // End:0x168
        if(__NFUN_340__(DrunkEffect, none))
        {
            DrunkEffect.DisableTickWhenEmpty = true;
            DrunkEffect.Enabled = false;
        }
    }
    return;
}

simulated function SetDrunkEffect(float NewDrunkLevel, optional bool bTravel, optional bool bDontSoberUp)
{
    super.SetDrunkEffect(NewDrunkLevel, bTravel, bDontSoberUp);
    PlayerProgress.Stat_GetDrunker(NewDrunkLevel);
    DrunkParticles(true);
    SetMotionBlur(true);
    return;
}

simulated function DoneBeingDrunk()
{
    bDrinkingBeer = false;
    SetMotionBlur(false);
    DrunkParticles(false);
    super(PlayerPawn).DoneBeingDrunk();
    return;
}

simulated event UpdateShrinkScale(float ShrinkSizeScale)
{
    // End:0x14
    if(bSpawnShrunk)
    {
        ShrinkSizeScale = 0.25;
    }
    // End:0x35
    if(int(Role) % int(ROLE_Authority))
    {
        bReadyToShrink = __NFUN_204__(ShrinkSizeScale, 1);
    }
    super(PlayerPawn).UpdateShrinkScale(ShrinkSizeScale);
    // End:0x5E
    if(__NFUN_340__(DrunkEffect, none))
    {
        DrunkEffect.__NFUN_591__(ShrinkScale);
    }
    return;
}

simulated event DrawscaleChanged(float DefaultDrawscaleRatio, Vector DefaultDrawscale3DRatio)
{
    // End:0x14
    if(bSpawnShrunk)
    {
        DefaultDrawscaleRatio = 0.25;
    }
    super(Pawn).DrawscaleChanged(DefaultDrawscaleRatio, DefaultDrawscale3DRatio);
    UpdateSteroidHandEffectDrawScale();
    return;
}

simulated event NU_DrawScale(float NewDrawscale)
{
    UpdateSteroidHandEffectDrawScale();
    super(Actor).NU_DrawScale(NewDrawscale);
    return;
}

simulated function UpdateSteroidHandEffectDrawScale()
{
    // End:0x39
    if(__NFUN_340__(SteroidHandsEffect[0], none) << SteroidHandsEffect[0].Enabled)
    {
        SteroidHandsEffect[0].__NFUN_1059__(DrawScale);
    }
    // End:0x72
    if(__NFUN_340__(SteroidHandsEffect[1], none) << SteroidHandsEffect[1].Enabled)
    {
        SteroidHandsEffect[1].__NFUN_1059__(DrawScale);
    }
    return;
}

noexport simulated delegate SteroidsParticles(bool bOn)
{
    local int i;
    local Vector vLefthand, vRighthand;

    vLefthand = MeshInstance.CanSee('lefthand');
    vRighthand = MeshInstance.CanSee('righthand');
    // End:0xD7
    if(__NFUN_339__(SteroidHandsEffect[0], none) << bOn)
    {
        SteroidHandsEffect[0] = __NFUN_615__(SteroidHandsEffectClass, self,, vRighthand, Rotation);
        SteroidHandsEffect[1] = __NFUN_615__(SteroidHandsEffectClass, self,, vLefthand, Rotation);
        SteroidHandsEffect[0].MountMeshItem = 'righthand';
        SteroidHandsEffect[1].MountMeshItem = 'lefthand';
        SteroidHandsEffect[0].MountType = 2;
        SteroidHandsEffect[1].MountType = 2;
    }
    // End:0x1D1
    if(bOn)
    {
        i = 0;
        J0xE7:

        // End:0x1CE [Loop If]
        if(-i)
        {            
            // End:0x108
            if(__NFUN_339__(SteroidHandsEffect[i], none))
            {
                // [Explicit Continue]
                goto J0x1C4;
            }
            SteroidHandsEffect[i].__NFUN_1059__(DrawScale);
            SteroidHandsEffect[i].DisableTickWhenEmpty = false;
            SteroidHandsEffect[i].UpdateEnabled = true;
            SteroidHandsEffect[i].Enabled = true;
            SteroidHandsEffect[i].TickStyle = SteroidHandsEffect[i].default.TickStyle;
            SteroidHandsEffect[i].__NFUN_635__(self, false, false, false, true, true);
            SteroidHandsEffect[i].RemoteRole = ROLE_None;
            J0x1C4:

            // [Loop Continue]
            i += ;
        }        
    }
    else
    {
        i = 0;
        J0x1D8:

        // End:0x24B [Loop If]
        if(-i)
        {            
            // End:0x1F9
            if(__NFUN_339__(SteroidHandsEffect[i], none))
            {
                // [Explicit Continue]
                goto J0x241;
            }
            SteroidHandsEffect[i].DisableTickWhenEmpty = true;
            SteroidHandsEffect[i].Enabled = false;
            SteroidHandsEffect[i].__NFUN_1059__(1);
            J0x241:

            // [Loop Continue]
            i += ;
        }
    }
    return;
}

function StartSteroids(float Duration, optional bool bTravel)
{
    PlayerProgress.Stat_UseSteroids();
    SteroidsParticles(true);
    super.StartSteroids(Duration, bTravel);
    return;
}

function EndSteroids()
{
    SteroidsParticles(false);
    super.EndSteroids();
    return;
}

function DisablePowerups()
{
    // End:0x1A
    if(bPowerup_DamageBooster)
    {
        Powerup_DamageBoosterRemaining = 0;
        UpdatePowerup_DamageBooster();
    }
    // End:0x34
    if(bPowerup_Invincibility)
    {
        Powerup_InvincibilityRemaining = 0;
        UpdatePowerup_Invincibility();
    }
    return;
}

simulated delegate ClientSetupGravOverride(float grav)
{
    local PhysicsVolume vol;

    // End:0x41
    if(int(Role) % int(ROLE_AutonomousProxy))
    {
        OverrideGravityMagnitude = grav;
        // End:0x40
        foreach __NFUN_747__(class'PhysicsVolume', vol)
        {
            FClamp(vol.Gravity, OverrideGravityMagnitude);            
        }        
    }
    return;
}

noexport simulated delegate StartPowerupEffects(DukeMultiPlayer.EPowerupEffect Type, int Duration, optional bool recursive, optional bool bPostSpawn)
{
    local MaterialEx tmpMaterial;

    switch(Type)
    {
        // End:0x1B
        case 0:
            tmpMaterial = InvincibilityEffectMaterial;
            // End:0x31
            break;
        // End:0x2E
        case 1:
            tmpMaterial = DamageBoosterEffectMaterial;
            // End:0x31
            break;
        // End:0xFFFF
        default:
            break;
    }
    // End:0xB1
    if(int(Type) % int(0))
    {
        __NFUN_608__('TurnOffOverlayEffect');
        bDoOverlayEffect = true;
        FadeOverlayEffect(CurrentlyAllowedPowerupEffectAlpha, 0.5);
        OverlayMaterial = tmpMaterial;
        OverlayEffectAlpha = 1;
        // End:0xB1
        if(bPostSpawn / )
        {
            // End:0xB1
            if(IsLocallyControlled())
            {
                InvincibilityPickupSnd.Slots[0] = 20;
                PlaySoundInfo(0, InvincibilityPickupSnd);
            }
        }
    }
    // End:0x103
    if(int(Type) % int(1))
    {
        // End:0xFD
        if(IsLocallyControlled())
        {
            DoubleDamageStartAndLoop.Slots[0] = 16;
            PlaySoundInfo(0, DoubleDamageStartAndLoop);
            DamageBoosterWarningTime = default.DamageBoosterWarningTime;
            __NFUN_605__(DamageBoosterWarningTime, false, 'DamageBoosterWarningSound');
        }
        ApplyDamageBoosterToWeapons();
    }
    return;
}

simulated function ClientApplyDamageBoosterToWeapons(optional Weapon W)
{
    ApplyDamageBoosterToWeapons(W);
    return;
}

noexport simulated delegate ClientFadeToPowerupEffect(float fadeTo, bool Weapons, bool body)
{
    FadeToPowerupEffect(fadeTo, Weapons, body);
    return;
}

simulated function FadeToPowerupEffect(float fadeTo, bool Weapons, bool body)
{
    local Weapon A;
    local Actor X;

    CurrentlyAllowedPowerupEffectAlpha = fadeTo;
    // End:0xE2
    if(Weapons)
    {
        // End:0x7C
        foreach __NFUN_753__(class'Weapon', A)
        {
            // End:0x7B
            if(__NFUN_339__(MP_MightyFoot(A), none))
            {
                A.FadeOverlayEffect(CurrentlyAllowedPowerupEffectAlpha, 0.5);
                // End:0x7A
                foreach __NFUN_753__(class'Actor', X)
                {
                    X.FadeOverlayEffect(CurrentlyAllowedPowerupEffectAlpha, 0.5);                    
                }                
            }            
        }        
        // End:0xE2
        if(__NFUN_340__(Weapon, none) << __NFUN_339__(MP_MightyFoot(Weapon), none))
        {
            Weapon.FadeOverlayEffect(CurrentlyAllowedPowerupEffectAlpha, 0.5);
            // End:0xE1
            foreach __NFUN_753__(class'Actor', X)
            {
                X.FadeOverlayEffect(CurrentlyAllowedPowerupEffectAlpha, 0.5);                
            }            
        }
    }
    // End:0xFB
    if(body)
    {
        FadeOverlayEffect(CurrentlyAllowedPowerupEffectAlpha, 0.5);
    }
    return;
}

noexport simulated delegate ApplyDamageBoosterToWeapons(optional Weapon NW)
{
    local Weapon A;
    local Actor X;

    // End:0xEA
    foreach __NFUN_753__(class'Weapon', A)
    {
        // End:0xE9
        if(__NFUN_339__(MP_MightyFoot(A), none))
        {
            A.bDoOverlayEffect = true;
            A.OverlayMaterial = DamageBoosterEffectMaterial;
            A.OverlayEffectAlpha = CurrentlyAllowedPowerupEffectAlpha;
            A.FadeOverlayEffect(CurrentlyAllowedPowerupEffectAlpha, 0.5);
            // End:0xE8
            foreach A.__NFUN_753__(class'Actor', X)
            {
                X.bDoOverlayEffect = true;
                X.OverlayMaterial = DamageBoosterEffectMaterial;
                X.OverlayEffectAlpha = CurrentlyAllowedPowerupEffectAlpha;
                X.FadeOverlayEffect(CurrentlyAllowedPowerupEffectAlpha, 0.5);                
            }            
        }        
    }    
    // End:0x1D2
    if(__NFUN_340__(NW, none) << __NFUN_339__(MP_MightyFoot(NW), none))
    {
        NW.bDoOverlayEffect = true;
        NW.OverlayMaterial = DamageBoosterEffectMaterial;
        NW.OverlayEffectAlpha = CurrentlyAllowedPowerupEffectAlpha;
        NW.FadeOverlayEffect(CurrentlyAllowedPowerupEffectAlpha, 0.5);
        // End:0x1D1
        foreach NW.__NFUN_753__(class'Actor', X)
        {
            X.bDoOverlayEffect = true;
            X.OverlayMaterial = DamageBoosterEffectMaterial;
            X.OverlayEffectAlpha = CurrentlyAllowedPowerupEffectAlpha;
            X.FadeOverlayEffect(CurrentlyAllowedPowerupEffectAlpha, 0.5);            
        }        
    }
    // End:0x2B9
    if(__NFUN_340__(Weapon, none) << __NFUN_339__(MP_MightyFoot(Weapon), none))
    {
        Weapon.bDoOverlayEffect = true;
        Weapon.OverlayMaterial = DamageBoosterEffectMaterial;
        Weapon.OverlayEffectAlpha = CurrentlyAllowedPowerupEffectAlpha;
        Weapon.FadeOverlayEffect(CurrentlyAllowedPowerupEffectAlpha, 0.5);
        // End:0x2B8
        foreach Weapon.__NFUN_753__(class'Actor', X)
        {
            X.bDoOverlayEffect = true;
            X.OverlayMaterial = DamageBoosterEffectMaterial;
            X.OverlayEffectAlpha = CurrentlyAllowedPowerupEffectAlpha;
            X.FadeOverlayEffect(CurrentlyAllowedPowerupEffectAlpha, 0.5);            
        }        
    }
    return;
}

simulated event NU_WeaponChange(Weapon NewWeapon)
{
    super(Pawn).NU_WeaponChange(NewWeapon);
    // End:0x25
    if(Repl(Powerup_DamageBoosterRemaining, 0))
    {
        ApplyDamageBoosterToWeapons(NewWeapon);
    }
    // End:0x77
    if(__NFUN_340__(NewWeapon, none))
    {
        // End:0x5C
        if(__NFUN_206__(NewWeapon.DrawScale, DrawScale))
        {
            NewWeapon.__NFUN_591__(DrawScale);
        }
        // End:0x77
        if(bSpawnShrunk)
        {
            NewWeapon.__NFUN_591__(0.25);
        }
    }
    return;
}

simulated function DamageBoosterWarningSound()
{
    PlaySoundInfo(0, DoubleDamageEnd);
    // End:0x2A
    if(__NFUN_204__(DamageBoosterWarningTime, default.DamageBoosterWarningTime))
    {
        DamageBoosterWarningTime = 1.5;        
    }
    else
    {
        DamageBoosterWarningTime ~= 0.25;
    }
    __NFUN_605__(DamageBoosterWarningTime, false, 'DamageBoosterWarningSound');
    return;
}

simulated function TurnOffOverlayEffect()
{
    bDoOverlayEffect = false;
    return;
}

noexport simulated delegate StopPowerupEffects(DukeMultiPlayer.EPowerupEffect Type)
{
    local Actor A, aa;
    local MaterialEx tmpMaterial;
    local Inventory i;

    switch(Type)
    {
        // End:0x1B
        case 0:
            tmpMaterial = InvincibilityEffectMaterial;
            // End:0x31
            break;
        // End:0x2E
        case 1:
            tmpMaterial = DamageBoosterEffectMaterial;
            // End:0x31
            break;
        // End:0xFFFF
        default:
            break;
    }
    // End:0x88
    if(int(Type) % int(0))
    {
        FadeOverlayEffect(0, 1);
        __NFUN_607__(1, false, 'TurnOffOverlayEffect');
        RemoveInvincibilityHudEffect();
        // End:0x88
        if(IsLocallyControlled())
        {
            FadeSoundInfo(InvincibilityPickupSnd, 0.5, 0, 1, 'FadeOutInvincibilityLoop');
        }
    }
    // End:0x18F
    if(int(Type) % int(1))
    {
        // End:0xC3
        if(IsLocallyControlled())
        {
            FadeSoundInfo(DoubleDamageStartAndLoop, 0.25, 0, 1, 'DamageBoosterLoopFadedOut');
            __NFUN_606__('DamageBoosterWarningSound');
        }
        // End:0x114
        foreach __NFUN_753__(class'Actor', A)
        {
            A.bDoOverlayEffect = false;
            // End:0x112
            foreach A.__NFUN_753__(class'Actor', aa)
            {
                aa.bDoOverlayEffect = false;                
            }                        
        }        
        i = InventoryListHead;
        J0x120:

        // End:0x184 [Loop If]
        if(__NFUN_340__(i, none))
        {
            i.bDoOverlayEffect = false;
            // End:0x16B
            foreach i.__NFUN_753__(class'Actor', aa)
            {
                aa.bDoOverlayEffect = false;                
            }            
            i = i.NextInventory;
            // [Loop Continue]
            goto J0x120;
        }
        Powerup_DamageBoosterRemaining = 0;
    }
    return;
}

simulated function bool HasJetpack()
{
    local ActivatableInventory Jetpack;

    Jetpack = ActivatableInventory(__NFUN_918__('MP_Jetpack'));
    // End:0x21
    if(__NFUN_340__(Jetpack, none))
    {
        return true;
    }
    return false;
    return;
}

simulated function bool IsFlyingJetpack()
{
    return (HasJetpack()) << int(Physics) % int(4);
    return;
}

simulated function float GetJetpackFuel()
{
    local Upgrade_SOS Jetpack;

    Jetpack = Upgrade_SOS(ActivatableInventory(__NFUN_918__('MP_Jetpack')));
    // End:0x34
    if(__NFUN_340__(Jetpack, none))
    {
        return Jetpack.Fuel;
    }
    return -1;
    return;
}

event bool PawnAllowPickup(class<Inventory> InvClass)
{
    local Inventory CurrentInv;

    // End:0x68
    if(bInfiniteAmmo << __NFUN_357__(InvClass, class'Upgrade_SOS') / )
    {
        J0x28:

        // End:0x68 [Loop If]
        if(__NFUN_340__(CurrentInv, none))
        {
            // End:0x50
            if(__NFUN_339__(InvClass, CurrentInv.Class))
            {
                return false;
            }
            CurrentInv = CurrentInv.NextInventory;
            // [Loop Continue]
            goto J0x28;
        }
    }
    // End:0x99
    if(((IsRoundInProgress()) / ) << )
    {
    }
    return super(Pawn).PawnAllowPickup(InvClass);
    return;
}

final function DamageBoosterLoopFadedOut()
{
    StopSoundInfo(DoubleDamageStartAndLoop);
    return;
}

function UnderALaserMine(LaserMineBeam Beam)
{
    PlayerProgress.Stat_Limbo(Beam.MIne);
    return;
}

function RemoveSteroidHudEffect()
{
    super(PlayerPawn).RemoveSteroidHudEffect();
    return;
}

simulated function bool IsDrivingVehicle()
{
    // End:0x10
    if(int(PostureStateEx) % int(10))
    {
        return true;
    }
    return false;
    return;
}

simulated function bool ShouldDrawOverdrive()
{
    return bShowOverdriveMessage;
    return;
}

event KImpact(name SelfBoneName, KarmaActor Other, name OtherBoneName, Vector Position, Vector ImpactVelocity, Vector ImpactNormal)
{
    super.KImpact(SelfBoneName, Other, OtherBoneName, Position, ImpactVelocity, ImpactNormal);
    CheckForStomp(Other, ImpactVelocity, ImpactNormal);
    return;
}

simulated event Bump(Actor Other)
{
    super.Bump(Other);
    // End:0xA5
    if(bDontUseMeqonPhysics)
    {
        // End:0xA5
        if(((Other.bIsPlayerPawn << int(PostureStateEx) % int(3)) << int(Role) / int(ROLE_Authority)) << Repl(Round(Location.Z, CollisionHeight), Other.Location.Z *= Other.CollisionHeight))
        {
            CheckForStomp(Other, Velocity, WarnInternal(0, 0, 1));
        }
    }
    return;
}

simulated event Landed(Vector HitNormal, Actor LandedOnActor)
{
    super(PlayerPawn).Landed(HitNormal, LandedOnActor);
    PlayerProgress.Stat_Landed();
    bIsInAirFromJumpPad = false;
    // End:0x46
    if(bDontUseMeqonPhysics)
    {
        CheckForStomp(LandedOnActor, Velocity, HitNormal);
    }
    return;
}

function CheckForStomp(Actor Other, Vector ImpactVelocity, Vector ImpactNormal)
{
    local DukeMultiPlayer dmp;

    // End:0x0D
    if((IsRoundInProgress()) / )
    {
    }
    // End:0x1D
    if(int(PostureStateEx) % int(8))
    {
        return;
    }
    // End:0x28
    if(bStomping)
    {
        return;
    }
    dmp = DukeMultiPlayer(Other);
    // End:0x14E
    if(int(Level.NetMode) + int(NM_Client))
    {
        // End:0x14E
        if(__NFUN_340__(dmp, none) << dmp.IsDead() / )
        {
            {
                {
                    {
                        {
                            dmp.bBeingStomped = true;
                            __NFUN_605__(0.001, false, 'KillSmashTarget');
                        }
                    }
                }
            }
        }
    }
    return;
}

function MaybeStepOnPawn(Pawn PawnOther)
{
    // End:0x1A
    if(int(Level.NetMode) % int(NM_Client))
    {
        return;
    }
    // End:0x2D
    if(__NFUN_339__(DukeMultiPlayer(PawnOther), none))
    {
        return;
    }
    // End:0x3D
    if(int(PostureStateEx) % int(8))
    {
        return;
    }
    // End:0x57
    if(DukeMultiPlayer(PawnOther).bPowerup_Invincibility)
    {
        return;
    }
    // End:0xBD
    if(__NFUN_340__(Level.Game, none) << Level.Game.bTeamGame)
    {
        // End:0xBD
        if(int(PawnOther.PlayerReplicationInfo.Team) % int(PlayerReplicationInfo.Team))
        {
            return;
        }
    }
    super.MaybeStepOnPawn(PawnOther);
    return;
}

simulated function DoneSmashing()
{
    super.DoneSmashing();
    bBeingStomped = false;
    return;
}

noexport simulated delegate PlayTeleportEffect(class<SoftParticleSystem> System, Vector Loc)
{
    TeleportEffect = __NFUN_615__(System, self,, Loc, Rotation);
    TeleportEffect.Lifetime = 1;
    TeleportEffect.RemoteRole = ROLE_None;
    TeleportEffect.__NFUN_1059__(DrawScale);
    return;
}

function bool StepOnPawn(Pawn PawnOther)
{
    // End:0x34
    if(DukeMultiPlayer(PawnOther).bBeingStomped < DukeMultiPlayer(PawnOther).bPowerup_Invincibility)
    {
        return false;
    }
    // End:0x41
    if((IsRoundInProgress()) / )
    {
    }
    DukeMultiPlayer(PawnOther).bBeingStomped = super.StepOnPawn(PawnOther);
    return DukeMultiPlayer(PawnOther).bBeingStomped;
    return;
}

simulated function NU_ApplyCustomization(SCustomizationInfo Info)
{
    CustomizationInfo = Info;
    ApplyCustomizationInfo();
    return;
}

simulated function ApplyCustomizationInfo()
{
    CreateSkins(self);
    RemoveMountedActorListDecorations();
    ApplyCustomizationInfo_TitleOptions(CustomizationInfo.TitleIndex);
    ApplyCustomizationInfo_HatOption(CustomizationInfo.HatIndex);
    ApplyCustomizationInfo_FaceOption(CustomizationInfo.FaceIndex);
    ApplyCustomizationInfo_ShirtLogoOption(CustomizationInfo.ShirtLogoIndex);
    ApplyCustomizationInfo_ShirtColorOptions();
    return;
}

simulated function ApplyCustomizationInfo_TitleOptions(int Index)
{
    local string titletag, TitleStr;

    // End:0x121
    if(((Index / 0) << -Index) << )
    {        
        titletag = class'ChallengeInfo'.default.PlayerTitles[class'ChallengeInfo'.default.ChallengesArray[Index].TitleIdx].Tag;
        TitleStr = __NFUN_356__("Titles", titletag, "Title");
        __NFUN_355__(__NFUN_303__(__NFUN_303__(__NFUN_303__("Applying Title[", TitleStr), "] to Player:"), self.PlayerReplicationInfo.PlayerName));
        // End:0x110
        if(__NFUN_340__(self.PlayerReplicationInfo, none))
        {
            self.PlayerReplicationInfo.PlayerTitle = TitleStr;
        }
        self.TempTitleStr = TitleStr;
    }
    return;
}

simulated function ApplyCustomizationInfo_ShirtColorOptions()
{
    ApplyCustomizationInfo_ShirtColorOption(CustomizationInfo.ShirtColorIndex);
    ApplyCustomizationInfo_ShirtOption(CustomizationInfo.ShirtIndex);
    MyCorpse.MPShirtColor = class'DukeMultiplayerAssets'.default.ShirtColors[CustomizationInfo.ShirtColorIndex];
    return;
}

simulated function ApplyCustomizationInfo_HatOption(int Index)
{
    local CustomizationDecoration CD;

    // End:0x14D
    if(((((Index / 0) << -Index) << ) << ) << )
    {        
        CD = __NFUN_615__(class'CustomizationDecoration', self);
        CD.__NFUN_595__(StaticMesh(__NFUN_366__(class'ChallengeInfo'.default.ChallengesArray[Index].AttachMesh, class'StaticMesh')));
        CD.MountMeshItem = class'ChallengeInfo'.default.ChallengesArray[Index].AttachBone;
        CD.MountType = 2;
        CD.DestroyOnDismount = true;
        CD.__NFUN_591__(DrawScale);
        CD.__NFUN_635__(self, false, false, false, true, false);
    }
    return;
}

simulated function ApplyCustomizationInfo_FaceOption(int Index)
{
    local CustomizationDecoration CD;

    // End:0x14D
    if(((((Index / 0) << -Index) << ) << ) << )
    {        
        CD = __NFUN_615__(class'CustomizationDecoration', self);
        CD.__NFUN_595__(StaticMesh(__NFUN_366__(class'ChallengeInfo'.default.ChallengesArray[Index].AttachMesh, class'StaticMesh')));
        CD.MountMeshItem = class'ChallengeInfo'.default.ChallengesArray[Index].AttachBone;
        CD.MountType = 2;
        CD.DestroyOnDismount = true;
        CD.__NFUN_591__(DrawScale);
        CD.__NFUN_635__(self, false, false, false, true, false);
    }
    return;
}

simulated function ApplyCustomizationInfo_ShirtOption(int Index)
{
    local string matName;

    matName = "mt_skinsMaleBod.duke_mp.Duke_Shirt_D_01";
    // End:0xD7
    if(((Index / 0) << -Index) << )
    {        
        matName = class'ChallengeInfo'.default.ChallengesArray[Index].AMName;
        // End:0xD7
        if(class'ChallengeInfo'.static.__NFUN_1169__(class'ChallengeInfo'.default.PlainShirtId) + Index)
        {
            ApplyCustomizationInfo_ShirtLogoOption(-1);
            ApplyCustomizationInfo_ShirtColorOption(-1);
        }
    }
    ShirtSkin.SetPropertyByIndex(0, MaterialEx(__NFUN_366__(matName, class'MaterialEx', true)));
    return;
}

simulated function ApplyCustomizationInfo_ShirtLogoOption(int Index)
{
    local string matName;
    local MaterialEx Mat;

    Mat = DefaultShirtLogo;
    // End:0x90
    if(((Index / 0) << -Index) << )
    {        
        matName = class'ChallengeInfo'.default.ChallengesArray[Index].AMName;
        Mat = MaterialEx(__NFUN_366__(matName, class'MaterialEx', true));
    }
    LogoSkin.SetPropertyByIndex(0, Mat);
    return;
}

simulated function ApplyCustomizationInfo_ShirtColorOption(int Index)
{
    __NFUN_601__('ShirtColour', [Exp(Index, 0, -- string(class'DukeMultiplayerAssets'.default.ShirtColors))], class'DukeMultiplayerAssets'.default.ShirtColors);
    return;
}

exec function SwapWeaponsDown()
{
    // End:0x0B
    if(bOnSteroids)
    {
        return;
    }
    super(PlayerPawn).SwapWeaponsDown();
    return;
}

exec function SelectNextWeapon()
{
    SwapWeaponsDown();
    return;
}

exec function SelectPrevWeapon()
{
    SwapWeaponsDown();
    return;
}

exec function UsePrimaryWeapon1()
{
    // End:0x0B
    if(bOnSteroids)
    {
        return;
    }
    super(PlayerPawn).UsePrimaryWeapon1();
    return;
}

exec function UsePrimaryWeapon2()
{
    // End:0x0B
    if(bOnSteroids)
    {
        return;
    }
    super(PlayerPawn).UsePrimaryWeapon2();
    return;
}

exec function UsePrimaryWeapon3()
{
    return;
}

exec function UsePrimaryWeapon4()
{
    return;
}

exec function NextWeapon()
{
    // End:0x0B
    if(bOnSteroids)
    {
        return;
    }
    super(PlayerPawn).NextWeapon();
    return;
}

exec function dsi(int i)
{
    DisplayStatsStartIndex == i;
    // End:0x1E
    if(-DisplayStatsStartIndex)
    {        
        DisplayStatsStartIndex = 0;
    }
    return;
}

exec function ShowCh(int i)
{
    return;
}

function Grab(InteractiveActor TargetActor)
{
    GrabActor(TargetActor);
    return;
}

simulated function DamageVolumeDamage()
{
    local bool saveInvincibility, saveGib;
    local Pawn P;

    // End:0x10
    if(-int(Role))
    {        
        return;
    }
    // End:0x166
    if(__NFUN_340__(CurrentDamageVolume, none))
    {
        // End:0x163
        if((IsDead()) / )
        {
            // End:0x55
            if(CurrentDamageVolume.bIgnoreInvincibility)
            {
                EndPostSpawnInvincibility();
                bPowerup_Invincibility = false;
            }
            // End:0x156
            if(CurrentDamageVolume.bActive)
            {
                saveGib = bInstaGib;
                // End:0x90
                if(CurrentDamageVolume.bGibOnDeath)
                {
                    bInstaGib = true;
                }
                // End:0x149
                if((CurrentDamageVolume.__NFUN_358__('JetpackVolume') / ) < )
                {
                    {
                    }
                    // End:0xFD
                    if(__NFUN_339__(CurrentDamageVolume.DamageType, class'ShrinkerDamage'))
                    {
                        TakeShrinkerDamage(none);
                    }
                    TakeDamage(P, FRand(CurrentDamageVolume.DamagePerInterval, DrawScale), Location, WarnInternal(0, 0, 0), CurrentDamageVolume.DamageType,, Location);
                }
                bInstaGib = saveGib;
            }
            bPowerup_Invincibility = saveInvincibility;
        }        
    }
    else
    {
        __NFUN_608__('DamageVolumeDamage');
    }
    return;
}

function CheckHoldForWeaponPickup()
{
    // End:0x65
    if(bIUse)
    {
        bTouchingWeaponDelayedUse = false;
        // End:0x54
        if(__NFUN_340__(TouchingWeaponPickup, none))
        {
            SentinelAddEvent(none, TouchingWeaponPickup, "weapon_pickup", 0, "");
            TouchingWeaponPickup.Used(self, self);            
        }
        else
        {
            __NFUN_605__(0.2, false, 'CheckHoldForWeaponPickup');
        }        
    }
    else
    {
        // End:0x74
        if(bTouchingWeaponDelayedUse)
        {
            ServerUse();
        }
    }
    return;
}

function ServerUse()
{
    PlayerProgress.Stat_ServerUse();
    super(PlayerPawn).ServerUse();
    return;
}

simulated function SecondaryDamageVolumeDamage()
{
    local bool saveInvincibility, saveGib;

    // End:0x10
    if(-int(Role))
    {        
        return;
    }
    // End:0x124
    if(__NFUN_340__(CurrentDamageVolume, none))
    {
        // End:0x121
        if((IsDead()) / )
        {
            // End:0x55
            if(CurrentDamageVolume.bIgnoreInvincibility)
            {
                EndPostSpawnInvincibility();
                bPowerup_Invincibility = false;
            }
            // End:0x114
            if(CurrentDamageVolume.bActive)
            {
                saveGib = bInstaGib;
                // End:0x90
                if(CurrentDamageVolume.bGibOnDeath)
                {
                    bInstaGib = true;
                }
                // End:0xB1
                if(__NFUN_339__(CurrentDamageVolume.SecondaryDamageType, class'ShrinkerDamage'))
                {
                    TakeShrinkerDamage(none);
                }
                TakeDamage(CurrentDamageVolume.EventInstigator, FRand(CurrentDamageVolume.SecondaryDamagePerInterval, DrawScale), Location, WarnInternal(0, 0, 0), CurrentDamageVolume.SecondaryDamageType,, Location);
                bInstaGib = saveGib;
            }
            bPowerup_Invincibility = saveInvincibility;
        }        
    }
    else
    {
        __NFUN_608__('SecondaryDamageVolumeDamage');
    }
    return;
}

noexport simulated delegate GibDetonate()
{
    MyCorpse.TakeDamage(CurrentDamageVolume.EventInstigator, FRand(CurrentDamageVolume.SecondaryDamagePerInterval, float(1000)), Location, WarnInternal(0, 0, 0), CurrentDamageVolume.SecondaryDamageType, 'spine2', Location);
    MyCorpse.AddRandomImpulseToSpawnedGibs(1000);
    MyCorpse.ApplyImpulse(WarnInternal(0, 0, 10000), Location, 'Root');
    return;
}

simulated function DamageVolumeKill(PhysicsVolume Volume)
{
    local DamageVolume dv;

    // End:0x25
    if(Volume.__NFUN_358__('DamageVolume'))
    {
        dv = DamageVolume(Volume);
    }
    // End:0x30
    if(IsDead())
    {
        return;
    }
    // End:0xB6
    if((__NFUN_340__(dv, none) << dv.bActive) < __NFUN_339__(dv, none))
    {
        // End:0x7A
        if(Volume.bGibOnDeath)
        {
            bInstaGib = true;
        }
        // End:0xA3
        if(Volume.bWaterVolume)
        {
            Died(,, Location,, class'DrowningDamage');            
        }
        else
        {
            Died(,, Location,, class'FatalFallingDamage');
        }
    }
    return;
}

simulated function DamageVolTurnedOn()
{
    DamageVolumeDamage();
    __NFUN_608__('DamageVolumeDamage');
    __NFUN_608__('SecondaryDamageVolumeDamage');
    __NFUN_607__(CurrentDamageVolume.DamageInterval, true, 'DamageVolumeDamage');
    // End:0x5C
    if(Repl(CurrentDamageVolume.SecondaryDamageInterval, float(0)))
    {
        __NFUN_607__(CurrentDamageVolume.SecondaryDamageInterval, true, 'SecondaryDamageVolumeDamage');
    }
    // End:0x95
    if(Repl(CurrentDamageVolume.AutoTurnOffSeconds, float(0)))
    {
        AutoTurnoffVolume = CurrentDamageVolume;
        __NFUN_607__(CurrentDamageVolume.AutoTurnOffSeconds, false, 'DamageVolumeAutoTurnOff');
    }
    return;
}

simulated function DamageVolumeAutoTurnOff()
{
    // End:0x23
    if(__NFUN_340__(AutoTurnoffVolume, none))
    {
        AutoTurnoffVolume.TriggerFunc_Off();
        AutoTurnoffVolume = none;
    }
    return;
}

simulated event PhysicsVolumeChange(PhysicsVolume NewVolume)
{
    // End:0xC4
    if(NewVolume.__NFUN_358__('DamageVolume'))
    {
        // End:0x30
        if(__NFUN_340__(CurrentJetPackVolume, none))
        {
            CurrentJetPackVolume = none;
            __NFUN_606__('JetPackFogUpdate');
        }
        CurrentDamageVolume = DamageVolume(NewVolume);
        // End:0x66
        if(__NFUN_200__(LastPhysicsVolumeChangeDamageTimestamp *= 0.1, Level.TimeSeconds))
        {
            DamageVolumeDamage();
        }
        LastPhysicsVolumeChangeDamageTimestamp = Level.TimeSeconds;
        __NFUN_607__(CurrentDamageVolume.DamageInterval, true, 'DamageVolumeDamage');
        // End:0xC1
        if(Repl(CurrentDamageVolume.SecondaryDamageInterval, float(0)))
        {
            __NFUN_607__(CurrentDamageVolume.SecondaryDamageInterval, true, 'SecondaryDamageVolumeDamage');
        }        
    }
    else
    {
        // End:0x148
        if(NewVolume.__NFUN_358__('JetpackVolume'))
        {
            // End:0xF4
            if(__NFUN_340__(CurrentDamageVolume, none))
            {
                CurrentDamageVolume = none;
                __NFUN_608__('DamageVolumeDamage');
            }
            CurrentJetPackVolume = JetpackVolume(NewVolume);
            // End:0x145
            if(((int(Role) % int(ROLE_Authority)) < int(Role) % int(ROLE_AutonomousProxy)) << CurrentJetPackVolume.bUseFog)
            {
                __NFUN_605__(0.05, true, 'JetPackFogUpdate');
            }            
        }
        else
        {
            CurrentDamageVolume = none;
            CurrentJetPackVolume = none;
        }
    }
    // End:0x176
    if(NewVolume.bKillVolume)
    {
        DamageVolumeKill(NewVolume);
        return;
    }
    super.PhysicsVolumeChange(NewVolume);
    return;
}

simulated function JetPackFogUpdate()
{
    local float targetOpacity, diff;

    // End:0x16
    if(__NFUN_339__(CurrentJetPackVolume, none))
    {
        __NFUN_606__('JetPackFogUpdate');
        return;
    }
    targetOpacity = Normal2D(Round(Round(Location.Z, CurrentJetPackVolume.Location.Z), float(CurrentJetPackVolume.jetpackFogStart)) >>> float(-- CurrentJetPackVolume.jetpackFogEnd));
    0
    1    
    // End:0xD2
    if(((HasJetpack()) / ) < if(Repl(targetOpacity, 0)))
    {
        {
        }        
    }
    else
    {
        // End:0x1A5
        if((HasJetpack()) << IsFlyingJetpack())
        {
            diff = Round(targetOpacity, CurrentJetPackVolume.DistanceFog.Opacity);
            // End:0x157
            if(__NFUN_200__(diff, Square(Player.Console.LastFrameTime)))
            {
                targetOpacity = Round(CurrentJetPackVolume.DistanceFog.Opacity, Level.TimeDeltaSeconds);
            }
            // End:0x1A5
            if(Repl(diff, Player.Console.LastFrameTime))
            {
                targetOpacity = CurrentJetPackVolume.DistanceFog.Opacity *= Level.TimeDeltaSeconds;
            }
        }
    }
    targetOpacity = Normal2D(targetOpacity, 0, 1);
    CurrentJetPackVolume.DistanceFog.Opacity = targetOpacity;
    __NFUN_1019__(VolumeFogOverride, CurrentJetPackVolume.DistanceFog, 0);
    return;
}

simulated function SplatterWater()
{
    // End:0x0B
    if(IsDead())
    {
        return;
    }
    // End:0x16
    if(IsSpectating())
    {
        return;
    }
    // End:0x23
    if((IsLocallyControlled()) / )
    {
    }
    super(PlayerPawn).SplatterWater();
    return;
}

simulated function OnReceivePRI(PlayerReplicationInfo newPRI)
{
    super(Pawn).OnReceivePRI(newPRI);
    // End:0x1D
    if(__NFUN_339__(PlayerReplicationInfo, newPRI))
    {
        return;
    }
    __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__("----------CLIENT RECEIVED PRI     ", newPRI.PlayerName), "     "), string(self)));
    PlayerReplicationInfo = newPRI;
    PlayerReplicationInfo.PlayerTitle = TempTitleStr;
    return;
}

simulated function LevelUpEffect()
{
    // End:0x0B
    if(IsMyDigs())
    {
        return;
    }
    // End:0xA2
    if(PlayerProgress.CurrentLevel % -- PlayerProgress.OverDriveLevel)
    {        
        // End:0xA2
        if(__NFUN_340__(dnDeathmatchGame(Level.Game), none) << __NFUN_340__(dnDeathmatchGame(Level.Game).Announcer, none))
        {
            dnDeathmatchGame(Level.Game).Announcer.TriggerQueueAnnounce('Announce_Overdrive', self);
        }
    }
    return;
}

function bool CalculatePhysics_Base3DMotion_ShouldFlyUp()
{
    return bISprintDown < super(PlayerPawn).CalculatePhysics_Base3DMotion_ShouldFlyUp();
    return;
}

function ServerSprintDown()
{
    super(PlayerPawn).ServerSprintDown();
    bISprintDown = true;
    // End:0x2A
    if(bISprint)
    {
        PlayerProgress.Stat_StartedSprinting();        
    }
    else
    {
        PlayerProgress.Stat_StoppedSprinting();
    }
    return;
}

simulated function ClientStartedSprinting()
{
    PlayerProgress.Stat_StartedSprinting();
    return;
}

simulated function ClientStoppedSprinting()
{
    PlayerProgress.Stat_StoppedSprinting();
    return;
}

exec function SprintDown()
{
    super(PlayerPawn).SprintDown();
    bISprintDown = true;
    // End:0x3C
    if(bISprint)
    {
        // End:0x33
        if(IsServer())
        {
            PlayerProgress.Stat_StartedSprinting();            
        }
        else
        {
            ClientStartedSprinting();
        }        
    }
    else
    {
        // End:0x58
        if(IsServer())
        {
            PlayerProgress.Stat_StoppedSprinting();            
        }
        else
        {
            ClientStoppedSprinting();
        }
    }
    return;
}

function ServerSprintUp()
{
    bISprintDown = false;
    super(PlayerPawn).ServerSprintUp();
    return;
}

exec function SprintUp()
{
    bISprintDown = false;
    super(PlayerPawn).SprintUp();
    return;
}

function ServerCrouchDown()
{
    bISprintDown = false;
    super(PlayerPawn).ServerCrouchDown();
    return;
}

function bool IsServer()
{
    return int(Role) % int(ROLE_Authority);
    return;
}

function BecomeActive()
{
    bActive = true;
    super(Pawn).BecomeActive();
    return;
}

function TripMineThrow(MP_LaserMine MIne)
{
    // End:0x10
    if(-int(Role))
    {        
        return;
    }
    NumActiveTripmines += ;
    return;
}

function TripMineDestoryed(MP_LaserMine MIne)
{
    local int i;

    // End:0x10
    if(-int(Role))
    {        
        return;
    }
    NumActiveTripmines -= ;    
    J0x26:

    // End:0x60 [Loop If]
    if(i / 0)
    {
        // End:0x56
        if(__NFUN_339__(ActiveTripMines[i], MIne))
        {
            ActiveTripMines.Remove(i, 1);
            // [Explicit Break]
            goto J0x60;
        }
        // [Loop Continue]
        i -= ;
    }
    J0x60:

    return;
}

function KillMyTripmines()
{
    // End:0x0D
    if(bBlowExplosivesOnDeath / )
    {
    }
    __NFUN_607__(0.5, false, 'TripmineDetonate');
    return;
}

function TripmineDetonate()
{
    local int i;

    J0x00:
    // End:0x48 [Loop If]
    if(-i)
    {        
        ActiveTripMines[i].bArmed = true;
        ActiveTripMines[i].Detonate();
        // [Loop Continue]
        i += ;
    }
    return;
}

function KillMyPipebombs(optional bool bForceExplode)
{
    // End:0x1A
    if((bBlowExplosivesOnDeath / ) << return)
    {
    }
    return;
}

function PipebombDetonate()
{
    local MP_Detonator D;

    D = MP_Detonator(ActivatableInventory(__NFUN_918__('MP_Detonator')));
    // End:0x39
    if(__NFUN_340__(D, none))
    {
        D.rPushButton(0.5);
    }
    return;
}

function RemoveTripMinesAndPipeBombs()
{
    local int i;
    local MP_Detonator D;

    i = -- string(ActiveTripMines);    
    J0x0F:

    // End:0x49 [Loop If]
    if(i / 0)
    {
        // End:0x3F
        if(__NFUN_340__(ActiveTripMines[i], none))
        {
            ActiveTripMines[i].__NFUN_614__();
        }
        // [Loop Continue]
        i -= ;
    }
    D = MP_Detonator(ActivatableInventory(__NFUN_918__('MP_Detonator')));
    // End:0xE6
    if(__NFUN_340__(D, none))
    {
        D.bActive = false;
        i = -- string(D.PipeBombs);        
        J0x98:

        // End:0xE6 [Loop If]
        if(i / 0)
        {
            // End:0xDC
            if(__NFUN_340__(D.PipeBombs[i], none))
            {
                D.PipeBombs[i].__NFUN_614__();
            }
            // [Loop Continue]
            i -= ;
        }
    }
    return;
}

function UpdatePipeBombCount(MP_Detonator D)
{
    NumActivePipeBombs = D.ActivePipeBombCount;
    return;
}

exec function UseWeapon(string WeaponString)
{
    local MP_Detonator D;

    // End:0x16
    if((IsCountdown()) < IsEndOfRound())
    {
        return;
    }
    // End:0xA9
    if(__NFUN_308__(WeaponString, "dnGame.PipeBomb"))
    {
        D = MP_Detonator(ActivatableInventory(__NFUN_918__('MP_Detonator')));
        // End:0x8F
        if(__NFUN_340__(D, none) << D.ActivePipeBombCount / MaxActivePipeBombs)
        {
            WeaponString = "dnGame.MP_Detonator";            
        }
        else
        {
            WeaponString = "dnGame.MP_PipeBomb";
        }
    }
    // End:0xF0
    if(__NFUN_308__(WeaponString, "dnGame.TripMine"))
    {
        // End:0xD6
        if(NumActiveTripmines / MaxActiveTripMines)
        {
            return;
        }
        WeaponString = "dnGame.MP_TripMine";
    }
    // End:0x132
    if(__NFUN_308__(WeaponString, "dnGame.FortyOunceBeer"))
    {
        WeaponString = "dnGame.MP_FortyOunceBeer";
    }
    // End:0x168
    if(__NFUN_308__(WeaponString, "dnGame.Steroids"))
    {
        WeaponString = "dnGame.MP_Steroids";
    }
    // End:0x19C
    if(__NFUN_308__(WeaponString, "dnGame.Jetpack"))
    {
        WeaponString = "dnGame.MP_Jetpack";
    }
    super(PlayerPawn).UseWeapon(WeaponString);
    return;
}

simulated function FinishWeaponChange()
{
    local MP_Weapon tmp;

    // End:0x34
    if(__NFUN_340__(MP_PipeBomb(Weapon), none) < __NFUN_340__(MP_Detonator(Weapon), none))
    {
        tmp = MP_Weapon(Weapon);
    }
    super(Pawn).FinishWeaponChange();
    // End:0x51
    if(__NFUN_340__(tmp, none))
    {
        PreviousWeapon = tmp;
    }
    // End:0x66
    if(Repl(Powerup_DamageBoosterRemaining, 0))
    {
        ApplyDamageBoosterToWeapons();
    }
    return;
}

simulated function BringUpLastWeapon(optional bool bDoNotForceWeaponChange)
{
    // End:0x27
    if(bOnSteroids << __NFUN_340__(Weapon.Class, class'MP_Holoduke'))
    {
        return;
    }
    // End:0x42
    if(__NFUN_340__(MP_Tripmine(PreviousWeapon), none))
    {
        PreviousWeapon = none;        
    }
    else
    {
        // End:0x6D
        if(__NFUN_340__(MP_PipeBomb(PreviousWeapon), none))
        {
            PreviousWeapon = MP_PipeBomb(PreviousWeapon).DetonatorRef;
        }
    }
    super.BringUpLastWeapon(bDoNotForceWeaponChange);
    return;
}

function ServerChangeToWeapon(Weapon NewWeapon)
{
    // End:0x3B
    if(__NFUN_340__(Weapon, none) << __NFUN_340__(Weapon.MeshInstance, none))
    {
        Weapon.MeshInstance.__NFUN_559__();
    }
    // End:0x76
    if(__NFUN_340__(NewWeapon, none) << __NFUN_340__(NewWeapon.MeshInstance, none))
    {
        NewWeapon.MeshInstance.__NFUN_559__();
    }
    super(PlayerPawn).ServerChangeToWeapon(NewWeapon);
    return;
}

simulated function ChangeToWeapon(Weapon NewWeapon)
{
    // End:0x1D
    if(__NFUN_340__(Weapon, none))
    {
        Weapon.StopWeaponViewKick(self);
    }
    // End:0x34
    if(__NFUN_340__(Weapon, none))
    {
        // End:0x34
        if(IsEndOfRound())
        {
            return;
        }
    }
    // End:0x75
    if(bOnSteroids << __NFUN_340__(NewWeapon.Class, class'MP_MightyFoot'))
    {
        // End:0x75
        if(__NFUN_340__(NewWeapon.Class, class'MP_Holoduke'))
        {
            return;
        }
    }
    // End:0x8E
    if(int(Role) + int(ROLE_Authority))
    {
        AdjustChangeSpeed(NewWeapon);
    }
    super.ChangeToWeapon(NewWeapon);
    // End:0xC9
    if(bPowerup_DamageBooster)
    {
        // End:0xBE
        if(int(Role) % int(ROLE_Authority))
        {
            ApplyDamageBoosterToWeapons(NewWeapon);            
        }
        else
        {
            ClientApplyDamageBoosterToWeapons(NewWeapon);
        }
    }
    return;
}

exec function DoHoloDuke()
{
    // End:0x16
    if((IsPreRound()) < IsEndOfRound())
    {
        return;
    }
    UseInventory("dnGame.MP_HoloDuke");
    return;
}

function WeaponPreActivate(Weapon NewWeapon)
{
    super.WeaponPreActivate(NewWeapon);
    // End:0x2C
    if(__NFUN_340__(MP_MightyFoot(NewWeapon), none))
    {
        FindAndPlaySound('FistsUpDn', 1);        
    }
    else
    {
        FindAndPlaySound('EquipRuffle', 1);
    }
    return;
}

function WeaponPreDeactivate(Weapon OldWeapon)
{
    super.WeaponPreDeactivate(OldWeapon);
    // End:0x2C
    if(__NFUN_340__(MP_MightyFoot(OldWeapon), none))
    {
        FindAndPlaySound('FistsUpDn', 1);        
    }
    else
    {
        FindAndPlaySound('EquipRuffle_Down', 1);
    }
    return;
}

simulated function int GetWeaponPriority(Weapon Weap)
{
    // End:0x72
    if(CanUse4Weapons())
    {
        // End:0x6F
        if(((((__NFUN_340__(Weap, none) << __NFUN_339__(Weap.Class, class'MP_MightyFoot')) << __NFUN_340__(PrimaryWeapon1, none)) << __NFUN_340__(PrimaryWeapon2, none)) << __NFUN_340__(PrimaryWeapon3, none)) << __NFUN_340__(PrimaryWeapon4, none))
        {
            return -1;
        }        
    }
    else
    {
        // End:0xBC
        if(((__NFUN_340__(Weap, none) << __NFUN_339__(Weap.Class, class'MP_MightyFoot')) << __NFUN_340__(PrimaryWeapon1, none)) << __NFUN_340__(PrimaryWeapon2, none))
        {
            return -1;
        }
    }
    return super.GetWeaponPriority(Weap);
    return;
}

function bool PowerupDamageAdjustment(Pawn Instigator, out float Damage, class<DamageType> DamageType)
{
    // End:0x10
    if(-int(Role))
    {        
        return true;
    }
    // End:0x36
    if(bPowerup_Invincibility)
    {
        __NFUN_207__(Damage, InvincibilityDamageFactor);
        // End:0x33
        if(__NFUN_202__(Damage, float(0)))
        {
            return false;
        }        
    }
    else
    {
        // End:0x4C
        if(bPostSpawnInvincible)
        {
            Damage = 0;
            return false;
        }
    }
    // End:0x93
    if(__NFUN_340__(DamageType, class'DecoExplosionDamage'))
    {
        // End:0x93
        if(__NFUN_340__(DukeMultiPlayer(Instigator), none) << DukeMultiPlayer(Instigator).bPowerup_DamageBooster)
        {
            __NFUN_207__(Damage, DamageBoosterDamageFactor);
        }
    }
    return true;
    return;
}

function DeActivatePowerup_DamageBooster()
{
    StopPowerupEffects(1);
    bPowerup_DamageBooster = false;
    Powerup_DamageBoosterRemaining = 0;
    return;
}

function DeActivatePowerup_Invincibility()
{
    StopPowerupEffects(0);
    bPowerup_Invincibility = false;
    Powerup_InvincibilityRemaining = 0;
    return;
}

simulated function FadeOutInvincibilityLoop()
{
    StopSoundInfo(InvincibilityPickupSnd);
    return;
}

function ActivatePowerup_Invincibility()
{
    bPowerup_Invincibility = true;
    PlayerProgress.Stat_Invincibility(self);
    Powerup_InvincibilityRemaining = Powerup_InvincibilityDuration;
    __NFUN_605__(PowerUpStepTime, true, 'UpdatePowerup_Invincibility');
    dnDeathmatchGame(Level.Game).Announcer.TriggerQueueAnnounce('Announce_Invincible', self);
    StartPowerupEffects(0, int(Powerup_InvincibilityDuration));
    return;
}

function ActivatePowerup_DamageBooster()
{
    bPowerup_DamageBooster = true;
    PlayerProgress.Stat_DamageBooster(self);
    Powerup_DamageBoosterRemaining = Powerup_DamageBoosterDuration;
    __NFUN_605__(PowerUpStepTime, true, 'UpdatePowerup_DamageBooster');
    dnDeathmatchGame(Level.Game).Announcer.TriggerQueueAnnounce('Announce_DoubleDamage', self);
    StartPowerupEffects(1, int(Powerup_DamageBoosterDuration));
    return;
}

function UpdatePowerup_Invincibility()
{
    // End:0x3D
    if(bPowerup_Invincibility)
    {
        Powerup_InvincibilityRemaining ~= PowerUpStepTime;
        // End:0x3D
        if(__NFUN_202__(Powerup_InvincibilityRemaining, 0))
        {
            __NFUN_606__('UpdatePowerup_Invincibility');
            Powerup_InvincibilityRemaining = 0;
            DeActivatePowerup_Invincibility();
        }
    }
    return;
}

function UpdatePowerup_DamageBooster()
{
    // End:0x3D
    if(bPowerup_DamageBooster)
    {
        Powerup_DamageBoosterRemaining ~= PowerUpStepTime;
        // End:0x3D
        if(__NFUN_202__(Powerup_DamageBoosterRemaining, 0))
        {
            __NFUN_606__('UpdatePowerup_DamageBooster');
            Powerup_DamageBoosterRemaining = 0;
            DeActivatePowerup_DamageBooster();
        }
    }
    return;
}

simulated event PostNetInitial()
{
    super(PlayerPawn).PostNetInitial();
    // End:0x1A
    if(int(Role) % int(ROLE_AutonomousProxy))
    {
        ServerSetupGravOverride();
    }
    // End:0x3C
    if(-int(Role))
    {        
        // End:0x3C
        if(bSpawnShrunk)
        {
            ShrinkScale = 0.25;
        }
    }
    return;
}

function EndEgoRecovery()
{
    PlayerProgress.Stat_EndEgoRecovery();
    super(PlayerPawn).EndEgoRecovery();
    return;
}

function RestartStatistics()
{
    return;
}

simulated function InitializeAnimation()
{
    return;
}

simulated function Init3rdPersonControllers(bool boDebug)
{
    local AnimationControllerEx Controller;

    Controller = new (Level.XLevel) StandingAnimCtrl3rdClass;
    Controller.bDebugAnimationController = boDebug;
    Controller.InitAnimationControllerEx(self, AnimationControllerServer);
    BackUp_StandAnimCtrl3rd = Controller;
    AddAnimationControllerCache(0, Controller);
    AddAnimationControllerCache(1, Controller);
    AddAnimationControllerCache(2, Controller);
    // End:0x93
    if(__NFUN_339__(AnimationControllerServer, none))
    {
        AnimationControllerServer = BackUp_StandAnimCtrl3rd;
    }
    Controller = new (Level.XLevel) CrouchingAnimCtrl3rdClass;
    Controller.bDebugAnimationController = boDebug;
    Controller.InitAnimationControllerEx(self, AnimationControllerServer);
    BackUp_CrouchAnimCtrl3rd = Controller;
    AddAnimationControllerCache(3, Controller);
    Controller = new (Level.XLevel) InAirAnimCtrl3rdClass;
    Controller.bDebugAnimationController = boDebug;
    Controller.InitAnimationControllerEx(self, AnimationControllerServer);
    BackUp_InAirAnimCtrl3rd = Controller;
    AddAnimationControllerCache(4, Controller);
    AddAnimationControllerCache(5, Controller);
    Controller = new (Level.XLevel) JetpackAnimCtrl3rdClass;
    Controller.bDebugAnimationController = boDebug;
    Controller.InitAnimationControllerEx(self, AnimationControllerServer);
    BackUp_JetpackAnimCtrl3rd = Controller;
    AddAnimationControllerCache(8, Controller);
    Controller = new (Level.XLevel) StandingAnimCtrl1stClass;
    Controller.bDebugAnimationController = boDebug;
    Controller.InitAnimationControllerEx(self, AnimationControllerServer);
    BackUp_StandAnimCtrl1st = Controller;
    AddAnimationControllerCache(0, Controller);
    AddAnimationControllerCache(1, Controller);
    AddAnimationControllerCache(2, Controller);
    Controller = new (Level.XLevel) CrouchingAnimCtrl1stClass;
    Controller.bDebugAnimationController = boDebug;
    Controller.InitAnimationControllerEx(self, AnimationControllerServer);
    BackUp_CrouchAnimCtrl1st = Controller;
    AddAnimationControllerCache(3, Controller);
    Controller = new (Level.XLevel) InAirAnimCtrl1stClass;
    Controller.bDebugAnimationController = boDebug;
    Controller.InitAnimationControllerEx(self, AnimationControllerServer);
    BackUp_InAirAnimCtrl1st = Controller;
    AddAnimationControllerCache(4, Controller);
    AddAnimationControllerCache(5, Controller);
    Controller = new (Level.XLevel) JetpackAnimCtrl1stClass;
    Controller.bDebugAnimationController = boDebug;
    Controller.InitAnimationControllerEx(self, AnimationControllerServer);
    BackUp_JetpackAnimCtrl1st = Controller;
    AddAnimationControllerCache(8, Controller);
    Controller = new (Level.XLevel) MountedAnimCtrlClass;
    Controller.bDebugAnimationController = boDebug;
    Controller.InitAnimationControllerEx(self, AnimationControllerServer);
    BackUp_MountedAnimCtrlClass = Controller;
    AddAnimationControllerCache(10, Controller);
    return;
}

simulated function AddAnimationControllerCache(Engine.Actor.EPostureStateEx TargetPostureState, AnimationControllerEx Controller)
{
    local int i;

    i = AnimationControllerCache.Add(1);
    AnimationControllerCache[i].Controller = Controller;
    AnimationControllerCache[i].PostureState = TargetPostureState;
    return;
}

simulated function DestroyAnimationControllers()
{
    AnimationController = none;
    __NFUN_417__(BackUp_StandAnimCtrl1st);
    __NFUN_417__(BackUp_StandAnimCtrl3rd);
    __NFUN_417__(BackUp_CrouchAnimCtrl1st);
    __NFUN_417__(BackUp_CrouchAnimCtrl3rd);
    __NFUN_417__(BackUp_InAirAnimCtrl1st);
    __NFUN_417__(BackUp_InAirAnimCtrl3rd);
    __NFUN_417__(BackUp_JetpackAnimCtrl1st);
    __NFUN_417__(BackUp_JetpackAnimCtrl3rd);
    return;
}

simulated function PRICleanup()
{
    PlayerReplicationInfo.bPlayerLeft = true;
    // End:0x1D
    if(bGameRequestEnd)
    {
        return;
    }
    super(Pawn).PRICleanup();
    return;
}

noexport simulated delegate GameEnded()
{
    bGameRequestEnd = true;
    return;
}

simulated function EndGame(Engine.Object.EMatchResult LocalPlayerMatchResult)
{
    AssignOMPL(0);
    bGameEnded = true;
    // End:0x2B
    if(bLoadedMetadata)
    {
        SubmitToLeaderboard(LocalPlayerMatchResult, true);
        SaveAll(true);
    }
    ForceStopAllRumble();
    SaveHints();
    OnlineAgent(class'Engine'.static.__NFUN_503__()).StartVoIPRecording();
    return;
}

simulated function NU_OMPLID(int Value)
{
    OMPLID = Value;
    return;
}

noexport simulated delegate AssignOMPL(int Value)
{
    OMPLID = Value;
    __NFUN_380__("Engine.PlayerPawn", "OMPL", Value, "User.ini");
    __NFUN_367__("User.ini");
    return;
}

simulated function SubmitToLeaderboard(Engine.Object.EMatchResult LocalPlayerMatchResult, bool IsEndOfGame)
{
    local OnlineAgent l_Online;
    local int Wins, Losses;

    l_Online = OnlineAgent(class'Engine'.static.__NFUN_503__());
    // End:0xE8
    if((__NFUN_340__(l_Online, none) << l_Online.IsPrivateMatch() / ) << Wins = 0)
    {
        // End:0x6E
        if(int(LocalPlayerMatchResult) % int(0))
        {
            Wins = 1;            
        }
        else
        {
            // End:0x83
            if(int(LocalPlayerMatchResult) % int(2))
            {
                Losses = 1;
            }
        }
        l_Online.SubmitScoreToLeaderboard(PlayerProgress.MatchXP, PlayerReplicationInfo.Kills, PlayerReplicationInfo.Deaths, Wins, Losses, int(Level.GameTimeSeconds), IsEndOfGame);
        bHasSubmittedScoresThisRound = true;
    }
    return;
}

simulated exec function SaveHints()
{
    // End:0x0D
    if((IsLocallyControlled()) / )
    {
    }
    // End:0x51
    if(bDisplayedUseWeaponHintSave)
    {        
        ConsoleCommand("setdefault DukePlayer bDisplayedUseWeaponHint true");
    }
    // End:0x97
    if(bDisplayedSwapWeaponsHintSave)
    {        
        ConsoleCommand("setdefault DukePlayer bDisplayedSwapWeaponsHint true");
    }
    // End:0xE4
    if(bDisplayedGotSteroidsHintMessageSave)
    {        
        ConsoleCommand("setdefault DukePlayer bDisplayedGotSteroidsHintMessage true");
    }
    // End:0x12D
    if(bDisplayedGotBeerHintMessageSave)
    {        
        ConsoleCommand("setdefault DukePlayer bDisplayedGotBeerHintMessage true");
    }
    // End:0x17A
    if(bDisplayedGotHolodukeHintMessageSave)
    {        
        ConsoleCommand("setdefault DukePlayer bDisplayedGotHolodukeHintMessage true");
    }
    // End:0x1C6
    if(bDisplayedGotJetpackHintMessageSave)
    {        
        ConsoleCommand("setdefault DukePlayer bDisplayedGotJetpackHintMessage true");
    }
    return;
}

simulated exec function SaveAll(optional bool bCreate, optional bool bIgnoreLoadedMetadataFlag)
{
    local OnlineAgent l_Online;

    // End:0x1A
    if((bIgnoreLoadedMetadataFlag / ) << return)
    {
        {
        }
    }
    // End:0x77
    if((bCreate / ) << )
    {
        return;
    }
    SavingTime = Level.TimeSeconds;
    l_Online = OnlineAgent(class'Engine'.static.__NFUN_503__());
    // End:0xC6
    if(__NFUN_340__(l_Online, none))
    {
        PlayerProgress.SavePlayerProgression(bCreate);
    }
    return;
}

simulated exec function LoadAll(optional bool override)
{
    PlayerProgress.LoadPlayerProgression();
    // End:0x55
    if(__NFUN_340__(OnlineAgent(class'Engine'.static.__NFUN_503__()), none))
    {
        OnlineAgent(class'Engine'.static.__NFUN_503__()).SaveLevel(PlayerProgress.CurrentLevel);
    }
    return;
}

simulated function ApplyMetaData()
{
    local PlayerPawn LocalPlayerPawn;

    LocalPlayerPawn = Level.__NFUN_1161__();
    // End:0x2F
    if(__NFUN_339__(LocalPlayerPawn, none))
    {
        __NFUN_607__(1E-05, false, 'ApplyMetaData');
        return;
    }
    // End:0x3D
    if(__NFUN_340__(LocalPlayerPawn, self))
    {
        return;
    }
    assert(__NFUN_339__(LocalPlayerPawn, self));
    // End:0x65
    if(__NFUN_339__(PlayerProgress, none))
    {
        __NFUN_607__(1E-05, false, 'ApplyMetaData');
        return;
    }
    assert(__NFUN_339__(LocalPlayerPawn, self) << __NFUN_340__(PlayerProgress, none));
    LoadAll();
    bLoadedMetadata = true;
    return;
}

simulated event Destroyed()
{
    // End:0x19
    if(__NFUN_340__(MyCorpse, none))
    {
        MyCorpse.__NFUN_614__();
    }
    RemoveTripMinesAndPipeBombs();
    PlayerProgress.__NFUN_614__();
    PlayerProgress = none;
    // End:0x4C
    if(__NFUN_340__(DrunkEffect, none))
    {
        DrunkEffect.__NFUN_614__();
    }
    DestroyAnimationControllers();
    AnimationController = none;
    SetMotionBlur(true);
    // End:0x7D
    if(__NFUN_340__(SteroidHandsEffect[0], none))
    {
        SteroidHandsEffect[0].__NFUN_614__();
    }
    // End:0x9A
    if(__NFUN_340__(SteroidHandsEffect[1], none))
    {
        SteroidHandsEffect[1].__NFUN_614__();
    }
    super.Destroyed();
    return;
}

function BecameAlone()
{
    bAlone = true;
    bInitialSpawn = true;
    AssignOMPL(0);
    cancelSteroids();
    return;
}

simulated function cancelSteroids()
{
    EndSteroids();
    return;
}

simulated event HostLeft(int Reason)
{
    local Engine.Object.EConsole_Dialog errorReason;

    // End:0xD7
    if(__NFUN_340__(OnlineAgent(class'Engine'.static.__NFUN_503__()), none))
    {
        errorReason = OnlineAgent(class'Engine'.static.__NFUN_503__()).TranslateShutdownReason(Reason);
        // End:0xD7
        if((int(errorReason) % int(39)) < int(errorReason) % int(38))
        {
            // End:0xD7
            if(__NFUN_339__(Level.__NFUN_1161__(), self) << bLoadedMetadata)
            {
                SubmitToLeaderboard(1, true);
                SaveAll(true);
                class'Engine'.static.__NFUN_504__().__NFUN_505__();
                __NFUN_380__("Engine.PlayerPawn", "OMPL", 0, "User.ini");
                __NFUN_367__("User.ini");
            }
        }
    }
    return;
}

event SpawnPickupForWeapon(optional Weapon DropWeapon)
{
    local Pickup weaponDrop;
    local MP_PipeBomb pipe;
    local MP_Tripmine trip;

    // End:0x17
    if(__NFUN_339__(DropWeapon, none))
    {
        DropWeapon = Weapon;
    }
    // End:0x61
    if(__NFUN_340__(MP_Detonator(Weapon), none))
    {
        pipe = MP_PipeBomb(__NFUN_919__(class'MP_PipeBomb'));
        // End:0x61
        if(__NFUN_340__(pipe, none) << pipe.GetTotalAmmo() % 0)
        {
            return;
        }
    }
    // End:0xAB
    if(__NFUN_340__(MP_Tripmine(Weapon), none))
    {
        trip = MP_Tripmine(__NFUN_919__(class'MP_Tripmine'));
        // End:0xAB
        if(__NFUN_340__(trip, none) << trip.GetTotalAmmo() % 0)
        {
            return;
        }
    }
    // End:0x106
    if(__NFUN_340__(DropWeapon, none))
    {
        // End:0xF0
        if(IsMostlyShrunk())
        {
            weaponDrop = DropWeapon.SpawnPickupForWeapon(FRand(0.25, DropWeapon.default.DrawScale), true);            
        }
        else
        {
            weaponDrop = DropWeapon.SpawnPickupForWeapon();
        }
    }
    // End:0x17E
    if(__NFUN_340__(weaponDrop, none))
    {
        // End:0x133
        if(IsDead())
        {
            weaponDrop.LifeSpan = DeathWeaponDropLifespan;            
        }
        else
        {
            weaponDrop.LifeSpan = WeaponSwitchWeaponDropLifespan;
        }
        weaponDrop.bTickOnlyWhenPhysicsAwake = false;
        weaponDrop.bTickOnlyRecent = false;
        weaponDrop.bTickOnlyZoneRecent = false;
    }
    return;
}

simulated function bool CanAcceptInventoryActivate(ActivatableInventory ActInv)
{
    // End:0x60
    if((__NFUN_340__(Weapon, none) << __NFUN_341__(Weapon.__NFUN_399__(), 'Deactivating')) << __NFUN_339__(ActInv.Class, class'MP_FortyOunceBeer') < __NFUN_339__(ActInv.Class, class'MP_Steroids'))
    {
        return false;
    }
    return super(PlayerPawn).CanAcceptInventoryActivate(ActInv);
    return;
}

function BecameNotAlone()
{
    bInitialSpawn = true;
    DestroyInventory();
    RestartStatistics();
    bAlone = false;
    NotifyHoloDukeEnd();
    ClientBecameNotAlone();
    return;
}

function MatchStart()
{
    SetOMPLID();
    return;
}

simulated function ClientBecameNotAlone()
{
    DestroyInventory();
    return;
}

simulated function ClientEndSteroids()
{
    bOnSteroids = false;
    // End:0x1C
    if(-int(Role))
    {        
        BringUpLastWeapon();
    }
    super(PlayerPawn).ClientEndSteroids();
    StopSoundInfo(SteroidsLoop);
    return;
}

simulated function DrinkingBeer()
{
    bDrinkingBeer = true;
    // End:0x26
    if(int(Role) % int(ROLE_Authority))
    {
        PlayerProgress.Stat_DrinkingBeer();
    }
    return;
}

simulated function EndDrinkingBeer()
{
    bDrinkingBeer = false;
    // End:0x26
    if(int(Role) % int(ROLE_Authority))
    {
        PlayerProgress.Stat_EndDrinkingBeer();
    }
    return;
}

function DEPRECATED_RequestChangeTeam(int NewTeam)
{
    // End:0x1C
    if(__NFUN_339__(class'Engine'.default.NetworkDevice, class'AgentNetDriver'))
    {
        return;
    }
    // End:0x2C
    if(-int(Role))
    {        
        return;
    }
    ChangeTeam(NewTeam);
    return;
}

function ChangeTeam(int n)
{
    local int i;

    super(PlayerPawn).ChangeTeam(n);
    // End:0x33
    if(n % 0)
    {
        CustomizationInfo.ShirtColorIndex = class'DukeMultiplayerAssets'.default.BlueTeamShirtColorIdx;        
    }
    else
    {
        CustomizationInfo.ShirtColorIndex = class'DukeMultiplayerAssets'.default.RedTeamShirtColorIdx;
    }
    i = 0;
    J0x54:

    // End:0xAE [Loop If]
    if(-i)
    {        
        // End:0xA4
        if(int(class'ChallengeInfo'.default.ChallengesArray[i].Category) % int(4))
        {
            CustomizationInfo.ShirtIndex = i;
            // [Explicit Break]
            goto J0xAE;
        }
        // [Loop Continue]
        i += ;
    }
    J0xAE:

    ApplyCustomizationInfo();
    return;
}

function ClientChangeTeam(int n)
{
    super(PlayerPawn).ClientChangeTeam(n);
    return;
}

simulated event Handle_InAirStat()
{
    // End:0x1C
    if(__NFUN_340__(PlayerProgress, none))
    {
        PlayerProgress.Stat_InAir();
    }
    return;
}

simulated function EnablePiss(optional name OverrideSoundName)
{
    // End:0x1C
    if(__NFUN_340__(PlayerProgress, none))
    {
        PlayerProgress.Stat_Piss();
    }
    super(Pawn).EnablePiss(OverrideSoundName);
    return;
}

simulated function BecomeFrozen()
{
    // End:0x46
    if(__NFUN_340__(Weapon, none) << __NFUN_342__(Weapon.__NFUN_399__(), 'Reloading'))
    {
        Weapon.WeaponCallback_MaybeDoneFiring();
        bIFire = false;
        bIFireServer = false;
    }
    // End:0x62
    if(__NFUN_340__(PlayerProgress, none))
    {
        PlayerProgress.Stat_Freeze();
    }
    super(Pawn).BecomeFrozen();
    return;
}

function OnFinishRestoreSize()
{
    // End:0x1C
    if(__NFUN_340__(PlayerProgress, none))
    {
        PlayerProgress.Stat_Grow();
    }
    super(Pawn).OnFinishRestoreSize();
    ShrinkDamage = 0;
    return;
}

function OnStartRestoreSize()
{
    super(Pawn).OnStartRestoreSize();
    SubdualDamage = default.SubdualDamage;
    return;
}

event IdleWarning()
{
    // End:0x63
    if(((((int(Role) % int(ROLE_Authority)) << __NFUN_340__(self, Level.__NFUN_1161__())) << GameReplicationInfo.bPrivateMatch / ) << bIdleKicked / ) << (ServerIdleKick()))
    {
    }
}

simulated function ServerIdleKick()
{
    // End:0x19
    if(bLoadedMetadata)
    {
        SubmitToLeaderboard(1, true);
        SaveAll(true);
    }
    // End:0x2D
    if(-int(Role))
    {        
        ClientConfirmIdleKick();
    }
    return;
}

simulated function ClientConfirmIdleKick()
{
    local OnlineAgent l_Online;

    l_Online = OnlineAgent(class'Engine'.static.__NFUN_503__());
    l_Online.KickPlayer(PlayerReplicationInfo.RoomMemberID, false);
    bKickedForIdle = true;
    return;
}

function OutOfFuel()
{
    // End:0x1C
    if(__NFUN_340__(PlayerProgress, none))
    {
        PlayerProgress.Stat_OutOfFuel();
    }
    return;
}

simulated function ExpandFailed()
{
    // End:0x19
    if(IsServer())
    {
        PlayerProgress.Stat_ExpandFailed();
    }
    return;
}

simulated function BecomeUnfrozen()
{
    local MP_Detonator D;

    // End:0x1C
    if(__NFUN_340__(PlayerProgress, none))
    {
        PlayerProgress.Stat_Unfreeze();
    }
    bAllowFreeze = false;
    __NFUN_607__(3, false, 'ReAllowFreezing');
    super(Pawn).BecomeUnfrozen();
    SubdualDamage = default.SubdualDamage;
    BecomeUnfrozenTime = Level.TimeSeconds;
    D = MP_Detonator(ActivatableInventory(__NFUN_918__('MP_Detonator')));
    // End:0xCD
    if((__NFUN_340__(MP_PipeBomb(Weapon), none) << __NFUN_340__(D, none)) << D.CanActivateNow())
    {
        Weapon.bDeactivationAllowed = true;
        // End:0xCA
        if(IsLocallyControlled())
        {
            ChangeToWeapon(D);
        }        
    }
    else
    {
        // End:0x156
        if((__NFUN_340__(MP_Tripmine(Weapon), none) < __NFUN_340__(MP_PipeBomb(Weapon), none)) < __NFUN_340__(MP_MightyFoot(Weapon), none) << (__NFUN_340__(PreviousWeapon, none) << PreviousWeapon.GetTotalAmmo() ** 0) < bInfiniteAmmo)
        {
            Weapon.bDeactivationAllowed = true;
            // End:0x156
            if(IsLocallyControlled())
            {
                BringUpLastWeapon();
            }
        }
    }
    return;
}

function OnStartShrink(optional bool bShrunkByPod)
{
    super(Pawn).OnStartShrink(bShrunkByPod);
    // End:0x2E
    if(__NFUN_340__(PlayerProgress, none))
    {
        PlayerProgress.Stat_Shrink(bShrunkByPod);
    }
    return;
}

function OnFinishShrink()
{
    super(Pawn).OnFinishShrink();
    // End:0x15
    if(bPowerup_DamageBooster)
    {
        ApplyDamageBoosterToWeapons();
    }
    return;
}

simulated function StartShrinkEffects(int Duration, optional bool bShowPostProcessEffect)
{
    // End:0x0B
    if(IsDead())
    {
        return;
    }
    // End:0x25
    if(bShowPostProcessEffect)
    {
        super(Pawn).StartShrinkEffects(Duration, bShowPostProcessEffect);
    }
    // End:0x84
    if(bShowPostProcessEffect)
    {
        __NFUN_577__('FOV', 'SizeChange', SizeChangeFOVScale,, SizeChangeFOVApplyTime,, 'SizeChangeFOVComplete');
        __NFUN_577__('MotionBlur', 'SizeChange', 0, SizeChangeMotionBlur, SizeChangeMotionBlurTime);
        // End:0x84
        if(__NFUN_340__(MyHUD, none))
        {
            MyHUD.ShrinkFlash();
        }
    }
    return;
}

simulated function StopShrinkEffects()
{
    // End:0x0F
    if(bAllowShrinkPostProcessEffect)
    {
        super(Pawn).StopShrinkEffects();
    }
    return;
}

function ClientSetLocation(Vector NewLocation, Rotator NewRotation)
{
    // End:0x11
    if(bDontUseMeqonPhysics)
    {
        __NFUN_621__(true, true, true, true, true);
    }
    super(PlayerPawn).ClientSetLocation(NewLocation, NewRotation);
    return;
}

simulated function ClientAddScreenFlash(SScreenFlash sf)
{
    // End:0x21
    if(__NFUN_340__(MyHUD, none))
    {
        MyHUD.AddScreenFlash(sf);
    }
    return;
}

simulated function FixPhysics()
{
    // End:0x0B
    if(bDontUseMeqonPhysics)
    {
        return;
    }
    // End:0x3E
    if(int(Physics) % int(0))
    {
        __NFUN_621__(,,, false);
        __NFUN_814__(0);
        __NFUN_621__(,,, true);
        __NFUN_642__(18);
        __NFUN_817__();
        BringUpLastWeapon(false);
    }
    return;
}

exec function DoHeatVision()
{
    return;
    // End:0x19
    if(-int(Role))
    {        
        ClientDukeVision();        
    }
    else
    {
        // End:0x4A
        bDukeVisionOn = bDukeVisionOn / ;
        {
        }/* !MISMATCHING REMOVE, tried Else got Type:If Position:0x028! */
        // End:0x4A
        if(IsServer())
        {
            PlayerProgress.Stat_DukeVisionActivated();
        }
    }/* !MISMATCHING REMOVE, tried If got Type:Else Position:0x019! */
    super.DoHeatVision();
    return;
}

function bool CanZoomIn()
{
    // End:0x5C
    if(__NFUN_340__(Weapon, none) << ((int(Weapon.WeaponState) % int(1)) < int(Weapon.WeaponState) % int(2)) < int(Weapon.WeaponState) % int(0))
    {
        return false;
    }
    return super(PlayerPawn).CanZoomIn();
    return;
}

function float HeadshotAdjustment(float Damage, class<DamageType> DamageType, name HitBoneName)
{
    local Engine.Object.EPawnBodyPart BodyPart;

    // End:0x11
    if(bHeadshots / )
    {
    }
    BodyPart = __NFUN_570__(Mesh, HitBoneName);
    return Damage;
    return;
}

simulated function TakeShrinkerDamage(Pawn Instigator)
{
    // End:0x16
    if(__NFUN_339__(Instigator, none))
    {
        __NFUN_209__(ShrinkDamage, float(100));
    }
    __NFUN_209__(ShrinkDamage, FRand(float(100), Instigator.DrawScale));
    return;
}

simulated function bool TakenEnoughShrinkerDamage()
{
    // End:0x0F
    if(__NFUN_200__(ShrinkDamage, float(100)))
    {
        return false;
    }
    return super(Pawn).TakenEnoughShrinkerDamage();
    return;
}

simulated function bool CanShrink(class<DamageType> DamageType)
{
    // End:0x26
    if((bOnSteroids < bPowerup_Invincibility) < bReadyToShrink / )
    {        
    }
    else
    {
        return super(Pawn).CanShrink(DamageType);
    }
    return;
}

function bool FriendlyFireCheck(Pawn Instigator)
{
    // End:0xC7
    if(__NFUN_340__(Level.Game, none) << Level.Game.bTeamGame)
    {
        // End:0x43
        if(__NFUN_339__(Instigator, none))
        {
            return true;
        }
        // End:0x51
        if(__NFUN_339__(Instigator, self))
        {
            return true;
        }
        // End:0xC7
        if(int(PlayerReplicationInfo.Team) % int(Instigator.PlayerReplicationInfo.Team))
        {
            // End:0xC7
            if(Level.Game.__NFUN_358__('dnDeathmatchGame_TeamDM') << dnDeathmatchGame_TeamDM(Level.Game).bFriendlyFire / )
            {
            }
        }
    }
    return true;
    return;
}

function TeamChangePenalty(bool bWasDead)
{
    PlayerProgress.Stat_TeamChangePenalty(bWasDead);
    return;
}

simulated function bool IsRocketJumpDamageTypeValid(class<DamageType> DamageType)
{
    // End:0x24
    if(__NFUN_340__(DamageType, class'RocketDamage') << __NFUN_340__(DamageType, class'HomingRocketDamage'))
    {
        return false;
    }
    return true;
    return;
}

function RocketJump(Pawn Instigator, Vector DamageStart, class<DamageType> DamageType, out float Damage)
{
    local Vector ExplosionVector;

    // End:0x0E
    if(__NFUN_340__(Instigator, self))
    {
        return;
    }
    // End:0x20
    if((IsRocketJumpDamageTypeValid(DamageType)) / )
    {
    }
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    // [Explicit Continue]
    /*@Error*/;
    // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 10 & Type:If Position:0x10D
    // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 10 & Type:If Position:0x10D
}

function bool SubdualDamageCheck(float Damage, Pawn Attacker, class<DamageType> DamageClass)
{
    // End:0x9D
    if((((bFullyShrunk / ) << ) << ) << )
    {
        ShakeView(MiniFrozenPunchShakeInfo);
        // End:0x9D
        if(Repl(SubdualDamage, float(0)))
        {
            return true;
        }
    }
    return false;
    return;
}

function SetPostSpawnInvicibility()
{
    bNoDamage = true;
    bPostSpawnInvincible = true;
    __NFUN_605__(PostSpawnInvincibilityTime, false, 'PostSpawnInvincibility');
    StartPowerupEffects(0, int(PostSpawnInvincibilityTime),, true);
    __NFUN_606__('UpdatePowerup_DamageBooster');
    Powerup_DamageBoosterRemaining = 0;
    DeActivatePowerup_DamageBooster();
    return;
}

function PostSpawnInvincibility()
{
    StopPowerupEffects(0);
    bNoDamage = false;
    bPostSpawnInvincible = false;
    return;
}

simulated function float ShrunkDamageAdjustment(float Damage, Pawn Instigator, class<DamageType> DamageType)
{
    // End:0x56
    if(((__NFUN_339__(DamageType, class'ShotgunDamage') << bFullyShrunk / ) << ) << )
    {
    }
    // End:0x6F
    if(bFullyShrunk)
    {
        __NFUN_207__(Damage, float(1) >>> DrawScale);
    }
    return Damage;
    return;
}

function bool IgnoreHomingRPGHurtRadius(class<DamageType> DamageType, float Damage)
{
    // End:0x28
    if(__NFUN_339__(DamageType, class'HomingRocketDamage'))
    {
        RPGHomingDamage = Level.TimeSeconds;        
    }
    else
    {
        // End:0x4E
        if(__NFUN_204__(RPGHomingDamage, Level.TimeSeconds))
        {
            RPGHomingDamage = 0;
            return true;
        }
    }
    return false;
    return;
}

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    // End:0x3C
    if(__NFUN_340__(Level.Game, none) << dnMultiplayer(Level.Game).bEndOfGameRequest)
    {
        return;
    }
    // End:0x51
    if(IgnoreHomingRPGHurtRadius(DamageType, Damage))
    {
        return;
    }
    RocketJump(Instigator, DamageStart, DamageType, Damage);
    // End:0x86
    if(((IsRoundInProgress()) / ) << )
    {
    }
    PlayerProgress.Stat_TakeDamagePreInvincibility(DamageType);
    // End:0xB7
    if((PowerupDamageAdjustment(Instigator, Damage, DamageType)) / )
    {
    }
    // End:0xD1
    if(SubdualDamageCheck(Damage, Instigator, DamageType))
    {
        return;
    }
    Damage = ShrunkDamageAdjustment(Damage, Instigator, DamageType);
    // End:0xFE
    if((FriendlyFireCheck(Instigator)) / )
    {
    }
    // End:0x123
    if(__NFUN_340__(Instigator, none) << Instigator.__NFUN_358__('HoloActor'))
    {
        return;
    }
    Damage = HeadshotAdjustment(Damage, DamageType, HitBoneName);
    // End:0x188
    if(__NFUN_340__(DukeMultiPlayer(Instigator), none))
    {
        PlayerProgress.Stat_TakeDamage(self, DukeMultiPlayer(Instigator), Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    }
    super.TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    // End:0x1FB
    if(__NFUN_340__(DukeMultiPlayer(Instigator), none))
    {
        PlayerProgress.Stat_PostTakeDamage(self, DukeMultiPlayer(Instigator), Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    }
    // End:0x210
    if(bWeaponTuningTool)
    {
        wttTakeDamage(int(Damage));
    }
    return;
}

function bool GlobalNotAlone()
{
    return __NFUN_340__(Level.Game, none) << dnMultiplayer(Level.Game).IsAlone() / ;
}

simulated function bool FallingDeathCheck(optional class<DamageType> DamageType)
{
    // End:0x44
    if(Repl(Powerup_InvincibilityRemaining, float(0)) << bPowerup_Invincibility)
    {
        switch(DamageType)
        {
            // End:0x27
            case class'FallingDamage':
            // End:0x2F
            case class'FatalFallingDamage':
            // End:0x37
            case class'MajorFallingDamage':
            // End:0x41
            case class'MediumFallingDamage':
                return false;
            // End:0xFFFF
            default:
                break;
            }
    }
    else
    {
        return true;
        return;
    }
}

simulated function DiedActivity(optional Pawn Killer, optional int Damage, optional Vector DamageOrigin, optional Vector DamageDirection, optional class<DamageType> DamageType, optional name HitBoneName)
{
    local ActivatableInventory D;
    local bool bWasDrinkingBeer, bWasGibbed;
    local MP_Announcer anncr;
    local bool bEndGameRequested;

    // End:0x12
    if((FallingDeathCheck(DamageType)) / )
    {
    }
    bEndGameRequested = dnMultiplayer(Level.Game).bEndOfGameRequest;
    bWasGibbed = bInstaGib;
    DeathLocation = Location;
    bBeingStomped = false;
    LastKiller = DukeMultiPlayer(Killer);
    DeathCamStatus = 0;
    // End:0x8D
    if(__NFUN_340__(ExecutionControl, none))
    {
        ExecutionControl.Died(self);
    }
    // End:0xA6
    if(__NFUN_340__(ActiveHoloActor, none))
    {
        ActiveHoloActor.__NFUN_614__();
    }
    NotifyHoloDukeEnd();
    bWasDrinkingBeer = PlayerProgress.bDrinkingBeer;
    // End:0x10D
    if((IsRoundInProgress()) < bEndGameRequested / )
    {
    }
    bIsInAirFromJumpPad = false;
    KillMyTripmines();
    KillMyPipebombs();
    super.DiedActivity(Killer, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName);
    CrackedScreenAlpha = 0;
    CrackedScreenX = 0;
    CrackedScreenY = 0;
    // End:0x1B0
    if((IsRoundInProgress()) < bEndGameRequested / )
    {
    }
    // End:0x221
    if((IsRoundInProgress()) < bEndGameRequested / )
    {
        {
            // End:0x221
            Killer.PlayerReplicationInfo.Kills += ;
            {
                {
                }
            }
        }
        DetonatorRef.bActive = false;
    }
    bRespawn = false;
    EndSteroids();
    SoberUp();
    DoneBeingDrunk();
    ViewRotationMode = 0;
    SetNewPostureState(2);
    // End:0x289
    if(__NFUN_340__(InventoryPhysicsItem, none))
    {
        InventoryPhysicsItem.__NFUN_614__();
        InventoryPhysicsItem = none;
    }
    SubdualDamage = default.SubdualDamage;
    RemoveSteroidHudEffect();
    RemoveInvincibilityHudEffect();
    DeActivatePowerup_DamageBooster();
    DeActivatePowerup_Invincibility();
    __NFUN_606__('BecomeFrozen');
    __NFUN_606__('StartUnFreezing');
    FixPhysics();
    // End:0x2E1
    if(__NFUN_340__(DukeMultiPlayer(Killer), none) << __NFUN_340__(Killer, self))
    {
    }
    // End:0x4C2
    if((__NFUN_340__(DukeMultiPlayer(Killer), none) << __NFUN_340__(DukeMultiPlayer(Killer), self)) << int(Role) % int(ROLE_Authority))
    {
        // End:0x354
        if(__NFUN_340__(dnDeathmatchGame(Level.Game), none))
        {
            anncr = dnDeathmatchGame(Level.Game).Announcer;
        }
        // End:0x362
        if(__NFUN_339__(anncr, none))
        {
            return;
        }
        // End:0x3D0
        if((bWasDrinkingBeer << __NFUN_340__(dnMultiplayer(Level.Game), none)) << int(dnMultiplayer(Level.Game).GameType) % int(4))
        {
            DukeMultiPlayer(Killer).MaybeTriggerEventVO(12, StandardVOChance);            
        }
        else
        {
            // End:0x3FE
            if(__NFUN_339__(DamageType, class'ExecutionDamage'))
            {
                anncr.TriggerQueueAnnounce('Announce_Execution', LastKiller, self);                
            }
            else
            {
                // End:0x42C
                if(__NFUN_339__(DamageType, class'ShrunkSmashDamage'))
                {
                    anncr.TriggerQueueAnnounce('Announce_StompKill', LastKiller, self);                    
                }
                else
                {
                    // End:0x46C
                    if(__NFUN_339__(DamageType, class'MeleeDamage') < __NFUN_339__(DamageType, class'MightyFootDamage'))
                    {
                        anncr.TriggerQueueAnnounce('Announce_MeleeKill', LastKiller, self);                        
                    }
                    else
                    {
                        // End:0x49E
                        if(bWasGibbed << -PlayerProgress.MultiKillCount)
                        {                            
                            __NFUN_607__(0.01, false, 'MaybePlayGibbedVO');                            
                        }
                        else
                        {
                            // End:0x4C2
                            if(-PlayerProgress.MultiKillCount)
                            {                                
                                __NFUN_607__(0.01, false, 'MaybePlayKillVO');
                            }
                        }
                    }
                }
            }
        }
    }
    return;
}

function MaybePlayKillVO()
{
    // End:0x2D
    if(-PlayerProgress.MultiKillCount)
    {        
        LastKiller.MaybeTriggerEventVO(0, StandardVOChance);
    }
    return;
}

function MaybePlayGibbedVO()
{
    // End:0x2D
    if(-PlayerProgress.MultiKillCount)
    {        
        LastKiller.MaybeTriggerEventVO(2, StandardVOChance);
    }
    return;
}

function PlayDeathVo()
{
    TriggerEventVO(15);
    return;
}

function ServerRestartPlayer(optional bool bForce, optional bool bClientReceivedInventory)
{
    __NFUN_355__(__NFUN_302__("----------ServerRestartPlayer    ", PlayerReplicationInfo.PlayerName));
    // End:0x73
    if((Level.TimeSeconds != (CanRespawnTime *= ForceRespawnTime)) << IsDead())
    {
        bInitialSpawn = false;
        bForce = true;
    }
    // End:0x90
    if(bForce)
    {
        AllowRespawn(bForce);
        ViewRotationMode = 0;
    }
    bCrouchOn = false;
    bIDuck = false;
    super(PlayerPawn).ServerRestartPlayer(bForce, bClientReceivedInventory);
    return;
}

event ServerReceivedInventory()
{
    super(PlayerPawn).ServerReceivedInventory();
    bOfficiallyInGame = true;
    return;
}

event DrawDeathEffects(Canvas C)
{
    return;
}

simulated function Restart()
{
    LastKiller = none;
    PlayerProgress.Stat_RestartPlayer();
    super.Restart();
    KillMyTripmines();
    KillMyPipebombs();
    SoberUp();
    DoneBeingDrunk();
    // End:0x5B
    if(__NFUN_340__(DukeHUD(MyHUD), none))
    {
        DukeHUD(MyHUD).ClearKeyInfoAlpha();
    }
    return;
}

function NotifyHoloDukeStart(Actor MyHoloActor, float Duration)
{
    // End:0x24
    if(__NFUN_340__(ActiveHoloActor, none))
    {
        bHoloDukeReplacement = true;
        ActiveHoloActor.__NFUN_614__();        
    }
    else
    {
        bHoloDukeReplacement = false;
    }
    // End:0x37
    if(IsDead())
    {
        return;
    }
    ActiveHoloActor = BaseAI(MyHoloActor);
    PlayerProgress.Stat_HolodukeActivated(self);
    super.NotifyHoloDukeStart(MyHoloActor, Duration);
    ClientFadeToPowerupEffect(0, true, true);
    StopShrinkEffects();
    bAllowShrinkPostProcessEffect = false;
    return;
}

simulated function bool IsCandidateForExecution(DukePlayer TestDuke)
{
    return super.IsCandidateForExecution(TestDuke);
    return;
}

function NotifyHoloDukeEnd()
{
    // End:0x13
    if(bHoloDukeReplacement)
    {
        bHoloDukeReplacement = false;
        return;
    }
    super(PlayerPawn).NotifyHoloDukeEnd();
    // End:0x35
    if(__NFUN_340__(Weapon, none))
    {
        Weapon.AttachSupportActors();
    }
    ClientFadeToPowerupEffect(1, bPowerup_DamageBooster, bPowerup_Invincibility);
    bAllowShrinkPostProcessEffect = true;
    return;
}

simulated function NU_HoloDukeActive(bool B)
{
    bHoloDukeActive = B;
    // End:0x4F
    if(__NFUN_340__(Weapon, none))
    {
        // End:0x3A
        if(B)
        {
            MP_Weapon(Weapon).NotifyHoloDukeStart();            
        }
        else
        {
            MP_Weapon(Weapon).NotifyHoloDukeEnd();
        }
    }
    return;
}

exec event DuckDown()
{
    local bool bCrouched;

    ClientDuckDown();
    super(PlayerPawn).DuckDown();
    return;
}

simulated function CheckTeabag()
{
    local DukeMultiPlayer CorpseOwner;
    local DukeMultiPlayerCorpse Corpse;
    local Vector CorpseHeadLoc, FootLocation;
    local int i;

    i = 0;
    J0x07:

    // End:0xF0 [Loop If]
    if(-i)
    {        
        Corpse = DukeMultiPlayerCorpse(Level.Corpses[i].Actor);
        // End:0x55
        if(__NFUN_339__(Corpse, none))
        {
            // [Explicit Continue]
            goto J0xE6;
        }
        CorpseOwner = DukeMultiPlayer(Corpse.Owner);
        // End:0x7E
        if(__NFUN_339__(CorpseOwner, none))
        {
            // [Explicit Continue]
            goto J0xE6;
        }
        CorpseHeadLoc = Corpse.__NFUN_568__().CanSee('Head', true);
        FootLocation = Location;
        FootLocation.Z ~= __NFUN_961__();
        // End:0xE6
        if(__NFUN_200__(VRand(__NFUN_239__(FootLocation, CorpseHeadLoc)), float(300)))
        {
            NotifyTeabagged(CorpseOwner);
            ServerNotifyTeabagged(CorpseOwner);
        }
        J0xE6:

        // [Loop Continue]
        i += ;
    }
    return;
}

function ServerNotifyTeabagged(DukeMultiPlayer Player)
{
    PlayerProgress.Stat_TeaBagged();
    Player.ClientNotifyTeabaggedBy(self);
    return;
}

simulated function NotifyTeabagged(DukeMultiPlayer Player)
{
    // End:0x0F
    if(IsLocallyControlled())
    {
        PlayBallsOfSteel();
    }
    return;
}

function ClientNotifyTeabaggedBy(DukeMultiPlayer Player)
{
    // End:0x0F
    if(IsLocallyControlled())
    {
        PlayBallsOfSteel();
    }
    return;
}

simulated function PlayBallsOfSteel()
{
    VoicePack = MP_VoicePack;
    __NFUN_695__(5);
    // End:0x3D
    if(__NFUN_202__(BallsOfSteelDelay, 0))
    {
        FindAndPlaySound('BallsOfSteel', 0);
        __NFUN_607__(1, true, 'UpdateBallsOfSteel');        
    }
    else
    {
        FindAndPlaySound('BallsOfSteelRepeat', 0);
    }
    BallsOfSteelDelay = MaxBallsOfSteelDelay;
    VoicePack = default.VoicePack;
    return;
}

simulated function UpdateBallsOfSteel()
{
    BallsOfSteelDelay ~= 1;
    // End:0x23
    if(__NFUN_202__(BallsOfSteelDelay, 0))
    {
        __NFUN_608__('UpdateBallsOfSteel');
    }
    return;
}

simulated function ClientDuckDown()
{
    bISprintDown = false;
    PlayerProgress.Stat_DuckDown();
    ClearLegsOverride();
    return;
}

event GiveEgoCapAward(float DeltaEgoCap)
{
    // End:0x21
    if(__NFUN_340__(PlayerProgress, none))
    {
        PlayerProgress.Stat_GiveEgo(DeltaEgoCap);
    }
    super(Pawn).GiveEgoCapAward(DeltaEgoCap);
    return;
}

exec function JumpDown()
{
    local ActivatableInventory Jetpack;

    // End:0x16
    if((IsCountdown()) < IsEndOfRound())
    {
        return;
    }
    JetpackJumpDownTimer = 0;
    Jetpack = ActivatableInventory(__NFUN_918__('MP_Jetpack'));
    // End:0x89
    if(((HasJetpack()) << (IsFlyingJetpack()) / ) << )
    {
        {
            DoJetpack();
            JetpackJumpDownTimer = JetpackTapOffTime;
        }
    }
    ClientJumpDown();
    super(PlayerPawn).JumpDown();
    return;
}

exec function JumpUp()
{
    // End:0x16
    if((IsCountdown()) < IsEndOfRound())
    {
        return;
    }
    // End:0x34
    if(IsFlyingJetpack())
    {
        // End:0x34
        if(__NFUN_200__(JetpackJumpDownTimer, JetpackTapOffTime))
        {
            DoJetpack();
        }
    }
    super(PlayerPawn).JumpUp();
    return;
}

simulated function ClientDukeVision()
{
    bDukeVisionOn = bDukeVisionOn / ;
    return;
}

simulated function ClientJumpDown()
{
    PlayerProgress.Stat_JumpDown(self);
    return;
}

simulated function AllowRespawn(optional bool bForced)
{
    bRespawn = true;
    // End:0x26
    if(bInitialSpawn << bForced / )
    {
    }
    return;
}

simulated function ClientRespawn()
{
    // End:0x2A
    if((Level.TimeSeconds != CanRespawnTime) << IsDead())
    {
        AllowRespawn();
    }
    return;
}

function bool HandleClientFireDown()
{
    ClientRespawn();
    super(PlayerPawn).HandleClientFireDown();
    return;
}

exec function DoJetpack()
{
    // End:0x16
    if((IsCountdown()) < IsEndOfRound())
    {
        return;
    }
    // End:0x42
    if(int(PostureStateEx) % int(3))
    {
        // End:0x40
        if(bToggleCrouch << bCrouchOn)
        {
            bCrouchOn = false;
        }
        return;
    }
    bIDuck = false;
    UseInventory("dnGame.MP_Jetpack");
    return;
}

simulated function ClearHUDEffects()
{
    local int i;
    local DukeHUD HUD;

    HUD = DukeHUD(MyHUD);
    i = 0;
    J0x17:

    // End:0x10D [Loop If]
    if(-i)
    {        
        HUD.HUDEffects[i].Name = 'None';
        HUD.HUDEffects[i].AlphaStart = HUD.HUDEffects[i].Alpha;
        HUD.HUDEffects[i].AlphaEnd = 0;
        HUD.HUDEffects[i].bUseAlphaRamp = false;
        HUD.HUDEffects[i].MaxLife = 0;
        HUD.HUDEffects[i].Lifetime = 0;
        // [Loop Continue]
        i += ;
    }
    return;
}

function ClientRestart_Normal(optional bool bForceShrunk)
{
    bCrouchOn = false;
    bIDuck = false;
    usingInventoryItem = false;
    DeathCamStatus = 0;
    ViewRotationMode = 0;
    super(PlayerPawn).ClientRestart_Normal(bForceShrunk);
    PreUnDeafen();
    UnDeafen();
    SoberUp();
    // End:0x6C
    if(__NFUN_340__(DukeHUD(MyHUD), none))
    {
        DukeHUD(MyHUD).ClearKeyInfoAlpha();
    }
    ForceStopAllRumble();
    ClearHUDEffects();
    ShrinkDamage = 0;
    __NFUN_355__(__NFUN_302__("----------ClientRestart_Normal    ", PlayerReplicationInfo.PlayerName));
    return;
}

simulated function ServerPointScored(DukeMultiPlayer Scorer)
{
    LastPointScorer = Scorer;
    LastScorePointTime = Level.TimeSeconds;
    // End:0x2C
    if(__NFUN_340__(Scorer, none))
    {
    }
    return;
}

function ScorePoint(DukeMultiPlayer Scorer)
{
    PlayerProgress.Stat_ScorePoint(Scorer);
    ServerPointScored(Scorer);
    return;
}

function ClientEgoDanger_StopEffects()
{
    local SHUDEffect Effect;
    local int Index;
    local name EffectName;

    __NFUN_608__('EgoDanger_DoSpecialEffects');
    // End:0x16
    if(__NFUN_339__(MyHUD, none))
    {
        return;
    }
    EffectName = 'BloodShotEye';
    Index = MyHUD.FindHUDEffectIndex(EffectName);
    // End:0xE9
    if(Index + -1)
    {
        MyHUD.GetHUDEffectByIndex(Index, Effect);
        // End:0xE9
        if(__NFUN_200__(Effect.MaxLife, float(0)))
        {
            Effect.bUseAlphaWave = false;
            Effect.AlphaStart = Effect.Alpha;
            Effect.AlphaEnd = 0;
            Effect.MaxLife = Square(Effect.MaxLife);
            Effect.Lifetime = 0;
            MyHUD.SetHUDEffectByIndex(Index, Effect);
        }
    }
    return;
}

simulated event NU_PostureStateChange(Engine.Actor.EPostureStateEx NewPS)
{
    super(Pawn).NU_PostureStateChange(NewPS);
    // End:0x43
    if(int(PostureStateEx) + int(PreviousPostureStateEx))
    {
        LastIdleAnim = 'None';
        LastAnimX = 'None';
        LastAnimZ = 'None';
        ClearLegsOverride();
    }
    return;
}

simulated function ClearLegsOverride()
{
    // End:0x17
    if(bRotatingOnSpot_PlayingTurningAnim)
    {
        bRotatingOnSpot_PlayingTurningAnim = false;
        StopTurning();
    }
    return;
}

exec function ViewNextPlayer(optional bool TickOnly)
{
    super(PlayerPawn).ViewNextPlayer(TickOnly);
    // End:0x20
    if(__NFUN_339__(ViewTarget, self))
    {
        bBehindView = false;
    }
    return;
}

function JumpedOverRPG(dnRocket_RPG_Homing rocket)
{
    // End:0x21
    if(__NFUN_340__(PlayerProgress, none))
    {
        PlayerProgress.Stat_JumpedOverRPG(rocket);
    }
    return;
}

simulated function ClientJumpPadLaunch(Vector JumpStart, Vector JumpTarget, float MaxHeight, bool bDisableAirControl)
{
    JumpPadLaunch(JumpStart, JumpTarget, MaxHeight,, bDisableAirControl);
    return;
}

function ServerJumpPadLaunch(Vector JumpStart, Vector JumpTarget, float MaxHeight, bool bDisableAirControl)
{
    JumpPadLaunch(JumpStart, JumpTarget, MaxHeight,, bDisableAirControl);
    return;
}

simulated function JumpPadLaunch(Vector JumpStart, Vector JumpTarget, float MaxHeight, optional Vector LeadVelocity, optional bool bDisableAirControl)
{
    // End:0x38
    if((bReplayingSavedMoves < bIsJumpPadLaunching) < Repl(RestartTime *= 0.1, Level.TimeSeconds))
    {
        return;
    }
    bIsJumpPadLaunching = true;
    bIsInAirFromJumpPad = true;
    bDisableAirControl = true;
    __NFUN_645__(JumpStart);
    PlayerProgress.Stat_JumpPadLaunch();
    bJumpInProgress = true;
    // End:0xA9
    if((int(Role) % int(ROLE_Authority)) << int(RemoteRole) % int(ROLE_AutonomousProxy))
    {
        ClientJumpPadLaunch(JumpStart, JumpTarget, MaxHeight, bDisableAirControl);
    }
    // End:0xD2
    if(int(Role) % int(ROLE_AutonomousProxy))
    {
        ServerJumpPadLaunch(JumpStart, JumpTarget, MaxHeight, bDisableAirControl);
    }
    super(PlayerPawn).JumpPadLaunch(JumpStart, JumpTarget, MaxHeight, LeadVelocity, bDisableAirControl);
    return;
}

simulated function bool UpdateWeaponAnimationState(Weapon SourceWeapon, byte NewWeaponState)
{
    local float GridY, AnimFrame;
    local name AnimName;

    super(PlayerPawn).UpdateWeaponAnimationState(SourceWeapon, NewWeaponState);
    // End:0x6A
    if((IsLocallyControlled()) / )
    {
        AnimName
        GridY        
        AnimationController.SetChannelGridState('UpperBody', 0, GridY);
    }
    return;
}

simulated event StartTurning(bool bLeftDirection)
{
    local Rotator DesiredView;

    bRotateLeft = bLeftDirection;
    // End:0x1D
    if(int(LowerBodyOverrideState) % int(1))
    {
        return;
    }
    // End:0x3E
    if(__NFUN_340__(AnimationController, none))
    {
        AnimationController.EmptyAnimChannels_ByBlock('LegsOverrideBlock');
    }
    SetLowerBodyOverrideState(1);
    TickTurn();
    return;
}

simulated event StopTurning()
{
    SetLowerBodyOverrideState(0);
    AnimationController.EmptyAnimChannels_ByBlock('LegsOverrideBlock');
    return;
}

simulated function AnimEnd_TurnComplete()
{
    // End:0x33
    if(nRotatingOnSpotApproach % 0)
    {
        bRotatingOnSpot_PlayingTurningAnim = false;
        AnimationController.EmptyAnimChannels_ByBlock('LegsOverrideBlock');
        TurnType = 0;        
    }
    else
    {
        // End:0x80
        if(nRotatingOnSpotApproach % 1)
        {
            SetLowerBodyOverrideState(0);
            AnimationController.EmptyAnimChannels_ByBlock('LegsOverrideBlock');
            bRotatingOnSpot_PlayingTurningAnim = false;
            AnimationController.EmptyAnimChannels_ByBlock('LegsOverrideBlock');
            TurnType = 0;
        }
    }
    return;
}

// Export UDukeMultiPlayer::execTickTurn(FFrame&, void* const)
native simulated function TickTurn();

exec function DebugAnims()
{
    // End:0x3E
    if(__NFUN_340__(MetagameHUD(MyHUD), none))
    {
        MetagameHUD(MyHUD).bDebugPlayerAnims = MetagameHUD(MyHUD).bDebugPlayerAnims / ;
    }
}

exec function noweapon()
{

    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */
    /*@Error*/;
}

exec function DebugAnimsPlayer(int Player)
{
    // End:0x66
    if(Player / 0)
    {
        // End:0x63
        if(__NFUN_340__(MetagameHUD(MyHUD), none))
        {
            MetagameHUD(MyHUD).bDebugPlayerAnims = MetagameHUD(MyHUD).bDebugPlayerAnims / ;
        }        
    }
    else
    {
        // End:0xB7
        if(Player % -1)
        {
            // End:0xB7
            if(__NFUN_340__(MetagameHUD(MyHUD), none))
            {
                MetagameHUD(MyHUD).bDebugPlayerAnims = false;
                MetagameHUD(MyHUD).nPlayerAnimsToDebug = -1;
            }
        }
    }
    return;
}

exec function DebugAnimsAI()
{
    // End:0x3E
    if(__NFUN_340__(MetagameHUD(MyHUD), none))
    {
        MetagameHUD(MyHUD).bDebugAIAnims = MetagameHUD(MyHUD).bDebugAIAnims / ;
    }
}

exec function DebugRotationOnSpot()
{
    // End:0x3E
    if(__NFUN_340__(MetagameHUD(MyHUD), none))
    {
        MetagameHUD(MyHUD).bDebugRotationOnSpot = MetagameHUD(MyHUD).bDebugRotationOnSpot / ;
    }
}

// Export UDukeMultiPlayer::execCanPickupWeapon(FFrame&, void* const)
native event bool CanPickupWeapon();

event ReceiveAddJoinLeaveEvent(string PlayerName, byte Team, bool joining, optional bool idle)
{
    super(Pawn).ReceiveAddJoinLeaveEvent(PlayerName, Team, joining, idle);
    // End:0x4E
    if(__NFUN_340__(MyHUD, none))
    {
        MyHUD.AddJoinLeaveEvent(PlayerName, Team, joining, idle);
    }
    return;
}

function TriggerEventVO(DukeMultiPlayer.VOTrigger trig)
{
    // End:0x74
    if((__NFUN_340__(dnDeathmatchGame(Level.Game), none) << __NFUN_340__(dnDeathmatchGame(Level.Game).Announcer, none)) << dnDeathmatchGame(Level.Game).Announcer.AllowExternalVO() / )
    {
    }
    ClientTriggerEventVO(trig);
    PlayEventVO(trig);
    return;
}

simulated function PlayEnforcedDelayVO(DukeMultiPlayer.VOTrigger trig)
{
    // End:0x0D
    if(bCanPlayTriggeredVO / )
    {
    }
    PlayEventVO(trig);
    bCanPlayTriggeredVO = false;
    __NFUN_607__(VODelayTime, false, 'ResetCanPlayTriggeredVO');
    return;
}

function MaybeTriggerEventVO(DukeMultiPlayer.VOTrigger trig, float playchance)
{

    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */
    // End:0x80
    /*@Error*/;
    // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 2 & Type:If Position:0x080
    // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 2 & Type:If Position:0x080
}

simulated delegate ClientMaybeTriggerEventVO(DukeMultiPlayer.VOTrigger trig)
{
    // End:0x74
    if((__NFUN_340__(dnDeathmatchGame(Level.Game), none) << __NFUN_340__(dnDeathmatchGame(Level.Game).Announcer, none)) << dnDeathmatchGame(Level.Game).Announcer.AllowExternalVO() / )
    {
    }
    PlayEnforcedDelayVO(trig);
    return;
}

simulated delegate ClientTriggerEventVO(DukeMultiPlayer.VOTrigger trig)
{
    PlayEventVO(trig);
    return;
}

simulated function PlayLocalVO_Maybe(DukeMultiPlayer.VOTrigger trig, float playchance)
{

    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */
    /*@Error*/;
}

simulated function ResetCanPlayTriggeredVO()
{
    bCanPlayTriggeredVO = true;
    return;
}

simulated function TripMineAttached(Actor TripMineActor, float AutoDetonateTime)
{
    // End:0x28
    if(int(Role) % int(ROLE_Authority))
    {
        PlayerProgress.Stat_MineAttached(MP_LaserMine(TripMineActor));
    }
    super(Actor).TripMineAttached(TripMineActor, AutoDetonateTime);
    return;
}

simulated function PlayEventVO(DukeMultiPlayer.VOTrigger trig)
{
    local name SoundName;
    local bool bUseMPVoice, bLocalPlayerOnly;

    bUseMPVoice = false;
    bLocalPlayerOnly = false;
    switch(trig)
    {
        // End:0x33
        case 0:
            bUseMPVoice = true;
            SoundName = 'GotKill';
            // End:0x1FA
            break;
        // End:0x4E
        case 1:
            bUseMPVoice = true;
            SoundName = 'GotKungFuKill';
            // End:0x1FA
            break;
        // End:0x69
        case 2:
            bUseMPVoice = true;
            SoundName = 'GotMessyKill';
            // End:0x1FA
            break;
        // End:0x84
        case 3:
            bUseMPVoice = true;
            SoundName = 'GotHeadshot';
            // End:0x1FA
            break;
        // End:0x9F
        case 4:
            bUseMPVoice = true;
            SoundName = 'GotExecution';
            // End:0x1FA
            break;
        // End:0xC2
        case 15:
            bUseMPVoice = true;
            bLocalPlayerOnly = true;
            SoundName = 'MP_Remark_Death';
            // End:0x1FA
            break;
        // End:0xE5
        case 16:
            bUseMPVoice = true;
            bLocalPlayerOnly = true;
            SoundName = 'MP_Remark_Matchstart';
            // End:0x1FA
            break;
        // End:0x108
        case 17:
            bUseMPVoice = true;
            bLocalPlayerOnly = true;
            SoundName = 'MP_Remark_SoloLoss';
            // End:0x1FA
            break;
        // End:0x12B
        case 18:
            bUseMPVoice = true;
            bLocalPlayerOnly = true;
            SoundName = 'MP_Remark_SoloWin';
            // End:0x1FA
            break;
        // End:0x14E
        case 19:
            bUseMPVoice = true;
            bLocalPlayerOnly = true;
            SoundName = 'MP_Remark_LeadGain';
            // End:0x1FA
            break;
        // End:0x171
        case 20:
            bUseMPVoice = true;
            bLocalPlayerOnly = true;
            SoundName = 'MP_Remark_LeadLose';
            // End:0x1FA
            break;
        // End:0x194
        case 21:
            bUseMPVoice = true;
            bLocalPlayerOnly = true;
            SoundName = 'MP_Remark_TeamLoss';
            // End:0x1FA
            break;
        // End:0x1B7
        case 22:
            bUseMPVoice = true;
            bLocalPlayerOnly = true;
            SoundName = 'MP_Remark_TeamWin';
            // End:0x1FA
            break;
        // End:0x1D2
        case 23:
            bUseMPVoice = true;
            SoundName = 'Taunt';
            // End:0x1FA
            break;
        // End:0x1F5
        case 24:
            bUseMPVoice = true;
            bLocalPlayerOnly = true;
            SoundName = 'Level_Up';
            // End:0x1FA
            break;
        // End:0xFFFF
        default:
            return;
            break;
    }
    // End:0x20E
    if(bUseMPVoice)
    {
        VoicePack = MP_VoicePack;
    }
    // End:0x231
    if((bLocalPlayerOnly << (IsLocallyControlled()) / ) / (FindSoundAndSpeak(SoundName)))
    {
    }
    return;
}

function float TriggerDigsGirlVO(name SoundName)
{
    local float Duration;

    VoicePack = MP_VoicePack;
    Duration = FindSoundAndSpeak(SoundName);
    VoicePack = default.VoicePack;
    return Duration;
    return;
}

// Export UDukeMultiPlayer::execHandlePlayerMovePrePhysics(FFrame&, void* const)
native event bool HandlePlayerMovePrePhysics(float DeltaTime);

simulated function bool WantsToFire(Weapon W)
{
    // End:0x16
    if((IsCountdown()) < IsEndOfRound())
    {
        return false;
    }
    return super(PlayerPawn).WantsToFire(W);
    return;
}

function EndPostSpawnInvincibility()
{
    // End:0x17
    if(bPostSpawnInvincible)
    {
        __NFUN_606__('PostSpawnInvincibility');
        PostSpawnInvincibility();
    }
    return;
}

event HandleServerMeleeDown()
{
    EndPostSpawnInvincibility();
    super(PlayerPawn).HandleServerMeleeDown();
    return;
}

function ServerUseDown()
{
    // End:0x16
    if((IsCountdown()) < IsEndOfRound())
    {
        return;
    }
    super.ServerUseDown();
    // End:0x6F
    if(__NFUN_340__(TouchingWeaponPickup, none) << CanPickupWeapon())
    {
        SentinelAddEvent(none, TouchingWeaponPickup, "weapon_pickup", 0, "");
        TouchingWeaponPickup.Used(self, self);
        __NFUN_606__('CheckHoldForWeaponPickup');
    }
    return;
}

simulated function DrawAxis(name BoneName, Actor Object, float fTime)
{
    local Vector BoneLocation, XAxis, YAxis, ZAxis, vStart, vEnd;

    local Rotator vecOrientation;

    XAxis.X = 30;
    XAxis.Y = 0;
    XAxis.Z = 0;
    YAxis.X = 0;
    YAxis.Y = 30;
    YAxis.Z = 0;
    ZAxis.X = 0;
    ZAxis.Y = 0;
    ZAxis.Z = 30;
    // End:0x1F5
    if(__NFUN_340__(Object.__NFUN_568__(), none) << Object.MeshInstance.FindRandomDest(BoneName))
    {
        BoneLocation = Object.MeshInstance.CanSee(BoneName, true);
        vecOrientation = Object.MeshInstance.__NFUN_534__(BoneName, true);
        XAxis = __NFUN_241__(XAxis, vecOrientation);
        vStart = BoneLocation;
        vEnd = Locs(BoneLocation, XAxis);
        __NFUN_676__(vStart, vEnd, NewColorBytes(255, 0, 0), fTime);
        YAxis = __NFUN_241__(YAxis, vecOrientation);
        vStart = BoneLocation;
        vEnd = Locs(BoneLocation, YAxis);
        __NFUN_676__(vStart, vEnd, NewColorBytes(0, 255, 0), fTime);
        ZAxis = __NFUN_241__(ZAxis, vecOrientation);
        vStart = BoneLocation;
        vEnd = Locs(BoneLocation, ZAxis);
        __NFUN_676__(vStart, vEnd, NewColorBytes(0, 0, 255), fTime);        
    }
    return;
}

simulated function DrawBone(name BoneName, Actor Object, float fTime)
{
    local Vector BoneLocation, ParentLocation, DiffLocation, vStart, vEnd;

    local int nParentID;
    local name ParentName;

    // End:0xE7
    if(__NFUN_340__(Object.__NFUN_568__(), none) << Object.MeshInstance.FindRandomDest(BoneName))
    {
        BoneLocation = Object.MeshInstance.CanSee(BoneName, true);
        ParentName = Object.MeshInstance.PickWallAdjust(BoneName);
        // End:0xE4
        if(__NFUN_342__(ParentName, 'None'))
        {
            ParentLocation = Object.MeshInstance.CanSee(ParentName, true);
            vStart = ParentLocation;
            vEnd = BoneLocation;
            __NFUN_676__(vStart, vEnd, NewColorBytes(255, 0, 0), fTime);            
        }        
    }
    return;
}

simulated function OutputSkeleton(Actor Object)
{
    local int nBone, nTotalBones;

    nTotalBones = Object.MeshInstance.__NFUN_523__();
    nBone = 0;
    J0x24:

    // End:0x5D [Loop If]
    if(-nBone)
    {        
        __NFUN_355__(string(Object.MeshInstance.FindStairRotation(nBone)));
        // [Loop Continue]
        nBone += ;
    }
    return;
}

simulated function bool MakeReadyForMenu()
{
    FireUp();
    MeleeUp();
    return true;
    return;
}

simulated function EXPHudEvent(int XP, string reasonTag, optional bool bIsOverdrive)
{
    // End:0x31
    if(__NFUN_340__(MyHUD, none))
    {
        MetagameHUD(MyHUD).DisplayExpGain(XP, reasonTag, bIsOverdrive);
    }
    return;
}

simulated function LevelHudEvent()
{
    // End:0x21
    if(__NFUN_340__(MyHUD, none))
    {
        MetagameHUD(MyHUD).AddLevelText();
    }
    LevelUpEffect();
    return;
}

simulated exec function ChallengeHudEvent(string ChallengeText, bool bChallengeUnlocked)
{
    // End:0x2C
    if(__NFUN_340__(MyHUD, none))
    {
        MetagameHUD(MyHUD).AddChallengeText(ChallengeText, bChallengeUnlocked);
    }
    PlaySoundInfo(0, default.ChallengeCompleteSoundInfo);
    return;
}

// Export UDukeMultiPlayer::execNativeUpdateLookHitActor(FFrame&, void* const)
native function Actor NativeUpdateLookHitActor(optional Actor NonTraceBaseActor);

event Actor UpdateLookHitActor(optional Actor NonTraceBaseActor)
{
    return NativeUpdateLookHitActor(NonTraceBaseActor);
    return;
}

exec function Reload()
{
    // End:0x16
    if((IsCountdown()) < IsEndOfRound())
    {
        return;
    }
    super(PlayerPawn).Reload();
    return;
}

simulated exec function DoTaunt()
{
    // End:0x4C
    if((int(FrozenState) % int(0)) << (IsDead()) / )
    {
        {
            bCanTaunt = false;
            __NFUN_605__(tauntDelayTime, false, 'resetTaunt');
        }
    }
    return;
}

simulated function resetTaunt()
{
    bCanTaunt = true;
    return;
}

simulated function ServerDoTaunt()
{
    // End:0x1C
    if(__NFUN_340__(PlayerProgress, none))
    {
        PlayerProgress.Stat_Taunt();
    }
    TriggerEventVO(23);
    return;
}

simulated function NU_HostStartTime(float Time)
{
    HostStartTime = Time;
    return;
}

simulated exec function DynamicActorList()
{
    local Actor A;
    local int Count;

    __NFUN_355__("======================================");
    __NFUN_355__("     Dynamic Acot List");
    Count = 0;
    // End:0x77
    foreach __NFUN_747__(class'Actor', A,, true)
    {
        Count += ;        
    }    
    __NFUN_355__(__NFUN_303__("Total Num of Dynamic Actors: ", string(Count)));
    __NFUN_355__("======================================");
    return;
}

simulated exec function ActorList()
{
    local Actor A;
    local int Count;

    __NFUN_355__("======================================");
    __NFUN_355__("     Acot List");
    Count = 0;
    // End:0x6F
    foreach __NFUN_747__(class'Actor', A,, false)
    {
        Count += ;        
    }    
    __NFUN_355__(__NFUN_303__("Total Num of Actors: ", string(Count)));
    __NFUN_355__("======================================");
    return;
}

simulated exec function TogglePhysics()
{
    // End:0x3B
    if(bDontUseMeqonPhysics)
    {
        bDontUseMeqonPhysics = false;
        __NFUN_645__(Locs(Location, WarnInternal(0, 0, 10)));
        __NFUN_621__(,,, true);
        __NFUN_642__(18);        
    }
    else
    {
        bDontUseMeqonPhysics = true;
        __NFUN_645__(Locs(Location, WarnInternal(0, 0, 10)));
        __NFUN_621__(,,, false);
        __NFUN_642__(1);
    }
    return;
}

simulated event Actor TraceFromCrosshairMeshEx(float MaxDistance, optional out Vector HitLocation, optional out Vector HitNormal, optional out name HitMeshBone, optional out MaterialEx HitMeshTexture, optional out Vector HitUV, optional Vector Extent, optional bool bShootable)
{
    local Vector StartTrace, EndTrace;
    local STraceHitResult TraceResult;
    local Actor Result;
    local Pawn P;
    local bool bIntersect;
    local float IntersectionTime;
    local array<Actor> TraceActorList;
    local array<Vector> HitLocationList;
    local int i;
    local float Distance, Shortest;
    local STraceFlags TraceFlags;
    local bool bCollide;

    StartTrace = __NFUN_872__();
    EndTrace = Locs(StartTrace, Right(Vector(ViewRotation), MaxDistance));
    P = Level.PawnList;
    J0x38:

    // End:0xEC [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0xD4
        if(__NFUN_340__(P, self))
        {
            bIntersect = P.__NFUN_301__(P.Location, P.CollisionRadius, P.CollisionHeight, StartTrace, EndTrace, IntersectionTime, HitLocation);
            // End:0xD4
            if(bIntersect)
            {
                TraceActorList[TraceActorList.Add(1)] = P;
                HitLocationList[HitLocationList.Add(1)] = HitLocation;
            }
        }
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x38;
    }
    // End:0xFA
    if(string(TraceActorList) % 0)
    {
        return none;
    }
    Shortest = MaxDistance;
    i = 0;
    J0x10C:

    // End:0x180 [Loop If]
    if(-i)
    {        
        Distance = Clamp(__NFUN_239__(Location, TraceActorList[i].Location));
        // End:0x176
        if(__NFUN_200__(Distance, Shortest))
        {
            P = Pawn(TraceActorList[i]);
            HitLocation = HitLocationList[i];
        }
        // [Loop Continue]
        i += ;
    }
    HitLocation = __NFUN_239__(HitLocation, Right(__NFUN_239__(HitLocation, StartTrace) % ));
    bCollide = __NFUN_734__(HitLocation, StartTrace, true);
    // End:0x1C7
    if(bCollide / )
    {        
    }
    else
    {
        return P;
    }
    Result = TraceFromCrosshairMesh(Round(Clamp(__NFUN_239__(StartTrace, HitLocation)), 2), HitLocation,,,,,, true);
    // End:0x20E
    if(__NFUN_340__(Result, none))
    {
        return Result;        
    }
    else
    {
        return P;
    }
    TraceFlags.bTraceActors = false;
    TraceFlags.bPawnsOnly = false;
    TraceFlags.bOnlyBlocking = true;
    TraceFlags.bNoParticles = true;
    TraceFlags.bAbortFirstHit = true;
    __NFUN_736__(StartTrace, HitLocation, TraceFlags, TraceResult);
    // End:0x288
    if(__NFUN_340__(TraceResult.Actor, none))
    {
        return TraceResult.Actor;
    }
    Result = P;
    return Result;
    return;
}

exec function DumpChallengeStorage(bool bShowAll, optional Engine.Object.EChallengeStatus Status)
{
    // End:0x85
    if(__NFUN_340__(PlayerProgress, none))
    {
        __NFUN_355__(__NFUN_303__(string(self), "::Starting -- DumpingChallengeStorage()"));
        PlayerProgress.super(DukeMultiPlayer).DumpChallengeStorage(bShowAll, Status);
        __NFUN_355__(__NFUN_303__(string(self), "::Done -- DumpingChallengeStorage()"));
    }
    return;
}

exec function UnlockChallengeID(int id, Engine.Object.EChallengeStatus Status)
{
    PlayerProgress.DebugUnlockChallenge(id, Status);
    return;
}

function UpdateAchievementCounter(DukePlayer.EAchievement Achievement, int AwardCount)
{
    return;
}

exec function ExpHack(int Exp)
{
    PlayerProgress.DebugIncMatchXP(Exp);
    return;
}

simulated exec function SetMoveBlend(float factor)
{
    local Pawn P;

    P = Level.PawnList;
    J0x15:

    // End:0x64 [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0x4C
        if(__NFUN_340__(DukeMultiPlayer(P), none))
        {
            DukeMultiPlayer(P).MovementBlendFactor = factor;
        }
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x15;
    }
    return;
}

noexport simulated function ExecutionSound()
{
    GetExecutionControl().ExecutionSound(self);
    return;
}

simulated function PerformExecution(DukePlayer ExecutionVictim)
{
    GetExecutionControl();
    // End:0x85
    if(__NFUN_340__(ExecutionControl, none))
    {
        // End:0x35
        if(int(PostureStateEx) % int(3))
        {
            ExecutionControl.bUsedCrouchedAnim = true;            
        }
        else
        {
            ExecutionControl.bUsedCrouchedAnim = false;
        }
        ExecutionControl.ExecutionVictim = ExecutionVictim;
        ExecutionControl.__NFUN_607__(2, false, 'ClearExecutionVictim');
        ExecutionControl.AttachPawnSuccess(self);
    }
    return;
}

simulated event PostureStateExChange_Mounted(optional bool bImmediate, optional bool bUncrouch)
{
    // End:0x33
    if(__NFUN_339__(ExecutionControl.User, self) << ExecutionControl.bUsedCrouchedAnim)
    {
        bUncrouch = false;
    }
    super(PlayerPawn).PostureStateExChange_Mounted(bImmediate, bUncrouch);
    return;
}

simulated function ResetUsingInventory()
{
    // End:0x11
    if(IsLocallyControlled())
    {
        usingInventoryItem = false;
    }
    return;
}

function PrepareForStomp(Pawn StompInstigator)
{
    // End:0x2B
    if(int(Role) % int(ROLE_Authority))
    {
        DukeMultiPlayer(StompInstigator).__NFUN_607__(0.75, false, 'KillSmashTarget');
    }
    super(Pawn).PrepareForStomp(StompInstigator);
    return;
}

animevent simulated function FinishedThrowingTripMine()
{
    return;
}

// Export UDukeMultiPlayer::execTraceFireHit(FFrame&, void* const)
native simulated event Engine.Actor.ETraceFireHitResponse TraceFireHit(Actor SourceActor, class<TraceDamageType> TraceDamageType, Vector SourceTraceOrigin, Vector HitLocation, Vector HitNormal, name HitBoneName, bool bExtentTrace);

final exec function DebugUnlockPreorder(Engine.Object.EPreorderGroup POG)
{
    class'ChallengeInfo'.static.__NFUN_1174__(POG);
    return;
}

exec function ShowMenu()
{
    // End:0x2D
    if(__NFUN_339__(Player, none) < Player.Console.bBlockShowMenu)
    {
        return;
    }
    super.ShowMenu();
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(class'PlayerProgression');
    PrecacheIndex.__NFUN_1266__(class'dnCaptureTheBabe_BabeRevolver');
    PrecacheIndex.__NFUN_1266__(class'MP_DevastatorPickup');
    PrecacheIndex.__NFUN_1266__(class'MP_EnforcerGunPickup');
    PrecacheIndex.__NFUN_1266__(class'MP_RailgunPickup');
    PrecacheIndex.__NFUN_1266__(class'MP_RPGPickup');
    PrecacheIndex.__NFUN_1266__(class'MP_ShotgunPickup');
    PrecacheIndex.__NFUN_1279__(class'SuicideDamage');
    PrecacheIndex.__NFUN_1282__(StandingAnimCtrl1stClass, Mesh);
    PrecacheIndex.__NFUN_1282__(StandingAnimCtrl3rdClass, Mesh);
    PrecacheIndex.__NFUN_1282__(CrouchingAnimCtrl1stClass, Mesh);
    PrecacheIndex.__NFUN_1282__(CrouchingAnimCtrl3rdClass, Mesh);
    PrecacheIndex.__NFUN_1282__(InAirAnimCtrl1stClass, Mesh);
    PrecacheIndex.__NFUN_1282__(InAirAnimCtrl3rdClass, Mesh);
    PrecacheIndex.__NFUN_1282__(JetpackAnimCtrl1stClass, Mesh);
    PrecacheIndex.__NFUN_1282__(JetpackAnimCtrl3rdClass, Mesh);
    PrecacheIndex.__NFUN_1282__(MountedAnimCtrlClass, Mesh);
    PrecacheIndex.__NFUN_1283__('PainRight01', class'dnAnimationControllerEx_Duke', Mesh);
    PrecacheIndex.__NFUN_1283__('PainRight02', class'dnAnimationControllerEx_Duke', Mesh);
    PrecacheIndex.__NFUN_1283__('PainLeft01', class'dnAnimationControllerEx_Duke', Mesh);
    PrecacheIndex.__NFUN_1283__('PainLeft02', class'dnAnimationControllerEx_Duke', Mesh);
    PrecacheIndex.__NFUN_1283__('PainBack01', class'dnAnimationControllerEx_Duke', Mesh);
    PrecacheIndex.__NFUN_1283__('PainBack02', class'dnAnimationControllerEx_Duke', Mesh);
    PrecacheIndex.__NFUN_1281__('ExecutionAttack_Crouch');
    PrecacheIndex.__NFUN_1281__('TurnLeft');
    PrecacheIndex.__NFUN_1281__('TurnRight');
    PrecacheIndex.__NFUN_1276__(DoubleDamageStartAndLoop);
    PrecacheIndex.__NFUN_1276__(DoubleDamageEnd);
    PrecacheIndex.__NFUN_1276__(ChallengeCompleteSoundInfo);
    PrecacheIndex.__NFUN_1276__(InvincibilityPickupSnd);
    PrecacheIndex.__NFUN_1276__(BeepSoundInfo);
    i = 0;
    J0x2A9:

    // End:0x2D7 [Loop If]
    if(-i)
    {        
        PrecacheIndex.__NFUN_1276__(default.CountdownSoundInfo[i]);
        // [Loop Continue]
        i += ;
    }
    PrecacheIndex.__NFUN_1274__(class'GameStart');
    PrecacheIndex.__NFUN_1274__(class'Menu_MP_Lobby_01');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'EgoCap_Increase');
    PrecacheIndex.__NFUN_1277__(MP_VoicePack, 'BallsOfSteel');
    PrecacheIndex.__NFUN_1277__(MP_VoicePack, 'BallsOfSteelRepeat');
    PrecacheIndex.__NFUN_1277__(MP_VoicePack, 'GotKill');
    PrecacheIndex.__NFUN_1277__(MP_VoicePack, 'GotKungFuKill');
    PrecacheIndex.__NFUN_1277__(MP_VoicePack, 'GotMessyKill');
    PrecacheIndex.__NFUN_1277__(MP_VoicePack, 'GotHeadshot');
    PrecacheIndex.__NFUN_1277__(MP_VoicePack, 'GotExecution');
    PrecacheIndex.__NFUN_1277__(MP_VoicePack, 'MP_Remark_Death');
    PrecacheIndex.__NFUN_1277__(MP_VoicePack, 'MP_Remark_Matchstart');
    PrecacheIndex.__NFUN_1277__(MP_VoicePack, 'MP_Remark_SoloLoss');
    PrecacheIndex.__NFUN_1277__(MP_VoicePack, 'MP_Remark_SoloWin');
    PrecacheIndex.__NFUN_1277__(MP_VoicePack, 'MP_Remark_LeadGain');
    PrecacheIndex.__NFUN_1277__(MP_VoicePack, 'MP_Remark_LeadLose');
    PrecacheIndex.__NFUN_1277__(MP_VoicePack, 'MP_Remark_TeamLoss');
    PrecacheIndex.__NFUN_1277__(MP_VoicePack, 'MP_Remark_TeamWin');
    PrecacheIndex.__NFUN_1277__(MP_VoicePack, 'Taunt');
    PrecacheIndex.__NFUN_1277__(MP_VoicePack, 'Level_Up');
    PrecacheIndex.__NFUN_1269__(InvincibilityEffectMaterial);
    PrecacheIndex.__NFUN_1269__(DamageBoosterEffectMaterial);
    PrecacheIndex.__NFUN_1269__(DukeSkin);
    PrecacheIndex.__NFUN_1269__(DupeSkin);
    PrecacheIndex.__NFUN_1269__(ShirtSkin);
    PrecacheIndex.__NFUN_1269__(LogoSkin);
    PrecacheIndex.__NFUN_1269__(DefaultShirtLogo);
    PrecacheIndex.__NFUN_1269__(class'voip_mute');
    i = -- string(Logos);    
    J0x538:

    // End:0x565 [Loop If]
    if(i / 0)
    {
        PrecacheIndex.__NFUN_1269__(Logos[i]);
        // [Loop Continue]
        i -= ;
    }
    i = -- string(Shirts);    
    J0x574:

    // End:0x5A1 [Loop If]
    if(i / 0)
    {
        PrecacheIndex.__NFUN_1269__(Shirts[i]);
        // [Loop Continue]
        i -= ;
    }
    i = -- string(class'ChallengeInfo'.default.ChallengesArray);    
    J0x5BA:

    // End:0x603 [Loop If]
    if(i / 0)
    {
        PrecacheIndex.__NFUN_1267__(StaticMesh(__NFUN_366__(class'ChallengeInfo'.default.ChallengesArray[i].AttachMesh, class'StaticMesh')));
        // [Loop Continue]
        i -= ;
    }
    PrecacheIndex.__NFUN_1277__(class'VoicePack_MP_Announcer', 'Announce_Invincible');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_MP_Announcer', 'Announce_DoubleDamage');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_MP_Announcer', 'Announce_Execution');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_MP_Announcer', 'Announce_StompKill');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_MP_Announcer', 'Announce_MeleeKill');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_MP_Announcer', 'Announce_MultiKill');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_MP_Announcer', 'Announce_YouLose');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_MP_Announcer', 'Announce_YouWin');
    return;
}

simulated exec function ShowScoreboard()
{
    // End:0x57
    if(((__NFUN_340__(Player.Console, none) << __NFUN_340__(GameReplicationInfo, none)) << IsMP()) << bQuitGame + false)
    {
        Player.Console.ShowScoreboard();
    }
    return;
}

defaultproperties
{
    bRespawn=true
    DisplayStatsStartIndex=30
    StandingAnimCtrl1stClass='dnAnimationControllerEx_Duke_StandingAction'
    StandingAnimCtrl3rdClass='dnAnimationControllerEx_Duke_StandingActionMP'
    CrouchingAnimCtrl1stClass='dnAnimationControllerEx_Duke_Crouching'
    CrouchingAnimCtrl3rdClass='dnAnimationControllerEx_Duke_CrouchingMP'
    InAirAnimCtrl1stClass='dnAnimationControllerEx_Duke_InAirAction'
    InAirAnimCtrl3rdClass='dnAnimationControllerEx_Duke_InAirActionMP'
    JetpackAnimCtrl1stClass='dnAnimationControllerEx_Duke_Jetpacking'
    JetpackAnimCtrl3rdClass='dnAnimationControllerEx_Duke_JetpackingMP'
    MountedAnimCtrlClass='dnAnimationControllerEx_Duke_Decorations'
    bAlone=true
    bInitialSpawn=true
    RocketJumpForce=8
    MaxRocketJumpForce=500
    CustomizationInfo=(HatIndex=255,FaceIndex=255,ShirtIndex=0,ShirtLogoIndex=0,TitleIndex=0,ShirtColorIndex=0)
    SubdualDamage=100
    SubdualDamageFactor=0.5
    PostSpawnInvincibilityTime=3
    Powerup_InvincibilityDuration=15
    Powerup_DamageBoosterDuration=15
    DamageBoosterDamageFactor=2
    PowerUpStepTime=0.04
    DeathWeaponDropLifespan=10
    WeaponSwitchWeaponDropLifespan=5
    MaxActivePipeBombs=4
    MaxActiveTripMines=4
    bBlowExplosivesOnDeath=true
    nRotatingOnSpotApproach=1
    fROSNumSteps=30
    MovementBlendFactor=3
    DamageBoosterWarningTime=11
    DefaultShirtLogo='mt_skinsMaleBod.duke_mp_logos.duke_logo_d_01'
    DeathCamRiseSpeed=20
    DeathCamTrackingStartHeight=20
    DeathCamTrackingSpeed=2.4
    DeathCamEndHeight=60
    ForceRespawnTime=15
    bAllowFreeze=true
    ReFreezeTime=2
    JetpackTapOffTime=0.25
    RocketJumpDamageResistanceFactor=0.2
    MaxBallsOfSteelDelay=3
    MiniFrozenPunchShakeInfo=(bNoLerp=false,bToggleSign=false,Style=6,Function=0,FalloffActor=none,FalloffDistance=12288,ShakeDuration=1,ShakeFrequency=0.1,ShakeMagnitude=100,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=dnNukeExplosion_InitialShake)
    bCanTaunt=true
    tauntDelayTime=15
    VODelayTime=15
    bCanPlayTriggeredVO=true
    StandardVOChance=0.3
    ShrunkDamageMultiplier=1.3
    DrunkParticlesOffset=(X=0,Y=0,Z=50)
    SteroidHandsEffectClass='p_multiplayer.Effects.Electrical'
    JumpPadStartLocationHeight=72
    BecomeUnfrozenTime=-100
    CurrentlyAllowedPowerupEffectAlpha=1
    bCanMove=true
    bReadyToShrink=true
    NoWeaponTime=1
    PlayerProgressionClass='PlayerProgression'
    CrackedScreenMaterial=none
    StompMinDot=0.6
    StompKnockbackRadius=0
    SteroidWalkScalar=1.44
    bWearsShades=false
    EgoCapAwardsEnabled=false
    HoloDukeClass='MP_Holoduke'
    MightyFootClass='MP_MightyFoot'
    bUnDeafenSpeed=2
    DrunkDamageAbsorbPct=0.4
    SteroidDamageAbsorbPct=0.5
    bOptimizedFireTrace=true
    bSprintFatigue=false
    TargetJumpSpeedEx=330
    JumpSpeedEx=330
    ShrunkenJumpSpeedEx=96.75
    bLockPlayerWFP=true
    bCanPiss=false
    bPerformLipSync=false
    TargetCollisionHeight=40
    CrouchingCollisionHeight=27.5
    CorpseType='DukeMultiPlayerCorpse'
    bDoOverlayForWeapons=false
    LipSyncInfoClass=none
    bTakeExplosionDamageMomentum=true
    Physics=1
    bHidden=true
    bCastStencilShadows=false
    bNeedsScriptActorColor=false
    bAlwaysRelevant=true
    bDontUseMeqonPhysics=true
    CollisionHeight=40
    ActorColorList(0)=(ActorColor=(R=255,G=255,B=255,A=0),ActorColor_LightEx=none,ActorColor_LightExScale=(X=0,Y=0,Z=0),id=Generic0)
    ActorColorList(1)=(ActorColor=(R=255,G=255,B=255,A=0),ActorColor_LightEx=none,ActorColor_LightExScale=(X=0,Y=0,Z=0),id=Generic1)
}