/*******************************************************************************
 * DukeMyDigsPlayer generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class DukeMyDigsPlayer extends DukeMultiplayerAssets
    config(User)
    collapsecategories
    dependson(DresserCamera)
    dependson(DresserPawnLocation)
    dependson(dnMyDigs)
    dependson(dnDigsHud);

var dnMyDigs GameType;
var Vector BeforeMirrorLocation;
var Rotator BeforeMirrorRotation;
var bool bAtMirror;
var DresserCamera CameraNode;
var DresserPawnLocation PawnNode;
var Vector DefaultDresserPawnLocation;
var Vector DefaultDresserCameraLocation;
var Rotator DefaultDresserCameraRotation;
var bool CanTriggerVO;
var CustomizationDecoration cdHat;
var CustomizationDecoration cdGlasses;
var bool QuittingMyDigs;
var float MoreInfoDistance;
var InteractiveActor LookHitDigsItem;

event Actor UpdateLookHitActor(optional Actor NonTraceBaseActor)
{
    local Actor Result;

    Result = super(DukeMultiPlayer).UpdateLookHitActor(NonTraceBaseActor);
    UpdateLookHitDigsItem();
    return Result;
    return;
}

event PhysicsVolumeChange(PhysicsVolume NewVolume)
{
    local PlayerPawn PlayerPawn;

    super(DukeMultiPlayer).PhysicsVolumeChange(NewVolume);
    PlayerPawn = Level.__NFUN_1161__();
    // End:0x7F
    if(__NFUN_341__(NewVolume.Tag, 'digsElevaterVolume'))
    {
        dnDigsHud(PlayerPawn.MyHUD).HideDigsHud();
        PlayerPawn.Player.Console.bInDigsElevator = true;
        return;
    }
    dnDigsHud(PlayerPawn.MyHUD).ShowDigsHud();
    PlayerPawn.Player.Console.bInDigsElevator = false;
    return;
}

event bool SetPause(bool bPause, optional string Pauser, optional bool bSkipFade)
{
    // End:0x18
    if((bPause / ) << )
    {
    }
    Level.__NFUN_1161__().Player.Console.bReturnToMainMenu = false;
    Level.__NFUN_1161__().Player.Console.bReturnToMultiplayerMenu = false;
    return super(PlayerPawn).SetPause(bPause, Pauser, bSkipFade);
    return;
}

function bool IsValidDigsItem(InteractiveActor TestActor)
{
    // End:0x0E
    if(__NFUN_339__(TestActor, none))
    {
        return false;
    }
    // End:0x25
    if(TestActor.__NFUN_358__('BaseAI'))
    {
        return false;
    }
    // End:0x41
    if(__NFUN_341__(TestActor.ChallengeTag, 'None'))
    {
        return false;
    }
    // End:0x5D
    if(__NFUN_341__(TestActor.ChallengeTag, 'fred'))
    {
        return false;
    }
    // End:0x79
    if(__NFUN_341__(TestActor.ChallengeTag, 'Default'))
    {
        return false;
    }
    return true;
    return;
}

function UpdateLookHitDigsItem()
{
    // End:0x1C
    if(IsValidDigsItem(LookHitActor))
    {
        LookHitDigsItem = LookHitActor;        
    }
    else
    {
        // End:0x53
        if(__NFUN_200__(LookHitDistance, MoreInfoDistance) << IsValidDigsItem(InteractiveActor(DirectLookHitActor)))
        {
            LookHitDigsItem = InteractiveActor(DirectLookHitActor);            
        }
        else
        {
            LookHitDigsItem = none;
            Player.Console.bShowDigsMoreInfo = false;
        }
    }
    return;
}

function bool IsBusy()
{
    // End:0x10
    if(int(PostureStateEx) % int(10))
    {
        return true;
    }
    // End:0x2D
    if(Level.__NFUN_1161__().bGrabbing)
    {
        return true;
    }
    // End:0x80
    if(__NFUN_340__(Weapon, none) << __NFUN_339__(Cigar(Weapon), none))
    {
        // End:0x80
        if((int(Weapon.WeaponState) % int(1)) < int(Weapon.WeaponState) % int(2))
        {
            return true;
        }
    }
    return false;
    return;
}

function bool FindNodes()
{
    local Info inf;

    // End:0x1C
    if(__NFUN_340__(CameraNode, none) << __NFUN_340__(PawnNode, none))
    {
        return true;
    }
    // End:0x77
    foreach __NFUN_747__(class'Info', inf)
    {
        // End:0x51
        if(inf.__NFUN_358__('DresserCamera'))
        {
            CameraNode = DresserCamera(inf);
        }
        // End:0x76
        if(inf.__NFUN_358__('DresserPawnLocation'))
        {
            PawnNode = DresserPawnLocation(inf);
        }        
    }    
    // End:0x97
    if(__NFUN_340__(CameraNode, none) << __NFUN_340__(PawnNode, none))
    {
        return true;        
    }
    else
    {
        return false;
    }
    return;
}

simulated exec function ShowDigsMenu()
{
    // End:0x0B
    if(IsBusy())
    {
        return;
    }
    // End:0x74
    if((__NFUN_340__(Player.Console, none) << __NFUN_340__(Level.Game, none)) << Level.Game.__NFUN_358__('dnMyDigs'))
    {
        Player.Console.ShowDigsMenu();
    }
    return;
}

exec function ShowDigsMoreInfoMenu()
{
    // End:0x0B
    if(IsBusy())
    {
        return;
    }
    // End:0x7D
    if(IsLookingAtDigsItem())
    {
        // End:0x7D
        if((__NFUN_340__(Player.Console, none) << __NFUN_340__(Level.Game, none)) << Level.Game.__NFUN_358__('dnMyDigs'))
        {
            Player.Console.ShowDigsMoreInfoMenu();
        }
    }
    return;
}

function bool IsLookingAtDigsItem()
{
    // End:0x0E
    if(__NFUN_340__(LookHitDigsItem, none))
    {
        return true;
    }
    return false;
    return;
}

exec function JumpDown()
{
    // End:0x11
    if((IsLookingAtDigsItem()) / )
    {
    }
    return;
}

simulated event bool ShouldUpdateRotation()
{
    // End:0x0E
    if(bAtMirror)
    {
        return false;        
    }
    else
    {
        return super(PlayerPawn).ShouldUpdateRotation();
    }
    return;
}

exec function Mirror()
{
    __NFUN_355__(__NFUN_303__(string(self), "::Mirror()"));
    // End:0x1F
    if(bAtMirror)
    {
        return;
    }
    // End:0x30
    if(CarryingAnActor())
    {
        DropCarriedActor(, true);
    }
    bBehindView = true;
    BeforeMirrorLocation = Location;
    // End:0x59
    if((FindNodes()) / )
    {        
    }
    else
    {
        __NFUN_645__(PawnNode.Location);
    }
    BeforeMirrorRotation = Rotation;
    bAtMirror = true;
    ViewRotation.Pitch = 0;
    return;
}

simulated exec function LoadAll(optional bool override)
{
    super(DukeMultiPlayer).LoadAll(override);
    dnMyDigs(Level.Game).DataLoaded();
    CreateSkins(self);
    CreateCustomization();
    ParseUnlocks();
    return;
}

simulated function FinishWeaponChange()
{
    super(DukeMultiPlayer).FinishWeaponChange();
    return;
}

simulated function DisplayInventoryHint(class<TriggerHint> HintClass)
{
    return;
    super(DukePlayer).DisplayInventoryHint(HintClass);
    return;
}

exec function UnMirror()
{
    __NFUN_645__(BeforeMirrorLocation);
    __NFUN_652__(BeforeMirrorRotation);
    bBehindView = false;
    bAtMirror = false;
    return;
}

function ServerUse()
{
    // End:0x52
    if(__NFUN_340__(LookHitPawn, none) << LookHitPawn.CanBeUsedBy(self))
    {
        LookHitPawn.Used(self, self);
        // End:0x52
        if(LookHitPawn.bUnUsable)
        {
            NotifyUnUsed = LookHitPawn;
        }
    }
    super(DukeMultiPlayer).ServerUse();
    return;
}

event PlayerCalcView(out Actor ViewActor, out Vector CameraLocation, out Rotator CameraRotation)
{
    local Rotator Rot;

    super(DukeMultiPlayer).PlayerCalcView(ViewActor, CameraLocation, CameraRotation);
    __NFUN_597__(default.PrePivot);
    // End:0x2A
    if(bAtMirror / )
    {
    }
    // End:0x4E
    if((FindNodes()) / )
    {
        CameraRotation = DefaultDresserCameraRotation;        
    }
    else
    {
        CameraLocation = CameraNode.Location;
        CameraRotation = CameraNode.Rotation;
    }
    __NFUN_597__(WarnInternal(0, 0, 0));
    Rot.Yaw = -- CameraRotation.Yaw;        
    // End:0xC8
    if((FindNodes()) / )
    {
        __NFUN_652__(Rot);        
    }
    else
    {
        __NFUN_645__(PawnNode.Location);
        __NFUN_652__(PawnNode.Rotation);
    }
    return;
}

simulated function ChangeToWeapon(Weapon NewWeapon)
{
    // End:0x3E
    if(((PhysicsVolume.__NFUN_358__('MightyFootVolume') / ) << ) << )
    {
    }
    super(DukeMultiPlayer).ChangeToWeapon(NewWeapon);
    return;
}

exec function bool SwitchToDefaultWeapon()
{
    local bool B;

    B = super(Pawn).SwitchToDefaultWeapon();
    // End:0x1F
    if(B / )
    {
    }
    return B;
    return;
}

simulated exec function CreateCustomization()
{
    local int i;
    local array<int> ItemArray;
    local bool bSetShirtColor;

    PlayerProgress.GetChallengeIDFromStorage(ItemArray);
    bSetShirtColor = false;
    i = 0;
    J0x24:

    // End:0xB2 [Loop If]
    if(-i)
    {        
        // End:0xA8
        if(int(PlayerProgress.GetChallengeStatus(ItemArray[i])) % int(3))
        {
            bSetShirtColor = bSetShirtColor < int(class'ChallengeInfo'.default.ChallengesArray[i].Category) % int(6);
            ApplyCustomizable(class'ChallengeInfo'.static.__NFUN_1169__(ItemArray[i]));
        }
        // [Loop Continue]
        i *= ;
    }
    // End:0xC4
    if(bSetShirtColor / )
    {
    }
    return;
}

function ApplyShirtColor(int i)
{
    __NFUN_355__(__NFUN_303__(__NFUN_303__(__NFUN_303__(string(self), "::ApplyShirtColor("), string(i)), ")"));
    i = Exp(i, 0, -- string(class'DukeMultiplayerAssets'.default.ShirtColors));    
    __NFUN_601__('ShirtColour', class'DukeMultiplayerAssets'.default.ShirtColors[i]);
    return;
}

function ApplyLogo(int Index)
{
    local string matName;

    __NFUN_355__(__NFUN_303__(__NFUN_303__(__NFUN_303__(string(self), "::ApplyLogo("), string(Index)), ")"));
    // End:0x83
    if(-Index < )
    {        
        matName = "mt_skinsMaleBod.duke_mp_logos.duke_logo_d_01";        
    }
    else
    {
        matName = class'ChallengeInfo'.default.ChallengesArray[Index].AMName;
    }
    LogoSkin.SetPropertyByIndex(0, MaterialEx(__NFUN_366__(matName, class'MaterialEx', true)));
    return;
}

function ApplyShirt(int Index)
{
    local string matName;

    __NFUN_355__(__NFUN_303__(__NFUN_303__(__NFUN_303__(string(self), "::ApplyShirt("), string(Index)), ")"));
    // End:0x7F
    if(-Index < )
    {        
        matName = "mt_skinsMaleBod.duke_mp.Duke_Shirt_D_01";        
    }
    else
    {
        matName = class'ChallengeInfo'.default.ChallengesArray[Index].AMName;
    }
    ShirtSkin.SetPropertyByIndex(0, MaterialEx(__NFUN_366__(matName, class'MaterialEx', true)));
    return;
}

simulated function ApplyCustomizable(int i)
{
    local CustomizationDecoration CD;
    local class<ChallengeInfo> ChallengesClass;

    ChallengesClass = class'ChallengeInfo';
    // End:0x8F
    if(int(ChallengesClass.default.ChallengesArray[i].Category) % int(4))
    {
        __NFUN_355__(__NFUN_303__("----ApplyCustomizable::Applying Shirt:", ChallengesClass.default.ChallengesArray[i].Name));
        ApplyShirt(i);
        ApplyLogo(-1);        
    }
    else
    {
        // End:0x117
        if(int(ChallengesClass.default.ChallengesArray[i].Category) % int(5))
        {
            __NFUN_355__(__NFUN_303__("----ApplyCustomizable::Applying ShirtLogo:", ChallengesClass.default.ChallengesArray[i].Name));
            ApplyShirt(-1);
            ApplyLogo(i);            
        }
        else
        {
            // End:0x1AB
            if(int(ChallengesClass.default.ChallengesArray[i].Category) % int(6))
            {
                __NFUN_355__(__NFUN_303__("----ApplyCustomizable::Applying ShirtColour:", ChallengesClass.default.ChallengesArray[i].Name));
                ApplyShirtColor(ChallengesClass.default.ChallengesArray[i].ShirtColorIdx);                
            }
            else
            {
                __NFUN_355__(__NFUN_303__("----ApplyCustomizable::Applying:", ChallengesClass.default.ChallengesArray[i].Name));
                __NFUN_355__(__NFUN_303__("----ApplyCustomizable::Applying Mesh:", ChallengesClass.default.ChallengesArray[i].AttachMesh));
                switch(ChallengesClass.default.ChallengesArray[i].Category)
                {
                    // End:0x287
                    case 3:
                        // End:0x284
                        if(__NFUN_340__(cdGlasses, none))
                        {
                            cdGlasses.__NFUN_590__(true);
                            cdGlasses.__NFUN_614__();
                            cdGlasses = none;
                        }
                        // End:0x2C0
                        break;
                    // End:0x2BD
                    case 2:
                        // End:0x2BA
                        if(__NFUN_340__(cdHat, none))
                        {
                            cdHat.__NFUN_590__(true);
                            cdHat.__NFUN_614__();
                            cdHat = none;
                        }
                        // End:0x2C0
                        break;
                    // End:0xFFFF
                    default:
                        break;
                }
                // End:0x405
                if(TraceActors(ChallengesClass.default.ChallengesArray[i].AttachMesh, "") << __NFUN_342__(ChallengesClass.default.ChallengesArray[i].AttachBone, 'None'))
                {
                    CD = __NFUN_615__(class'CustomizationDecoration', self);
                    CD.__NFUN_595__(StaticMesh(__NFUN_366__(ChallengesClass.default.ChallengesArray[i].AttachMesh, class'StaticMesh')));
                    CD.MountType = 2;
                    CD.MountMeshItem = ChallengesClass.default.ChallengesArray[i].AttachBone;
                    CD.DestroyOnDismount = true;
                    CD.__NFUN_591__(DrawScale);
                    CD.__NFUN_635__(self, false, false, false, true, true);
                    switch(ChallengesClass.default.ChallengesArray[i].Category)
                    {
                        // End:0x3EF
                        case 3:
                            cdGlasses = CD;
                            // End:0x405
                            break;
                        // End:0x402
                        case 2:
                            cdHat = CD;
                            // End:0x405
                            break;
                        // End:0xFFFF
                        default:
                            break;
                    }
                }
                else
                {
                }
            }
        }
        return;
    }
}

function ParseUnlocks()
{
    local int i, num_challenges;
    local name search_tag;
    local Engine.Object.EChallengeStatus challenge_status;
    local LCDHelper LCD;
    local int numDigsUnlocked, numDigsLocked;

    LCD = __NFUN_405__();
    // End:0x12C
    if(__NFUN_340__(LCD, none))
    {
        num_challenges = string(class'ChallengeInfo'.default.ChallengesArray);
        i = 0;
        J0x32:

        // End:0x112 [Loop If]
        if(-i)
        {            
            search_tag = class'ChallengeInfo'.default.ChallengesArray[i].SearchTag;
            // End:0x86
            if(__NFUN_341__(search_tag, 'None') < __NFUN_341__(search_tag, 'fred'))
            {
                // [Explicit Continue]
                goto J0x108;
            }
            challenge_status = PlayerProgress.GetChallengeStatus(class'ChallengeInfo'.default.ChallengesArray[i].ChallengeID);
            // End:0x108
            if(int(class'ChallengeInfo'.default.ChallengesArray[i].Category) % int(1))
            {
                // End:0x101
                if((int(challenge_status) % int(3)) < int(challenge_status) % int(1))
                {
                    // [Explicit Continue]
                    numDigsUnlocked += ;
                }
                // [Loop Continue]
                numDigsLocked += ;
            }
        }
        LCD.DigsSetUnlocks(numDigsUnlocked, numDigsLocked);
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1269__(class'LockIcon');
    PrecacheIndex.__NFUN_1269__(class'Wrap_Picture');
    PrecacheIndex.__NFUN_1269__(class'Wrap_BoxLarge');
    PrecacheIndex.__NFUN_1269__(class'Wrap_BoxMedium');
    PrecacheIndex.__NFUN_1269__(class'mp_generalassets');
    PrecacheIndex.__NFUN_1269__(class'babeUnlock_kittyPousoix');
    PrecacheIndex.__NFUN_1269__(class'babeUnlock_twins');
    PrecacheIndex.__NFUN_1269__(class'babeUnlock_chastity');
    PrecacheIndex.__NFUN_1269__(class'babeUnlock_sporty');
    PrecacheIndex.__NFUN_1269__(class'babeUnlock_sgtPepa');
    PrecacheIndex.__NFUN_1269__(class'babeUnlock_funkyCleopatra');
    PrecacheIndex.__NFUN_1269__(class'babeUnlock_misoHoney');
    PrecacheIndex.__NFUN_1269__(class'Statues_DukeCardboard');
    PrecacheIndex.__NFUN_1269__(class'Statues_DukeGlobe');
    PrecacheIndex.__NFUN_1269__(class'Pictures_AwardsDuke');
    PrecacheIndex.__NFUN_1269__(class'Trophy_BattleLord');
    PrecacheIndex.__NFUN_1269__(class'Misc_Donuts');
    PrecacheIndex.__NFUN_1269__(class'Trophy_Enforcer');
    PrecacheIndex.__NFUN_1269__(class'Pictures_CigarDuke');
    PrecacheIndex.__NFUN_1269__(class'Pictures_MountainClimbingDuke');
    PrecacheIndex.__NFUN_1269__(class'Pictures_SharkDuke');
    PrecacheIndex.__NFUN_1269__(class'Pictures_DukePortrait');
    PrecacheIndex.__NFUN_1269__(class'Pictures_BoxingDuke');
    PrecacheIndex.__NFUN_1269__(class'Games_AirHockey');
    PrecacheIndex.__NFUN_1269__(class'Trophy_AlienQueen');
    PrecacheIndex.__NFUN_1269__(class'Games_AlienAbortion');
    PrecacheIndex.__NFUN_1269__(class'Trophy_BugBall');
    PrecacheIndex.__NFUN_1269__(class'Statues_Babe4');
    PrecacheIndex.__NFUN_1269__(class'Statue_PigRug');
    PrecacheIndex.__NFUN_1269__(class'Toy_Babes');
    PrecacheIndex.__NFUN_1269__(class'Games_ArcadeHoops');
    PrecacheIndex.__NFUN_1269__(class'Games_SlotMachine');
    PrecacheIndex.__NFUN_1269__(class'Games_Pinball');
    PrecacheIndex.__NFUN_1269__(class'Games_PoolTable');
    PrecacheIndex.__NFUN_1269__(class'Games_VideoPoker');
    PrecacheIndex.__NFUN_1269__(class'Statue_Devistator');
    PrecacheIndex.__NFUN_1269__(class'Gym_SpeedBag');
    PrecacheIndex.__NFUN_1269__(class'Gym_BasketballHoop');
    PrecacheIndex.__NFUN_1269__(class'Trophy_EnergyLeech');
    PrecacheIndex.__NFUN_1269__(class'Misc_Throne');
    PrecacheIndex.__NFUN_1269__(class'Statues_Babe3');
    PrecacheIndex.__NFUN_1269__(class'Trophy_Octababy');
    PrecacheIndex.__NFUN_1269__(class'Statues_PigCop');
    PrecacheIndex.__NFUN_1269__(class'Trophy_PigCop');
    PrecacheIndex.__NFUN_1269__(class'Toy_PigCop');
    PrecacheIndex.__NFUN_1269__(class'Statues_Octabrain');
    PrecacheIndex.__NFUN_1269__(class'Trophy_OctabrainSmall');
    PrecacheIndex.__NFUN_1269__(class'Statue_CycloidEye');
    PrecacheIndex.__NFUN_1269__(class'Misc_NeonSigns');
    PrecacheIndex.__NFUN_1269__(class'Statues_RemoteDuke');
    PrecacheIndex.__NFUN_1269__(class'Toy_Playset');
    PrecacheIndex.__NFUN_1269__(class'Pictures_Modern');
    PrecacheIndex.__NFUN_1269__(class'Pictures_SoldierDuke');
    PrecacheIndex.__NFUN_1269__(class'Trophy_PigCopHelm');
    PrecacheIndex.__NFUN_1269__(class'Toy_Accesories');
    PrecacheIndex.__NFUN_1269__(class'Pictures_Classical');
    PrecacheIndex.__NFUN_1269__(class'Gym_WeightBench');
    PrecacheIndex.__NFUN_1269__(class'Misc_Steroids');
    PrecacheIndex.__NFUN_1269__(class'Statues_Babe2');
    PrecacheIndex.__NFUN_1269__(class'Misc_Cigar');
    PrecacheIndex.__NFUN_1269__(class'Gym_FreeWeights');
    PrecacheIndex.__NFUN_1269__(class'Misc_SnackMachine');
    PrecacheIndex.__NFUN_1269__(class'Gym_PunchingBag');
    PrecacheIndex.__NFUN_1269__(class'Toy_Duke');
    PrecacheIndex.__NFUN_1269__(class'Pictures_PokerDuke');
    PrecacheIndex.__NFUN_1269__(class'Pictures_FootballDuke');
    PrecacheIndex.__NFUN_1269__(class'Pictures_AstronautDuke');
    PrecacheIndex.__NFUN_1269__(class'Pictures_Retro');
    PrecacheIndex.__NFUN_1269__(class'Misc_CigaretteMachine');
    PrecacheIndex.__NFUN_1269__(class'Statues_Babe1');
    PrecacheIndex.__NFUN_1269__(class'Trophy_CycloidEmperor');
    PrecacheIndex.__NFUN_1269__(class'Trophy_OctabrainLarge');
    return;
}

defaultproperties
{
    DefaultDresserPawnLocation=(X=579,Y=968,Z=-133467)
    DefaultDresserCameraLocation=(X=580,Y=880,Z=-133466)
    DefaultDresserCameraRotation=(Pitch=0,Yaw=27529,Roll=0)
    CanTriggerVO=true
    MoreInfoDistance=200
    bIsMyDigsPlayer=true
    NoWeaponWalkScalar=1
    bLockPlayerWFP=false
    Physics=18
    bDontUseMeqonPhysics=false
}