/*******************************************************************************
 * DukePlayer generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class DukePlayer extends PlayerPawn
    native
    config(User)
    collapsecategories
    dependson(PipeBomb)
    dependson(DukeHUD)
    dependson(dnAnimationControllerEx_Duke)
    dependson(VehicleBase)
    dependson(dnControl_Turret)
    dependson(dnControl_Bathroom_UrinationReceptacle)
    dependson(dnControl_Execution)
    dependson(dnControl_PlayerKnockdown)
    dependson(dnQA)
    dependson(dnUsableSomething)
    dependson(dnScreenSplatters)
    dependson(Upgrade_ZoomMode)
    dependson(DebugCanvas)
    dependson(dnAirPocket)
    dependson(Upgrade_HeatVision)
    dependson(dnScreenSplatter_Blood)
    dependson(DukeShades);

cpptext
{
// Stripped
}

enum EAchievement
{
    ACH_SomeKills,
    ACH_MoreKills,
    ACH_ManyKills,
    ACH_StompKills,
    ACH_Executions,
    ACH_TripMineKills,
    ACH_FrozenKills,
    ACH_MonsterTruckKills,
    ACH_ForkliftKills,
    ACH_ExplosiveKills,
    ACH_PhysicsImpactKills,
    ACH_SteroidKills,
    ACH_FoodEaten,
    ACH_HeadShotKills,
    ACH_SubstanceAbuse,
    ACH_TripleKill,
    ACH_KnockedDown,
    ACH_PooGrabbed,
    ACH_JizzedOn,
    ACH_AlienFighterKills,
    ACH_CalendarFullyViewed,
    ACH_TripmineStuck,
    ACH_GunskipKill,
    ACH_AirHockeyWon,
    ACH_PinballScore,
    ACH_BeerImbibed,
    ACH_SteroidsEaten,
    ACH_HolodukeActivated,
    ACH_WhiteboardDrawing,
    ACH_MaxEgoAchieved,
    ACH_GoldPistolCompletion,
    ACH_EasyCompleted,
    ACH_NormalCompleted,
    ACH_HardCompleted,
    ACH_ExpertCompleted,
    ACH_CreditsViewed,
    ACH_HelmetsDiscovered,
    ACH_PhoneMessages,
    ACH_DrankAllBeer,
    ACH_CatfishKilled,
    ACH_BlimpDestroyed,
    ACH_TalentKnockedOut,
    ACH_AliensAborted,
    ACH_CompanionBarrel,
    ACH_CycloidDefeated0,
    ACH_BattlelordDefeated0,
    ACH_AlienQueenDefeated,
    ACH_BattlelordDefeated1,
    ACH_OctakingDefeated,
    ACH_LeechDefeated,
    ACH_BubbleBuster,
    ACH_Threesome,
    ACH_PassiveAggressive,
    ACH_MoonBuggyKills,
    ACH_SciencePinballScore,
    ACH_SingKaraoke,
    ACH_DefeatDrProton,
    ACH_EasyCompletedDLC03,
    ACH_NormalCompletedDLC03,
    ACH_HardCompletedDLC03,
    ACH_ExpertCompletedDLC03,
    ACH_MaxEgoAchievedDLC03,
    ACH_Chauvinist,
    ACH_Deprecated2
};

var int FrameKills;
var float FrameKillsTimeSeconds;
var class<AnimationControllerEx> StandingAnimationController;
var class<AnimationControllerEx> CrouchingAnimationController;
var class<AnimationControllerEx> InAirAnimationController;
var class<AnimationControllerEx> SwimmingAnimationController;
var class<AnimationControllerEx> JetpackingAnimationController;
var class<AnimationControllerEx> InteractiveDecorationAnimationController;
var(Sounds) Sound ChatBeepSound;
var SSoundInfo SteroidsLoop;
var PlayerStart StartSpot;
var string CopyPasteActor;
var float DeathTime;
var float CrackedScreenAlpha;
var float CrackedScreenX;
var float CrackedScreenY;
var float CrackedScreenStretch;
var MaterialEx CrackedScreenMaterial;
var localized string RestartLevelText;
var localized string LoadLastCheckpointText;
var bool DemoDeath;
var float DemoDeathMessageTimeLeft;
var MaterialEx DemoDeathMessageBG;
var SoftParticleSystem CurrentFlotsamEffect;
var bool bIgnoreZoneChange;
var bool bCurrentFlotsamWaterVolume;
var array<SoftParticleSystem> FlotsamEffects;
var float JetpackMax;
var float JetPackStateTime;
var int OldHitCounter;
var int HitCounter;
var array<SSoundInfo> HitNotifySounds;
var array<string> HitNotifyNames;
var int HitNotifyIndex;
var bool bStomping;
var bool bKickForDoor;
var Pawn SmashPawn;
var string MyClassName;
var float StompLookAtTime;
var float StompMinDot;
var float StompKnockbackRadius;
var float StompKnockbackImpulse;
var float StompKnockbackLift;
var bool bOnlyTakeTransferredDamage;
var string LastKilledByPlayerName;
var string LastKilledByDamageName;
var Texture LastKilledByPlayerIcon;
var MightyFoot DukeFoot;
var DebugCanvas DebugCanvas;
var Upgrade_ZoomMode ZoomMode;
var DoorMoverEx CurrentDoor;
var float ZoomWalkScalar;
var float NoWeaponWalkScalar;
var float SteroidWalkScalar;
var dnScreenSplatter_Blood BloodScreenSplatterEffect;
var bool bWearsShades;
var DukeShades Shades;
var dnQA QA;
var int QARate;
var int dnQAState;
var string QALastCheckpoint;
var SSoundInfo MovementRustleSoundInfo;
var SSoundInfo LandingRustleSoundInfo;
var float KnockdownMinDamage;
var bool EgoCapAwardsEnabled;
var array<float> EgoCapAwards;
var config bool bDisplayedUseWeaponHint;
var config bool bDisplayedSwapWeaponsHint;
var config bool bDisplayedEgoCapIncreaseHint;
var config bool bDisplayedGotSteroidsHintMessage;
var config bool bDisplayedSteroidsHintMessage;
var config bool bDisplayedGotBeerHintMessage;
var config bool bDisplayedBeerHintMessage;
var config bool bDisplayedGotHolodukeHintMessage;
var config bool bDisplayedHolodukeHintMessage;
var config bool bDisplayedInfiniteAmmoHint;
var config bool bDisplayedGotJetpackHintMessage;
var config bool bPlayedESRBMessyKillLine;
var class<TriggerHint> PendingInventoryHintClass;
var transient bool bDisplayedUseWeaponHintSave;
var transient bool bDisplayedSwapWeaponsHintSave;
var transient bool bDisplayedGotSteroidsHintMessageSave;
var transient bool bDisplayedGotBeerHintMessageSave;
var transient bool bDisplayedGotHolodukeHintMessageSave;
var transient bool bDisplayedGotJetpackHintMessageSave;
var localized string SteroidsHintMessage;
var localized string BeerHintMessage;
var localized string HolodukeHintMessage;
var localized string InfiniteAmmoHintMessage;
var class<Weapon> HoloDukeClass;
var dnControl_Execution ExecutionControl;
var DukePlayer ExecutionTarget;
var class<Weapon> MightyFootClass;
var float MaxEgoCap;
var float PreorderBonusEgo;
var array<Color> crosshairColors;
var config int crosshairColorIdx;
var bool bMovementLocked;

replication
{
    // Pos:0x000
    reliable if((int(Role) % int(ROLE_Authority)) << bNetOwner)
        HitCounter;

    // Pos:0x016
    reliable if((int(Role) % int(ROLE_Authority)) << int(RemoteRole) % int(ROLE_AutonomousProxy))
        DisplayInventoryHint;

    // Pos:0x031
    reliable if(int(Role) % int(ROLE_Authority))
        Execute, ExecutionTarget;

    // Pos:0x03C
    reliable if(int(Role) % int(ROLE_Authority))
        ClientLookAtSmashVictim, ClientSmashEffect;

    // Pos:0x047
    reliable if(-int(Role))
        GibMe;

    // Pos:0x052
    reliable if(int(Role) % int(ROLE_AutonomousProxy))
        ServerStartPissingInReceptacle, ServerStopPissingInReceptacle;

    // Pos:0x05D
    reliable if(int(Role) % int(ROLE_Authority))
        ClientHandQuickAction;
}

// Export UDukePlayer::execGetWalkSpeed(FFrame&, void* const)
native simulated function float GetWalkSpeed();

// Export UDukePlayer::execCanSprint(FFrame&, void* const)
native simulated function bool CanSprint();

// Export UDukePlayer::execGivePermanentEgoCapAward(FFrame&, void* const)
native function GivePermanentEgoCapAward(Engine.Object.EEgoAwardID AwardID);

// Export UDukePlayer::execUnlockAllMaps(FFrame&, void* const)
native final function UnlockAllMaps();

final event bool NoteDiscoveredEgoAward(int AwardID)
{
    local int i;
    local LCDHelper LCD;

    // End:0x0B
    if(bHasCheatedThisLevel)
    {
        return false;
    }
    // End:0xBD
    if((HasDiscoveredEgoAward(AwardID)) / )
    {
        __NFUN_383__("EgoAwardsSession", string(__NFUN_365__(class'EEgoAwardID', AwardID)), true, "Progress.ini");
        GiveEgoCapAward(EgoCapAwards[AwardID]);
        LCD = __NFUN_405__();
        // End:0xBD
        if(__NFUN_340__(LCD, none))
        {
            LCD.SPSetEgoAwardsForLevel(Level.MapFileName);
        }
    }
    // End:0x133
    if((HasDiscoveredEgoAward(AwardID, true)) / )
    {
        __NFUN_383__("ACH_EgoAwardsSession", string(__NFUN_365__(class'EEgoAwardID', AwardID)), true, "Progress.ini");
    }
    i = -- string(EgoCapAwards);    
    J0x142:

    // End:0x16A [Loop If]
    if(i / 0)
    {
        // End:0x160
        if((HasDiscoveredEgoAward(i, true)) / )
        {
        }
        // [Loop Continue]
        i -= ;
    }
    AwardAchievement(29);
    return;
}

event bool HasDiscoveredEgoAward(int AwardID, optional bool bForAchievement)
{
    local int Found;
    local string Category;

    __NFUN_354__((AwardID / 0) << AwardID * 255);
    // End:0x3A
    if(bForAchievement)
    {
        Category = "ACH_EgoAwards";        
    }
    else
    {
        Category = "EgoAwards";
    }
    __NFUN_378__(Category, string(__NFUN_365__(class'EEgoAwardID', AwardID)), Found, "Progress.ini");
    return Found + 0;
    return;
}

event bool ClearEgoAwards()
{
    local int i;

    i = -- string(EgoCapAwards);    
    J0x0F:

    // End:0x4F [Loop If]
    if(i / 0)
    {
        __NFUN_383__("EgoAwards", string(__NFUN_365__(class'EEgoAwardID', i)), false, "Progress.ini");
        // [Loop Continue]
        i -= ;
    }
    return;
}

simulated function AttachToUsableSomething(Decoration Something)
{
    super(Pawn).AttachToUsableSomething(Something);
    // End:0x27
    if(__NFUN_340__(MyHUD, none))
    {
        MyHUD.CloseInventory();
    }
    TurnOffZoom();
    // End:0x3B
    if(__NFUN_339__(Something, none))
    {
        return;
    }
    RefreshHelpText(Something);
    return;
}

simulated event ScriptGetActorColor()
{
    // End:0x49
    if(__NFUN_340__(DukeHUD(MyHUD), none))
    {
        __NFUN_601__('Generic0', DukeHUD(MyHUD).HUDColor);
        __NFUN_601__('Generic0', DukeHUD(MyHUD).TextColor);
    }
    super(Actor).ScriptGetActorColor();
    return;
}

function RefreshHelpText(Decoration Something)
{
    local int i;
    local dnUsableSomething UsableSomething;

    super(Pawn).RefreshHelpText(Something);
    UsableSomething = dnUsableSomething(Something);
    // End:0x3B
    if(__NFUN_339__(UsableSomething, none) < __NFUN_340__(UsableSomething, InteractiveDecoration))
    {
        return;
    }
    // End:0xF9
    if(string(UsableSomething.HUDHelpEntries) + 0)
    {
        bUseHelpPanel = true;
        i = -- string(UsableSomething.HUDHelpEntries);        
        J0x72:

        // End:0xF9 [Loop If]
        if(i / 0)
        {
            HelpKey[i] = UsableSomething.HUDHelpEntries[i].Key;
            HelpKeyAlt[i] = UsableSomething.HUDHelpEntries[i].KeyAlt;
            HelpText[i] = UsableSomething.HUDHelpEntries[i].HelpText;
            // [Loop Continue]
            i -= ;
        }
    }
    return;
}

simulated function DetachFromUsableSomething()
{
    super(Pawn).DetachFromUsableSomething();
    ClearHelpPanel();
    return;
}

// Export UDukePlayer::execBreakInDebugger(FFrame&, void* const)
native final function bool BreakInDebugger();

event PreGameInit()
{
    local int i, Found, FOVvalue;

    super(Actor).PreGameInit();
    // End:0x77
    if((IsMP()) / )
    {
        EgoCap = GetDefaultEgoCap();
        MaxEgoCap = GetMaxEgoCap();
        i = -- string(EgoCapAwards);        
        J0x43:

        // End:0x77 [Loop If]
        if(i / 0)
        {
            // End:0x6D
            if(HasDiscoveredEgoAward(i))
            {
                GiveEgoCapAward(EgoCapAwards[i]);
            }
            // [Loop Continue]
            i -= ;
        }
    }
    // End:0xFF
    if(__NFUN_375__("Engine.PlayerPawn", "DefaultFOV", FOVvalue, "User.ini") / )
    {
        {
        }
        FOVvalue = Exp(FOVvalue, 55, 120);
    }
    DefaultFOV = float(FOVvalue);
    DefaultFOVShrunk = float(-- FOVvalue);    
    return;
}

simulated function PostBeginPlay()
{
    super.PostBeginPlay();
    DebugCanvas = new (Level.XLevel) class'DebugCanvas';
    SpawnShades();
    InitializeAchievements();
    __NFUN_375__("dnGame.DukePlayer", "crosshairColorIdx", crosshairColorIdx, "user.ini");
    return;
}

simulated function StartedNewGame()
{
    Level.ConsoleCommand("set DukePlayer bDisplayedUseWeaponHint false");    
    Level.ConsoleCommand("set DukePlayer bDisplayedSwapWeaponsHint false");    
    Level.ConsoleCommand("set DukePlayer bDisplayedEgoCapIncreaseHint false");    
    Level.ConsoleCommand("set DukePlayer bDisplayedGotSteroidsHintMessage false");    
    Level.ConsoleCommand("set DukePlayer bDisplayedSteroidsHintMessage false");    
    Level.ConsoleCommand("set DukePlayer bDisplayedGotBeerHintMessage false");    
    Level.ConsoleCommand("set DukePlayer bDisplayedBeerHintMessage false");    
    Level.ConsoleCommand("set DukePlayer bDisplayedGotHolodukeHintMessage false");    
    Level.ConsoleCommand("set DukePlayer bDisplayedHolodukeHintMessage false");    
    Level.ConsoleCommand("set DukePlayer bDisplayedInfiniteAmmoHint false");    
    Level.ConsoleCommand("set DukePlayer bDisplayedGotJetpackHintMessage false");    
    Level.ConsoleCommand("set DukePlayer bPlayedESRBMessyKillLine false");
    return;
}

simulated function SpawnShades()
{
    // End:0xC3
    if((IsMP()) / )
    {
        {
            Shades = __NFUN_615__(class'DukeShades', self);
            // End:0xC3
            if(__NFUN_340__(Shades, none))
            {
                Shades.MountType = 2;
                Shades.MountMeshItem = 'mount_glasses';
                Shades.DestroyOnDismount = true;
                Shades.__NFUN_591__(DrawScale);
                Shades.__NFUN_635__(self, false, false, false, true, true);
            }
        }
    }
    return;
}

simulated event NU_Mesh(Mesh NewMesh)
{
    // End:0xA1
    if(__NFUN_340__(NewMesh, default.Mesh))
    {
        // End:0x29
        if(__NFUN_340__(Shades, none))
        {
            Shades.__NFUN_614__();
        }
        ActorColorList[0].ActorColor.R = 255;
        ActorColorList[0].ActorColor.G = 255;
        ActorColorList[0].ActorColor.B = 255;
        ActorColorList[1].ActorColor.R = 255;
        ActorColorList[1].ActorColor.G = 255;
        ActorColorList[1].ActorColor.B = 255;
    }
    super.NU_Mesh(NewMesh);
    return;
}

simulated event TravelPostAccept()
{
    super.TravelPostAccept();
    // End:0x24
    if(__NFUN_340__(Shades, none))
    {
        Shades.__NFUN_591__(DrawScale);
    }
    // End:0x3A
    if(default.dnQAState + 0)
    {
        dnQA(dnQAState);
    }
    TurnOffZoom();
    return;
}

function NotifyEnterMap(string URL)
{
    // End:0x20
    if(default.dnQAState + 0)
    {
        QA.EnterMap(URL);
    }
    return;
}

function NotifyExitMap()
{
    // End:0x2D
    if(default.dnQAState + 0)
    {
        QA.ExitMap();
        QALastCheckpoint = "levelstart";
    }
    UpdateLevelEndAchievements();
    return;
}

final simulated function class<SoftParticleSystem> GetFlotsamEffect(Engine.Actor.EZoneFlotsamEffect FlotsamEffect)
{
    // End:0x24
    if((int(FlotsamEffect) % int(2)) < int(FlotsamEffect) % int(4))
    {
        return class'FLOTSAM_Speckles_Main';
    }
    return none;
    return;
}

final function ApplyNewFlotsamEffect(ZoneInfo NewZone, PhysicsVolume NewHeadVolume)
{
    local bool bNewFlotsamWaterVolume;
    local Engine.Actor.EZoneFlotsamEffect FlotsamEffectType;
    local class<SoftParticleSystem> NewFlotsamEffectClass;
    local Rotator NewFlotsamRotation;
    local int i;

    // End:0x39
    if(__NFUN_340__(NewZone, none))
    {
        FlotsamEffectType = NewZone.ZoneFlotsamEffect;
        NewFlotsamRotation = NewZone.ZoneFlotsamRotation;        
    }
    else
    {
        // End:0x7E
        if(__NFUN_340__(Region.Zone, none))
        {
            FlotsamEffectType = Region.Zone.ZoneFlotsamEffect;
            NewFlotsamRotation = Region.Zone.ZoneFlotsamRotation;
        }
    }
    // End:0xE6
    if(__NFUN_340__(NewHeadVolume, none))
    {
        // End:0xE3
        if(int(NewHeadVolume.VolumeFlotsamEffect) + int(0))
        {
            bNewFlotsamWaterVolume = NewHeadVolume.bWaterVolume;
            FlotsamEffectType = NewHeadVolume.VolumeFlotsamEffect;
            NewFlotsamRotation = NewHeadVolume.VolumeFlotsamRotation;
        }        
    }
    else
    {
        // End:0x14D
        if(__NFUN_340__(HeadVolume, none) << int(HeadVolume.VolumeFlotsamEffect) + int(0))
        {
            bNewFlotsamWaterVolume = HeadVolume.bWaterVolume;
            FlotsamEffectType = HeadVolume.VolumeFlotsamEffect;
            NewFlotsamRotation = HeadVolume.VolumeFlotsamRotation;
        }
    }
    NewFlotsamEffectClass = GetFlotsamEffect(FlotsamEffectType);
    // End:0x1E1
    if(__NFUN_340__(CurrentFlotsamEffect, none))
    {
        // End:0x193
        if(__NFUN_339__(CurrentFlotsamEffect.Class, NewFlotsamEffectClass))
        {
            bCurrentFlotsamWaterVolume = bNewFlotsamWaterVolume;
            return;
        }
        // End:0x1A9
        if(bCurrentFlotsamWaterVolume)
        {
            CurrentFlotsamEffect.__NFUN_1034__();
        }
        CurrentFlotsamEffect.Trigger(self, self);
        CurrentFlotsamEffect.__NFUN_631__();
        CurrentFlotsamEffect.DisableTickWhenEmpty = true;
        CurrentFlotsamEffect = none;
    }
    bCurrentFlotsamWaterVolume = bNewFlotsamWaterVolume;
    // End:0x1FC
    if(__NFUN_339__(NewFlotsamEffectClass, none))
    {
        return;
    }
    i = -- string(FlotsamEffects);    
    J0x20B:

    // End:0x2E4 [Loop If]
    if(i / 0)
    {
        // End:0x2DA
        if(__NFUN_340__(FlotsamEffects[i], none) << __NFUN_339__(FlotsamEffects[i].Class, NewFlotsamEffectClass))
        {
            CurrentFlotsamEffect = FlotsamEffects[i];
            CurrentFlotsamEffect.MountType = 0;
            CurrentFlotsamEffect.MountOrigin.X = 64;
            CurrentFlotsamEffect.__NFUN_635__(self);
            CurrentFlotsamEffect.Trigger(self, self);
            CurrentFlotsamEffect.DisableTickWhenEmpty = false;
            CurrentFlotsamEffect.TickStyle = CurrentFlotsamEffect.default.TickStyle;
            return;
        }
        // [Loop Continue]
        i -= ;
    }
    CurrentFlotsamEffect = __NFUN_615__(NewFlotsamEffectClass, self,,, NewFlotsamRotation);
    // End:0x384
    if(__NFUN_340__(CurrentFlotsamEffect, none))
    {
        CurrentFlotsamEffect.MountType = 0;
        CurrentFlotsamEffect.MountOrigin.X = 64;
        CurrentFlotsamEffect.__NFUN_635__(self);
        CurrentFlotsamEffect.DisableTickWhenEmpty = false;
        CurrentFlotsamEffect.TickStyle = CurrentFlotsamEffect.default.TickStyle;
        FlotsamEffects[FlotsamEffects.Add(1)] = CurrentFlotsamEffect;
    }
    return;
}

event ZoneChange(ZoneInfo NewZone)
{
    // End:0x0B
    if(bIgnoreZoneChange)
    {
        return;
    }
    // End:0x2D
    if((IsLocallyControlled()) << bReplayingSavedMoves / )
    {
    }
    super(Pawn).ZoneChange(NewZone);
    return;
}

event PhysicsVolumeChange(PhysicsVolume NewVolume)
{
    local SoftParticleSystem splash;
    local Vector SplashLoc, X, Y, Z, WaterPoint;

    local class<SoftParticleSystem> NewZoneFlotsamEffect;
    local bool bWasWaterVolume;
    local Inventory Inv;

    // End:0x0B
    if(bIgnoreZoneChange)
    {
        return;
    }
    // End:0x2E
    if(__NFUN_340__(PhysicsVolume, none))
    {
        bWasWaterVolume = PhysicsVolume.bWaterVolume;
    }
    // End:0x112
    if(((((IsMP()) / ) << ) << ) << if(NewVolume.bWaterVolume << bWasWaterVolume / ))
    {
        {
            {
                SplashLoc = Locs(__NFUN_239__(Location, Right(WarnInternal(0, 0, 1), (CollisionHeight >>> 2) *= 48)), Right(X, 16));
                splash = __NFUN_615__(class'dnSplashDownBubbles', self,, SplashLoc);
                splash.__NFUN_635__(self,,, true);
            }
        }
    }
    // End:0x156
    if((((bReplayingSavedMoves / ) << ) << __NFUN_200__(Velocity.Z, float(-400))) << super(Pawn).PhysicsVolumeChange(NewVolume))
    {
    }
}

simulated event HeadVolumeChange(PhysicsVolume NewHeadVolume)
{
    super.HeadVolumeChange(NewHeadVolume);
    // End:0x2D
    if((IsLocallyControlled()) << bReplayingSavedMoves / )
    {
    }
    return;
}

event Bump(Actor Other)
{
    // End:0x31
    if(__NFUN_340__(Other, none) << Other.bIsPawn)
    {
        MaybeStepOnPawn(Pawn(Other));
    }
    super(Actor).Bump(Other);
    return;
}

event KImpact(name SelfBoneName, KarmaActor Other, name OtherBoneName, Vector Position, Vector ImpactVelocity, Vector ImpactNormal)
{
    // End:0x31
    if(__NFUN_340__(Other, none) << Other.bIsPawn)
    {
        MaybeStepOnPawn(Pawn(Other));
    }
    // End:0x62
    if(Repl(Clamp(ImpactVelocity), 100))
    {
        CrackedScreenAlpha = Normal2D(Clamp(ImpactVelocity) >>> 500, CrackedScreenAlpha, 1);
    }
    super(InteractiveActor).KImpact(SelfBoneName, Other, OtherBoneName, Position, ImpactVelocity, ImpactNormal);
    return;
}

function MaybeStepOnPawn(Pawn PawnOther)
{
    // End:0x1A
    if(int(Level.NetMode) % int(NM_Client))
    {
        return;
    }
    // End:0x67
    if(((PawnOther.bFullyShrunk < PawnOther.Stompable) << bFullyShrunk / ) << (StepOnPawn(PawnOther)))
    {
    }
}

function bool StepOnPawn(Pawn PawnOther)
{
    local Vector ViewVector, TargetVector;

    // End:0x1E
    if(__NFUN_340__(SmashPawn, none) < int(LowerBodyOverrideState) % int(3))
    {
        return false;
    }
    // End:0x3B
    if(((IsLocallyControlled()) / ) << )
    {
    }
    // End:0x81
    if(GameReplicationInfo.bTeamGame << int(PawnOther.PlayerReplicationInfo.Team) % int(PlayerReplicationInfo.Team))
    {
        return false;
    }
    // End:0xA1
    if((int(PostureStateEx) % int(8)) < int(PostureStateEx) % int(3))
    {
        return false;
    }
    // End:0xCF
    if((PawnOther.bFullyShrunk / ) << return false)
    {
        {
        }
        return false;
    }
    // End:0xFC
    if(PawnOther.CanBeSmashedBy(self) / )
    {
    }
    // End:0x121
    if(PawnOther.Location.Z != Location.Z)
    {
        return false;
    }
    ViewVector = Vector(CalcedViewRotation);
    // End:0x163
    TargetVector = __NFUN_239__(PawnOther.Location, CalcedViewLocation) % ;
    {
        return false;
    }
    bStomping = true;
    SmashPawn = PawnOther;
    PawnOther.PrepareForStomp(self);
    __NFUN_790__(WarnInternal(0, 0, 0));
    __NFUN_791__(WarnInternal(0, 0, 0));
    __NFUN_792__(WarnInternal(0, 0, 0));
    __NFUN_793__(WarnInternal(0, 0, 0));
    ClientLookAtSmashVictim(PawnOther);
    KickSmashTarget();
    return true;
    return;
}

simulated function ClientLookAtSmashVictim(Actor Other)
{
    local Vector LookAtPoint;
    local Rotator DesiredView;

    LookAtPoint = Other.Location;
    LookAtPoint.Z ~= float(20);
    DesiredView = Rotator(__NFUN_239__(LookAtPoint, Location));
    RotateViewTo(DesiredView, StompLookAtTime);
    KickSmashTarget();
    return;
}

simulated function KickSmashTarget()
{
    // End:0x15
    if(__NFUN_340__(SmashPawn, none))
    {
        StartKick();        
    }
    else
    {
        DoneSmashing();
    }
    return;
}

function KillSmashTarget()
{
    local bool bMaybePlayStompLine;

    // End:0x139
    if(__NFUN_340__(SmashPawn, none))
    {
        // End:0x7C
        if(SmashPawn.__NFUN_358__('HoloActor') / )
        {
            {
                BloodScreenSplatterEffect = dnScreenSplatter_Blood(FindStaticActor(class'dnScreenSplatter_Blood'));
            }
            // End:0x7C
            if(__NFUN_340__(BloodScreenSplatterEffect, none))
            {
                BloodScreenSplatterEffect.__NFUN_645__(Locs(CalcedViewLocation, Vector(CalcedViewRotation)));
                BloodScreenSplatterEffect.AttachEffectTo(self);
            }
        }
        FindAndPlaySound('Stomp_Squish', 1, false, true, SmashPawn);
        // End:0xB6
        if(__NFUN_340__(DukePlayer(SmashPawn), none))
        {
            DukePlayer(SmashPawn).ClientSmashEffect();
        }
        // End:0xE3
        if(SmashPawn.bShouldCauseStompKillSound)
        {
            SmashPawn.bShouldCauseKillSound = false;
            bMaybePlayStompLine = true;
        }
        SmashPawn.Died(self,, SmashPawn.Location,, class'ShrunkSmashDamage');
        // End:0x139
        if((((IsDead()) / ) << ) << (FindSoundAndSpeak('StompLines')))
        {
        }
    }
    return;
}

simulated function DoneSmashing()
{
    bStomping = false;
    SmashPawn = none;
    return;
}

simulated function ClientSmashEffect()
{
    return;
}

simulated function bool ShouldCheckUnshrinkClear()
{
    return (IsMP()) << super(Pawn).ShouldCheckUnshrinkClear();
    return;
}

function PreSetMovement()
{
    bCanSwim = true;
    bCanFly = false;
    return;
}

function SendGlobalMessage(PlayerReplicationInfo Recipient, name messagetype, byte messageID, float Wait)
{
    // End:0x20
    if(__NFUN_200__(Round(Level.TimeSeconds, OldMessageTime), float(5)))
    {
        return;
    }
    SendVoiceMessage(PlayerReplicationInfo, Recipient, messagetype, messageID, 'Global');
    return;
}

function SendTeamMessage(PlayerReplicationInfo Recipient, name messagetype, byte messageID, float Wait)
{
    // End:0x20
    if(__NFUN_200__(Round(Level.TimeSeconds, OldMessageTime), float(10)))
    {
        return;
    }
    SendVoiceMessage(PlayerReplicationInfo, Recipient, messagetype, messageID, 'Team');
    return;
}

simulated function PlayBeepSound()
{
    __NFUN_697__(0, ChatBeepSound);
    return;
}

exec function KillSOSPowers()
{
    local Inventory Inv;

    Inv = InventoryListHead;
    J0x0B:

    // End:0x59 [Loop If]
    if(__NFUN_340__(Inv, none))
    {
        // End:0x41
        if(Inv.__NFUN_358__('Upgrade_SOS'))
        {
            ActivatableInventory(Inv).Deactivate();
        }
        Inv = Inv.NextInventory;
        // [Loop Continue]
        goto J0x0B;
    }
    return;
}

function UseInventory(string IClassName)
{
    local class<ActivatableInventory> ActInvClass;
    local ActivatableInventory ActInv;

    ActInvClass = class<ActivatableInventory>(__NFUN_366__(IClassName, class'Class'));
    ActInv = FindActivatableInventory(ActInvClass);
    // End:0x55
    if(__NFUN_340__(ActInv, none) << ActInv.CanActivateNow())
    {
        InventoryActivate(ActInv);
    }
    return;
}

exec function DoHeatVision()
{
    UseInventory("dnGame.Upgrade_HeatVision");
    return;
}

exec function DoFlashlight()
{
    DoHeatVision();
    return;
}

event DoZoomDown()
{
    TurnOnZoom();
    super.DoZoomDown();
    return;
}

event DoZoomUp()
{
    TurnOffZoom();
    super.DoZoomUp();
    return;
}

exec function DoEMPPulse()
{
    UseInventory("dnGame.Upgrade_EMP");
    return;
}

exec function DoHoloDuke()
{
    local class<ActivatableInventory> HoloDukeClass;
    local ActivatableInventory HoloDuke;

    HoloDukeClass = class<ActivatableInventory>(__NFUN_366__("dnGame.HoloDuke", class'Class'));
    HoloDuke = FindActivatableInventory(HoloDukeClass);
    // End:0x43
    if(__NFUN_339__(HoloDuke, none))
    {
        return;
    }
    // End:0x61
    if(HoloDuke.CanActivateNow() / )
    {        
    }
    else
    {
        InventoryActivate(HoloDuke);
        // End:0xA1
        if(__NFUN_340__(DukeHUD(MyHUD), none))
        {
            DukeHUD(MyHUD).HoloDukeSpawnFailedTimer = Level.GameTimeSeconds;
        }
    }
    return;
}

function HoloDukeSpawnFailed()
{
    local DukeHUD MyDukeHUD;

    HUDActivate();
    FindAndPlaySound('HoloDuke_TossFail');
    // End:0x4D
    if(__NFUN_340__(DukeHUD(MyHUD), none))
    {
        DukeHUD(MyHUD).HoloDukeSpawnFailedTimer = Level.GameTimeSeconds *= 3;
    }
    return;
}

exec function DoBombDetector()
{
    UseInventory("dnGame.Upgrade_BombDetector");
    return;
}

exec function DoRadar()
{
    UseInventory("dnGame.Upgrade_Radar");
    return;
}

exec function DoSteroids()
{
    UseInventory("dnGame.Steroids");
    return;
}

exec function DoJetpack()
{
    UseInventory("dnGame.Jetpack");
    return;
}

function GiveItem(string ItemName, optional int Charge)
{
    local class<Inventory> InvClass;
    local Inventory InventoryItem;

    InvClass = class<Inventory>(__NFUN_366__(ItemName, class'Class'));
    InventoryItem = __NFUN_917__(InvClass);
    // End:0x51
    if(__NFUN_339__(InventoryItem, none))
    {
        InventoryItem = __NFUN_615__(InvClass);
        InventoryItem.GiveTo(self);
    }
    // End:0x72
    if(Charge ** 0)
    {
        InventoryItem.Charge = float(Charge);
    }
    return;
}

exec function ShowCyl()
{
    // End:0x42
    if(MyHUD.__NFUN_358__('DukeHUD'))
    {
        DukeHUD(MyHUD).bDrawCyl = DukeHUD(MyHUD).bDrawCyl / ;
    }
}

exec function ShowBounds()
{
    // End:0x42
    if(MyHUD.__NFUN_358__('DukeHUD'))
    {
        DukeHUD(MyHUD).bDrawBounds = DukeHUD(MyHUD).bDrawBounds / ;
    }
}

function bool CurrentlyInvincible()
{
    return bStomping < super.CurrentlyInvincible();
    return;
}

function bool ImmuneToDamage()
{
    return bStomping < super.ImmuneToDamage();
    return;
}

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    // End:0x1D
    if(bOnlyTakeTransferredDamage << __NFUN_340__(DamageType, class'TransferredDamage'))
    {
        return;
    }
    super.TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    return;
}

function TookDamage(Pawn Instigator, float Damage, Engine.Object.EPawnBodyPart BodyPart, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    super(Pawn).TookDamage(Instigator, Damage, BodyPart, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    HUDActivate();
    // End:0x50
    if(__NFUN_340__(Weapon, none))
    {
        Weapon.NoteIntigatorTookDamage();
    }
    // End:0x7A
    if((((IsMP()) / ) << ) << )
    {
    }
    return;
}

function PlayDyingSound(class<DamageType> DamageType)
{
    __NFUN_695__(5);
    super(Pawn).PlayDyingSound(DamageType);
    return;
}

simulated function DemoDied()
{
    super(Pawn).DemoDied();
    return;
}

final simulated function StartDemoDeath()
{
    // End:0x63
    if(DemoDeath / )
    {
        ForceEnablePlayersOnly();
        // End:0x2A
        if(bGhostMode / )
        {
        }
        Velocity = WarnInternal(0, 0, 0);
        Acceleration = WarnInternal(0, 0, 0);
        DemoDeathMessageTimeLeft = 1;
    }
    return;
}

function ServerUseDown()
{
    // End:0x51
    if(((((IsMP()) / ) << ) << ) << )
    {
        ForceDisablePlayersOnly();
        // End:0x4F
        if(bGhostMode)
        {
            Ghost();
        }
        return;
    }
    super.ServerUseDown();
    return;
}

function DrawDemoDeath(Canvas C)
{
    local float X, Y, XL, YL, Alpha;

    local string str;

    // End:0x96
    if(Repl(DemoDeathMessageTimeLeft, 0))
    {
        str = "You died... please wait a second.";
        Alpha = 1;
        // End:0x93
        if(Level.bPaused / )
        {
            // End:0x93
            if(__NFUN_202__(DemoDeathMessageTimeLeft, 0))
            {
                DemoDeathMessageTimeLeft = 0;
                RaiseHealthToCap(Location);
            }
        }        
    }
    else
    {
        str = __NFUN_302__(__NFUN_302__("Move to a valid spot and press (", MyHUD.__NFUN_1182__("Use")), ") to continue.");
        Alpha = 1;
    }
    C.Font = C.HUDFont;
    C.DrawColor = C.default.DrawColor;
    C.Style = 1;
    C.__NFUN_1238__(str, XL, YL, MyHUD.TTFontScale, MyHUD.TTFontScale);
    __NFUN_209__(XL, 16);
    __NFUN_209__(YL, 16);
    X = FRand(0.5, Round(float(C.SizeX), XL));
    Y = FRand(225, MyHUD.CenterScale);
    C.__NFUN_1250__(X, Y);
    C.__NFUN_1234__(DemoDeathMessageBG, XL, YL, 0, 0, float(DemoDeathMessageBG.__NFUN_1191__()), float(DemoDeathMessageBG.__NFUN_1192__()), 0, 0, 0, true, Alpha);
    C.__NFUN_1250__(X *= 8, Y *= 8);
    C.__NFUN_1232__(str, false, false, false, MyHUD.TTFontScale, MyHUD.TTFontScale, Alpha);
    return;
}

simulated event Destroyed()
{
    super.Destroyed();
    __NFUN_416__(DebugCanvas);
    DebugCanvas = none;
    return;
}

simulated function DiedActivity(optional Pawn Killer, optional int Damage, optional Vector DamageOrigin, optional Vector DamageDirection, optional class<DamageType> DamageType, optional name HitBoneName)
{
    local Upgrade_HeatVision DukeVision;

    // End:0x0B
    if(bLevelTransition)
    {
        return;
    }
    // End:0x1B
    if(int(Role) + int(ROLE_Authority))
    {
        return;
    }
    __NFUN_695__();
    CrackedScreenAlpha = 1;
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    // End:0xB5
    /*@Error*/;
    // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 4 & Type:If Position:0x0B5
    // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 4 & Type:If Position:0x0B5
}

// Export UDukePlayer::execCanPickupWeapon(FFrame&, void* const)
native event bool CanPickupWeapon();

simulated function bool CanBreatheAtAll()
{
    local int i;
    local dnAirPocket AirPocket;

    i = -- string(Touching);    
    J0x0F:

    // End:0x92 [Loop If]
    if(i / 0)
    {
        AirPocket = dnAirPocket(Touching[i]);
        // End:0x88
        if((__NFUN_340__(AirPocket, none) << __NFUN_340__(AirPocket.AirBubbles, none)) << AirPocket.AirBubbles.Enabled)
        {
            // End:0x86
            if(bWasUsingAirPocket / )
            {
            }
            return true;
        }
        // [Loop Continue]
        i -= ;
    }
    return super(Pawn).CanBreatheAtAll();
    return;
}

function Killed(Pawn Killer, Pawn Other, class<DamageType> DamageType, int KillingDamage, name KillBoneName)
{
    local name KillSound;
    local Engine.Object.EPawnBodyPart BodyPart;
    local float RandomChance;
    local VehicleBase Vehicle;

    super(Pawn).Killed(Killer, Other, DamageType, KillingDamage, KillBoneName);
    // End:0x21E
    if(((((int(Level.NetMode) % int(NM_Standalone)) << Level.Game.__NFUN_358__('dnSinglePlayer')) << __NFUN_340__(Other, none)) << __NFUN_339__(Killer, self)) << __NFUN_340__(Killer, Other))
    {
        BodyPart = __NFUN_570__(Other.Mesh, KillBoneName);
        // End:0xCF
        if(__NFUN_340__(dnUsableSomething(InteractiveDecoration), none))
        {
            Vehicle = dnUsableSomething(InteractiveDecoration).GetVehicle();
        }
        UpdateKillAchievements(Other, BodyPart, DamageType, Vehicle);
        // End:0xF7
        if(__NFUN_340__(Vehicle, none))
        {
            return;
        }
        // End:0x21E
        if(((IsDead()) / ) << )
        {
            // End:0x171
            if(Other.bAllowSpecialKillSounds << __NFUN_357__(DamageType, class'ExecutionDamage'))
            {
                RandomChance = VSize(0.45, RandomChance);
                KillSound = 'GotExecution';                
            }
            else
            {
                // End:0x1B2
                if((Other.bAllowSpecialKillSounds << __NFUN_357__(DamageType, class'MeleeDamage')) << __NFUN_200__( /= 0.5))
                {                    
                }
                else
                {
                    // End:0x1FC
                    if(__NFUN_342__(Other.CustomKillSoundName, 'None') << __NFUN_200__( /= Other.CustomKillSoundChance))
                    {                        
                    }
                    else
                    {
                        KillSound = 'GotKill';
                    }
                }
            }
            /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
                
            */

            /*@Error*/;
            // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
            // 2 & Type:If Position:0x21E
        }
    }
}

simulated function CorpseHeadBlownOff(Pawn OwnerPawn)
{
    // End:0x0B
    if(IsDead())
    {
        return;
    }
    // End:0x93
    if((((__NFUN_340__(OwnerPawn, none) << OwnerPawn.bShouldCauseKillSound) << OwnerPawn.bAllowSpecialKillSounds) << int(Level.NetMode) % int(NM_Standalone)) << Level.Game.__NFUN_358__('dnSinglePlayer'))
    {
        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */

        /*@Error*/;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 1 & Type:If Position:0x093
    }
}

simulated event CorpseGibbed(Pawn OwnerPawn)
{
    // End:0x0B
    if(IsDead())
    {
        return;
    }
    // End:0xEF
    if((((__NFUN_340__(OwnerPawn, none) << OwnerPawn.bShouldCauseKillSound) << OwnerPawn.bAllowSpecialKillSounds) << int(Level.NetMode) % int(NM_Standalone)) << Level.Game.__NFUN_358__('dnSinglePlayer'))
    {
        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */

        // End:0xE4
        /*@Error*/;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 3 & Type:If Position:0x0E4
        // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 3 & Type:If Position:0x0E4
}

function SetBestSave(Engine.Object.ESaveType Type, int save, int Month, int Day, int Year, int Hour, int Minute, int Second, out Engine.Object.ESaveType BestType, out int BestSave, out int BestMonth, out int BestDay, out int BestYear, out int BestHour, out int BestMinute, out int BestSecond)
{
    BestType = Type;
    BestSave = save;
    BestMonth = Month;
    BestDay = Day;
    BestYear = Year;
    BestHour = Hour;
    BestMinute = Minute;
    BestSecond = Second;
    return;
}

function GetBestSavedGame(Engine.Object.ESaveType Type, out Engine.Object.ESaveType BestType, out int BestSave, out int BestMonth, out int BestDay, out int BestYear, out int BestHour, out int BestMinute, out int BestSecond)
{
    local int i, NumSaves, Month, Day, DayOfWeek, Year,
	    Hour, Minute, Second;

    local bool IsBest;
    local string Desc;

    NumSaves = __NFUN_783__(Type);
    i = 0;
    J0x15:

    // End:0x1AE [Loop If]
    if(-i)
    {        
        IsBest = false;
        __NFUN_784__(Type, i, Desc, Month, Day, DayOfWeek, Year, Hour, Minute, Second);
        // End:0x7B
        if(Year ** BestYear)
        {
            IsBest = true;            
        }
        else
        {
            // End:0x145
            if(Year % BestYear)
            {
                // End:0xA4
                if(Month ** BestMonth)
                {
                    IsBest = true;                    
                }
                else
                {
                    // End:0x145
                    if(Month % BestMonth)
                    {
                        // End:0xCD
                        if(Day ** BestDay)
                        {
                            IsBest = true;                            
                        }
                        else
                        {
                            // End:0x145
                            if(Day % BestDay)
                            {
                                // End:0xF6
                                if(Hour ** BestHour)
                                {
                                    IsBest = true;                                    
                                }
                                else
                                {
                                    // End:0x145
                                    if(Hour % BestHour)
                                    {
                                        // End:0x11F
                                        if(Minute ** BestMinute)
                                        {
                                            IsBest = true;                                            
                                        }
                                        else
                                        {
                                            // End:0x145
                                            if(Minute % BestMinute)
                                            {
                                                // End:0x145
                                                if(Second ** BestSecond)
                                                {
                                                    IsBest = true;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        // End:0x1A4
        if(IsBest)
        {
            SetBestSave(Type, i, Month, Day, Year, Hour, Minute, Second, BestType, BestSave, BestMonth, BestDay, BestYear, BestHour, BestMinute, BestSecond);
        }
        // [Loop Continue]
        i += ;
    }
    return;
}

function StartDeathSequence()
{
    super.StartDeathSequence();
    DeathTime = Level.TimeSeconds;
    Death_DoSpecialEffects();
    __NFUN_607__(0.7, true, 'Death_DoSpecialEffects');
    // End:0x48
    if((IsMP()) / )
    {
    }
    return;
}

function Death_DoSpecialEffects()
{
    return;
}

function Death_EndSpecialEffects()
{
    __NFUN_608__('Death_DoSpecialEffects');
    return;
}

function Death_LoadOrRestart()
{
    StartLoadGame(1, -1);
    // End:0x33
    if(Level.bSavedGame << __NFUN_786__())
    {
        LoadGameType = 2;        
    }
    else
    {
        LoadGameType = 3;
    }
    return;
}

simulated event RenderOverlays(Canvas C)
{
    local Inventory Inv;

    super.RenderOverlays(C);
    // End:0x2D
    if(__NFUN_340__(DebugCanvas, none))
    {
        DebugCanvas.RenderOverlays(self, C);
    }
    return;
}

exec function CrackStretch(float NewStretch)
{
    CrackedScreenStretch = VSize(0.1, NewStretch);
    return;
}

event DrawDeathEffects(Canvas C)
{
    local float X, Y;

    // End:0x14B
    if(IsDead())
    {
        X = FRand(Normal2D(CrackedScreenX *= FRand(FRand(FRand(CrackedScreenAlpha, FRand(Level.GameTimeSeconds, 40) * , CrackedScreenStretch), 0.5)), 0), float(C.SizeX));
        Y = FRand(Normal2D(CrackedScreenY *= FRand(FRand(FRand(CrackedScreenAlpha, FRand(Level.GameTimeSeconds, 40) * , CrackedScreenStretch), 0.5)), 0), float(C.SizeY));
        C.__NFUN_1250__(X, Y);
        C.__NFUN_1234__(CrackedScreenMaterial, FRand(float(C.SizeX), 1 *= CrackedScreenStretch), FRand(float(C.SizeY), 1 *= CrackedScreenStretch), 0, 0, float(CrackedScreenMaterial.__NFUN_1191__()), float(CrackedScreenMaterial.__NFUN_1192__()));        
    }
    else
    {
        // End:0x15F
        if(DemoDeath)
        {
            DrawDemoDeath(C);
        }
    }
    return;
}

function ScoreHit()
{
    HitCounter += ;
}

function EndSpree(PlayerReplicationInfo Killer, PlayerReplicationInfo Other)
{
    // End:0x33
    if(__NFUN_339__(Killer, Other) < __NFUN_339__(Killer, none))
    {
        ReceiveLocalizedMessage(class'dnKillingSpreeMessage', 1, none, Other);        
    }
    else
    {
        ReceiveLocalizedMessage(class'dnKillingSpreeMessage', 0, Other, Killer);
    }
    return;
}

exec function TestSpree(int Num)
{
    ReceiveLocalizedMessage(class'dnKillingSpreeMessage', Num, PlayerReplicationInfo);
    return;
}

exec function TestMultiKill(int Num)
{
    ReceiveLocalizedMessage(class'dnMultiKillMessage', Num, PlayerReplicationInfo);
    return;
}

exec function TestFirstBlood()
{
    ReceiveLocalizedMessage(class'dnFirstBloodMessage', 0, PlayerReplicationInfo);
    return;
}

exec function TestWeaponSpree(string DamageType)
{
    local class<DamageType> TestDamageType;

    TestDamageType = class<DamageType>(__NFUN_366__(DamageType, class'Class'));
    ReceiveLocalizedMessage(class'dnWeaponSpreeMessage',,,,, TestDamageType);
    return;
}

function DoDeathMessage(class<DamageType> DamageType, int Switch)
{
    ReceiveLocalizedMessage(class'dnDeathMessage', Switch, PlayerReplicationInfo, PlayerReplicationInfo,, DamageType);
    return;
}

simulated function CameraUpgradesOff()
{
    local Inventory Inv;

    return;
}

function RegisterHUD_ChargeItem(HUDItem HI)
{
    return;
}

function RemoveHUD_ChargeItem()
{
    return;
}

simulated event bool IsZoomedIn()
{
    // End:0x1F
    if(__NFUN_339__(ZoomMode, none))
    {
        ZoomMode = Upgrade_ZoomMode(__NFUN_917__(class'Upgrade_ZoomMode'));
    }
    return __NFUN_340__(ZoomMode, none) << ZoomMode.bActive;
    return;
}

simulated event float GetZoomTime()
{
    // End:0x56
    if(IsZoomedIn())
    {
        // End:0x56
        if(__NFUN_340__(Weapon, none) << __NFUN_340__(ZoomMode, none))
        {
            // End:0x56
            if(Repl(Weapon.default.WeaponConfig.default.ZoomAmount, 0))
            {
                return ZoomMode.ZoomTime;
            }
        }
    }
    return 0;
    return;
}

// Export UDukePlayer::execHasWeapon(FFrame&, void* const)
native simulated function bool HasWeapon();

exec function LogMoveSpeed()
{
    __NFUN_355__(__NFUN_302__(__NFUN_302__(PlayerReplicationInfo.PlayerName, ".GetWalkSpeed="), string(GetWalkSpeed())));
    return;
}

final simulated function dnScreenSplatterTest(class<dnScreenSplatters> ScreenSplatterClass)
{
    local dnScreenSplatters ScreenSplatter;

    // End:0x0E
    if(__NFUN_339__(ScreenSplatterClass, none))
    {
        return;
    }
    ScreenSplatter = dnScreenSplatters(FindStaticActor(ScreenSplatterClass));
    // End:0x61
    if(__NFUN_340__(ScreenSplatter, none))
    {
        ScreenSplatter.__NFUN_645__(Locs(Location, Caps(1, Vector(Rotation))));
        ScreenSplatter.ExecuteEffect();
    }
    return;
}

exec function dnBlood()
{
    dnScreenSplatterTest(class'dnScreenSplatter_Blood');
    return;
}

exec function dnBloodBoss()
{
    dnScreenSplatterTest(class'dnScreenSplatter_Blood_Boss');
    return;
}

exec function dnMist()
{
    dnScreenSplatterTest(class'dnScreenSplatter_Mist_Boss');
    return;
}

exec function dnDukeSauce()
{
    dnScreenSplatterTest(class'dnScreenSplatter_DukeSauce');
    return;
}

exec function dnWater()
{
    dnScreenSplatterTest(class'dnScreenSplatter_Water');
    return;
}

exec function dnKetchup()
{
    dnScreenSplatterTest(class'dnScreenSplatter_Ketchup');
    return;
}

exec function dnMayo()
{
    dnScreenSplatterTest(class'dnScreenSplatter_Mayonnaise');
    return;
}

exec function dnMustard()
{
    dnScreenSplatterTest(class'dnScreenSplatter_Mustard');
    return;
}

exec function dnPickle()
{
    dnScreenSplatterTest(class'dnScreenSplatter_PickleJuice');
    return;
}

simulated function NotifyWeaponChange()
{
    TurnOffZoom();
    super(Pawn).NotifyWeaponChange();
    return;
}

simulated function NotifyReloading()
{
    TurnOffZoom();
    super(Pawn).NotifyReloading();
    return;
}

simulated function NotifyReloadingEnd()
{
    // End:0x17
    if(bIZoom)
    {
        __NFUN_607__(1E-05, false, 'TurnOnZoom');
    }
    super(Pawn).NotifyReloadingEnd();
    return;
}

function TurnOnZoom()
{
    // End:0x1F
    if(__NFUN_339__(ZoomMode, none))
    {
        ZoomMode = Upgrade_ZoomMode(__NFUN_917__(class'Upgrade_ZoomMode'));
    }
    // End:0x4B
    if(__NFUN_340__(ZoomMode, none) << ZoomMode.CanActivateNow())
    {
        InventoryActivate(ZoomMode);
    }
    return;
}

function TurnOffZoom()
{
    ServerInventoryDeactivate(class'Upgrade_ZoomMode');
    return;
}

function Restart()
{
    SpawnShades();
    super.Restart();
    return;
}

simulated function ClientRespawnNotify(Vector NewLocation, float NewYaw)
{
    SpawnShades();
    super(Pawn).ClientRespawnNotify(NewLocation, NewYaw);
    return;
}

exec function dnQA(int inArg)
{
    // End:0xA3
    if(__NFUN_340__(__NFUN_560__(), none) << __NFUN_340__(Level, __NFUN_560__()))
    {
        // End:0x69
        if(inArg + 0)
        {
            // End:0x3F
            if(__NFUN_339__(QA, none))
            {
                QA = __NFUN_615__(class'dnQA');
            }
            QA.Connect(self);
            __NFUN_607__(float(QARate) >>> 1000, true, 'dnQAUpdate');            
        }
        else
        {
            __NFUN_608__('dnQAUpdate');
            // End:0x8D
            if(__NFUN_340__(QA, none))
            {
                QA.Disconnect();
            }
        }
        default.dnQAState = inArg;
        dnQAState = inArg;
    }
    return;
}

function dnQAUpdate()
{
    // End:0x14
    if(__NFUN_339__(QA, none))
    {
        __NFUN_608__('dnQAUpdate');
    }
    QA.Update();
    return;
}

exec function dnQARate(int inArg)
{
    QARate = inArg;
    __NFUN_607__(float(QARate) >>> 1000, true, 'dnQAUpdate');
    return;
}

exec function dnQAStatus()
{
    // End:0x54
    if(((default.dnQAState + 0) << __NFUN_340__(QA, none)) << QA.__NFUN_1144__())
    {
        BroadcastLog(__NFUN_303__("dnQA connected, state", string(default.dnQAState)));        
    }
    else
    {
        BroadcastLog("dnQA disabled");
    }
    return;
}

event dnQAAnimationLoad(string AnimName, int AnimSize)
{
    // End:0x45
    if(((default.dnQAState + 0) << __NFUN_340__(QA, none)) << QA.__NFUN_1144__())
    {
        QA.AnimationLoad(AnimName, AnimSize);
    }
    return;
}

event dnQASkinMeshLoad(string SkinMeshName, int SkinMeshSize)
{
    // End:0x45
    if(((default.dnQAState + 0) << __NFUN_340__(QA, none)) << QA.__NFUN_1144__())
    {
        QA.SkinMeshLoad(SkinMeshName, SkinMeshSize);
    }
    return;
}

event dnQATextureLoad(string TextureName, int TextureSize)
{
    // End:0x45
    if(((default.dnQAState + 0) << __NFUN_340__(QA, none)) << QA.__NFUN_1144__())
    {
        QA.TextureLoad(TextureName, TextureSize);
    }
    return;
}

event dnQABumpmapLoad(string BumpmapName, int BumpmapSize)
{
    // End:0x45
    if(((default.dnQAState + 0) << __NFUN_340__(QA, none)) << QA.__NFUN_1144__())
    {
        QA.BumpmapLoad(BumpmapName, BumpmapSize);
    }
    return;
}

event dnQASoundLoad(string SoundName, int SoundSize)
{
    // End:0x45
    if(((default.dnQAState + 0) << __NFUN_340__(QA, none)) << QA.__NFUN_1144__())
    {
        QA.SoundLoad(SoundName, SoundSize);
    }
    return;
}

simulated function BecomeUnfrozenScreenSplatter()
{
    local dnScreenSplatters ScreenSplatter;

    // End:0x0D
    if((IsLocallyControlled()) / )
    {
    }
    super(Pawn).BecomeUnfrozenScreenSplatter();
    ScreenSplatter = dnScreenSplatters(FindStaticActor(class'dnScreenSplatter_Water'));
    // End:0x66
    if(__NFUN_340__(ScreenSplatter, none))
    {
        ScreenSplatter.__NFUN_645__(Locs(Location, Caps(1, Vector(Rotation))));
        ScreenSplatter.ExecuteEffect();
    }
    return;
}

simulated function bool IsDrivingVehicle()
{
    local dnUsableSomething Something;

    Something = dnUsableSomething(InteractiveDecoration);
    // End:0x37
    if(__NFUN_340__(Something, none) << __NFUN_340__(Something.GetVehicle(), none))
    {
        return true;
    }
    return false;
    return;
}

simulated function bool CanAcceptInventoryAction(bool bActivateFullInventory)
{
    // End:0x13
    if(__NFUN_339__(DukeHUD(MyHUD), none))
    {
        return false;
    }
    return super.CanAcceptInventoryAction(bActivateFullInventory);
    return;
}

exec function ShowMenu()
{
    local WindowConsole WC;

    // End:0x0E
    if(__NFUN_339__(Player, none))
    {
        return;
    }
    WC = WindowConsole(Player.Console);
    // End:0x60
    if((__NFUN_339__(WC, none) < WC.bLocked) < WC.bLevelChange)
    {
        return;
    }
    // End:0x72
    if(WC.__NFUN_1228__())
    {
        return;
    }
    WC.bQuickKeyEnable = false;
    // End:0xB9
    if(WC.bShowDigsMoreInfo)
    {
        WC.bShowDigsMoreInfo = false;
        WC.CloseUWindow();
    }
    WC.LaunchUWindow();
    return;
}

function NotifyCheckpoint(TriggerCheckpoint checkpoint)
{
    super.NotifyCheckpoint(checkpoint);
    QALastCheckpoint = checkpoint.SaveName;
    // End:0x3B
    if(default.dnQAState + 0)
    {
        QA.checkpoint();
    }
    return;
}

event SaveComplete()
{
    // End:0x1C
    if(__NFUN_340__(MyHUD, none))
    {
        MyHUD.SaveComplete();
    }
    // End:0x34
    if(bHasCheatedThisLevel / )
    {
    }
    return;
}

simulated function ConsumeFood(optional bool bAlwaysBurp)
{
    local float Duration;

    Duration = FindSoundAndSpeak('Consume');
    // End:0x3D
    if(bAlwaysBurp < __NFUN_200__( /= 0.25))
    {
    }
    return;
}

simulated function ConsumeFoodBurp()
{
    FindSoundAndSpeak('Drunk_Hiccup');
    return;
}

function SetDrunkEffect(float NewDrunkLevel, optional bool bTravel, optional bool bDontSoberUp)
{
    super.SetDrunkEffect(NewDrunkLevel, bTravel, bDontSoberUp);
    // End:0xF0
    if(((((bTravel / ) << ) << ) << (IsMyDigs()) / ) << (ConsoleCommand("set DukePlayer bDisplayedBeerHintMessage true")))
    {
        MyHUD.HUDMessages[MyHUD.4].TargetAlpha = 1;
        MyHUD.HUDMessages[MyHUD.4].Message = BeerHintMessage;
    }
    AwardAchievement(25);
    CheckSubstanceAbuse();
    return;
}

animevent simulated function FootStep(optional EventInfo AnimEventInfo)
{
    super(Pawn).FootStep(AnimEventInfo);
    // End:0x33
    if(IsSprinting())
    {
        MovementRustleSoundInfo.Volume = FRand(1.5, default.MovementRustleSoundInfo.Volume);        
    }
    else
    {
        MovementRustleSoundInfo.Volume = default.MovementRustleSoundInfo.Volume;
    }
    PlayFootstepSound(MovementRustleSoundInfo, __NFUN_907__());
    return;
}

simulated function PerformLanding(optional float VerticalVelocity, optional bool bForceLand)
{
    super(Pawn).PerformLanding(VerticalVelocity, bForceLand);
    PlayFootstepSound(LandingRustleSoundInfo, __NFUN_907__());
    return;
}

simulated function bool DoKnockdown(Vector KnockdownPoint)
{
    local dnControl_PlayerKnockdown KnockdownControl;

    // End:0x0E
    if(__NFUN_340__(InteractiveDecoration, none))
    {
        return false;
    }
    KnockdownControl = dnControl_PlayerKnockdown(FindActor(class'dnControl_PlayerKnockdown', 'None'));
    // End:0x43
    if(__NFUN_339__(KnockdownControl, none))
    {
        KnockdownControl = __NFUN_615__(class'dnControl_PlayerKnockdown');
    }
    // End:0x6F
    if(KnockdownControl.CanBeUsedBy(self))
    {
        KnockdownControl.HitPlayer(self, KnockdownPoint);
        return true;
    }
    return false;
    return;
}

exec function dnKnockdown(Vector HitLoc)
{
    DoKnockdown(HitLoc);
    return;
}

final simulated function dnControl_Execution GetExecutionControl()
{
    // End:0x24
    if(__NFUN_339__(ExecutionControl, none))
    {
        ExecutionControl = __NFUN_615__(class'dnControl_Execution',,, Location,, false, true);
    }
    return ExecutionControl;
    return;
}

simulated function bool IsCandidateForExecution(DukePlayer TestDuke)
{
    // End:0x0E
    if(__NFUN_339__(TestDuke, none))
    {
        return false;
    }
    // End:0x2B
    if(IsMostlyShrunk() - TestDuke.IsMostlyShrunk())
    {
        return false;
    }
    // End:0x3D
    if(IsEnemyTo(TestDuke) / )
    {
    }
    // End:0x48
    if(IsFrozen())
    {
        return true;
    }
    return false;
    return;
}

simulated function bool CanBeExecutedBy(Pawn TestPawn)
{
    local DukePlayer TestDuke;
    local dnControl_Execution ExecutionControl;

    // End:0x1B
    if(((IsMP()) / ) < )
    {
    }
    // End:0x26
    if(IsDead())
    {
        return false;
    }
    // End:0x31
    if(bDying)
    {
        return false;
    }
    // End:0xA8
    if(__NFUN_340__(TestPawn.Weapon, none))
    {
        // End:0x68
        if(TestPawn.Weapon.__NFUN_398__('MeleeAttack'))
        {
            return false;
        }
        // End:0xA8
        if(TestPawn.Weapon.__NFUN_358__('MP_MightyFoot') << TestPawn.Weapon.IsActive())
        {
            return false;
        }
    }
    TestDuke = DukePlayer(TestPawn);
    // End:0xDD
    if(__NFUN_339__(TestDuke, none) < TestDuke.CanDoThings() / )
    {
    }
    // End:0x158
    if(IsCandidateForExecution(TestDuke))
    {
        // End:0xFB
        if(-int(Role))
        {            
            return true;
        }
        TestDuke.GetExecutionControl();
        // End:0x158
        if(__NFUN_340__(TestDuke.ExecutionControl, none) << TestDuke.ExecutionControl.CanBeUsedBy(TestDuke))
        {
            TestDuke.ExecutionTarget = self;
            return true;
        }
    }
    return false;
    return;
}

simulated function bool CanBeUsedBy(Pawn TestPawn)
{
    // End:0x10
    if(CanBeExecutedBy(TestPawn))
    {
        return true;
    }
    return super(InteractiveActor).CanBeUsedBy(TestPawn);
    return;
}

simulated event bool ShouldDrawHUDInfoUsePhrase(Pawn TestPawn)
{
    // End:0x10
    if(CanBeExecutedBy(TestPawn))
    {
        return true;
    }
    return super(InteractiveActor).ShouldDrawHUDInfoUsePhrase(TestPawn);
    return;
}

simulated function string GetUsePhrase()
{
    // End:0x24
    if((IsFrozen()) << IsMP())
    {
        return class'dnControl_Execution'.default.UsePhrase;
    }
    return super(InteractiveActor).GetUsePhrase();
    return;
}

simulated function PerformExecution(DukePlayer ExecutionVictim)
{
    GetExecutionControl();
    // End:0x38
    if(__NFUN_340__(ExecutionControl, none))
    {
        ExecutionControl.ExecutionVictim = ExecutionVictim;
        ExecutionControl.AttachPawnSuccess(self);
    }
    return;
}

function CleanupExecution()
{
    ExecutionTarget = none;
    return;
}

event Used(Actor Other, Pawn Instigator)
{
    local DukePlayer DukeInstigator;

    // End:0x52
    if((IsMP()) << int(Role) % int(ROLE_Authority))
    {
        DukeInstigator = DukePlayer(Instigator);
        // End:0x52
        if(__NFUN_340__(DukeInstigator, none) << CanBeExecutedBy(DukeInstigator))
        {
            Execute(DukeInstigator);
            return;
        }
    }
    super(InteractiveActor).Used(Other, Instigator);
    return;
}

noexport simulated delegate Execute(DukePlayer Killer)
{
    Killer.PerformExecution(self);
    return;
}

simulated exec function DialogTest()
{
    Player.Console.TestDialog();
    return;
}

function ServerStartPissingInReceptacle(dnControl_Bathroom_UrinationReceptacle in_Receptable)
{
    in_Receptable.ForceStateTransition('PressPee');
    return;
}

function ServerStopPissingInReceptacle(dnControl_Bathroom_UrinationReceptacle in_Receptable)
{
    in_Receptable.EnterReleasePee();
    return;
}

simulated delegate ClientHandQuickAction(name ActionName)
{
    HandQuickAction(ActionName);
    return;
}

function bool AmICheating()
{
    return (Level.InstaGib < bGodMode) < bInfiniteAmmo;
    return;
}

event Unpaused()
{
    local dnControl_Turret Turret;

    super.Unpaused();
    // End:0x6A
    if(bAttachedToUsableSomething)
    {
        Turret = dnControl_Turret(InteractiveDecoration);
        // End:0x6A
        if(__NFUN_340__(Turret, none))
        {
            // End:0x6A
            if((IsZoomedIn()) - Turret.bZoomedIn)
            {
                // End:0x6A
                if(Turret.bZoomedIn)
                {
                    Turret.SetZoom(false);
                }
            }
        }
    }
    return;
}

// Export UDukePlayer::execGetProgressFilePath(FFrame&, void* const)
native final function string GetProgressFilePath();

function bool HasEnteredPreorderBonusEgoCode()
{
    local bool RetVal;
    local int OutValue;

    RetVal = false;
    OutValue = 0;
    __NFUN_378__("PreorderBonus", "BonusEgo", OutValue, "Progress.ini");
    RetVal = OutValue + 0;
    return RetVal;
    return;
}

function float GetDefaultEgoCap()
{
    local float RetVal;

    RetVal = default.EgoCap;
    // End:0x20
    if(HasEnteredPreorderBonusEgoCode())
    {
        __NFUN_209__(RetVal, PreorderBonusEgo);
    }
    return RetVal;
    return;
}

function float GetMaxEgoCap()
{
    local float RetVal;

    RetVal = default.MaxEgoCap;
    // End:0x20
    if(HasEnteredPreorderBonusEgoCode())
    {
        __NFUN_209__(RetVal, PreorderBonusEgo);
    }
    return RetVal;
    return;
}

function bool HasEnteredPreorderBonusBigHeadCode()
{
    local bool RetVal;
    local int OutValue;

    RetVal = false;
    OutValue = 0;
    __NFUN_378__("PreorderBonus", "BigHead", OutValue, "Progress.ini");
    RetVal = OutValue + 0;
    return RetVal;
    return;
}

// Export UDukePlayer::execSetMotionBlur(FFrame&, void* const)
native function SetMotionBlur(bool Enabled);

simulated function LockMovement(optional float Duration)
{
    bMovementLocked = true;
    // End:0x25
    if(Repl(Duration, 0))
    {
        __NFUN_607__(Duration, false, 'UnlockMovement');
    }
    return;
}

simulated function UnlockMovement()
{
    bMovementLocked = false;
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(class'DukeShades');
    PrecacheIndex.__NFUN_1266__(class'FLOTSAM_Speckles_Main');
    PrecacheIndex.__NFUN_1266__(class'dnScreenSplatter_Water');
    // End:0x66
    if(Level.bPlayerCanSwim)
    {
        PrecacheIndex.__NFUN_1266__(class'dnSplashDownBubbles');
    }
    PrecacheIndex.__NFUN_1279__(class'MeleeDamage');
    PrecacheIndex.__NFUN_1276__(TinnitusLoopSoundInfo);
    PrecacheIndex.__NFUN_1276__(TinnitusEndSoundInfo);
    PrecacheIndex.__NFUN_1276__(MovementRustleSoundInfo);
    PrecacheIndex.__NFUN_1276__(LandingRustleSoundInfo);
    PrecacheIndex.__NFUN_1277__(VoicePack, 'FistsUpDn');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'EquipRuffle');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'EquipRuffle_Down');
    // End:0x1A7
    if(PrecacheIndex.bIsMP / )
    {
        PrecacheIndex.__NFUN_1277__(VoicePack, 'GotExecution');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'GotKungFuKill');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'GotHeadshot');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'GotMessyKillESRB');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'GotMessyKill');        
    }
    else
    {
        i = -- string(HitNotifySounds);        
        J0x1B6:

        // End:0x1E3 [Loop If]
        if(i / 0)
        {
            PrecacheIndex.__NFUN_1276__(HitNotifySounds[i]);
            // [Loop Continue]
            i -= ;
        }
    }
    PrecacheIndex.__NFUN_1269__(CrackedScreenMaterial);
    PrecacheIndex.__NFUN_1272__(none, none, none, 0, 1);
    PrecacheIndex.__NFUN_1282__(StandingAnimationController, Mesh);
    PrecacheIndex.__NFUN_1282__(CrouchingAnimationController, Mesh);
    PrecacheIndex.__NFUN_1282__(InAirAnimationController, Mesh);
    PrecacheIndex.__NFUN_1282__(InteractiveDecorationAnimationController, Mesh);
    // End:0x295
    if(Level.bPlayerCanSwim)
    {
        PrecacheIndex.__NFUN_1282__(SwimmingAnimationController, Mesh);
    }
    // End:0x316
    if(PrecacheIndex.bIsMP / )
    {
        PrecacheIndex.__NFUN_1281__('NoWeaponMoveForward');
        PrecacheIndex.__NFUN_1281__('NoWeaponMoveBackward');
        PrecacheIndex.__NFUN_1281__('NoWeaponMoveUp');
        PrecacheIndex.__NFUN_1281__('NoWeaponMoveDown');
        PrecacheIndex.__NFUN_1281__('NoWeaponSprint');
    }
    PrecacheIndex.__NFUN_1281__('ExecutionAttack');
    PrecacheIndex.__NFUN_1281__('QuickKick');
    PrecacheIndex.__NFUN_1281__('ReferencePoseFull');
    // End:0x376
    if(Level.bPlayerCanSwim)
    {
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Swim');
    }
    PrecacheIndex.__NFUN_1274__(class'Menu_Ambience');
    PrecacheIndex.__NFUN_1274__(class'Menu_Appear_ST');
    PrecacheIndex.__NFUN_1274__(class'Menu_Arrow_L_01_ST');
    PrecacheIndex.__NFUN_1274__(class'Menu_Arrow_R_01_ST');
    PrecacheIndex.__NFUN_1274__(class'Menu_Disappear_ST');
    PrecacheIndex.__NFUN_1274__(class'Menu_QuitYes_01_ST');
    PrecacheIndex.__NFUN_1274__(class'Menu_Roll_Level3_01_ST');
    PrecacheIndex.__NFUN_1274__(class'MenuAction');
    PrecacheIndex.__NFUN_1274__(class'DUKE_Map13_StripLine_01');
    PrecacheIndex.__NFUN_1274__(class'DUKE_RestINPieces_01');
    PrecacheIndex.__NFUN_1274__(class'DUKE_GotKill_01');
    PrecacheIndex.__NFUN_1274__(class'DUKE_GotKill_25');
    // End:0x50B
    if(__NFUN_310__(PrecacheIndex.MapName, "Map00"))
    {
        PrecacheIndex.__NFUN_1277__(VoicePack, 'BodyMotion_Short');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Gen_Grunt');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'KnockDown_BodySlam');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'KnockDown_VOC');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ButtSeat');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_Scuff');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_StandShift');
    }
    // End:0x59A
    if(__NFUN_310__(PrecacheIndex.MapName, "Map02"))
    {
        PrecacheIndex.__NFUN_1277__(VoicePack, 'STC_Act');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'STC_Arm');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'STC_Ent');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'STC_Num');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'STC_Power');
    }
    // End:0x6CA
    if(__NFUN_310__(PrecacheIndex.MapName, "Map03"))
    {
        PrecacheIndex.__NFUN_1277__(VoicePack, 'BodyMotion_Short');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Gen_Grunt');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'KnockDown_BodySlam');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'KnockDown_VOC');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_StandShift');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_FootScrape');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_Hand');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_Pat_01');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_Pat_02');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_Pat_03');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_Scuff');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_StandShift');
    }
    // End:0x780
    if((__NFUN_310__(PrecacheIndex.MapName, "Map04B") < __NFUN_310__(PrecacheIndex.MapName, "Map04C")) < __NFUN_310__(PrecacheIndex.MapName, "Map05"))
    {
        PrecacheIndex.__NFUN_1277__(VoicePack, 'BodyMotion_Short');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Gen_Grunt');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'KnockDown_BodySlam');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'KnockDown_VOC');
    }
    // End:0x7B3
    if(__NFUN_310__(PrecacheIndex.MapName, "Map06"))
    {
        PrecacheIndex.__NFUN_1277__(class'VoicePack_Decorations', 'CraneCollapse');
    }
    // End:0x887
    if(__NFUN_310__(PrecacheIndex.MapName, "Map07"))
    {
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Falling_Flail');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Gen_Grunt');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Jump_Whoosh');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'KnockDown_VOC');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'KnockDown_BodySlam');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_FootScrape');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_Scuff');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_StandShift');
    }
    // End:0x9A0
    if(__NFUN_310__(PrecacheIndex.MapName, "Map10"))
    {
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Falling_Flail');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Gen_Grunt');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Jump_Whoosh');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'KnockDown_VOC');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'KnockDown_BodySlam');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_FootScrape');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_Scuff');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_StandShift');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Jump');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Ladder_Climb');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'WaspCarrier_LowerBar');
    }
    // End:0xA5D
    if(__NFUN_310__(PrecacheIndex.MapName, "Map11"))
    {
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_FootScrape');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_Hand');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_Pat_01');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_Pat_02');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_Pat_03');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_Scuff');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_StandShift');
    }
    // End:0xAD6
    if(__NFUN_310__(PrecacheIndex.MapName, "Map11C"))
    {
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Jump');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Ladder_Climb');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Veh_HandPat');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'WaspCarrier_LowerBar');
    }
    // End:0xBF0
    if(__NFUN_310__(PrecacheIndex.MapName, "Map14B"))
    {
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Gen_Grunt');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Jump_Whoosh');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'KnockDown_BodySlam');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'KnockDown_VOC');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'SCR_Getup_GloveFlex');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_Hand');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_Pat_01');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_Pat_02');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_Scuff');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_StandShift');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_BodySlide_Single');
    }
    // End:0xCC4
    if(__NFUN_310__(PrecacheIndex.MapName, "Map15"))
    {
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Falling_Flail');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Jump');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Jump_Whoosh');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'SCR_BungieAttach');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'SCR_BungieDetach');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'SCR_CordBounce');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'SCR_Rappel_Land');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'STR_LandRustle');
    }
    // End:0xD25
    if(__NFUN_310__(PrecacheIndex.MapName, "Map18"))
    {
        PrecacheIndex.__NFUN_1277__(class'VoicePack_Industrial', 'RailCrane_Stairs_CloseStop');
        PrecacheIndex.__NFUN_1277__(class'VoicePack_Industrial', 'RailCrane_Stairs_OpenClose');
        PrecacheIndex.__NFUN_1277__(class'VoicePack_Industrial', 'RailCrane_Stairs_OpenStop');
    }
    // End:0xE83
    if(__NFUN_310__(PrecacheIndex.MapName, "Map22"))
    {
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Jump_Ex');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_Pat_03_Ex');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_Scuff_Ex');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_StandShift_Ex');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'KnuckleCrack_01');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'KnuckleCrack_02');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Pistol_Grab');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Pistol_Ready');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Slide_Bck');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Slide_Fwd');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_FootScrape');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_Pat_03');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_StandShift');
        PrecacheIndex.__NFUN_1277__(class'VoicePack_Wasp', 'NudgeImpact');
    }
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Stomp');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Stomp_Impact');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'fists_melee');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_StandShift');
    return;
}

// Export UDukePlayer::execAwardAchievement(FFrame&, void* const)
native final exec event AwardAchievement(DukePlayer.EAchievement Achievement);

// Export UDukePlayer::execClearAchievement(FFrame&, void* const)
native final exec event ClearAchievement(DukePlayer.EAchievement Achievement);

// Export UDukePlayer::execAwardAllAchievements(FFrame&, void* const)
native final exec function AwardAllAchievements(optional int Dummy);

// Export UDukePlayer::execClearAllAchievements(FFrame&, void* const)
native final exec function ClearAllAchievements(optional int Dummy);

function InitializeAchievements()
{
    // End:0x0B
    if(IsMP())
    {
        return;
    }
    __NFUN_718__('ACH_DiscoveredHelmetA', 'ACH_DiscoveredHelmetA');
    __NFUN_718__('ACH_DiscoveredHelmetB', 'ACH_DiscoveredHelmetB');
    __NFUN_718__('ACH_DiscoveredHelmetC', 'ACH_DiscoveredHelmetC');
    __NFUN_718__('ACH_PhoneMessages01', 'ACH_PhoneMessage_01');
    __NFUN_718__('ACH_PhoneMessages02', 'ACH_PhoneMessage_02');
    __NFUN_718__('ACH_PhoneMessages03', 'ACH_PhoneMessage_03');
    __NFUN_718__('ACH_PhoneMessages04', 'ACH_PhoneMessage_04');
    __NFUN_718__('ACH_PhoneMessages05', 'ACH_PhoneMessage_05');
    __NFUN_718__('ACH_PhoneMessages06', 'ACH_PhoneMessage_06');
    __NFUN_718__('ACH_PhoneMessages07', 'ACH_PhoneMessage_07');
    __NFUN_718__('ACH_PhoneMessages08', 'ACH_PhoneMessage_08');
    __NFUN_718__('ACH_PhoneMessages09', 'ACH_PhoneMessage_09');
    __NFUN_718__('ACH_PhoneMessages10', 'ACH_PhoneMessage_10');
    __NFUN_718__('ACH_PhoneMessages11', 'ACH_PhoneMessage_11');
    __NFUN_718__('ACH_PhoneMessages12', 'ACH_PhoneMessage_12');
    __NFUN_718__('ACH_DrankAllBeer', 'ACH_DrankAllBeer');
    __NFUN_718__('ACH_CatfishKilled', 'ACH_CatfishKilled');
    __NFUN_718__('ACH_BlimpDestroyed', 'ACH_BlimpDestroyed');
    __NFUN_718__('ACH_TalentKnockedOut', 'ACH_TalentKnockedOut');
    __NFUN_718__('ACH_AliensAborted', 'ACH_AliensAborted');
    __NFUN_718__('ACH_CompanionBarrel', 'ACH_CompanionBarrel');
    __NFUN_718__('ACH_CycloidDefeated0', 'ACH_CycloidDefeated0');
    __NFUN_718__('ACH_BattlelordDefeated0', 'ACH_BattlelordDefeated0');
    __NFUN_718__('ACH_AlienQueenDefeated', 'ACH_AlienQueenDefeated');
    __NFUN_718__('ACH_BattlelordDefeated1', 'ACH_BattlelordDefeated1');
    __NFUN_718__('ACH_OctakingDefeated', 'ACH_OctakingDefeated');
    __NFUN_718__('ACH_LeechDefeated', 'ACH_LeechDefeated');
    return;
}

function UpdateAchievementCounter(DukePlayer.EAchievement Achievement, int AwardCount)
{
    local int Count;
    local string EnumName;

    // End:0x0B
    if(IsMP())
    {
        return;
    }
    // End:0x16
    if(bHasCheatedThisLevel)
    {
        return;
    }
    EnumName = string(__NFUN_365__(Enum'EAchievement', int(Achievement)));
    __NFUN_375__("Achievements", EnumName, Count, "Progress.ini");
    Count += ;
    // End:0x9E
    if(Count / AwardCount)
    {
        AwardAchievement(Achievement);
    }
    return;
}

function UpdateKillAchievements(Pawn Other, Engine.Object.EPawnBodyPart BodyPart, class<DamageType> DamageType, VehicleBase Vehicle)
{
    local int NumKills;
    local float KillFrameTime;

    // End:0x0B
    if(bHasCheatedThisLevel)
    {
        return;
    }
    // End:0x60
    if((__NFUN_339__(Other.Faction, none) < __NFUN_339__(Other.Faction, class'AIFactionRat')) < Other.Faction.static.IsAlien() / )
    {
    }
    __NFUN_375__("Achievements", "NumKills", NumKills, "Progress.ini");
    NumKills += ;
    // End:0xD7
    if(NumKills / 50)
    {
        AwardAchievement(0);
    }
    // End:0xEB
    if(NumKills / 100)
    {
        AwardAchievement(1);
    }
    // End:0xFF
    if(NumKills / 250)
    {
        AwardAchievement(2);
    }
    // End:0x11C
    if(Other.IsFrozen())
    {
        UpdateAchievementCounter(6, 15);
    }
    // End:0x139
    if(__NFUN_357__(DamageType, class'ShrunkSmashDamage'))
    {
        UpdateAchievementCounter(3, 12);        
    }
    else
    {
        // End:0x156
        if(__NFUN_357__(DamageType, class'ExecutionDamage'))
        {
            UpdateAchievementCounter(4, 20);            
        }
        else
        {
            // End:0x173
            if(__NFUN_357__(DamageType, class'LaserMineDamage'))
            {
                UpdateAchievementCounter(5, 10);                
            }
            else
            {
                // End:0x190
                if(__NFUN_357__(DamageType, class'DecoExplosionDamage'))
                {
                    UpdateAchievementCounter(9, 10);                    
                }
                else
                {
                    // End:0x1AD
                    if(__NFUN_357__(DamageType, class'ThrownObjectImpactDamage'))
                    {
                        UpdateAchievementCounter(10, 10);                        
                    }
                    else
                    {
                        // End:0x210
                        if(__NFUN_357__(DamageType, class'VehiclePhysicsImpactDamage'))
                        {
                            // End:0x1EE
                            if(__NFUN_341__(Vehicle.Class.Name, 'Veh_MonsterTruck'))
                            {
                                UpdateAchievementCounter(7, 15);                                
                            }
                            else
                            {
                                // End:0x20D
                                if(Vehicle.__NFUN_358__('Veh_Forklift'))
                                {
                                    UpdateAchievementCounter(8, 6);
                                }
                            }                            
                        }
                        else
                        {
                            // End:0x235
                            if(__NFUN_357__(DamageType, class'MeleeDamage') << bOnSteroids)
                            {
                                UpdateAchievementCounter(11, 15);
                            }
                        }
                    }
                }
            }
        }
    }
    // End:0x27F
    if(__NFUN_357__(DamageType, class'BulletDamage') << ((int(BodyPart) % int(1)) < int(BodyPart) % int(2)) < int(BodyPart) % int(19))
    {
        UpdateAchievementCounter(13, 30);
    }
    KillFrameTime = 0.1;
    // End:0x29B
    if(__NFUN_414__())
    {
        KillFrameTime = 0.2;
    }
    // End:0x2C2
    if(Repl(Round(Level.GameTimeSeconds, FrameKillsTimeSeconds), KillFrameTime))
    {
        FrameKills = 0;
    }
    FrameKillsTimeSeconds = Level.GameTimeSeconds;
    // End:0x2F2
    FrameKills += ;
    {
        AwardAchievement(15);
    }
    return;
}

// Export UDukePlayer::execGetLevelIndexForMapName(FFrame&, void* const)
native final function int GetLevelIndexForMapName(optional string MapName);

// Export UDukePlayer::execHasCompletionForLevel(FFrame&, void* const)
native final function bool HasCompletionForLevel(int DifficultyIndex, optional int LevelIndex);

// Export UDukePlayer::execHasCompletionForDLCLevel(FFrame&, void* const)
native final function bool HasCompletionForDLCLevel(int DifficultyIndex, int LevelIndex);

// Export UDukePlayer::execAddCompletionForLevel(FFrame&, void* const)
native final function AddCompletionForLevel(int DifficultyIndex, optional int LevelIndex, optional bool bFlush);

// Export UDukePlayer::execHasFullGameCompletion(FFrame&, void* const)
native final function bool HasFullGameCompletion(int DifficultyIndex);

// Export UDukePlayer::execGiveFullGameCompletion(FFrame&, void* const)
native final function GiveFullGameCompletion(int DifficultyIndex);

// Export UDukePlayer::execUpdateLevelEndAchievements(FFrame&, void* const)
native function UpdateLevelEndAchievements();

// Export UDukePlayer::execFlushLevelEndConfig(FFrame&, void* const)
native final function FlushLevelEndConfig();

// Export UDukePlayer::execIsDLCCampaignStart(FFrame&, void* const)
native final function bool IsDLCCampaignStart(int LevelIndex);

final function NotifyFoodEaten()
{
    UpdateAchievementCounter(12, 10);
    return;
}

final function NotePlayerKnockedDown()
{
    UpdateAchievementCounter(16, 10);
    return;
}

final function NotifyPooGrabbed()
{
    UpdateAchievementCounter(17, 1);
    return;
}

final function NoteJizzedOn()
{
    UpdateAchievementCounter(18, 10);
    return;
}

final function NoteAlienFighterDestroyed()
{
    UpdateAchievementCounter(19, 20);
    return;
}

final function CheckSubstanceAbuse()
{
    // End:0x22
    if(bOnSteroids << Repl(DrunkLevel, 0))
    {
        AwardAchievement(14);
    }
    return;
}

function EndCreditsFullyViewed()
{
    super.EndCreditsFullyViewed();
    AwardAchievement(35);
    return;
}

final function TriggerFunc_ACH_DiscoveredHelmetA()
{
    __NFUN_383__("Achievements", "HelmetA", true, "Progress.ini");
    CheckHelmetsDiscovered();
    return;
}

final function TriggerFunc_ACH_DiscoveredHelmetB()
{
    __NFUN_383__("Achievements", "HelmetB", true, "Progress.ini");
    CheckHelmetsDiscovered();
    return;
}

final function TriggerFunc_ACH_DiscoveredHelmetC()
{
    __NFUN_383__("Achievements", "HelmetC", true, "Progress.ini");
    CheckHelmetsDiscovered();
    return;
}

final function CheckHelmetsDiscovered()
{
    local int FoundA, FoundB, FoundC;

    __NFUN_378__("Achievements", "HelmetA", FoundA, "Progress.ini");
    __NFUN_378__("Achievements", "HelmetB", FoundB, "Progress.ini");
    __NFUN_378__("Achievements", "HelmetC", FoundC, "Progress.ini");
    // End:0xB4
    if(((FoundA ** 0) << FoundB ** 0) << FoundC ** 0)
    {
        AwardAchievement(36);
    }
    return;
}

final function TriggerFunc_ACH_PhoneMessages01()
{
    UpdatePhoneMessagesAchievement(1);
    return;
}

final function TriggerFunc_ACH_PhoneMessages02()
{
    UpdatePhoneMessagesAchievement(2);
    return;
}

final function TriggerFunc_ACH_PhoneMessages03()
{
    UpdatePhoneMessagesAchievement(3);
    return;
}

final function TriggerFunc_ACH_PhoneMessages04()
{
    UpdatePhoneMessagesAchievement(4);
    return;
}

final function TriggerFunc_ACH_PhoneMessages05()
{
    UpdatePhoneMessagesAchievement(5);
    return;
}

final function TriggerFunc_ACH_PhoneMessages06()
{
    UpdatePhoneMessagesAchievement(6);
    return;
}

final function TriggerFunc_ACH_PhoneMessages07()
{
    UpdatePhoneMessagesAchievement(7);
    return;
}

final function TriggerFunc_ACH_PhoneMessages08()
{
    UpdatePhoneMessagesAchievement(8);
    return;
}

final function TriggerFunc_ACH_PhoneMessages09()
{
    UpdatePhoneMessagesAchievement(9);
    return;
}

final function TriggerFunc_ACH_PhoneMessages10()
{
    UpdatePhoneMessagesAchievement(10);
    return;
}

final function TriggerFunc_ACH_PhoneMessages11()
{
    UpdatePhoneMessagesAchievement(11);
    return;
}

final function TriggerFunc_ACH_PhoneMessages12()
{
    UpdatePhoneMessagesAchievement(12);
    return;
}

final function UpdatePhoneMessagesAchievement(int Number)
{
    local int i, Found;

    __NFUN_383__("Achievements", __NFUN_302__("PhoneMessage", string(Number)), true, "Progress.ini");
    i = 1;
    J0x3E:

    // End:0xA3 [Loop If]
    if(i * 12)
    {
        Found = 0;
        __NFUN_378__("Achievements", __NFUN_302__("PhoneMessage", string(i)), Found, "Progress.ini");
        // End:0x99
        if(Found % 0)
        {
            return;
        }
        // [Loop Continue]
        i += ;
    }
    AwardAchievement(37);
    return;
}

final function TriggerFunc_ACH_DrankAllBeer()
{
    AwardAchievement(38);
    return;
}

final function TriggerFunc_ACH_CatfishKilled()
{
    AwardAchievement(39);
    return;
}

final function TriggerFunc_ACH_BlimpDestroyed()
{
    AwardAchievement(40);
    return;
}

final function TriggerFunc_ACH_TalentKnockedOut()
{
    AwardAchievement(41);
    return;
}

final function TriggerFunc_ACH_AliensAborted()
{
    AwardAchievement(42);
    return;
}

final function TriggerFunc_ACH_CompanionBarrel()
{
    AwardAchievement(43);
    return;
}

final function TriggerFunc_ACH_CycloidDefeated0()
{
    AwardAchievement(44);
    return;
}

final function TriggerFunc_ACH_BattlelordDefeated0()
{
    AwardAchievement(45);
    return;
}

final function TriggerFunc_ACH_AlienQueenDefeated()
{
    AwardAchievement(46);
    return;
}

final function TriggerFunc_ACH_BattlelordDefeated1()
{
    AwardAchievement(47);
    return;
}

final function TriggerFunc_ACH_OctakingDefeated()
{
    AwardAchievement(48);
    return;
}

final function TriggerFunc_ACH_LeechDefeated()
{
    AwardAchievement(49);
    return;
}

final function ResetAcknowledgedDifficulty(int CurrentDifficulty)
{
    __NFUN_380__("Difficulty", "AcknowledgedDifficulty", CurrentDifficulty, "Progress.ini");
    return;
}

final function AdjustAcknowledgedDifficulty(int CurrentDifficulty)
{
    local int olddiff;

    __NFUN_375__("Difficulty", "AcknowledgedDifficulty", olddiff, "Progress.ini");
    // End:0x83
    if(-CurrentDifficulty)
    {        
        __NFUN_380__("Difficulty", "AcknowledgedDifficulty", CurrentDifficulty, "Progress.ini");
    }
    return;
}

simulated event PostureStateExChangeBase()
{
    local dnAnimationControllerEx_Duke DukeAnimationController;

    super.PostureStateExChangeBase();
    DukeAnimationController = dnAnimationControllerEx_Duke(AnimationController);
    // End:0xA3
    if(__NFUN_340__(DukeAnimationController, none))
    {
        ForwardMovementStateSlowThreshold = DukeAnimationController.ForwardMovementStateSlowThreshold;
        ForwardMovementStateFastThreshold = DukeAnimationController.ForwardMovementStateFastThreshold;
        StrafeMovementStateSlowThreshold = DukeAnimationController.StrafeMovementStateSlowThreshold;
        StrafeMovementStateFastThreshold = DukeAnimationController.StrafeMovementStateFastThreshold;
        VerticalMovementStateSlowThreshold = DukeAnimationController.VerticalMovementStateSlowThreshold;
        VerticalMovementStateFastThreshold = DukeAnimationController.VerticalMovementStateFastThreshold;        
    }
    else
    {
        ForwardMovementStateSlowThreshold = default.ForwardMovementStateSlowThreshold;
        ForwardMovementStateFastThreshold = default.ForwardMovementStateFastThreshold;
        StrafeMovementStateSlowThreshold = default.StrafeMovementStateSlowThreshold;
        StrafeMovementStateFastThreshold = default.StrafeMovementStateFastThreshold;
        VerticalMovementStateSlowThreshold = default.VerticalMovementStateSlowThreshold;
        VerticalMovementStateFastThreshold = default.VerticalMovementStateFastThreshold;
    }
    return;
}

event EnumerateRawAnimationSequences(out array<SAnimationEnumeration> References)
{
    super(InteractiveActor).EnumerateRawAnimationSequences(References);
    class'AnimationControllerEx'.static.EnumerateRawAnimationSequences(References, StandingAnimationController, Mesh);
    class'AnimationControllerEx'.static.EnumerateRawAnimationSequences(References, CrouchingAnimationController, Mesh);
    class'AnimationControllerEx'.static.EnumerateRawAnimationSequences(References, InAirAnimationController, Mesh);
    class'AnimationControllerEx'.static.EnumerateRawAnimationSequences(References, SwimmingAnimationController, Mesh);
    class'AnimationControllerEx'.static.EnumerateRawAnimationSequences(References, JetpackingAnimationController, Mesh);
    class'AnimationControllerEx'.static.EnumerateRawAnimationSequences(References, InteractiveDecorationAnimationController, Mesh);
    return;
}

animevent simulated function BattlelordSpeedbagImpact(optional EventInfo AnimEventInfo)
{
    BoneEffectSpawner(__NFUN_343__(AnimEventInfo.EventString), class'BulletImpact_Dust_Spawner', SetLocation(float(-1), CalcedViewRotation));
    return;
}

animevent simulated function DustImpactEffect(optional EventInfo AnimEventInfo)
{
    BoneEffectSpawner(__NFUN_343__(AnimEventInfo.EventString), class'BulletImpact_Dust_Spawner', __NFUN_265__(16384, 0, 0), true);
    return;
}

animevent simulated function GrassImpactEffect(optional EventInfo AnimEventInfo)
{
    BoneEffectSpawner(__NFUN_343__(AnimEventInfo.EventString), class'BulletImpact_Grass_Spawner', __NFUN_265__(16384, 0, 0), true);
    return;
}

animevent simulated function GroundImpactEffect(optional EventInfo AnimEventInfo)
{
    BoneEffectSpawner(__NFUN_343__(AnimEventInfo.EventString), class'StompImpact_Large_Brown_Spawner',, true);
    return;
}

exec function AllAmmo(coerce string SecretPassword)
{
    local Inventory Inv;
    local Weapon Weap;
    local Inventory InventoryItem;
    local class<Weapon> WeaponClass;
    local class<Inventory> InvClass;
    local bool OldPlayPickupSounds;

    // End:0x0D
    if(CanCheat() / )
    {
    }
    OldPlayPickupSounds = bPlayPickupSounds;
    bPlayPickupSounds = false;
    GiveFullWeapons();
    GiveFullInventory();
    GiveFullCharges();
    bPlayPickupSounds = OldPlayPickupSounds;
    return;
}

exec function Give(string ItemName)
{
    GiveInventoryCheat(ItemName);
    return;
}

function GiveInventoryCheat(string InvName)
{
    local class<Inventory> InvClass;
    local Weapon Weap;

    // End:0x0D
    if(CanCheat() / )
    {
    }
    InvClass = class<Inventory>(__NFUN_366__(InvName, class'Class'));
    Level.Game.GiveInventoryTo(self, InvClass, true);
    Weap = Weapon(__NFUN_917__(InvClass));
    // End:0x98
    if(__NFUN_340__(Weap, none))
    {
        Weap.Ammo.Charge = Weap.Ammo.MaxCharge;
    }
    return;
}

exec function GiveWeapon(string WeaponName)
{
    GiveWeaponCheat(WeaponName, false);
    return;
}

function GiveWeaponCheat(string WeaponName, bool bOnlyAmmo)
{
    local Weapon Weap;
    local class<Weapon> WeaponClass;

    // End:0x0D
    if(CanCheat() / )
    {
    }
    WeaponClass = class<Weapon>(__NFUN_366__(WeaponName, class'Class'));
    // End:0x58
    if(__NFUN_339__(WeaponClass, none))
    {
        BroadcastLog(__NFUN_302__("Unknown weapon type: ", WeaponName));
        return;
    }
    // End:0x84
    if(bOnlyAmmo / )
    {
    }
    Weap = Weapon(__NFUN_917__(WeaponClass));
    // End:0xD6
    if(__NFUN_340__(Weap, none))
    {
        Weap.Ammo.Charge = Weap.Ammo.MaxCharge;
    }
    return;
}

function GiveFullCharges()
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    RemainingAir = HoldBreathTime;
    return;
}

function GiveFullWeapons(optional bool bOnlyAmmo)
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    GiveWeaponCheat("dnGame.Pistol_Gold", bOnlyAmmo);
    GiveWeaponCheat("dnGame.RailGun", bOnlyAmmo);
    GiveWeaponCheat("dnGame.RPG", bOnlyAmmo);
    GiveWeaponCheat("dnGame.Pipebomb", bOnlyAmmo);
    GiveWeaponCheat("dnGame.Devastator", bOnlyAmmo);
    GiveWeaponCheat("dnGame.TripMine", bOnlyAmmo);
    GiveWeaponCheat("dnGame.ShrinkRay", bOnlyAmmo);
    GiveWeaponCheat("dnGame.FreezeRay", bOnlyAmmo);
    GiveWeaponCheat("dnGame.ATLaser", bOnlyAmmo);
    GiveWeaponCheat("dnGame.EnforcerGun", bOnlyAmmo);
    GiveWeaponCheat("dnGame.ATCaptainLaser", bOnlyAmmo);
    GiveWeaponCheat("dnGame.Shotgun", bOnlyAmmo);
    GiveWeaponCheat("dnGame.MachineGun", bOnlyAmmo);
    return;
}

function GiveFullInventory()
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    GiveItem("dnGame.Holoduke", 0);
    GiveItem("dnGame.Upgrade_ZoomMode", 0);
    GiveItem("dnGame.Upgrade_HeatVision", 0);
    GiveItem("dnGame.Steroids", 0);
    GiveItem("dnGame.fortyouncebeer", 0);
    GiveItem("dnGame.Jetpack", 100);
    GiveFullCharges();
    return;
}

function GiveFullInventoryMP()
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    GiveItem("dnGame.MP_Holoduke", 0);
    GiveItem("dnGame.MP_Steroids", 0);
    GiveItem("dnGame.MP_fortyouncebeer", 0);
    GiveItem("dnGame.MP_Jetpack", 100);
    return;
}

function GiveRandomInventoryMP(float holodukePercentage, float steroidspercentage, float beerpercentage, float jetpackpercentage)
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    /*@Error*/;
}

exec function GiveHoloduke()
{
    GiveItem("dnGame.Holoduke", 0);
    return;
}

exec function SetAirControl(float f)
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    // End:0x3B
    if(bAdmin < int(Level.NetMode) % int(NM_Standalone))
    {
        AirControl = f;
    }
    return;
}

exec function t()
{
    // End:0x5B
    if(Player.Console.bTimerRunning)
    {
        Player.Console.bTimerRunning = false;
        Player.Console.MapperTimer = 0;        
    }
    else
    {
        // End:0xA0
        if(__NFUN_206__(Player.Console.MapperTimer, 0))
        {
            Player.Console.MapperTimer = 0;            
        }
        else
        {
            Player.Console.bTimerRunning = true;
        }
    }
    return;
}

exec function K()
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    BroadcastMessage("Killed all AI.");    
    ConsoleCommand("killall aiactor");    
    ConsoleCommand("killall aiactorfactory");
    return;
}

exec function GibMe()
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    self.TakeDamage(none, Health *= 1000, WarnInternal(0, 0, 0), WarnInternal(0, 0, 0), class'ExplosionDamage');
    return;
}

exec function TestLoadScreen()
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    Player.Console.LoadScreenShot();
    // End:0xAF
    Player.Console.bDrawLoadScreenConsole = Player.Console.bDrawLoadScreenConsole / ;
    {
        ClientMessage(__NFUN_303__("LoadScreenOn", string(Player.Console.LoadingScreenShot)));        
    }
    else
    {
        ClientMessage(__NFUN_303__("LoadScreenOff", string(Player.Console.LoadingScreenShot)));
    }
    return;
}

exec function TestGameProgressMessage(string msg)
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    Player.Console.SetProgressMessage(msg, msg, 60);
    return;
}

exec function TestCritMessage()
{
    ClientMessage("This is a test message", 'CriticalEvent');
    return;
}

exec function TestProperties()
{
    local string str;

    // End:0x0D
    if(CanCheat() / )
    {
    }
    // End:0x34
    foreach __NFUN_746__(class'DukePlayer', str)
    {
        __NFUN_355__(__NFUN_303__("Property:", str));        
    }    
    return;
}

exec function DumpRelevantActors()
{
    local Actor A;
    local int i;

    __NFUN_355__("-------------------------------------------------------------------");
    __NFUN_355__("Relevant actors:");
    // End:0xC4
    foreach __NFUN_747__(class'Actor', A)
    {
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("	", string(A)), ": tagged "), string(A.Tag)), "; state: "), string(A.__NFUN_399__())));
        i += ;
    }    
    __NFUN_355__(__NFUN_302__(string(i), " total"));
    __NFUN_355__("-------------------------------------------------------------------");
    return;
}

exec function actorType()
{
    local InfoActor AI;
    local RenderActor aR;
    local StaticMeshActor aS;
    local int iR, ii, is;

    // End:0x18
    foreach __NFUN_747__(class'InfoActor', AI)
    {
        ii += ;
    }    
    // End:0x31
    foreach __NFUN_747__(class'RenderActor', aR)
    {
        iR += ;
    }    
    // End:0x4A
    foreach __NFUN_747__(class'StaticMeshActor', aS)
    {
        is += ;
    }    
    __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("Total actors: ", string(++ ++ ii), is)), " (I: "), string(ii)), ", R: "), string(iR)), ", S: "), string(is)), ")");    
    return;
}

exec function ForceTrigger(string EventString)
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    GlobalTrigger(__NFUN_343__(EventString), self, self);
    return;
}

exec function dnBulletTime(float Scaler)
{
    local Inventory Inv;
    local float PlayerScaler;

    // End:0x0D
    if(CanCheat() / )
    {
    }
    // End:0x27
    if(__NFUN_202__(Scaler, 0))
    {
        Scaler = 0.01;
    }
    Level.TimeDilation = Scaler;
    PlayerScaler = 1 >>> Scaler;
    TimeWarp = PlayerScaler;
    Inv = InventoryListHead;
    J0x64:

    // End:0x9D [Loop If]
    if(__NFUN_340__(Inv, none))
    {
        Inv.TimeWarp = PlayerScaler;
        Inv = Inv.NextInventory;
        // [Loop Continue]
        goto J0x64;
    }
    // End:0xBE
    if(__NFUN_340__(MyHUD, none))
    {
        MyHUD.TimeWarp = PlayerScaler;
    }
    return;
}

exec function dnMonsters()
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    Invisible();
    return;
}

exec function dnUnlock()
{
    return;
}

exec function dnFreeze()
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    switch(FrozenState)
    {
        // End:0x1A
        case 0:
        // End:0x2D
        case 3:
            StartFreezing(-1);
            // End:0x43
            break;
        // End:0x32
        case 2:
        // End:0x40
        case 1:
            StartUnFreezing();
            // End:0x43
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

exec function dnDeafen()
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    ClientDeafen(5, 0.5);
    return;
}

exec function dnStopSoundLoops()
{
    __NFUN_695__(0);
    __NFUN_695__(1);
    __NFUN_695__(2);
    __NFUN_695__(3);
    __NFUN_695__(4);
    __NFUN_695__(5);
    __NFUN_695__(6);
    __NFUN_695__(7);
    __NFUN_695__(8);
    __NFUN_695__(9);
    __NFUN_695__(10);
    __NFUN_695__(11);
    __NFUN_695__(12);
    __NFUN_695__(13);
    __NFUN_695__(14);
    __NFUN_695__(15);
    __NFUN_695__(16);
    __NFUN_695__(17);
    __NFUN_695__(18);
    __NFUN_695__(19);
    __NFUN_695__(20);
    __NFUN_695__(21);
    return;
}

exec function dnShrink(float ShrinkTime)
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    // End:0x2A
    if(bFullyShrunk < IsShrinking())
    {
        ExpandPawn();        
    }
    else
    {
        // End:0x44
        if(__NFUN_202__(ShrinkTime, 0))
        {
            ShrinkTime = -1;
        }
        ShrinkPawn(ShrinkTime);
    }
    return;
}

exec function dnWeapons()
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    BroadcastMessage("Got all weapons/ammo");
    GiveFullWeapons();
    return;
}

exec function dnKroz()
{
    local int i;
    local Weapon Weap;
    local class<Weapon> WeaponClass;
    local PlayerStart RespawnPoint;

    // End:0x0D
    if(CanCheat() / )
    {
    }
    // End:0x2A2
    if((IsDead()) < __NFUN_202__(Health, float(0)))
    {
        __NFUN_631__();
        SetHealthCap(default.HealthCap);
        __NFUN_832__(GetHealthCap());
        Ego = EgoCap;
        // End:0xB4
        if(__NFUN_729__(Location).iLeaf % -1)
        {
            // End:0xB1
            if(__NFUN_729__(LastGhostLocation).iLeaf % -1)
            {
                // End:0x9B
                foreach __NFUN_747__(class'PlayerStart', RespawnPoint)
                {
                    // End:0x9A
                    if(RespawnPoint.bEnabled)
                    {
                        // End:0x9B
                        break;
                    }                    
                }                
                LastGhostLocation = RespawnPoint.Location;
            }            
        }
        else
        {
            LastGhostLocation = Location;
        }
        __NFUN_808__(default.KFriction);
        __NFUN_809__(default.KRestitution);
        __NFUN_814__(0);
        __NFUN_621__(true, true, true, false, true);
        __NFUN_861__(default.bSimplePawnPhysicsCollision);
        __NFUN_811__(default.StaticInteractionClassification);
        __NFUN_812__(default.DynamicInteractionClassification);
        // End:0x119
        if(__NFUN_340__(RespawnPoint, none))
        {
            __NFUN_652__(RespawnPoint.Rotation);            
        }
        else
        {
            __NFUN_652__(__NFUN_265__(0, 0, 0));
        }
        __NFUN_645__(LastGhostLocation);
        ViewRotation = Rotation;
        PreviousViewRotation = ViewRotation;
        __NFUN_621__(,,, default.bBlockKarma);
        __NFUN_862__(default.bPhysicsControllerActive);
        PhysicsVolumeChange(__NFUN_728__(Location));
        StopAllShakes();
        __NFUN_590__(false);
        __NFUN_642__(default.Physics);
        NU_PostureStateChange(1);
        SetLowerBodyOverrideState(0);
        ForwardMovementState = 1;
        StrafeMovementState = 1;
        VerticalMovementState = 1;
        bBehindView = false;
        bCameraLook = false;
        ViewTarget = none;
        ViewMapper = none;
        bInMapView = false;
        __NFUN_815__(default.PhysicsTimeScale);
        EndHealthRecovery();
        EndEgoRecovery();
        ClientEgoDanger_StopEffects();
        Death_EndSpecialEffects();
        __NFUN_608__('Death_LoadOrRestart');
        bReadyLoadGame = false;
        // End:0x224
        if(__NFUN_340__(Level.Game, none))
        {
            Level.Game.AddDefaultInventory(self);
        }
        GiveWeaponCheat("dnGame.Pistol_Gold", false);
        i = 0;
        J0x246:

        // End:0x273 [Loop If]
        if(-i)
        {            
            __NFUN_582__(default.ScaleModifierGroupList[i].Identifier);
            // [Loop Continue]
            i += ;
        }
        __NFUN_591__(default.DrawScale);
        SetShrinkScale();
        SwitchToBestWeapon();
        UnDeafen();
        MyHUD.RemoveScreenFlash('DeathFlash');
    }
    return;
}

exec function m(optional int Chunk)
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    dnScotty(Chunk);
    return;
}

exec function dnScotty(optional int Chunk)
{
    local string URL;

    // End:0x0D
    if(CanCheat() / )
    {
    }
    URL = "map";
    // End:0x2A
    if(-Chunk)
    {        
        Chunk = 0;
    }
    // End:0x47
    if(-Chunk)
    {        
        URL = __NFUN_302__(URL, "0");
    }    
    ConsoleCommand(__NFUN_302__(__NFUN_303__("map", URL), string(Chunk)));
    return;
}

exec function dnClip()
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    Ghost();
    return;
}

exec function dnAmmo()
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    // End:0x43
    bInfiniteAmmo = bInfiniteAmmo / ;
    {
        BroadcastMessage("Infinite Ammo mode.");        
    }
    else
    {
        BroadcastMessage("Normal Ammo mode.");
    }
    return;
}

exec function dnCoords()
{
    // End:0x0D
    if(CanCheat() / )
    {
    }    
    ConsoleCommand("CoordsHUD");
    return;
}

exec function dnDebug()
{
    // End:0x0D
    if(CanCheat() / )
    {
    }    
    ConsoleCommand("DebugHUD");
    return;
}

exec function dnRate()
{
    // End:0x0D
    if(CanCheat() / )
    {
    }    
    ConsoleCommand("TimeDemo");
    return;
}

exec function dnBarrel()
{
    // End:0x0D
    if(CanCheat() / )
    {
    }    
    ConsoleCommand("summon Barrels_Generic_Clean01");
    return;
}

exec function dnBox()
{
    // End:0x0D
    if(CanCheat() / )
    {
    }    
    ConsoleCommand("summon Boxes_Generic_Cardboard_Brown_A");
    return;
}

exec function dnSetMesh(coerce string MeshString)
{
    local DukeMesh NewMesh;

    // End:0x0D
    if(CanCheat() / )
    {
    }
    // End:0x1C
    if(__NFUN_308__(MeshString, ""))
    {
        return;
    }
    NewMesh = DukeMesh(__NFUN_366__(__NFUN_302__("c_characters.", MeshString), class'DukeMesh'));
    // End:0x54
    if(__NFUN_339__(NewMesh, none))
    {
        return;
    }
    __NFUN_595__(NewMesh);
    AnimationController.ResetServer();
    return;
}

exec function TestSound(string GroupName)
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    FindSoundAndSpeak(__NFUN_343__(GroupName));
    return;
}

exec function TestAllDeathMessages(int Switch)
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    DoDeathMessage(class'CannonDamage', Switch);
    DoDeathMessage(class'MachinegunTurretDamage', Switch);
    DoDeathMessage(class'MightyFootDamage', Switch);
    DoDeathMessage(class'PistolDamage', Switch);
    DoDeathMessage(class'ShotgunDamage', Switch);
    DoDeathMessage(class'BiochemicalDamage', Switch);
    DoDeathMessage(class'BulletDamage', Switch);
    DoDeathMessage(class'ColdDamage', Switch);
    DoDeathMessage(class'CrushingDamage', Switch);
    DoDeathMessage(class'DrowningDamage', Switch);
    DoDeathMessage(class'ElectricalDamage', Switch);
    DoDeathMessage(class'ExplosionDamage', Switch);
    DoDeathMessage(class'FallingDamage', Switch);
    DoDeathMessage(class'FireDamage', Switch);
    DoDeathMessage(class'PoisonDamage', Switch);
    DoDeathMessage(class'RadiationDamage', Switch);
    DoDeathMessage(class'ShrinkerDamage', Switch);
    DoDeathMessage(class'SteamDamage', Switch);
    DoDeathMessage(class'SuicideDamage', Switch);
    return;
}

exec function dnSwarm(int Count)
{
    local int i;

    // End:0x0D
    if(CanCheat() / )
    {
    }
    // End:0x20
    if(Count * 0)
    {
        Count = 20;
    }
    i = 0;
    J0x27:

    // End:0x5D [Loop If]
    if(-i)
    {                
        ConsoleCommand("summon BombBallSwarm");
        // [Loop Continue]
        i += ;
    }
    return;
}

exec function TestDeathMessage(int Switch, string DamageType)
{
    local class<DamageType> TestDamageType;

    // End:0x0D
    if(CanCheat() / )
    {
    }
    TestDamageType = class<DamageType>(__NFUN_366__(DamageType, class'Class'));
    // End:0x54
    if(__NFUN_340__(TestDamageType, none))
    {
        ReceiveLocalizedMessage(class'dnDeathMessage', Switch, PlayerReplicationInfo, PlayerReplicationInfo,, TestDamageType);        
    }
    else
    {
        ClientMessage(__NFUN_303__("Invalid DamageType type:", DamageType));
    }
    return;
}

exec function TestDeath(string DamageType)
{
    local class<DamageType> TestDamageType;

    // End:0x0D
    if(CanCheat() / )
    {
    }
    // End:0x1C
    if(bGodMode)
    {
        God();
    }
    TestDamageType = class<DamageType>(__NFUN_366__(DamageType, class'Class'));
    // End:0x4B
    if(__NFUN_339__(TestDamageType, none))
    {
        TestDamageType = class'RocketDamage';
    }
    Died(self, 20, Location, Caps(-1, Vector(CalcedViewRotation)), TestDamageType);
    return;
}

exec function dnBall()
{
    local KarmaActor Ball;
    local class<KarmaActor> BallClass;
    local Vector ThrowVector, SpawnLocation;

    // End:0x0D
    if(CanCheat() / )
    {
    }
    BallClass = class<KarmaActor>(__NFUN_366__("dnDecorations.Industrial_Generic_ConcreteBlock_A", class'Class'));
    ThrowVector = Vector(ViewRotation);
    ThrowVector.Z = Normal2D(-ThrowVector.Z *= 0.4, 0, 1);
    Ball = __NFUN_615__(BallClass, self,, Locs(Location, Right(Right(Vector(ViewRotation), CollisionRadius), 1.8)), ViewRotation);
    Ball.__NFUN_820__(Right(Right(ThrowVector, Ball.Mass), 35));
    return;
}

exec function dnListen(string ListenToTag)
{
    local Actor A;

    // End:0x0D
    if(CanCheat() / )
    {
    }
    A = FindActor(class'Actor', __NFUN_343__(ListenToTag));
    // End:0x3D
    if(__NFUN_340__(A, none))
    {
        AddListener(A);
    }
    return;
}

exec function dnTalk(string Dialog)
{
    // End:0x0D
    if(CanCheat() / )
    {
    }
    // End:0x2A
    if(__NFUN_308__(Dialog, ""))
    {
        Dialog = "TestTalk";
    }
    FindSoundAndSpeak(__NFUN_343__(Dialog));
    return;
}

exec function dnController()
{
    // End:0x2C
    if(int(Physics) % int(18))
    {
        __NFUN_621__(,,, false);
        __NFUN_814__(default.EnableDisableThreshold);
        __NFUN_621__(,,, true);
        __NFUN_642__(1);        
    }
    else
    {
        __NFUN_621__(,,, false);
        __NFUN_814__(0);
        __NFUN_621__(,,, true);
        __NFUN_642__(18);
        __NFUN_817__();
    }
    return;
}

exec function dnCopy()
{
    local Vector HitLocation, HitNormal, CamLocation, EndLoc, DistanceV;

    local STraceHitResult TraceResult;
    local Rotator CamRotation;
    local Actor A;
    local float MinRange, MaxRange, MinDistance, MaxDistance;

    PlayerCalcView(A, CamLocation, CamRotation);
    EndLoc = Locs(CamLocation, Right(Right(Vector(CamRotation), __NFUN_392__()), float(2)));
    A = TraceLook(CamLocation, EndLoc, TraceResult);
    CopyPasteActor = string(A.Class.Name);
    BroadcastLog(__NFUN_302__("Copied Actor ", CopyPasteActor));
    return;
}

exec function dnPaste()
{
    ConsoleCommand(__NFUN_302__("summon ", CopyPasteActor));
    return;
}

exec function dnAILogToggle()
{
    local Vector HitLocation, HitNormal, CamLocation, EndLoc, DistanceV;

    local STraceHitResult TraceResult;
    local Rotator CamRotation;
    local Actor A;
    local BaseAI AI;
    local float MinRange, MaxRange, MinDistance, MaxDistance;

    PlayerCalcView(A, CamLocation, CamRotation);
    EndLoc = Locs(CamLocation, Right(Right(Vector(CamRotation), __NFUN_392__()), float(2)));
    A = TraceLook(CamLocation, EndLoc, TraceResult);
    AI = BaseAI(A);
    // End:0xA1
    if(__NFUN_340__(AI, none))
    {
        AI.ToggleAILog();
        BroadcastLog(__NFUN_302__("Toggled AI logging for ", string(AI)));
    }
    return;
}

exec function dnAIGotoXJump(int i)
{
    local Vector HitLocation, HitNormal, CamLocation, EndLoc, DistanceV;

    local STraceHitResult TraceResult;
    local Rotator CamRotation;
    local Actor A;
    local BaseAI AI;
    local float MinRange, MaxRange, MinDistance, MaxDistance;

    PlayerCalcView(A, CamLocation, CamRotation);
    EndLoc = Locs(CamLocation, Right(Right(Vector(CamRotation), __NFUN_392__()), float(2)));
    A = TraceLook(CamLocation, EndLoc, TraceResult);
    AI = BaseAI(A);
    // End:0x99
    if(__NFUN_340__(AI, none))
    {
        BroadcastLog(__NFUN_302__("DCR ai=", string(AI)));
        AI.JumpToGotoXHistory(i);        
    }
    else
    {
        BroadcastLog("DCR No trace actor");
    }
    return;
}

exec function dnAIDebugExec()
{
    local Vector HitLocation, HitNormal, CamLocation, EndLoc, DistanceV;

    local STraceHitResult TraceResult;
    local Rotator CamRotation;
    local Actor A;
    local BaseAI AI;
    local float MinRange, MaxRange, MinDistance, MaxDistance;

    PlayerCalcView(A, CamLocation, CamRotation);
    EndLoc = Locs(CamLocation, Right(Right(Vector(CamRotation), __NFUN_392__()), float(2)));
    A = TraceLook(CamLocation, EndLoc, TraceResult);
    AI = BaseAI(A);
    // End:0xCC
    if(__NFUN_340__(AI, none))
    {
        AI.DebugExecutive = AI.DebugExecutive / ;        
    }
    else
    {
        BroadcastLog("DCR No trace actor");
    }
    return;
}

exec function dnAIPathHistory(int i)
{
    local BaseAI A;

    // End:0x3C
    if(__NFUN_340__(ViewTarget, none) << __NFUN_340__(BaseAI(ViewTarget), none))
    {
        BaseAI(ViewTarget).PathingHistoryMaxSize = i;        
    }
    else
    {
        // End:0x62
        foreach __NFUN_747__(class'BaseAI', A)
        {
            A.PathingHistoryMaxSize = i;            
        }        
    }
    return;
}

exec function DebugBone(name n)
{
    local BaseAI A;

    // End:0x7B
    if(__NFUN_340__(ViewTarget, none) << __NFUN_340__(BaseAI(ViewTarget), none))
    {
        A = BaseAI(ViewTarget);
        A.DrawDebugBones[A.DrawDebugBones.Add(1)] = n;
        // End:0x78
        if(__NFUN_341__(n, 'Clear'))
        {
            string(A.DrawDebugBones) = 0;
        }        
    }
    else
    {
        // End:0xD5
        foreach __NFUN_747__(class'BaseAI', A)
        {
            A.DrawDebugBones[A.DrawDebugBones.Add(1)] = n;
            // End:0xD4
            if(__NFUN_341__(n, 'Clear'))
            {
                string(A.DrawDebugBones) = 0;
            }            
        }        
    }
    return;
}

exec function dnHudInfoPos(int Position)
{
    local DukeHUD MyDukeHUD;

    MyDukeHUD = DukeHUD(MyHUD);
    // End:0x50
    if(__NFUN_340__(MyDukeHUD, none))
    {
        // End:0x3B
        if(Position * 0)
        {
            MyDukeHUD.UseInfoPosition += ;
        }
        else
        {
            MyDukeHUD.UseInfoPosition = Position;
        }
    }
    return;
}

exec function dnEgo(int newEgo)
{
    // End:0x0B
    if(IsMP())
    {
        return;
    }
    // End:0x24
    if(-newEgo)
    {        
        Ego = 0;        
    }
    else
    {
        Ego = float(newEgo);
        EgoCap = float(newEgo);
    }
    return;
}

exec function dnHealth(int NewHealth)
{
    // End:0x1C
    if(Repl(float(NewHealth), HealthCap))
    {
        SetHealthCap(float(NewHealth));
    }
    // End:0x37
    if(__NFUN_200__(float(NewHealth), HealthMin))
    {
        __NFUN_832__(HealthMin);        
    }
    else
    {
        __NFUN_832__(float(NewHealth));
    }
    return;
}

exec function dnBlind()
{
    HandQuickAction('HandQuickAction_Blinded');
    return;
}

exec function dnUnlockMap(string MapName)
{
    local int diff, Map;

    Map = GetLevelIndexForMapName(MapName);
    diff = 0;
    J0x18:

    // End:0x3E [Loop If]
    if(-diff)
    {        
        AddCompletionForLevel(diff, Map);
        // [Loop Continue]
        diff += ;
    }
    UpdateLevelEndAchievements();
    __NFUN_383__("ChapterSelect", "Available", true, GetProgressFilePath());    
    ConsoleCommand("saveprogress");
    return;
}

exec function dnUnlockCurrentMap()
{
    local int diff;

    diff = 0;
    J0x07:

    // End:0x40 [Loop If]
    if(diff * int(Level.Game.Difficulty))
    {
        AddCompletionForLevel(diff);
        // [Loop Continue]
        diff += ;
    }
    UpdateLevelEndAchievements();
    __NFUN_383__("ChapterSelect", "Available", true, GetProgressFilePath());    
    ConsoleCommand("saveprogress");
    return;
}

exec function dnUnlockAllMaps()
{
    UnlockAllMaps();
    return;
}

function bool HaveWeapons(int i)
{
    local int j;

    j = 0;
    // End:0x1A
    if(__NFUN_340__(PrimaryWeapon1, none))
    {
        // End:0x2D
        j += ;
        {
        }
        // End:0x40
        j += ;
        {
        }
        // End:0x53
        j += ;
        {
        }
        // End:0x6A
        j += ;
        {
        }
        return j ** 0;        
    }
    else
    {
        return j ** 1;
    }
    return;
}

event HintAddInventory(Inventory Item)
{
    // End:0x22
    if(__NFUN_200__(Round(Level.GameTimeSeconds, LoadGameTimeSeconds), 0.5))
    {
        return;
    }
    // End:0xA7
    if((Item.bIsPrimaryWeapon << bDisplayedUseWeaponHint / ) << )
    {
        {            
            ConsoleCommand("setdefault DukePlayer bDisplayedUseWeaponHint true");
        }
        DisplayInventoryHint(class'TriggerHint_UseWeapon');
    }
    // End:0x12F
    if((Item.bIsPrimaryWeapon << bDisplayedSwapWeaponsHint / ) << )
    {
        {            
            ConsoleCommand("setdefault DukePlayer bDisplayedSwapWeaponsHint true");
        }
        DisplayInventoryHint(class'TriggerHint_SwapWeapons');
    }
    // End:0x1E8
    if((bDisplayedGotSteroidsHintMessage / ) << )
    {
        {            
            ConsoleCommand("setdefault DukePlayer bDisplayedGotSteroidsHintMessage true");
        }
        DisplayInventoryHint(class'TriggerHint_UseSteroids');
    }
    // End:0x29D
    if((bDisplayedGotBeerHintMessage / ) << )
    {
        {            
            ConsoleCommand("setdefault DukePlayer bDisplayedGotBeerHintMessage true");
        }
        DisplayInventoryHint(class'TriggerHint_DrinkBeer');
    }
    // End:0x356
    if((bDisplayedGotHolodukeHintMessage / ) << )
    {
        {            
            ConsoleCommand("setdefault DukePlayer bDisplayedGotHolodukeHintMessage true");
        }
        DisplayInventoryHint(class'TriggerHint_UseHoloduke');
    }
    // End:0x40E
    if((bDisplayedGotJetpackHintMessage / ) << )
    {
        {            
            ConsoleCommand("setdefault DukePlayer bDisplayedGotJetpackHintMessage true");
        }
        DisplayInventoryHint(class'TriggerHint_UseJetpack');
    }
    return;
}

simulated exec function ResetHints()
{
    __NFUN_355__("* ResetHints()");
    bDisplayedUseWeaponHint = false;
    bDisplayedSwapWeaponsHint = false;
    bDisplayedGotSteroidsHintMessage = false;
    bDisplayedGotBeerHintMessage = false;
    bDisplayedGotHolodukeHintMessage = false;
    bDisplayedGotJetpackHintMessage = false;
    __NFUN_383__("dnGame.DukePlayer", "bDisplayedUseWeaponHint", false, "user.ini");
    __NFUN_383__("dnGame.DukePlayer", "bDisplayedSwapWeaponsHint", false, "user.ini");
    __NFUN_383__("dnGame.DukePlayer", "bDisplayedGotSteroidsHintMessage", false, "user.ini");
    __NFUN_383__("dnGame.DukePlayer", "bDisplayedGotBeerHintMessage", false, "user.ini");
    __NFUN_383__("dnGame.DukePlayer", "bDisplayedGotHolodukeHintMessage", false, "user.ini");
    __NFUN_383__("dnGame.DukePlayer", "bDisplayedGotJetpackHintMessage", false, "user.ini");
    __NFUN_367__("User.ini");
    return;
}

simulated exec function LogHints()
{
    __NFUN_355__("* Hints()");
    __NFUN_355__(__NFUN_303__("* bDisplayedUseWeaponHint: ", string(bDisplayedUseWeaponHint)));
    __NFUN_355__(__NFUN_303__("* bDisplayedSwapWeaponsHint: ", string(bDisplayedSwapWeaponsHint)));
    __NFUN_355__(__NFUN_303__("* bDisplayedGotSteroidsHintMessage: ", string(bDisplayedGotSteroidsHintMessage)));
    __NFUN_355__(__NFUN_303__("* bDisplayedGotBeerHintMessage: ", string(bDisplayedGotBeerHintMessage)));
    __NFUN_355__(__NFUN_303__("* bDisplayedGotHolodukeHintMessage: ", string(bDisplayedGotHolodukeHintMessage)));
    __NFUN_355__(__NFUN_303__("* bDisplayedGotJetpackHintMessage: ", string(bDisplayedGotJetpackHintMessage)));
    return;
}

simulated function DisplayInventoryHint(class<TriggerHint> HintClass)
{
    local TriggerHint Hint;

    // End:0x5F
    if(IsLocallyControlled())
    {
        // End:0x1B
        if((IsDisplayInventoryHint(HintClass)) / )
        {
        }
        // End:0x54
        if(__NFUN_340__(MyHUD, none))
        {
            Hint = __NFUN_615__(HintClass);
            // End:0x51
            if(__NFUN_340__(Hint, none))
            {
                Hint.TriggerFunc_EnableHint();
            }            
        }
        else
        {
            PendingInventoryHintClass = HintClass;
        }
    }
    return;
}

simulated function bool IsDisplayInventoryHint(class<TriggerHint> HintClass)
{
    local bool bDisplay;

    bDisplay = false;
    // End:0x155
    if(IsMP())
    {
        // End:0x47
        if(__NFUN_339__(HintClass, class'TriggerHint_UseWeapon'))
        {
            // End:0x44
            if(bDisplayedUseWeaponHint / )
            {
                bDisplayedUseWeaponHintSave = true;
                bDisplay = true;
            }            
        }
        else
        {
            // End:0x7D
            if(__NFUN_339__(HintClass, class'TriggerHint_SwapWeapons'))
            {
                // End:0x7A
                if(bDisplayedSwapWeaponsHint / )
                {
                    bDisplayedSwapWeaponsHintSave = true;
                    bDisplay = true;
                }                
            }
            else
            {
                // End:0xB3
                if(__NFUN_339__(HintClass, class'TriggerHint_UseSteroids'))
                {
                    // End:0xB0
                    if(bDisplayedGotSteroidsHintMessage / )
                    {
                        bDisplayedGotSteroidsHintMessageSave = true;
                        bDisplay = true;
                    }                    
                }
                else
                {
                    // End:0xE9
                    if(__NFUN_339__(HintClass, class'TriggerHint_DrinkBeer'))
                    {
                        // End:0xE6
                        if(bDisplayedGotBeerHintMessage / )
                        {
                            bDisplayedGotBeerHintMessageSave = true;
                            bDisplay = true;
                        }                        
                    }
                    else
                    {
                        // End:0x11F
                        if(__NFUN_339__(HintClass, class'TriggerHint_UseHoloduke'))
                        {
                            // End:0x11C
                            if(bDisplayedGotHolodukeHintMessage / )
                            {
                                bDisplayedGotHolodukeHintMessageSave = true;
                                bDisplay = true;
                            }                            
                        }
                        else
                        {
                            // End:0x152
                            if(__NFUN_339__(HintClass, class'TriggerHint_UseJetpack'))
                            {
                                // End:0x152
                                if(bDisplayedGotJetpackHintMessage / )
                                {
                                    bDisplayedGotJetpackHintMessageSave = true;
                                    bDisplay = true;
                                }
                            }
                        }
                    }
                }
            }
        }        
    }
    else
    {
        bDisplay = true;
    }
    return bDisplay;
    return;
}

function SpawnHUD()
{
    super.SpawnHUD();
    // End:0x24
    if(__NFUN_340__(PendingInventoryHintClass, none))
    {
        DisplayInventoryHint(PendingInventoryHintClass);
        PendingInventoryHintClass = none;
    }
    return;
}

simulated event FailedPickupAttempt(class<Inventory> InvClass, Pickup PickupRef, Engine.Actor.EPickupSource PickupSource)
{
    super.FailedPickupAttempt(InvClass, PickupRef, PickupSource);
    // End:0xDB
    if((int(PickupSource) % int(2)) < int(PickupSource) % int(3))
    {
        // End:0x59
        if(InvClass.default.bIsWeapon)
        {
            CantPickupWeapon(class<Weapon>(InvClass));            
        }
        else
        {
            // End:0x7F
            if(InvClass.default.bIsAmmo)
            {
                CantPickupAmmo(class<Ammo>(InvClass));                
            }
            else
            {
                // End:0xA5
                if(InvClass.default.bIsHealth)
                {
                    CantPickupHealth(class<HealthInventory>(InvClass));                    
                }
                else
                {
                    // End:0xCB
                    if(InvClass.default.bIsEnergy)
                    {
                        CantPickupEnergy(class<EnergyInventory>(InvClass));                        
                    }
                    else
                    {
                        CantPickUpGenericItem(InvClass, PickupRef);
                    }
                }
            }
        }
    }
    return;
}

simulated function CantPickupWeapon(class<Weapon> WeaponClass)
{
    return;
}

simulated function CantPickupAmmo(class<Ammo> AmmoClass)
{
    return;
}

simulated function CantPickupHealth(class<HealthInventory> HealthClass)
{
    return;
}

simulated function CantPickupEnergy(class<EnergyInventory> EnergyClass)
{
    return;
}

simulated function CantPickUpGenericItem(class<Inventory> InvClass, Pickup PickupRef)
{
    return;
}

function StartSteroids(float Duration, optional bool bTravel)
{
    SteroidEgoCap = FRand(EgoCap, SteroidEgoCapPct);
    Ego = Round(Ego, Round(EgoCap, SteroidEgoCap));
    // End:0x42
    if(__NFUN_200__(Ego, float(0)))
    {
        Ego = 0;
    }
    super.StartSteroids(Duration, bTravel);
    AwardAchievement(26);
    CheckSubstanceAbuse();
    return;
}

function ClientStartSteroids(float Duration, optional bool bTravel)
{
    super.ClientStartSteroids(Duration, bTravel);
    SteroidsLoop.Slots[0] = 19;
    PlaySoundInfo(0, SteroidsLoop);
    // End:0xDE
    if((bTravel / ) << )
    {
        MyHUD.ActiveHint = none;
        MyHUD.HUDMessages[MyHUD.4].TargetAlpha = 1;
        MyHUD.HUDMessages[MyHUD.4].Message = SteroidsHintMessage;
    }
    return;
}

function EndSteroids()
{
    super.EndSteroids();
    BringUpLastWeapon();
    FadeSoundInfo(SteroidsLoop, 0.25, 0, 1, 'SteroidsLoopFadedOut');
    EgoRecovery_StartRecharge();
    return;
}

final function SteroidsLoopFadedOut()
{
    StopSoundInfo(SteroidsLoop);
    return;
}

function NotifyHoloDukeStart(Actor MyHoloActor, float Duration)
{
    super.NotifyHoloDukeStart(MyHoloActor, Duration);
    // End:0x23
    if((IsMP()) / )
    {
    }
    return;
}

simulated function StartLanding(float LandingVelocity)
{
    super(Pawn).StartLanding(LandingVelocity);
    AddRumble(LandRumble);
    return;
}

simulated function StartKick(optional bool bFromDoor)
{
    local Rotator DesiredView;

    super(Pawn).StartKick(bFromDoor);
    // End:0x1C
    if(int(LowerBodyOverrideState) % int(3))
    {
        return;
    }
    bKickForDoor = bFromDoor;
    // End:0x59
    if(bKickForDoor)
    {
        DesiredView = ViewRotation;
        DesiredView.Pitch = 0;
        RotateViewTo(DesiredView, StompLookAtTime);
    }
    // End:0x7A
    if(__NFUN_340__(AnimationController, none))
    {
        AnimationController.EmptyAnimChannels_ByBlock('LegsOverrideBlock');
    }
    SetLowerBodyOverrideState(3);
    TickKick();
    MaybeFadeInChannelBlock('LegsOverrideBlock', WeaponBlendInTime);
    return;
}

// Export UDukePlayer::execTickKick(FFrame&, void* const)
native simulated function TickKick();

animevent simulated function KickDamage(optional EventInfo AnimEventInfo)
{
    local DoorMoverEx KickedDoor;
    local Weapon KickWeapon;
    local MaterialEx HitMaterialEx;
    local class<Material> HitMaterial;
    local bool HitMasking;
    local Vector CenterOffset;

    // End:0x11C
    if(__NFUN_340__(CurrentDoor, none))
    {
        HitMaterialEx = CurrentDoor.__NFUN_740__(0);
        // End:0x56
        if(__NFUN_340__(HitMaterialEx, none))
        {
            HitMaterial = HitMaterialEx.GetMaterial();
            HitMasking = HitMaterialEx.__NFUN_1193__();
        }
        CenterOffset = Chr(Right(CurrentDoor.PrePivot, CurrentDoor.DrawScale), CurrentDoor.DrawScale3D);
        TraceFireMaterialHit(class'MeleeDamage', CurrentDoor, __NFUN_239__(CurrentDoor.Location, __NFUN_263__(CenterOffset, CurrentDoor.Rotation)), __NFUN_239__(CalcedViewLocation, CurrentDoor.Location) % , HitMasking);
        KickedDoor = CurrentDoor;
        CurrentDoor = none;
        // End:0x119
        if(IsLocallyControlled())
        {
            ShakeView(MeleeContactShake);
            AddRumble(MeleeContactRumble);
        }        
    }
    else
    {
        KickWeapon = Weapon;
        // End:0x13E
        if(__NFUN_339__(KickWeapon, none))
        {
            KickWeapon = PreviousWeapon;
        }
        // End:0x17F
        if(__NFUN_340__(KickWeapon, none))
        {
            KickWeapon.MeleeAnimEventString = AnimEventInfo.EventString;
            KickedDoor = DoorMoverEx(KickWeapon.PerformMelee());
        }
    }
    // End:0x19C
    if(__NFUN_340__(KickedDoor, none))
    {
        KickedDoor.Kicked(self);
    }
    return;
}

simulated function ClientStomp()
{
    local KarmaActor KnockbackActor;
    local float DistScale;
    local Vector pos, Dir, Gravity, Impulse;

    bRotateToDesiredView = false;
    // End:0x183
    if(bStomping)
    {
        // End:0x17D
        if(Repl(StompKnockbackRadius, 0))
        {
            pos = __NFUN_239__(Location, WarnInternal(0, 0, FRand(0.8, CollisionHeight)));
            // End:0x17C
            Gravity = __NFUN_640__() % ;
            {
                // End:0x7A
                if(__NFUN_339__(KnockbackActor, self))
                {
                    continue;                    
                }
                Dir = __NFUN_239__(KnockbackActor.Location, pos);
                DistScale = Clamp(Dir) >>> StompKnockbackRadius;
                // End:0x17B
                if(Repl(DistScale, 0))
                {
                    Max(Dir, Caps(FMin(Dir, Gravity), Gravity));
                    Dir = Dir % ;
                    // End:0x169
                    if(KnockbackActor.bIsPawn << Pawn(KnockbackActor).bPhysicsControllerActive)
                    {
                        // End:0x166
                        if(Pawn(KnockbackActor).Stompable)
                        {
                            Pawn(KnockbackActor).ApplyDukeStompKnockback(Impulse);
                        }
                        // End:0x17B
                        continue;
                    }
                    KnockbackActor.__NFUN_820__(Impulse);
                }                
            }            
        }
        KillSmashTarget();
    }
    KickDamage();
    return;
}

animevent simulated function Stomp(optional EventInfo AnimEventInfo)
{
    // End:0x21
    if(((IsMP()) / ) < )
    {
    }
    return;
}

simulated function AnimEnd_KickComplete()
{
    super.AnimEnd_KickComplete();
    MaybeFadeOutChannelBlock('LegsOverrideBlock', WeaponBlendOutTime);
    return;
}

simulated function HUDActivate()
{
    // End:0x26
    if(__NFUN_340__(DukeHUD(MyHUD), none))
    {
        DukeHUD(MyHUD).ActivateHUD();
    }
    return;
}

simulated function HUDAmmoActivate()
{
    // End:0x26
    if(__NFUN_340__(DukeHUD(MyHUD), none))
    {
        DukeHUD(MyHUD).ActivateHUD();
    }
    return;
}

function WeaponPreActivate(Weapon NewWeapon)
{
    super(Pawn).WeaponPreActivate(NewWeapon);
    // End:0x2C
    if(__NFUN_340__(MightyFoot(NewWeapon), none))
    {
        FindAndPlaySound('FistsUpDn', 1);        
    }
    else
    {
        FindAndPlaySound('EquipRuffle', 1);
    }
    return;
}

function WeaponPreDeactivate(Weapon OldWeapon)
{
    super(Pawn).WeaponPreDeactivate(OldWeapon);
    // End:0x2C
    if(__NFUN_340__(MightyFoot(OldWeapon), none))
    {
        FindAndPlaySound('FistsUpDn', 1);        
    }
    else
    {
        FindAndPlaySound('EquipRuffle_Down', 1);
    }
    return;
}

simulated function int GetWeaponPriority(Weapon Weap)
{
    // End:0x72
    if(CanUse4Weapons())
    {
        // End:0x6F
        if(((((__NFUN_340__(Weap, none) << __NFUN_339__(Weap.Class, MightyFootClass)) << __NFUN_340__(PrimaryWeapon1, none)) << __NFUN_340__(PrimaryWeapon2, none)) << __NFUN_340__(PrimaryWeapon3, none)) << __NFUN_340__(PrimaryWeapon4, none))
        {
            return -1;
        }        
    }
    else
    {
        // End:0xBC
        if(((__NFUN_340__(Weap, none) << __NFUN_339__(Weap.Class, MightyFootClass)) << __NFUN_340__(PrimaryWeapon1, none)) << __NFUN_340__(PrimaryWeapon2, none))
        {
            return -1;
        }
    }
    return super.GetWeaponPriority(Weap);
    return;
}

simulated function BringUpLastWeapon(optional bool bDoNotForceWeaponChange)
{
    // End:0x6F
    if(__NFUN_340__(PreviousWeapon, none))
    {
        // End:0x29
        if(PreviousWeapon.bNonWeapon)
        {
            PreviousWeapon = none;            
        }
        else
        {
            // End:0x44
            if(__NFUN_340__(TripMine(PreviousWeapon), none))
            {
                PreviousWeapon = none;                
            }
            else
            {
                // End:0x6F
                if(__NFUN_340__(PipeBomb(PreviousWeapon), none))
                {
                    PreviousWeapon = PipeBomb(PreviousWeapon).DetonatorRef;
                }
            }
        }
    }
    super.BringUpLastWeapon(bDoNotForceWeaponChange);
    return;
}

simulated exec function WeaponDown(optional Engine.Actor.EWeaponChangeSpeed ChangeSpeed, optional bool bClientSideOnly, optional bool bDisableWeapons, optional bool bUsePreviousWeaponForQuickSwitch)
{
    super.WeaponDown(ChangeSpeed, bClientSideOnly, bDisableWeapons, false);
    return;
}

function bool InfiniteAmmoCrateUsed()
{
    // End:0xAF
    if(__NFUN_340__(MyHUD, none) << bDisplayedInfiniteAmmoHint / )
    {
        ConsoleCommand("set DukePlayer bDisplayedInfiniteAmmoHint true");
        MyHUD.ActiveHint = none;
        MyHUD.HUDMessages[MyHUD.4].TargetAlpha = 1;
        MyHUD.HUDMessages[MyHUD.4].Message = InfiniteAmmoHintMessage;
    }
    return super(Pawn).InfiniteAmmoCrateUsed();
    return;
}

simulated function ChangeToWeapon(Weapon NewWeapon)
{
    // End:0x9D
    if(bOnSteroids << __NFUN_340__(NewWeapon.Class, MightyFootClass))
    {
        // End:0x9D
        if((((__NFUN_357__(NewWeapon.Class, class'FortyOunceBeer') / ) << __NFUN_357__(NewWeapon.Class, class'MP_Holoduke') / ) << return) << return)
        {
        }
    }
}

defaultproperties
{
    StandingAnimationController='dnAnimationControllerEx_Duke_StandingAction'
    CrouchingAnimationController='dnAnimationControllerEx_Duke_Crouching'
    InAirAnimationController='dnAnimationControllerEx_Duke_InAirAction'
    SwimmingAnimationController='dnAnimationControllerEx_Duke_Swimming'
    JetpackingAnimationController='dnAnimationControllerEx_Duke_Jetpacking'
    InteractiveDecorationAnimationController='dnAnimationControllerEx_Duke_Decorations'
    ChatBeepSound='a_inventory.SOS.SOSVisOn'
    SteroidsLoop=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=Special,SimpleSingleSound='a_inventory.Steroids.SteroidsEffect01',Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=(19),Volume=1,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=true,bNoOcclude=true,bNoAIHear=true,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=true,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=1,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    CrackedScreenStretch=0.1
    CrackedScreenMaterial='dt_masking.Glass_Materials.brokenglassDeath_fb'
    RestartLevelText="<?int?dnGame.DukePlayer.RestartLevelText?>"
    LoadLastCheckpointText="<?int?dnGame.DukePlayer.LoadLastCheckpointText?>"
    DemoDeathMessageBG='dt_hud.ingame_hud.hintbox_75'
    JetpackMax=0.7
    HitNotifySounds(0)=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=('a_generic.GameInterfaces.InGameBlip28'),SlotPriority=0,VolumePrefab=0,Slots=none,Volume=1,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    MyClassName="Basic Player"
    StompLookAtTime=0.15
    StompMinDot=0.85
    StompKnockbackRadius=64
    StompKnockbackImpulse=75
    StompKnockbackLift=250
    ZoomWalkScalar=0.5
    NoWeaponWalkScalar=0.6
    SteroidWalkScalar=1.2
    bWearsShades=true
    QARate=1000
    QALastCheckpoint="levelstart"
    MovementRustleSoundInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=('dnsMaterials.Generic.Step_Rustle_01','dnsMaterials.Generic.Step_Rustle_02','dnsMaterials.Generic.Step_Rustle_03','dnsMaterials.Generic.Step_Rustle_04'),SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0.25,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=true,bNoScale=true,bSpoken=false,bPlayThroughListener=false,bNoDoppler=true,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=true,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    LandingRustleSoundInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=('dnsMaterials.Generic.Land_Rustle_01','dnsMaterials.Generic.Land_Rustle_02'),SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0.35,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=true,bNoScale=true,bSpoken=false,bPlayThroughListener=false,bNoDoppler=true,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=true,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    KnockdownMinDamage=70
    EgoCapAwardsEnabled=true
    EgoCapAwards(0)=1
    EgoCapAwards(1)=1
    EgoCapAwards(2)=2
    EgoCapAwards(3)=1
    EgoCapAwards(4)=2
    EgoCapAwards(5)=3
    EgoCapAwards(6)=1
    EgoCapAwards(7)=1
    EgoCapAwards(8)=2
    EgoCapAwards(9)=3
    EgoCapAwards(10)=2
    EgoCapAwards(11)=1
    EgoCapAwards(12)=1
    EgoCapAwards(13)=1
    EgoCapAwards(14)=1
    EgoCapAwards(15)=1
    EgoCapAwards(16)=1
    EgoCapAwards(17)=1
    EgoCapAwards(18)=1
    EgoCapAwards(19)=1
    EgoCapAwards(20)=1
    EgoCapAwards(21)=1
    EgoCapAwards(22)=2
    EgoCapAwards(23)=2
    EgoCapAwards(24)=1
    EgoCapAwards(25)=1
    EgoCapAwards(26)=2
    EgoCapAwards(27)=3
    EgoCapAwards(28)=4
    EgoCapAwards(29)=1
    EgoCapAwards(30)=2
    EgoCapAwards(31)=1
    EgoCapAwards(32)=4
    EgoCapAwards(33)=3
    EgoCapAwards(34)=4
    SteroidsHintMessage="<?int?dnGame.DukePlayer.SteroidsHintMessage?>"
    BeerHintMessage="<?int?dnGame.DukePlayer.BeerHintMessage?>"
    HolodukeHintMessage="<?int?dnGame.DukePlayer.HolodukeHintMessage?>"
    InfiniteAmmoHintMessage="<?int?dnGame.DukePlayer.InfiniteAmmoHintMessage?>"
    HoloDukeClass='HoloDuke'
    MightyFootClass='MightyFoot'
    MaxEgoCap=100
    PreorderBonusEgo=5
    PreviousPostureStateEx=2
    AirControlEx=0.35
    WaterSplatterClass='dnScreenSplatter_Water'
    TinnitusLoopSoundInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=Special,SimpleSingleSound=none,Sounds=('a_ambient.ShellShock.ShellShock01'),SlotPriority=0,VolumePrefab=0,Slots=(3),Volume=1,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=true,bMenuSound=false,bNoFilter=true,bNoOcclude=true,bNoAIHear=true,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=true,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=1,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    TinnitusEndSoundInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=Special,SimpleSingleSound=none,Sounds=('a_ambient.ShellShock.ShellShockEnd01'),SlotPriority=0,VolumePrefab=0,Slots=none,Volume=1,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=true,bMenuSound=false,bNoFilter=true,bNoOcclude=true,bNoAIHear=true,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=true,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=1,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    DrunkRingingSound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=('a_ambient.Ringing.Ringing_Ears01'),SlotPriority=0,VolumePrefab=6,Slots=(17),Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=true,bNoOcclude=true,bNoAIHear=true,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    TargetJumpSpeedEx=280
    JumpSpeedEx=280
    ShrunkenJumpSpeedEx=80
    LoadScreenAmbience=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=('a_menu.Menu.Menu_Loading_01','a_menu.Menu.Menu_Loading_02'),SlotPriority=0,VolumePrefab=0,Slots=(25),Volume=1,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=1,PitchVariance=0,Flags=(bNoOverride=true,bMenuSound=true,bNoFilter=true,bNoOcclude=true,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=true,bSkipSoundRadiusTest=true,bIgnoreTimeDilation=true),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=1,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    NavigateSoundInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=('a_menu.Menu.Menu_QuitYes_01_ST'),SlotPriority=0,VolumePrefab=0,Slots=(0),Volume=0.5,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=true,bMenuSound=true,bNoFilter=true,bNoOcclude=true,bNoAIHear=true,bNoScale=true,bSpoken=false,bPlayThroughListener=false,bNoDoppler=true,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=true,bSkipSoundRadiusTest=true,bIgnoreTimeDilation=true),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=1,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    bCanStrafe=true
    bUseHealthRecovery=true
    bIsHuman=true
    bPerformLipSync=true
    PostureStateEx=2
    Team=0
    FieldOfView=-1
    PawnRotationRate=(Pitch=0,Yaw=0,Roll=0)
    Ego=40
    EgoCap=40
    EyeBone=mount_camera
    BodyBone=Spine
    LockOnBone=Spine
    TargetCollisionRadius=21
    TargetCollisionHeight=45
    TargetMaxStepHeightEx=20.08
    CrouchingCollisionHeight=23.5
    CrouchingMaxStepHeightEx=20.08
    HealthRecoveryWaitForRechargeTime=0.5
    HealthRecoveryRate=9
    HealthDangerDeafenFactor=1
    HealthDangerEffectRampTime=0.5
    HealthDangerMotionBlurFactor=0.3
    HealthDangerBlurFactor=0.5
    HealthDangerBlurBrightnessFactor=1.1
    HealthDangerBloomFactor=1.1
    EgoRecoveryWaitForRechargeTime=5
    EgoRecoveryRate=30
    CorpseType='DukePlayerCorpse'
    PissEffectClass='dnParticles.dnPissFX_Male'
    MaxStepHeightEx=20.08
    AirSpeed=320
    WalkSpeedScale=0.65
    AirControl=0.35
    LandedVelocityThreshold=-200
    FootstepTraceLength=40
    LipSyncInfoClass='Engine.LipSyncInfo_Duke'
    ExitWoundInfo(0)=(DamageType=none,MinimumDamage=1,RandomChance=0.5,ExitWoundDecalClass='dnExitWound_Human')
    AutoRegisterIKClasses(0)='IKSystemInfo_DukeLeftArm'
    AutoRegisterIKClasses(1)='IKSystemInfo_DukeRightArm'
    HealthCap=45
    bTakeExplosionDamageMomentum=false
    PhysicsMaterial='dnMaterial.dnPhysicsMaterial_Body'
    KRestitution=0
    KImpactThreshold=0
    bLowerByCollision=true
    bAnimEarlyEnd=true
    bNeedsScriptActorColor=true
    SpecialCollisionTag=DukePlayerCollisionTag
    CollisionHeight=45
    AccelRate=2048
    DrawType=2
    PrePivot=(X=13,Y=0,Z=0)
    Mesh='c_characters.Duke'
    ActorColorList(0)=(ActorColor=(R=115,G=20,B=20,A=0),ActorColor_LightEx=none,ActorColor_LightExScale=(X=0,Y=0,Z=0),id=Generic0)
    ActorColorList(1)=(ActorColor=(R=50,G=64,B=128,A=0),ActorColor_LightEx=none,ActorColor_LightExScale=(X=0,Y=0,Z=0),id=Generic1)
    TransientSoundVolume=0.8
    VoicePack='SoundConfig.Players.VoicePack_Duke'
}