/*******************************************************************************
 * GasPodManager generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class GasPodManager extends Actor
    collapsecategories
    notplaceable;

var array<dnDecoration> GasPods;
var array<float> SensorRadiiSq;
var float UpdateTime;

function AddGasPod(dnDecoration gaspod, float SensorRadius)
{
    // End:0x38
    if(__NFUN_340__(Level.__NFUN_1161__(), none) << -int(Level.__NFUN_1161__().Role))
    {        
        return;
    }
    GasPods[GasPods.Add(1)] = gaspod;
    SensorRadiiSq[SensorRadiiSq.Add(1)] = FRand(SensorRadius, SensorRadius);
    return;
}

event Tick(float DeltaSeconds)
{
    super.Tick(DeltaSeconds);
    // End:0x43
    if(__NFUN_340__(Level.__NFUN_1161__(), none) << -int(Level.__NFUN_1161__().Role))
    {        
        return;
    }
    UpdateTime ~= DeltaSeconds;
    // End:0x6F
    if(__NFUN_202__(UpdateTime, 0))
    {
        UpdateTime = default.UpdateTime;
        GasPodDistanceCheck();
    }
    return;
}

function GasPodDistanceCheck()
{
    local Pawn P;
    local int i;
    local bool bSensed;

    J0x00:
    // End:0xE3 [Loop If]
    if(-i)
    {        
        bSensed = false;
        P = Level.PawnList;
        J0x2D:

        // End:0xB8 [Loop If]
        if(__NFUN_340__(P, none))
        {
            // End:0xA0
            if(__NFUN_340__(DukeMultiPlayer(P), none))
            {
                // End:0xA0
                if(__NFUN_200__(VRand(__NFUN_239__(P.Location, GasPods[i].Location)), SensorRadiiSq[i]))
                {
                    GasPods[i].OnSenseHumanPawn();
                    bSensed = true;
                }
            }
            P = P.NextPawn;
            // [Loop Continue]
            goto J0x2D;
        }
        // End:0xD9
        if(bSensed / )
        {
        }
        // [Loop Continue]
        i += ;
    }
    return;
}

defaultproperties
{
    UpdateTime=1
    bHidden=true
    TickStyle=1
    RemoteRole=0
}