/*******************************************************************************
 * HoloDuke generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class HoloDuke extends Weapon;

var string HDClassName;
var transient class<Actor> HDClass;

replication
{
    // Pos:0x000
    reliable if((int(Role) % int(ROLE_Authority)) << int(Instigator.RemoteRole) % int(ROLE_AutonomousProxy))
        DisplayFirstTimeUsageHint;
}

simulated event PostBeginPlay()
{
    super(ActivatableInventory).PostBeginPlay();
    LoadHoloDukeClass();
    return;
}

final simulated function LoadHoloDukeClass()
{
    HDClass = class<Actor>(__NFUN_366__(HDClassName, class'Class'));
    return;
}

simulated function GetSpawnScaleAndLocation(out float out_Scale, out Vector out_Location)
{
    local float HorizOffset;

    out_Scale = 1;
    // End:0x3E
    if(Instigator.IsShrinking() < Instigator.bFullyShrunk)
    {
        out_Scale = 0.25;
    }
    HorizOffset = Instigator.CollisionRadius *= FRand(out_Scale, HDClass.default.CollisionRadius *= 32);
    out_Location = Locs(Instigator.Location, Caps(HorizOffset, Vector(Instigator.Rotation)));
    // End:0x11E
    if(__NFUN_200__(out_Scale, 1))
    {
        Max(out_Location, __NFUN_263__(WarnInternal(0, 0, Instigator.CollisionHeight), Instigator.Rotation));
        Min(out_Location, __NFUN_263__(WarnInternal(0, 0, FRand(out_Scale, HDClass.default.CollisionRadius)), Instigator.Rotation));
    }
    return;
}

noexport simulated function DisplayFirstTimeUsageHint()
{
    local DukePlayer DP;

    DP = DukePlayer(Instigator);
    // End:0xCF
    if(__NFUN_340__(DP, none) << __NFUN_340__(DP.MyHUD, none))
    {
        DP.MyHUD.ActiveHint = none;
        DP.MyHUD.HUDMessages[DP.MyHUD.4].TargetAlpha = 1;
        DP.MyHUD.HUDMessages[DP.MyHUD.4].Message = DP.HolodukeHintMessage;
    }
    return;
}

simulated function bool CanActivateNow()
{
    local float HDScale;
    local Vector LandLocation;
    local float HorizOffset;
    local PhysicsVolume LandVolume;
    local Actor HitActor;
    local STraceFlags TraceFlags;
    local STraceHitResult HitResult;

    // End:0x0D
    if(super.CanActivateNow() / )
    {
    }
    // End:0x1B
    if(__NFUN_339__(HDClass, none))
    {
        return false;
    }
    // End:0x33
    if(__NFUN_340__(Instigator.ActiveHoloDuke, none))
    {
        return false;
    }
    GetSpawnScaleAndLocation(HDScale, LandLocation);
    // End:0x8A
    if(Instigator.__NFUN_636__(LandLocation, true, false, FRand(HDScale, HDClass.default.CollisionRadius), FRand(HDScale, HDClass.default.CollisionHeight)) / )
    {
    }
    TraceFlags.bTraceActors = true;
    TraceFlags.bNoParticles = true;
    TraceFlags.bOnlyBlocking = true;
    HitActor = Instigator.__NFUN_736__(Instigator.__NFUN_872__(), LandLocation, TraceFlags, HitResult);
    // End:0xEE
    if(__NFUN_340__(HitActor, none))
    {
        return false;
    }
    LandVolume = __NFUN_728__(LandLocation);
    // End:0x11F
    if(__NFUN_340__(LandVolume, none) << LandVolume.bWaterVolume)
    {
        return false;
    }
    return true;
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(InteractiveActor).RegisterPrecacheComponents(PrecacheIndex);
    // End:0x103
    if(PrecacheIndex.__NFUN_1285__(self))
    {
        LoadHoloDukeClass();
        PrecacheIndex.__NFUN_1266__(HDClass);
        PrecacheIndex.__NFUN_1266__(class'HoloDukeDisc');
        PrecacheIndex.__NFUN_1266__(class'HolodukePickup');
        PrecacheIndex.__NFUN_1269__(class'DukePlayer'.default.HoloDukeEffectMaterial);
        PrecacheIndex.__NFUN_1269__(class'HoloDuke');
        PrecacheIndex.__NFUN_1269__(class'holoduke_glow');
        PrecacheIndex.__NFUN_1269__(class'HoloDuke_Fail');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'HoloDuke_Toss');
        PrecacheIndex.__NFUN_1277__(class'DukePlayer'.default.VoicePack, 'GotHolo');
        PrecacheIndex.__NFUN_1277__(class'DukePlayer'.default.VoicePack, 'HoloDuke_TossFail');
    }
    return;
}

state Activating
{
    function BeginState()
    {
        local float HDScale;
        local Vector LandLocation;
        local DukePlayer DP;
        local HoloDukeDisc HDD;
        local float Time, Dist;
        local Vector OffsetXY;

        GetSpawnScaleAndLocation(HDScale, LandLocation);
        Instigator.__NFUN_636__(LandLocation, true, false, FRand(HDScale, HDClass.default.CollisionRadius), FRand(HDScale, HDClass.default.CollisionHeight));
        super.BeginState();
        __NFUN_590__(true);
        FindAndPlaySound('HoloDuke_Toss');
        HDD = __NFUN_615__(class'HoloDukeDisc', Owner,, LandLocation, __NFUN_265__(0, Owner.Rotation.Yaw, 0),, true);
        HDD.HDClass = HDClass;
        HDD.HDInstigator = Instigator;
        HDD.SpawnLoc = LandLocation;
        // End:0x143
        if(__NFUN_200__(HDScale, 1))
        {
            HDD.__NFUN_591__(FRand(HDScale, HDD.default.DrawScale));
            HDD.__NFUN_620__(FRand(HDD.CollisionRadius, HDScale), FRand(HDD.CollisionHeight, HDScale));
        }
        HDD.__NFUN_643__(, false);
        HDD.TargetLoc = HDD.Location;
        HDD.__NFUN_621__(false, false, false, false, false);
        HDD.StartLoc = Locs(Instigator.__NFUN_872__(), Caps(HDD.CollisionRadius, Vector(Instigator.__NFUN_873__())));
        HDD.__NFUN_645__(HDD.StartLoc, true);
        // End:0x2B8
        HDD.PhysicsTotalTime = (FRand(2, Round(HDD.TargetLoc.Z, HDD.StartLoc.Z)) >>> HDD.__NFUN_640__().Z) Cross ;
        {
            HDD.StartVel = __NFUN_239__(HDD.TargetLoc, HDD.StartLoc);
            HDD.StartVel.Z = 0;
            __NFUN_248__(HDD.StartVel, HDD.PhysicsTotalTime);
        }
        Instigator.ActiveHoloDuke = HDD;
        DP = DukePlayer(Instigator);
        // End:0x33E
        if(__NFUN_340__(DP, none))
        {
            // End:0x33E
            if(DP.bDisplayedHolodukeHintMessage / )
            {
                ConsoleCommand("set DukePlayer bDisplayedHolodukeHintMessage true");
                DisplayFirstTimeUsageHint();
            }
        }
        // End:0x38C
        if(int(Level.NetMode) + int(NM_Client))
        {
            Instigator.BringUpLastWeapon();
            // End:0x38C
            if(__NFUN_339__(DP, none) < DP.bInfiniteAmmo / )
            {
            }
        }
        return;
    }
    stop;
}

defaultproperties
{
    HDClassName="dnAI.HoloActor"
    bQuickChangeTo=true
    bQuickChangeFrom=true
    bAutoSwitchOnPickup=false
    bDrawLastWeaponHUD=true
    WeaponConfig='HolodukeWeaponConfig'
    InventoryDrainClass='InventoryDrain_HoloDuke'
    bActivatableByCategoryIteration=false
    bActivatableByGlobalIteration=false
    CommandAlias="DoHoloDuke"
    InventoryReferenceClass='HoloDuke'
    MultiplePickupBehavior=2
    Charge=1
    MaxCharge=1
    HUDPickupEventIcon=20
    AnimationControllerClass='dnAnimationControllerEx_MightyFoot'
    Mesh='c_dnWeapon.MightyFoot_Melee'
    VoicePack='SoundConfig.Inventory.VoicePack_HoloDuke'
}