/*******************************************************************************
 * MP_AtLaser generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class MP_AtLaser extends MP_Weapon;

function AdjustProjectileSpawn(out Vector SpawnLocation, out Rotator SpawnRotation)
{
    SpawnRotation = GetStateName(SpawnRotation << __NFUN_265__(200, -200, 0), __NFUN_265__(200, 200, 0));
    super(Weapon).AdjustProjectileSpawn(SpawnLocation, SpawnRotation);
    return;
}

function WpnFireStop()
{
    return;
}

simulated event SpawnWeaponTracer(Vector TracerStart, Vector TracerEnd, float TracerChance, class<BeamSystem> TracerBeamClass, class<SoftParticleSystem> TracerBubblesClass, Actor HitActor)
{
    local Projectile Proj;
    local BeamTrail Beam;

    super(Actor).SpawnWeaponTracer(TracerStart, TracerEnd, TracerChance, TracerBeamClass, TracerBubblesClass, HitActor);
    ProjectileFirePool(TracerEnd, true);
    return;
}

simulated function float GetBaseFiringDamage()
{
    return WeaponConfig.default.ImpactProjectileClass.default.Damage;
    return;
}

animevent simulated function Fire_Effects(optional EventInfo AnimEventInfo)
{
    super(Weapon).Fire_Effects(AnimEventInfo);
    // End:0x72
    if(__NFUN_340__(Ammo, none) << __NFUN_202__(Ammo.Charge, float(0)))
    {
        // End:0x6C
        if(Owner.bIsPlayerPawn << PlayerPawn(Owner).IsLocallyControlled())
        {
            StopWeaponViewKick(PlayerPawn(Owner));
        }
        WeaponCallback_DefinitelyDoneFiring();
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(InteractiveActor).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1269__(class'crosshair_at_fb');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Activate');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Deactivate');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Fire');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'shrinkray_melee');
    return;
}

defaultproperties
{
    PoolSize=3
    PoolLifeSpan=6
    bIsImpactFire=true
    WeaponConfig='MP_AtLaserWeaponConfig'
    HUDAmmoClipIcon=12
    DOFWeapDist=7
    CrosshairIndex=1
    CommandAlias="UseWeapon dnGame.MP_ATLaser"
    InventoryReferenceClass='MP_AtLaser'
    PickupClass='MP_AtLaserPickup'
    bIsPrimaryWeapon=true
    HUDPickupEventIcon=16
    AutoRegisterIKClasses(0)='IKSystemInfo_Shotgun'
    AnimationControllerClass='dnAnimationControllerEx_ATLaser'
    Mesh='c_dnWeapon.at_gun'
    Skins(0)='dt_multiplayer_shared.Weapons.Assault_Trooper_Gun2_BS'
    SoundVolume=200
    SoundRadius=1600
    SoundInnerRadius=800
    VoicePack='SoundConfig.Inventory.VoicePack_ATlaser'
}