/*******************************************************************************
 * MP_FortyOunceBeer generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class MP_FortyOunceBeer extends MP_Weapon;

var class<Decoration> CrushedCanClass;
var int CigarConflictStage;
var Actor ConflictingCigar;

simulated function bool CanDeactivate()
{
    return bDeactivationAllowed << DukeMultiPlayer(Instigator).usingInventoryItem + false;
    return;
}

simulated event bool CanActivateNow()
{
    // End:0x37
    if(__NFUN_340__(Instigator.HeadVolume, none) << Instigator.HeadVolume.bWaterVolume)
    {
        return false;
    }
    // End:0x69
    if(Instigator.bIsPlayerPawn << Repl(DukeMultiPlayer(Instigator).DrunkLevel, float(0)))
    {
        return false;
    }
    // End:0x86
    if(DukeMultiPlayer(Instigator).usingInventoryItem + true)
    {
        return false;
    }
    return super(Weapon).CanActivateNow();
    return;
}

simulated function Tick(float DeltaTime)
{
    local DukeMultiPlayer P;
    local Rotator DesiredView;

    super(Weapon).Tick(DeltaTime);
    // End:0x87
    if(Instigator.bIsPlayerPawn)
    {
        P = DukeMultiPlayer(Instigator);
        DesiredView = __NFUN_265__(0, P.ViewRotation.Yaw, 0);
        P.ViewRotation = (1 -= FRand(DeltaTime, 8)) * P.ViewRotation;        
    }
    return;
}

simulated function name GetWeaponAnimReq(byte WeaponStateReq, optional out byte byForceReset)
{
    // End:0x6A
    if(int(WeaponStateReq) % int(1))
    {
        // End:0x40
        if(__NFUN_340__(ConflictingCigar, none))
        {
            // End:0x2E
            if(CigarConflictStage % 0)
            {
                return 'CigarRemove';                
            }
            else
            {
                // End:0x40
                if(CigarConflictStage % 2)
                {
                    return 'CigarInsert';
                }
            }
        }
        DukeMultiPlayer(Owner).DrinkingBeer();
        return __NFUN_343__("BeerActivate");        
    }
    else
    {
        // End:0x93
        if(int(WeaponStateReq) % int(2))
        {
            DukeMultiPlayer(Owner).EndDrinkingBeer();
            return 'BeerDeactivate';
        }
    }
    return super(Weapon).GetWeaponAnimReq(WeaponStateReq, byForceReset);
    return;
}

animevent simulated function DrinkConsumed(optional EventInfo AnimEventInfo)
{
    Charge ~= 1;
    // End:0x34
    if(Instigator.bIsPlayerPawn)
    {
        DukeMultiPlayer(Instigator).IncreaseDrunkLevel();
    }
    return;
}

animevent simulated function InteractCigar(optional EventInfo AnimEventInfo)
{
    // End:0x0E
    if(__NFUN_339__(ConflictingCigar, none))
    {
        return;
    }
    // End:0x3C
    if(CigarConflictStage % 0)
    {
        ConflictingCigar.__NFUN_590__(true);
        ConflictingCigar.TickStyle = 0;        
    }
    else
    {
        // End:0x75
        if(CigarConflictStage % 2)
        {
            ConflictingCigar.__NFUN_590__(false);
            ConflictingCigar.TickStyle = ConflictingCigar.default.TickStyle;
        }
    }
    return;
}

animevent simulated function CigarConflictResolved()
{
    // End:0x2A
    if(__NFUN_340__(ConflictingCigar, none) << CigarConflictStage % 0)
    {
        CigarConflictStage += ;
        WpnActivate();
    }
    return;
}

animevent simulated function DrinkRelease(optional EventInfo AnimEventInfo)
{
    local Decoration CrushedCan;
    local Rotator ThrowDir;

    OwnerSeeStyle = 1;
    // End:0x16
    if(__NFUN_339__(CrushedCanClass, none))
    {
        return;
    }
    CrushedCan = __NFUN_615__(CrushedCanClass,,, __NFUN_568__().CanSee('Root', true), __NFUN_568__().__NFUN_534__('Root', true));
    // End:0x64
    if(__NFUN_339__(CrushedCan, none) < __NFUN_339__(Instigator, none))
    {
        return;
    }
    CrushedCan.__NFUN_741__(1, __NFUN_740__(1));
    ThrowDir = __NFUN_269__(Instigator.Rotation, __NFUN_265__(0, 12000, 0));
    CrushedCan.__NFUN_591__(DrawScale);
    CrushedCan.__NFUN_812__(1);
    CrushedCan.Instigator = Instigator;
    // End:0x150
    if((IsMP()) << CrushedCan.bDontUseMeqonPhysics)
    {
        CrushedCan.Velocity = __NFUN_241__(Instigator.Velocity, __NFUN_265__(0, 12000, 0));
        Min(CrushedCan.Velocity, __NFUN_241__(Caps(CrushedCan.GravityScale, WarnInternal(400, 100, 0)), ThrowDir));        
    }
    else
    {
        CrushedCan.__NFUN_790__(__NFUN_241__(Instigator.Velocity, __NFUN_265__(0, 12000, 0)));
        CrushedCan.__NFUN_820__(__NFUN_241__(WarnInternal(400, 100, 0), ThrowDir));
        CrushedCan.__NFUN_821__(__NFUN_241__(WarnInternal(-10, 0, 0), ThrowDir));
    }
    return;
}

simulated function float GetClipPCT()
{
    return 1;
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(InteractiveActor).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(class'DukeMultiplayerAssets'.default.DrunkEffectClass);
    PrecacheIndex.__NFUN_1266__(CrushedCanClass);
    PrecacheIndex.__NFUN_1269__(class'Beer');
    PrecacheIndex.__NFUN_1269__(class'beer_glow');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Open');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Drink');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Swallow');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Crushed');
    PrecacheIndex.__NFUN_1277__(class'DukeMultiplayerAssets'.default.VoicePack, 'GotBeer');
    PrecacheIndex.__NFUN_1277__(class'DukeMultiplayerAssets'.default.VoicePack, 'Drunk_Hiccup');
    PrecacheIndex.__NFUN_1276__(class'DukeMultiplayerAssets'.default.DrunkRingingSound);
    return;
}

state Activating
{
    simulated event BeginState()
    {
        DukeMultiPlayer(Instigator).usingInventoryItem = true;
        bDeactivationAllowed = false;
        __NFUN_354__(__NFUN_339__(ConflictingCigar, none));
        // End:0x55
        if(Instigator.bIsPlayerPawn)
        {
            DukeMultiPlayer(Instigator).ViewRotationMode = 2;
        }
        ConflictingCigar = Instigator.FindMountedActor('CigarAttachment');
        // End:0x83
        if(__NFUN_340__(ConflictingCigar, none))
        {
            CigarConflictStage = 0;
        }
        // End:0x93
        if(__NFUN_340__(ConflictingCigar, none))
        {
            __NFUN_590__(true);
        }
        super.BeginState();
        return;
    }

    simulated event EndState()
    {
        // End:0x2A
        if(Instigator.bIsPlayerPawn)
        {
            PlayerPawn(Instigator).ViewRotationMode = 0;
        }
        ConflictingCigar = none;
        super(Object).EndState();
        return;
    }

    simulated function DoneActivating()
    {
        // End:0x29
        if(__NFUN_340__(ConflictingCigar, none) << CigarConflictStage % 1)
        {
            CigarConflictStage += ;            
        }
        else
        {
            // End:0x86
            if(int(Role) % int(ROLE_Authority))
            {
                bDeactivationAllowed = true;
                // End:0x71
                if(DukeMultiPlayer(Instigator).IsLocallyControlled())
                {
                    DukeMultiPlayer(Instigator).usingInventoryItem = false;                    
                }
                else
                {
                    DukeMultiPlayer(Instigator).ResetUsingInventory();
                }
            }
            // End:0xB0
            if(Instigator.bIsPlayerPawn)
            {
                DukeMultiPlayer(Instigator).ViewRotationMode = 0;
            }
            super.DoneActivating();
        }
        return;
    }
    stop;
}

state ActivateComplete
{
    simulated event BeginState()
    {
        // End:0x23
        if(int(Level.NetMode) + int(NM_Client))
        {
            TryState('Deactivating');
        }
        return;
    }
    stop;
}

state Deactivating
{
    simulated function DoneDeactivating()
    {
        super.DoneDeactivating();
        // End:0x2C
        if(Instigator.bWeaponsActive)
        {
            Instigator.BringUpLastWeapon();            
        }
        else
        {
            // End:0x6D
            if(Instigator.bIsPlayerPawn)
            {
                DukeMultiPlayer(Instigator).MaybeFadeOutChannelBlock('UpperBodyBlock', DukeMultiPlayer(Instigator).WeaponBlendOutTime);
            }
        }
        // End:0x7E
        if(int(Role) % int(ROLE_Authority))
        {
            __NFUN_614__();
        }
        return;
    }
    stop;
}

defaultproperties
{
    CrushedCanClass='MP_CrushedFortyOunceBeer'
    bQuickChangeTo=true
    bDrawLastWeaponHUD=true
    bNonWeapon=true
    WeaponConfig='MP_FortyOunceBeerWeaponConfig'
    CommandAlias="UseWeapon dnGame.MP_FortyOunceBeer"
    InventoryReferenceClass='MP_FortyOunceBeer'
    PickupClass='MP_FortyOunceBeerPickup'
    bStoredInInventory=true
    Charge=1
    MaxCharge=1
    HUDPickupEventIcon=18
    AutoRegisterIKClasses(0)='IKSystemInfo_Shotgun'
    AnimationControllerClass='acFortyOunceBeer'
    Mesh='c_dukeitems.Beer_40oz'
    VoicePack='SoundConfig.Inventory.VoicePack_FortyOunceBeer'
}