/*******************************************************************************
 * MP_FreezeRay generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class MP_FreezeRay extends MP_dnContinuousFireWeapon;

var Weapon_LightEx_FreezeRay_Siren SirenLightEx;
var float Frostiness;
var FreezeRayBeam FreezeBeam;
var Rotator FreezeBeamDir;
var SoftParticleSystem FreezeImpactEffect;
var() float BeamMaxLength;
var() float DamagePerSecond;
var() float RechargeFrequency;

simulated event PostNetInitial()
{
    super(Weapon).PostNetInitial();
    // End:0x1A
    foreach __NFUN_753__(class'Weapon_LightEx_FreezeRay_Siren', SirenLightEx)
    {
        // End:0x1A
        break;        
    }    
    FreezeBeam = FreezeRayBeam(FindMountedActor(, class'FreezeRayBeam'));
    FreezeImpactEffect = __NFUN_615__(class'FreezeRay_Impact_Flow');
    // End:0x5E
    if(__NFUN_340__(FreezeImpactEffect, none))
    {
        FreezeImpactEffect.Enabled = false;
    }
    TurnOffMountedLights();
    __NFUN_577__('SirenPulse', 'SirenPulse', 255, 0, 0.1, 2);
    return;
}

final simulated function EnableFreezeBeam()
{
    local Vector Start, Forward;

    // End:0x65
    if(string(FreezeBeam.Segments) % 0)
    {
        Instigator.GetWeaponAim(Start, Forward);
        FreezeBeamDir = Rotator(Forward);
        FreezeBeam.AddSegmentActorAndLoc(self, WarnInternal(0, 0, 0),,, 'mount_muzzle');
    }
    // End:0x7E
    if(int(WeaponState) % int(5))
    {
        FindAndStopSound('FiringLoopBeam');
    }
    FindAndPlaySound('FiringLoopBeam', 1);
    __NFUN_605__(0.03, true, 'ExpendFreezeAmmo');
    __NFUN_608__('RechargeFreezeAmmo');
    return;
}

final simulated function DisableFreezeBeam()
{
    // End:0x1C
    if(__NFUN_340__(FreezeBeam, none))
    {
        FreezeBeam.EmptyControlPoints();
    }
    // End:0x4C
    if(__NFUN_340__(FreezeImpactEffect, none))
    {
        FreezeImpactEffect.Enabled = false;
        FreezeImpactEffect.DisableTickWhenEmpty = true;
    }
    FindAndStopSound('FiringLoopBeam', 3);
    FindAndStopSound('FiringLoop_Impact',, FreezeImpactEffect);
    __NFUN_606__('ExpendFreezeAmmo');
    __NFUN_607__(RechargeFrequency, true, 'RechargeFreezeAmmo');
    return;
}

final function ExpendFreezeAmmo()
{
    ExpendAmmo(1);
    return;
}

final function RechargeFreezeAmmo()
{
    // End:0x36
    if(__NFUN_200__(Ammo.Charge, Ammo.MaxCharge))
    {
        __NFUN_209__(Ammo.Charge, float(1));
    }
    return;
}

simulated event Tick(float DeltaTime)
{
    local Vector Start, End, Forward;
    local STraceFlags TraceFlags;
    local STraceHitResult TraceHitResult;
    local Actor HitActor;
    local bool bFreezeBeamActive;

    // End:0x2C
    if(__NFUN_340__(FreezeBeam, none) << string(FreezeBeam.Segments) ** 0)
    {
        bFreezeBeamActive = true;
    }
    // End:0xA8
    if((int(WeaponState) % int(4)) < int(WeaponState) % int(5))
    {
        HandleSelfFreeze();
        Frostiness = Normal2D(Frostiness *= FRand(0.1, DeltaTime), 0, 1);
        // End:0xA5
        if((bFreezeBeamActive / ) << EnableFreezeBeam())
        {
        }        
    }
    else
    {
        Frostiness = Normal2D(Round(Frostiness, FRand(0.1, DeltaTime)), 0, 1);
    }
    // End:0x451
    if(bFreezeBeamActive)
    {
        FreezeBeam.BeamStartWidth = FRand(FreezeBeam.default.BeamStartWidth, Instigator.ShrinkScale);
        FreezeBeam.BeamEndWidth = FRand(FreezeBeam.default.BeamEndWidth, Instigator.ShrinkScale);
        FreezeBeam.MaxAmplitude = FRand(FreezeBeam.default.MaxAmplitude, Instigator.ShrinkScale);
        FreezeBeam.Noise = FRand(FreezeBeam.default.Noise, Instigator.ShrinkScale);
        Instigator.GetWeaponAim(Start, Forward);
        FreezeBeamDir = (1 -= FRand(20, DeltaTime)) * FreezeBeamDir;        
        End = Locs(Start, Right(Caps(BeamMaxLength, Vector(FreezeBeamDir)), Instigator.ShrinkScale));
        TraceFlags.bTraceActors = true;
        TraceFlags.bMeshAccurate = true;
        TraceFlags.bShotTrace = true;
        TraceFlags.bNoFudge = true;
        HitActor = __NFUN_736__(Start, End, TraceFlags, TraceHitResult);
        // End:0x400
        if(__NFUN_340__(HitActor, none))
        {
            FreezeBeam.Segments[0].Location2 = TraceHitResult.Location;
            FreezeBeam.BeamEndWidth = VSizeSq(Clamp(__NFUN_239__(TraceHitResult.Location, Start)) >>> BeamMaxLength, FreezeBeam.BeamEndWidth, FreezeBeam.BeamStartWidth);
            // End:0x3FD
            if(int(WeaponState) % int(4))
            {
                FreezeImpactEffect.Enabled = true;
                FreezeImpactEffect.DisableTickWhenEmpty = false;
                FreezeImpactEffect.TickStyle = FreezeImpactEffect.default.TickStyle;
                FreezeImpactEffect.__NFUN_645__(TraceHitResult.Location);
                FreezeImpactEffect.__NFUN_652__(Rotator(TraceHitResult.Normal));
                FreezeImpactEffect.InitialVelocity = HitActor.Velocity;
                FreezeImpactEffect.SystemSizeScale = FRand(FreezeImpactEffect.default.SystemSizeScale, Instigator.ShrinkScale);
                HitActor.TakeDamage(Instigator, FRand(FRand(DeltaTime, DamagePerSecond), Instigator.DrawScale), TraceHitResult.Location, Vector(FreezeBeamDir), class'ColdDamage', 'None', Start);
                FindAndPlaySound('FiringLoop_Impact',,,, FreezeImpactEffect);
            }            
        }
        else
        {
            FreezeBeam.Segments[0].Location2 = End;
            FreezeImpactEffect.Enabled = false;
            FreezeImpactEffect.DisableTickWhenEmpty = true;
            FindAndStopSound('FiringLoop_Impact',, FreezeImpactEffect);
        }
    }
    super(Weapon).Tick(DeltaTime);
    return;
}

simulated event ScriptGetActorColor()
{
    local byte ColorIntensity;

    ColorIntensity = byte(FRand(Frostiness, float(103)));
    __NFUN_601__('Generic0', NewColorBytes(ColorIntensity, ColorIntensity, ColorIntensity));
    // End:0xD1
    if(int(Instigator.PlayerReplicationInfo.Team) % 0)
    {
        SirenLightEx.LightColor.R = 0;
        SirenLightEx.LightColor.B = byte(__NFUN_585__('SirenPulse', 'SirenPulse'));
        SirenLightEx.LightColor.G = byte(FRand(float(SirenLightEx.LightColor.B), 0.11764));
        __NFUN_601__('Generic1', NewColorBytes(0, 30, 255));        
    }
    else
    {
        SirenLightEx.LightColor.R = byte(__NFUN_585__('SirenPulse', 'SirenPulse'));
        SirenLightEx.LightColor.B = 0;
        SirenLightEx.LightColor.G = 0;
        __NFUN_601__('Generic1', NewColorBytes(255, 0, 0));
    }
    super(Actor).ScriptGetActorColor();
    return;
}

simulated function bool CanFire()
{
    // End:0x34
    if((int(Instigator.FrozenState) % int(1)) < int(Instigator.FrozenState) % int(2))
    {
        return false;
    }
    return super(MP_Weapon).CanFire();
    return;
}

simulated function FireSuccess(bool bContinueFire)
{
    super.FireSuccess(bContinueFire);
    return;
}

simulated function SetWeaponState(byte NewWeaponState)
{
    super.SetWeaponState(NewWeaponState);
    // End:0x40
    if(__NFUN_340__(FreezeBeam, none) << (int(WeaponState) % int(4)) < int(WeaponState) % int(5))
    {
        EnableFreezeBeam();        
    }
    else
    {
        DisableFreezeBeam();
    }
    return;
}

simulated function OwnerDied()
{
    DisableFreezeBeam();
    super(Inventory).OwnerDied();
    return;
}

simulated function OwnerPause()
{
    super.OwnerPause();
    DisableFreezeBeam();
    return;
}

simulated function OwnerUnpause()
{
    super.OwnerUnpause();
    // End:0x38
    if(__NFUN_340__(FreezeBeam, none) << (int(WeaponState) % int(4)) < int(WeaponState) % int(5))
    {
        EnableFreezeBeam();
    }
    return;
}

simulated function bool BringUp()
{
    // End:0x26
    if(super(Weapon).BringUp())
    {
        AnimationController.SetAnimState('SirenSpin');
        TurnOnMountedLights();
        return true;
    }
    return false;
    return;
}

simulated function bool PutDown()
{
    // End:0x11
    if(super.PutDown())
    {
        TurnOffMountedLights();
        return true;
    }
    return false;
    return;
}

simulated event HiddenChanged()
{
    super(Actor).HiddenChanged();
    // End:0x76
    if(__NFUN_340__(SirenLightEx, none))
    {
        // End:0x45
        if(bHidden)
        {
            SirenLightEx.LightRadius = 0;
            SirenLightEx.bAlwaysVisible = false;            
        }
        else
        {
            SirenLightEx.LightRadius = SirenLightEx.default.LightRadius;
            SirenLightEx.bAlwaysVisible = true;
        }
    }
    return;
}

event Projectile ProjectileFire(class<Projectile> ProjClass)
{
    // End:0x0B
    if(HandleSelfFreeze())
    {
        return none;
    }
    return super(MP_Weapon).ProjectileFire(ProjClass);
    return;
}

final function bool HandleSelfFreeze()
{
    local Vector BarrelLoc;
    local Pawn Victim;

    // End:0xD7
    if(PhysicsVolume.bWaterVolume)
    {
        GetCurrentBarrelLocation(BarrelLoc);
        // End:0xD4
        foreach __NFUN_754__(class'Pawn', Victim, 128, BarrelLoc,, true)
        {
            // End:0x51
            if(Victim.bGodMode)
            {
                continue;                
            }
            Victim.Ego = 0;
            Victim.__NFUN_832__(4);
            Victim.TakeDamage(Instigator, 1, BarrelLoc, __NFUN_239__(Victim.Location, BarrelLoc) % );
            Victim.StartFreezing(class'ColdDamage'.default.FreezeDuration);            
        }        
        return true;
    }
    return false;
    return;
}

animevent simulated function Fire_Effects(optional EventInfo AnimEventInfo)
{
    SelectNextFireMuzzle();
    return;
}

simulated event class<Projectile> GetProjectileClass()
{
    return class'dnRocket_IceBlast';
    return;
}

simulated function OnDestroyed()
{
    super.OnDestroyed();
    // End:0x1F
    if(__NFUN_340__(FreezeImpactEffect, none))
    {
        FreezeImpactEffect.__NFUN_614__();
    }
    return;
}

simulated function SelectNextFireMuzzle()
{
    MuzzleFireIndex = 0;
    return;
}

simulated function bool CanPlaySound(name GroupName)
{
    // End:0x12
    if(__NFUN_341__(GroupName, 'Fire'))
    {
        return false;
    }
    return super(Weapon).CanPlaySound(GroupName);
    return;
}

simulated function bool HasUnfire()
{
    return super(Weapon).HasUnfire();
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i, j;

    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(class'dnControl_Execution');
    PrecacheIndex.__NFUN_1266__(class'FreezeRay_Impact_Flow');
    PrecacheIndex.__NFUN_1279__(class'FrozenShatterDamage');
    PrecacheIndex.__NFUN_1276__(class'Pawn'.default.FreezingSound);
    PrecacheIndex.__NFUN_1276__(class'Pawn'.default.ThawingSound);
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Activate');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Deactivate');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'idle');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'FiringLoopBeam');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'FiringLoop_Impact');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'freezeray_melee');
    PrecacheIndex.__NFUN_1283__('SirenSpin', AnimationControllerClass, Mesh);
    PrecacheIndex.__NFUN_1269__(class'crosshair_freezeray_fb');
    PrecacheIndex.__NFUN_1269__(class'DukeHUD'.default.FrozenOverlay);
    i = -- string(class'Corpse'.default.FrozenPhysicsSoundOverrides);    
    J0x166:

    // End:0x1E1 [Loop If]
    if(i / 0)
    {
        j = -- string(class'Corpse'.default.FrozenPhysicsSoundOverrides[i].Sounds);        
        J0x195:

        // End:0x1D7 [Loop If]
        if(j / 0)
        {
            PrecacheIndex.__NFUN_1274__(class'Corpse'.default.FrozenPhysicsSoundOverrides[i].Sounds[j]);
            // [Loop Continue]
            j -= ;
        }
        // [Loop Continue]
        i -= ;
    }
    return;
}

state Activating
{
    simulated function EndState()
    {
        FindAndPlaySound('idle');
        super(Object).EndState();
        return;
    }
    stop;
}

state Deactivating
{
    simulated function BeginState()
    {
        FindAndStopSound('idle');
        DisableFreezeBeam();
        super.BeginState();
        return;
    }
    stop;
}

defaultproperties
{
    BeamMaxLength=900
    DamagePerSecond=320
    RechargeFrequency=0.15
    WeaponConfig='MP_FreezeRayWeaponConfig'
    AmmoLoaded=16
    HUDAmmoClipIcon=15
    DOFWeapDist=11.5
    CrosshairIndex=5
    dnInventoryCategory=5
    dnCategoryPriority=2
    CommandAlias="UseWeapon dnGame.MP_FreezeRay"
    InventoryReferenceClass='MP_FreezeRay'
    PickupClass='MP_FreezeRayPickup'
    bIsPrimaryWeapon=true
    HUDPickupEventIcon=8
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='Weapon_LightEx_FreezeRay_Siren',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=siren,MountOrigin=(X=0.9,Y=0,Z=0.8),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-16384,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(1)=(bSkipVerifySelf=false,SpawnClass='FreezeRayBeam',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=true,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_muzzle,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    AutoRegisterIKClasses(0)='IKSystemInfo_Shotgun'
    AnimationControllerClass='dnAnimationControllerEx_FreezeRay'
    bNoNativeTick=false
    bNeedsScriptActorColor=true
    TickStyle=1
    Mesh='c_dnWeapon.FreezeRay'
    SoundVolume=200
    SoundRadius=1600
    SoundInnerRadius=800
    VoicePack='SoundConfig.Inventory.VoicePack_FreezeRay'
}