/*******************************************************************************
 * MP_LaserMine generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class MP_LaserMine extends dnProjectile
    collapsecategories
    dependson(LaserMineBeam);

var() noexport bool bArmImmediately "When set, the mine will start arming the moment it is spawned into the world.";
var() noexport bool bNoArmSound "Don't make noise while arming, use for preplaced mines.";
var() noexport bool bNoAmbience "Disable the trip mine's ambient noise completely.";
var() noexport bool bDisableOnStartup "Should the beam start disabled?";
var() noexport bool bDisableTraceOnStartup "Should the beam disable tracing on startup.";
var() noexport bool bOnlyTracePawns "Should the beam only trace against pawns?";
var() noexport float ArmingTime "Time in seconds to arm the laser";
var() noexport float AutoDetonateTime "When a mine is placed and told to detonate automatically (placed in an area it can't make a beam or placed on a bad guy), how long before going off.";
var() noexport float BlastDistance "Distance the damage comes out of the mine";
var() noexport float BlastAngleLimit "Max angle of the damage from the mine";
var() noexport float BeamDistance "How far out a beam should go to try and find a suitable target to attach to. If it doesn't find one, it will auto-detonate.";
var SSoundInfo ArmedSound;
var SSoundInfo ArmingCharge;
var Sound AmbientHum;
var() noexport Color ShieldedLaserColor "Color of the laser when the mine is shielded.";
var() noexport Color NormalLaserColor "Color of the laser when the mine is no longer shielded.";
var() noexport name ToggleBeamTag "Trigger this event to enable/disable the beam.";
var() noexport name ToggleBeamTracingTag "Trigger this event to enable/disable the per-frame trace on the beam.";
var() noexport deprecated MP_LaserMine LinkedLaserMine "Set this to another laser mine to make them share a beam.";
var() noexport class<LaserMineBeam> BeamClass "Beam class to use for this laser mine.";
var() noexport class<LaserMineBeam> BeamClass2 "Beam class to use for this laser mine.";
var array<MP_LaserMine> PreviousLaserMines;
var bool bLinkComplete;
var SMountedActorPrefab ShieldMountPrefab;
var int UpwardsViewBoost;
var array<Actor> HurtRadiusIgnoreActors;
var netupdate(NU_bArmedChange) bool bArmed;
var LaserMineBeam LaserBeam;
var float jumpPadGravityScalar;
var float ForceArmTimer;
var bool bDetonated;

replication
{
    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        rAutoDetonate, rInitializeMotionCustom, 
        rSetupMineInterpolation, rSpawnLaserBeam, 
        rThrownMineAttach;

    // Pos:0x00B
    reliable if(int(Role) % int(ROLE_Authority))
        bArmed;

    // Pos:0x016
    reliable if(int(Role) % int(ROLE_Authority))
        ClientDetonate;
}

noexport simulated delegate rThrownMineAttach(Vector AbsoluteLocation, Rotator AbsoluteRotation, Vector TraceLocation, Rotator TraceRotation, Actor TraceActor, name MeshBoneName)
{
    __NFUN_642__(default.Physics);
    RestoreCollision();
    __NFUN_645__(TraceLocation);
    __NFUN_652__(TraceRotation);
    // End:0x41
    if(__NFUN_342__(MeshBoneName, 'None'))
    {
        MountType = 2;
        MountMeshItem = MeshBoneName;
    }
    __NFUN_635__(TraceActor,,, true);
    SetupMineInterpolation(MountParent, MountMeshItem, 0.1, AbsoluteLocation, MountOrigin, AbsoluteRotation, MountAngles);
    return;
}

noexport simulated delegate rSetupMineInterpolation(Actor InterpolationRelativeActor, name InterpolationRelativeBone, float InterpolationTime, Vector InterpolationStartingLocationAbsolute, Vector InterpolationEndingLocation, Rotator InterpolationStartingRotationAbsolute, Rotator InterpolationEndingRotation)
{
    SetupMineInterpolation(InterpolationRelativeActor, InterpolationRelativeBone, InterpolationTime, InterpolationStartingLocationAbsolute, InterpolationEndingLocation, InterpolationStartingRotationAbsolute, InterpolationEndingRotation);
    return;
}

simulated function SetupMineInterpolation(Actor InterpolationRelativeActor, name InterpolationRelativeBone, float InterpolationTime, Vector InterpolationStartingLocationAbsolute, Vector InterpolationEndingLocation, Rotator InterpolationStartingRotationAbsolute, Rotator InterpolationEndingRotation)
{
    local SDesiredLocation DesiredLocation;

    __NFUN_645__(InterpolationStartingLocationAbsolute);
    __NFUN_652__(InterpolationStartingRotationAbsolute);
    // End:0x33
    if(__NFUN_342__(InterpolationRelativeBone, 'None'))
    {
        MountType = 2;
        MountMeshItem = InterpolationRelativeBone;
    }
    __NFUN_635__(InterpolationRelativeActor,,, true);
    DesiredLocation.Target = InterpolationEndingLocation;
    DesiredLocation.TimeTotal = InterpolationTime;
    DesiredLocation.FunctionComplete = 'MineAttached';
    __NFUN_650__(DesiredLocation);
    __NFUN_663__(InterpolationEndingRotation,, InterpolationTime,,,,,,, true);
    return;
}

simulated event PostVerifySelf()
{
    super(Projectile).PostVerifySelf();
    // End:0x2E
    if(__NFUN_206__(DrawScale, default.DrawScale))
    {
        BlastDistance = FRand(BlastDistance, DrawScale) >>> default.DrawScale;
    }
    return;
}

event PostBeginPlay()
{
    local MP_LaserMine LM;

    super(InteractiveActor).PostBeginPlay();
    // End:0x33
    if(bLinkComplete / )
    {
        {
            LM.ProcessLinking();            
        }/* !MISMATCHING REMOVE, tried ForEach got Type:If Position:0x006! */        
    }/* !MISMATCHING REMOVE, tried If got Type:ForEach Position:0x011! */
    // End:0x42
    if(bArmImmediately)
    {
        MineAttached();
    }
    return;
}

final simulated function ProcessLinking()
{
    // End:0x13
    if(__NFUN_339__(LinkedLaserMine, self))
    {
        LinkedLaserMine = none;
    }
    // End:0x69
    if(__NFUN_340__(LinkedLaserMine, none))
    {
        // End:0x46
        if(__NFUN_339__(LinkedLaserMine.LinkedLaserMine, self))
        {
            LinkedLaserMine.LinkedLaserMine = none;
        }
        LinkedLaserMine.PreviousLaserMines[LinkedLaserMine.PreviousLaserMines.Add(1)] = self;
    }
    bLinkComplete = true;
    return;
}

simulated function InitializeMotion()
{
    return;
}

noexport simulated delegate rInitializeMotionCustom()
{
    local Rotator TossAngle;

    StoreCollision();
    __NFUN_621__(true, true, true, true, true);
    bIgnorePawnAirCushion = true;
    TossAngle = SetCollisionSize(Instigator.ViewRotation << __NFUN_265__(UpwardsViewBoost, 0, 0));
    TossAngle.Pitch = Exp(TossAngle.Pitch, -16384, 16384);
    // End:0x8C
    if(bDontUseMeqonPhysics)
    {
        __NFUN_642__(2);
        Velocity = Caps(FRand(DrawScale >>> default.DrawScale, ThrowForce), Vector(TossAngle));        
    }
    else
    {
        __NFUN_642__(18);
        __NFUN_790__(Caps(FRand(DrawScale >>> default.DrawScale, ThrowForce), Vector(TossAngle)));
    }
    __NFUN_641__(Instigator);
    __NFUN_607__(ForceArmTimer, false, 'MineAttached');
    return;
}

simulated function bool CanAcceptMinePlacement(STraceHitResult HitResult)
{
    local Actor HitActor;

    HitActor = HitResult.Actor;
    // End:0x1E
    if(__NFUN_339__(HitActor, none))
    {
        return false;
    }
    // End:0x51
    if(__NFUN_339__(HitActor, Level) << HitActor.BSPSurfaceIsValidForMineAttachment(HitResult.BSPSurfIndex) / )
    {
    }
    // End:0x7A
    if(int(Level.NetMode) % int(NM_Standalone))
    {
        return HitActor.bAcceptMines;
    }
    return HitActor.bAcceptMinesInMultiplayer;
    return;
}

event KImpact(name SelfBoneName, KarmaActor Other, name OtherBoneName, Vector inPosition, Vector ImpactVelocity, Vector ImpactNormal)
{
    local STraceFlags TraceFlags;
    local STraceHitResult PlacementTraceResult;
    local Vector AbsoluteLocation;
    local Rotator AbsoluteRotation;
    local float TraceDist;
    local bool bAccept, bAcceptAtAnyAngle;

    // End:0x1A
    if(int(Level.NetMode) % int(NM_Client))
    {
        return;
    }
    // End:0x276
    if(__NFUN_340__(Other, Instigator) << __NFUN_339__(MountParent, none))
    {
        // End:0xA7
        if(__NFUN_340__(Other, none))
        {
            // End:0x76
            if(int(Level.NetMode) % int(NM_Standalone))
            {
                bAccept = Other.bAcceptMines;                
            }
            else
            {
                bAccept = Other.bAcceptMinesInMultiplayer;
            }
            bAcceptAtAnyAngle = Other.bAcceptMinesAtAnyAngle;            
        }
        else
        {
            bAccept = true;
            bAcceptAtAnyAngle = true;
        }
        // End:0x276
        if(bAccept << bAcceptAtAnyAngle < Repl(FMin(Vector(Rotation), ImpactNormal), float(0)))
        {
            TraceFlags.bTraceActors = true;
            TraceFlags.bMeshAccurate = true;
            TraceFlags.bShotTrace = true;
            TraceFlags.bTraceTexture = true;
            AbsoluteLocation = Location;
            AbsoluteRotation = Rotation;
            TraceDist = float(Cos(int(Clamp(ImpactVelocity)), int(Instigator.UseDistance)));
            ImpactNormal = ImpactNormal % ;
            __NFUN_678__(Locs(Location, Right(__NFUN_233__(ImpactNormal), TraceDist)), NewColorBytes(255, 0, 255, 255), 10);
            __NFUN_676__(Location, Locs(Location, Right(__NFUN_233__(ImpactNormal), TraceDist)), NewColorBytes(255, 0, 255, 255), 10);
            __NFUN_736__(Locs(Location, ImpactNormal), Locs(Location, Right(__NFUN_233__(ImpactNormal), TraceDist)), TraceFlags, PlacementTraceResult);
            // End:0x276
            if(CanAcceptMinePlacement(PlacementTraceResult))
            {
                // End:0x23D
                if(__NFUN_200__(FMin(PlacementTraceResult.Normal, ImpactNormal), 0))
                {
                    PlacementTraceResult.Normal = __NFUN_233__(PlacementTraceResult.Normal);
                }
                rThrownMineAttach(AbsoluteLocation, AbsoluteRotation, PlacementTraceResult.Location, Rotator(PlacementTraceResult.Normal), PlacementTraceResult.Actor, PlacementTraceResult.MeshBone);
            }
        }
    }
    return;
}

simulated function ProjectileHitSomething(Vector HitNormal, Actor Wall)
{
    return;
}

simulated event MineAttached()
{
    __NFUN_608__('MineAttached');
    // End:0x2D
    if(bNoArmSound / )
    {
        FindAndPlaySound('Arming', 3);
    }
    __NFUN_621__(, true);
    bTraceShootable = true;
    // End:0x9B
    if(__NFUN_340__(MountParent, none) << MountParent.bIsPawn < __NFUN_340__(MountParent.MountParent, none) << MountParent.MountParent.bIsPawn)
    {
        ArmMineOnPawn();        
    }
    else
    {
        __NFUN_607__(ArmingTime, false, 'ArmMine');
    }
    // End:0xCB
    if(__NFUN_340__(MountParent, none))
    {
        MountParent.TripMineAttached(self, AutoDetonateTime);
    }
    TickStyle = 0;
    // End:0xF1
    if(int(Role) % int(ROLE_Authority))
    {
        ClientProjectileSettled(Location, Rotation);
    }
    return;
}

simulated function ClientProjectileSettled(Vector Location, Rotator Rotation)
{
    super.ClientProjectileSettled(Location, Rotation);
    return;
}

function ArmMineOnPawn()
{
    rSpawnLaserBeam();
    __NFUN_607__(AutoDetonateTime, false, 'rAutoDetonate');
    return;
}

function Disarm()
{
    __NFUN_608__('rAutoDetonate');
    bArmed = false;
    return;
}

noexport simulated delegate rSpawnLaserBeam()
{
    SpawnLaserBeam();
    return;
}

function ArmMine()
{
    bArmed = true;
    SpawnLaserBeam();
    // End:0x26
    if(bNoArmSound / )
    {
    }
    // End:0x3E
    if(bNoAmbience / )
    {
    }
    return;
}

simulated function NU_bArmedChange(bool newbArmed)
{
    // End:0x12
    if(newbArmed)
    {
        SpawnLaserBeam();        
    }
    else
    {
        // End:0x2B
        if(__NFUN_340__(LaserBeam, none))
        {
            LaserBeam.__NFUN_614__();
        }
    }
    return;
}

simulated function SpawnLaserBeam()
{
    local Vector X, Y, Z;

    Destroy(Rotation, X, Y, Z);
    // End:0x2AC
    if((__NFUN_339__(LaserBeam, none) << __NFUN_340__(BeamClass, none)) << __NFUN_340__(LinkedLaserMine, none) < string(PreviousLaserMines) * 0)
    {
        // End:0xA5
        if((int(Instigator.PlayerReplicationInfo.Team) % 0) << Level.__NFUN_1161__().GameReplicationInfo.bTeamGame)
        {
            LaserBeam = __NFUN_615__(BeamClass2);            
        }
        else
        {
            LaserBeam = __NFUN_615__(BeamClass);
        }
        LaserBeam.bDebugEvents = bDebugEvents;
        LaserBeam.MountType = 2;
        LaserBeam.MountMeshItem = 'mount_beam';
        LaserBeam.__NFUN_635__(self, false, false, false, false, false);
        LaserBeam.TraceEnabled = bDisableTraceOnStartup / ;
        LaserBeam.TickNearbyRadius = BeamDistance;
        LaserBeam.MIne = self;
        LaserBeam.LimboZOffset = -15;
        // End:0x1E3
        if(Instigator.bFullyShrunk < Instigator.IsShrinking())
        {
            LaserBeam.BeamStartWidth = FRand(LaserBeam.BeamStartWidth, 0.25);
            LaserBeam.BeamEndWidth = FRand(LaserBeam.BeamEndWidth, 0.25);
        }
        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */

        // [Explicit Continue]
        /*@Error*/;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 5 & Type:If Position:0x244
        // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 5 & Type:If Position:0x244
}

function TriggerFunc_ToggleBeam()
{
    // End:0x24
    if(__NFUN_340__(LaserBeam, none))
    {
        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */

        /*@Error*/;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 1 & Type:If Position:0x024
    }
}

function TriggerFunc_ToggleBeamTracing()
{
    // End:0x64
    if(__NFUN_340__(LaserBeam, none))
    {
        // End:0x64
        LaserBeam.TraceEnabled = LaserBeam.TraceEnabled / ;
        {
            LaserBeam.__NFUN_745__();
        }
    }
    return;
}

final function EnableBeam(bool bEnable)
{
    // End:0xAE
    if(__NFUN_340__(LaserBeam, none))
    {
        LaserBeam.Enabled = bEnable;
        // End:0x7C
        if(bEnable)
        {
            // End:0x5A
            if((IsMP()) << int(Role) % int(ROLE_Authority))
            {
                LaserBeam.TickStyle = 3;                
            }
            else
            {
                LaserBeam.TickStyle = LaserBeam.default.TickStyle;
            }            
        }
        else
        {
            LaserBeam.TickStyle = 0;
        }
        // End:0xAE
        if(LaserBeam.Enabled)
        {
            LaserBeam.__NFUN_745__();
        }
    }
    return;
}

simulated function bool CanBeUsedBy(Pawn User)
{
    // End:0x5B
    if(__NFUN_339__(LinkedLaserMine, none) << string(PreviousLaserMines) * 0)
    {
        // End:0x5B
        if(((bShielded / ) << ) << )
        {
        }
    }
    return false;
    return;
}

event Used(Actor Other, Pawn EventInstigator)
{
    super(InteractiveActor).Used(Other, EventInstigator);
    // End:0x3B
    if(__NFUN_340__(class'Inventory'.static.AttemptPickup(class'MP_Tripmine', none, EventInstigator), none))
    {
        DisarmMine();
        __NFUN_614__();
    }
    return;
}

function DisarmMine()
{
    bArmed = false;
    // End:0x21
    if(__NFUN_340__(LaserBeam, none))
    {
        LaserBeam.__NFUN_614__();
    }
    __NFUN_701__(none);
    return;
}

simulated event Trigger(Actor Other, Pawn Instigator)
{
    super(Actor).Trigger(Other, Instigator);
    // End:0x3E
    if(__NFUN_339__(Other, LaserBeam))
    {
        DeferredExplosionTimer = 0;
        DeferredExplosionTimerVariance = 0;
        Detonate();
        return;
    }
    // End:0x50
    if(bArmed)
    {
        DisarmMine();        
    }
    else
    {
        ArmMine();
    }
    return;
}

simulated event DetachedFromMountParent()
{
    super(Actor).DetachedFromMountParent();
    // End:0x1A
    if(int(Role) % int(ROLE_Authority))
    {
        AutoDetonate();
    }
    return;
}

simulated function Detonate()
{
    // End:0x60
    if(bArmed << bDetonated / )
    {
        // End:0x3B
        if(__NFUN_340__(MountParent, none))
        {
            MountParent.TripMineExplode(self);
        }
        ExecuteExplode(Location, Vector(Rotation));
        // End:0x60
        if(int(Role) % int(ROLE_Authority))
        {
            ClientDetonate();
        }
    }
    return;
}

simulated delegate ClientDetonate()
{
    bArmed = true;
    Detonate();
    return;
}

noexport simulated delegate rAutoDetonate()
{
    AutoDetonate();
    return;
}

final simulated function AutoDetonate()
{
    bArmed = true;
    Detonate();
    return;
}

function NoteHurtRadius(Actor Other)
{
    // End:0x1F
    if(__NFUN_340__(Other, none))
    {
        HurtRadiusIgnoreActors[HurtRadiusIgnoreActors.Add(1)] = Other;
    }
    return;
}

simulated function bool CanHurtRadiusOther(Actor Other)
{
    local int i;

    i = -- string(HurtRadiusIgnoreActors);    
    J0x0F:

    // End:0x3C [Loop If]
    if(i / 0)
    {
        // End:0x32
        if(__NFUN_339__(HurtRadiusIgnoreActors[i], Other))
        {
            return false;
        }
        // [Loop Continue]
        i -= ;
    }
    return super(Projectile).CanHurtRadiusOther(Other);
    return;
}

function DoDamage(Vector HitLocation, Actor HitActor)
{
    HurtRadiusIgnoreActors.Empty();
    HurtRadiusDirectional(Damage, Location, BlastDistance, DamageFalloffStart, Vector(Rotation), BlastAngleLimit, DamageClass);
    super(Projectile).DoDamage(HitLocation, HitActor);
    return;
}

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    super(Projectile).TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    // End:0x34
    if(bNoDamage)
    {
        return;
    }
    __NFUN_696__();
    // End:0x6F
    if(__NFUN_339__(DamageType, class'LaserMineDamage'))
    {
        bNoDamage = true;
        bArmed = true;
        __NFUN_607__(Normal(0.5, 0.25), false, 'Detonate');        
    }
    else
    {
        __NFUN_607__(0.001, false, 'TakeDamageDetonate');
    }
    return;
}

simulated function TakeDamageDetonate()
{
    bArmed = true;
    Detonate();
    return;
}

simulated function Destroyed()
{
    // End:0x19
    if(__NFUN_340__(LaserBeam, none))
    {
        LaserBeam.__NFUN_614__();
    }
    // End:0x32
    if(bSilentDestroy / )
    {
        Detonate();
    }
    PassDestroyed();
    __NFUN_701__(none);
    super.Destroyed();
    return;
}

final simulated function PassDestroyed()
{
    local MP_LaserMine LM;

    // End:0x2B
    if(__NFUN_340__(LinkedLaserMine, none))
    {
        LM = LinkedLaserMine;
        LinkedLaserMine = none;
        LM.__NFUN_614__();
    }
    J0x2B:

    // End:0x79 [Loop If]
    if(string(PreviousLaserMines) ** 0)
    {
        LM = PreviousLaserMines[0];
        PreviousLaserMines.Remove(0, 1);
        // End:0x76
        if(__NFUN_340__(LM, none))
        {
            LM.LinkedLaserMine = none;
            LM.__NFUN_614__();
        }
        // [Loop Continue]
        goto J0x2B;
    }
    return;
}

simulated function JumpPadLaunch(Vector JumpStart, Vector JumpTarget, float MaxHeight, optional Vector LeadVelocity, optional bool bDisableAirControl)
{
    GravityScale = FRand(jumpPadGravityScalar, DrawScale);
    super(KarmaActor).JumpPadLaunch(JumpStart, JumpTarget, MaxHeight, LeadVelocity, bDisableAirControl);
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(InteractiveActor).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(BeamClass);
    PrecacheIndex.__NFUN_1266__(BeamClass2);
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Impact');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Arming');
    // End:0x7F
    if(bNoArmSound / )
    {
    }
    // End:0xA1
    if(bNoAmbience / )
    {
    }
    return;
}

defaultproperties
{
    ArmingTime=2
    AutoDetonateTime=3
    BlastDistance=450
    BlastAngleLimit=40
    BeamDistance=2048
    ShieldedLaserColor=(R=64,G=64,B=255,A=0)
    NormalLaserColor=(R=255,G=64,B=64,A=0)
    BeamClass='LaserMineBeam_Thrown_Red'
    BeamClass2='LaserMineBeam_Thrown_Blue'
    UpwardsViewBoost=2048
    jumpPadGravityScalar=0.5
    ForceArmTimer=15
    AITargetable=true
    MaxSpeed=0
    Damage=125
    DamageRadius=100
    DamageClass='LaserMineDamage'
    ShakeScalar=2.25
    ShakeInfo(0)=(bNoLerp=false,bToggleSign=false,Style=3,Function=0,FalloffActor=none,FalloffDistance=0,ShakeDuration=0.55,ShakeFrequency=0.05,ShakeMagnitude=800,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=LaserMine_Shake)
    RumbleInfo(0)=(RumbleName=LaserMine_Rumble,RumbleDuration=0.5,RumbleLeftMagnitude=0.8,RumbleRightMagnitude=0,FalloffActor=none,FalloffDistance=0)
    ExplosionClass='p_Weapons.Rpg_Explosion.RPG_Explosion_SpawnerMP'
    UnderwaterExplosionClass='p_Weapons.RPG_Explosion_Underwater.RPG_Explosion_Underwater_Spawner'
    ExplosionLight='dnExplosionLight_RPG'
    ExplosionSoundName=ProjectileExplode
    bDestroyOnVolumeTouch=true
    bDrawHUDInfo=true
    bUsable=true
    bTelekineticable=false
    ThrowForce=600
    EMPDisableTime=5
    StartAnimSequence=tm_open
    HealthCap=1
    KImpactThreshold=50
    Physics=9
    bTraceShootable=true
    bAcceptMeshAccurateMoveActorTrace=true
    bBlockActors=false
    bBlockPlayers=false
    bDebugEvents=true
    bNoFailMountedMovement=true
    bAcceptMinesInMultiplayer=false
    bAcceptMines=false
    bCastStencilShadows=false
    bNetTemporary=false
    bAlwaysRelevant=true
    bDontSimulateMotion=true
    bCollideWorld=false
    CollisionRadius=1
    CollisionHeight=1
    TickStyle=0
    PrePivot=(X=-2,Y=0,Z=0)
    Mesh='c_dnWeapon.TripMine'
    Skins(0)=none
    Skins(1)='mt_skins5.TripMine.tripmine2bc_armed'
    LifeSpan=0
    SoundVolume=48
    SoundRadius=400
    SoundInnerRadius=200
    VoicePack='SoundConfig.Inventory.VoicePack_TripMine'
}