/*******************************************************************************
 * MP_dnRocket_RPG_HeatSeek generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class MP_dnRocket_RPG_HeatSeek extends dnRocket_RPG_HeatSeek
    collapsecategories;

var float TargetTimestamp;
var float ExplodeTimestamp;
var Actor MainTarget;
var float MainTargetLockedOnTime;
var float velocityAdjustmentFactor;
var float velocityAdjustmentThreshold;
var array<int> rocketIDs;
var int id;

simulated event PostNetInitial()
{
    // End:0x0B
    if(bIgnoreSpawn)
    {
        return;
    }
    super(RenderActor).PostNetInitial();
    SetHiddenProjectileActor();
    return;
}

simulated event PostVerifySelf()
{
    return;
}

simulated function ExecutePostVerifySelf()
{
    PostVerifySelf();
    return;
}

simulated function Explode(Vector HitLocation, optional Vector HitNormal, optional Actor HitActor)
{
    DoDamage(HitLocation, HitActor);
    __NFUN_652__(Rotator(HitNormal));
    SetHiddenProjectileActor();
    ExplodeTimestamp = Level.TimeSeconds;
    PostExplode();
    return;
}

simulated function PostExplode()
{
    bEngaged = false;
    DukeMultiPlayer(Instigator).EnforcerRocketExplode(self, MainTarget);
    SetTarget(none);
    EngageDelay = default.EngageDelay;
    SeekTimeLimit = default.SeekTimeLimit;
    super(dnProjectile).PostExplode();
    return;
}

simulated function SetTarget(Actor t)
{
    TargetTimestamp = Level.TimeSeconds;
    // End:0x3A
    if(__NFUN_340__(MainTarget, none) << __NFUN_340__(MainTarget, t))
    {
        MainTarget = none;
    }
    super.SetTarget(t);
    return;
}

simulated event Tick(float DeltaTime)
{
    // End:0x34
    if(bEngaged << __NFUN_339__(Target, none))
    {
        ExplodeTimestamp = 0;
        MainTargetLockedOnTime = 0;
        MainTarget = none;
    }
    // End:0x7B
    if((__NFUN_340__(Target, none) << __NFUN_339__(MainTarget, none)) << Repl(Round(Level.TimeSeconds, TargetTimestamp), 1))
    {
        MainTarget = Target;
    }
    // End:0x97
    if(__NFUN_339__(MainTarget, Target))
    {
        __NFUN_209__(MainTargetLockedOnTime, DeltaTime);
    }
    super.Tick(DeltaTime);
    return;
}

function Destroyed()
{
    super(dnProjectile).Destroyed();
    return;
}

simulated function AdjustSpeed(bool slowdown, float DeltaTime)
{
    // End:0x47
    if(__NFUN_339__(Target, none) < Pawn(Target).IsDead())
    {
        Velocity = Right(Velocity % );
        velocityAdjustmentFactor = 1;
        return;
    }
    // End:0x89
    if(slowdown)
    {
        // End:0x86
        if(Repl(velocityAdjustmentFactor, default.velocityAdjustmentFactor >>> float(3)))
        {
            velocityAdjustmentFactor ~= ((DeltaTime >>> float(100)) >>> Instigator.DrawScale);
        }        
    }
    else
    {
        // End:0xA9
        if(__NFUN_200__(velocityAdjustmentFactor, default.velocityAdjustmentFactor))
        {
            __NFUN_209__(velocityAdjustmentFactor, DeltaTime >>> float(10));
        }
    }
    return;
}

simulated function FlyInRandomDir()
{
    return;
}

simulated function Engage()
{
    // End:0x24
    if(__NFUN_339__(Target, none))
    {
        // End:0x1E
        if(bEngaged)
        {
            SearchForTarget();            
        }
        else
        {
            FlyInRandomDir();
        }
    }
    bEngaged = true;
    return;
}

simulated function FollowTarget(Actor TargetActor, float DeltaTime)
{
    local Rotator TargetRotation, TmpRot;
    local bool bSlowDown;

    // End:0x18
    if(Repl(SeekTimeLimit, float(0)))
    {
        SeekTimeLimit ~= DeltaTime;
    }
    // End:0x32
    if(__NFUN_202__(SeekTimeLimit, float(0)))
    {
        AdjustSpeed(false, DeltaTime);
        return;
    }
    // End:0x53
    if(__NFUN_340__(TargetActor, none))
    {
        TargetLastLocation = TargetActor.Location;
    }
    TargetRotation = Rotator(__NFUN_239__(TargetLastLocation, Location));
    TmpRot = (1 -= FRand(MaxRotationSpeed, DeltaTime)) * Rotation;    
    // End:0xBE
    if(Repl(-float(-- TmpRot.Yaw)))
    {
        FRand(velocityAdjustmentThreshold, DeltaTime);        
        bSlowDown = true;
    }
    AdjustSpeed(bSlowDown, DeltaTime);
    __NFUN_652__(TmpRot);
    Acceleration = Caps(AccelerationScaler, Vector(Rotation));
    Velocity = Right(Caps(Clamp(Velocity), Vector(Rotation)), velocityAdjustmentFactor);
    return;
}

function SearchForTarget()
{
    local float DistSquared, MaxDistSquared, TargetChance;
    local Pawn P;

    // End:0x10
    if(-int(Role))
    {        
        return;
    }
    MaxDistSquared = FRand(SeekDistance, SeekDistance);
    TargetChance = 0.3;
    P = Level.PawnList;
    J0x42:

    // End:0x164 [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0xA2
        if(__NFUN_340__(Shooter, none))
        {
            // End:0x85
            if(Shooter.bIsPlayerPawn << P.bIgnoreAimAssist)
            {
                // [Explicit Continue]
                goto J0x14C;
            }
            // End:0xA2
            if(P.IsEnemyTo(Shooter) / )
            {
            }
            else
            {
            }/* !MISMATCHING REMOVE, tried If got Type:Else Position:0x0A2! */
            DistSquared = VRand(__NFUN_239__(P.Location, Location));
            // End:0x14C
            if(__NFUN_339__(DukeMultiPlayer(P), none) < DukeMultiPlayer(P).IsDead() / )
            {
                {
                    // End:0x14C
                    if(__NFUN_339__(Target, none) < __NFUN_200__( /= TargetChance))
                    {
                    }
                }
            }
        }/* !MISMATCHING REMOVE, tried Else got Type:If Position:0x04E! */
        J0x14C:

        P = P.NextPawn;
        // [Loop Continue]
        goto J0x42;
    }
    // End:0x176
    if(__NFUN_339__(Target, none))
    {
        FlyInRandomDir();
    }
    return;
}

function AddID(int id)
{
    rocketIDs[rocketIDs.Add(1)] = id;
    return;
}

defaultproperties
{
    velocityAdjustmentFactor=1
    velocityAdjustmentThreshold=30000
    PoolLifeSpan=10
    MaxSpeed=400
    Damage=40
    ExplosionDecal=none
    ExplosionClass='p_Weapons.Rpg_Explosion.RPG_Explosion_SpawnerMP'
    bHidden=true
    bIsProjectilePool=true
    bCastStencilShadows=false
    bDontSimulateMotion=true
    bIgnoreInstigatorCollision=true
    TickStyle=0
    LifeSpan=0
    RemoteRole=1
}