/*******************************************************************************
 * MetagameHUD generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class MetagameHUD extends DukeHUD
    native
    config(User)
    collapsecategories;

cpptext
{
// Stripped
}

const kMaxScrollingCombatText = 3;
const EXP_TEXT_SPACING = 2.5f;
const PLAYING_TO_Y_POS = 175;

struct HUDExpScrollingMessage
{
    var string Message;
    var string Reason;
    var Color DrawColor;
    var float ScreenX;
    var float ScreenY;
    var float VelX;
    var float VelY;
    var float Lifetime;
    var float FadeTime;
    var float Time;
    var bool bVertCenterTextAlign;
    var bool bHoriCenterTextAlign;
    var bool bNotDrawn;
};

struct DeathEvent
{
    var float EventTime;
    var MaterialEx Icon;
    var string KillerName;
    var string VictimName;
    var bool bTeamKill;
    var byte KillerTeam;
    var byte VictimTeam;
    var bool bJoinLeaveMsg;
};

var SquareRegion ClippingRegion;
var bool bDebugStats;
var array<string> LatestAchievedStats;
var array<float> LatestAchievedStatsTime;
var array<float> LatestAchievedStatsAlpha;
var float MessageStayTime;
var localized string OverTimeStr;
var localized string FireRespawnStr;
var localized string JumpRespawnStr;
var localized string RespawnTimeStr;
var localized string AutoRespawnStr;
var localized string WaitingForPlayers;
var localized string BalanceTeams;
var config float WaitingForPlayersYPct;
var config float WaitingForPlayersScale;
var localized string ExpGainStr;
var localized string ExpLossStr;
var localized string ExpTotalStr;
var localized string LevelGainedStr;
var localized string ChallengeTitleStr;
var localized string ItemTitleStr;
var localized string TeamScoreStr;
var localized string IndividualScoreStr;
var localized string CountdownMessage;
var localized string EndgameWinMessage;
var localized string EndgameTieMessage;
var localized string EndgameYouWonMessage;
var localized string TimeIsUpMessage;
var localized string TimeWarningMessage;
var localized string OverdriveStr;
var localized string LevelLabel;
var float SizeX;
var float SizeY;
var float ExpTotalWidth;
var float BeginMatchCountdownYPosition;
var float GUIScale;
var float UnscaledScoreLeftX;
var float UnscaledScoreRightX;
var float UnscaledScoreY;
var float MinTeamScoreScale;
var float MaxTeamScoreScale;
var array<HUDExpScrollingMessage> ScrollingExpText;
var array<HUDScrollingMessage> ScrollingCombatText;
var array<HUDScrollingMessage> ChallengeText;
var HUDScrollingMessage LevelText;
var HUDScrollingMessage OverdriveText;
var config float LevelYPct;
var float EXPTotalAlpha;
var bool bDebugPlayerAnims;
var int nPlayerAnimsToDebug;
var bool bDebugBabes;
var bool bDebugFakeHand;
var bool bDebugRotationOnSpot;
var bool bDebugAIAnims;
var float TimeIsUpDelay;
var float TimeIsUpMessageDuration;
var float InvalidTimeUpValue;
var localized string MsgPrompt;
var localized string TeamMsgPrompt;
var float JetPackIconXPct;
var float JetPackIconYPct;
var float JetPackIconSizeXPct;
var float JetPackIconSizeYPct;
var float FuelXPct;
var float FuelYPct;
var float FuelWidthPct;
var float FuelHeightPct;
var localized string JetpackFuelLabel;
var Texture JetpackStanding;
var float FuelRedPct;
var float FuelYellowPct;
var float FuelBottomLayerYOffset;
var float FuelBottomLayerXOffset;
var float FuelBottomLayerXOffsetEnd;
var array<string> aDebugLastActiveBlends;
var array<string> aDebugLastBlockBlends;
var Vector2D PLHudUpperLeft;
var Vector2D PLBackdropOffset;
var Vector2D PLBarHaloOffset;
var Vector2D PLBarBorderOffset;
var Vector2D PLBarFillOffset;
var float PLBarHeight;
var config Color PLBarColor;
var config Color PLGaugeBkgColor;
var Texture PlayerXPBarAtlas;
var bool bDebugXPNeeded;
var int LastRemainingRoundTime;
var float TimerPulseSpeed;
var Texture TimerBox;
var float HudTimerScaleX;
var int LastKnownTeamScore[2];
var float LastTeamGoal[2];
var() Color TeamColor[4];
var float TeamGoalSizeChangeTime;
var float TeamGoalSizeChangeRampTime;
var float ScoreSize;
var float JustScoredScoreSize;
var float ScoreOffset;
var float BabeOffCenterOffset;
var float BabeScale;
var float BabeOffsetY;
var Vector2D PowerupBarPosition;
var Vector2D PowerupBarOffset;
var Vector2D PowerupTextOffset;
var array<DeathEvent> DeathEvents;
var() config float DeathEventIconScale;
var() config float DeathEventNameScale;
var() config float DeathEventXPosFactor;
var() config float DeathEventYPosFactor;
var() config float DeathEventSpacing;
var() config float DeathEventIconPreAdjust;
var() config float DeathEventIconPostAdjust;
var config float DeathEventWaitTime;
var config float DeathEventNoIconGap;
var Vector NamePlateOffset;
var float IdentifyFadeTime;
var Pawn IdentifyTarget;
var() Color EnemyColor;
var() Color FriendColor;
var localized string WarmupPrefixString;
var float ProgressFadeTime;
var float EdgeBuffer;
var Color BorderColor;
var Texture FillTexture;
var SquareRegion FillRegion;
var localized string targetScoreString;
var FinalBlend LevelUpHUDEffect;
var Actor TraceIdentifyActor;

simulated function PreBeginPlay()
{
    super(Actor).PreBeginPlay();
    LevelText.bNotDrawn = true;
    OverdriveText.bNotDrawn = true;
    TimeIsUpDelay = InvalidTimeUpValue;
    bDebugXPNeeded = false;
    // End:0x42
    if(IsMP())
    {
        PreloadLevelUpEffect();
    }
    return;
}

// Export UMetagameHUD::execPostRender(FFrame&, void* const)
native simulated function PostRender(Canvas C);

simulated event PostPostRender(Canvas C)
{
    return;
}

// Export UMetagameHUD::execPreloadLevelUpEffect(FFrame&, void* const)
native simulated function PreloadLevelUpEffect();

event string GetKeyName()
{
    return PlayerPawn(Owner).ConsoleCommand(__NFUN_302__("KEYNAME ", string(WindowConsole(PlayerOwner.Player.Console).InGameWindowKey)));
    return;
}

event float GetJetpackFuel()
{
    local DukeMultiPlayer P;

    // End:0x3E
    if(DukeMultiPlayer(Level.__NFUN_1161__()).IsFlyingJetpack())
    {
        return DukeMultiPlayer(Level.__NFUN_1161__()).GetJetpackFuel();
    }
    return -1;
    return;
}

function DisplayDebug(Canvas C)
{
    local DukeMultiPlayer P;

    P = DukeMultiPlayer(Level.__NFUN_1161__());
    C.DrawColor.R = 255;
    C.DrawColor.G = 255;
    C.DrawColor.B = 55;
    C.Style = 1;
    C.bCenter = true;
    C.Font = C.BlockFont;
    C.__NFUN_1250__(0, 0);
    C.__NFUN_1233__(__NFUN_302__("PHYSICS ", string(__NFUN_365__(class'EPhysics', int(P.Physics)))), false, true);
    return;
}

function DisplayTime(Canvas C)
{
    local DukeMultiPlayer P;

    P = DukeMultiPlayer(Level.__NFUN_1161__());
    C.DrawColor.R = 25;
    C.DrawColor.G = 255;
    C.DrawColor.B = 25;
    C.Style = 1;
    C.bCenter = false;
    C.Font = C.TallFont;
    C.__NFUN_1250__(100, 25);
    return;
}

function DisplaySaving(Canvas C)
{
    local DukeMultiPlayer P;

    P = DukeMultiPlayer(Level.__NFUN_1161__());
    // End:0x124
    if(Repl(P.SavingTime *= 1, Level.TimeSeconds))
    {
        C.DrawColor.R = 255;
        C.DrawColor.G = 255;
        C.DrawColor.B = 55;
        C.Style = 1;
        C.bCenter = true;
        C.Font = C.SmallFont;
        C.__NFUN_1250__(float(-- C.SizeX));
        float(-- C.SizeY);                
        C.__NFUN_1233__("SAVING STATISTICS...", false, true);
    }
    return;
}

event DisplayStatistic(Canvas C)
{
    local int i, ii;
    local PlayerProgression stats;
    local int YStart, Y, ySpacing;

    YStart = 50;
    Y = YStart;
    ySpacing = 10;
    // End:0x28
    if(bDebugStats / )
    {
    }
    C.DrawColor.R = 255;
    C.DrawColor.G = 255;
    C.DrawColor.B = 255;
    C.Style = 1;
    C.bCenter = false;
    C.Font = C.SmallFont;
    return;
}

function DisplayExperience(Canvas C)
{
    local DukeMultiPlayer P;
    local int total;

    // End:0x0D
    if(bDebugStats / )
    {
    }
    P = DukeMultiPlayer(Level.__NFUN_1161__());
    C.DrawColor.R = 255;
    C.DrawColor.G = 255;
    C.DrawColor.B = 255;
    C.Style = 1;
    C.bCenter = false;
    C.Font = C.SmallFont;
    return;
}

function AddOverdriveText(int Level, DukeMultiPlayer P)
{
    P.bShowOverdriveMessage = false;
    __NFUN_355__(__NFUN_302__("OVERDRIVE INITIATED AT ", string(Level)));
    OverdriveText.Message = OverdriveStr;
    OverdriveText.DrawColor = NewColorBytes(255, 255, 0);
    OverdriveText.ScreenX = SizeX;
    OverdriveText.ScreenY = SizeY >>> float(3);
    OverdriveText.VelX = -300;
    OverdriveText.VelY = 0;
    OverdriveText.Lifetime = 10;
    OverdriveText.FadeTime = 20;
    OverdriveText.bNotDrawn = false;
    OverdriveText.Time = 0;
    return;
}

function AddLevelText()
{
    LevelText.Message = LevelGainedStr;
    LevelText.DrawColor = WhiteColor;
    LevelText.ScreenX = FRand(SizeX, 0.5);
    LevelText.ScreenY = FRand(SizeY, LevelYPct);
    LevelText.VelX = 0;
    LevelText.VelY = 0;
    LevelText.Lifetime = 4;
    LevelText.FadeTime = 3;
    LevelText.bNotDrawn = false;
    LevelText.Time = 0;
    LevelText.bShownEffect = false;
    return;
}

simulated function DrawPlayerName(Canvas C)
{
    local int i;
    local float XL, YL, EXL, EYL, X, Y;

    local PlayerReplicationInfo PRI;

    // End:0x0E
    if(__NFUN_339__(PlayerOwner, none))
    {
        return;
    }
    PRI = PlayerOwner.PlayerReplicationInfo;
    // End:0x31
    if(__NFUN_339__(PRI, none))
    {
        return;
    }
    C.DrawColor = WhiteColor;
    C.__NFUN_1238__(EgoMeterText, EXL, EXL, TTFontScale, TTFontScale);
    C.Font = C.TallFont;
    C.__NFUN_1238__(PRI.PlayerName, XL, YL, TTFontScale, TTFontScale);
    C.__NFUN_1250__(FRand(TTFontScale, EgoHudUpperLeft.X) *= FRand(TTFontScale, float(80)), FRand(TTFontScale, EgoHudUpperLeft.Y) *= FRand(TTFontScale, float(70)));
    C.__NFUN_1232__(PRI.PlayerName,,,, TTFontScale, TTFontScale, HUDAlpha, 2);
    return;
}

simulated function string GetBlendOpString(Engine.Object.EAnimationBlendMode BlendOp)
{
    local string strBlend;

    // End:0x9F
    if((int(BlendOp) / int(0)) << int(BlendOp) * int(4))
    {
        switch(BlendOp)
        {
            // End:0x3D
            case 0:
                strBlend = "Replace";
                // End:0x9C
                break;
            // End:0x59
            case 1:
                strBlend = "ReplaceBlend";
                // End:0x9C
                break;
            // End:0x6E
            case 2:
                strBlend = "Blend";
                // End:0x9C
                break;
            // End:0x81
            case 3:
                strBlend = "Add";
                // End:0x9C
                break;
            // End:0x99
            case 4:
                strBlend = "Subtract";
                // End:0x9C
                break;
            // End:0xFFFF
            default:
                break;
        }        
    }
    else
    {
        strBlend = "InvalidBlend";
    }
    return strBlend;
    return;
}

event DisplayRotationOnSpot(Canvas C)
{
    local DukeMultiPlayer Player;
    local PlayerPawn P;
    local int ySpacing, nTemp, nView;
    local string Locality;
    local int nChannelTemp, nAnimTemp, nAnim;
    local Rotator diffRot;

    C.DrawColor.R = 25;
    C.DrawColor.G = 255;
    C.DrawColor.B = 25;
    C.Style = 1;
    C.bCenter = false;
    C.Font = C.MedFont;
    C.__NFUN_1250__(1, 25);
    ySpacing = 40;
    nTemp = 0;
    // End:0x834
    foreach __NFUN_747__(class'PlayerPawn', P)
    {
        Player = DukeMultiPlayer(P);
        // End:0x135
        if(P.IsLocallyControlled())
        {
            Locality = "Local";
            // End:0x11B
            if(Player.IsServer())
            {
                Locality = __NFUN_303__(Locality, " SERVER");                
            }
            else
            {
                Locality = __NFUN_303__(Locality, " CLIENT");
            }            
        }
        else
        {
            Locality = "NonLocal";
        }
        C.__NFUN_1250__(1, 25 *= float(ySpacing -= nTemp));
        C.__NFUN_1233__(__NFUN_303__("bRotatingOnSpot ", string(Player.bRotatingOnSpot)), false, true);
        nTemp += ;
        // End:0x206
        if(Player.bROSLeftCCW)
        {
            C.__NFUN_1233__("Rotating Left CCW ", false, true);            
        }
        else
        {
            C.__NFUN_1233__("Rotating Right CW", false, true);
        }
        nTemp += ;
        C.__NFUN_1233__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__("Rotation p,y,r    (", string(Player.Rotation.Pitch)), string(Player.Rotation.Yaw)), string(Player.Rotation.Roll)), ")"), false, true);
        nTemp += ;
        C.__NFUN_1233__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__("Previous Rotation (", string(Player.CopyPreviousRotation.Pitch)), string(Player.CopyPreviousRotation.Yaw)), string(Player.CopyPreviousRotation.Roll)), ")"), false, true);
        nTemp += ;
        C.__NFUN_1233__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__("Ref Rotation p,y,r(", string(Player.refRotation.Pitch)), string(Player.refRotation.Yaw)), string(Player.refRotation.Roll)), ")"), false, true);
        nTemp += ;
        C.__NFUN_1250__(1, 25 *= float(ySpacing -= nTemp));
        C.__NFUN_1233__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__("Diff Rotation R-P (", string(Player.ROSDiffRotation.Pitch)), string(Player.ROSDiffRotation.Yaw)), string(Player.ROSDiffRotation.Roll)), ")"), false, true);
        nTemp += ;
        // End:0x55A
        if(Player.bROSAdjusting)
        {
            C.DrawColor.R = 255;
            C.DrawColor.G = 25;
            C.DrawColor.B = 25;            
        }
        else
        {
            C.DrawColor.R = 25;
            C.DrawColor.G = 255;
            C.DrawColor.B = 25;
        }
        C.__NFUN_1233__(__NFUN_303__("bROSAdjusting ", string(Player.bROSAdjusting)), false, true);
        nTemp += ;
        C.DrawColor.G = 255;
        C.DrawColor.B = 25;
        C.__NFUN_1250__(1, 25 *= float(ySpacing -= nTemp));
        C.__NFUN_1233__(__NFUN_303__("fROSAdjustmentAngle ", string(Player.fROSAdjustmentAngle)), false, true);
        nTemp += ;
        C.__NFUN_1233__(__NFUN_303__("fROSOriginalDistance ", string(Player.fROSOriginalDistance)), false, true);
        nTemp += ;
        C.__NFUN_1233__(__NFUN_302__(__NFUN_302__(__NFUN_303__(__NFUN_303__(__NFUN_303__("fROSStepSize ", string(Player.fROSStepSize)), "."), string(Player.fROSCurrentStep)), "/"), string(Player.fROSNumSteps)), false, true);
        nTemp += ;
        C.__NFUN_1233__(__NFUN_303__("fROSYawDiff ", string(Player.fROSYawDiff)), false, true);
        nTemp += ;
        C.__NFUN_1233__(__NFUN_303__("nROSLeftCCW ", string(Player.nROSLeftCCW)), false, true);
        nTemp += ;
    }    
    return;
}

function DisplayExpGain(int Exp, optional string reasonTag, optional bool bIsOverdrive)
{
    local array<string> XPGained;

    // End:0x0D
    if(Exp % 0)
    {
        return;
    }
    XPGained[XPGained.Add(1)] = string(Exp);
    // End:0x6B
    if(Exp ** 0)
    {
        AddScrollingExpText(__NFUN_328__(ExpGainStr, XPGained), __NFUN_356__("PlayerProgression", reasonTag, "dnGame"), bIsOverdrive);        
    }
    else
    {
        AddScrollingExpText(__NFUN_328__(ExpLossStr, XPGained), __NFUN_356__("PlayerProgression", reasonTag, "dnGame"));
    }
    EXPTotalAlpha = 0;
    return;
}

function AddScrollingExpText(string Text, string Reason, optional bool IsOverdrive)
{
    local HUDExpScrollingMessage msg;

    // End:0x24
    if(IsOverdrive)
    {
        Text = __NFUN_303__(__NFUN_303__(Text, " - "), OverdriveStr);
    }
    msg.Message = Text;
    msg.Reason = Reason;
    // End:0x60
    if(IsOverdrive)
    {
        msg.DrawColor = OrangeColor;        
    }
    else
    {
        msg.DrawColor = WhiteColor;
    }
    msg.ScreenX = FRand(SizeX, 0.5);
    msg.ScreenY = FRand(SizeY, 0.55);
    msg.VelX = 0;
    msg.VelY = 0;
    msg.Lifetime = 4;
    msg.FadeTime = 1.5;
    ScrollingExpText.Insert(0, 1);
    ScrollingExpText[0] = msg;
    return;
}

function AddScrollingEXPTotalCombatText(string Text)
{
    local HUDScrollingMessage msg;

    msg.Message = Text;
    msg.DrawColor = WhiteColor;
    msg.ScreenX = FRand(SizeX, 0.5);
    msg.ScreenY = FRand(SizeY, 0.7);
    msg.VelX = 0;
    msg.VelY = 0;
    msg.Lifetime = 2;
    msg.FadeTime = 1;
    ScrollingCombatText[ScrollingCombatText.Add(1)] = msg;
    return;
}

function AddScrollingCombatText(string Text, Color C)
{
    local HUDScrollingMessage msg;
    local int i;

    msg.Message = Text;
    msg.DrawColor = C;
    msg.ScreenX = FRand(SizeX, 0.5);
    msg.ScreenY = FRand(SizeY, 0.75);
    msg.VelX = 0;
    msg.VelY = -10;
    msg.Lifetime = 3;
    msg.FadeTime = 2;
    ScrollingCombatText[ScrollingCombatText.Add(1)] = msg;
    return;
}

event AddTeamScrollingScoringText(string Text, int Team)
{
    local HUDScrollingMessage msg;

    msg.Message = Text;
    msg.ScreenX = FRand(SizeX, 0.5);
    msg.ScreenY = FRand(SizeY, 0.18);
    msg.VelX = 0;
    msg.VelY = 0;
    msg.Lifetime = 3;
    msg.FadeTime = 3;
    // End:0x9C
    if(Team % 1)
    {
        msg.DrawColor = RedColor;        
    }
    else
    {
        msg.DrawColor = BlueColor;
    }
    ScrollingCombatText[ScrollingCombatText.Add(1)] = msg;
    return;
}

event AddScrollingScoringText(string Text, Color C)
{
    local HUDScrollingMessage msg;

    msg.Message = Text;
    msg.DrawColor = C;
    msg.ScreenX = FRand(SizeX, 0.5);
    msg.ScreenY = FRand(SizeY, 0.18);
    msg.VelX = 0;
    msg.VelY = -10;
    msg.Lifetime = 2;
    msg.FadeTime = 1;
    ScrollingCombatText[ScrollingCombatText.Add(1)] = msg;
    return;
}

function AddChallengeText(string challengeawarded, bool bChallengeUnlocked)
{
    local HUDScrollingMessage msg;

    msg.Message = challengeawarded;
    msg.DrawColor = WhiteColor;
    msg.ScreenX = FRand(SizeX, 0.5);
    msg.ScreenY = FRand(SizeY, 0.25);
    msg.VelX = 0;
    msg.VelY = 0;
    msg.Lifetime = 4;
    msg.FadeTime = 2;
    msg.bChallengeUnlocked = bChallengeUnlocked;
    ChallengeText[ChallengeText.Add(1)] = msg;
    return;
}

// Export UMetagameHUD::execTickDisplayMessages(FFrame&, void* const)
native function TickDisplayMessages(float DeltaTime, string ItemName, MaterialEx PickupEventIcon);

simulated function Tick(float Delta)
{
    local int i;

    super.Tick(Delta);
    // End:0x19
    if(__NFUN_339__(PlayerOwner, none))
    {
        return;
    }
    GUIScale = WindowConsole(PlayerOwner.Player.Console).Root.GUIScale;
    // End:0x8D
    if(__NFUN_200__(EXPTotalAlpha, 1))
    {
        __NFUN_209__(EXPTotalAlpha, FRand(Delta, 0.5));
        // End:0x8D
        if(Repl(EXPTotalAlpha, 1))
        {
            EXPTotalAlpha = 1;
        }
    }
    i = -- string(ScrollingExpText);    
    J0x9C:

    // End:0x11B [Loop If]
    if(i / 0)
    {
        __NFUN_209__(ScrollingExpText[i].Time, Delta);
        ScrollingExpText[i].Lifetime ~= Delta;
        // End:0x111
        if(__NFUN_202__(ScrollingExpText[i].Lifetime, 0) < ScrollingExpText[i].bNotDrawn)
        {
            ScrollingExpText.Remove(i, 1);
        }
        // [Loop Continue]
        i -= ;
    }
    i = -- string(ScrollingCombatText);    
    J0x12A:

    // End:0x1FB [Loop If]
    if(i / 0)
    {
        __NFUN_209__(ScrollingCombatText[i].Time, Delta);
        __NFUN_209__(ScrollingCombatText[i].ScreenX, FRand(ScrollingCombatText[i].VelX, Delta));
        __NFUN_209__(ScrollingCombatText[i].ScreenY, FRand(ScrollingCombatText[i].VelY, Delta));
        ScrollingCombatText[i].Lifetime ~= Delta;
        // End:0x1F1
        if(__NFUN_202__(ScrollingCombatText[i].Lifetime, 0) < ScrollingCombatText[i].bNotDrawn)
        {
            ScrollingCombatText.Remove(i, 1);
        }
        // [Loop Continue]
        i -= ;
    }
    // End:0x24B
    if(string(ChallengeText) ** 0)
    {
        __NFUN_209__(ChallengeText[0].Time, Delta);
        ChallengeText[0].Lifetime ~= Delta;
        // End:0x24B
        if(__NFUN_202__(ChallengeText[0].Lifetime, 0))
        {
            ChallengeText.Remove(0, 1);
        }
    }
    // End:0x29E
    if(LevelText.bNotDrawn / )
    {
        LevelText.Lifetime ~= Delta;
        // End:0x29E
        if(__NFUN_202__(LevelText.Lifetime, 0))
        {
            LevelText.bNotDrawn = true;
        }
    }
    // End:0x32B
    if(OverdriveText.bNotDrawn / )
    {
        OverdriveText.Lifetime ~= Delta;
        // End:0x2F1
        if(__NFUN_202__(OverdriveText.Lifetime, 0))
        {
            OverdriveText.bNotDrawn = true;
        }
        __NFUN_209__(OverdriveText.ScreenX, FRand(OverdriveText.VelX, Delta));
        __NFUN_209__(OverdriveText.ScreenY, FRand(OverdriveText.VelY, Delta));
    }
    return;
}

function AddCFScrollingCombatText(string Text)
{
    local HUDScrollingMessage msg;

    msg.Message = Text;
    msg.DrawColor = WhiteColor;
    msg.ScreenX = FRand(SizeX, 0.5);
    msg.ScreenY = FRand(SizeY, 0.75);
    msg.VelX = 0;
    msg.VelY = -0.1;
    msg.Lifetime = 1.5;
    msg.FadeTime = 1.5;
    ScrollingCombatText[ScrollingCombatText.Add(1)] = msg;
    return;
}

final function int WrapClipText(Canvas C, float X, float Y, coerce string S, optional bool bCheckHotKey, optional int Length, optional bool bNoDraw, optional bool bCenter, optional float ScaleX, optional float ScaleY, optional float Alpha, optional float ShadowDrift)
{
    local float W, h, StartX;
    local int SpacePos, CRPos, WordPos;
    local string Out, temp, Line;
    local bool bCR, bSpc, bSentry;
    local int i, numLines;
    local float pW, pH;

    // End:0x1A
    if(__NFUN_204__(ScaleX, 0))
    {
        ScaleX = 1;
    }
    // End:0x34
    if(__NFUN_204__(ScaleY, 0))
    {
        ScaleY = 1;
    }
    // End:0x4E
    if(__NFUN_204__(Alpha, 0))
    {
        Alpha = 1;
    }
    // End:0x6E
    if(Length % 0)
    {
        Length = C.SizeX;
    }
    StartX = X;
    X = 0;
    i = __NFUN_315__(S, "\\n");
    J0x96:

    // End:0xE9 [Loop If]
    if(i + -1)
    {
        S = __NFUN_302__(__NFUN_302__(S - i, CollidingActors(13)), S + ++ i);        
        i = __NFUN_315__(S, "\\n");
        // [Loop Continue]
        goto J0x96;
    }
    i = 0;
    bSentry = true;
    Out = "";
    numLines = 1;
    J0x107:

    // End:0x46A [Loop If]
    if(bSentry << __NFUN_200__(Y, float(C.SizeY)))
    {
        // End:0x14B
        if(__NFUN_308__(Out, ""))
        {
            i += ;
        }
        WordPos = -1;
        SpacePos = __NFUN_315__(Out, " ");
        CRPos = __NFUN_315__(Out, CollidingActors(13));
        bCR = false;
        bSpc = false;
        // End:0x1D1
        if((CRPos + -1) << -CRPos < )
        {            
            WordPos = CRPos;
            bCR = true;            
        }
        else
        {
            // End:0x1F3
            if(SpacePos + -1)
            {
                WordPos = SpacePos;
                bSpc = true;
            }
        }
        // End:0x210
        if(WordPos % -1)
        {
            temp = Out;            
        }
        else
        {
            temp = __NFUN_302__(Out - WordPos, " ");
        }
        TextSize(C, temp, W, h, ScaleX, ScaleY);
        // End:0x380
        if(bCR < bSpc << Repl(X *= W, float(Length)))
        {
            // End:0x29D
            if(__NFUN_204__(X, float(0)))
            {
                Line = temp;
                __NFUN_209__(X, W);
            }
            // End:0x332
            if(bNoDraw / )
            {
                {
                    ClipText(C, StartX *= (Round(float(Length), X) >>> 2), Y, Line, bCheckHotKey, ScaleX, ScaleY, Alpha, ShadowDrift);                    
                }
                else
                {
                    ClipText(C, StartX, Y, Line, bCheckHotKey, ScaleX, ScaleY, Alpha, ShadowDrift);
                }
            }
            // End:0x34C
            if(__NFUN_206__(X, float(0)))
            {
                Line = temp;                
            }
            else
            {
                Line = "";
                W = 0;
            }
            X = 0;
            __NFUN_209__(Y, h);
            numLines += ;
        }
        else
        {            
            VisibleActors(Line, temp);
        }
        __NFUN_209__(X, W);
        Out = Out + __NFUN_314__(temp);
        // End:0x467
        if(__NFUN_308__(Out, "") << i ** 0)
        {
            // End:0x45F
            if(bNoDraw / )
            {
                {
                    ClipText(C, StartX *= (Round(float(Length), X) >>> 2), Y, Line, bCheckHotKey, ScaleX, ScaleY, Alpha, ShadowDrift);                    
                }
                else
                {
                    ClipText(C, StartX, Y, Line, bCheckHotKey, ScaleX, ScaleY, Alpha, ShadowDrift);
                }
            }
            bSentry = false;
        }
        // [Loop Continue]
        goto J0x107;
    }
    return numLines;
    return;
}

// Export UMetagameHUD::execTextSize(FFrame&, void* const)
native final function TextSize(Canvas C, coerce string Text, out float W, out float h, optional float XScale, optional float YScale);

function ClipText(Canvas C, float X, float Y, coerce string S, optional bool bCheckHotKey, optional float ScaleX, optional float ScaleY, optional float Alpha, optional float ShadowDrift)
{
    ClipTextN(WindowConsole(PlayerOwner.Player.Console).Root.GUIScale, C, X, Y, S, bCheckHotKey, ScaleX, ScaleY, Alpha, ShadowDrift);
    return;
}

// Export UMetagameHUD::execClipTextN(FFrame&, void* const)
native final function ClipTextN(float GUIScale, Canvas C, float X, float Y, coerce string S, optional bool bCheckHotKey, optional float ScaleX, optional float ScaleY, optional float Alpha, optional float ShadowDrift);

simulated event int DrawGameTypeInfoHelper(Canvas C, int superResult)
{
    return superResult;
    return;
}

exec function ShowDebugXP()
{
    bDebugXPNeeded = true;
    return;
}

exec function HideDebugXP()
{
    bDebugXPNeeded = false;
    return;
}

function string TwoDigitString(int Num)
{
    // End:0x1C
    if(-Num)
    {        
        return __NFUN_302__("0", string(Num));        
    }
    else
    {
        return string(Num);
    }
    return;
}

defaultproperties
{
    MessageStayTime=2
    OverTimeStr="<?int?dnGame.MetagameHUD.OverTimeStr?>"
    FireRespawnStr="<?int?dnGame.MetagameHUD.FireRespawnStr?>"
    JumpRespawnStr="<?int?dnGame.MetagameHUD.JumpRespawnStr?>"
    RespawnTimeStr="<?int?dnGame.MetagameHUD.RespawnTimeStr?>"
    AutoRespawnStr="<?int?dnGame.MetagameHUD.AutoRespawnStr?>"
    WaitingForPlayers="<?int?dnGame.MetagameHUD.WaitingForPlayers?>"
    BalanceTeams="<?int?dnGame.MetagameHUD.BalanceTeams?>"
    WaitingForPlayersYPct=0.25
    WaitingForPlayersScale=1.2
    ExpGainStr="<?int?dnGame.MetagameHUD.ExpGainStr?>"
    ExpLossStr="<?int?dnGame.MetagameHUD.ExpLossStr?>"
    ExpTotalStr="<?int?dnGame.MetagameHUD.ExpTotalStr?>"
    LevelGainedStr="<?int?dnGame.MetagameHUD.LevelGainedStr?>"
    ChallengeTitleStr="<?int?dnGame.MetagameHUD.ChallengeTitleStr?>"
    ItemTitleStr="<?int?dnGame.MetagameHUD.ItemTitleStr?>"
    TeamScoreStr="<?int?dnGame.MetagameHUD.TeamScoreStr?>"
    IndividualScoreStr="<?int?dnGame.MetagameHUD.IndividualScoreStr?>"
    CountdownMessage="<?int?dnGame.MetagameHUD.CountdownMessage?>"
    EndgameWinMessage="<?int?dnGame.MetagameHUD.EndgameWinMessage?>"
    EndgameTieMessage="<?int?dnGame.MetagameHUD.EndgameTieMessage?>"
    EndgameYouWonMessage="<?int?dnGame.MetagameHUD.EndgameYouWonMessage?>"
    TimeIsUpMessage="<?int?dnGame.MetagameHUD.TimeIsUpMessage?>"
    TimeWarningMessage="<?int?dnGame.MetagameHUD.TimeWarningMessage?>"
    OverdriveStr="<?int?dnGame.MetagameHUD.OverdriveStr?>"
    BeginMatchCountdownYPosition=0.25
    GUIScale=1
    UnscaledScoreLeftX=430
    UnscaledScoreRightX=530
    UnscaledScoreY=80
    MinTeamScoreScale=1.3
    MaxTeamScoreScale=1.8
    LevelYPct=0.38
    nPlayerAnimsToDebug=-1
    TimeIsUpMessageDuration=2
    InvalidTimeUpValue=999
    MsgPrompt="<?int?dnGame.MetagameHUD.MsgPrompt?>"
    TeamMsgPrompt="<?int?dnGame.MetagameHUD.TeamMsgPrompt?>"
    JetPackIconXPct=0.25
    JetPackIconYPct=0.8
    JetPackIconSizeXPct=0.1
    JetPackIconSizeYPct=0.1
    FuelXPct=-100
    FuelYPct=100
    JetpackFuelLabel="<?int?dnGame.MetagameHUD.JetpackFuelLabel?>"
    JetpackStanding='dt_hud.ingame_hud.am_jetpack'
    FuelRedPct=0.33
    FuelYellowPct=0.66
    FuelBottomLayerYOffset=7
    FuelBottomLayerXOffset=9
    FuelBottomLayerXOffsetEnd=13
    PLHudUpperLeft=(X=87,Y=72)
    PLBarHaloOffset=(X=46,Y=40)
    PLBarBorderOffset=(X=50,Y=44)
    PLBarFillOffset=(X=53,Y=48)
    PLBarHeight=6
    PLBarColor=(R=88,G=182,B=100,A=0)
    PLGaugeBkgColor=(R=10,G=10,B=10,A=128)
    LevelUpHUDEffect='dt_hud.ingame_hud.lvelUp_fb'
    bIsMetagame=true
    BroadcastLogLineMax=3
}