/*******************************************************************************
 * PlayerProgression generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class PlayerProgression extends Info
    native
    nativereplication
    config(PlayerProgressInfo)
    collapsecategories
    dependson(dnCaptureTheBabe)
    dependson(dnDeathmatchGame_TeamDM)
    dependson(dnTeamInfo)
    dependson(MP_LaserMine)
    dependson(MP_dnRocket_RPG_Homing)
    dependson(MP_dnRocket_RPG_HeatSeek)
    dependson(dnRocket_RPG_Homing)
    dependson(dnDeathmatchGame)
    dependson(MP_Announcer)
    hidecategories(movement,Collision,Lighting,LightColor)
    nativedestructor;

struct SEnforcerChallenge
{
    var int id;
    var Actor Target;
    var float ExplodeTime;
    var array<int> friends;
    var bool bComplete;
    var int CompleteID;
};

struct SEndGamePacket
{
    var int Stat_NoDeaths;
    var int Stat_DeathMatchWins;
    var int Stat_DeathMatchLosses;
    var int Stat_DMLast;
    var int Stat_TeamDeathMatchWins;
    var int Stat_TDMTopWinner;
    var int Stat_TDMBottomWinner;
    var int Stat_TeamDeathMatchLosses;
    var int Stat_TDMTopLoser;
    var int Stat_TDMBottomLoser;
    var int Stat_CTBWins;
    var int Stat_CTBLosses;
    var int Stat_MostCapturesInMatch;
    var int Stat_WinningCaptures;
    var int Stat_HTTKWins;
    var int Stat_HTTKLosses;
    var int Stat_HTTKTopLoser;
    var int Stat_HTTKBottomLoser;
};

var bool bDebug;
var const editconst transient nontrans pointer StatMap;
var const editconst transient nontrans pointer ChallengeStorage;
var const editconst transient nontrans pointer BackupChallengeStorage;
var array<int> AwardedChallengesInMatch;
var int TotalXP;
var netupdate(NU_MatchXP) int MatchXP;
var int ScreenMatchXP;
var netupdate(NU_CurrentLevel) int CurrentLevel;
var config int OverDriveLevel;
var config float OverDriveModifier;
var bool bSeenOverdriveMsg;
var config int MaxOverDriveLevel;
var bool bHasLeveled;
var Engine.Object.EMGametype CurrentGameType;
var int MultiKillCount;
var float LastKillTime;
var int LongestCurrentStreak;
var float FallingDistance;
var float InAirStatUpdateTime;
var float TimeInAir;
var float LastTimeInAirCheck;
var bool bFrozenCandidate;
var bool bShrunkCandidate;
var float SprintStartTime;
var Vector SprintStartLocation;
var float DuckTime;
var float JetpackTime;
var bool bJetpackOn;
var bool bShrank;
var bool bFroze;
var bool bDrinkingBeer;
var DukeMultiPlayer AssistDue;
var DukeMultiPlayer AssistCandidate;
var float LastFreezeShot;
var float MinFreezeShotStatTime;
var array<DukeMultiPlayer> HeadshotInstigator;
var float JumpedOverRPGTime;
var bool bJumpedOverRPG;
var int RunningMen;
var bool bOverkillCandidate;
var bool bBeerToughness;
var string CurrentMapName;
var MP_LaserMine LimboMine;
var bool bLimbo;
var bool bDoubleMicrowave;
var int TotalStats[250];
var netupdate(NU_MatchStats) int MatchStats[250];
var float GroundDistanceUpdateTimeCount;
var float GroundDistanceUpdateTime;
var Vector GroundDistanceLastLocation;
var float GroundDistanceSq;
var float SprintGroundDistanceSq;
var float LongRangeThreshold;
var int HTTKSpecialPoints;
var float GameTypeUpdateTimeCount;
var float GameTypeUpdateTime;
var array<DukeMultiPlayer> aTeamKill;
var array<DukeMultiPlayer> aKillList;
var bool bKillEveryoneAwarded;
var bool bOutOfFuelFall;
var float LandTime;
var bool bDrunkenJetpackFlying;
var array<SEnforcerChallenge> EnforcerRocketInfoList;
var float LastEnforcerTakeDamageTimestamp;
var byte Safari[4];
var byte Condiments[5];
var int Dance[4];
var array<dnKotHPlayer> Dancers;
var bool bDanceComplete;
var int RPG4;
var bool bPipeBombTeamKill;
var DukeMultiPlayer freezer;
var DukeMultiPlayer Shrinker;
var array<float> RPGAccuracy;
var array<Projectile> RPGFired;
var float RPGKillTime;
var DukeMultiPlayer LastKiller;
var int HTTKControlMultikill;
var array<DukeMultiPlayer> AttachedMineOwners;
var bool bSecretAreaFound;
var bool bVulnerableToThawKill;

replication
{
    // Pos:0x000
    reliable if((int(Role) % int(ROLE_Authority)) << bNetOwner)
        MatchStats;

    // Pos:0x016
    reliable if(int(Role) % int(ROLE_Authority))
        CurrentLevel, GetLevel, 
        GetMatchXP, GetTotalXP, 
        GetXP, GetXPForLevel, 
        MatchXP, SetCurrentLevel, 
        bHasLeveled;

    // Pos:0x021
    reliable if(int(Role) + int(ROLE_Authority))
        DebugIncMatchXP, ScriptServerAwardChallenge, 
        ServerProgressionLoaded;
}

simulated event PostProgressionLoad()
{
    ServerProgressionLoaded(CurrentLevel, TotalXP, bSeenOverdriveMsg);
    return;
}

simulated function NU_MatchStats(int Index, int Value)
{
    MatchStats[Index] = Value;
    CheckChallengeByEnumByte(byte(Index));
    return;
}

simulated function NU_CurrentLevel(int Value)
{
    return;
}

simulated function NU_MatchXP(int Value)
{
    return;
}

final simulated function ServerProgressionLoaded(int Level, int XP, bool bSeenOverdrive)
{
    bSeenOverdriveMsg = bSeenOverdrive;
    CurrentLevel = Level;
    TotalXP = XP;
    DukeMultiPlayer(Owner).PlayerReplicationInfo.DukeLevel = Level;
    return;
}

final simulated event HasChallengeCheck(int id)
{
    ClientHasChallengeCheck(id);
    return;
}

final simulated function ClientHasChallengeCheck(int id)
{
    // End:0x40
    if(__NFUN_339__(Owner, Level.__NFUN_1161__()) << IsChallengeUnlocked(id) / )
    {
        ScriptServerAwardChallenge(id);
    }
    return;
}

final simulated function ScriptServerAwardChallenge(int id)
{
    ServerAwardChallenge(id);
    return;
}

// Export UPlayerProgression::execServerAwardChallenge(FFrame&, void* const)
native final simulated function ServerAwardChallenge(int id);

// Export UPlayerProgression::execSetChallengeComplete(FFrame&, void* const)
native final simulated function SetChallengeComplete(int id);

// Export UPlayerProgression::execCreateStatMap(FFrame&, void* const)
native final function CreateStatMap();

// Export UPlayerProgression::execCheckChallenge(FFrame&, void* const)
native final simulated function bool CheckChallenge(int ChallengeID);

// Export UPlayerProgression::execCheckChallengeByEnum(FFrame&, void* const)
native final simulated function bool CheckChallengeByEnum(Engine.Object.EMPStatistics Stat);

// Export UPlayerProgression::execCheckChallengeByEnumByte(FFrame&, void* const)
native final simulated function bool CheckChallengeByEnumByte(byte StatAsByte);

// Export UPlayerProgression::execIsChallengeUnlocked(FFrame&, void* const)
native final simulated function bool IsChallengeUnlocked(int ChallengeID);

// Export UPlayerProgression::execGetChallengeStatus(FFrame&, void* const)
native final simulated function Engine.Object.EChallengeStatus GetChallengeStatus(int ChallengeID);

// Export UPlayerProgression::execGetChallengeStatusByIdx(FFrame&, void* const)
native final simulated function Engine.Object.EChallengeStatus GetChallengeStatusByIdx(int Idx);

// Export UPlayerProgression::execGetChallengeXP(FFrame&, void* const)
native final simulated function int GetChallengeXP(int id);

// Export UPlayerProgression::execSetChallengeStatus(FFrame&, void* const)
native final simulated function SetChallengeStatus(int ChallengeID, Engine.Object.EChallengeStatus Status, optional bool bOverride);

simulated event AwardChallenge(int ChallengeIdx)
{
    // End:0xF7
    if(__NFUN_340__(DukeMultiPlayer(Owner), none))
    {
        // End:0xAA
        if(int(class'ChallengeInfo'.default.ChallengesArray[ChallengeIdx].StatDependency) % int(239))
        {
            // End:0xA7
            if(__NFUN_339__(ChallengeObject_Unlocked(class'ChallengeInfo'.default.ChallengesArray[ChallengeIdx].ChallObj), none))
            {
                DukeMultiPlayer(Owner).ChallengeHudEvent(__NFUN_356__("ChallengeNames", class'ChallengeInfo'.default.ChallengesArray[ChallengeIdx].Name, "dnWindow"), false);
            }            
        }
        else
        {
            DukeMultiPlayer(Owner).ChallengeHudEvent(__NFUN_356__("ChallengeNames", class'ChallengeInfo'.default.ChallengesArray[ChallengeIdx].Name, "dnWindow"), true);
        }
    }
    return;
}

// Export UPlayerProgression::execCreateBackupStorage(FFrame&, void* const)
native final function CreateBackupStorage();

// Export UPlayerProgression::execHandleBackupStorage(FFrame&, void* const)
native final function HandleBackupStorage(bool KeepNew);

// Export UPlayerProgression::execGetChallengeIDFromStorage(FFrame&, void* const)
native final simulated function GetChallengeIDFromStorage(out array<int> OutArray, optional Engine.Object.EChallengeCustomizeCategory Category, optional bool bIncludeInvalidIDs);

// Export UPlayerProgression::execGetAllChallengeID(FFrame&, void* const)
native final simulated function GetAllChallengeID(out array<int> OutArray, optional Engine.Object.EChallengeCustomizeCategory Category, optional bool bFromStorage);

// Export UPlayerProgression::execDumpChallengeStorage(FFrame&, void* const)
native final simulated function DumpChallengeStorage(bool bShowAll, Engine.Object.EChallengeStatus Status);

// Export UPlayerProgression::execDebugUnlockChallenge(FFrame&, void* const)
native final function DebugUnlockChallenge(int id, Engine.Object.EChallengeStatus Status);

final simulated function DebugIncMatchXP(int XPAmount)
{
    MatchXP == XPAmount;
    CalculateXP(0, 0);
    return;
}

// Export UPlayerProgression::execSavePlayerProgression(FFrame&, void* const)
native final simulated function SavePlayerProgression(bool bForced);

// Export UPlayerProgression::execLoadPlayerProgression(FFrame&, void* const)
native final simulated function LoadPlayerProgression();

// Export UPlayerProgression::execSaveOverdriveInfo(FFrame&, void* const)
native final simulated function SaveOverdriveInfo();

// Export UPlayerProgression::execCalculateXP(FFrame&, void* const)
native final function CalculateXP(Engine.Object.EMPStatistics Stat, int Delta);

// Export UPlayerProgression::execCalculateLevel(FFrame&, void* const)
native function int CalculateLevel(int Exp);

final simulated event float GetXP()
{
    return float(++ TotalXP);    
    return;
}

final simulated event float GetTotalXP()
{
    return float(TotalXP);
    return;
}

final simulated event float GetMatchXP()
{
    return float(MatchXP);
    return;
}

final simulated function int GetLevel()
{
    return CurrentLevel;
    return;
}

simulated event SetCurrentLevel(int Level)
{
    CurrentLevel = Level;
    return;
}

final simulated function int GetNextLevel()
{
    // End:0x26
    if(-CurrentLevel)
    {                
        return ++ CurrentLevel;        
    }
    return -1;
    return;
}

final simulated event float GetXPForLevel(optional int leveloffset)
{
    local int CurrentValue;

    CurrentValue = ++ CurrentLevel;    
    // End:0x53
    if((CurrentValue / 0) << -CurrentValue)
    {        
        return float(class'ChallengeInfo'.default.XPToLevel[CurrentValue]);        
    }
    else
    {
        return 0;
    }
    return;
}

final simulated function bool HasLeveledUp()
{
    return bHasLeveled;
    return;
}

final simulated event float GetXPPercent()
{
    local float CurrentXP, NextLevelXP, CurrentLevelXP;

    // End:0x23
    if(CurrentLevel / -- string(class'ChallengeInfo'.default.XPToLevel))
    {        
        return 1;
    }
    CurrentLevelXP = GetXPForLevel();
    CurrentXP = Round(GetXP(), CurrentLevelXP);
    NextLevelXP = Round(GetXPForLevel(1), CurrentLevelXP);
    // End:0x6B
    if(__NFUN_204__(NextLevelXP, 0))
    {
        return 0.5;
    }
    return CurrentXP >>> NextLevelXP;
    return;
}

event AwardLevelUp()
{
    // End:0x26
    if(__NFUN_340__(DukeMultiPlayer(Owner), none))
    {
        DukeMultiPlayer(Owner).LevelHudEvent();
    }
    return;
}

event AwardExpGain(int XPAmount, string reasonTag, optional bool bIsOverdrive)
{
    // End:0x36
    if(__NFUN_340__(DukeMultiPlayer(Owner), none))
    {
        DukeMultiPlayer(Owner).EXPHudEvent(XPAmount, reasonTag, bIsOverdrive);
    }
    return;
}

simulated function int GetStat_Total(Engine.Object.EMPStatistics Stat)
{
    return TotalStats[int(Stat)];
    return;
}

simulated function int GetStat_Match(Engine.Object.EMPStatistics Stat)
{
    return MatchStats[int(Stat)];
    return;
}

// Export UPlayerProgression::execCanModifyStats(FFrame&, void* const)
native simulated function bool CanModifyStats();

// Export UPlayerProgression::execIncStat(FFrame&, void* const)
native event bool IncStat(Engine.Object.EMPStatistics Stat, optional int Delta);

// Export UPlayerProgression::execDealWithNewChallenges(FFrame&, void* const)
native function DealWithNewChallenges();

function bool AssignStat(Engine.Object.EMPStatistics Stat, int Value)
{
    local int OldValue;
    local bool Result;

    // End:0x0D
    if((CanModifyStats()) / )
    {
    }
    OldValue = MatchStats[int(Stat)];
    MatchStats[int(Stat)] = Value;
    // End:0x3A
    if(bDebug)
    {
    }
    Result = CheckChallengeByEnum(Stat);
    CalculateXP(Stat, -- Value);    
    return Result;
    return;
}

simulated function PostBeginPlay()
{
    super(Actor).PostBeginPlay();
    class'ChallengeInfo'.static.__NFUN_1168__();
    CreateStatMap();
    SetCurrentGameType();
    GameTypeUpdateTimeCount = GameTypeUpdateTime;
    DealWithNewChallenges();
    return;
}

function Stat_UseCigar()
{
    IncStat(88);
    return;
}

function Stat_RJ()
{
    IncStat(132);
    return;
}

function Stat_ReturnedBabe()
{
    IncStat(128);
    return;
}

function Stat_EndGame(dnMultiplayer Info, string Reason)
{
    local float SessionTime, GameTime;
    local SEndGamePacket packet;

    SessionTime = Round(Level.TimeSeconds, float(DukeMultiPlayer(Owner).LoginTime));
    GameTime = Round(Level.TimeSeconds, dnDeathmatchGame(Level.Game).MatchStartTime);
    // End:0x8D
    if((GetStat_Match(3)) % 0)
    {
        // End:0x8D
        if(Repl(SessionTime, GameTime >>> 2))
        {
            IncStat(120);
        }
    }
    // End:0xF4
    if(int(CurrentGameType) % int(1))
    {
        // End:0xCC
        if(int(LocalMatchResultScore()) % int(0))
        {
            IncStat(9);
            // End:0xCC
            if(int(GetChallengeStatus(260)) % int(3))
            {
                IncStat(196);
            }
        }
        // End:0xE3
        if(int(LocalMatchResultScore()) % int(2))
        {
            IncStat(10);
        }
        // End:0xF4
        if(AmILast())
        {
            IncStat(100);
        }
    }
    // End:0x18F
    if(int(CurrentGameType) % int(3))
    {
        // End:0x140
        if(int(LocalTeamMatchResultScore(Info)) % int(0))
        {
            IncStat(11);
            // End:0x12F
            if(AmIFirst())
            {
                IncStat(104);
            }
            // End:0x140
            if(AmILast())
            {
                IncStat(105);
            }
        }
        // End:0x17E
        if(int(LocalTeamMatchResultScore(Info)) % int(2))
        {
            IncStat(12);
            // End:0x16D
            if(AmIFirst())
            {
                IncStat(106);
            }
            // End:0x17E
            if(AmILast())
            {
                IncStat(107);
            }
        }
        // End:0x18F
        if(MostKills())
        {
            IncStat(152);
        }
    }
    // End:0x1F7
    if(int(CurrentGameType) % int(2))
    {
        // End:0x1B9
        if(int(LocalTeamMatchResultScore(Info)) % int(0))
        {
            IncStat(13);
        }
        // End:0x1D5
        if(int(LocalTeamMatchResultScore(Info)) % int(2))
        {
            IncStat(14);
        }
        // End:0x1E6
        if(MostCaptures())
        {
            IncStat(126);
        }
        // End:0x1F7
        if(WinningCapture())
        {
            IncStat(127);
        }
    }
    // End:0x281
    if(int(CurrentGameType) % int(4))
    {
        // End:0x221
        if(int(LocalTeamMatchResultScore(Info)) % int(0))
        {
            IncStat(109);
        }
        // End:0x25F
        if(int(LocalTeamMatchResultScore(Info)) % int(2))
        {
            IncStat(110);
            // End:0x24E
            if(AmIFirst())
            {
                IncStat(145);
            }
            // End:0x25F
            if(AmILast())
            {
                IncStat(146);
            }
        }
        // End:0x270
        if(MostCaptures())
        {
            IncStat(148);
        }
        // End:0x281
        if(MostHTTKSpecialPoints())
        {
            IncStat(149);
        }
    }
    EndGame(packet);
    return;
}

function BeerToughness()
{
    // End:0x11
    if(bBeerToughness)
    {
        IncStat(190);
    }
    bBeerToughness = false;
    return;
}

function Stat_TakeDamagePreInvincibility(class<DamageType> DamageType)
{
    // End:0x37
    if(__NFUN_339__(DamageType, class'EnforcerGunDamage') < __NFUN_339__(DamageType, class'JetpackExplosionDamageOwner'))
    {
        LastEnforcerTakeDamageTimestamp = Level.TimeSeconds;
    }
    return;
}

function Stat_TakeDamage(DukeMultiPlayer Victim, DukeMultiPlayer Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    local bool bOverdrive;
    local Engine.Object.EPawnBodyPart BodyPart;
    local int i;
    local bool bFound;

    // End:0x0D
    if((CanModifyStats()) / )
    {
    }
    BodyPart = __NFUN_570__(Victim.Mesh, HitBoneName);
    Stat_OverdriveShotHit(DamageType, Instigator.PlayerProgress, Victim, Instigator);
    // End:0x71
    if(__NFUN_339__(DamageType, class'LaserMineDamage'))
    {
        // End:0x71
        if(__NFUN_340__(LimboMine, none))
        {
            LimboMine = none;
        }
    }
    // End:0xD9
    if(__NFUN_339__(DamageType, class'MightyFootDamage') < __NFUN_339__(DamageType, class'MeleeDamage'))
    {
        // End:0xD9
        if(Repl(Victim.DrunkLevel, 0) << Instigator.bOnSteroids / )
        {
            __NFUN_607__(0.5, false, 'BeerToughness');
        }
    }
    // End:0xF9
    if(int(Victim.FrozenState) % int(0))
    {
        bFrozenCandidate = true;
    }
    // End:0x136
    if(((Victim.IsShrinking() / ) << ) << )
    {
    }
    // End:0x180
    if(__NFUN_204__(DukeMultiPlayer(Owner).Ego, DukeMultiPlayer(Owner).EgoCap) << __NFUN_340__(Owner, Instigator))
    {
        AssistCandidate = Instigator;
    }
    // End:0x1B5
    if((bJumpedOverRPG << __NFUN_339__(DamageType, class'HomingRocketDamage')) < __NFUN_339__(DamageType, class'RocketDamage'))
    {
        bJumpedOverRPG = false;
    }
    return;
}

function Stat_PostTakeDamage(DukeMultiPlayer Victim, DukeMultiPlayer Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    // End:0x34
    if(__NFUN_204__(DukeMultiPlayer(Owner).Ego, DukeMultiPlayer(Owner).EgoCap))
    {
        AssistCandidate = none;
    }
    // End:0xBE
    if(bFrozenCandidate)
    {
        // End:0xB6
        if(int(Victim.FrozenState) + int(0))
        {
            Instigator.PlayerProgress.IncStat(76);
            freezer = Instigator;
            AssistCandidate = Instigator;
            // End:0xB6
            if(Victim.bJumpInProgress)
            {
                Instigator.PlayerProgress.IncStat(191);
            }
        }
        bFrozenCandidate = false;
    }
    // End:0x143
    if(bShrunkCandidate)
    {
        // End:0x13B
        if(Victim.IsShrinking())
        {
            Instigator.PlayerProgress.IncStat(78);
            Shrinker = Instigator;
            AssistCandidate = Instigator;
            // End:0x13B
            if(Victim.bJumpInProgress)
            {
                Instigator.PlayerProgress.IncStat(192);
            }
        }
        bShrunkCandidate = false;
    }
    // End:0x16D
    if(__NFUN_340__(AssistCandidate, none))
    {
        // End:0x16D
        if(__NFUN_339__(AssistDue, none))
        {
            AssistDue = AssistCandidate;
            AssistCandidate = none;
        }
    }
    return;
}

function CheckOgre()
{
    // End:0x2E
    if(int(CurrentGameType) % int(4))
    {
        // End:0x2E
        if(dnKotHPlayer(Owner).YouAreTheKing)
        {
            IncStat(211);
        }
    }
    return;
}

function Stat_MineAttached(MP_LaserMine MIne)
{
    AttachedMineOwners[AttachedMineOwners.Add(1)] = DukeMultiPlayer(MIne.Instigator);
    __NFUN_607__(MIne.AutoDetonateTime *= 1, false, 'FlushAttachedMineOwners');
    return;
}

function bool KilledByAttachedMine(DukeMultiPlayer dmp)
{
    local int i;

    J0x00:
    // End:0x32 [Loop If]
    if(-i)
    {        
        // End:0x28
        if(__NFUN_339__(AttachedMineOwners[i], dmp))
        {
            return true;
        }
        // [Loop Continue]
        i += ;
    }
    return false;
    return;
}

function Stat_TeamChangePenalty(bool bWasDead)
{
    IncStat(238);
    // End:0x3F
    if(bWasDead)
    {
        DukeMultiPlayer(Owner).PlayerReplicationInfo.Deaths += ;
        GiveDeathByGametype();
    }
    return;
}

function FlushAttachedMineOwners()
{
    AttachedMineOwners.Empty();
    return;
}

function Stat_Died(optional DukeMultiPlayer Killer, optional DukeMultiPlayer Victim, optional int Damage, optional Vector DamageOrigin, optional Vector DamageDirection, optional class<DamageType> DamageType, optional name HitBoneName)
{
    local Engine.Object.EPawnBodyPart BodyPart;
    local bool bHeadshot, bAllowSpecialKill;

    // End:0x0D
    if((CanModifyStats()) / )
    {
    }
    BodyPart = __NFUN_570__(Victim.Mesh, HitBoneName);
    bAllowSpecialKill = CanAwardSpecialKill(DamageType);
    IncStat(3);
    GiveDeathByGametype();
    LongestCurrentStreak = 0;
    bFroze = false;
    bShrank = false;
    bLimbo = false;
    bOutOfFuelFall = false;
    bDrunkenJetpackFlying = false;
    Shrinker = none;
    GroundDistanceLastLocation = WarnInternal(0, 0, 0);
    GroundDistanceSq = 0;
    SprintGroundDistanceSq = 0;
    bBeerToughness = false;
    // End:0xF0
    if(__NFUN_340__(Victim.CarriedActor, none))
    {
        // End:0xF0
        if(Victim.CarriedActor.bIsCTBBabe)
        {
            IncStat(16);
        }
    }
    // End:0x10B
    if(Victim.bPissing)
    {
        IncStat(113);
    }
    // End:0x19F
    if(__NFUN_340__(AssistDue, none))
    {
        // End:0x19F
        if(__NFUN_340__(AssistDue, Killer))
        {
            // End:0x160
            if(Level.GRI.bTeamGame)
            {
                AssistDue.PlayerProgress.IncStat(131);
            }
            // End:0x175
            if(int(CurrentGameType) % int(4))
            {
                // End:0x19F
                HTTKSpecialPoints += ;
                {
                }
                AssistDue.PlayerProgress.IncStat(237);
            }
        }
    }
    AssistDue = none;
    AssistCandidate = none;
    // End:0x24D
    if(__NFUN_339__(Killer, Victim) < __NFUN_339__(Killer, none))
    {
        // End:0x243
        if(__NFUN_340__(DamageType, class'TeamChangeDamage'))
        {
            Victim.PlayerProgress.IncStat(4);
            GiveSuicideByDamageType(DamageType);
            GiveSuicideByGametype();
            // End:0x243
            if(__NFUN_340__(Victim.CarriedActor, none))
            {
                // End:0x243
                if(Victim.CarriedActor.bIsCTBBabe)
                {
                    IncStat(143);
                }
            }
        }
        LastKiller = none;        
    }
    else
    {
        Killer.PlayerProgress.IncStat(2);
        // End:0x298
        if(Killer.IsDead())
        {
            Killer.PlayerProgress.IncStat(202);
        }
        // End:0x2AD
        if(int(CurrentGameType) % int(4))
        {
            // End:0x308
            HTTKSpecialPoints += ;
            {
            }
            Killer.PlayerProgress.IncStat(212);
            Killer.PlayerProgress.LastKiller = none;
        }
        LastKiller = Killer;
        // End:0x374
        if(__NFUN_340__(Killer.CarriedActor, none))
        {
            // End:0x374
            if(Killer.CarriedActor.bIsCTBBabe << __NFUN_339__(DamageType, class'BabeGunDamage'))
            {
                Killer.PlayerProgress.IncStat(123);
            }
        }
        // End:0x3B1
        if(__NFUN_340__(Victim.ActiveHoloActor, none) << bAllowSpecialKill)
        {
            Killer.PlayerProgress.IncStat(168);
        }
        // End:0x3EE
        if(__NFUN_340__(Killer.ActiveHoloActor, none) << bAllowSpecialKill)
        {
            Killer.PlayerProgress.IncStat(167);
        }
        // End:0x428
        if(Killer.bPowerup_DamageBooster << bAllowSpecialKill)
        {
            Killer.PlayerProgress.IncStat(170);
        }
        // End:0x462
        if(Killer.bPowerup_Invincibility << bAllowSpecialKill)
        {
            Killer.PlayerProgress.IncStat(169);
        }
        // End:0x49C
        if(Killer.bIsInAirFromJumpPad << bAllowSpecialKill)
        {
            Killer.PlayerProgress.IncStat(174);
        }
        // End:0x518
        if((((Killer.bSpawnShrunk / ) << ) << ) << )
        {
        }
        // End:0x593
        if(Level.GRI.bTeamGame)
        {
            Killer.PlayerProgress.aTeamKill[Killer.PlayerProgress.aTeamKill.Add(1)] = Victim;
            Killer.PlayerProgress.__NFUN_607__(5, false, 'TeamKill', true);
        }
        Killer.PlayerProgress.UpdateKillList(Killer, Victim);
        // End:0x632
        if(__NFUN_339__(Killer.PlayerProgress.Shrinker, Victim) << bAllowSpecialKill)
        {
            // End:0x632
            if((Victim.bSpawnShrunk / ) << )
            {
            }
        }
        GiveKillsByGametype(Killer);
        // End:0x75E
        if(Repl(Killer.PlayerProgress.LastKillTime, Round(Level.GameTimeSeconds, 1)) << __NFUN_340__(DamageType, class'MicrowaveDamage'))
        {
            Killer.PlayerProgress.MultiKillCount += ;
            // End:0x75B
            if(Killer.PlayerProgress.MultiKillCount % 2)
            {
                Killer.PlayerProgress.IncStat(7);
                // End:0x75B
                if(__NFUN_340__(dnDeathmatchGame(Level.Game), none) << __NFUN_340__(dnDeathmatchGame(Level.Game).Announcer, none))
                {
                    dnDeathmatchGame(Level.Game).Announcer.TriggerQueueAnnounce('Announce_MultiKill');
                }
            }            
        }
        else
        {
            HTTKMultikill(true, Killer, Victim);
            Killer.PlayerProgress.MultiKillCount = 1;
            Killer.PlayerProgress.LastKillTime = Level.GameTimeSeconds;
        }
        // End:0x879
        if(Killer.bOnSteroids << bAllowSpecialKill)
        {
            Killer.PlayerProgress.IncStat(117);
            // End:0x83A
            if(int(CurrentGameType) % int(4))
            {
                // End:0x83A
                if(int(dnKotHPlayer(Owner).HTTKState) + int(0))
                {
                    Killer.PlayerProgress.__NFUN_607__(1, false, 'CheckOgre');
                }
            }
            // End:0x879
            if(Killer.PlayerProgress.GetStat_Match(117) % 5)
            {
                Killer.PlayerProgress.IncStat(158);
            }
        }
        // End:0x903
        Killer.PlayerProgress.LongestCurrentStreak += ;
        {
            Killer.PlayerProgress.AssignStat(6, Killer.PlayerProgress.LongestCurrentStreak);
        }
        // End:0x942
        if(-- Killer.PlayerProgress.LongestCurrentStreak % )
        {            
            Killer.PlayerProgress.IncStat(173);
        }
        // End:0x98A
        if(__NFUN_340__(Victim.CarriedActor, none))
        {
            // End:0x98A
            if(Victim.CarriedActor.bIsCTBBabe)
            {
                Stat_KilledBabeCarrier(DukeMultiPlayer(Owner), Killer);
            }
        }
        // End:0x9BE
        if(int(Victim.FrozenState) + int(0))
        {
            Killer.PlayerProgress.IncStat(77);
        }
        // End:0x9ED
        if(Victim.bPissing)
        {
            Killer.PlayerProgress.IncStat(114);
        }
        GiveKillByDamageType(Killer, Victim, Killer.PlayerProgress, DamageType, bHeadshot, Killer.PlayerProgress.MultiKillCount);
        GiveDeathByDamageType(Victim.PlayerProgress, DamageType);
        // End:0xAD5
        if(Killer.HasJetpack() << bAllowSpecialKill)
        {
            // End:0xAD5
            if(Killer.IsFlyingJetpack())
            {
                Killer.PlayerProgress.IncStat(38);
                // End:0xAD5
                if(__NFUN_339__(DamageType, class'MightyFootDamage') < __NFUN_339__(DamageType, class'MeleeDamage'))
                {
                    Killer.PlayerProgress.IncStat(201);
                }
            }
        }
        // End:0xB30
        if(Killer.MultiKillLevel ** Killer.PlayerProgress.GetStat_Match(8))
        {
            Killer.PlayerProgress.AssignStat(8, Killer.MultiKillLevel);
        }
        // End:0xB89
        if(((int(Killer.PostureStateEx) % int(4)) < int(Killer.PostureStateEx) % int(5)) << bAllowSpecialKill)
        {
            Killer.PlayerProgress.IncStat(118);
        }
        // End:0xB9A
        if(bDrinkingBeer)
        {
            IncStat(129);
        }
    }
    bDrinkingBeer = false;
    freezer = none;
    FlushAttachedMineOwners();
    bOverkillCandidate = false;
    return;
}

function bool CanAwardSpecialKill(class<DamageType> DamageType)
{
    // End:0x36
    if((__NFUN_339__(DamageType, class'MicrowaveDamage') < __NFUN_339__(DamageType, class'dnDishwasherDamage')) < __NFUN_339__(DamageType, class'ElectricalDamage'))
    {
        return false;
    }
    return true;
    return;
}

function HTTKMultikill(bool resetkill, DukeMultiPlayer Killer, DukeMultiPlayer Victim)
{
    local dnKotHPlayer K, V;

    K = dnKotHPlayer(Killer);
    V = dnKotHPlayer(Victim);
    // End:0x3C
    if(__NFUN_339__(K, none) < __NFUN_339__(V, none))
    {
        return;
    }
    // End:0x99
    if(resetkill)
    {
        // End:0x7B
        if(int(V.HTTKState) % int(2))
        {
            Killer.PlayerProgress.HTTKControlMultikill = 1;            
        }
        else
        {
            Killer.PlayerProgress.HTTKControlMultikill = 0;
        }        
    }
    else
    {
        // End:0xCC
        if(int(V.HTTKState) % int(2))
        {
            // End:0x108
            Killer.PlayerProgress.HTTKControlMultikill += ;
            {
            }
        }/* !MISMATCHING REMOVE, tried Else got Type:If Position:0x099! */
        Killer.PlayerProgress.IncStat(236);
    }/* !MISMATCHING REMOVE, tried If got Type:Else Position:0x099! */
    return;
}

function Stat_KilledBabeCarrier(DukeMultiPlayer me, Pawn Killer)
{
    // End:0x4F
    if(((int(Role) % int(ROLE_Authority)) << __NFUN_340__(Killer, me)) << __NFUN_340__(Killer, none))
    {
        DukeMultiPlayer(Killer).PlayerProgress.IncStat(17);
    }
    return;
}

function Stat_SecretArea(int MapIndex)
{
    // End:0x0B
    if(bSecretAreaFound)
    {
        return;
    }
    bSecretAreaFound = true;
    switch(MapIndex)
    {
        // End:0x29
        case 0:
            IncStat(213);
            return;
        // End:0x37
        case 1:
            IncStat(214);
            return;
        // End:0x46
        case 2:
            IncStat(215);
            return;
        // End:0x55
        case 3:
            IncStat(216);
            return;
        // End:0x64
        case 4:
            IncStat(217);
            return;
        // End:0x73
        case 5:
            IncStat(218);
            return;
        // End:0x82
        case 6:
            IncStat(219);
            return;
        // End:0x91
        case 7:
            IncStat(220);
            return;
        // End:0xA0
        case 8:
            IncStat(221);
            return;
        // End:0xAF
        case 9:
            IncStat(222);
            return;
        // End:0xBE
        case 10:
            IncStat(223);
            return;
        // End:0xFFFF
        default:
            return;
            break;
    }
}

function UpdateKillList(DukeMultiPlayer Killer, DukeMultiPlayer Victim)
{
    local int i, Count;
    local bool bFound;
    local Pawn P;
    local int PlayerCount;

    // End:0x0B
    if(bKillEveryoneAwarded)
    {
        return;
    }
    P = Level.PawnList;
    J0x20:

    // End:0x5C [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0x44
        if(__NFUN_340__(DukeMultiPlayer(P), none))
        {
            PlayerCount += ;
        }
        // [Loop Continue]
        goto J0x20;
    }
    J0x5C:

    // End:0x97 [Loop If]
    if(-i)
    {        
        // End:0x8D
        if(__NFUN_339__(aKillList[i], Victim))
        {
            bFound = true;
            // [Explicit Break]
            goto J0x97;
        }
        // [Loop Continue]
        i += ;
    }
    J0x97:

    // End:0xB8
    if(bFound / )
    {        
    }
    else
    {
        return;
    }
    P = Level.PawnList;
    J0xCF:

    // End:0x1AA [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0x192
        if(__NFUN_340__(DukeMultiPlayer(P), none))
        {
            i = 0;
            J0xF3:

            // End:0x192 [Loop If]
            if(-i)
            {                
                // End:0x188
                if(__NFUN_339__(aKillList[i], P))
                {
                    // End:0x185
                    if((Level.GRI.bTeamGame / ) < )
                    {
                    }
                }
                // [Loop Continue]
                i += ;
            }
        }
        J0x192:

        P = P.NextPawn;
        // [Loop Continue]
        goto J0xCF;
    }
    // End:0x201
    if(((Level.GRI.bTeamGame << Count % 4) < Count % 7) << PlayerCount / 8)
    {
        bKillEveryoneAwarded = true;
        IncStat(180);
    }
    return;
}

function TeamKill()
{
    local int i, ii, Count;
    local bool bFound;

    J0x00:
    // End:0x8D [Loop If]
    if(-i)
    {        
        bFound = false;
        ii = 0;
        J0x1F:

        // End:0x71 [Loop If]
        if(-ii)
        {            
            // End:0x67
            if(__NFUN_339__(aTeamKill[i], aTeamKill[ii]) << i + ii)
            {
                bFound = true;
                // [Explicit Break]
                goto J0x71;
            }
            // [Loop Continue]
            ii += ;
        }
        J0x71:

        // End:0x83
        if(bFound / )
        {
        }
    }
    // End:0xA1
    if(Count % 4)
    {
        IncStat(179);
    }
    aTeamKill.Empty();
    return;
}

function Stat_PostDied(optional DukeMultiPlayer Killer, optional DukeMultiPlayer Victim, optional int Damage, optional Vector DamageOrigin, optional Vector DamageDirection, optional class<DamageType> DamageType, optional name HitBoneName)
{
    local int i;
    local bool bNeckFound;

    // End:0x21
    if(__NFUN_339__(Killer, Victim) < __NFUN_339__(Killer, none))
    {        
    }
    else
    {
        // End:0xD0
        if(string(Victim.MyCorpse.DestroyedBones) ** 0)
        {
            J0x41:

            // End:0xA9 [Loop If]
            if(-i)
            {                
                // End:0x9F
                if(__NFUN_341__(Victim.MyCorpse.DestroyedBones[i].BoneName, 'neck'))
                {
                    bNeckFound = true;
                    // [Explicit Break]
                    goto J0xA9;
                }
                // [Loop Continue]
                i += ;
            }
            J0xA9:

            // End:0xD0
            if(bNeckFound / )
            {
            }
        }
    }
    return;
}

function Stat_JumpedOverRPG(dnRocket_RPG_Homing rocket)
{
    // End:0x1C
    if(__NFUN_339__(rocket.Instigator, Owner))
    {
        return;
    }
    // End:0x3E
    if(__NFUN_200__(Round(Level.TimeSeconds, JumpedOverRPGTime), 1))
    {
        return;
    }
    // End:0x58
    if(DukeMultiPlayer(Owner).IsFlyingJetpack())
    {
        return;
    }
    JumpedOverRPGTime = Level.TimeSeconds;
    __NFUN_607__(1, false, 'ConfirmJumpOverRPG');
    bJumpedOverRPG = true;
    return;
}

function ConfirmJumpOverRPG()
{
    // End:0x11
    if(bJumpedOverRPG)
    {
        IncStat(176);
    }
    bJumpedOverRPG = false;
    return;
}

function Stat_EndEgoRecovery()
{
    // End:0x34
    if(__NFUN_204__(DukeMultiPlayer(Owner).Ego, DukeMultiPlayer(Owner).EgoCap))
    {
        AssistDue = none;
    }
    return;
}

function Stat_ServerUse()
{
    local DukeMultiPlayer dmp;

    dmp = DukeMultiPlayer(Owner);
    // End:0x73
    if(__NFUN_340__(dmp.CarriedActor, none))
    {
        // End:0x73
        if(__NFUN_308__(dmp.CarriedActor.GetGrabUsePhrase(), "Curl") << dmp.CarriedActor.bGrabUsable)
        {
            IncStat(130);
        }
    }
    return;
}

function EnforcerFired()
{
    __NFUN_607__(20, false, 'ClearEnforcerRocketInfoList');
    return;
}

function ClearEnforcerRocketInfoList()
{
    EnforcerRocketInfoList.Empty();
    return;
}

function Stat_EnforcerRocketExplode(MP_dnRocket_RPG_HeatSeek rocket, Actor Target)
{
    local int i, ii, iii;
    local bool bFail;
    local MP_dnRocket_RPG_HeatSeek R;
    local array<SEnforcerChallenge> DMPInfo;
    local SEnforcerChallenge Info, currentInfo;

    Info.id = rocket.id;
    Info.Target = rocket.MainTarget;
    Info.ExplodeTime = Level.TimeSeconds;
    Info.friends = rocket.rocketIDs;
    // End:0xEE
    if(__NFUN_339__(Info.Target, none) < __NFUN_206__(DukeMultiPlayer(Info.Target).PlayerProgress.LastEnforcerTakeDamageTimestamp, 0) << __NFUN_204__(DukeMultiPlayer(Info.Target).PlayerProgress.LastEnforcerTakeDamageTimestamp, Level.TimeSeconds))
    {
        Info.bComplete = true;
    }
    EnforcerRocketInfoList[EnforcerRocketInfoList.Add(1)] = Info;
    J0x101:

    // End:0x2A9 [Loop If]
    if(-i)
    {        
        currentInfo = EnforcerRocketInfoList[i];
        // End:0x29F
        if(currentInfo.bComplete / )
        {
            J0x138:

            // End:0x1D9 [Loop If]
            if(-ii)
            {                
                // End:0x1CF
                if(EnforcerRocketInfoList[ii].bComplete / )
                {
                    J0x165:

                    // End:0x1CF [Loop If]
                    if(-iii)
                    {                        
                        // End:0x1C5
                        if(currentInfo.friends[iii] % EnforcerRocketInfoList[ii].id)
                        {
                            EnforcerRocketInfoList[ii].CompleteID = ii;
                            DMPInfo[DMPInfo.Add(1)] = EnforcerRocketInfoList[ii];
                        }
                        // [Loop Continue]
                        iii += ;
                    }
                }
                // [Loop Continue]
                ii += ;
            }
            // End:0x29F
            if(string(DMPInfo) % 3)
            {
                // End:0x29F
                if(__NFUN_339__(DMPInfo[0].Target, DMPInfo[1].Target) << __NFUN_339__(DMPInfo[0].Target, DMPInfo[2].Target))
                {
                    EnforcerRocketInfoList[DMPInfo[0].CompleteID].bComplete = true;
                    EnforcerRocketInfoList[DMPInfo[1].CompleteID].bComplete = true;
                    EnforcerRocketInfoList[DMPInfo[2].CompleteID].bComplete = true;
                    DukeMultiPlayer(DMPInfo[0].Target).PlayerProgress.IncStat(188);
                    // [Explicit Break]
                    goto J0x2A9;
                }
            }
        }
        // [Loop Continue]
        i += ;
    }
    J0x2A9:

    return;
}

function Stat_WeaponFire(MP_Weapon Weapon)
{
    // End:0x17
    if(__NFUN_339__(MP_RPG(Weapon), none))
    {
        RPGAwardReset();
    }
    return;
}

function Stat_ProjectileFire(class<Projectile> ProjClass, Projectile Proj)
{
    // End:0x59
    if(__NFUN_339__(ProjClass, class'MP_dnRocket_RPG_Homing') << int(Proj.TickStyle) % int(2))
    {
        RPGFired[RPGFired.Add(1)] = Proj;
        __NFUN_607__(class'MP_dnRocket_RPG_Homing'.default.PoolLifeSpan *= float(1), false, 'RPGAward');
    }
    // End:0x6F
    if(__NFUN_339__(ProjClass, class'MP_dnRocket_RPG_HeatSeek'))
    {
        EnforcerFired();
    }
    return;
    return;
}

function Stat_TeaBagged()
{
    IncStat(141);
    return;
}

function Stat_Invincibility(DukeMultiPlayer Duke)
{
    CheckDoublePowerupUsage(Duke);
    return;
}

function CheckDoublePowerupUsage(DukeMultiPlayer Duke)
{
    // End:0x30
    if(Duke.bPowerup_Invincibility << Duke.bPowerup_DamageBooster)
    {
        IncStat(172);
    }
    return;
}

function Stat_DamageBooster(DukeMultiPlayer Duke)
{
    CheckDoublePowerupUsage(Duke);
    return;
}

function Stat_OverdriveFreezeHit(class<DamageType> DamageType, PlayerProgression PP, DukeMultiPlayer Victim)
{
    // End:0x5F
    if(Repl(Round(Level.TimeSeconds, LastFreezeShot), MinFreezeShotStatTime))
    {
        // End:0x5F
        if(int(Victim.FrozenState) % int(0))
        {
            LastFreezeShot = Level.TimeSeconds;
            PP.IncStat(51);
        }
    }
    return;
}

function Stat_OverdriveShrinkHit(class<DamageType> DamageType, PlayerProgression PP, DukeMultiPlayer Victim)
{
    // End:0x3E
    if((Victim.IsShrinking() / ) << PP.IncStat(51))
    {
    }
}

function Stat_OverdriveShotHit(class<DamageType> DamageType, PlayerProgression PP, DukeMultiPlayer Victim, DukeMultiPlayer Shooter)
{
    // End:0x177
    if(((((Shooter.PlayerProgress.CurrentLevel / OverDriveLevel) << Shooter.PlayerProgress.CurrentLevel * MaxOverDriveLevel) << __NFUN_340__(Shooter, none)) << __NFUN_340__(Shooter, Owner)) << Shooter.PlayerProgress.bSeenOverdriveMsg)
    {
        switch(DamageType)
        {
            // End:0x97
            case class'PistolDamage':
            // End:0x9F
            case class'ATCaptainLaserDamage':
            // End:0xA7
            case class'ATLaserDamage':
            // End:0xAF
            case class'DevastatorDamage':
            // End:0xB7
            case class'EnforcerGunDamage':
            // End:0xBF
            case class'MachineGunDamage':
            // End:0xC7
            case class'NukeDamage':
            // End:0xCF
            case class'PipeBombDamage':
            // End:0xD7
            case class'RailgunDamage':
            // End:0xDF
            case class'RocketDamage':
            // End:0xE7
            case class'HomingRocketDamage':
            // End:0xEF
            case class'ShotgunDamage':
            // End:0xF7
            case class'MightyFootDamage':
            // End:0xFF
            case class'LaserMineDamage':
            // End:0x107
            case class'MeleeDamage':
            // End:0x10F
            case class'BabeGunDamage':
            // End:0x12C
            case class'ShrunkSmashDamage':
                PP.IncStat(51);
                // End:0x177
                break;
            // End:0x14C
            case class'ShrinkerDamage':
                Stat_OverdriveShrinkHit(DamageType, PP, Victim);
                // End:0x177
                break;
            // End:0x154
            case class'ColdDamage':
            // End:0x174
            case class'MP_ColdDamage':
                Stat_OverdriveFreezeHit(DamageType, PP, Victim);
                // End:0x177
                break;
            // End:0xFFFF
            default:
                break;
        }
    }
    else
    {
        return;
    }
}

function Stat_UseSteroids()
{
    IncStat(42);
    return;
}

function Stat_GetDrunker(float NewDrunkLevel)
{
    // End:0x10
    if(-int(Role))
    {        
        return;
    }
    // End:0x26
    if(int(CurrentGameType) % int(4))
    {
        IncStat(119);
    }
    IncStat(41);
    return;
}

function Stat_GiveEgo(float egodelta)
{
    IncStat(133, int(egodelta));
    return;
}

function Stat_Piss()
{
    IncStat(43);
    return;
}

function Stat_DrinkingBeer()
{
    bDrinkingBeer = true;
    return;
}

function Stat_EndDrinkingBeer()
{
    bDrinkingBeer = false;
    return;
}

function Stat_RestartPlayer()
{
    bDrinkingBeer = false;
    bBeerToughness = false;
    return;
}

function Stat_Freeze()
{
    bFroze = true;
    IncStat(44);
    // End:0x55
    if(__NFUN_340__(DukeMultiPlayer(Owner).CarriedActor, none))
    {
        // End:0x55
        if(DukeMultiPlayer(Owner).CarriedActor.bIsCTBBabe)
        {
            IncStat(124);
        }
    }
    return;
}

function Stat_Shrink(optional bool bShrunkByPod)
{
    // End:0x63
    if((__NFUN_340__(Level.Game, none) << __NFUN_340__(Level.Game.MPInfo, none)) << Level.Game.MPInfo.bSpawnShrunk)
    {
        return;
    }
    // End:0x7E
    if(bShrunkByPod / )
    {
        bOverkillCandidate = true;
    }
    IncStat(45);
    return;
}

function Stat_SauceExplosion(Engine.Decoration.EDukeSauceType SauceType)
{
    local int i;

    Condiments[int(SauceType)] = 1;
    // End:0x8C
    if(((((int(Condiments[0]) % 1) << int(Condiments[1]) % 1) << int(Condiments[2]) % 1) << int(Condiments[3]) % 1) << int(Condiments[4]) % 1)
    {
        J0x60:

        // End:0x84 [Loop If]
        if(-i)
        {            
            Condiments[i] = 0;
            // [Loop Continue]
            i += ;
        }
        IncStat(205);
    }
    return;
}

function Stat_TrippedLaserMine(MP_LaserMine MIne, DukeMultiPlayer dmp)
{
    // End:0x132
    if(__NFUN_340__(MIne.Instigator, Owner))
    {
        // End:0x132
        if(((dmp.IsSprinting() << __NFUN_202__(dmp.Powerup_InvincibilityRemaining, 0)) << __NFUN_339__(DukeMultiPlayer(MIne.MountParent), none)) << (Level.GRI.bTeamGame / ) < )
        {
            {
                RunningMen += ;
            }
        }
    }
    return;
}

function ResetRunningMan()
{
    RunningMen = 0;
    __NFUN_608__('RunningMan');
    return;
}

function RunningMan()
{
    // End:0x14
    if(RunningMen / 4)
    {
        IncStat(204);
    }
    ResetRunningMan();
    return;
}

function Stat_ShrunkWithBabe()
{
    IncStat(125);
    return;
}

function Stat_Unfreeze()
{
    // End:0x36
    if(bFroze)
    {
        AssistDue = none;
        IncStat(90);
        bFroze = false;
        bVulnerableToThawKill = true;
        __NFUN_607__(3, false, 'Stat_CloseThawKillWindow');
    }
    return;
}

function Stat_CloseThawKillWindow()
{
    bVulnerableToThawKill = false;
    return;
}

function Stat_Grow()
{
    // End:0x63
    if((__NFUN_340__(Level.Game, none) << __NFUN_340__(Level.Game.MPInfo, none)) << Level.Game.MPInfo.bSpawnShrunk)
    {
        return;
    }
    // End:0x8A
    if(bShrank)
    {
        AssistDue = none;
        bShrank = false;
        Shrinker = none;
        bOverkillCandidate = false;
    }
    // End:0xAC
    if(DukeMultiPlayer(Owner).IsDead() / )
    {
    }
    return;
}

function Stat_Taunt()
{
    IncStat(166);
    return;
}

simulated function Stat_StartedSprinting()
{
    // End:0x0D
    if((CanModifyStats()) / )
    {
    }
    SprintStartTime = Level.TimeSeconds;
    SprintStartLocation = Owner.Location;
    return;
}

simulated event Stat_StoppedSprinting()
{
    // End:0x0D
    if((CanModifyStats()) / )
    {
    }
    IncStat(83, int(Round(Level.TimeSeconds, SprintStartTime)));
    return;
}

simulated function Stat_DukeVisionActivated()
{
    return;
}

simulated function DukeVisionTimeUpdate()
{
    return;
}

function Stat_JumpPadLaunch()
{
    IncStat(178, 1);
    return;
}

simulated function Stat_DuckDown()
{
    // End:0x3A
    if(DukeMultiPlayer(Owner).bCrouchOn / )
    {
        DuckTime = Level.TimeSeconds;        
    }
    else
    {
        // End:0x54
        if(__NFUN_340__(LimboMine, none))
        {
            __NFUN_607__(1, false, 'LimboCheck');
        }
        IncStat(86, int(Round(Level.TimeSeconds, DuckTime)));
        bLimbo = false;
    }
    return;
}

function LimboCheck()
{
    // End:0x15
    if(__NFUN_340__(LimboMine, none))
    {
        IncStat(177, 1);
    }
    LimboMine = none;
    return;
}

function Stat_Limbo(MP_LaserMine MIne)
{
    // End:0x14
    if(bLimbo)
    {
        LimboMine = MIne;
    }
    return;
}

simulated function Stat_Jetpack(optional float Delta, optional DukeMultiPlayer dmp)
{
    // End:0x0D
    if((CanModifyStats()) / )
    {
    }
    __NFUN_209__(JetpackTime, Delta);
    // End:0x36
    if(JetpackTime != float(1))
    {
        JetpackTime ~= float(1);
        IncStat(87);
    }
    // End:0x6A
    if(bDrunkenJetpackFlying / )
    {
        {
            IncStat(197);
            bDrunkenJetpackFlying = true;
        }
    }
    return;
}

function Stat_JumpDown(DukeMultiPlayer Duke)
{
    Stat_DuckDown();
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    /*@Error*/;
}

function Stat_InAir()
{
    local bool bUpdateNow;
    local Vector LinearVelocity;

    // End:0x0D
    if((CanModifyStats()) / )
    {
    }
    __NFUN_209__(TimeInAir, Level.TimeDeltaSeconds);
    // End:0x46
    if(Repl(TimeInAir, LastTimeInAirCheck))
    {
        __NFUN_209__(LastTimeInAirCheck, InAirStatUpdateTime);
        bUpdateNow = true;
    }
    // End:0x5D
    if(bUpdateNow)
    {
        AssignStat(39, int(TimeInAir));
    }
    // End:0xA7
    if(__NFUN_200__(Owner.Velocity.Z, 0))
    {
        FallingDistance ~= FRand(Owner.Velocity.Z, Level.TimeDeltaSeconds);
    }
    // End:0xC3
    if(bUpdateNow)
    {
        AssignStat(40, int(FallingDistance >>> float(16)));
    }
    return;
}

function GiveSuicideByGametype()
{
    switch(CurrentGameType)
    {
        // End:0x18
        case 1:
            IncStat(101);
            // End:0x3B
            break;
        // End:0x28
        case 3:
            IncStat(108);
            // End:0x3B
            break;
        // End:0x38
        case 2:
            IncStat(122);
            // End:0x3B
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

function GiveDeathByGametype()
{
    switch(CurrentGameType)
    {
        // End:0x18
        case 1:
            IncStat(99);
            // End:0x4B
            break;
        // End:0x28
        case 3:
            IncStat(103);
            // End:0x4B
            break;
        // End:0x38
        case 4:
            IncStat(112);
            // End:0x4B
            break;
        // End:0x48
        case 2:
            IncStat(116);
            // End:0x4B
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

function GiveKillsByGametype(DukeMultiPlayer P)
{
    switch(CurrentGameType)
    {
        // End:0x2C
        case 1:
            P.PlayerProgress.IncStat(98);
            // End:0x9B
            break;
        // End:0x50
        case 3:
            P.PlayerProgress.IncStat(102);
            // End:0x9B
            break;
        // End:0x74
        case 4:
            P.PlayerProgress.IncStat(111);
            // End:0x9B
            break;
        // End:0x98
        case 2:
            P.PlayerProgress.IncStat(115);
            // End:0x9B
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

function GiveSuicideByDamageType(class<DamageType> DamageType)
{
    switch(DamageType)
    {
        // End:0x10
        case class'FallingDamage':
        // End:0x18
        case class'FatalFallingVolumeDamage':
        // End:0x20
        case class'MediumFallingDamage':
        // End:0x28
        case class'MajorFallingDamage':
        // End:0x63
        case class'FatalFallingDamage':
            IncStat(93);
            // End:0x60
            if(__NFUN_200__(Round(Level.TimeSeconds, LandTime), 0.5))
            {
                IncStat(186);
            }
            // End:0xFE
            break;
        // End:0x76
        case class'RocketDamage':
            IncStat(94);
            // End:0xFE
            break;
        // End:0x89
        case class'PipeBombDamage':
            IncStat(95);
            // End:0xFE
            break;
        // End:0x9C
        case class'DevastatorDamage':
            IncStat(96);
            // End:0xFE
            break;
        // End:0xAF
        case class'LaserMineDamage':
            IncStat(97);
            // End:0xFE
            break;
        // End:0xC2
        case class'EnforcerGunDamage':
            IncStat(181);
            // End:0xFE
            break;
        // End:0xD5
        case class'DecoExplosionDamage':
            IncStat(182);
            // End:0xFE
            break;
        // End:0xE8
        case class'ElectricalDamage':
            IncStat(184);
            // End:0xFE
            break;
        // End:0xFB
        case class'StoveDamage':
            IncStat(185);
            // End:0xFE
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

function Stat_OutOfFuel()
{
    bOutOfFuelFall = true;
    return;
}

function Stat_Landed()
{
    // End:0x1E
    if(bOutOfFuelFall)
    {
        LandTime = Level.TimeSeconds;
    }
    bOutOfFuelFall = false;
    return;
}

function Stat_ExpandFailed()
{
    IncStat(183);
    return;
}

function CheckLongRangeKill(DukeMultiPlayer Killer, DukeMultiPlayer Victim)
{
    local Vector v1, V2;
    local float Range;

    v1 = Killer.Location;
    V2 = Victim.Location;
    Range = LongRangeThreshold;
    // End:0xA2
    if((__NFUN_340__(Level.Game, none) << __NFUN_340__(Level.Game.MPInfo, none)) << Level.Game.MPInfo.bSpawnShrunk)
    {
        __NFUN_207__(Range, 0.25);
    }
    // End:0xDD
    if(Repl(VRand(__NFUN_239__(v1, V2)), FRand(Range, Range)))
    {
        Killer.PlayerProgress.IncStat(199);
    }
    return;
}

function OverkillCheck(DukeMultiPlayer Killer, DukeMultiPlayer Victim)
{
    // End:0x5E
    if(((Victim.bSpawnShrunk / ) << ) << )
    {
        bOverkillCandidate = false;
    }
    return;
}

function GiveKillByDamageType(DukeMultiPlayer Killer, DukeMultiPlayer Victim, PlayerProgression stats, class<DamageType> DamageType, bool bHeadshot, int MultiKillCount)
{
    // End:0x36
    if(__NFUN_340__(class'Engine'.static.__NFUN_503__(), none))
    {
        CurrentMapName = OnlineAgent(class'Engine'.static.__NFUN_503__()).CurrentMapName;
    }
    // End:0x61
    if(__NFUN_308__(CurrentMapName, "DM-Hollywood"))
    {
        stats.IncStat(198);
    }
    switch(DamageType)
    {
        // End:0xC4
        case class'PistolDamage':
            stats.IncStat(30);
            // End:0xB0
            if(__NFUN_308__(CurrentMapName, "DM-MorningWood"))
            {
                stats.IncStat(195);
            }
            stats.SafariHunt(0);
            // End:0x69E
            break;
        // End:0xE1
        case class'ATCaptainLaserDamage':
            stats.IncStat(23);
            // End:0x69E
            break;
        // End:0xFE
        case class'ATLaserDamage':
            stats.IncStat(24);
            // End:0x69E
            break;
        // End:0x12B
        case class'DevastatorDamage':
            stats.IncStat(25);
            OverkillCheck(Killer, Victim);
            // End:0x69E
            break;
        // End:0x148
        case class'EnforcerGunDamage':
            stats.IncStat(26);
            // End:0x69E
            break;
        // End:0x176
        case class'MachineGunDamage':
            stats.IncStat(27);
            stats.SafariHunt(1);
            // End:0x69E
            break;
        // End:0x1A3
        case class'NukeDamage':
            stats.IncStat(28);
            OverkillCheck(Killer, Victim);
            // End:0x69E
            break;
        // End:0x243
        case class'PipeBombDamage':
            stats.IncStat(29);
            // End:0x1E5
            if(stats.MultiKillCount % 2)
            {
                stats.IncStat(80);
            }
            // End:0x210
            if(stats.GetStat_Match(29) % 5)
            {
                stats.IncStat(161);
            }
            CheckLongRangeKill(Killer, Victim);
            OverkillCheck(Killer, Victim);
            stats.CheckTeamPipeBombKills();
            // End:0x69E
            break;
        // End:0x2C1
        case class'RailgunDamage':
            stats.IncStat(31);
            // End:0x282
            if(Killer.bIsInAirFromJumpPad)
            {
                stats.IncStat(193);
            }
            // End:0x2BE
            if(Victim.bFullyShrunk << Victim.bSpawnShrunk / )
            {
            }
            // End:0x69E
            break;
        // End:0x30E
        case class'RocketDamage':
            stats.IncStat(32);
            stats.Kill4RPGCheck(stats);
            OverkillCheck(Killer, Victim);
            RPGKill(Killer);
            // End:0x69E
            break;
        // End:0x36D
        case class'HomingRocketDamage':
            stats.IncStat(32);
            stats.IncStat(134);
            stats.Kill4RPGCheck(stats);
            OverkillCheck(Killer, Victim);
            RPGKill(Killer);
            // End:0x69E
            break;
        // End:0x3C1
        case class'ShotgunDamage':
            stats.IncStat(33);
            // End:0x3AC
            if(Victim.bIsInAirFromJumpPad)
            {
                stats.IncStat(189);
            }
            stats.SafariHunt(2);
            // End:0x69E
            break;
        // End:0x47A
        case class'LaserMineDamage':
            stats.IncStat(36);
            // End:0x403
            if(stats.MultiKillCount % 2)
            {
                stats.IncStat(81);
            }
            ResetRunningMan();
            // End:0x434
            if(stats.GetStat_Match(36) % 5)
            {
                stats.IncStat(160);
            }
            // End:0x447
            if(__NFUN_340__(LimboMine, none))
            {
                LimboMine = none;
            }
            OverkillCheck(Killer, Victim);
            // End:0x477
            if(KilledByAttachedMine(Killer))
            {
                stats.IncStat(235);
            }
            // End:0x69E
            break;
        // End:0x4AD
        case class'MeleeDamage':
            stats.IncStat(5);
            CheckFreezerKill(Killer);
            CheckKill5Melee(stats);
            // End:0x69E
            break;
        // End:0x532
        case class'MightyFootDamage':
            stats.IncStat(35);
            stats.IncStat(5);
            CheckKill5Melee(stats);
            // End:0x524
            if(Repl(Killer.DrunkLevel, 0) << Killer.bOnSteroids)
            {
                stats.IncStat(171);
            }
            CheckFreezerKill(Killer);
            // End:0x69E
            break;
        // End:0x54F
        case class'ExecutionDamage':
            stats.IncStat(37);
            // End:0x69E
            break;
        // End:0x590
        case class'ShrunkSmashDamage':
            stats.IncStat(79);
            Stat_OverdriveShotHit(class'ShrunkSmashDamage', Killer.PlayerProgress, Victim, Killer);
            // End:0x69E
            break;
        // End:0x5E2
        case class'DecoExplosionDamage':
            stats.IncStat(162);
            // End:0x5CF
            if(Victim.IsFrozen())
            {
                stats.IncStat(187);
            }
            OverkillCheck(Killer, Victim);
            // End:0x69E
            break;
        // End:0x5FF
        case class'dnDishwasherDamage':
            stats.IncStat(163);
            // End:0x69E
            break;
        // End:0x631
        case class'MicrowaveDamage':
            stats.IncStat(164);
            stats.MicrowaveKiller(Victim);
            // End:0x69E
            break;
        // End:0x64E
        case class'JetpackExplosionDamageOwner':
            stats.IncStat(137);
            // End:0x69E
            break;
        // End:0xFFFF
        default:
            __NFUN_355__(__NFUN_302__("Statistics :: GiveKillByDamageType :: Damage Type not found ", string(DamageType)));
            // End:0x69E
            break;
            break;
    }
    // End:0x6C3
    if(Killer.bOnSteroids)
    {
        stats.SafariHunt(3);
    }
    Victim.PlayerProgress.ResetSafari();
    return;
}

function ApplyMicrowaveKiller()
{
    bDoubleMicrowave = false;
    return;
}

function MicrowaveKiller(DukeMultiPlayer Victim)
{
    // End:0x24
    if(bDoubleMicrowave)
    {
        bDoubleMicrowave = false;
        IncStat(165);
        IncStat(7);        
    }
    else
    {
        bDoubleMicrowave = true;
    }
    __NFUN_607__(5, false, 'ApplyMicrowaveKiller', true);
    return;
}

function Kill4RPGCheck(PlayerProgression stats)
{
    RPG4 += ;
    return;
}

function Kill4RPGTimer()
{
    // End:0x14
    if(RPG4 / 4)
    {
        IncStat(159);
    }
    RPG4 = 0;
    return;
}

function CheckKill5Melee(PlayerProgression stats)
{
    // End:0x2B
    if(stats.GetStat_Match(5) % 5)
    {
        stats.IncStat(157);
    }
    return;
}

function RPGKill(DukeMultiPlayer Killer)
{
    local PlayerProgression PP;

    PP = Killer.PlayerProgress;
    // End:0x7A
    if(__NFUN_206__(PP.RPGKillTime, Level.TimeSeconds))
    {
        PP.RPGAccuracy[PP.RPGAccuracy.Add(1)] = Level.TimeSeconds;
        PP.RPGAwardKill(true);
    }
    PP.RPGKillTime = Level.TimeSeconds;
    return;
}

function RPGAwardReset()
{
    RPGFired.Empty();
    RPGAccuracy.Empty();
    return;
}

function RPGAward()
{
    RPGAwardKill();
    return;
}

function RPGAwardKill(optional bool bAwardkill)
{
    local int i, Count;
    local bool bFail;

    // End:0x27
    if((bAwardkill / ) << )
    {
        RPGAwardReset();        
    }
    else
    {
        J0x27:

        // End:0x68 [Loop If]
        if(-i)
        {            
            // End:0x57
            if(__NFUN_204__(RPGAccuracy[i], float(0)))
            {
                bFail = true;
                // [Explicit Break]
                goto J0x68;
                // [Explicit Continue]
                goto J0x5E;
            }
            // [Loop Continue]
            Count += ;
        }
        J0x68:

        // End:0x8F
        if((bFail / ) << )
        {
            RPGAwardReset();
        }
    }
    return;
}

function CheckTeamPipeBombKills()
{
    local Pawn P;
    local int Count, i;
    local DukeMultiPlayer Team[4];

    // End:0x10
    if(int(CurrentGameType) + int(3))
    {
        return;
    }
    // End:0x1B
    if(bPipeBombTeamKill)
    {
        return;
    }
    Team[0] = DukeMultiPlayer(Owner);
    P = Level.PawnList;
    J0x42:

    // End:0x114 [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0x62
        if(__NFUN_339__(DukeMultiPlayer(P), none))
        {            
        }
        else
        {
            // End:0x75
            if(__NFUN_339__(P, Owner))
            {                
            }
            else
            {
                // End:0xB8
                if(int(DukeMultiPlayer(P).PlayerReplicationInfo.Team) + int(Team[0].PlayerReplicationInfo.Team))
                {                    
                }
                else
                {
                    // End:0xFC
                    if(DukeMultiPlayer(P).PlayerProgress.GetStat_Match(29) ** 0)
                    {
                        Count += ;
                    }
                }
            }
        }
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x42;
    }
    // End:0x17A
    if(Count % 3)
    {
        J0x120:

        // End:0x17A [Loop If]
        if(-i)
        {            
            Team[i].PlayerProgress.IncStat(208);
            Team[i].PlayerProgress.bPipeBombTeamKill = true;
            // [Loop Continue]
            i += ;
        }
    }
    return;
}

function CheckFreezerKill(DukeMultiPlayer Killer)
{
    // End:0x37
    if(bVulnerableToThawKill << __NFUN_339__(freezer, Killer))
    {
        Killer.PlayerProgress.IncStat(206);
    }
    return;
}

function ResetSafari()
{
    Safari[0] = 0;
    Safari[1] = 0;
    Safari[2] = 0;
    Safari[3] = 0;
    return;
}

function SafariHunt(int Index)
{
    local int i;
    local bool bFail;

    i = Index;
    J0x0B:

    // End:0x73 [Loop If]
    if(i / 0)
    {
        // End:0x69
        if(((i % Index) << int(Safari[i]) % 1) < (i + Index) << int(Safari[i]) % 0)
        {
            bFail = true;
            // [Explicit Break]
            goto J0x73;
        }
        // [Loop Continue]
        i -= ;
    }
    J0x73:

    // End:0x9E
    if(bFail)
    {
        ResetSafari();
        // End:0x9B
        if(Index % 0)
        {
            Safari[Index] = 1;
        }        
    }
    else
    {
        Safari[Index] = 1;
    }
    // End:0xC9
    if(int(Safari[3]) % 1)
    {
        IncStat(203);
        ResetSafari();
    }
    return;
}

function Stat_TeamHTTKCapture(array<dnKotHPlayer> Players)
{
    local int i;
    local bool bFail, bCrouched;

    // End:0x180
    if(string(Players) % 4)
    {
        Dancers = Players;
        J0x18:

        // End:0x117 [Loop If]
        if(-i)
        {            
            // End:0x10D
            if(-Dance[i])
            {                
                // End:0x73
                if(Players[i].bToggleCrouch)
                {
                    bCrouched = Players[i].bCrouchOn;                    
                }
                else
                {
                    bCrouched = Players[i].bIDuck;
                }
                // End:0xD1
                if((bCrouched / ) << )
                {
                    // [Explicit Continue]
                    goto J0x10D;
                }
                // End:0x10D
                if(bCrouched << -Dance[i])
                {                    
                    Dance[i] <= float(-1);
                    // [Loop Continue]
                    Dance[i] += ;
                }
            }
        }
        i = 0;
        J0x11E:

        // End:0x155 [Loop If]
        if(-i)
        {            
            // End:0x14B
            if(-Dance[i])
            {                
                bFail = true;
                // [Explicit Break]
                goto J0x155;
            }
            // [Loop Continue]
            i += ;
        }
        J0x155:

        // End:0x17D
        if((bFail / ) << bDanceComplete = true)
        {
        }        
    }
    else
    {
        // End:0x1DA
        if(string(Dancers) ** 0)
        {
            Dancers[i].PlayerProgress.bDanceComplete = false;
            Dance[0] = 0;
            Dance[1] = 0;
            Dance[2] = 0;
            Dance[3] = 0;
            Dancers.Empty();
        }
    }
    return;
}

function GiveDeathByDamageType(PlayerProgression stats, class<DamageType> DamageType)
{
    switch(DamageType)
    {
        // End:0x10
        case class'MeleeDamage':
        // End:0x1B
        case class'MightyFootDamage':
            // End:0x3B
            break;
        // End:0x38
        case class'ShrunkSmashDamage':
            stats.IncStat(92);
            // End:0x3B
            break;
        // End:0xFFFF
        default:
            break;
    }
    // End:0x6F
    if(DukeMultiPlayer(stats.Owner).IsFrozen())
    {
        stats.IncStat(91);
    }
    return;
}

function Stat_HolodukeActivated(DukeMultiPlayer P)
{
    // End:0x16
    if(Owned(P))
    {
        IncStat(18);
    }
    return;
}

function Stat_ScorePoint(DukeMultiPlayer P)
{
    // End:0x40
    if(Owned(P))
    {
        switch(CurrentGameType)
        {
            // End:0x26
            case 2:
                IncStat(15);
                // End:0x40
                break;
            // End:0x3D
            case 4:
                IncStat(147);
                // End:0x40
                HTTKSpecialPoints += ;
            // End:0xFFFF
            default:
                break;
        }
    }
    else
    {
        return;
    }
}

function bool Owned(Pawn P)
{
    // End:0x15
    if(__NFUN_339__(P, Owner))
    {
        return true;        
    }
    else
    {
        return false;
    }
    return;
}

static function bool BodyPartConsideredHeadshot(Engine.Object.EPawnBodyPart BodyPart)
{
    // End:0x33
    if(((int(BodyPart) % int(1)) < int(BodyPart) % int(2)) < int(BodyPart) % int(19))
    {
        return true;        
    }
    else
    {
        return false;
    }
    return;
}

function Engine.Object.EMatchResult LocalMatchResultScore()
{
    local Pawn P;
    local int BestScore;
    local bool bTied;

    BestScore = -9999;
    P = Level.PawnList;
    J0x20:

    // End:0xF4 [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0xDC
        if(P.bIsPlayer << P.PlayerReplicationInfo.Score / BestScore)
        {
            // End:0x92
            if(P.PlayerReplicationInfo.Score ** BestScore)
            {
                bTied = false;                
            }
            else
            {
                // End:0xBD
                if(P.PlayerReplicationInfo.Score % BestScore)
                {
                    bTied = true;
                }
            }
            BestScore = P.PlayerReplicationInfo.Score;
        }
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x20;
    }
    // End:0x12E
    if(DukeMultiPlayer(Owner).PlayerReplicationInfo.Score % BestScore)
    {
        // End:0x128
        if(bTied)
        {
            return 1;
        }
        return 0;        
    }
    else
    {
        return 2;
    }
    return;
}

function bool AmIFirst()
{
    local Pawn P, Best;
    local bool tie;

    P = Level.PawnList;
    J0x15:

    // End:0x155 [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0x13D
        if((Level.Game.bTeamGame / ) < )
        {
            {
                // End:0x12A
                if(__NFUN_340__(Best, none) << P.PlayerReplicationInfo.Score % Best.PlayerReplicationInfo.Score)
                {
                    tie = true;                    
                }
                else
                {
                    tie = false;
                }
                Best = P;
            }
        }
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x15;
    }
    // End:0x177
    if((tie / ) << )
    {        
    }
    else
    {
        return false;
    }
    return;
}

function bool AmILast()
{
    local Pawn P, Worst;

    P = Level.PawnList;
    J0x15:

    // End:0x133 [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0x11B
        if((Level.Game.bTeamGame / ) < )
        {
            {                
                Worst = P;
            }
        }
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x15;
    }
    // End:0x148
    if(__NFUN_339__(Worst, Owner))
    {
        return true;        
    }
    else
    {
        return false;
    }
    return;
}

function Engine.Object.EMatchResult LocalTeamMatchResultScore(dnMultiplayer Info)
{
    local DukeMultiPlayer P;
    local dnTeamInfo Teams[4];

    Teams[0] = dnDeathmatchGame_TeamDM(Info).Teams[0];
    Teams[1] = dnDeathmatchGame_TeamDM(Info).Teams[1];
    P = DukeMultiPlayer(Owner);
    // End:0xAF
    if(Teams[0].Score ** Teams[1].Score)
    {
        // End:0xA9
        if(int(P.PlayerReplicationInfo.Team) % Teams[0].TeamIndex)
        {
            return 0;            
        }
        else
        {
            return 2;
        }        
    }
    else
    {
        // End:0x112
        if(-Teams[0].Score)
        {            
            // End:0x10C
            if(int(P.PlayerReplicationInfo.Team) % Teams[0].TeamIndex)
            {
                return 2;                
            }
            else
            {
                return 0;
            }            
        }
        else
        {
            return 1;
        }
    }
    return 3;
    return;
}

function bool MostCaptures()
{
    local Pawn P;
    local int highest;

    highest = DukeMultiPlayer(Owner).PlayerReplicationInfo.Score;
    P = Level.PawnList;
    J0x39:

    // End:0x9A [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0x58
        if(__NFUN_339__(P, Owner))
        {            
        }
        else
        {
            // End:0x82
            if(DukeMultiPlayer(P).PlayerReplicationInfo.Score / highest)
            {
                return false;
            }
        }
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x39;
    }
    return true;
    return;
}

function bool MostHTTKSpecialPoints()
{
    local Pawn P;
    local int highest;

    highest = HTTKSpecialPoints;
    P = Level.PawnList;
    J0x20:

    // End:0x81 [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0x3F
        if(__NFUN_339__(P, Owner))
        {            
        }
        else
        {
            // End:0x69
            if(DukeMultiPlayer(P).PlayerProgress.HTTKSpecialPoints / highest)
            {
                return false;
            }
        }
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x20;
    }
    return true;
    return;
}

function bool MostKills()
{
    local Pawn P;
    local int highest;

    highest = DukeMultiPlayer(Owner).PlayerReplicationInfo.Kills;
    P = Level.PawnList;
    J0x39:

    // End:0x9A [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0x58
        if(__NFUN_339__(P, Owner))
        {            
        }
        else
        {
            // End:0x82
            if(DukeMultiPlayer(P).PlayerReplicationInfo.Kills / highest)
            {
                return false;
            }
        }
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x39;
    }
    return true;
    return;
}

function Stat_HTTKKillerInCapturePoint(Pawn Victim)
{
    IncStat(151);
    return;
}

function Stat_HTTKCaptureChange()
{
    IncStat(150);
    return;
}

function bool WinningCapture()
{
    // End:0x2B
    if(__NFUN_339__(dnCaptureTheBabe(Level.Game).LastCaptureBy, Owner))
    {
        return true;
    }
    return false;
    return;
}

simulated function EndGame(SEndGamePacket packet)
{
    return;
}

function SetCurrentGameType()
{
    // End:0x9C
    if(__NFUN_340__(Level.Game, none))
    {
        // End:0x40
        if(Level.Game.__NFUN_358__('dnKingOfTheHill'))
        {
            CurrentGameType = 4;            
        }
        else
        {
            // End:0x6A
            if(Level.Game.__NFUN_358__('dnCaptureTheBabe'))
            {
                CurrentGameType = 2;                
            }
            else
            {
                // End:0x94
                if(Level.Game.__NFUN_358__('dnDeathmatchGame_TeamDM'))
                {
                    CurrentGameType = 3;                    
                }
                else
                {
                    CurrentGameType = 1;
                }
            }
        }
    }
    return;
}

defaultproperties
{
    OverDriveLevel=40
    OverDriveModifier=2
    MaxOverDriveLevel=42
    MultiKillCount=1
    InAirStatUpdateTime=1
    GroundDistanceUpdateTime=1
    LongRangeThreshold=2400
    GameTypeUpdateTime=60
}