/*******************************************************************************
 * StochasticTrigger generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class StochasticTrigger extends Triggers
    collapsecategories
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound,Collision,Interactivity,Karma,Lighting,Mounting,movement,Sound,Filter,Networking,Interpolation);

var() noexport deprecated array<name> Events "What events to call (must be at least one event)";
var() noexport bool bIsActive "This trigger dispacher is activated/deactivated";
var() noexport bool TriggerImmediately "Trigger the first event immediately, otherwise wait until the CheckTime has passed once.";
var() noexport float TriggerProbability "The chance of the event occuring effect playing";
var() noexport float minReCheckTime "Try to re-trigger the event after (min amount) (This is the final result when using ramping of periods). 0 values are not allowed, and negative values are converted to positive.";
var() noexport float maxReCheckTime "Try to re-trigger the event after (max amount) (This is the final result when using ramping of periods). 0 values are not allowed, and negative values are converted to positive.";
var(StochasticTriggerEx) noexport bool bDisplayDebugInfo "Displays some helpful information for debugging your time settings.";
var(StochasticTriggerEx) noexport bool bResetRampTime "Reset the ramp time each time this is Enabled. Otherwise it's stored and picks up where it left off.";
var(StochasticTriggerEx) noexport bool bResetRampCount "Reset the ramp count each time this is Enabled. Otherwise it's stored and picks up where it left off.";
var(StochasticTriggerEx) noexport bool bOscillateRamp "If this is true, then when it reaches the end of the ramp time, it will start going in the opposite direction, otherwise it will simply restart at the beginning again.";
var(StochasticTriggerEx) noexport bool bDisableAfterRamp "Disable the entire system after the ramping has completed.";
var(StochasticTriggerEx) noexport int RampCount "Number of times to ramp through. A ramp of up and down counts as 2 ramps. 0=Infinite 1=Ramp once and then stay steady at that rate.";
var(StochasticTriggerEx) noexport float RampTime "Amount of time to ramp the recheck time from Start to the final values. It's valid to get longer or shorter. This restarts each time the actor is enabled.";
var(StochasticTriggerEx) noexport float RampPeakTime "Amount of time to wait once a ramp time has completed before starting to go in the other direction";
var(StochasticTriggerEx) noexport float minReCheckTimeStart "Start out trying to re-trigger after (min amount) and ramp to the final time over RampTime. 0 values are not allowed, and negative values are converted to positive.";
var(StochasticTriggerEx) noexport float maxReCheckTimeStart "Start out trying to re-trigger after (max amount) and ramp to the final time over RampTime. 0 values are not allowed, and negative values are converted to positive.";
var int curRampCount;
var float curRampTime;
var float curminReCheckTime;
var float curmaxReCheckTime;
var Engine.Object.ETickStyle ActiveTickStyle;

function PostBeginPlay()
{
    super(Actor).PostBeginPlay();
    // End:0x2B
    if(__NFUN_202__(RampTime, float(0)))
    {
        curminReCheckTime = minReCheckTime;
        curmaxReCheckTime = maxReCheckTime;        
    }
    else
    {
        ResetRampTime();
    }
    ActiveTickStyle = TickStyle;
    // End:0x4E
    if(bIsActive)
    {
        EnableTriggerEvent();        
    }
    else
    {
        DisableTriggerEvent();
    }
    return;
}

function bool VerifySelf()
{
    local int i;

    // End:0x9E
    if(__NFUN_202__(TriggerProbability, 0))
    {
        InvalidAlert(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("Warning: ", string(self)), " has "), string(int(FRand(TriggerProbability, float(100))))), "% chance of triggering, rendering it useless. "), string(self)), " has left the game with -1 frags."));
        return false;
    }
    i = -- string(Events);    
    J0xAD:

    // End:0xE4 [Loop If]
    if(i / 0)
    {
        // End:0xDA
        if(__NFUN_341__(Events[i], 'None'))
        {
            Events.Remove(i, 1);
        }
        // [Loop Continue]
        i -= ;
    }
    // End:0x16F
    if(__NFUN_204__(minReCheckTime, 0) << __NFUN_204__(maxReCheckTime, 0))
    {
        InvalidAlert(__NFUN_302__(__NFUN_302__("Warning: ", string(self)), " has min and max ReCheckTime values of 0. This is invalid and must be changed."));
        return false;
    }
    // End:0x188
    if(__NFUN_200__(minReCheckTime, float(0)))
    {
        minReCheckTime = -minReCheckTime;
    }
    // End:0x1A1
    if(__NFUN_200__(maxReCheckTime, float(0)))
    {
        maxReCheckTime = -maxReCheckTime;
    }
    // End:0x1BB
    if(__NFUN_200__(maxReCheckTime, minReCheckTime))
    {
        maxReCheckTime = minReCheckTime;
    }
    // End:0x2A1
    if(Repl(RampTime, float(0)))
    {
        // End:0x255
        if(__NFUN_204__(minReCheckTimeStart, 0) << __NFUN_204__(maxReCheckTimeStart, 0))
        {
            InvalidAlert(__NFUN_302__(__NFUN_302__("Warning: ", string(self)), " has min and max ReCheckTimeStart values of 0. This is invalid and must be changed."));
        }
        // End:0x26E
        if(__NFUN_200__(minReCheckTimeStart, float(0)))
        {
            minReCheckTimeStart = -minReCheckTimeStart;
        }
        // End:0x287
        if(__NFUN_200__(maxReCheckTimeStart, float(0)))
        {
            maxReCheckTimeStart = -maxReCheckTimeStart;
        }
        // End:0x2A1
        if(__NFUN_200__(maxReCheckTimeStart, minReCheckTimeStart))
        {
            maxReCheckTimeStart = minReCheckTimeStart;
        }
    }
    return super(Actor).VerifySelf();
    return;
}

function SetActiveTickStyle()
{
    TickStyle = ActiveTickStyle;
    bNoNativeTick = __NFUN_202__(RampTime, float(0));
    return;
}

function EnableTriggerEvent()
{
    DisableTriggerEvent();
    // End:0x2E
    if(bDisplayDebugInfo)
    {
        BroadcastLog(__NFUN_302__(string(self), " has been enabled."));
    }
    // End:0x58
    if(Repl(RampTime, float(0)))
    {
        // End:0x49
        if(bResetRampTime)
        {
            ResetRampTime();
        }
        // End:0x58
        if(bResetRampCount)
        {
            ResetRampCount();
        }
    }
    SetActiveTickStyle();
    bIsActive = true;
    // End:0x78
    if(TriggerImmediately)
    {
        DoTriggerEvent();        
    }
    else
    {
        PrepareNextTriggerEvent();
    }
    return;
}

function ResetRampTime()
{
    curRampTime = 0;
    curminReCheckTime = minReCheckTimeStart;
    curmaxReCheckTime = maxReCheckTimeStart;
    return;
}

function ResetRampCount()
{
    curRampCount = 0;
    return;
}

function DisableTriggerEvent()
{
    // End:0x29
    if(bDisplayDebugInfo)
    {
        BroadcastLog(__NFUN_302__(string(self), " has been disabled."));
    }
    bIsActive = false;
    __NFUN_606__('DoTriggerEvent');
    bNoNativeTick = true;
    TickStyle = 0;
    return;
}

function PrepareNextTriggerEvent()
{
    local float reTriggerTime;

    // End:0x5D
    reTriggerTime = FRand(Round(curmaxReCheckTime, curminReCheckTime),  /= ) *= if(bDisplayDebugInfo);
    {
    }
    // End:0x75
    if(__NFUN_204__(reTriggerTime, 0))
    {
        DoTriggerEvent();        
    }
    else
    {
        __NFUN_605__(reTriggerTime, false, 'DoTriggerEvent');
    }
    return;
}

function DoTriggerEvent()
{

    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */
    /*@Error*/;
}

function TriggerEvent()
{
    // End:0x20
    if(string(Events) ** 0)
    {
        GlobalTrigger(Events[Sin(string(Events))]);
    }
    return;
}

event Tick(float DeltaTime)
{
    super(Actor).Tick(DeltaTime);
    __NFUN_209__(curRampTime, DeltaTime);
    // End:0x76
    if(__NFUN_200__(curRampTime, RampTime))
    {
        curminReCheckTime = FRand(Round(minReCheckTime, minReCheckTimeStart), curRampTime >>> RampTime) *= minReCheckTimeStart;
        curmaxReCheckTime = FRand(Round(maxReCheckTime, maxReCheckTimeStart), curRampTime >>> RampTime) *= maxReCheckTimeStart;
        return;
    }
    // End:0xC5
    if((curRampTime != RampTime) << __NFUN_202__(Round(curRampTime, DeltaTime), RampTime))
    {
        curminReCheckTime = minReCheckTime;
        curmaxReCheckTime = maxReCheckTime;
        // End:0xC5
        if(RampCount ** 0)
        {
            // End:0x13A
            curRampCount += ;
            {
            }
        }        
        // End:0x137
        if(Round(curRampTime, RampTime) != RampPeakTime)
        {
            curRampTime = 0;
            // End:0x137
            if(bOscillateRamp)
            {
                minReCheckTime = minReCheckTimeStart;
                maxReCheckTime = maxReCheckTimeStart;
                minReCheckTimeStart = curminReCheckTime;
                maxReCheckTimeStart = curmaxReCheckTime;
            }
        }        
    }
    else
    {
        // End:0x14C
        if(bDisableAfterRamp)
        {
            DisableTriggerEvent();            
        }
        else
        {
            bNoNativeTick = true;
        }
    }
    return;
}

state() TriggeredActive
{
    function Trigger(Actor Other, Pawn EventInstigator)
    {
        EnableTriggerEvent();
        return;
    }

    function UnTrigger(Actor Other, Pawn EventInstigator)
    {
        DisableTriggerEvent();
        return;
    }
Begin:

    bIsActive = false;
    stop;            
}

state() TriggeredDisable
{
    function Trigger(Actor Other, Pawn EventInstigator)
    {
        DisableTriggerEvent();
        __NFUN_614__();
        return;
    }
Begin:

    bIsActive = true;
    stop;            
}

auto state() TriggeredToggle
{
    function Trigger(Actor Other, Pawn EventInstigator)
    {
        // End:0x12
        if(bIsActive)
        {
            DisableTriggerEvent();            
        }
        else
        {
            EnableTriggerEvent();
        }
        return;
    }
    stop;
}

state() AlwaysActive
{Begin:

    EnableTriggerEvent();
    stop;    
}

defaultproperties
{
    bResetRampTime=true
    bNoNativeTick=false
    TickStyle=2
    Texture='Engine.S_TrigStochastic'
}