/*******************************************************************************
 * TriggerPlayer generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class TriggerPlayer extends Triggers
    collapsecategories
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound);

enum TriggerVehicleViewStyle
{
    VehicleView_DontChange,
    VehicleView_FirstPerson,
    VehicleView_ThirdPerson,
    VehicleView_Toggle
};

enum EBossMeterAction
{
    BOSSMETER_NoAction,
    BOSSMETER_AddMeter,
    BOSSMETER_RemoveMeter
};

var(TPDamage) noexport Engine.Object.EBitModifier TakeOnlyTransferredDamage "When this is set, the player will only accept damage of transferred type.";
var(TPDamage) noexport Engine.Object.EBitModifier InvinciblePlayer "Whether the player can take any damage at all or not.";
var(TPWeapon) noexport Engine.Object.EBitModifier InfiniteAmmo "Give the player infinite ammo or not.";
var(TPWeapon) noexport Engine.Object.EBitModifier WeaponsUseable "Enable/Disable 'Safe Mode', which dictates whether the player can use weapons or not.";
var(TPWeapon) noexport bool ForceQuickKick "Force the player to do a quick kick.";
var(TPEffects) noexport array<SScreenFlash> ScreenFlashes "List of screen flashes to apply to the player when triggered.";
var(TPEffects) noexport array<name> ScreenFlashRemoveList "List of screen flashes to remove from the player when triggered.";
var(TPEffects) noexport bool bRestartShakes "When true, will check to see if player already has the" "shakes listed in the ViewShakeInfo array," "and then will restart them if they exist." "Otherwise, will readd them to the active list.";
var(TPEffects) noexport array<SViewShakeInfo> ViewShakeInfo "List of camera shakes to apply to the player when triggered.";
var(TPEffects) noexport array<name> ShakeRemoveList "List of shake names that you want to remove from the player when triggered.";
var(TPEffects) noexport bool bDeafenPlayer "Cause the player to go deaf.";
var(TPEffects) noexport array<SScaleModifier> BlurScreenAddList "Causes the screen to blur. Value from 0-1 for the target to scale the overall blur effect happening to the player.";
var(TPEffects) noexport array<name> BlurScreenRemoveList "List of screen blurs to remove from the player.";
var(TPEffects) noexport array<SScaleModifier> BlurBrightnessAddList "Causes the screen (only when when blurred) to get brighter and bloomed. This is added to whatever currently exists (not a scaler).";
var(TPEffects) noexport array<name> BlurBrightnessRemoveList "List of screen BlurBrightness to remove from the player.";
var(TPEffects) noexport array<SScaleModifier> MotionBlurAddList "Causes the screen display a motion blur type effect. Value from 0-1 for the target to scale the overall motion blur effect happening to the player.";
var(TPEffects) noexport array<name> MotionBlurRemoveList "List of motion blurs to remove from the player.";
var(TPEffects) noexport array<SScaleModifier> DOFBlurAmountAddList "List of Depth of Field modifiers to apply";
var(TPEffects) noexport array<name> DOFBlurAmountRemoveList "List of Depth of Field modifiers to remove";
var(TPEffects) noexport array<SScaleModifier> DOFFocalDistAddList "List of Depth of Field focal distance modifiers to apply";
var(TPEffects) noexport array<name> DOFFocalDistRemoveList "List of Depth of Field focal distance modifiers to remove";
var(TPEffects) noexport array<SScaleModifier> DOFFocalRangeMinAddList "List of Depth of Field focal min range modifiers to apply";
var(TPEffects) noexport array<name> DOFFocalRangeMinRemoveList "List of Depth of Field focal min range modifiers to remove";
var(TPEffects) noexport array<SScaleModifier> DOFFocalRangeMaxAddList "List of Depth of Field focal max range modifiers to apply";
var(TPEffects) noexport array<name> DOFFocalRangeMaxRemoveList "List of Depth of Field focal max range modifiers to remove";
var(TPEffects) noexport array<SRumbleInfo> RumbleInfo "List of controller rumbles to apply to the player when triggered.";
var(TPInventory) noexport array< class<Inventory> > GiveItemClass "List of Inventory items to give the player";
var(TPInventory) noexport array< class<Inventory> > TakeItemClass "List of Inventory items to remove from the player's inventory if they have them. This does not consider subclasses.";
var(TPInventory) noexport array< class<Inventory> > TakeItemGroupClass "List of Inventory classes. If the player has any items of this class or a subclass of it, that item will be removed.";
var(TPState) noexport bool bForceUnregisterQuestItem "If true, UnregisterQuestItem will be called which will stop displaying the quest item status on the HUD.  This is useful for quest situations where a dnControl won't be used.";
var(TPState) noexport bool bForceGrabActor "When true, triggering this TriggerPlayer will force the player to grab the actor specified by ForcedGrabActor.";
var(TPState) noexport deprecated InteractiveActor ForcedGrabActor "Actor the player will be forced to grab if bForceGrabActor is true.";
var(TPControl) noexport Engine.Object.EBitModifier PhysicsControllerEnabled "Will the player's physics control be enabled? If false, the player won't be able to move under their own control.";
var(TPControl) bool bSetViewRotationMode;
var(TPControl) Engine.Object.EPlayerViewRotationMode NewViewRotationMode;
var(TPControl) noexport Engine.Object.EBitModifier MenuDisabled "Control the status of MenuDisabled";
var(TPEffects) noexport array<SScaleModifier> FOVAddList "Zooms the player's view in/out. The Target is a percentage of the current FOV. So if at 90, then 0.5 would put the player at 45.";
var(TPEffects) noexport array<name> FOVRemoveList "List of motion blurs to remove from the player.";
var(TPState) noexport bool bForceShrink "If this is true, the Player will shrink instantly upon trigger.";
var(TPState) noexport bool bForceShrinkWithEffects "If this is true, the Player will start shrinking upon trigger.  bForceShrink must also be true.";
var(TPState) noexport bool bForceUnshrink "If this is true, the Player will return to full-size upon trigger.";
var(TPState) noexport bool bForceUnfreeze "If this is true, the Player will unfreeze upon trigger.";
var(TPState) noexport bool bMarkLevelAsCompleted "If this is true, the current level will be marked as completed upon trigger.";
var(TPState) noexport Engine.Object.EBitModifier ForceCrouchModifier "How to modify the bForceCrouch flag on the player.";
var(TPState) noexport Engine.Object.EFloatModifier HoldBreathTimeModifier "How to modify HoldBreathTime.";
var(TPState) noexport float HoldBreathTime "Modifier value for HoldBreathTime.";
var(TPVoice) noexport name VoicePackEntry "The name of an entry in the player's VoicePack that will cause them to 'speak' it.";
var(TPView) noexport TriggerPlayer.TriggerVehicleViewStyle VehicleViewStyle "Change vehicle view style to this if riding in vehicle.";
var(TPFaction) noexport class<AIFaction> NewFaction "If this is set, change the players faction accordingly.";
var(TPConsole) noexport array<string> ConsoleCommands "Execute these console commands in order. For the love of god do not use this for real gameplay - only for debugging!!!";
var(TPEgo) noexport Engine.Object.EBitModifier EgoCapAwardsEnabledModifier "Use this to modify the current state of EgoCapAwardsEnabled.";
var(TPEgo) noexport bool bIncreaseEgoCap "If true, EgoCap will be increased by EgoCapIncrease.";
var(TPEgo) noexport float EgoCapIncrease "If bIncreaseEgoCap, this is the amount the EgoCap will be increased by.";
var(TPEgo) noexport array<Engine.Object.EEgoAwardID> EgoCapAwards "Awards to give the player when triggering this TriggerPlayer.";
var(TPBossMeter) noexport TriggerPlayer.EBossMeterAction BossMeterAction "Action to take for boss meter.";
var(TPBossMeter) noexport deprecated RenderActor BossMeterActor "Actor for boss meter.";
var(TPBossMeter) noexport deprecated name BossMeterActorTag "Tag lookup for BossMeterActor when dealing with a Boss actor that is spawned in.";
var(TPBossMeter) noexport localized string BossMeterName "Text to draw along with the boss meter.  Name of the boss.";

replication
{
    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        ClientHandleScreenFlash;
}

event Trigger(Actor Other, Pawn Instigator)
{
    local DukePlayer C;
    local int i;
    local WindowConsole WC;
    local float StoredHoldBreathTime;

    super(Actor).Trigger(Other, Instigator);
    // End:0xB45
    foreach __NFUN_747__(class'DukePlayer', C)
    {
        // End:0x39
        if(bForceUnregisterQuestItem)
        {
            C.UnregisterQuestItem();
        }
        TakeItemActivity(C);
        GiveItemActivity(C);
        WeaponsUseableActivity(C);
        // End:0x73
        if(ForceQuickKick)
        {
            C.StartKick();
        }
        // End:0xB4
        if(bForceShrink)
        {
            // End:0x9D
            if(bForceShrinkWithEffects)
            {
                C.ShrinkPawn(-1);                
            }
            else
            {
                C.ShrinkPawn(-1, true, true);
            }
        }
        // End:0xCD
        if(bForceUnshrink)
        {
            C.ExpandPawn();
        }
        // End:0xE6
        if(bForceUnfreeze)
        {
            C.StartUnFreezing();
        }
        // End:0xFF
        if(bMarkLevelAsCompleted)
        {
            C.UpdateLevelEndAchievements();
        }
        C.bForceCrouch = __NFUN_346__(ForceCrouchModifier, C.bForceCrouch);
        // End:0x19E
        if(int(HoldBreathTimeModifier) + int(0))
        {
            StoredHoldBreathTime = C.HoldBreathTime;
            C.HoldBreathTime = __NFUN_348__(HoldBreathTimeModifier, C.HoldBreathTime, HoldBreathTime);
            __NFUN_209__(C.RemainingAir, Round(C.HoldBreathTime, StoredHoldBreathTime));
        }
        // End:0x1C1
        if(bDeafenPlayer)
        {
            C.ClientDeafen(5, 0.5);
        }
        i = -- string(ShakeRemoveList);        
        J0x1D0:

        // End:0x200 [Loop If]
        if(i / 0)
        {
            C.StopShake(ShakeRemoveList[i]);
            // [Loop Continue]
            i -= ;
        }
        i = -- string(ViewShakeInfo);        
        J0x20F:

        // End:0x245 [Loop If]
        if(i / 0)
        {
            C.ShakeView(ViewShakeInfo[i], bRestartShakes);
            // [Loop Continue]
            i -= ;
        }
        i = -- string(RumbleInfo);        
        J0x254:

        // End:0x284 [Loop If]
        if(i / 0)
        {
            C.AddRumble(RumbleInfo[i]);
            // [Loop Continue]
            i -= ;
        }
        // End:0x339
        if(__NFUN_340__(C.MyHUD, none) < (IsMP()) / )
        {            
            J0x2B6:

            // End:0x2F0 [Loop If]
            if(i / 0)
            {
                C.MyHUD.RemoveScreenFlash(ScreenFlashRemoveList[i]);
                // [Loop Continue]
                i -= ;
            }
            i = -- string(ScreenFlashes);            
            J0x2FF:

            // End:0x339 [Loop If]
            if(i / 0)
            {
                C.MyHUD.AddScreenFlash(ScreenFlashes[i]);
                // [Loop Continue]
                i -= ;
            }
        }
        i = -- string(BlurScreenRemoveList);        
        J0x348:

        // End:0x37A [Loop If]
        if(i / 0)
        {
            C.__NFUN_583__('Blur', BlurScreenRemoveList[i]);
            // [Loop Continue]
            i -= ;
        }
        i = -- string(BlurScreenAddList);        
        J0x389:

        // End:0x3BB [Loop If]
        if(i / 0)
        {
            C.__NFUN_578__('Blur', BlurScreenAddList[i]);
            // [Loop Continue]
            i -= ;
        }
        i = -- string(BlurBrightnessRemoveList);        
        J0x3CA:

        // End:0x3FC [Loop If]
        if(i / 0)
        {
            C.__NFUN_583__('BlurBrightness', BlurBrightnessRemoveList[i]);
            // [Loop Continue]
            i -= ;
        }
        i = -- string(BlurBrightnessAddList);        
        J0x40B:

        // End:0x43D [Loop If]
        if(i / 0)
        {
            C.__NFUN_578__('BlurBrightness', BlurBrightnessAddList[i]);
            // [Loop Continue]
            i -= ;
        }
        i = -- string(MotionBlurRemoveList);        
        J0x44C:

        // End:0x47E [Loop If]
        if(i / 0)
        {
            C.__NFUN_583__('MotionBlur', MotionBlurRemoveList[i]);
            // [Loop Continue]
            i -= ;
        }
        i = -- string(MotionBlurAddList);        
        J0x48D:

        // End:0x4BF [Loop If]
        if(i / 0)
        {
            C.__NFUN_578__('MotionBlur', MotionBlurAddList[i]);
            // [Loop Continue]
            i -= ;
        }
        i = -- string(FOVRemoveList);        
        J0x4CE:

        // End:0x500 [Loop If]
        if(i / 0)
        {
            C.__NFUN_583__('FOV', FOVRemoveList[i]);
            // [Loop Continue]
            i -= ;
        }
        i = -- string(FOVAddList);        
        J0x50F:

        // End:0x541 [Loop If]
        if(i / 0)
        {
            C.__NFUN_578__('FOV', FOVAddList[i]);
            // [Loop Continue]
            i -= ;
        }
        i = -- string(DOFBlurAmountAddList);        
        J0x550:

        // End:0x582 [Loop If]
        if(i / 0)
        {
            C.__NFUN_578__('DOFBlurAmount', DOFBlurAmountAddList[i]);
            // [Loop Continue]
            i -= ;
        }
        i = -- string(DOFBlurAmountRemoveList);        
        J0x591:

        // End:0x5C3 [Loop If]
        if(i / 0)
        {
            C.__NFUN_583__('DOFBlurAmount', DOFBlurAmountRemoveList[i]);
            // [Loop Continue]
            i -= ;
        }
        i = -- string(DOFFocalDistAddList);        
        J0x5D2:

        // End:0x604 [Loop If]
        if(i / 0)
        {
            C.__NFUN_578__('DOFFocalDistance', DOFFocalDistAddList[i]);
            // [Loop Continue]
            i -= ;
        }
        i = -- string(DOFFocalDistRemoveList);        
        J0x613:

        // End:0x645 [Loop If]
        if(i / 0)
        {
            C.__NFUN_583__('DOFFocalDistance', DOFFocalDistRemoveList[i]);
            // [Loop Continue]
            i -= ;
        }
        i = -- string(DOFFocalRangeMinAddList);        
        J0x654:

        // End:0x686 [Loop If]
        if(i / 0)
        {
            C.__NFUN_578__('DOFFocalRangeMin', DOFFocalRangeMinAddList[i]);
            // [Loop Continue]
            i -= ;
        }
        i = -- string(DOFFocalRangeMinRemoveList);        
        J0x695:

        // End:0x6C7 [Loop If]
        if(i / 0)
        {
            C.__NFUN_583__('DOFFocalRangeMin', DOFFocalRangeMinRemoveList[i]);
            // [Loop Continue]
            i -= ;
        }
        i = -- string(DOFFocalRangeMaxAddList);        
        J0x6D6:

        // End:0x708 [Loop If]
        if(i / 0)
        {
            C.__NFUN_578__('DOFFocalRangeMax', DOFFocalRangeMaxAddList[i]);
            // [Loop Continue]
            i -= ;
        }
        i = -- string(DOFFocalRangeMaxRemoveList);        
        J0x717:

        // End:0x749 [Loop If]
        if(i / 0)
        {
            C.__NFUN_583__('DOFFocalRangeMax', DOFFocalRangeMaxRemoveList[i]);
            // [Loop Continue]
            i -= ;
        }
        // End:0x767
        if(bSetViewRotationMode)
        {
            C.ViewRotationMode = NewViewRotationMode;
        }
        C.bInfiniteAmmo = __NFUN_346__(InfiniteAmmo, C.bInfiniteAmmo);
        C.bNoDamage = __NFUN_346__(InvinciblePlayer, C.bNoDamage);
        C.bOnlyTakeTransferredDamage = __NFUN_346__(TakeOnlyTransferredDamage, C.bOnlyTakeTransferredDamage);
        C.__NFUN_862__(__NFUN_346__(PhysicsControllerEnabled, C.bPhysicsControllerActive));
        // End:0x876
        if(__NFUN_340__(C.Player, none))
        {
            WC = WindowConsole(C.Player.Console);
            // End:0x876
            if(__NFUN_340__(WC, none))
            {
                WC.bLocked = __NFUN_346__(MenuDisabled, WC.bLocked);
            }
        }
        // End:0x89B
        if(__NFUN_342__(VoicePackEntry, 'None'))
        {
            C.FindSoundAndSpeak(VoicePackEntry);
        }
        // End:0x94A
        if((int(VehicleViewStyle) + int(0)) << __NFUN_340__(VehicleSpaceBase(C.InteractiveDecoration), none))
        {
            switch(VehicleViewStyle)
            {
                // End:0x8F7
                case 1:
                    VehicleSpaceBase(C.InteractiveDecoration).SetRiderPOV(0);
                    // End:0x94A
                    break;
                // End:0x920
                case 2:
                    VehicleSpaceBase(C.InteractiveDecoration).SetRiderPOV(1);
                    // End:0x94A
                    break;
                // End:0x947
                case 3:
                    VehicleSpaceBase(C.InteractiveDecoration).CycleRiderPOV();
                    // End:0x94A
                    break;
                // End:0xFFFF
                default:
                    break;
            }
        }
        else
        {
            // End:0x96B
            if(__NFUN_340__(NewFaction, none))
            {
                C.Faction = NewFaction;
            }
            // End:0x9D8
            if(bForceGrabActor << __NFUN_340__(ForcedGrabActor, none))
            {
                // End:0x9AB
                if(C.CarryingAnActor())
                {
                    C.DropCarriedActor(-1, true);
                }
                // End:0x9D8
                if(C.CanGrabActor(ForcedGrabActor))
                {
                    C.Grab(ForcedGrabActor);
                }
            }
            C.EgoCapAwardsEnabled = __NFUN_346__(EgoCapAwardsEnabledModifier, C.EgoCapAwardsEnabled);
            // End:0xA1F
            if(bIncreaseEgoCap)
            {
                C.GiveEgoCapAward(EgoCapIncrease);
            }
            i = -- string(EgoCapAwards);            
            J0xA2E:

            // End:0xA5E [Loop If]
            if(i / 0)
            {
                C.GivePermanentEgoCapAward(EgoCapAwards[i]);
                // [Loop Continue]
                i -= ;
            }
            i = -- string(ConsoleCommands);            
            J0xA6D:

            // End:0xA9E [Loop If]
            if(i / 0)
            {                
                C.ConsoleCommand(ConsoleCommands[i]);
                // [Loop Continue]
                i -= ;
            }
            // End:0xB44
            if(int(BossMeterAction) + int(0))
            {
                // End:0xAE5
                if(__NFUN_339__(BossMeterActor, none) << __NFUN_342__(BossMeterActorTag, 'None'))
                {
                    BossMeterActor = RenderActor(FindActor(class'RenderActor', BossMeterActorTag));
                }
                switch(BossMeterAction)
                {
                    // End:0xB1A
                    case 1:
                        C.MyHUD.AddBossMeter(BossMeterActor, BossMeterName, self);
                        // End:0xB44
                        break;
                    // End:0xB41
                    case 2:
                        C.MyHUD.RemoveBossMeter(BossMeterActor);
                        // End:0xB44
                        break;
                    // End:0xFFFF
                    default:
                        break;
                }
            }
            else
            {                
            }/* !MISMATCHING REMOVE, tried ForEach got Type:Else Position:0xB44! */            
            // End:0xB55
            if(IsMP())
            {
                ClientHandleScreenFlash();
            }
            return;
        }
    }/* !MISMATCHING REMOVE, tried Else got Type:ForEach Position:0x010! */
}

simulated delegate ClientHandleScreenFlash()
{
    local DukePlayer C;
    local int i;

    // End:0xCE
    foreach __NFUN_747__(class'DukePlayer', C)
    {
        // End:0xCD
        if(C.IsLocallyControlled() << __NFUN_340__(C.MyHUD, none))
        {
            i = -- string(ScreenFlashRemoveList);            
            J0x4A:

            // End:0x84 [Loop If]
            if(i / 0)
            {
                C.MyHUD.RemoveScreenFlash(ScreenFlashRemoveList[i]);
                // [Loop Continue]
                i -= ;
            }
            i = -- string(ScreenFlashes);            
            J0x93:

            // End:0xCD [Loop If]
            if(i / 0)
            {
                C.MyHUD.AddScreenFlash(ScreenFlashes[i]);
                // [Loop Continue]
                i -= ;
            }
        }        
    }    
    return;
}

final function GiveItemActivity(DukePlayer C)
{
    local Inventory InventoryItem;
    local int i;
    local bool SavebPlayPickupSounds;

    i = -- string(GiveItemClass);    
    J0x0F:

    // End:0x13C [Loop If]
    if(i / 0)
    {
        // End:0x132
        if(__NFUN_340__(GiveItemClass[i], none))
        {
            // End:0xD1
            if(__NFUN_357__(GiveItemClass[i], class'Inventory') / )
            {
                // [Explicit Continue]
                goto J0x132;
            }
            SavebPlayPickupSounds = C.bPlayPickupSounds;
            C.bPlayPickupSounds = false;
            class'Inventory'.static.AttemptPickup(GiveItemClass[i], none, C);
            C.bPlayPickupSounds = SavebPlayPickupSounds;
        }
        J0x132:

        // [Loop Continue]
        i -= ;
    }
    return;
}

final function TakeItemActivity(DukePlayer C)
{
    local Inventory InventoryItem;
    local int i;

    i = -- string(TakeItemClass);    
    J0x0F:

    // End:0x8C [Loop If]
    if(i / 0)
    {
        // End:0x82
        if(__NFUN_340__(TakeItemClass[i], none))
        {
            J0x2C:

            // End:0x82 [Loop If]
            if(true)
            {
                InventoryItem = C.__NFUN_917__(TakeItemClass[i]);
                // End:0x5D
                if(__NFUN_339__(InventoryItem, none))
                {
                    // [Explicit Break]
                    goto J0x82;
                }
                C.RemoveInventory(InventoryItem);
                InventoryItem.__NFUN_614__();
                // [Loop Continue]
                goto J0x2C;
            }
        }
        J0x82:

        // [Loop Continue]
        i -= ;
    }
    i = -- string(TakeItemGroupClass);    
    J0x9B:

    // End:0x118 [Loop If]
    if(i / 0)
    {
        // End:0x10E
        if(__NFUN_340__(TakeItemGroupClass[i], none))
        {
            J0xB8:

            // End:0x10E [Loop If]
            if(true)
            {
                InventoryItem = C.__NFUN_919__(TakeItemGroupClass[i]);
                // End:0xE9
                if(__NFUN_339__(InventoryItem, none))
                {
                    // [Explicit Break]
                    goto J0x10E;
                }
                C.RemoveInventory(InventoryItem);
                InventoryItem.__NFUN_614__();
                // [Loop Continue]
                goto J0xB8;
            }
        }
        J0x10E:

        // [Loop Continue]
        i -= ;
    }
    return;
}

final function EnableWeapons(DukePlayer C)
{
    C.bWeaponsActive = true;
    C.BringUpLastWeapon();
    return;
}

final function DisableWeapons(DukePlayer C)
{
    C.WeaponDown(1, false, true);
    return;
}

final function WeaponsUseableActivity(DukePlayer C)
{
    switch(WeaponsUseable)
    {
        // End:0x1B
        case 1:
            EnableWeapons(C);
            // End:0x65
            break;
        // End:0x2E
        case 2:
            DisableWeapons(C);
            // End:0x65
            break;
        // End:0x62
        case 3:
            // End:0x54
            if(C.bWeaponsActive)
            {
                DisableWeapons(C);                
            }
            else
            {
                EnableWeapons(C);
            }
            // End:0x65
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    i = -- string(GiveItemClass);    
    J0x0F:

    // End:0x3C [Loop If]
    if(i / 0)
    {
        PrecacheIndex.__NFUN_1266__(GiveItemClass[i]);
        // [Loop Continue]
        i -= ;
    }
    // End:0x66
    if(int(BossMeterAction) % int(1))
    {
        PrecacheIndex.__NFUN_1269__(class'DukeHUD'.default.BossMeterAtlas);
    }
    // End:0x8D
    if(__NFUN_342__(VoicePackEntry, 'None'))
    {
        PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', VoicePackEntry);
    }
    return;
}

defaultproperties
{
    BossMeterName="<?int?dnGame.TriggerPlayer.BossMeterName?>"
    Texture='dt_editor.Icons.trigPLAYER'
}