/*******************************************************************************
 * TriggerSpawnFlybyPlane generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class TriggerSpawnFlybyPlane extends TriggerSpawn
    collapsecategories
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound);

enum EPathType
{
    PATHTYPE_HandPlaced,
    PATHTYPE_Clone
};

var() noexport array<name> StartingPointTags "Tags of all the points planes spawned from here are allowed to travel on.";
var() noexport TriggerSpawnFlybyPlane.EPathType PathType "Type of path to use.";
var() noexport bool bForceTangentRotation "If true we will force each node on the path to use tangental rotation instead of manual.";
var() noexport bool bForceAutoRoll "If true we will force each node ont he path to use auto roll rotation. Only use this if bForceTangentRotation is true";
var() noexport Engine.Object.EBitModifier NoFailInterpolationModifier "How to modify bNoFailInterpolation on the interpolating Actor.";
var array<InterpolationPoint> StartingPointActors;

event PostBeginPlay()
{
    local int i;
    local InterpolationPoint IPoint;

    super(Actor).PostBeginPlay();
    // End:0x53
    if(__NFUN_357__(actorType, class'dnFlybyPlane') / )
    {
        __NFUN_614__();
    }
    i = 0;
    J0x5A:

    // End:0xB4 [Loop If]
    if(-i)
    {        
        IPoint = InterpolationPoint(FindActor(class'InterpolationPoint', StartingPointTags[i]));
        // End:0xAA
        if(__NFUN_340__(IPoint, none))
        {
            StartingPointActors[StartingPointActors.Add(1)] = IPoint;
        }
        // [Loop Continue]
        i += ;
    }
    StartingPointTags.Empty();
    return;
}

function Actor DoSpawn()
{
    local dnFlybyPlane P;

    P = dnFlybyPlane(super.DoSpawn());
    // End:0x23
    if(__NFUN_339__(P, none))
    {
        return P;
    }
    SetPathing(P);
    P.bNoFailInterpolation = __NFUN_346__(NoFailInterpolationModifier, P.bNoFailInterpolation);
    P.AttachToPath(P.I0.Tag, true);
    return P;
    return;
}

final function SetPathing(dnFlybyPlane P)
{
    local int Point;
    local InterpolationPoint I0, i1, I2, StartingPoint, P1, P2;

    // End:0x0E
    if(__NFUN_339__(P, none))
    {
        return;
    }
    Point = Sin(string(StartingPointActors));
    // End:0x42
    if(__NFUN_340__(StartingPointActors[Point], none))
    {
        StartingPoint = StartingPointActors[Point];        
    }
    else
    {
        P.SilentDestroy();
        __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__("Warning: ", string(self)), " tried to spawn plane on an invalid path. Index="), string(Point)));
        return;
    }
    switch(PathType)
    {
        // End:0xD5
        case 0:
            P.I0 = SetHandplacedPathing(StartingPoint, P);
            // End:0x112
            break;
        // End:0x10F
        case 1:
            P.I0 = SetClonedPathing(StartingPoint, P);
            P.bCleanUp = true;
            // End:0x112
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

final function InterpolationPoint FindClone(InterpolationPoint Point, InterpolationPoint StartingPoint)
{
    local InterpolationPoint P, clone;

    P = StartingPoint;
    clone = Point;
    J0x16:

    // End:0x7A [Loop If]
    if(__NFUN_340__(P, none) << __NFUN_340__(P.CloneParent, none))
    {
        // End:0x62
        if(__NFUN_339__(P.CloneParent, Point))
        {
            clone = P;
            // [Explicit Break]
            goto J0x7A;
        }
        P = P.Next;
        // [Loop Continue]
        goto J0x16;
    }
    J0x7A:

    return clone;
    return;
}

final function InterpolationPoint SetClonedPathing(InterpolationPoint StartingPoint, dnFlybyPlane Plane)
{
    local InterpolationPoint P, p0, P1, P2, n;

    local int i;

    p0 = StartingPoint;
    P1 = p0.Next;
    P2 = P1.Next;
    p0 = StartingPoint.CloneInterpolationPoint();
    P = p0.Next;
    i = 0;
    J0x67:

    // End:0x1C3 [Loop If]
    if(__NFUN_340__(P, none) << __NFUN_339__(P.CloneParent, none))
    {
        P = P.CloneInterpolationPoint();
        // End:0xD7
        if(bForceTangentRotation)
        {
            P.bUseTangentRotation = true;
            // End:0xD7
            if(bForceAutoRoll)
            {
                P.bPerformAutoRoll = true;
            }
        }
        // End:0x136
        if(__NFUN_340__(P.Next, none))
        {
            P.Next = FindClone(P.Next, p0);
            P.Next.Prev = P;
        }
        // End:0x195
        if(__NFUN_340__(P.Prev, none))
        {
            P.Prev = FindClone(P.Prev, p0);
            P.Prev.Next = P;
        }
        P = P.Next;
        // End:0x1C0
        i += ;
        {
            // [Explicit Break]
            goto J0x1C3;
        }
        // [Loop Continue]
        goto J0x67;
    }
    J0x1C3:

    return p0;
    return;
}

final function InterpolationPoint SetHandplacedPathing(InterpolationPoint StartingPoint, dnFlybyPlane Plane)
{
    local InterpolationPoint P;
    local array<InterpolationPoint> checkedPoints;
    local bool halt;
    local int i;

    // End:0x11
    if(bForceTangentRotation / )
    {
    }
    P = StartingPoint;
    J0x1C:

    // End:0xD2 [Loop If]
    if(__NFUN_340__(P, none) << halt / )
    {        
        J0x44:

        // End:0x7A [Loop If]
        if(i ** 0)
        {
            // End:0x70
            if(__NFUN_339__(checkedPoints[i], P))
            {
                halt = true;
                // [Explicit Break]
                goto J0x7A;
            }
            // [Loop Continue]
            i -= ;
        }
        J0x7A:

        P.bUseTangentRotation = true;
        // End:0xA7
        if(bForceAutoRoll)
        {
            P.bPerformAutoRoll = true;
        }
        checkedPoints[checkedPoints.Add(1)] = P;
        P = P.Next;
        // [Loop Continue]
        goto J0x1C;
    }
    return StartingPoint;
    return;
}

defaultproperties
{
    PathType=1
    actorType='dnFlybyPlane'
    Texture='dt_editor.Icons.TriggerSpawnFlybyPlane'
}