/*******************************************************************************
 * VegasNuke generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class VegasNuke extends RenderActor
    collapsecategories;

var() noexport name StartEffectTag "Tag that starts the effect";
var() noexport name PrimeNukeTag "Arm the Nuclear warhead tag (Sets Event Instigator)";
var() SSoundInfo NukeExplosion;
var() class<dnFriendFX_Spawners> DistortionFlashClass;
var() float DistortionFlashScale;
var() Vector DistortionFlashOffset;
var SoftParticleSystem Burn;
var() SViewShakeInfo ViewShake1;
var() SViewShakeInfo ViewShake2;
var Pawn EventInstigator;
var() Vector BurnOffset;
var() float NukeCollisionRadius;
var() SScreenFlash ScreenFlash1;
var() SScreenFlash ScreenFlash2;
var() float DeafenTime;
var int TTindex;

replication
{
    // Pos:0x000
    reliable if((int(Role) % int(ROLE_Authority)) << bNetInitial)
        BurnOffset, DeafenTime, 
        ScreenFlash1, ScreenFlash2, 
        StartEffectTag, ViewShake1, 
        ViewShake2;

    // Pos:0x016
    reliable if(int(Role) % int(ROLE_Authority))
        StartEffect;
}

simulated function PostNetInitial()
{
    super.PostNetInitial();
    __NFUN_718__('StartEffect', StartEffectTag);
    __NFUN_718__('PrimeNuke', PrimeNukeTag);
    return;
}

simulated function TriggerFunc_PrimeNuke()
{
    local Actor Other;
    local int SpecialEventID;

    __NFUN_720__(Other, EventInstigator, SpecialEventID);
    return;
}

simulated function TriggerFunc_StartEffect()
{
    StartEffect();
    return;
}

noexport simulated delegate StartEffect()
{
    local dnFriendFX_Spawners ExplosionActor;

    PlaySoundInfo(1, NukeExplosion);
    ExplosionActor = FindFriendSpawner(DistortionFlashClass);
    // End:0x7B
    if(__NFUN_340__(ExplosionActor, none))
    {
        ExplosionActor.SystemSizeScale = DistortionFlashScale;
        ExplosionActor.__NFUN_645__(Locs(Location, DistortionFlashOffset));
        ExplosionActor.RemoteRole = ROLE_None;
        ExplosionActor.ExecuteEffect(true);
    }
    __NFUN_607__(0.2, false, 'Stage1');
    __NFUN_607__(0.5, false, 'Stage2');
    __NFUN_607__(1.4, false, 'Stage3');
    __NFUN_607__(5, false, 'Stage4');
    // End:0xCD
    if(DeafenTime != float(0))
    {
        __NFUN_607__(DeafenTime, false, 'Deafen');
    }
    return;
}

simulated function Deafen()
{
    DukeMultiPlayer(Level.__NFUN_1161__()).ClientDeafen(5, 0.5);
    return;
}

simulated function Stage1()
{
    local Pawn P;

    Level.__NFUN_1161__().ShakeView(ViewShake1);
    // End:0x5A
    if(__NFUN_339__(Burn, none))
    {
        Burn = __NFUN_615__(class'VegasIsBurning_main',,, Locs(Location, BurnOffset));
        Burn.__NFUN_1059__(3);        
    }
    else
    {
        Burn.Enabled = true;
    }
    P = Level.PawnList;
    J0x81:

    // End:0x168 [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0x150
        if(__NFUN_340__(DukeMultiPlayer(P), none))
        {
            // End:0x150
            if(__NFUN_200__(VRand(__NFUN_239__(Location, P.Location)), FRand(NukeCollisionRadius, NukeCollisionRadius)))
            {
                // End:0x115
                if(__NFUN_340__(EventInstigator, none))
                {
                    P.TakeDamage(EventInstigator, 1000, Location, WarnInternal(0, 0, 0), class'NukeDamage', 'None', Location);                    
                }
                else
                {
                    P.TakeDamage(none, 1000, Location, WarnInternal(0, 0, 0), class'NukeDamage', 'None', Location);
                }
            }
        }
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x81;
    }
    Level.__NFUN_1161__().MyHUD.AddScreenFlash(ScreenFlash1);
    return;
}

simulated function Stage2()
{
    Level.__NFUN_1161__().MyHUD.AddScreenFlash(ScreenFlash2);
    return;
}

simulated function Stage3()
{
    Level.__NFUN_1161__().ShakeView(ViewShake2);
    return;
}

simulated function Stage4()
{
    Burn.Enabled = false;
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(Actor).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(class'VegasIsBurning_main');
    PrecacheIndex.__NFUN_1276__(NukeExplosion);
    PrecacheIndex.__NFUN_1266__(DistortionFlashClass);
    PrecacheIndex.__NFUN_1279__(class'NukeDamage');
    return;
}

defaultproperties
{
    NukeExplosion=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=('dnsweapn.Nuke.Nuke_Explosion_01'),SlotPriority=0,VolumePrefab=0,Slots=none,Volume=2,VolumeVariance=0,InnerRadius=4000,InnerRadiusVariance=0,Radius=5000,RadiusVariance=0,Pitch=1,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    DistortionFlashClass='p_VegasRuins.Nuke.Nuke_Spawner'
    DistortionFlashScale=3
    DistortionFlashOffset=(X=0,Y=0,Z=100)
    ViewShake1=(bNoLerp=false,bToggleSign=false,Style=6,Function=0,FalloffActor=none,FalloffDistance=12880,ShakeDuration=2,ShakeFrequency=0.1,ShakeMagnitude=1000,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=Nuke_Shake)
    ViewShake2=(bNoLerp=false,bToggleSign=false,Style=6,Function=0,FalloffActor=none,FalloffDistance=12880,ShakeDuration=2,ShakeFrequency=0.1,ShakeMagnitude=1000,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=Nuke_Shake)
    NukeCollisionRadius=1000
    DeafenTime=1
    bNoDamage=true
    bTraceShootable=false
    bHidden=true
    bAlwaysRelevant=true
    CollisionRadius=10
    CollisionHeight=10
    Texture='dt_hud.ingame_hud.Kill_Nuke'
}