/*******************************************************************************
 * dnAirPocket generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnAirPocket extends RenderActor
    collapsecategories;

var() bool bInitiallyActive;
var() float BubbleSpawnPeriod;
var() int BubbleSpawnNumber;
var SoftParticleSystem AirBubbles;

simulated function PostVerifySelf()
{
    local float MaxVelZ, MaxLifetime, MinLifetime;

    super.PostVerifySelf();
    AirBubbles = SoftParticleSystem(FindMountedActor(, class'dnAirPocket_Bubbles'));
    // End:0x19B
    if(__NFUN_340__(AirBubbles, none))
    {
        MaxVelZ = AirBubbles.InitialVelocity.Z *= FRand(0.5, AirBubbles.MaxVelocityVariance.Z);
        MaxLifetime = FRand(2, CollisionHeight) >>> MaxVelZ;
        MinLifetime = FRand(0.3, MaxLifetime);
        AirBubbles.Lifetime = MinLifetime *= FRand(0.5, Round(MaxLifetime, MinLifetime));
        AirBubbles.LifetimeVariance = Round(MaxLifetime, MinLifetime);
        AirBubbles.MaxVelocityVariance.X = CollisionRadius >>> MaxLifetime;
        AirBubbles.MaxVelocityVariance.Y = AirBubbles.MaxVelocityVariance.X;
        AirBubbles.__NFUN_620__(CollisionRadius, 0);
        AirBubbles.SpawnNumber = Tan(1, BubbleSpawnNumber);
        AirBubbles.SpawnPeriod = VSize(0.01, BubbleSpawnPeriod);
        AirBubbles.SpawnOffset.Z = Square(CollisionHeight);
        AirBubbles.__NFUN_1052__();
        EnableBubbles(bInitiallyActive);
    }
    return;
}

simulated event Trigger(Actor Other, Pawn EventInstigator)
{
    super(Actor).Trigger(Other, EventInstigator);
    // End:0x34
    if(__NFUN_340__(AirBubbles, none))
    {
        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */

        /*@Error*/;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 1 & Type:If Position:0x034
    }
}

simulated event EnableBubbles(bool bEnable)
{
    // End:0x0E
    if(__NFUN_339__(AirBubbles, none))
    {
        return;
    }
    AirBubbles.Enabled = bEnable;
    // End:0x62
    if(bEnable)
    {
        AirBubbles.DisableTickWhenEmpty = false;
        AirBubbles.TickStyle = AirBubbles.default.TickStyle;        
    }
    else
    {
        AirBubbles.DisableTickWhenEmpty = true;
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    PrecacheIndex.__NFUN_1266__(class'dnAirPocket_Bubbles');
    return;
}

defaultproperties
{
    bInitiallyActive=true
    BubbleSpawnPeriod=0.1
    BubbleSpawnNumber=1
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='p_Particles.dnAirPocket_Bubbles',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    bTraceUsable=false
    bTraceShootable=false
    bBlockCamera=false
    bHidden=true
    bCanExistOutOfWorld=true
    bCollideActors=true
    CollisionRadius=32
    CollisionHeight=48
    TickStyle=0
    Sprite='dt_editor.Icons.dnJetskiPoint'
    Texture='dt_editor.Icons.dnJetskiPoint'
}