/*******************************************************************************
 * dnControlRemapperEx_Turret generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnControlRemapperEx_Turret extends dnControlRemapperEx_GenericDecoration
    collapsecategories;

var bool bViewOn;
var bool bNoFadeView;
var float CRViewAlphaFadeTime;
var float CRViewAlphaFadeStartTime;
var float CRViewAlphaTarget;

simulated function PawnAttach(Pawn Attachee, bool bForceComplete)
{
    bNoFadeView = bForceComplete;
    super(ControlRemapperEx).PawnAttach(Attachee, bForceComplete);
    return;
}

simulated function EnterState_CRS_FullyAttached()
{
    super(ControlRemapperEx).EnterState_CRS_FullyAttached();
    bViewOn = true;
    CRViewAlphaFadeStartTime = Level.GameTimeSeconds;
    CRViewAlphaTarget = 1;
    return;
}

simulated function PrepareForDetach()
{
    super(ControlRemapperEx).PrepareForDetach();
    bNoFadeView = false;
    CRViewAlphaFadeStartTime = Level.GameTimeSeconds;
    CRViewAlphaTarget = 0;
    return;
}

simulated function EnterState_CRS_NoUserAttached()
{
    super(ControlRemapperEx).EnterState_CRS_NoUserAttached();
    bViewOn = false;
    return;
}

simulated event CalcView(Actor CameraActor, out Vector CameraLocation, out Rotator CameraRotation)
{
    local dnControl_Turret MountTurret;
    local float CRViewAlpha;
    local Rotator CRCameraRotation, diff;

    super(ControlRemapperEx).CalcView(CameraActor, CameraLocation, CameraRotation);
    // End:0x23
    if(__NFUN_339__(CurrentPlayer, none))
    {
        return;
    }
    // End:0xA1
    if(bViewOn)
    {
        // End:0x43
        if(bNoFadeView)
        {
            CRViewAlpha = 1;            
        }
        else
        {
            CRViewAlpha = Round(Level.GameTimeSeconds, CRViewAlphaFadeStartTime) >>> CRViewAlphaFadeTime;
            // End:0x80
            if(Repl(CRViewAlpha, 1))
            {
                CRViewAlpha = 1;
            }
        }
        // End:0xA1
        if(__NFUN_204__(CRViewAlphaTarget, 0))
        {
            CRViewAlpha = Round(1, CRViewAlpha);
        }
    }
    CRCameraRotation = Rotator(Vector(CameraRotation));
    diff = SetCollisionSize(CRCameraRotation >> CameraRotation);
    Trace(CameraRotation, SetLocation(CRViewAlpha, diff));
    MountTurret = dnControl_Turret(MountParent);
    // End:0x13F
    if(__NFUN_340__(MountTurret, none))
    {
        Min(CameraLocation, __NFUN_263__(Caps(CRViewAlpha, MountTurret.TurretViewLocationOffset), CameraRotation));
        CameraRotation = __NFUN_269__(SetLocation(CRViewAlpha, MountTurret.TurretViewRotationOffset), CameraRotation);
    }
    CurrentPlayer.ViewRotation = CameraRotation;
    return;
}

defaultproperties
{
    CRViewAlphaFadeTime=2.5
}