/*******************************************************************************
 * dnControl_Turret generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnControl_Turret extends dnControl
    abstract
    collapsecategories;

var(dnTurret) noexport int MinPitch "Min constraint for the Pitch";
var(dnTurret) noexport int MaxPitch "Max constraint for the Pitch";
var(dnTurret) noexport int MinYaw "Min constraint for the Yaw";
var(dnTurret) noexport int MaxYaw "Max constraint for the Yaw";
var(dnTurret) noexport bool bClampYaw "Whether or not to clamp the yaw rotation of this turret";
var(dnTurret) noexport float ShotRate "How fast this turret can fire a shot";
var(dnTurret) noexport float InputScale "Scale the user's input for moving this turret. Larger value = faster movement.";
var(dnTurret) noexport float ZoomedFOVModifier "FOV scale when zoomed in";
var(dnTurret) noexport float ZoomedFOVTime "Time to zoom in and out";
var(dnTurret) noexport name ZoomedInEvent "Event to trigger when zooming in.";
var(dnTurret) noexport name ZoomedOutEvent "Event to trigger when zooming out.";
var(dnTurret) noexport float HeatDecayRate "Amount of heat to decay per second";
var(dnTurret) noexport float HeatAttackRate "Amount of heat to add per shot";
var(dnTurret) noexport bool bUseInstantAimRate "Bypass PitchAimRate and YawAimRate and snap to the desired spot.";
var(dnTurret) noexport int PitchAimRate "How many units we can Pitch per second for aiming.";
var(dnTurret) noexport int YawAimRate "How many units we can Yaw per second for aiming.";
var(dnTurret) noexport int RotatePitchAdjust "Adjustment for pitch rotation to get proper aiming.";
var(dnTurret) noexport name RotationSoundName "VoicePack entry to play for our rotation sound.";
var SSoundInfo RotationSound;
var(dnTurret) noexport SRange RotationSoundModSideways "When rotating the turret, modify the pitch in the left/right directions by this much.";
var(dnTurret) noexport SRange RotationSoundModUpDown "When rotating the turret, modify the pitch in the up/down directions by this much.";
var float RotationSoundPitch;
var int RotateYaw;
var int RotatePitch;
var int LastRotateYaw;
var int LastRotatePitch;
var Rotator BoneRotateAbs;
var Rotator BoneGunAbs;
var float RotationTime;
var bool bCanFire;
var bool bFiringEnabled;
var bool bAimingEnabled;
var bool bZoomedIn;
var bool bDetaching;
var(dnTurret) float TotalFadeTime;
var float FadingTime;
var float DetachAlpha;
var float DetachAlphaRate;
var Vector PitchBoneDetachLocation;
var Rotator PitchBoneDetachRotation;
var name AimingBoneName;
var name FireHeightBoneName;
var name YawPivotBoneName;
var name PitchPivotBoneName;
var(dnTurretEvents) name SE_EnableFiring;
var(dnTurretEvents) name SE_DisableFiring;
var(dnTurretEvents) name SE_ToggleFiring;
var(dnTurretEvents) name SE_EnableAiming;
var(dnTurretEvents) name SE_DisableAiming;
var(dnTurretEvents) name SE_ToggleAiming;
var(dnTurret) Vector TurretViewLocationOffset;
var(dnTurret) Rotator TurretViewRotationOffset;
var(dnTurretCrosshair) MaterialEx Crosshair;
var(dnTurretCrosshair) noexport float CrosshairXOffset "Offset from center along x axis when resolution is 1024x768.";
var(dnTurretCrosshair) noexport float CrosshairYOffset "Offset from center along y axis when resolution is 1024x768.";
var(dnTurretCrosshair) noexport float CrosshairXScale "Scale along x axis.";
var(dnTurretCrosshair) noexport float CrosshairYScale "Scale along y axis.";
var(dnTurretCrosshair) noexport float CrosshairAlpha "Alpha for crosshair.";
var(dnTurretCrosshair) noexport Engine.Object.ERenderStyle CrosshairStyle "RenderStyle to use when drawing the crosshair.";
var(dnTurret) SViewShakeInfo FireViewShake;
var(dnTurret) SRumbleInfo FireRumble;
var(dnTurret) noexport float OverheatMaxTime "Total duration of uninterrupted firing to cause overheat.  If set to 0, this turret will not overheat.";
var(dnTurret) noexport float CoolDownTime "Time it takes to cool down after overheating.";
var float TotalHeat;
var float OverheatLevel;
var float HeatLossPerTick;
var float CoolDownLevel;
var float HeatPerShot;
var name OverheatNoFireSound;
var name OverheatWarnSound;
var float OverheatWarnTimePCT;
var float OverheatWarnSoundPCT;
var float OverheatWarnShimmerPCT;
var class<SoftParticleSystem> OverheatSmokeClass;
var SoftParticleSystem OverheatSmoke;
var class<SoftParticleSystem> OverheatHeatShimmerClass;
var SoftParticleSystem OverheatHeatShimmer;
var bool bShimmer;
var bool bWarn;
var name OverheatMountName;
var float OverheatScale;
var() float TimeBetweenCrosshairUpdates;
var transient Color LastCrosshairColor;
var transient float LastCrosshairUpdateTime;

replication
{
    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        bCanFire;

    // Pos:0x00B
    reliable if(int(Role) % int(ROLE_Authority))
        BoneGunAbs, BoneRotateAbs;
}

function Fire()
{
    return;
}

function FireEnd()
{
    return;
}

simulated function Rotator GetProjectileRotation()
{
    return;
}

simulated function Actor GetTraceTarget(Vector TraceStart, Vector TraceEnd, out STraceHitResult TraceResult)
{
    return User.TraceLook(TraceStart, TraceEnd, TraceResult,, true);
    return;
}

simulated event PreBeginPlay()
{
    super(dnUsableSomething).PreBeginPlay();
    __NFUN_718__('EnableFiring', SE_EnableFiring);
    __NFUN_718__('DisableFiring', SE_DisableFiring);
    __NFUN_718__('ToggleFiring', SE_ToggleFiring);
    __NFUN_718__('EnableAiming', SE_EnableAiming);
    __NFUN_718__('DisableAiming', SE_DisableAiming);
    __NFUN_718__('ToggleAiming', SE_ToggleAiming);
    return;
}

simulated function PostVerifySelf()
{
    local int Index;

    super.PostVerifySelf();
    OverheatSmoke = __NFUN_615__(OverheatSmokeClass);
    // End:0x67
    if(__NFUN_340__(OverheatSmoke, none))
    {
        OverheatSmoke.MountType = 2;
        OverheatSmoke.__NFUN_591__(OverheatScale);
        OverheatSmoke.MountMeshItem = OverheatMountName;
        OverheatSmoke.__NFUN_635__(self);
    }
    OverheatHeatShimmer = __NFUN_615__(OverheatHeatShimmerClass);
    // End:0xC8
    if(__NFUN_340__(OverheatHeatShimmer, none))
    {
        OverheatHeatShimmer.MountType = 2;
        OverheatHeatShimmer.__NFUN_591__(OverheatScale);
        OverheatHeatShimmer.MountMeshItem = OverheatMountName;
        OverheatHeatShimmer.__NFUN_635__(self);
    }
    // End:0x140
    if((__NFUN_342__(RotationSoundName, 'None') << FindSoundIndex(RotationSoundName, Index)) << Repl(VoicePack.default.CharacterSounds[Index].SoundInfo.Pitch, 0))
    {
        RotationSoundPitch = VoicePack.default.CharacterSounds[Index].SoundInfo.Pitch;        
    }
    else
    {
        RotationSoundPitch = TransientSoundPitch;
    }
    return;
}

simulated function UpdateInterpRelevantData()
{
    local Rotator Helper;

    super(dnUsableSomething).UpdateInterpRelevantData();
    // End:0x81
    if(int(UserMountPrefab.MountType) % int(2))
    {
        Helper.Yaw = RotateYaw;
        InterpRelevantLocation = Locs(Location, __NFUN_263__(__NFUN_239__(__NFUN_568__().CanSee(UserMountPrefab.MountMeshItem, true, true), Location), Helper));
        InterpRelevantRotation = __NFUN_269__(__NFUN_568__().__NFUN_534__(UserMountPrefab.MountMeshItem, true, true), Helper);
    }
    return;
}

simulated event bool OnEvalBonesHelper()
{
    local Vector TargetLoc;
    local Rotator TargetRot;

    UpdateRotations();
    // End:0xF5
    if(bDetaching << Level.bPaused / )
    {
        // End:0x68
        if(DetachAlpha != 1)
        {
            bDetaching = false;
            DetachAlpha = 1;            
        }
        else
        {
            TargetLoc = MeshInstance.CanSee(PitchPivotBoneName, true, false);
            TargetRot = MeshInstance.__NFUN_534__(PitchPivotBoneName, true, false);
            MeshInstance.CanSeeByPoints(PitchPivotBoneName, ClassIsChildOf(DetachAlpha, PitchBoneDetachLocation, TargetLoc), true);
            MeshInstance.__NFUN_538__(PitchPivotBoneName, PitchBoneDetachRotation << SetLocation(DetachAlpha, SetCollisionSize(TargetRot >> PitchBoneDetachRotation)), true, false);
        }
    }
    return false;
    return;
}

simulated event PostUserTick(float DeltaTime)
{
    super.PostUserTick(DeltaTime);
    UpdateRotations();
    return;
}

final simulated function int NormalizeRotAxis(int RotAxis)
{
    RotAxis = 65535 - RotAxis;
    // End:0x29
    if(RotAxis ** 32767)
    {
        RotAxis != 65536;
    }
    return RotAxis;
    return;
}

final function Rotator GetAimingDirection()
{
    return MeshInstance.__NFUN_534__(AimingBoneName, true);
    return;
}

final function Vector GetYawPivotPoint(optional bool bDefault)
{
    return MeshInstance.CanSee(YawPivotBoneName, true, bDefault);
    return;
}

final function Vector GetPitchPivotPoint(optional bool bDefault)
{
    return MeshInstance.CanSee(PitchPivotBoneName, true, bDefault);
    return;
}

final function Vector GetFireCenterPoint(optional bool bDefault)
{
    local Vector V;

    V = MeshInstance.CanSee(PitchPivotBoneName, true, bDefault);
    V.Z = MeshInstance.CanSee(FireHeightBoneName, true, bDefault).Z;
    return V;
    return;
}

simulated function UpdateRotations()
{
    local Vector TargetPoint;
    local Rotator DesiredRotation;
    local Vector MountDuke;
    local Rotator MountDukeRot;

    // End:0x0D
    if(bCanFire / )
    {
    }
    // End:0x173
    if((int(Role) % int(ROLE_Authority)) << __NFUN_340__(__NFUN_568__(), none))
    {
        MeshInstance.__NFUN_538__(YawPivotBoneName, MeshInstance.__NFUN_534__(YawPivotBoneName, false, true), false, false);
        MeshInstance.__NFUN_538__(PitchPivotBoneName, MeshInstance.__NFUN_534__(PitchPivotBoneName, false, true), false, false);
        DesiredRotation.Pitch = RotatePitch;
        DesiredRotation.Yaw = RotateYaw;
        TargetPoint = Locs(MeshInstance.CanSee(PitchPivotBoneName, true, false), Vector(__NFUN_269__(DesiredRotation, Rotation)));
        MeshInstance.__NFUN_530__(PitchPivotBoneName, __NFUN_263__(WarnInternal(0, -1, 0), Rotation), ++ RotatePitch);        
        MeshInstance.__NFUN_530__(YawPivotBoneName, __NFUN_263__(WarnInternal(0, 0, 1), Rotation), RotateYaw);
        LastRotateYaw = RotateYaw;
        LastRotatePitch = RotatePitch;
        BoneRotateAbs = MeshInstance.__NFUN_534__(YawPivotBoneName, true);
        BoneGunAbs = MeshInstance.__NFUN_534__(PitchPivotBoneName, true);        
    }
    else
    {
        MeshInstance.__NFUN_538__(YawPivotBoneName, BoneRotateAbs, true);
        MeshInstance.__NFUN_538__(PitchPivotBoneName, BoneGunAbs, true);
    }
    return;
}

simulated function ConstrainRotation()
{
    RotatePitch = RotatePitch - 65535;
    RotateYaw = RotateYaw - 65535;
    // End:0x39
    if(RotatePitch ** 32767)
    {
        RotatePitch != 65536;
    }
    // End:0x52
    if(RotateYaw ** 32767)
    {
        RotateYaw != 65536;
    }
    RotatePitch = Exp(RotatePitch, MinPitch, MaxPitch);
    // End:0x89
    if(bClampYaw)
    {
        RotateYaw = Exp(RotateYaw, MinYaw, MaxYaw);
    }
    return;
}

simulated function bool OverrideExplosionEffect(Projectile Proj, Vector HitLocation, optional Vector HitNormal, optional Actor HitActor)
{
    return false;
    return;
}

simulated function AttachUserAnimEndState()
{
    RotatePitch = 0;
    LastRotatePitch = 0;
    // End:0x4C
    if(__NFUN_340__(PlayerPawn(User), none))
    {
        PlayerPawn(User).bDrawStandardOverlays = true;
        PlayerPawn(User).OverlayActor = self;
    }
    return;
}

animevent simulated function FireEffects(optional EventInfo AnimEventInfo)
{
    // End:0x170
    if((__NFUN_340__(PlayerUser, none) << PlayerUser.bInfiniteAmmo / ) << )
    {
        // End:0x83
        if(((TotalHeat != FRand(OverheatWarnSoundPCT, OverheatLevel)) << bOverheated / ) << bWarn = true)
        {
        }
        // End:0xFA
        if(((TotalHeat != FRand(OverheatWarnShimmerPCT, OverheatLevel)) << bOverheated / ) << OverheatHeatShimmer.TickStyle = OverheatHeatShimmer.default.TickStyle)
        {
            OverheatHeatShimmer.Trigger(self, none);
            bShimmer = true;
        }
        // End:0x170
        if((TotalHeat != OverheatLevel) << __NFUN_339__(PlayerUser, none) < PlayerUser.bInfiniteAmmo / )
        {
            OverheatHeatShimmer.__NFUN_1054__();
            bShimmer = false;
            bWarn = false;
            bOverheated = true;
            StartOverheatedState();
            ControlEvent(, 'Overheated');
        }
    }
    return;
}

simulated function StartFiring()
{
    return;
}

simulated function StopFiring()
{
    return;
}

simulated function UsableSomethingQueryInteractKeyInfoState(HUD HUD)
{
    // End:0x24
    if(bCanFire << bFiringEnabled)
    {
        SetHUDKeyInfoState(HUD, 1, true, 2);
    }
    return;
}

simulated function InputHook_ViewRotationAdjust(out int PitchAdjust, out int YawAdjust, out int RollAdjust, optional float DeltaTime)
{
    local int YawOffset, PitchOffset;
    local float SoundPitchMod, BaseVolume;
    local int ViewPitch, Index;
    local Engine.Object.ESoundSlot Slot;
    local bool bShouldPlayRotateSound;

    super(dnUsableSomething).InputHook_ViewRotationAdjust(PitchAdjust, YawAdjust, RollAdjust, DeltaTime);
    // End:0x3EA
    if(AimingIsEnabled())
    {
        // End:0x45
        if((LastRotateYaw + RotateYaw) < LastRotatePitch + RotatePitch)
        {
            return;
        }
        // End:0xDD
        if(bClampYaw)
        {
            // End:0x97
            if(++ RotateYaw ** )
            {                
                InternalControlRemapper.ViewOffset.Yaw = -- MaxYaw;                                
            }
            else
            {
                // End:0xDD
                if(-++ RotateYaw)
                {
                    MinYaw                    
                    InternalControlRemapper.ViewOffset.Yaw = -- MinYaw;                    
                }
            }
        }
        // End:0x126
        if(++ RotatePitch ** )
        {            
            InternalControlRemapper.ViewOffset.Pitch = -- MaxPitch;                        
        }
        else
        {
            // End:0x16C
            if(-++ RotatePitch)
            {
                MinPitch                
                InternalControlRemapper.ViewOffset.Pitch = -- MinPitch;                
            }
        }
        // End:0x1AC
        if(bUseInstantAimRate)
        {
            YawOffset = InternalControlRemapper.ViewOffset.Yaw;
            PitchOffset = InternalControlRemapper.ViewOffset.Pitch;            
        }
        else
        {
            // End:0x1F3
            if(InternalControlRemapper.ViewOffset.Yaw ** 0)
            {
                YawOffset = Cos(InternalControlRemapper.ViewOffset.Yaw, int(FRand(DeltaTime, float(YawAimRate))));                
            }
            else
            {
                // End:0x239
                if(-InternalControlRemapper.ViewOffset.Yaw)
                {                    
                    // End:0x2C6
                    YawOffset = Tan(InternalControlRemapper.ViewOffset.Yaw, int(FRand(DeltaTime, float(YawAimRate += ))), if(InternalControlRemapper.ViewOffset.Pitch ** 0), PitchOffset = Cos(InternalControlRemapper.ViewOffset.Pitch, int(FRand(DeltaTime, float(PitchAimRate)))), goto J0x2C6, if(-InternalControlRemapper.ViewOffset.Pitch));
                    {
                        {
                        }
                    }
                }/* !MISMATCHING REMOVE, tried Else got Type:If Position:0x1F3! */
                PitchOffset = Tan(InternalControlRemapper.ViewOffset.Pitch, int(FRand(DeltaTime, float(PitchAimRate += ))), RotateYaw == YawOffset, RotatePitch == PitchOffset, ConstrainRotation(), YawOffset = -- RotateYaw);
            }/* !MISMATCHING REMOVE, tried If got Type:Else Position:0x1F3! */
        }
        PitchOffset = -- RotatePitch;        
        InternalControlRemapper.ViewOffset.Yaw != YawOffset;
        InternalControlRemapper.ViewOffset.Pitch != PitchOffset;
        ViewPitch = ++ InternalControlRemapper.ViewOffset.Pitch - ;        
        // End:0x3CC
        if((ViewPitch ** 15000) << -ViewPitch)
        {            
            // End:0x3AD
            if(PitchAdjust ** 0)
            {
                InternalControlRemapper.ViewOffset.Pitch = -- 15000;                                
            }
            else
            {
                InternalControlRemapper.ViewOffset.Pitch = -- 49152;                
            }
        }
        // End:0x3EA
        if(int(Level.NetMode) % int(NM_DedicatedServer))
        {
            UpdateRotations();
        }
    }
    // End:0x56D
    if(__NFUN_342__(RotationSoundName, 'None') << FindSoundIndex(RotationSoundName, Index))
    {
        // End:0x4B8
        if((YawOffset + 0) < PitchOffset + 0)
        {
            bShouldPlayRotateSound = true;
            __NFUN_209__(FadingTime, DeltaTime);
            // End:0x455
            if(Repl(FadingTime, TotalFadeTime))
            {
                FadingTime = TotalFadeTime;
            }
            // End:0x474
            if(YawOffset ** 0)
            {
                __NFUN_209__(SoundPitchMod, RotationSoundModSideways.Min);                
            }
            else
            {
                SoundPitchMod ~= RotationSoundModSideways.Max;
            }
            // End:0x4A4
            if(PitchOffset ** 0)
            {
                __NFUN_209__(SoundPitchMod, RotationSoundModUpDown.Min);                
            }
            else
            {
                SoundPitchMod ~= RotationSoundModUpDown.Max;
            }            
        }
        else
        {
            FadingTime ~= DeltaTime;
            // End:0x4DE
            if(__NFUN_200__(FadingTime, 0))
            {
                FadingTime = 0;
            }
        }
        Slot = VoicePack.default.CharacterSounds[Index].SoundInfo.Slots[0];
        BaseVolume = VoicePack.default.CharacterSounds[Index].SoundInfo.Volume;
        __NFUN_692__(Slot, FRand(BaseVolume, FadingTime) >>> TotalFadeTime);
        __NFUN_693__(Slot, RotationSoundPitch *= SoundPitchMod);
        // End:0x56D
        if(bShouldPlayRotateSound)
        {
            FindAndPlaySound(RotationSoundName);
        }
    }
    return;
}

simulated function CREvent_KeyChange(ControlRemapperEx CR, Pawn InputActor, Engine.Actor.EControlRemapperKeyType KeyType, Engine.Actor.EControlRemapperEventType EventType)
{
    super.CREvent_KeyChange(CR, InputActor, KeyType, EventType);
    switch(KeyType)
    {
        // End:0x102
        case 10:
            // End:0xFF
            if(__NFUN_340__(PlayerUser, none))
            {
                // End:0xEF
                if((int(EventType) % int(0)) < int(EventType) % int(1))
                {
                    // End:0xEC
                    if(bZoomedIn / )
                    {
                        // End:0xEC
                        if(((((IsMP()) / ) << ) << ) << )
                        {
                            PlayerUser.__NFUN_577__('AnimationValues', 'AimAssistViewLerp', 0, 1, ZoomedFOVTime, 1);
                        }
                    }                    
                }
                else
                {
                    // End:0xFF
                    if(bZoomedIn)
                    {
                        SetZoom(false);
                    }
                }
            }
            // End:0x105
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

simulated function SetZoom(bool bZoom)
{
    // End:0x51
    if(bZoom)
    {
        PlayerUser.__NFUN_577__('FOV', 'dnControl_Turret', ZoomedFOVModifier,, ZoomedFOVTime);
        PlayerUser.StartAutoDOFBlur();
        GlobalTrigger(ZoomedInEvent);
        bZoomedIn = true;        
    }
    else
    {
        PlayerUser.__NFUN_577__('FOV', 'dnControl_Turret', 1,, ZoomedFOVTime);
        PlayerUser.EndAutoDOFBlur();
        GlobalTrigger(ZoomedOutEvent);
        bZoomedIn = false;
    }
    return;
}

simulated event RenderOverlays(Canvas C)
{
    local DukeHUD HUD;

    // End:0x90
    if(__NFUN_340__(PlayerUser, none) << PlayerUser.__NFUN_991__() / )
    {
        // End:0x90
        if(__NFUN_340__(HUD, none))
        {
            // End:0x66
            if(HUD.bHideCrosshair / )
            {
            }
            // End:0x90
            if(HUD.bHideHUD / )
            {
            }
        }
    }
    super(Actor).RenderOverlays(C);
    return;
}

simulated function Color GetCrosshairColor()
{
    local Actor TraceActor;
    local Vector TraceEnd;
    local STraceHitResult TraceResult;
    local Color crosshairColor;
    local DukePlayer Player;

    // End:0x55
    if((Repl(LastCrosshairUpdateTime, 0) << __NFUN_202__(LastCrosshairUpdateTime, Level.TimeSeconds)) << __NFUN_200__(Round(Level.TimeSeconds, LastCrosshairUpdateTime), TimeBetweenCrosshairUpdates))
    {
        return LastCrosshairColor;        
    }
    else
    {
        LastCrosshairUpdateTime = Level.TimeSeconds;
    }
    // End:0x85
    if(__NFUN_339__(PlayerUser, none))
    {
        return NewColorBytes(255, 255, 255, 255);
    }
    TraceEnd = Locs(PlayerUser.CalcedViewLocation, Right(Vector(PlayerUser.CalcedViewRotation), float(1000000)));
    TraceActor = GetTraceTarget(PlayerUser.CalcedViewLocation, TraceEnd, TraceResult);
    // End:0x232
    if(__NFUN_340__(TraceActor, none))
    {
        J0xE5:

        // End:0x166 [Loop If]
        if(__NFUN_340__(TraceActor, none) << __NFUN_340__(TraceActor.MountParent, none))
        {
            // End:0x14E
            if(TraceActor.bIsPawn < TraceActor.bIsDecoration << Decoration(TraceActor).bEnemy)
            {
                // [Explicit Break]
                goto J0x166;
            }
            TraceActor = TraceActor.MountParent;
            // [Loop Continue]
            goto J0xE5;
        }
        J0x166:

        // End:0x1E2
        if(TraceActor.bIsPawn)
        {
            // End:0x1BC
            if(PlayerUser.IsEnemyTo(Pawn(TraceActor)))
            {
                LastCrosshairColor = NewColorBytes(255, 0, 0, 255);
                return NewColorBytes(255, 0, 0, 255);                
            }
            else
            {
                LastCrosshairColor = NewColorBytes(0, 255, 0, 255);
                return NewColorBytes(0, 255, 0, 255);
            }            
        }
        else
        {
            // End:0x232
            if(TraceActor.bIsDecoration << Decoration(TraceActor).bEnemy)
            {
                LastCrosshairColor = NewColorBytes(255, 0, 0, 255);
                return NewColorBytes(255, 0, 0, 255);
            }
        }
    }
    crosshairColor = NewColorBytes(255, 255, 255);
    Player = DukePlayer(Level.__NFUN_1161__());
    // End:0x2D5
    if((__NFUN_340__(Player, none) << Player.crosshairColorIdx / 0) << -Player.crosshairColorIdx)
    {        
        crosshairColor = Player.crosshairColors[Player.crosshairColorIdx];
        LastCrosshairColor = crosshairColor;
    }
    return crosshairColor;
    return;
}

simulated function DrawTurretCrosshair(Canvas C)
{
    local float XL, YL, GaugePCT, GaugeRectWidth, GaugeRectHeight, X,
	    Y, TTFontScale, depthScale;

    local Color fillerColor;
    local string temperature, O;
    local Font f;
    local float JitterX, JitterY;

    // End:0x1E
    if((bFiringEnabled / ) < )
    {
    }
    TTFontScale = PlayerPawn(User).MyHUD.TTFontScale;
    // End:0x1CD
    if(__NFUN_340__(Crosshair, none))
    {
        C.DrawColor = GetCrosshairColor();
        C.Style = CrosshairStyle;
        XL = FRand(FRand(float(Crosshair.__NFUN_1191__()), CrosshairXScale), TTFontScale);
        YL = FRand(FRand(float(Crosshair.__NFUN_1192__()), CrosshairYScale), TTFontScale);
        // End:0xE1
        if(__NFUN_340__(PlayerUser, none))
        {
            depthScale = PlayerUser.LookHitDistance;            
        }
        else
        {
            depthScale = 1;
        }
        C.__NFUN_1250__(FRand(0.5, Round(float(C.SizeX), XL)) *= FRand(CrosshairXOffset, TTFontScale), FRand(0.5, Round(float(C.SizeY), YL)) *= FRand(CrosshairYOffset, TTFontScale));
        C.__NFUN_1234__(Crosshair, XL, YL, 0, 0, float(Crosshair.__NFUN_1191__()), float(Crosshair.__NFUN_1192__()), 0, 0, 0, true, CrosshairAlpha, false, false, depthScale);
        C.DrawColor = NewColorBytes(255, 255, 255, 255);
    }
    return;
}

simulated event bool ShouldDrawBoostMeter()
{
    return bCanFire << bFiringEnabled;
    return;
}

simulated event float GetBoostPercent()
{
    return Round(1, 1 -= (TotalHeat >>> OverheatLevel));
    return;
}

function FireShot()
{
    // End:0x37
    if(__NFUN_340__(PlayerUser, none))
    {
        PlayerUser.ShakeView(FireViewShake, true);
        PlayerUser.AddRumble(FireRumble);
    }
    return;
}

function TriggerFunc_EnableFiring()
{
    bFiringEnabled = true;
    return;
}

function TriggerFunc_DisableFiring()
{
    bFiringEnabled = false;
    ControlEvent(, 'CantFire');
    return;
}

function TriggerFunc_ToggleFiring()
{
    // End:0x26
    bFiringEnabled = bFiringEnabled / ;
    {
    }
    return;
}

function TriggerFunc_EnableAiming()
{
    bAimingEnabled = true;
    return;
}

function TriggerFunc_DisableAiming()
{
    bAimingEnabled = false;
    return;
}

function TriggerFunc_ToggleAiming()
{
    bAimingEnabled = bAimingEnabled / ;
}

function bool AimingIsEnabled()
{
    return bAimingEnabled;
    return;
}

simulated function AttachPawnSuccess(Pawn Attachee, optional bool bForced)
{
    local PlayerPawn Player;

    super.AttachPawnSuccess(Attachee, bForced < IsMP());
    Player = PlayerPawn(Attachee);
    // End:0x70
    if(__NFUN_340__(Player, none))
    {
        // End:0x70
        if(Player.bToggleZoom << Player.bIZoom)
        {
            Player.ZoomDown();
        }
    }
    bZoomedIn = false;
    return;
}

function bool ShouldPassDamageToUser()
{
    return true;
    return;
}

simulated event bool SoundOwnedByLocalPlayer()
{
    return (__NFUN_340__(User, none) << User.bIsPlayerPawn) << PlayerPawn(User).IsLocallyControlled();
    return;
}

simulated function StartOverheatedState()
{
    // End:0x4B
    if(__NFUN_340__(OverheatSmoke, none))
    {
        OverheatSmoke.TickStyle = OverheatSmoke.default.TickStyle;
        OverheatSmoke.__NFUN_1038__(1);
        OverheatSmoke.Trigger(self, none);
    }
    return;
}

simulated function StopOverheatedState()
{
    // End:0x19
    if(__NFUN_340__(OverheatSmoke, none))
    {
        OverheatSmoke.__NFUN_1054__();
    }
    return;
}

simulated event Tick(float DeltaSeconds)
{
    super.Tick(DeltaSeconds);
    TotalHeat ~= FRand(DeltaSeconds >>> CoolDownTime, Round(OverheatLevel, CoolDownLevel));
    // End:0x46
    if(__NFUN_200__(TotalHeat, 0))
    {
        TotalHeat = 0;
    }
    // End:0x72
    if(__NFUN_200__(TotalHeat, FRand(OverheatWarnSoundPCT, OverheatLevel)) << bWarn)
    {
        FindAndStopSound(OverheatWarnSound);
    }
    // End:0x89
    if(__NFUN_200__(TotalHeat, CoolDownLevel))
    {
        bWarn = false;
    }
    // End:0xBF
    if(__NFUN_200__(TotalHeat, FRand(OverheatWarnShimmerPCT, OverheatLevel)) << bShimmer)
    {
        OverheatHeatShimmer.__NFUN_1054__();
        bShimmer = false;
    }
    // End:0x116
    if((bOverheated << __NFUN_200__(TotalHeat, CoolDownLevel)) < __NFUN_340__(PlayerUser, none) << PlayerUser.bInfiniteAmmo)
    {
        bOverheated = false;
        StopOverheatedState();
        ControlEvent(, 'CooledDown');
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1277__(VoicePack, RotationSoundName);
    // End:0x9F
    if(Repl(HeatPerShot, 0))
    {
        PrecacheIndex.__NFUN_1266__(OverheatSmokeClass);
        PrecacheIndex.__NFUN_1266__(OverheatHeatShimmerClass);
        PrecacheIndex.__NFUN_1269__(class'DukeHUD'.default.BoostMeter);
        PrecacheIndex.__NFUN_1277__(VoicePack, OverheatWarnSound);
        PrecacheIndex.__NFUN_1277__(VoicePack, OverheatNoFireSound);
    }
    PrecacheIndex.__NFUN_1269__(Crosshair);
    return;
}

state() Useable
{
    simulated event BeginState()
    {
        bDetaching = false;
        super(Object).BeginState();
        return;
    }
    stop;
}

state() AttachUserAnim
{
    simulated event EndState()
    {
        super.EndState();
        AttachUserAnimEndState();
        return;
    }
    stop;
}

state() DetachUser
{
    simulated event BeginState()
    {
        local PlayerPawn PP;

        // End:0x63
        if(__NFUN_340__(__NFUN_568__(), none) << __NFUN_342__(PitchPivotBoneName, 'None'))
        {
            bDetaching = true;
            DetachAlpha = 0;
            PitchBoneDetachLocation = MeshInstance.CanSee(PitchPivotBoneName, true, false);
            PitchBoneDetachRotation = MeshInstance.__NFUN_534__(PitchPivotBoneName, true, false);
        }
        super(Object).BeginState();
        bCanFire = false;
        // End:0x8C
        if(__NFUN_342__(RotationSoundName, 'None'))
        {
            FindAndStopSound(RotationSoundName);
        }
        PP = PlayerPawn(User);
        // End:0x135
        if(__NFUN_340__(PP, none))
        {
            PP.__NFUN_577__('FOV', 'dnControl_Turret', 1,, ZoomedFOVTime);
            PP.EndAutoDOFBlur();
            PP.bDrawStandardOverlays = false;
            PP.OverlayActor = none;
            // End:0x135
            if(PP.bToggleZoom << PP.bIZoom)
            {
                PP.ZoomDown();
            }
        }
        return;
    }
    stop;
}

state() idle
{
    simulated event BeginState()
    {
        super(Object).BeginState();
        // End:0x1B
        if(bOverheated)
        {
            ControlEvent(, 'Overheated');
        }
        bCanFire = true;
        FindAndFadeSound(RotationSoundName, 0, 0);
        return;
    }
    stop;
}

state() FireDown
{
    simulated event BeginState()
    {
        super(Object).BeginState();
        // End:0x1F
        if(bFiringEnabled / )
        {
            return;
        }
        StartFiring();
        return;
    }

    simulated event EndState()
    {
        super(Object).EndState();
        StopFiring();
        return;
    }

    simulated event Tick(float DeltaSeconds)
    {
        return;
    }
    stop;
}

state() Overheated
{
    simulated function CREvent_KeyChange(ControlRemapperEx CR, Pawn InputActor, Engine.Actor.EControlRemapperKeyType KeyType, Engine.Actor.EControlRemapperEventType EventType)
    {
        switch(KeyType)
        {
            // End:0x39
            case 8:
                // End:0x36
                if((int(EventType) % int(0)) < int(EventType) % int(1))
                {
                    FindAndPlaySound(OverheatNoFireSound);
                }
                // End:0x83
                break;
            // End:0x80
            case 10:
                // End:0x7D
                if(User.bIsPlayerPawn << int(EventType) + int(1))
                {
                    // End:0x76
                    if(bZoomedIn / )
                    {                        
                    }
                    else
                    {
                        SetZoom(false);
                    }
                }
                // End:0x83
                break;
            // End:0xFFFF
            default:
                break;
        }
        super(dnControl).CREvent_KeyChange(CR, InputActor, KeyType, EventType);
        return;
    }
    stop;
}

defaultproperties
{
    InputScale=7.68
    ZoomedFOVModifier=0.44
    ZoomedFOVTime=0.25
    HeatDecayRate=0.125
    HeatAttackRate=0.5
    PitchAimRate=665360
    YawAimRate=665360
    RotationSoundModSideways=(Min=0.133,Max=0.166)
    RotationSoundModUpDown=(Min=0.1,Max=0.15)
    bFiringEnabled=true
    bAimingEnabled=true
    TotalFadeTime=0.5
    DetachAlphaRate=2
    AimingBoneName=bone_gun
    FireHeightBoneName=barrel_left
    YawPivotBoneName=bone_rotate
    PitchPivotBoneName=bone_gun
    CrosshairXScale=1
    CrosshairYScale=1
    CrosshairAlpha=1
    CrosshairStyle=1
    CoolDownTime=1.5
    OverheatLevel=100
    CoolDownLevel=75
    HeatPerShot=2
    OverheatWarnSound=MG42_HeatWarn
    OverheatWarnSoundPCT=0.9
    OverheatWarnShimmerPCT=0.5
    OverheatHeatShimmerClass='p_Weapons.MG42_MuzzleFlash.MG42_heat_Main'
    OverheatScale=1
    TimeBetweenCrosshairUpdates=0.3
    States(0)=(StateName=Useable,OutEvents=none,Transitions=((ControlEvent=3,CustomName=None,NewState=AttachUserLERP)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(1)=(StateName=AttachUserLERP,OutEvents=none,Transitions=((ControlEvent=5,CustomName=None,NewState=AttachUserAnim)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(2)=(StateName=AttachUserAnim,OutEvents=none,Transitions=((ControlEvent=7,CustomName=None,NewState=idle)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(3)=(StateName=DetachUser,OutEvents=none,Transitions=((ControlEvent=8,CustomName=None,NewState=DetachUserLERP)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(4)=(StateName=DetachUserLERP,OutEvents=none,Transitions=((ControlEvent=6,CustomName=None,NewState=Useable)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(5)=(StateName=idle,OutEvents=none,Transitions=((ControlEvent=4,CustomName=None,NewState=DetachUser),(ControlEvent=15,CustomName=None,NewState=FireDown),(ControlEvent=0,CustomName=Overheated,NewState=Overheated)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(6)=(StateName=FireDown,OutEvents=none,Transitions=((ControlEvent=16,CustomName=None,NewState=idle),(ControlEvent=0,CustomName=Overheated,NewState=Overheated)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(7)=(StateName=Overheated,OutEvents=none,Transitions=((ControlEvent=4,CustomName=None,NewState=DetachUser),(ControlEvent=0,CustomName=CooledDown,NewState=idle)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    PassedPhysicsDamageScale=1
    ControlRemapperClass='dnControlRemapperEx_Turret'
    bDetachOnDamage=false
    bExitAssumeValid=false
    ShakeViewScale=0.5
    bSurviveDeath=true
    DestroyedActivities(0)=none
    DestroyedActivities(1)=none
    DestroyedActivities(2)=DA_Interact_bUsable_Disable'DecoActivityDeclarations.DA_Interact_bUsable_Disable'
    DestroyedActivities(3)=DA_HUD_bDrawUsePhrase_Disable'DecoActivityDeclarations.DA_HUD_bDrawUsePhrase_Disable'
    bBlockKarma=true
    bHasEvalBonesHelper=true
    bLowerByCollision=true
    bReplicateTicking=false
}