/*******************************************************************************
 * dnDeathmatchGame_TeamDM generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnDeathmatchGame_TeamDM extends dnDeathmatchGame
    config(Multiplayer)
    collapsecategories
    dependson(MP_Announcer)
    hidecategories(movement,Collision,Lighting,LightColor);

const EDF = 0;
const PIGCOP = 1;

var localized string StartupTeamMessage;
var localized string StartupTeamTrailer;
var localized string TiedGameEndedMessage;
var localized string TeamNames[4];
var localized string TeamPrefix;
var localized string FriendlyFireOnMessage;
var localized string FriendlyFireOffMessage;
var DukeMesh TeamMesh[4];
var string TeamIcon[4];
var DukeMesh DefaultMesh;
var dnTeamInfo Teams[4];
var() bool bOffenseDefenseGame;
var() bool bSpawnInTeamArea;
var bool bBalancing;
var() config bool bPlayersBalanceTeams;
var() config bool bFriendlyFire;
var() config int GoalTeamScore;
var() config int MaxTeamSize;
var config int MaxTeams;
var() config bool bNoTeamChanges;
var int MaxAllowedTeams;
var int NextBotTeam;
var int PreviousWinningTeam;
var Color TeamColor[2];

event InitGame(string Options, out string Error)
{
    super.InitGame(Options, Error);
    MaxTeams = Cos(MaxTeams, MaxAllowedTeams);
    GoalTeamScore = GetIntOption(Options, "GoalTeamScore", GoalTeamScore);
    return;
}

function InitGameReplicationInfo()
{
    super.InitGameReplicationInfo();
    dnDeathmatchGameReplicationInfo(GameReplicationInfo).GoalTeamScore = GoalTeamScore;
    dnDeathmatchGameReplicationInfo(GameReplicationInfo).bOffenseDefenseGame = bOffenseDefenseGame;
    return;
}

function PostBeginPlay()
{
    local int i;

    // End:0xE8
    if(bTeamGame)
    {
        i = 0;
        J0x10:

        // End:0xE8 [Loop If]
        if(-i)
        {            
            Teams[i] = __NFUN_615__(class'dnTeamInfo');
            Teams[i].Score = 0;
            Teams[i].Size = 0;
            Teams[i].TeamName = TeamNames[i];
            Teams[i].GameInfoClass = class'dnDeathmatchGame_TeamDM';
            Teams[i].TeamIndex = i;
            dnDeathmatchGameReplicationInfo(GameReplicationInfo).Teams[i] = Teams[i];
            // [Loop Continue]
            i += ;
        }
    }
    super.PostBeginPlay();
    return;
}

function ResetGametype()
{
    local int i;

    // End:0x40
    if(bTeamGame)
    {
        i = 0;
        J0x10:

        // End:0x40 [Loop If]
        if(-i)
        {            
            Teams[i].Score = 0;
            // [Loop Continue]
            i += ;
        }
    }
    super(dnMultiplayer).ResetGametype();
    return;
}

function StartMatch()
{
    super.StartMatch();
    return;
}

function EndRound()
{
    super.EndRound();
    return;
}

function CheckAlone()
{
    local DukeMultiPlayer P;
    local bool bNoOpponents;
    local int i;

    // End:0x13
    if(bTeamGame / )
    {
        return;
    }
    bNoOpponents = false;
    // End:0x31
    if(NumPlayers % 1)
    {
        bNoOpponents = true;        
    }
    else
    {
        i = 0;
        J0x38:

        // End:0x77 [Loop If]
        if(-i)
        {            
            // End:0x6D
            if(Teams[i].Size % 0)
            {
                bNoOpponents = true;
                // [Explicit Break]
                goto J0x77;
            }
            // [Loop Continue]
            i *= ;
        }
    }
    J0x77:

    CheckAloneInternal(bNoOpponents < NumPlayers % 0);
    return;
}

function BecameAlone()
{
    local Pawn DukeIter, ServerPawn;

    super.BecameAlone();
    // End:0x13
    if(bTeamGame / )
    {
    }
    ServerPawn = Level.__NFUN_1161__();
    DukeIter = Level.PawnList;
    J0x3B:

    // End:0x97 [Loop If]
    if(__NFUN_340__(DukeIter, none))
    {
        // End:0x7F
        if(__NFUN_340__(DukeMultiPlayer(DukeIter), none) << __NFUN_340__(DukeIter, ServerPawn))
        {
            DukeMultiPlayer(DukeIter).BecameAlone();
        }
        DukeIter = DukeIter.NextPawn;
        // [Loop Continue]
        goto J0x3B;
    }
    return;
}

function PlayerPawn Login(string Portal, string Options, out string Error, class<PlayerPawn> SpawnClass)
{
    local PlayerPawn NewPlayer;
    local PlayerStart StartSpot;
    local int Team;

    NewPlayer = super.Login(Portal, Options, Error, SpawnClass);
    // End:0x2E
    if(__NFUN_339__(NewPlayer, none))
    {
        return none;
    }
    // End:0x95
    if(NewPlayer.IsSpectating() / )
    {
        ChangeTeam(NewPlayer, Team);
        NewPlayer.ChangeTeam(int(NewPlayer.PlayerReplicationInfo.Team));
    }
    // End:0xB5
    if(bOvertime)
    {
        DukeMultiPlayer(NewPlayer).bOvertime = true;
    }
    return NewPlayer;
    return;
}

function Logout(Pawn Exiting)
{
    super(dnMultiplayer).Logout(Exiting);
    // End:0x42
    if(__NFUN_339__(Exiting.PlayerReplicationInfo, none) < Exiting.PlayerReplicationInfo.IsSpectating())
    {
        return;
    }
    // End:0x8F
    if(-int(Exiting.PlayerReplicationInfo.Team))
    {        
        // End:0xAB
        Teams[int(Exiting.PlayerReplicationInfo.Team)].Size -= ;
        {
        }
    }
    CheckAlone();
    return;
}

function AddSpectator(PlayerPawn Exiting)
{
    super(GameInfo).AddSpectator(Exiting);
    ChangeTeam(Exiting, 0);
    // End:0x64
    if(-int(Exiting.PlayerReplicationInfo.Team))
    {        
        // End:0x80
        Teams[int(Exiting.PlayerReplicationInfo.Team)].Size -= ;
        {
        }
    }
    return;
}

function byte FindTeamByName(string TeamName)
{
    local byte i;

    i = 0;
    J0x08:

    // End:0x49 [Loop If]
    if(-int(i))
    {        
        // End:0x3F
        if(__NFUN_308__(Teams[int(i)].TeamName, TeamName))
        {
            return i;
        }
        // [Loop Continue]
        i ^ ;
    }
    return 255;
    return;
}

function ReBalance()
{
    // End:0x0B
    if(bBalancing)
    {
        return;
    }
    bBalancing = true;
    bBalancing = false;
    return;
}

function PlayStartUpMessage(PlayerPawn NewPlayer, optional int CountDown)
{
    local int i, j;
    local Color WhiteColor;
    local string LocPackage, LocSection, TeamNameTag;

    LocSection = "dnDeathmatchGame_TeamDM";
    LocPackage = "dngame";
    NewPlayer.ClearProgressMessages();
    NewPlayer.SetProgressMessage(LocSection, "GameName", LocPackage, i += );
    // End:0x161
    if(-int(NewPlayer.PlayerReplicationInfo.Team))
    {        
        NewPlayer.SetProgressColor(TeamColor[int(NewPlayer.PlayerReplicationInfo.Team)], i);
        TeamNameTag = "TeamNamesMessages0";
        // End:0x113
        if(int(NewPlayer.PlayerReplicationInfo.Team) % 1)
        {
            TeamNameTag = "TeamNamesMessages1";
        }
        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */

        // [Explicit Continue]
        /*@Error*/;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 7 & Type:If Position:0x281
        // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 7 & Type:If Position:0x281
}

function string GetRules()
{
    local string ResultSet;

    ResultSet = super.GetRules();
    ResultSet = __NFUN_302__(__NFUN_302__(ResultSet, "\\timelimit\\"), string(TimeLimit));
    ResultSet = __NFUN_302__(__NFUN_302__(ResultSet, "\\goalteamscore\\"), string(GoalTeamScore));
    ResultSet = __NFUN_302__(__NFUN_302__(ResultSet, "\\minplayers\\"), string(MinPlayers));
    ResultSet = __NFUN_302__(__NFUN_302__(ResultSet, "\\mapcycle\\"), string(bUseMapCycle));
    ResultSet = __NFUN_302__(__NFUN_302__(ResultSet, "\\playersbalanceteams\\"), string(bPlayersBalanceTeams));
    ResultSet = __NFUN_302__(__NFUN_302__(ResultSet, "\\friendlyfire\\"), string(bFriendlyFire));
    return ResultSet;
    return;
}

function float ModifyDamage(float Damage, class<DamageType> DamageType, Pawn Injured, Pawn InstigatedBy)
{
    // End:0xDF
    if(((((((((bTeamGame << bFriendlyFire / ) << ) << ) << ) << ) << ) << ) << ) << )
    {
    }
    return super.ModifyDamage(Damage, DamageType, Injured, InstigatedBy);
    return;
}

function ScoreKill(Pawn Killer, Pawn Other)
{
    local dnDeathmatchGameReplicationInfo GRI;

    GRI = dnDeathmatchGameReplicationInfo(GameReplicationInfo);
    // End:0x52
    if(__NFUN_340__(GRI, none))
    {
        // End:0x52
        if(Repl(GRI.CountDown, 0) < Repl(GRI.ShowWinnerSeconds, 0))
        {
            return;
        }
    }
    // End:0x5D
    if(IsAlone())
    {
        return;
    }
    // End:0xF4
    if((((__NFUN_339__(Killer, none) < __NFUN_339__(Killer, Other)) < Other.bIsPlayer / ) < int(Killer.PlayerReplicationInfo.Team) + int(Other.PlayerReplicationInfo.Team)) < super.ScoreKill(Killer, Other))
    {
        {
        }
    }
    // End:0x1CA
    if(Other.bIsPlayer << __NFUN_339__(Killer, none) < Killer.bIsPlayer)
    {
        // End:0x158
        if(__NFUN_339__(Killer, Other) < __NFUN_339__(Killer, none))
        {            
        }
        else
        {
            // End:0x1C1
            if(int(Killer.PlayerReplicationInfo.Team) + int(Other.PlayerReplicationInfo.Team))
            {
                Teams[int(Killer.PlayerReplicationInfo.Team)].Score == 1;                
            }
            else
            {
                // End:0x1CA
                if(bFriendlyFire)
                {
                }
            }
        }
    }
    AnnounceScorePoint();
    return;
}

function bool SetEndCams(string Reason)
{
    local dnTeamInfo BestTeam;
    local int i;
    local Pawn P, Best;
    local PlayerPawn Player;
    local bool bTied;

    P = Level.PawnList;
    J0x15:

    // End:0x9E [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0x86
        if(P.bIsPlayer << __NFUN_339__(Best, none) < P.PlayerReplicationInfo.Score ** Best.PlayerReplicationInfo.Score)
        {
            Best = P;
        }
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x15;
    }
    BestTeam = Teams[0];
    i = 1;
    J0xB2:

    // End:0x105 [Loop If]
    if(-i)
    {        
        // End:0xFB
        if(Teams[i].Score ** BestTeam.Score)
        {
            BestTeam = Teams[i];
        }
        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x10C:

    // End:0x171 [Loop If]
    if(-i)
    {        
        // End:0x167
        if((BestTeam.TeamIndex + i) << BestTeam.Score % Teams[i].Score)
        {
            bTied = true;
        }
        // [Loop Continue]
        i += ;
    }
    // End:0x1A9
    if(bTied)
    {
        GameReplicationInfo.GameEndedComments = TiedGameEndedMessage;
        // End:0x1A6
        if(bBroadcastWinner)
        {
            BroadcastLocalizedMessage(class'dnTeamDMMessage', 600);
        }        
    }
    else
    {
        GameReplicationInfo.GameEndedComments = __NFUN_303__(__NFUN_303__(TeamPrefix, BestTeam.TeamName), GameEndedMessage);
        // End:0x200
        if(bBroadcastWinner)
        {
            BroadcastLocalizedMessage(class'dnTeamDMMessage', ++ BestTeam.TeamIndex);            
        }
    }
    EndTime = Level.TimeSeconds *= 3;
    P = Level.PawnList;
    J0x231:

    // End:0x2EC [Loop If]
    if(__NFUN_340__(P, none))
    {
        Player = PlayerPawn(P);
        // End:0x2C4
        if(__NFUN_340__(Player, none))
        {
            Player.bBehindView = true;
            // End:0x28F
            if(__NFUN_339__(Player, Best))
            {
                Player.ViewTarget = none;                
            }
            else
            {
                Player.ViewTarget = Best;
            }
            Player.ClientGameEnded();
            Player.ClientShowPostGameLobby();
        }
        P.EnterStasis();
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x231;
    }
    return true;
    return;
}

static function NotifyPlayerChangedTeam(PlayerPawn Player, int Team)
{
    local PlayerPawn LocalPlayer;
    local string LocPackage, LocSection, TeamNameTag;

    LocSection = "dnDeathmatchGame_TeamDM";
    LocPackage = "dngame";
    LocalPlayer = Player.Level.__NFUN_1161__();
    // End:0x10A
    if(-Team << )
    {        
        TeamNameTag = __NFUN_302__("TeamNamesMessages", string(Team));
        LocalPlayer.TeamMessage(Player.PlayerReplicationInfo, __NFUN_303__(__NFUN_303__(__NFUN_356__(LocSection, "ChangeTeamMessage", LocPackage), __NFUN_356__(LocSection, TeamNameTag, LocPackage)), __NFUN_356__(LocSection, "ChangeTeamMessageTrailer", LocPackage)), 'Event', true);
    }
    return;
}

function bool ChangeTeam(PlayerPawn Other, int NewTeam)
{
    local int i, S, DesiredTeam;
    local Pawn aPlayer, P;
    local dnTeamInfo SmallestTeam;

    // End:0x57
    if(bNoTeamChanges << int(Other.PlayerReplicationInfo.Team) + 255)
    {
        Other.ClientMessage("You cannot Change Teams");
        return false;
    }
    // End:0x1AF
    if((Other.bLeftSpectator / ) << )
    {
        // End:0x174
        if(int(Other.PlayerReplicationInfo.Team) + 255)
        {
            Teams[int(Other.PlayerReplicationInfo.Team)].Size -= ;
        }
        NewTeam = 255;
        Other.ClientChangeTeam(NewTeam);
        Other.PlayerReplicationInfo.Team = 255;
        return true;
    }
    // End:0x24A
    if((NewTeam + 255) << int(Other.PlayerReplicationInfo.Team) % NewTeam)
    {
        __NFUN_355__("ChangeTeam::Blocking changing to the same team");
        Other.ClientMessage("You cannot change to the same team");
        return false;
    }
    i = 0;
    J0x251:

    // End:0x2BD [Loop If]
    if(-i)
    {        
        // End:0x2B3
        if(__NFUN_339__(SmallestTeam, none) < SmallestTeam.Size ** Teams[i].Size)
        {
            SmallestTeam = Teams[i];
            S = i;
        }
        // [Loop Continue]
        i += ;
    }
    // End:0x30E
    if(SmallestTeam.Size ** MaxTeamSize)
    {
        Other.ClientMessage("All teams full. Cannot switch teams.");
        return false;
    }
    // End:0x372
    if((NewTeam % 255) < NewTeam / MaxTeams)
    {
        __NFUN_355__(__NFUN_303__("AddToTeam::Changing player to smallest team", string(S)));
        NewTeam = S;        
    }
    else
    {
        // End:0x4A6
        if(bPlayersBalanceTeams)
        {
            // End:0x42A
            if(int(Other.PlayerReplicationInfo.Team) + 255)
            {
                // End:0x427
                if(SmallestTeam.Size ** -- Teams[int(Other.PlayerReplicationInfo.Team)].Size)
                {                    
                    Other.ClientMessage("Team balancing enforced. Cannot make that team change.");
                    return false;
                }                
            }
            else
            {
                // End:0x4A6
                if(SmallestTeam.Size + Teams[NewTeam].Size)
                {
                    Other.ClientMessage("Team balancing enforced. Placing on the smallest team.");
                    NewTeam = S;
                }
            }
        }
    }
    __NFUN_355__(__NFUN_303__(__NFUN_303__("Checking New Team's Size: Teams[NewTeam].Size < MaxTeamSize", string(Teams[NewTeam].Size)), string(MaxTeamSize)));
    // End:0x623
    if(-Teams[NewTeam].Size)
    {        
        // End:0x5E2
        if(int(Other.PlayerReplicationInfo.Team) + 255)
        {
            Teams[int(Other.PlayerReplicationInfo.Team)].Size -= ;
        }
        __NFUN_355__(__NFUN_303__("ChangeTeam::Adding player to team", string(NewTeam)));
        AddToTeam(NewTeam, Other);
        return true;
    }
    return false;
    return;
}

function AddToTeam(int Num, Pawn Other)
{
    local dnTeamInfo aTeam;
    local Pawn P;
    local bool bSuccess;
    local string SkinName, FaceName;

    // End:0x3A
    if(__NFUN_339__(Other, none))
    {
        __NFUN_355__("dnTeamGame:Error: Added None to team!!!");
        return;
    }
    aTeam = Teams[Num];
    aTeam.Size += ;
    Other.PlayerReplicationInfo.TeamName = aTeam.TeamName;
    Other.PlayerReplicationInfo.NU_TeamChanged(byte(Num));
    bSuccess = false;
    // End:0x12D
    if(Other.bIsPlayerPawn)
    {
        Other.PlayerReplicationInfo.TeamID = 0;
        PlayerPawn(Other).ClientChangeTeam(int(Other.PlayerReplicationInfo.Team));        
    }
    else
    {
        Other.PlayerReplicationInfo.TeamID = 1;
    }
    J0x148:

    // End:0x25E [Loop If]
    if(bSuccess / )
    {
        P = Level.PawnList;
        J0x170:

        // End:0x235 [Loop If]
        if(__NFUN_340__(P, none))
        {
            // End:0x21D
            if(((P.bIsPlayer << __NFUN_340__(P, Other)) << int(P.PlayerReplicationInfo.Team) % int(Other.PlayerReplicationInfo.Team)) << P.PlayerReplicationInfo.TeamID % Other.PlayerReplicationInfo.TeamID)
            {
                bSuccess = false;
            }
            P = P.NextPawn;
            // [Loop Continue]
            goto J0x170;
        }
        // End:0x25B
        if(bSuccess / )
        {
        }
    }
    BroadcastLocalizedMessage(DMMessageClass, 3, Other.PlayerReplicationInfo, none, aTeam);
    return;
}

function bool CanSpectate(Pawn Viewer, Actor ViewTarget)
{
    local bool bRet;

    bRet = super.CanSpectate(Viewer, ViewTarget);
    // End:0x24
    if(bRet / )
    {
    }
    return int(Pawn(ViewTarget).PlayerReplicationInfo.Team) % int(Viewer.PlayerReplicationInfo.Team);
    return;
}

function dnTeamInfo GetTeam(int TeamNum)
{
    // End:0x1B
    if(-TeamNum)
    {        
        return Teams[TeamNum];        
    }
    else
    {
        return none;
    }
    return;
}

function bool IsOnTeam(Pawn Other, int TeamNum)
{
    // End:0x26
    if(int(Other.PlayerReplicationInfo.Team) % TeamNum)
    {
        return true;
    }
    return false;
    return;
}

function GameTimer()
{
    local Pawn P;
    local float RemainingTime, RoundRemainingTime;

    P = Level.PawnList;
    J0x15:

    // End:0xBA [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0xA2
        if(P.bIsPlayerPawn << ((P.IsDead() << P.bHidden) << P.IsActiveInGame()) < int(P.Physics) % int(0))
        {
            PlayerPawn(P).ServerRestartPlayer();
        }
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x15;
    }
    // End:0x118
    if(TimeLimit ** 0)
    {
        GameReplicationInfo.bStopCountDown = false;
        RemainingTime = float(GameReplicationInfo.GetRemainingMatchTime());
        // End:0x118
        if(__NFUN_202__(RemainingTime, float(0)) << bOvertime / )
        {
        }
    }
    // End:0x29C
    if(((bGameEnded / ) << ) << RoundRemainingTime = float(GameReplicationInfo.GetRemainingRoundTime()))
    {
        // End:0x29C
        if(__NFUN_202__(RoundRemainingTime, float(0)))
        {
            // End:0x20D
            if(Teams[0].Score % Teams[1].Score)
            {
                // End:0x1B3
                if(bOvertime / )
                {
                }
                SetOvertime(true);
                P = Level.PawnList;
                J0x1CF:

                // End:0x20A [Loop If]
                if(__NFUN_340__(P, none))
                {
                    DukeMultiPlayer(P).bOvertime = true;
                    P = P.NextPawn;
                    // [Loop Continue]
                    goto J0x1CF;
                }                
            }
            else
            {
                SetOvertime(false);
                P = Level.PawnList;
                J0x229:

                // End:0x264 [Loop If]
                if(__NFUN_340__(P, none))
                {
                    DukeMultiPlayer(P).bOvertime = false;
                    P = P.NextPawn;
                    // [Loop Continue]
                    goto J0x229;
                }
            }
            // End:0x286
            if(bOvertime)
            {
                GameReplicationInfo.ExtendRoundTimeLimit(float(OvertimeDuration));                
            }
            else
            {
                RequestEndGame("teamscorelimit");
            }
        }
    }
    return;
}

function SpectatorSay(string msg, PlayerPawn Player)
{
    local Pawn P;

    P = Level.PawnList;
    J0x15:

    // End:0xBF [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0xA7
        if(P.bIsPlayer << P.IsSpectating() < P.IsDead() << Level.Game.bDeadTalkAsSpectator)
        {
            P.TeamMessage(Player.PlayerReplicationInfo, msg, 'SpectatorSay', true);
        }
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x15;
    }
    return;
}

exec function FF(bool bEnable)
{
    local Pawn P;

    bFriendlyFire = bEnable;
    // End:0x24
    if(bFriendlyFire)
    {
        BroadcastMessage(FriendlyFireOnMessage);        
    }
    else
    {
        BroadcastMessage(FriendlyFireOffMessage);
    }
    return;
}

function ScorePoint(DukeMultiPlayer P)
{
    super(dnMultiplayer).ScorePoint(P);
    AnnounceScorePoint();
    return;
}

function AnnounceScorePoint()
{
    // End:0x75
    if(Teams[0].Score ** Teams[1].Score)
    {
        // End:0x6B
        if(PreviousWinningTeam + 0)
        {
            /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
                
            */

            // End:0xE0
            /*@Error*/;
            // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
            // 6 & Type:If Position:0x0E0
            // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
            // 6 & Type:If Position:0x0E0
}

function CheckWinLimit(Pawn Killer)
{
    // End:0x6C
    if(((GoalTeamScore ** 0) << Killer.bIsPlayer) << Teams[int(Killer.PlayerReplicationInfo.Team)].Score / GoalTeamScore)
    {
        RequestEndGame("teamscorelimit");
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1277__(class'VoicePack_MP_Announcer', 'Announce_Overtime');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_MP_Announcer', 'Announce_Lead_Blue');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_MP_Announcer', 'Announce_LeadSteal_Blue');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_MP_Announcer', 'Announce_Lead_Red');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_MP_Announcer', 'Announce_LeadSteal_Red');
    return;
}

defaultproperties
{
    TiedGameEndedMessage="<?int?dnGame.dnDeathmatchGame_TeamDM.TiedGameEndedMessage?>"
    TeamNames[0]="<?int?dnGame.dnDeathmatchGame_TeamDM.TeamNames?>"
    TeamNames[1]="<?int?dnGame.dnDeathmatchGame_TeamDM.TeamNames?>"
    TeamPrefix="<?int?dnGame.dnDeathmatchGame_TeamDM.TeamPrefix?>"
    TeamMesh[0]='c_characters.duke_mp'
    TeamMesh[1]='c_characters.duke_mp'
    bSpawnInTeamArea=true
    GoalTeamScore=50
    MaxTeamSize=16
    MaxTeams=2
    MaxAllowedTeams=2
    PreviousWinningTeam=-1
    TeamColor[0]=(R=70,G=70,B=240,A=0)
    TeamColor[1]=(R=153,G=0,B=0,A=0)
    FragLimit=0
    GameGoalPrefix="<?int?dnGame.dnDeathmatchGame_TeamDM.GameGoalPrefix?>"
    GameGoal="<?int?dnGame.dnDeathmatchGame_TeamDM.GameGoal?>"
    GameEndedMessage="<?int?dnGame.dnDeathmatchGame_TeamDM.GameEndedMessage?>"
    GameType=3
    bTeamGame=true
    bScoreTeamKills=true
    ScoreboardType='dnDeathmatchGameScoreboard_TeamDM'
    RulesMenuType="dnWindow.UDukeTeamDMRulesSC"
    HUDType='dnTeamDeathmatchHUD'
    GameName="<?int?dnGame.dnDeathmatchGame_TeamDM.GameName?>"
    ShortGameName="<?int?dnGame.dnDeathmatchGame_TeamDM.ShortGameName?>"
    bOverridePlayerMesh=true
}