/*******************************************************************************
 * dnDecoration_Characters generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnDecoration_Characters extends dnDecoration
    abstract
    collapsecategories;

enum EShootingStyle
{
    SHOOTSTYLE_Trace,
    SHOOTSTYLE_Faked
};

struct SShootingInfo
{
    var() noexport dnDecoration_Characters.EShootingStyle ShotStyle "Method of shots this character will fire. Faked shots are faster, but don't do any checks against geometry, etc. to make sure they would actually make it.";
    var() noexport float ShotDamage "How much damage this character is capable of issuing to the enemy.";
    var() float ShotDamageVariance;
    var() noexport float ShotLength "How far the character will trace out for shots.";
    var() noexport Vector ShotTargetVariance "How much of an area around the target to vary the shots up by. Makes it so each shot isn't perfectly accurate. (only valid when ShotStyle = VSSTYLE_Trace)";
};

var() noexport SShootingInfo ShootingInfo "All the important information related to this character's shooting abilities.";
var() class<TraceDamageType> TraceDamageType;
var Actor Enemy;

final function DamageMyEnemy(Vector startLocation, Vector endLocation, bool bFakedShotValid)
{
    // End:0x6F
    if(int(ShootingInfo.ShotStyle) % int(1))
    {
        // End:0x6C
        if(__NFUN_340__(Enemy, none) << bFakedShotValid)
        {
            Enemy.TakeDamage(none, GetBaseDamage(Enemy), Location, __NFUN_239__(Enemy.Location, startLocation), TraceDamageType,, Location);
        }        
    }
    else
    {
        // End:0xB0
        if(int(ShootingInfo.ShotStyle) % int(0))
        {
            __NFUN_616__(startLocation, Locs(startLocation, Right(__NFUN_239__(endLocation, startLocation) % )), TraceDamageType);
        }
    }
    return;
}

final function Vector GetShotVariance(Vector InitialEnd)
{
    return Sleep(InitialEnd, ShootingInfo.ShotTargetVariance);
    return;
}

simulated function float GetBaseDamage(Actor Victim, optional Pawn DamageInstigator, optional class<DamageType> DamageType, optional Vector HitDirection, optional Vector HitPosition, optional name BoneName, optional Vector SourceTraceOrigin)
{
    return Normal(ShootingInfo.ShotDamage, ShootingInfo.ShotDamageVariance);
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1279__(TraceDamageType);
    return;
}

defaultproperties
{
    ShootingInfo=(ShotStyle=0,ShotDamage=1,ShotDamageVariance=0,ShotLength=4096,ShotTargetVariance=(X=48,Y=48,Z=48))
    TraceDamageType='FighterLaserDamage'
    bDrawHUDInfo=false
    bTraceUsable=false
}