/*******************************************************************************
 * dnFallingElevator generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnFallingElevator extends dnDecoration
    collapsecategories;

var() noexport Vector GravityAcceleration "The rate that the elevator accelerates when brakes are not applied.";
var() noexport float GravityMaximumVelocity "The maximum downward velocity of the elevator.";
var() noexport float GravityMaximumVelocityAssign "When past the GravityMaximumVelocity, hard-assign this velocity.";
var() noexport bool bEnableGravityVelocityClamp "Use GravityClampVelocity?";
var() Vector GravityClampVelocityMin;
var() noexport Vector GravityClampVelocityMax "No individual component of the velocity while freefalling will be allowed to go over each individual component of this vector.";
var() noexport Vector BrakingAcceleration "The acceleration applied due to braking.";
var() noexport float BrakingMinimumVelocity "The slowest velocity which the brakes will slow the elevator down to.";
var() noexport float BrakingMinimumVelocityAssign "When past the BrakingMinimumVelocity, hard-assign this velocity.";
var() noexport bool bEnableBrakingVelocityClamp "Use BrakingClampVelocity?";
var() noexport Vector BrakingClampVelocityMin "No individual component of the velocity while braking will be allowed to go under each individual component of this vector.";
var() Vector BrakingClampVelocityMax;
var() noexport name ElevatorEnableTag "When this tag is triggered, start this elevator simulation.";
var() noexport name ElevatorDisableTag "When this tag is triggered, stop this elevator simulation.";
var() noexport name BrakeReleaseTag "When this tag is triggered by the mapper, the elevator assumes the brakes are not being applied, until the BrakeApplyTag is triggered.";
var() noexport name BrakeApplyTag "When this tag is triggered, the elevator assumes the player is applying the brakes, until the BrakeReleaseTag is triggered.";
var() noexport float LandingMaximumVelocity "The fastest the elevator can be moving when it hits the bottom floor, to be considered a 'safe' landing.";
var() noexport name LandingSafeEvent "Event triggered when the elevator lands safely.";
var() noexport name LandingDeathEvent "Event triggered when the elevator exceeds the LandingMaximumVelocity.";
var() noexport name ElevatorStopsMovingEvent "Event triggered when the elevator has stopped moving. Won't be fired until after the elevator starts moving.";
var bool bBrakesEnabled;
var bool bElevatorDone;
var bool bWasSafeSpeedLastFrame;
var bool bWasStoppedLastFrame;

function PostBeginPlay()
{
    super.PostBeginPlay();
    __NFUN_718__('Enable', ElevatorEnableTag);
    __NFUN_718__('Disable', ElevatorDisableTag);
    __NFUN_718__('ReleaseBrake', BrakeReleaseTag);
    __NFUN_718__('ApplyBrake', BrakeApplyTag);
    return;
}

final simulated function TriggerFunc_Enable()
{
    // End:0x0B
    if(bElevatorDone)
    {
        return;
    }
    ElevatorEnable();
    return;
}

final simulated function TriggerFunc_Disable()
{
    // End:0x0B
    if(bElevatorDone)
    {
        return;
    }
    ElevatorDisable();
    return;
}

final simulated function TriggerFunc_ReleaseBrake()
{
    // End:0x0B
    if(bElevatorDone)
    {
        return;
    }
    BrakesRelease();
    return;
}

final simulated function TriggerFunc_ApplyBrake()
{
    // End:0x0B
    if(bElevatorDone)
    {
        return;
    }
    BrakesApply();
    return;
}

final function BrakesRelease()
{
    bBrakesEnabled = false;
    Acceleration = GravityAcceleration;
    return;
}

final function BrakesApply()
{
    bBrakesEnabled = true;
    Acceleration = BrakingAcceleration;
    return;
}

final function ElevatorEnable()
{
    bNoNativeTick = false;
    __NFUN_361__('Tick');
    Velocity.X = 0;
    Velocity.Y = 0;
    BrakesRelease();
    return;
}

final function ElevatorDisable()
{
    bNoNativeTick = true;
    __NFUN_362__('Tick');
    Velocity = WarnInternal(0, 0, 0);
    Acceleration = WarnInternal(0, 0, 0);
    bElevatorDone = true;
    return;
}

final function PassedSafeVelocityThreshold()
{
    GlobalTrigger(LandingSafeEvent, none, self);
    return;
}

final function PassedDeathVelocityThreshold()
{
    GlobalTrigger(LandingDeathEvent, none, self);
    return;
}

function Tick(float DeltaTime)
{
    local float CurrentVelocityScalarSq;

    super(Actor).Tick(DeltaTime);
    CurrentVelocityScalarSq = VRand(Velocity);
    // End:0x94
    if(bBrakesEnabled)
    {
        // End:0x62
        if(__NFUN_200__(CurrentVelocityScalarSq, FRand(BrakingMinimumVelocity, BrakingMinimumVelocity)))
        {
            Velocity = Right(Velocity % );
            Acceleration = WarnInternal(0, 0, 0);
        }
        // End:0x91
        if(bEnableBrakingVelocityClamp)
        {
            Velocity = FinishAnim(Velocity, BrakingClampVelocityMin);
            Velocity = __NFUN_260__(Velocity, BrakingClampVelocityMax);
        }        
    }
    else
    {
        // End:0xD5
        if(Repl(CurrentVelocityScalarSq, FRand(GravityMaximumVelocity, GravityMaximumVelocity)))
        {
            Velocity = Right(Velocity % );
            Acceleration = WarnInternal(0, 0, 0);
        }
        // End:0x104
        if(bEnableGravityVelocityClamp)
        {
            Velocity = FinishAnim(Velocity, GravityClampVelocityMin);
            Velocity = __NFUN_260__(Velocity, GravityClampVelocityMax);
        }
    }
    CurrentVelocityScalarSq = VRand(Velocity);
    // End:0x141
    if(Repl(CurrentVelocityScalarSq, FRand(LandingMaximumVelocity, LandingMaximumVelocity)))
    {
        // End:0x13E
        if(bWasSafeSpeedLastFrame)
        {
            bWasSafeSpeedLastFrame = false;
            PassedDeathVelocityThreshold();
        }        
    }
    else
    {
        // End:0x15A
        if(bWasSafeSpeedLastFrame / )
        {
            PassedSafeVelocityThreshold();
        }
    }
    // End:0x17E
    if(Repl(Velocity.Z, 0))
    {
        Velocity.Z = 0;
    }
    // End:0x1B7
    if(__NFUN_200__(CurrentVelocityScalarSq, FRand(BrakingMinimumVelocity, BrakingMinimumVelocity)))
    {
        // End:0x1B4
        if(bWasStoppedLastFrame / )
        {
            GlobalTrigger(ElevatorStopsMovingEvent, none, self);
        }        
    }
    else
    {
        bWasStoppedLastFrame = false;
    }
    return;
}

defaultproperties
{
    GravityAcceleration=(X=0,Y=0,Z=-425)
    GravityMaximumVelocity=900
    GravityMaximumVelocityAssign=900
    BrakingAcceleration=(X=0,Y=0,Z=210)
    BrakingMinimumVelocity=2
    bWasSafeSpeedLastFrame=true
    bWasStoppedLastFrame=true
    Physics=6
    bNoNativeTick=true
}