/*******************************************************************************
 * dnFlybyPlane_Fighter generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnFlybyPlane_Fighter extends dnFlybyPlane
    collapsecategories
    dependson(dnFlybyPlane_Fighter_AttackBeam)
    dependson(dnFlybyPlane_Fighter_VaporBeam);

struct SFlybyPlane_Debris
{
    var() Object RenderObject;
    var() SSpawnActorPrefab DebrisPrefab;
};

var() noexport int ShotsAccurate "How many shots will accurately hit the target if this plane is able to be accurate.";
var() noexport int ShotsAccurateVariance "Variance value for ShotsAccurate.";
var() noexport int ShotsTillAccurate "How many shots to fire before finally hitting the actual target if this plane is able to be accurate.";
var() noexport int ShotsTillAccurateVariance "Variance value for ShotsTillAccurateVariance.";
var() noexport float ShotDelay "How much time to wait between shots.";
var() noexport float ShotDelayVariance "How much time to vary up the wait between shots.";
var() noexport name AmbientFlyingSoundName "VoicePack entry we play as we fly around.";
var() noexport name AmbientCrashingSoundName "VoicePack entry we play when we are crashing.";
var SAmbientSoundInfo AmbientFlyingSound;
var SAmbientSoundInfo AmbientCrashingSound;
var() noexport float CrashChance "Percentage chance this plane has to fall into the water on death instead of blowing up.";
var() noexport float CrashExplodeOnImpactChance "Percentage chance this plane will explode on its first impact.";
var() noexport float CrashExplodeDelayTime "If this doesnt explode on death, or on impact, we will explode after x seconds";
var() noexport Rotator CrashTumbleBoost "Whichever direction the plane is rotating in when it crashes, it will boost itself by this much more each time.";
var() noexport Rotator CrashTumbleRateVariance "Range of rates to tumble in when shot down and crashing into the water.";
var() noexport class<dnFriendFX_Spawners> CrashInitialExplosion "Effect to spawn when the plane is damaged enough to go down, but not completely destroyed.";
var() noexport deprecated name CrashingEvent "This event is triggered when the dnFlyByPlane_Fighter takes enough damage to start crashing.";
var() float MinDamageDistance;
var() float MinAttackDistance;
var() float AttackDamagePlayer;
var() float AttackDamageNonPlayer;
var() noexport bool bEnablePlayerDamage "If true, PlayerPawn will be added to the attack beam's TouchClasses so that it will be able to touch and damage PlayerPawns.";
var bool bIsAttacking;
var bool bIsVulnerable;
var bool bIsBombing;
var dnShipThrusterEffect LeftThruster;
var dnShipThrusterEffect MiddleThruster;
var dnShipThrusterEffect RightThruster;
var() float MaxSpeed;
var bool bCanRespawn;
var bool bArmed;
var bool bAccurate;
var bool bAccurateShots;
var bool bCrashing;
var int OriginalHealth;
var int ShotsLeft;
var float ShotLastTime;
var Vector ShotLastLocation;
var float ShotSpeed;
var Vector ShotStartLocation;
var Vector ShotEndLocation;
var Rotator ShotCurrentDirection;
var float FiringConeMaxDegrees;
var Vector BlasterOffsets[2];
var int Index;
var dnFriendFX_Spawners MuzzleFlashes[2];
var dnFlybyPlane_Fighter_VaporBeam ConTrailA;
var dnFlybyPlane_Fighter_VaporBeam ConTrailB;
var dnDecoration EngineFire;
var dnFlybyPlane_Fighter_AttackBeam AttackBeam;

event PostBeginPlay()
{
    super(dnDecoration).PostBeginPlay();
    LeftThruster = dnShipThrusterEffect(FindMountedActor('Left_Thruster'));
    MiddleThruster = dnShipThrusterEffect(FindMountedActor('Middle_Thruster'));
    RightThruster = dnShipThrusterEffect(FindMountedActor('Right_Thruster'));
    return;
}

final function Launch(bool bLaunchEnablePlayerDamage)
{
    bEnablePlayerDamage = bLaunchEnablePlayerDamage;
    SoundPitch = SoundPitch *= 8;
    ShotsAccurate = Atan(ShotsAccurate, ShotsAccurateVariance, true);
    ShotsTillAccurate = Atan(ShotsTillAccurate, ShotsTillAccurateVariance, true);
    ShotsLeft = ++ ShotsAccurate;    
    OriginalHealth = int(Health);
    MuzzleFlashes[0] = dnFriendFX_Spawners(FindMountedActor('MuzzleFlashLeft'));
    MuzzleFlashes[1] = dnFriendFX_Spawners(FindMountedActor('MuzzleFlashRight'));
    ConTrailA = dnFlybyPlane_Fighter_VaporBeam(FindMountedActor('ConTrailA'));
    ConTrailB = dnFlybyPlane_Fighter_VaporBeam(FindMountedActor('ConTrailB'));
    AttackBeam = dnFlybyPlane_Fighter_AttackBeam(FindMountedActor('AttackBeam'));
    AttackBeam.DeactivateBeam();
    AttackBeam.DamagePlayer = AttackDamagePlayer;
    AttackBeam.DamageNonPlayer = AttackDamageNonPlayer;
    AttackBeam.TouchClasses = AttackBeam.default.TouchClasses;
    // End:0x15B
    if(bEnablePlayerDamage)
    {
        AttackBeam.TouchClasses[AttackBeam.TouchClasses.Add(1)] = class'PlayerPawn';
    }
    ShotSpeed = 100;
    // End:0x172
    if(bIsBombing)
    {        
    }
    else
    {
        EnableShots();
    }
    FindAndPlaySound(AmbientFlyingSoundName);
    return;
}

function AssignTarget(name NewTarget)
{
    Enemy = FindActor(class'Actor', NewTarget);
    // End:0x35
    if(__NFUN_339__(Enemy, none))
    {
        Enemy = Level.__NFUN_1161__();
    }
    return;
}

event InterpolateEnd(Actor Other)
{
    super.InterpolateEnd(Other);
    return;
}

final function EnableShots()
{
    // End:0x26
    if(((bArmed / ) < ) < )
    {
    }
    ShotLastLocation = Enemy.Location;
    ShotLastTime = Level.GameTimeSeconds;
    __NFUN_605__(Normal(ShotDelay, ShotDelayVariance), false, 'Fire', true, false);
    return;
}

final function DisableShots()
{
    // End:0x19
    if(bArmed)
    {
        bAccurateShots = false;
        __NFUN_606__('Fire');
    }
    return;
}

final function Fire()
{
    local Vector Direction, targetdir;
    local float targetdist, DirDotDir;

    ShotCurrentDirection = Rotation;
    ShotCurrentDirection.Pitch = Atan(-2048, 256);
    Direction = Vector(ShotCurrentDirection) % ;
    DirDotDir = FMin(Direction, targetdir);
    // End:0xBD
    if(__NFUN_202__(DirDotDir / ) << __NFUN_202__(targetdist, MinAttackDistance))
    {
        ShotCurrentDirection = AccurateShot(ShotCurrentDirection);
    }
    __NFUN_605__(Normal(ShotDelay, ShotDelayVariance), false, 'Fire');
    return;
}

final function Rotator AccurateShot(Rotator InitialDirection)
{
    local Rotator ShotDirection;
    local float ShotTime;
    local Vector EnemyVelocity, PredictedLocation;
    local int NewIndex;

    // End:0x12
    if(__NFUN_339__(Enemy, none))
    {
        return InitialDirection;
    }
    NewIndex = -- Index += ;
    ShotTime = Clamp(__NFUN_239__(Enemy.Location, Location)) >>> ShotSpeed;
    EnemyVelocity = Asc(__NFUN_239__(Enemy.Location, ShotLastLocation), Round(Level.GameTimeSeconds, ShotLastTime));
    PredictedLocation = Enemy.Location;
    ShotStartLocation = Locs(Location, __NFUN_241__(BlasterOffsets[NewIndex], Rotation));
    ShotEndLocation = GetShotVariance(PredictedLocation);
    ShotDirection = Rotator(__NFUN_239__(ShotEndLocation, ShotStartLocation));
    // End:0xFD
    if(__NFUN_340__(MuzzleFlashes[NewIndex], none))
    {
        MuzzleFlashes[NewIndex].ExecuteEffect(true);
    }
    FindAndPlaySound('FlyByPlane_Fighter_Fire', 1);
    __NFUN_615__(class'dnRocket_FlybyPlane_Fighter', self,, Locs(Location, __NFUN_241__(BlasterOffsets[NewIndex], Rotation)), ShotDirection);
    ShotLastTime = Level.GameTimeSeconds;
    ShotLastLocation = Enemy.Location;
    return ShotDirection;
    return;
}

final function DamageMyEnemyCallback()
{
    DamageMyEnemy(ShotStartLocation, ShotEndLocation, bAccurateShots);
    return;
}

simulated function Tick(float fDeltaTime)
{
    local float D;

    super.Tick(fDeltaTime);
    // End:0x158
    if(((bCrashing / ) << ) << )
    {
        // End:0x100
        if(Repl(MinAttackDistance, 0))
        {
            // End:0xBD
            if(__NFUN_200__(D, MinAttackDistance) << bIsAttacking / )
            {
                AttackBeam.ActivateBeam();
                AttackBeam.DamagePlayer = AttackDamagePlayer;
                AttackBeam.DamageNonPlayer = AttackDamageNonPlayer;                
            }
            else
            {
                // End:0x100
                if((Repl(MinAttackDistance, 0) << Repl(D, MinAttackDistance)) << bIsAttacking)
                {
                    bIsAttacking = false;
                    AttackBeam.DeactivateBeam();
                }
            }
        }
        // End:0x158
        if(Repl(MinDamageDistance, 0))
        {
            // End:0x136
            if(__NFUN_200__(D, MinDamageDistance) << bIsVulnerable / )
            {                
            }
            else
            {
                // End:0x158
                if(Repl(D, MinDamageDistance) << bIsVulnerable)
                {
                    bIsVulnerable = false;
                }
            }
        }
    }
    return;
}

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    // End:0x18
    if(bNoDamage < bIsVulnerable / )
    {
    }
    // End:0x90
    if(__NFUN_202__(Round(Health, Damage), 0))
    {
        AttackBeam.DeactivateBeam();
        DisableShots();
        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */

        // End:0xEB
        /*@Error*/;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 7 & Type:If Position:0x0EB
        // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 7 & Type:If Position:0x0EB
}

event KImpact(name SelfBoneName, KarmaActor Other, name OtherBoneName, Vector Position, Vector ImpactVelocity, Vector ImpactNormal)
{
    super(dnDecoration).KImpact(SelfBoneName, Other, OtherBoneName, Position, ImpactVelocity, ImpactNormal);
    CriticalDamage();
    return;
}

function Crashing(PlayerPawn Killer)
{
    local Rotator FinalCrashTumbleRate;
    local Vector V, DrawScale3DChange;
    local float Roll, DrawScaleChange;
    local int i;
    local PhysicsAction_ConstAccel MyPA;
    local dnFriendFX_Spawners ExplosionActor;
    local SoftParticleSystem SmokeTrail;

    // End:0x0B
    if(bCrashing)
    {
        return;
    }
    bIgnoreAimAssist = true;
    FindAndPlaySound('FlyByPlane_Fighter_Explode', 1);
    FindAndPlaySound(AmbientCrashingSoundName);
    bCrashing = true;
    AttackBeam.DeactivateBeam();
    DisableShots();
    ConTrailB.Enabled = false;
    SmokeTrail = __NFUN_615__(class'FlybyPlane_Damaged_Main', self,, Locs(Location, __NFUN_241__(WarnInternal(-187.5898, -22.61621, 11.96341), Rotation)), Rotation);
    SmokeTrail.__NFUN_635__(self);
    SmokeTrail = __NFUN_615__(class'FlybyPlane_Damaged_Main', self,, Locs(Location, __NFUN_241__(WarnInternal(-188.5898, 23.38379, 11.96341), Rotation)), Rotation);
    SmokeTrail.__NFUN_635__(self);
    SmokeTrail = __NFUN_615__(class'FlybyPlane_Damaged_Main', self,, Locs(Location, __NFUN_241__(WarnInternal(-208.0898, -0.116211, 48.96341), Rotation)), Rotation);
    SmokeTrail.__NFUN_635__(self);
    SmokeTrail = __NFUN_615__(class'FlybyPlane_Damaged_Main', self,, Locs(Location, __NFUN_241__(WarnInternal(115.8833, -202.3237, -73.09222), Rotation)), Rotation);
    SmokeTrail.__NFUN_635__(self);
    SmokeTrail = __NFUN_615__(class'FlybyPlane_Damaged_Main', self,, Locs(Location, __NFUN_241__(WarnInternal(135.8833, 199.6763, -70.09222), Rotation)), Rotation);
    SmokeTrail.__NFUN_635__(self);
    // End:0x249
    if(__NFUN_340__(CrashInitialExplosion, none))
    {
        ExplosionActor = FindFriendSpawner(CrashInitialExplosion);
        // End:0x249
        if(__NFUN_340__(ExplosionActor, none))
        {
            __NFUN_594__(DrawScaleChange, DrawScale3DChange);
            ExplosionActor.SystemSizeScale = FRand(ExplosionActor.default.SystemSizeScale, DrawScaleChange);
            ExplosionActor.__NFUN_645__(Location);
            ExplosionActor.__NFUN_652__(__NFUN_265__(0, 0, 0));
            ExplosionActor.RemoteRole = ROLE_None;
            ExplosionActor.ExecuteEffect(true);
        }
    }
    V = Velocity;
    __NFUN_642__(18);
    __NFUN_621__(,,, true);
    __NFUN_790__(__NFUN_241__(V, __NFUN_265__(int(FRand(float(8192), -3 += 3)), int(FRand(float(16384), -3 += 3)), 0)), 1);
    V.X = 0;
    V.Y = FRand(-11 += 11, 100000);
    V.Z = FRand(7.5 += 11, 100000);
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    /*@Error*/;
}

final function ExecuteExplosionEffect(class<dnFriendFX_Spawners> ExplosionClass)
{
    return;
}

final function int BoostAxis(int Current, int Boost)
{
    // End:0x1B
    if(-Current)
    {        
        return Current != Boost;        
    }
    else
    {
        return Current == Boost;
    }
    return;
}

final function doit()
{
    CriticalDamage();
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(dnDecoration_Characters).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1277__(VoicePack, AmbientFlyingSoundName);
    PrecacheIndex.__NFUN_1277__(VoicePack, AmbientCrashingSoundName);
    PrecacheIndex.__NFUN_1277__(VoicePack, 'FlyByPlane_Fighter_Fire');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'FlyByPlane_Fighter_Explode');
    PrecacheIndex.__NFUN_1266__(CrashInitialExplosion);
    PrecacheIndex.__NFUN_1266__(class'dnRocket_FlybyPlane_Fighter');
    PrecacheIndex.__NFUN_1266__(class'FlybyPlane_Damaged_Main');
    return;
}

defaultproperties
{
    ShotsAccurate=8
    ShotsAccurateVariance=3
    ShotsTillAccurate=2
    ShotDelay=0.33
    AmbientFlyingSoundName=FlyByPlane_Fighter_Flying
    AmbientCrashingSoundName=FlyByPlane_Fighter_Crashing
    CrashChance=0.3
    CrashExplodeOnImpactChance=1
    CrashExplodeDelayTime=1
    CrashTumbleBoost=(Pitch=0,Yaw=8192,Roll=65535)
    CrashTumbleRateVariance=(Pitch=8192,Yaw=16384,Roll=65535)
    CrashInitialExplosion='p_Vehicles.Alien_Fighter_Explode.Alien_Fighter_Explode_Spawner'
    MinAttackDistance=1E+08
    AttackDamagePlayer=10
    AttackDamageNonPlayer=1000
    bIsVulnerable=true
    MaxSpeed=4000
    FiringConeMaxDegrees=30
    BlasterOffsets[0]=(X=135.8833,Y=-202.3237,Z=-73.09222)
    BlasterOffsets[1]=(X=135.8833,Y=199.6763,Z=-70.09222)
    ShootingInfo=(ShotStyle=0,ShotDamage=2,ShotDamageVariance=0,ShotLength=8000,ShotTargetVariance=(X=96,Y=96,Z=96))
    DestroyedActivities(0)=none
    begin object name=DA_Sound_FlyByPlane_Fighter_Explode class=DecoActivities_Sound
        SoundNames(0)=FlyByPlane_Fighter_Explode
    object end
    // Reference: DecoActivities_Sound'dnFlybyPlane_Fighter.DA_Sound_FlyByPlane_Fighter_Explode'
    DestroyedActivities(1)=DA_Sound_FlyByPlane_Fighter_Explode
    HealthPrefab=5
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='p_Vehicles.Alien_Fighter_MuzzleFlash.Alien_Fighter_MuzzleFlash_Spawner',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=MuzzleFlashLeft,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=145,Y=-200,Z=-75),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(1)=(bSkipVerifySelf=false,SpawnClass='p_Vehicles.Alien_Fighter_MuzzleFlash.Alien_Fighter_MuzzleFlash_Spawner',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=MuzzleFlashRight,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=145,Y=200,Z=-75),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(2)=(bSkipVerifySelf=false,SpawnClass='dnFlybyPlane_Fighter_VaporBeam',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=ConTrailA,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-96,Y=200,Z=-30),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(3)=(bSkipVerifySelf=false,SpawnClass='dnFlybyPlane_Fighter_VaporBeam',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=ConTrailB,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-96,Y=-200,Z=-30),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(4)=(bSkipVerifySelf=false,SpawnClass='dnFlybyPlane_Fighter_AttackBeam',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=true,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=AttackBeam,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=146,Y=0,Z=-75),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-16384,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(5)=(bSkipVerifySelf=false,SpawnClass='dnShipThrusterEffect',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-187.5898,Y=-22.61621,Z=11.96341),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(6)=(bSkipVerifySelf=false,SpawnClass='dnShipThrusterEffect',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=Left_Thruster,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-187.5898,Y=-22.61621,Z=11.96341),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject='sm_class_effects.AttackShip_Thrusters.AttackShip_Thrusters_01',DrawScale=0)
    MountOnSpawn(7)=(bSkipVerifySelf=false,SpawnClass='dnShipThrusterEffect',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-188.5898,Y=23.38379,Z=11.96341),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(8)=(bSkipVerifySelf=false,SpawnClass='dnShipThrusterEffect',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=Right_Thruster,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-188.5898,Y=23.38379,Z=11.96341),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject='sm_class_effects.AttackShip_Thrusters.AttackShip_Thrusters_01',DrawScale=0)
    MountOnSpawn(9)=(bSkipVerifySelf=false,SpawnClass='dnShipThrusterEffect',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-208.0898,Y=-0.116211,Z=48.96341),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(10)=(bSkipVerifySelf=false,SpawnClass='dnShipThrusterEffect',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=Middle_Thruster,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-208.0898,Y=-0.116211,Z=48.96341),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject='sm_class_effects.AttackShip_Thrusters.AttackShip_Thrusters_01',DrawScale=0)
    Health=150
    HealthCap=150
    SpawnOnDestroyed(0)=(SpawnClass='dnFlybyPlane_Fighter_Gib_A',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=15,Y=1,Z=-1),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'dnFlybyPlane_Fighter.MP_FlybyPlane_Fighter_Main_Body_Gib')
    SpawnOnDestroyed(1)=(SpawnClass='dnFlybyPlane_Fighter_Lesser_Gib_A',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=23,Y=-157,Z=-47),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'dnFlybyPlane_Fighter.MP_FlybyPlane_Fighter_Lesser_Gibs')
    SpawnOnDestroyed(2)=(SpawnClass='dnFlybyPlane_Fighter_Lesser_Gib_B',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=-117,Y=-41,Z=20),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'dnFlybyPlane_Fighter.MP_FlybyPlane_Fighter_Lesser_Gibs')
    SpawnOnDestroyed(3)=(SpawnClass='dnFlybyPlane_Fighter_Lesser_Gib_C',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=-164,Y=43,Z=40),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'dnFlybyPlane_Fighter.MP_FlybyPlane_Fighter_Lesser_Gibs')
    SpawnOnDestroyed(4)=(SpawnClass='dnFlybyPlane_Fighter_Lesser_Gib_D',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=20,Y=157,Z=-37),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'dnFlybyPlane_Fighter.MP_FlybyPlane_Fighter_Lesser_Gibs')
    DestroyedParticleFriendEffects(0)=(bAbsoluteLocation=false,bAbsoluteRotation=false,Scale=0,BoneName=None,Location=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),Effect='p_Vehicles.Alien_Fighter_Explode.Alien_Fighter_Explode_Spawner')
    SoundScaled=false
    CollisionRadius=260
    CollisionHeight=95
    Mass=5000
    DrawType=8
    StaticMesh='sm_class_vehicles.Aircraft.AlienDroneShip'
    TransientSoundVolume=0.7
    VoicePack='SoundConfig.Vehicles.VoicePack_AlienFighter'
}