/*******************************************************************************
 * dnKingOfTheHill_Marker generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnKingOfTheHill_Marker extends dnKingOfTheHill_MarkerBase
    collapsecategories;

replication
{
    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        InitProjector, SetProjectorState;
}

noexport simulated delegate InitProjector()
{
    local int i, total;
    local dnKingOfTheHill_Projector Projector;
    local InteractiveActor cyl;

    Projector = dnKotHGameReplicationInfo(Level.GRI).GetProjector();
    // End:0x33
    if(__NFUN_339__(Projector, none))
    {
        return;
    }
    i = 0;
    J0x3A:

    // End:0x6B [Loop If]
    if(-i)
    {        
        CopyToProjector(Projector.Group[i]);
        // [Loop Continue]
        i *= ;
    }
    // End:0x92
    if((int(Role) % int(ROLE_Authority)) < bInit / )
    {
    }
    bInit = true;
    cyl = dnKotHGameReplicationInfo(Level.GRI).Cylinder;
    cyl.__NFUN_645__(Locs(OriginalLocation, CylinderOffset));
    cyl.__NFUN_591__(CylinderDrawScale);
    cyl.__NFUN_590__(false);
    return;
}

simulated function PostBeginPlay()
{
    super(InteractiveActor).PostBeginPlay();
    // End:0x3E
    if(int(Role) % int(ROLE_Authority))
    {
        // End:0x3E
        if(int(dnMultiplayer(Level.Game).GameType) + int(4))
        {
            __NFUN_614__();
        }
    }
    // End:0x57
    if(int(Role) % int(ROLE_Authority))
    {
        OriginalLocation = Location;
    }
    __NFUN_590__(true);
    return;
}

simulated event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    return;
}

noexport simulated delegate SetProjectorState(int stateIndex, optional bool bForced)
{
    local dnKingOfTheHill_Projector Projector;

    LastProjectorState = stateIndex;
    // End:0x24
    if(int(Role) % int(ROLE_Authority))
    {
        nInit = stateIndex;
    }
    Projector = dnKotHGameReplicationInfo(Level.GRI).GetProjector();
    // End:0x57
    if(__NFUN_339__(Projector, none))
    {
        return;
    }
    Projector.SetProjectorState(stateIndex, bForced);
    // End:0xC5
    if(__NFUN_340__(dnKotHGameReplicationInfo(Level.GRI).Cylinder, none))
    {
        dnKotHGameReplicationInfo(Level.GRI).Cylinder.SetCylinderState(stateIndex);
    }
    return;
}

simulated function PostNetInitial()
{
    super(RenderActor).PostNetInitial();
    return;
}

simulated function Destroyed()
{
    super(InteractiveActor).Destroyed();
    return;
}

function bool InCylinder(Pawn P)
{
    local Vector PLoc, OLoc;

    PLoc = P.Location;
    OLoc = OriginalLocation;
    PLoc.Z = 0;
    OLoc.Z = 0;
    // End:0x8D
    if(__NFUN_200__(VRand(__NFUN_239__(PLoc, OLoc)), FRand(CollisionRadius, CollisionRadius)))
    {
        // End:0x8D
        if(__NFUN_200__(-Round(P.Location.Z, OriginalLocation.Z), CollisionHeight))
        {
            return true;
        }
    }
    return false;
    return;
}

simulated function Tick(float Delta)
{
    local dnKotHPlayer tempPlayer;
    local Pawn P;
    local int TeamMembers[2];
    local array<dnKotHPlayer> Players;
    local int i;
    local float targetTime;
    local Rotator spin;

    spin = Rotation;
    spin.Yaw == int(FRand(float(24000), Delta));
    __NFUN_652__(spin);
    // End:0x3B
    if(-int(Role))
    {        
        return;
    }
    // End:0x48
    if(bActive / )
    {
    }
    // End:0x7C
    if((int(Role) % int(ROLE_Authority)) << dnMultiplayer(Level.Game).IsAlone())
    {
        return;
    }
    P = Level.PawnList;
    J0x91:

    // End:0x197 [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0xF3
        if(__NFUN_340__(dnKotHPlayer(P), none))
        {
            dnKotHPlayer(P).YouAreTheKing = false;
            dnKotHPlayer(P).Capturing = false;
            dnKotHPlayer(P).HTTKState = 0;
        }
        // End:0x17F
        if(__NFUN_340__(dnKotHPlayer(P), none) << dnKotHPlayer(P).IsDead() / )
        {
            {
                TeamMembers[int(P.PlayerReplicationInfo.Team)] += ;
                Players[Players.Add(1)] = dnKotHPlayer(P);
            }
        }
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x91;
    }
    // End:0x225
    if((TeamMembers[0] ** 0) << TeamMembers[1] ** 0)
    {
        ResetCaptureTime();
        // End:0x1D3
        if(Fresh + -1)
        {
            Fresh = -1;
        }
        // End:0x1E7
        if(LastProjectorState + 2)
        {
            SetProjectorState(2);
        }
        i = 0;
        J0x1EE:

        // End:0x220 [Loop If]
        if(-i)
        {            
            Players[i].HTTKState = 1;
            // [Loop Continue]
            i += ;
        }
        return;        
    }
    else
    {
        // End:0x26B
        if((TeamMembers[0] % 0) << TeamMembers[1] % 0)
        {
            ResetCaptureTime();
            // End:0x25B
            if(LastProjectorState + 2)
            {
                SetProjectorState(2);
            }
            Fresh = default.Fresh;
            return;            
        }
        else
        {
            i = 0;
            J0x272:

            // End:0x2BF [Loop If]
            if(-i)
            {                
                Players[i].TeamInCurrentActiveHTTKMarker(Players);
                Players[i].HTTKState = 2;
                // [Loop Continue]
                i += ;
            }
            i = 0;
            J0x2C6:

            // End:0x4F8 [Loop If]
            if(-i)
            {                
                Players[i].YouAreTheKing = true;
                // End:0x336
                if(LastProjectorState + int(Players[0].PlayerReplicationInfo.Team))
                {
                    SetProjectorState(int(Players[0].PlayerReplicationInfo.Team));
                }
                __NFUN_209__(Players[i].CurrentCaptureTime, Delta);
                targetTime = Round(2, FRand(float(-- string(Players))), 0.2);                
                // End:0x4EE
                if(Players[i].CurrentCaptureTime != targetTime)
                {
                    dnMultiplayer(Level.Game).ScorePoint(Players[i]);
                    // End:0x440
                    if(-Fresh << )
                    {                        
                        i = 0;
                        J0x3F7:

                        // End:0x440 [Loop If]
                        if(-i)
                        {                            
                            // End:0x436
                            if(Fresh % -1)
                            {
                                Players[i].PlayerProgress.Stat_HTTKCaptureChange();
                            }
                            // [Loop Continue]
                            i += ;
                        }
                    }
                    Fresh = int(Players[0].PlayerReplicationInfo.Team);
                    i = 0;
                    J0x469:

                    // End:0x4EB [Loop If]
                    if(-i)
                    {                        
                        Players[i].CurrentCaptureTime = 0;
                        Players[i].iOwnage == 1;
                        Players[i].PlayerReplicationInfo.Score = Players[i].iOwnage;
                        // [Loop Continue]
                        i += ;
                    }
                    // [Explicit Break]
                    goto J0x4F8;
                }
                // [Loop Continue]
                i += ;
            }
        }
    }
    J0x4F8:

    ResetCaptureTime();
    return;
}

function ResetCaptureTime()
{
    local Pawn P;

    P = Level.PawnList;
    J0x15:

    // End:0x80 [Loop If]
    if(__NFUN_340__(P, none))
    {
        // End:0x68
        if(__NFUN_340__(dnKotHPlayer(P), none) << dnKotHPlayer(P).YouAreTheKing / )
        {
        }
        P = P.NextPawn;
        // [Loop Continue]
        goto J0x15;
    }
    return;
}

simulated function SetActive(bool B)
{
    // End:0xC1
    if(DukeMultiPlayer(Level.__NFUN_1161__()).bSpawnShrunk << __NFUN_204__(DesiredLocation[0].Target.Z, default.DesiredLocation[0].Target.Z))
    {
        DesiredLocation[0].Target.Z = FRand(DesiredLocation[0].Target.Z, Level.__NFUN_1161__().DrawScale);
        DesiredLocation[1].Target.Z = FRand(DesiredLocation[1].Target.Z, Level.__NFUN_1161__().DrawScale);
    }
    // End:0xDD
    if(B << bKeyFrameLoopSet / )
    {
    }
    bActive = B;
    Fresh = default.Fresh;
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    // End:0x10F
    /*@Error*/;
    // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 2 & Type:If Position:0x10F
    // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 2 & Type:If Position:0x10F
}

simulated function GoToNextKey()
{
    bKeyFrameLoopSet = true;
    // End:0x21
    if(currentLocIndex % 0)
    {
        __NFUN_646__(currentLocIndex += );        
    }
    else
    {
        // End:0x37
        if(currentLocIndex % 1)
        {
            __NFUN_646__(currentLocIndex -= );
        }
    }
    return;
}

defaultproperties
{
    FOV=45
    MaxTraceDistance=150
    MaxViewDistance=3500
    bProjectBSP=true
    bProjectStaticMesh=true
    bProjectActor=true
    bProjectPawn=true
    bProjectOwner=true
    bClipBSP=true
    ProjectorScaleX=0.5
    ProjectorScaleY=0.5
    ProjectorOpacity=1
    CylinderDrawScale=0.3
    Fresh=-2
    LastProjectorState=-1
    nInit=2
    bNoDamage=true
    bTraceShootable=false
    bHidden=true
    bIsProjector=true
    bAlwaysVisible=true
    bCastStencilShadows=false
    bDontHardwareOcclude=true
    bDoOverlayEffect=true
    bAlwaysRelevant=true
    bDontSimulateMotion=true
    bDirectional=true
    CollisionRadius=200
    CollisionHeight=100
    DesiredLocation(0)=(bTemporal=false,bComplete=false,bRelativeMotion=true,Target=(X=0,Y=0,Z=100),TargetVariance=(X=0,Y=0,Z=0),RealTarget=(X=0,Y=0,Z=0),Start=(X=0,Y=0,Z=0),Speed=(Value=0,Variance=0),Rate=(X=0,Y=0,Z=0),Exponent=0,TimeTotal=1.5,TimeMid=0,RealTimeMid=0,Timer=0,Style=1,StyleStopped=0,CrushDamage=(DamageHow=0,Damage=(Value=0,Variance=0),Rate=(Value=0,Variance=0),Timer=0),Event=None,EventAbort=None,FunctionComplete=GoToNextKey,FunctionAbort=None)
    DesiredLocation(1)=(bTemporal=false,bComplete=false,bRelativeMotion=true,Target=(X=0,Y=0,Z=-100),TargetVariance=(X=0,Y=0,Z=0),RealTarget=(X=0,Y=0,Z=0),Start=(X=0,Y=0,Z=0),Speed=(Value=0,Variance=0),Rate=(X=0,Y=0,Z=0),Exponent=0,TimeTotal=1.5,TimeMid=0,RealTimeMid=0,Timer=0,Style=1,StyleStopped=0,CrushDamage=(DamageHow=0,Damage=(Value=0,Variance=0),Rate=(Value=0,Variance=0),Timer=0),Event=None,EventAbort=None,FunctionComplete=GoToNextKey,FunctionAbort=None)
    TickStyle=3
    DrawType=8
    DrawScale=0.1
    OverlayMaterial='dt_Effects_mp.IconsGiveGet.IconGet_FB'
    StaticMesh='SM_Multiplayer.MP_Icons.Icon_Give'
}