/*******************************************************************************
 * dnMPTuner generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnMPTuner extends MultiplayerInfo
    native
    collapsecategories
    hidecategories(movement,Collision,Lighting,LightColor,Actor,Advanced,Display,Editor,Events,Filter,Interpolation,Material,Mounting,Network,Sound,Tick,TickRules,VertexFunction,Actor,Advanced,Display,Editor,Events,Filter,Interpolation,Material,Mounting,Network,Sound,Tick,TickRules,VertexFunction);

cpptext
{
// Stripped
}

var() noexport netupdate(ApplyEgoRecoveryRate) float EgoRecoveryRate "how fast ego recovers";

// Export UdnMPTuner::execLoadDevIni(FFrame&, void* const)
native function LoadDevIni();

function PostBeginPlay()
{
    super(Actor).PostBeginPlay();
    return;
}

function ApplyDevIni()
{
    LoadDevIni();
    ApplyEgo(StartingEgo);
    ApplyHealth(StartingHealth);
    return;
}

function PreRestartPlayer(Pawn Player)
{
    super.PreRestartPlayer(Player);
    return;
}

function PostRestartPlayer(Pawn Player)
{
    local int i;

    super.PostRestartPlayer(Player);
    // End:0x1F
    if(int(Role) % int(ROLE_Authority))
    {
        LoadDevIni();
    }
    return;
}

simulated function ApplyEgo(float f)
{
    local Pawn Player;

    StartingEgo = f;
    // End:0x7A
    foreach __NFUN_747__(class'Pawn', Player)
    {
        Player.EgoCap = StartingEgo;
        Player.Ego = StartingEgo;
        Player.SetHealthCap(StartingHealth);
        Player.RaiseHealthToCap(Player.Location);        
    }    
    return;
}

simulated function ApplyHealth(float f)
{
    local Pawn Player;

    StartingHealth = f;
    // End:0x7A
    foreach __NFUN_747__(class'Pawn', Player)
    {
        Player.EgoCap = StartingEgo;
        Player.Ego = StartingEgo;
        Player.SetHealthCap(StartingHealth);
        Player.RaiseHealthToCap(Player.Location);        
    }    
    return;
}

simulated function ApplyEgoRecoveryRate(float f)
{
    local Pawn Player;

    EgoRecoveryRate = f;
    // End:0x31
    foreach __NFUN_747__(class'Pawn', Player)
    {
        Player.EgoRecoveryRate = EgoRecoveryRate;        
    }    
    return;
}

defaultproperties
{
    EgoRecoveryRate=5
    StartingEgo=80
    WeaponStayTime=5
    ConsoleCommands(0)="set Pistol BaseDamagePerShot 40"
    ConsoleCommands(1)="set Shotgun BaseDamagePerShot 15"
    ConsoleCommands(2)="set Shotgun HighBaseDamagePerShot 20"
    ConsoleCommands(3)="set MachineGun BaseDamagePerShot 18"
    ConsoleCommands(4)="set dnRocket_ATLaser Damage 20"
    ConsoleCommands(5)="set dnRocket_ATCaptainLaser Damage 20"
    ConsoleCommands(6)="set dnRocket_RPG_HeatSeek Damage 30"
    ConsoleCommands(7)="set dnRocket_RPG_Homing Damage 90"
    ConsoleCommands(8)="set dnPipeBombProjectile Damage 90"
    ConsoleCommands(9)="set LaserMine Damage 90"
    ConsoleCommands(10)="set dnRocket_Devastator Damage 25"
    ConsoleCommands(11)="set Pistol BaseDamagePerShot 1"
    ConsoleCommands(12)="set Shotgun BaseDamagePerShot 15"
    ConsoleCommands(13)="set Shotgun HighBaseDamagePerShot 20"
    ConsoleCommands(14)="set MachineGun BaseDamagePerShot 18"
    ConsoleCommands(15)="set dnRocket_ATLaser Damage 20"
    ConsoleCommands(16)="set dnRocket_ATCaptainLaser Damage 20"
    ConsoleCommands(17)="set dnRocket_RPG_HeatSeek Damage 30"
    ConsoleCommands(18)="set dnRocket_RPG_Homing Damage 90"
    ConsoleCommands(19)="set dnPipeBombProjectile Damage 90"
    ConsoleCommands(20)="set LaserMine Damage 90"
    ConsoleCommands(21)="set dnRocket_Devastator Damage 25"
}