/*******************************************************************************
 * dnMothershipGun generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnMothershipGun extends dnDecoration_Characters
    collapsecategories;

var Actor TargetActor;
var bool bFollowTarget;
var name PivotBoneName;
var name MuzzleBoneName;
var float MaxRotationSpeed;
var BeamSystem LaserBeam;
var SoftParticleSystem BeamCharge;
var SoftParticleSystem BeamShoot;
var SoftParticleSystem BeamImpact;
var dnFriendFX_Spawners BeamMuzzleFlash;
var float BeamChargeTime;
var float BeamOnTime;
var array<dnMothershipGunArmor> ArmorPieces;
var SoftParticleSystem ArmorExplosion;
var name TakeDamageEvent;
var bool bOnTarget;
var float OnTargetMinDot;
var name OnTargetEvent;
var bool bResetRotation;
var name ResetCompleteEvent;
var Rotator BaseRotation;
var float MaxResetRotationSpeed;
var anim name OpenAnim;
var anim name CloseAnim;

function PostVerifySelf()
{
    local dnMothershipGunArmor Armor;

    super(dnDecoration).PostVerifySelf();
    __NFUN_718__('FireOn', __NFUN_343__(__NFUN_302__(string(Tag), "FireOn")));
    __NFUN_718__('FireOff', __NFUN_343__(__NFUN_302__(string(Tag), "FireOff")));
    __NFUN_718__('FollowTargetOn', __NFUN_343__(__NFUN_302__(string(Tag), "FollowTargetOn")));
    __NFUN_718__('FollowTargetOff', __NFUN_343__(__NFUN_302__(string(Tag), "FollowTargetOff")));
    __NFUN_718__('LoseArmorPiece', __NFUN_343__(__NFUN_302__(string(Tag), "LoseArmorPiece")));
    __NFUN_718__('OpenGun', __NFUN_343__(__NFUN_302__(string(Tag), "OpenGun")));
    __NFUN_718__('CloseGun', __NFUN_343__(__NFUN_302__(string(Tag), "CloseGun")));
    __NFUN_718__('ResetRotation', __NFUN_343__(__NFUN_302__(string(Tag), "ResetRotation")));
    TargetActor = FindActor(class'Actor', __NFUN_343__(__NFUN_302__(string(Tag), "Target")));
    LaserBeam = __NFUN_615__(class'dnMothershipBeam');
    LaserBeam.Enabled = false;
    LaserBeam.TickStyle = 0;
    LaserBeam.MountType = 2;
    LaserBeam.MountMeshItem = 'mount_gun';
    LaserBeam.__NFUN_635__(self);
    LaserBeam.AddSegmentActor(LaserBeam, TargetActor,, 'mount_gun');
    BeamCharge = SoftParticleSystem(FindMountedActor('BeamCharge', class'SoftParticleSystem'));
    BeamShoot = SoftParticleSystem(FindMountedActor('BeamShoot', class'SoftParticleSystem'));
    BeamImpact = __NFUN_615__(class'MotherShip_GunBeam_Impact_Spawner');
    BeamMuzzleFlash = dnFriendFX_Spawners(FindMountedActor('BeamMuzzleFlash', class'dnFriendFX_Spawners'));
    // End:0x238
    foreach __NFUN_753__(class'dnMothershipGunArmor', Armor)
    {
        ArmorPieces[string(ArmorPieces)] = Armor;        
    }    
    ArmorExplosion = __NFUN_615__(class'Map02_MotherShip_Gun_Explode_Spawner');
    TakeDamageEvent = __NFUN_343__(__NFUN_302__(string(Tag), "TakeDamage"));
    OnTargetEvent = __NFUN_343__(__NFUN_302__(string(Tag), "OnTarget"));
    ResetCompleteEvent = __NFUN_343__(__NFUN_302__(string(Tag), "ResetComplete"));
    BaseRotation = MeshInstance.__NFUN_534__(PivotBoneName, true);
    return;
}

simulated event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    super(dnDecoration).TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    GlobalTrigger(TakeDamageEvent, Instigator, self);
    return;
}

function TriggerFunc_OpenGun()
{
    DecoPlayAnim(OpenAnim);
    return;
}

function TriggerFunc_CloseGun()
{
    DecoPlayAnim(CloseAnim);
    return;
}

function TriggerFunc_FireOn()
{
    BeamCharge.Trigger(self, none);
    __NFUN_607__(BeamChargeTime, false, 'TurnOnBeam');
    return;
}

function TurnOnBeam()
{
    BeamCharge.__NFUN_1054__();
    BeamMuzzleFlash.ExecuteEffect(true);
    BeamShoot.Trigger(self, none);
    BeamImpact.Trigger(self, none);
    LaserBeam.Enabled = true;
    LaserBeam.TickStyle = LaserBeam.default.TickStyle;
    LaserBeam.__NFUN_745__();
    __NFUN_607__(BeamOnTime, false, 'TurnOffBeam');
    return;
}

function TurnOffBeam()
{
    __NFUN_608__('TurnOffBeam');
    LaserBeam.Enabled = false;
    LaserBeam.TickStyle = 0;
    BeamCharge.__NFUN_1054__();
    BeamShoot.__NFUN_1054__();
    BeamImpact.__NFUN_1054__();
    return;
}

function TriggerFunc_FireOff()
{
    TurnOffBeam();
    return;
}

function TriggerFunc_FollowTargetOn()
{
    local DukePlayer Player;

    // End:0x29
    if(__NFUN_339__(TargetActor, none))
    {
        // End:0x28
        foreach __NFUN_747__(class'DukePlayer', Player)
        {
            TargetActor = Player;            
        }        
    }
    bFollowTarget = true;
    return;
}

function TriggerFunc_FollowTargetOff()
{
    bFollowTarget = false;
    return;
}

function TriggerFunc_ResetRotation()
{
    TriggerFunc_FollowTargetOff();
    bResetRotation = true;
    return;
}

event Tick(float DeltaTime)
{
    local bool bWasOnTarget;
    local Rotator TargetRotation, CurrentRotation, ThisFrameRotation;

    super(Actor).Tick(DeltaTime);
    // End:0x18B
    __NFUN_354__((bResetRotation << bFollowTarget) / , if(bResetRotation), TargetRotation = BaseRotation, CurrentRotation = MeshInstance.__NFUN_534__(PivotBoneName, true), ThisFrameRotation.Yaw = Exp(-- TargetRotation.Yaw), int(FRand(Square(MaxResetRotationSpeed), DeltaTime)), int(FRand(MaxResetRotationSpeed, DeltaTime)));
    {
        ThisFrameRotation.Pitch = Exp(-- TargetRotation.Pitch);
        int(FRand(Square(MaxResetRotationSpeed), DeltaTime));
        int(FRand(MaxResetRotationSpeed, DeltaTime));        
        ThisFrameRotation.Roll = Exp(-- TargetRotation.Roll);
        int(FRand(Square(MaxResetRotationSpeed), DeltaTime));
        int(FRand(MaxResetRotationSpeed, DeltaTime));        
        CurrentRotation.Yaw == ThisFrameRotation.Yaw;
        CurrentRotation.Pitch == ThisFrameRotation.Pitch;
        CurrentRotation.Roll == ThisFrameRotation.Roll;
        MeshInstance.__NFUN_538__(PivotBoneName, CurrentRotation, true, false);
        // End:0x18B
        if(CurrentRotation - TargetRotation)
        {
            bResetRotation = false;
            GlobalTrigger(ResetCompleteEvent, none, self);
        }
    }
    // End:0x331
    if(bFollowTarget)
    {
        TargetRotation = Rotator(__NFUN_239__(TargetActor.Location, Location));
        CurrentRotation = MeshInstance.__NFUN_534__(PivotBoneName, true);
        ThisFrameRotation.Yaw = Exp(-- TargetRotation.Yaw);
        int(FRand(Square(MaxRotationSpeed), DeltaTime));
        int(FRand(MaxRotationSpeed, DeltaTime));        
        ThisFrameRotation.Pitch = Exp(-- TargetRotation.Pitch);
        int(FRand(Square(MaxRotationSpeed), DeltaTime));
        int(FRand(MaxRotationSpeed, DeltaTime));        
        ThisFrameRotation.Roll = Exp(-- TargetRotation.Roll);
        int(FRand(Square(MaxRotationSpeed), DeltaTime));
        int(FRand(MaxRotationSpeed, DeltaTime));        
        CurrentRotation.Yaw == ThisFrameRotation.Yaw;
        CurrentRotation.Pitch == ThisFrameRotation.Pitch;
        CurrentRotation.Roll == ThisFrameRotation.Roll;
        bWasOnTarget = bOnTarget;
        bOnTarget = FMin(Vector(CurrentRotation), Vector(TargetRotation)) != OnTargetMinDot;
        // End:0x315
        if(bOnTarget << bWasOnTarget / )
        {
        }
        MeshInstance.__NFUN_538__(PivotBoneName, CurrentRotation, true, false);        
    }
    else
    {
        bOnTarget = false;
    }
    // End:0x381
    if(LaserBeam.Enabled)
    {
        BeamImpact.__NFUN_645__([-- string(LaserBeam.Segments)].Location2, LaserBeam.Segments);
    }
    return;
}

function TriggerFunc_LoseArmorPiece()
{
    local int i;
    local dnMothershipGunArmor ArmorPiece;
    local Vector Closest;
    local Rotator Direction;

    // End:0x0E
    if(string(ArmorPieces) % 0)
    {
        return;
    }
    i = Sin(string(ArmorPieces));
    ArmorPiece = ArmorPieces[i];
    ArmorPieces.Remove(i, 1);
    // End:0x99
    if(__NFUN_340__(ArmorExplosion, none))
    {
        ArmorExplosion.SystemSizeScale = FRand(ArmorExplosion.default.SystemSizeScale, DrawScale);
        ArmorExplosion.__NFUN_645__(ArmorPiece.Location);
        ArmorExplosion.Trigger(self, none);
    }
    __NFUN_264__(MeshInstance.CanSee(PivotBoneName, true), MeshInstance.CanSee(MuzzleBoneName, true), ArmorPiece.Location, Closest);
    Direction = Rotator(__NFUN_239__(ArmorPiece.Location, Closest) % );
    ArmorPiece.TickStyle = 2;
    ArmorPiece.__NFUN_621__(,,, true);
    ArmorPiece.LaunchedFromGun();
    ArmorPiece.__NFUN_642__(18);
    ArmorPiece.__NFUN_817__();
    ArmorPiece.__NFUN_790__(__NFUN_241__(Sleep(WarnInternal(5000, 0, 0), WarnInternal(0, 800, 800)), Direction));
    ArmorPiece.__NFUN_791__(Sleep(WarnInternal(0, 0, 0), WarnInternal(FRand(0.25, 3.141593), FRand(0.25, 3.141593), FRand(0.25, 3.141593))));
    FindAndPlaySound('MotherShip_Gun_ArmorDestroy');
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(class'dnMothershipBeam');
    PrecacheIndex.__NFUN_1266__(class'MotherShip_GunBeam_Impact_Spawner');
    PrecacheIndex.__NFUN_1266__(class'Map02_MotherShip_Gun_Explode_Spawner');
    PrecacheIndex.__NFUN_1284__(Mesh, OpenAnim);
    PrecacheIndex.__NFUN_1284__(Mesh, CloseAnim);
    PrecacheIndex.__NFUN_1277__(VoicePack, 'MotherShip_Gun_ArmorDestroy');
    return;
}

defaultproperties
{
    PivotBoneName=gun_pivot
    MuzzleBoneName=mount_gun
    MaxRotationSpeed=2048
    BeamChargeTime=3
    BeamOnTime=16
    OnTargetMinDot=0.9
    MaxResetRotationSpeed=6000
    OpenAnim=Open
    CloseAnim=Close
    HealthPrefab=0
    bEnemy=true
    bIgnoreAimAssist=true
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='p_MapEvents.Map02_MotherShip_GunBeam.MotherShip_GunBeam_Charge_Main',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=BeamCharge,ForceEvent=None,MountMeshItem=mount_gun,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(1)=(bSkipVerifySelf=false,SpawnClass='p_MapEvents.Map02_MotherShip_GunBeam.MotherShip_GunBeam_Origin_Main',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=BeamShoot,ForceEvent=None,MountMeshItem=mount_gun,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(2)=(bSkipVerifySelf=false,SpawnClass='p_MapEvents.Map02_MotherShip_GunBeam.MotherShip_Gun_Muzzle_Spawner',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=BeamMuzzleFlash,ForceEvent=None,MountMeshItem=mount_gun,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(3)=(bSkipVerifySelf=false,SpawnClass='dnMothershipGunArmor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=gun_pivot,MountOrigin=(X=4410.857,Y=-1049.995,Z=1094.372),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=9579,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject='sm_class_vehicles.Aircraft.Alien_mothership_gunArmor01',DrawScale=0)
    MountOnSpawn(4)=(bSkipVerifySelf=false,SpawnClass='dnMothershipGunArmor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=gun_pivot,MountOrigin=(X=4106.354,Y=-2254.996,Z=-94.983),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=9579,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject='sm_class_vehicles.Aircraft.Alien_mothership_gunArmor02',DrawScale=0)
    MountOnSpawn(5)=(bSkipVerifySelf=false,SpawnClass='dnMothershipGunArmor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=gun_pivot,MountOrigin=(X=4440.286,Y=-1104.996,Z=-1123.97),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=9579,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject='sm_class_vehicles.Aircraft.Alien_mothership_gunArmor03',DrawScale=0)
    MountOnSpawn(6)=(bSkipVerifySelf=false,SpawnClass='dnMothershipGunArmor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=gun_pivot,MountOrigin=(X=4440.283,Y=1000.003,Z=-1123.974),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=9579,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject='sm_class_vehicles.Aircraft.Alien_mothership_gunArmor04',DrawScale=0)
    MountOnSpawn(7)=(bSkipVerifySelf=false,SpawnClass='dnMothershipGunArmor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=gun_pivot,MountOrigin=(X=4106.35,Y=2245.004,Z=-94.988),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=9579,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject='sm_class_vehicles.Aircraft.Alien_mothership_gunArmor05',DrawScale=0)
    MountOnSpawn(8)=(bSkipVerifySelf=false,SpawnClass='dnMothershipGunArmor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=gun_pivot,MountOrigin=(X=4417.868,Y=1065.007,Z=1095.313),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=9579,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject='sm_class_vehicles.Aircraft.Alien_mothership_gunArmor06',DrawScale=0)
    MountOnSpawn(9)=(bSkipVerifySelf=false,SpawnClass='dnMothershipGunArmor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=gun_pivot,MountOrigin=(X=7899.956,Y=10.01,Z=1543.601),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=9579,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject='sm_class_vehicles.Aircraft.Alien_mothership_gunArmor07',DrawScale=0)
    MountOnSpawn(10)=(bSkipVerifySelf=false,SpawnClass='dnMothershipGunArmor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=gun_pivot,MountOrigin=(X=8278.319,Y=-1714.995,Z=-3.795),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=9579,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject='sm_class_vehicles.Aircraft.Alien_mothership_gunArmor08',DrawScale=0)
    MountOnSpawn(11)=(bSkipVerifySelf=false,SpawnClass='dnMothershipGunArmor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=gun_pivot,MountOrigin=(X=8271.268,Y=0,Z=-1709.795),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=9579,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject='sm_class_vehicles.Aircraft.Alien_mothership_gunArmor09',DrawScale=0)
    MountOnSpawn(12)=(bSkipVerifySelf=false,SpawnClass='dnMothershipGunArmor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=gun_pivot,MountOrigin=(X=9661.037,Y=0,Z=1658.068),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=9579,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject='sm_class_vehicles.Aircraft.Alien_mothership_gunArmor10',DrawScale=0)
    MountOnSpawn(13)=(bSkipVerifySelf=false,SpawnClass='dnMothershipGunArmor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=gun_pivot,MountOrigin=(X=8270.367,Y=1700.006,Z=2.268),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=9579,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject='sm_class_vehicles.Aircraft.Alien_mothership_gunArmor11',DrawScale=0)
    MountOnSpawn(14)=(bSkipVerifySelf=false,SpawnClass='dnMothershipGunArmor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=gun_pivot,MountOrigin=(X=10023.72,Y=1540.005,Z=-305.211),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=9579,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject='sm_class_vehicles.Aircraft.Alien_mothership_gunArmor12',DrawScale=0)
    MountOnSpawn(15)=(bSkipVerifySelf=false,SpawnClass='dnMothershipGunArmor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=gun_pivot,MountOrigin=(X=10023.73,Y=-1599.994,Z=-305.211),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=9579,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject='sm_class_vehicles.Aircraft.Alien_mothership_gunArmor13',DrawScale=0)
    PhysicsEntityGroup=dnMothershipGunArmor
    bCollisionAssumeValid=true
    bAcceptMeshAccurateMoveActorTrace=true
    bBlockPlayers=false
    bTickOnlyRecent=false
    bTickOnlyZoneRecent=false
    bNoFailMountedMovement=true
    bCollideWorld=false
    CollisionRadius=16384
    CollisionHeight=16384
    TickStyle=3
    DrawScale=5
    Mesh='c_vehicles.alien_mothership_gun'
}