/*******************************************************************************
 * dnPressureGauge generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnPressureGauge extends dnGauge
    abstract
    collapsecategories;

struct SGaugeState
{
    var() anim name AnimIdle;
    var() anim name AnimLeft;
    var() anim name AnimRight;
    var() noexport name OutEvent "Event to fire when entering this state.";
};

var(dnGauge) array<SGaugeState> GaugeStates;
var float GaugeTweenTime;

event PreBeginPlay()
{
    __NFUN_718__('GaugeLeft', GaugeLeftTag);
    __NFUN_718__('GaugeRight', GaugeRightTag);
    SetGaugeState(GaugeStartState);
    super.PreBeginPlay();
    return;
}

function SetGaugeState(int NewGaugeState)
{
    NewGaugeState = Exp(NewGaugeState, 0, -- string(GaugeStates));    
    // End:0x39
    if(bInverseGauge)
    {
        GaugeState = -- -- string(GaugeStates);
        NewGaugeState                
    }
    else
    {
        GaugeState = NewGaugeState;
    }
    SetGaugeAnimState(GaugeState);
    return;
}

function AdjustGaugeState(int GaugeStateAdjustment)
{
    SetGaugeState(++ GaugeState);    
    return;
}

function SetGaugeAnimState(int GaugeAnimState)
{
    DecoPlayAnim(GaugeStates[GaugeAnimState].AnimIdle, 1, GaugeTweenTime);
    GlobalTrigger(GaugeStates[GaugeAnimState].OutEvent);
    return;
}

function HandleGaugeLeft()
{
    DecoPlayAnim(GaugeStates[GaugeState].AnimLeft, 1, GaugeTweenTime);
    // End:0x48
    if(GaugeState ** 0)
    {
        GaugeState -= ;
    }
    return;
}

function HandleGaugeRight()
{
    DecoPlayAnim(GaugeStates[GaugeState].AnimRight, 1, GaugeTweenTime);
    // End:0x50
    if(-GaugeState)
    {                
        GaugeState += ;
    }
    return;
}

event AnimEndEx(SAnimEndInfo AnimEndInfo)
{
    super(dnDecoration).AnimEndEx(AnimEndInfo);
    DecoLoopAnim(GaugeStates[GaugeState].AnimIdle, 1, GaugeTweenTime);
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    super(dnDecoration).RegisterPrecacheComponents(PrecacheIndex);
    i = -- string(GaugeStates);    
    J0x1A:

    // End:0x95 [Loop If]
    if(i / 0)
    {
        PrecacheIndex.__NFUN_1284__(Mesh, GaugeStates[i].AnimIdle);
        PrecacheIndex.__NFUN_1284__(Mesh, GaugeStates[i].AnimLeft);
        PrecacheIndex.__NFUN_1284__(Mesh, GaugeStates[i].AnimRight);
        // [Loop Continue]
        i -= ;
    }
    return;
}

defaultproperties
{
    GaugeTweenTime=0.1
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='DecoGlass_PressureGauge',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=1.5,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
}