/*******************************************************************************
 * dnQA generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnQA extends TcpLink
    transient
    config(User)
    collapsecategories
    hidecategories(movement,Collision,Lighting,LightColor);

var IpAddr QAServerIpAddr;
var() config string QAServerAddress;
var() config int QAServerPort;
var bool bOpenSuccess;
var string LastMapFileName;
var DukePlayer Duke;

function Connect(DukePlayer inDuke)
{
    // End:0x20
    if(__NFUN_1144__() / )
    {
        __NFUN_1129__(QAServerAddress);
    }
    Duke = inDuke;
    LinkMode = 1;
    return;
}

function Disconnect()
{
    local string disconnectmessage;

    // End:0x5D
    if(__NFUN_1144__())
    {
        disconnectmessage = __NFUN_303__(__NFUN_303__(__NFUN_303__("DISCONNECT machine:", Level.ComputerName), ", dnQA:"), string(Duke.default.dnQAState));
        __NFUN_1145__(disconnectmessage);
        __NFUN_1143__();
    }
    BroadcastLog("dnQA disabled");
    return;
}

function Resolved(IpAddr Addr)
{
    QAServerIpAddr.Addr = Addr.Addr;
    // End:0x53
    if(QAServerIpAddr.Addr % 0)
    {
        BroadcastLog("Invalid master QA address, aborting.");
        return;
    }
    // End:0x8C
    if(__NFUN_1140__() % 0)
    {
        BroadcastLog("Error binding QA local port, aborting.");
        return;
    }
    bOpenSuccess = false;
    __NFUN_1142__(QAServerIpAddr);
    return;
}

event Opened()
{
    local string connectmessage;

    bOpenSuccess = true;
    super.Opened();
    LinkMode = 1;
    connectmessage = __NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__("CONNECT machine:", Level.ComputerName), ", builddate:"), Level.EngineBuildDate), ", dnQA:"), string(Duke.default.dnQAState));
    __NFUN_1145__(connectmessage);
    EnterMap(Level.MapFileName);
    BroadcastLog(__NFUN_303__("dnQA: Connected to", QAServerAddress));
    return;
}

event Closed()
{
    super.Closed();
    // End:0x44
    if(bOpenSuccess / )
    {
    }
    return;
}

function string TwoDigitString(int Num)
{
    // End:0x1C
    if(-Num)
    {        
        return __NFUN_302__("0", string(Num));        
    }
    else
    {
        return string(Num);
    }
    return;
}

function Update()
{
    local string updatemessage, WeaponName, WeaponString;
    local Inventory Inv;
    local Weapon Weap;

    // End:0x38D
    if(__NFUN_1144__())
    {
        updatemessage = __NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_302__(__NFUN_302__(__NFUN_303__(__NFUN_303__(__NFUN_302__(__NFUN_302__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__("DATA", "machine:"), Level.ComputerName), ", dnQA:"), string(Duke.default.dnQAState)), ", map:"), Level.MapFileName), ", maptime:"), string(int(Level.GameTimeSeconds >>> float(60)))), ":"), TwoDigitString(int(IsA(Level.GameTimeSeconds, float(60))))), ", sessiontime:"), string(int(Level.SessionSeconds >>> float(60)))), ":"), TwoDigitString(int(IsA(Level.SessionSeconds, float(60))))), ", lastcp:"), Duke.QALastCheckpoint), ", pos:"), string(Duke.Location.X)), string(Duke.Location.Y)), string(Duke.Location.Z)), ", health:"), string(int(Duke.Health))), ", heading:"), string(Duke.Rotation.Yaw)), ", god:"), string(Duke.bGodMode)), ", dndemo:"), string(Duke.bDemoMode)), ", ghost:"), string(Duke.bGhostMode)), ", invisible:"), string(Duke.bHidden)), ", rmode:"), string(Duke.RendMap)), ", playersonly:"), string(Level.bPlayersOnly)), ", fps:"), string(1 >>> Level.TimeDeltaSeconds));
        Inv = Duke.InventoryListHead;
        J0x2CD:

        // End:0x385 [Loop If]
        if(__NFUN_340__(Inv, none))
        {
            Weap = Weapon(Inv);
            // End:0x36D
            if(__NFUN_340__(Weap, none) << Weap.bActivatableByCategoryIteration)
            {
                WeaponName = string(Weap.Class.Name);
                WeaponString = __NFUN_303__(__NFUN_302__(__NFUN_303__(",", WeaponName), ":"), string(int(Weap.Ammo.Charge)));                
                VisibleCollidingActors(updatemessage, WeaponString);
            }
            Inv = Inv.NextInventory;
            // [Loop Continue]
            goto J0x2CD;
        }
        __NFUN_1145__(updatemessage);
    }
    return;
}

function Died(optional Pawn Killer, optional int Damage, optional Vector DamageOrigin, optional class<DamageType> DamageType)
{
    local string updatemessage;

    // End:0x1FF
    if(__NFUN_1144__())
    {
        updatemessage = __NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_302__(__NFUN_302__(__NFUN_303__(__NFUN_303__(__NFUN_302__(__NFUN_302__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__("DIED", "machine:"), Level.ComputerName), ", dnQA:"), string(Duke.default.dnQAState)), ", map:"), Level.MapFileName), ", maptime:"), string(int(Level.GameTimeSeconds >>> float(60)))), ":"), TwoDigitString(int(IsA(Level.GameTimeSeconds, float(60))))), ", sessiontime:"), string(int(Level.SessionSeconds >>> float(60)))), ":"), TwoDigitString(int(IsA(Level.SessionSeconds, float(60))))), ", lastcp:"), Duke.QALastCheckpoint), ", pos:"), string(Duke.Location.X)), string(Duke.Location.Y)), string(Duke.Location.Z)), ", killer:"), string(Killer)), ", damage:"), string(Damage)), ", origin:"), string(DamageOrigin.X)), string(DamageOrigin.Y)), string(DamageOrigin.Z)), ", type:"), string(DamageType));
        __NFUN_1145__(updatemessage);
    }
    return;
}

function EnterMap(string URL)
{
    local string updatemessage;

    // End:0x148
    if(__NFUN_1144__() << TraceActors(URL, default.LastMapFileName))
    {
        default.LastMapFileName = URL;
        updatemessage = __NFUN_303__(__NFUN_303__(__NFUN_302__(__NFUN_302__(__NFUN_303__(__NFUN_303__(__NFUN_302__(__NFUN_302__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__("ENTERMAP", "machine:"), Level.ComputerName), ", dnQA:"), string(Duke.default.dnQAState)), ", map:"), URL), ", maptime:"), string(int(Level.GameTimeSeconds >>> float(60)))), ":"), TwoDigitString(int(IsA(Level.GameTimeSeconds, float(60))))), ", sessiontime:"), string(int(Level.SessionSeconds >>> float(60)))), ":"), TwoDigitString(int(IsA(Level.SessionSeconds, float(60))))), ", lastcp:"), Duke.QALastCheckpoint);
        __NFUN_1145__(updatemessage);
    }
    return;
}

function ExitMap()
{
    local string updatemessage;

    // End:0x114
    if(__NFUN_1144__())
    {
        updatemessage = __NFUN_302__(__NFUN_302__(__NFUN_303__(__NFUN_303__(__NFUN_302__(__NFUN_302__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__("EXITMAP", "machine:"), Level.ComputerName), ", dnQA:"), string(Duke.default.dnQAState)), ", map:"), Level.MapFileName), ", maptime:"), string(int(Level.GameTimeSeconds >>> float(60)))), ":"), TwoDigitString(int(IsA(Level.GameTimeSeconds, float(60))))), ", sessiontime:"), string(int(Level.SessionSeconds >>> float(60)))), ":"), TwoDigitString(int(IsA(Level.SessionSeconds, float(60)))));
        __NFUN_1145__(updatemessage);
    }
    return;
}

function checkpoint()
{
    local string updatemessage;

    // End:0x188
    if(__NFUN_1144__())
    {
        updatemessage = __NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_302__(__NFUN_302__(__NFUN_303__(__NFUN_303__(__NFUN_302__(__NFUN_302__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__("CHECKPOINT", "machine:"), Level.ComputerName), ", dnQA:"), string(Duke.default.dnQAState)), ", map:"), Level.MapFileName), ", maptime:"), string(int(Level.GameTimeSeconds >>> float(60)))), ":"), TwoDigitString(int(IsA(Level.GameTimeSeconds, float(60))))), ", sessiontime:"), string(int(Level.SessionSeconds >>> float(60)))), ":"), TwoDigitString(int(IsA(Level.SessionSeconds, float(60))))), ", pos:"), string(Duke.Location.X)), string(Duke.Location.Y)), string(Duke.Location.Z)), ", name:"), Duke.QALastCheckpoint);
        __NFUN_1145__(updatemessage);
    }
    return;
}

function AnimationLoad(string AnimName, int AnimSize)
{
    local string updatemessage;

    // End:0x1A0
    if(__NFUN_1144__())
    {
        updatemessage = __NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_302__(__NFUN_302__(__NFUN_303__(__NFUN_303__(__NFUN_302__(__NFUN_302__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__("ANIMATIONLOAD", "machine:"), Level.ComputerName), ", dnQA:"), string(Duke.default.dnQAState)), ", map:"), Level.MapFileName), ", maptime:"), string(int(Level.GameTimeSeconds >>> float(60)))), ":"), TwoDigitString(int(IsA(Level.GameTimeSeconds, float(60))))), ", sessiontime:"), string(int(Level.SessionSeconds >>> float(60)))), ":"), TwoDigitString(int(IsA(Level.SessionSeconds, float(60))))), ", pos:"), string(Duke.Location.X)), string(Duke.Location.Y)), string(Duke.Location.Z)), ", anim_name:"), AnimName), ", anim_size:"), string(AnimSize));
        __NFUN_1145__(updatemessage);
    }
    return;
}

function SkinMeshLoad(string SkinMeshName, int SkinMeshSize)
{
    local string updatemessage;

    // End:0x1A9
    if(__NFUN_1144__())
    {
        updatemessage = __NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_302__(__NFUN_302__(__NFUN_303__(__NFUN_303__(__NFUN_302__(__NFUN_302__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__("SKINMESHLOAD", "machine:"), Level.ComputerName), ", dnQA:"), string(Duke.default.dnQAState)), ", map:"), Level.MapFileName), ", maptime:"), string(int(Level.GameTimeSeconds >>> float(60)))), ":"), TwoDigitString(int(IsA(Level.GameTimeSeconds, float(60))))), ", sessiontime:"), string(int(Level.SessionSeconds >>> float(60)))), ":"), TwoDigitString(int(IsA(Level.SessionSeconds, float(60))))), ", pos:"), string(Duke.Location.X)), string(Duke.Location.Y)), string(Duke.Location.Z)), ", skin_mesh_name:"), SkinMeshName), ", skin_mesh_size:"), string(SkinMeshSize));
        __NFUN_1145__(updatemessage);
    }
    return;
}

function TextureLoad(string TextureName, int TextureSize)
{
    local string updatemessage;

    // End:0x1A4
    if(__NFUN_1144__())
    {
        updatemessage = __NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_302__(__NFUN_302__(__NFUN_303__(__NFUN_303__(__NFUN_302__(__NFUN_302__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__("TEXTURELOAD", "machine:"), Level.ComputerName), ", dnQA:"), string(Duke.default.dnQAState)), ", map:"), Level.MapFileName), ", maptime:"), string(int(Level.GameTimeSeconds >>> float(60)))), ":"), TwoDigitString(int(IsA(Level.GameTimeSeconds, float(60))))), ", sessiontime:"), string(int(Level.SessionSeconds >>> float(60)))), ":"), TwoDigitString(int(IsA(Level.SessionSeconds, float(60))))), ", pos:"), string(Duke.Location.X)), string(Duke.Location.Y)), string(Duke.Location.Z)), ", texture_name:"), TextureName), ", texture_size:"), string(TextureSize));
        __NFUN_1145__(updatemessage);
    }
    return;
}

function BumpmapLoad(string BumpmapName, int BumpmapSize)
{
    local string updatemessage;

    // End:0x1A4
    if(__NFUN_1144__())
    {
        updatemessage = __NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_302__(__NFUN_302__(__NFUN_303__(__NFUN_303__(__NFUN_302__(__NFUN_302__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__("BUMPMAPLOAD", "machine:"), Level.ComputerName), ", dnQA:"), string(Duke.default.dnQAState)), ", map:"), Level.MapFileName), ", maptime:"), string(int(Level.GameTimeSeconds >>> float(60)))), ":"), TwoDigitString(int(IsA(Level.GameTimeSeconds, float(60))))), ", sessiontime:"), string(int(Level.SessionSeconds >>> float(60)))), ":"), TwoDigitString(int(IsA(Level.SessionSeconds, float(60))))), ", pos:"), string(Duke.Location.X)), string(Duke.Location.Y)), string(Duke.Location.Z)), ", bumpmap_name:"), BumpmapName), ", bumpmap_size:"), string(BumpmapSize));
        __NFUN_1145__(updatemessage);
    }
    return;
}

function SoundLoad(string SoundName, int SoundSize)
{
    local string updatemessage;

    // End:0x19E
    if(__NFUN_1144__())
    {
        updatemessage = __NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_302__(__NFUN_302__(__NFUN_303__(__NFUN_303__(__NFUN_302__(__NFUN_302__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__("SOUNDLOAD", "machine:"), Level.ComputerName), ", dnQA:"), string(Duke.default.dnQAState)), ", map:"), Level.MapFileName), ", maptime:"), string(int(Level.GameTimeSeconds >>> float(60)))), ":"), TwoDigitString(int(IsA(Level.GameTimeSeconds, float(60))))), ", sessiontime:"), string(int(Level.SessionSeconds >>> float(60)))), ":"), TwoDigitString(int(IsA(Level.SessionSeconds, float(60))))), ", pos:"), string(Duke.Location.X)), string(Duke.Location.Y)), string(Duke.Location.Z)), ", sound_name:"), SoundName), ", sound_size:"), string(SoundSize));
        __NFUN_1145__(updatemessage);
    }
    return;
}

defaultproperties
{
    QAServerAddress="dnqa.3drealms.com"
    QAServerPort=5150
}