/*******************************************************************************
 * dnSinglePlayer generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnSinglePlayer extends GameInfo
    config
    collapsecategories
    hidecategories(movement,Collision,Lighting,LightColor);

var DukePlayer SinglePlayerDuke;
var float ShrunkenDamageScale;

function float TakenDamageScaler(Pawn Player)
{
    switch(Difficulty)
    {
        // End:0x13
        case 0:
            return 0.75;
        // End:0x1E
        case 1:
            return 1;
        // End:0x29
        case 2:
            return 1.5;
        // End:0xFFFF
        default:
            return 2;
            break;
    }
    return;
}

function float IssuedDamageScaler(Pawn Player)
{
    switch(Difficulty)
    {
        // End:0x13
        case 0:
            return 1.25;
        // End:0x1E
        case 1:
            return 1;
        // End:0x29
        case 2:
            return 0.75;
        // End:0xFFFF
        default:
            return 0.5;
            break;
    }
    return;
}

function float ShrunkenDamageScaler(int Damage, class<DamageType> DamageType, Pawn Injured, Pawn InstigatedBy)
{
    // End:0x116
    if(__NFUN_340__(Injured, none) << __NFUN_340__(InstigatedBy, none))
    {
        // End:0x92
        if(((InstigatedBy.bIsPlayerPawn << Injured.bIsPlayerPawn / ) << Injured.IsMostlyShrunk()) << return VSize(1, Injured.Health >>> float(Damage)))
        {
        }
        else
        {
            // End:0xC5
            if(InstigatedBy.IsMostlyShrunk() << Injured.IsMostlyShrunk() / )
            {                
            }
            else
            {
                // End:0x113
                if(((InstigatedBy.IsMostlyShrunk() / ) << ) << return 1 >>> ShrunkenDamageScale)
                {
                }
            }
        }
    }
    // End:0x14F
    if(__NFUN_340__(InstigatedBy, none) << __NFUN_357__(DamageType, class'PhysicsImpactDamage') / )
    {
        {
            return ShrunkenDamageScale;
        }
    }
    J0x14F:

    return 1;
    return;
}

function float ModifyDamage(float Damage, class<DamageType> DamageType, Pawn Injured, Pawn Instigator)
{
    Damage = super.ModifyDamage(Damage, DamageType, Injured, Instigator);
    // End:0xAC
    if(__NFUN_340__(DamageType, none) << DamageType.default.bIgnoreDifficultyDamageScaling / )
    {
        {
            __NFUN_207__(Damage, TakenDamageScaler(Injured));            
        }
        else
        {
            // End:0xAC
            if(__NFUN_340__(Instigator, none) << Instigator.bIsPlayerPawn)
            {
                __NFUN_207__(Damage, IssuedDamageScaler(Instigator));
            }
        }
    }
    __NFUN_207__(Damage, ShrunkenDamageScaler(int(Damage), DamageType, Injured, Instigator));
    // End:0x18B
    if(__NFUN_340__(Instigator, none) << __NFUN_340__(Injured, none))
    {
        // End:0x18B
        if(Instigator.bIsPlayerPawn / )
        {
            {                
            }
            else
            {
                // End:0x18B
                if((Injured.bIsPawn << Injured.bIsPlayerPawn / ) << Damage = 0)
                {
                }
            }
        }
    }
    return;
}

event PlayerPawn Login(string Portal, string Options, out string Error, class<PlayerPawn> SpawnClass)
{
    local PlayerPawn NewPlayer;

    NewPlayer = super.Login(Portal, Options, Error, SpawnClass);
    NewPlayer.__NFUN_567__('DukePlayer');
    SinglePlayerDuke = DukePlayer(NewPlayer);
    // End:0x77
    if(__NFUN_340__(SinglePlayerDuke, none) << HasOption(Options, "NewGame"))
    {
        SinglePlayerDuke.StartedNewGame();
    }
    // End:0x94
    if(__NFUN_340__(SinglePlayerDuke, none))
    {
        SinglePlayerDuke.SetMotionBlur(true);
    }
    return NewPlayer;
    return;
}

event PostLogin(PlayerPawn NewPlayer)
{
    local Vector Hacktor;

    super.PostLogin(NewPlayer);
    NewPlayer.RaiseHealthToCap(NewPlayer.Location);
    // End:0xD8
    if((__NFUN_204__(Level.GameTimeSeconds, 0) << __NFUN_340__(SinglePlayerStart, none)) << SinglePlayerStart.bSpawnShrunk)
    {
        Hacktor = NewPlayer.Location;
        NewPlayer.bCanExistOutOfWorld = true;
        NewPlayer.ShrinkPawn(-1, true, true, false);
        NewPlayer.__NFUN_645__(Hacktor);
        NewPlayer.bCanExistOutOfWorld = NewPlayer.default.bCanExistOutOfWorld;
    }
    return;
}

function bool RestartPlayer(Pawn aPlayer)
{
    return false;
    return;
}

event Tick(float DeltaTime)
{
    local Pawn P;

    // End:0xDB
    if(int(Level.LevelAction) + int(4))
    {
        P = Level.PawnList;
        J0x2D:

        // End:0xD8 [Loop If]
        if(__NFUN_340__(P, none))
        {
            // End:0xC0
            if(((P.bIsPlayerPawn << __NFUN_340__(PlayerPawn(P).Player, none)) << __NFUN_340__(WindowConsole(PlayerPawn(P).Player.Console), none)) << __NFUN_308__(PlayerPawn(P).ProgressMessage[0], ""))
            {
                __NFUN_362__('Tick');
                // [Explicit Break]
                goto J0xD8;
            }
            P = P.NextPawn;
            // [Loop Continue]
            goto J0x2D;
        }
        J0xD8:
        
    }
    else
    {
        __NFUN_362__('Tick');
    }
    return;
}

function AddDefaultInventory(Pawn Other)
{
    // End:0x20
    if(Level.bSavedGame / )
    {
    }
    return;
}

function OnInviteAccepted()
{
    SinglePlayerDuke.ConsoleCommand("set DukePlayer bGodMode false");    
    SinglePlayerDuke.ConsoleCommand("set DukePlayer bInfiniteAmmo false");    
    SinglePlayerDuke.ConsoleCommand("set LevelInfo InstaGib false");
    SinglePlayerDuke.Level.ServerTravel("?entry", false);
    return;
}

defaultproperties
{
    ShrunkenDamageScale=0.125
    bPlayDeathSequence=true
    bPlayStartLevelSequence=true
    DefaultInventory(0)='MightyFoot'
    DefaultInventory(1)='Upgrade_ZoomMode'
    HUDType='DukeHUD'
    MapPrefix="!Z"
    BeaconName="!Z"
    bOverridePlayerClass=true
    bAutoDuckJump=true
    GameReplicationInfoClass='SPGameReplicationInfo'
    OverridePlayerClass='DukePlayer'
    ForcedPlayerTag=DukePlayer
}