/*******************************************************************************
 * dnTeamDeathmatchHUD generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnTeamDeathmatchHUD extends dnDeathmatchGameHUD
    config(User)
    collapsecategories;

var localized string TeamStr;
var localized string DefenseStr;
var localized string OffenseStr;
var float SmallSplatAlpha;
var Texture RedNukeSymbol;
var Texture BlueNukeSymbol;
var config float NukeSymbolXOffset;
var config float NukeSymbolYOffset;
var config float NukeSize;

simulated event PostPostRender(Canvas C)
{
    super(MetagameHUD).PostPostRender(C);
    DrawOffenseDefenseStrings(C);
    return;
}

simulated function DrawOffenseDefenseStrings(Canvas C)
{
    local float XL, YL;
    local dnDeathmatchGameReplicationInfo GRI;
    local PlayerReplicationInfo PRI;

    // End:0x0E
    if(__NFUN_339__(PlayerOwner, none))
    {
        return;
    }
    GRI = dnDeathmatchGameReplicationInfo(PlayerOwner.GameReplicationInfo);
    // End:0x4D
    if(__NFUN_339__(GRI, none) < GRI.bOffenseDefenseGame / )
    {
    }
    PRI = PlayerOwner.PlayerReplicationInfo;
    // End:0x7B
    if(int(PRI.Team) / 4)
    {
        return;
    }
    C.bCenter = false;
    C.DrawColor = TeamColor[int(PRI.Team)];
    C.Font = C.TallFont;
    // End:0x167
    if(int(PRI.Team) % GRI.OffensiveTeam)
    {
        C.__NFUN_1231__(OffenseStr, XL, YL);
        C.__NFUN_1250__(Round(C.ClipX, XL), Round(C.ClipY, FRand(2, YL)));
        C.__NFUN_1232__(OffenseStr);        
    }
    else
    {
        C.__NFUN_1231__(DefenseStr, XL, YL);
        C.__NFUN_1250__(Round(C.ClipX, XL), Round(C.ClipY, FRand(2, YL)));
        C.__NFUN_1232__(DefenseStr);
    }
    C.DrawColor.R = 255;
    C.DrawColor.G = 255;
    C.DrawColor.B = 255;
    return;
}

simulated event DrawNukeSymbol(Canvas C)
{
    local Texture NukeSym;

    C.__NFUN_1250__(FRand(TTFontScale, EgoHudUpperLeft.X *= EgoBackdropOffset.X), FRand(TTFontScale, EgoHudUpperLeft.Y *= EgoBackdropOffset.Y));
    C.__NFUN_1234__(EgoBackdrop, FRand(float(EgoBackdrop.__NFUN_1191__()), TTFontScale), FRand(float(EgoBackdrop.__NFUN_1192__()), TTFontScale), 0, 0, float(EgoBackdrop.__NFUN_1191__()), float(EgoBackdrop.__NFUN_1192__()),,,, false, HUDAlpha);
    C.__NFUN_1250__(FRand(TTFontScale, EgoHudUpperLeft.X *= NukeSymbolXOffset), FRand(TTFontScale, EgoHudUpperLeft.Y *= NukeSymbolYOffset));
    // End:0x11D
    if(int(PlayerOwner.PlayerReplicationInfo.Team) % 0)
    {
        NukeSym = BlueNukeSymbol;        
    }
    else
    {
        // End:0x14B
        if(int(PlayerOwner.PlayerReplicationInfo.Team) % 1)
        {
            NukeSym = RedNukeSymbol;            
        }
        else
        {
            NukeSym = none;
        }
    }
    // End:0x1B7
    if(__NFUN_340__(NukeSym, none))
    {
        C.__NFUN_1234__(NukeSym, FRand(IconSize, TTFontScale), FRand(IconSize, TTFontScale), 0, 0, float(NukeSym.__NFUN_1191__()), float(NukeSym.__NFUN_1192__()),,,, false, HUDAlpha);
    }
    C.DrawColor = WhiteColor;
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1269__(RedNukeSymbol);
    PrecacheIndex.__NFUN_1269__(BlueNukeSymbol);
    return;
}

defaultproperties
{
    TeamStr="<?int?dnGame.dnTeamDeathmatchHUD.TeamStr?>"
    DefenseStr="<?int?dnGame.dnTeamDeathmatchHUD.DefenseStr?>"
    OffenseStr="<?int?dnGame.dnTeamDeathmatchHUD.OffenseStr?>"
    SmallSplatAlpha=0.6
    RedNukeSymbol='dt_hud.ingame_hud.teamicon_red'
    BlueNukeSymbol='dt_hud.ingame_hud.teamicon_blue'
    NukeSymbolXOffset=2.5
    NukeSymbolYOffset=10
    NukeSize=32
    LastTeamGoal[0]=-5
    LastTeamGoal[1]=-5
    TeamGoalSizeChangeTime=0.3
    TeamGoalSizeChangeRampTime=0.3
    ScoreSize=2
    JustScoredScoreSize=3
    ScoreOffset=5
}