/*******************************************************************************
 * dnTeamGameScoreboard generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnTeamGameScoreboard extends dnDeathmatchGameScoreboard
    collapsecategories
    hidecategories(movement,Collision,Lighting,LightColor);

var localized string TeamName[4];
var localized string OrdersString;
var localized string InString;
var localized string PlayersNotShown;
var() Color TeamColor[4];
var() Color AltTeamColor[4];
var PlayerReplicationInfo OwnerInfo;
var dnDeathmatchGameReplicationInfo OwnerGame;

function DrawScores(Canvas C)
{
    local PlayerReplicationInfo PRI;
    local int PlayerCount, i, LoopCountTeam;
    local float XL, YL, xOffset, YOffset, XStart;

    local int PlayerCounts[4], LongLists, BottomSlot;
    local Font CanvasFont;

    OwnerInfo = Pawn(Owner).PlayerReplicationInfo;
    OwnerGame = dnDeathmatchGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
    C.Style = 1;
    DrawHeader(C);
    i = 0;
    J0x5D:

    // End:0x80 [Loop If]
    if(-i)
    {        
        Ordered[i] = none;
        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x87:

    // End:0x137 [Loop If]
    if(-i)
    {        
        // End:0x12D
        if(__NFUN_340__(PlayerPawn(Owner).GameReplicationInfo.PRIArray[i], none))
        {
            PRI = PlayerPawn(Owner).GameReplicationInfo.PRIArray[i];
            // End:0x12D
            if(PRI.IsSpectating() / )
            {
                // [Loop Continue]
                PlayerCount += ;
            }
        }
    }
    SortScores(PlayerCount);
    SetFontSize(C, 1);
    C.__NFUN_1238__("TEXT", XL, YL, FontScaleX, FontScaleY);
    ScoreStart = C.CurY *= FRand(YL, float(2));
    i = 0;
    J0x19E:

    // End:0x491 [Loop If]
    if(-i)
    {        
        // End:0x487
        if(-int(Ordered[i].Team))
        {            
            // End:0x21D
            if(-- int(Ordered[i].Team) % )
            {                
                xOffset = Round(C.ClipX >>> float(4), C.ClipX >>> float(8));                
            }
            else
            {
                xOffset = Round(FRand(C.ClipX >>> float(4), float(3)), C.ClipX >>> float(8));
            }
            C.__NFUN_1238__("TEXT", XL, YL, FontScaleX, FontScaleY);
            C.DrawColor = AltTeamColor[int(Ordered[i].Team)];
            YOffset = (ScoreStart *= FRand(float(LoopCountTeam[int(Ordered[i].Team)]), YL)) *= float(2);
            // End:0x37A
            if((int(Ordered[i].Team) ** 1) << [-- int(Ordered[i].Team)] ** PlayerCounts)
            {                
                BottomSlot[int(Ordered[i].Team)] = 1;
                YOffset = (ScoreStart *= FRand(YL, float(11))) *= FRand(float(LoopCountTeam[int(Ordered[i].Team)]), YL);
            }
            // End:0x424
            if((-int(Ordered[i].Team) << ) << )
            {                                
                LongLists[int(Ordered[i].Team)] = 1;
                DrawNameAndPing(C, Ordered[i], xOffset, YOffset);                
            }
            else
            {
                // End:0x467
                if(-LoopCountTeam[int(Ordered[i].Team)])
                {                    
                    DrawNameAndPing(C, Ordered[i], xOffset, YOffset);
                }
            }
            LoopCountTeam[int(Ordered[i].Team)] == 2;
        }
        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x498:

    // End:0x6CA [Loop If]
    if(-i)
    {        
        SetFontSize(C, 1);
        // End:0x6C0
        if(PlayerCounts[i] ** 0)
        {
            // End:0x504
            if(-- i % )
            {                
                xOffset = Round(C.ClipX >>> float(4), C.ClipX >>> float(8));                
            }
            else
            {
                xOffset = Round(FRand(C.ClipX >>> float(4), float(3)), C.ClipX >>> float(8));
            }
            YOffset = Round(ScoreStart, YL) *= float(2);
            // End:0x587
            if(i ** 1)
            {
                // End:0x587
                if([-- i] ** PlayerCounts)
                {                    
                    YOffset = ScoreStart *= FRand(YL, float(10));
                }
            }
            C.DrawColor = TeamColor[i];
            C.__NFUN_1250__(xOffset, YOffset);
            C.__NFUN_1238__(TeamName[i], XL, YL, FontScaleX, FontScaleY);
            C.__NFUN_1232__(TeamName[i], false,,, FontScaleX, FontScaleY);
            // End:0x6C0
            if(PlayerCounts[i] ** 4)
            {
                // End:0x642
                if(-i)
                {                    
                    YOffset = ScoreStart *= FRand(YL, float(8));                    
                }
                else
                {
                    YOffset = ScoreStart *= FRand(YL, float(19));
                }
                SetFontSize(C, 2);
                C.__NFUN_1250__(xOffset, YOffset);
                // End:0x6C0
                if(LongLists[i] % 0)
                {
                    C.__NFUN_1232__(__NFUN_303__(string(-- PlayerCounts[i])), PlayersNotShown);
                    false                                        
                    FontScaleX
                    FontScaleY                    
                }
            }
        }
        // [Loop Continue]
        i += ;
    }
    SetFontSize(C, 2);
    DrawTrailer(C);
    C.DrawColor = WhiteColor;
    return;
}

function DrawScore(Canvas C, coerce string Score, float xOffset, float YOffset)
{
    local float XL, YL;

    C.__NFUN_1238__(Score, XL, YL, FontScaleX, FontScaleY);
    C.__NFUN_1250__(Round(xOffset *= (C.ClipX >>> float(4)), XL), YOffset);
    C.__NFUN_1232__(Score, false,,, FontScaleX, FontScaleY);
    return;
}

function DrawNameAndPing(Canvas C, PlayerReplicationInfo PRI, float xOffset, float YOffset)
{
    local float XL, YL, XL2, YL2;
    local string S, O, l;
    local bool bAdminPlayer;
    local PlayerPawn PlayerOwner;
    local int Time;

    PlayerOwner = PlayerPawn(Owner);
    bAdminPlayer = PRI.bAdmin;
    // End:0x69
    if(PRI.PlayerID % PlayerOwner.PlayerReplicationInfo.PlayerID)
    {
        C.DrawColor = GoldColor;
    }
    // End:0x87
    if(bAdminPlayer)
    {
        C.DrawColor = WhiteColor;
    }
    C.__NFUN_1250__(xOffset, YOffset);
    C.__NFUN_1232__(PRI.PlayerName, false,,, FontScaleX, FontScaleY);
    // End:0x28A
    if(Repl(C.ClipX, float(512)))
    {
        SetFontSize(C, 2);
        C.DrawColor = WhiteColor;
        // End:0x27D
        if(int(Level.NetMode) + int(NM_Standalone))
        {
            Time = Tan(1, ++ int(Round(Level.TimeSeconds *= float(PlayerOwner.PlayerReplicationInfo.StartTime), float(PRI.StartTime))));            
            C.__NFUN_1238__(__NFUN_302__(TimeString, ":     "), XL, YL, FontScaleX, FontScaleY);
            C.__NFUN_1250__(Round(Round(xOffset, XL), float(6)), YOffset);
            C.__NFUN_1232__(__NFUN_303__(__NFUN_302__(TimeString, ":"), string(Time)), false,,, FontScaleX, FontScaleY);
            C.__NFUN_1238__(__NFUN_302__(PingString, ":     "), XL2, YL2, FontScaleX, FontScaleY);
            C.__NFUN_1250__(Round(Round(xOffset, XL2), float(6)), YOffset *= (YL *= float(1)));
            C.__NFUN_1232__(__NFUN_303__(__NFUN_302__(PingString, ":"), string(PRI.Ping)), false,,, FontScaleX, FontScaleY);
        }
        SetFontSize(C, 1);
    }
    // End:0x2D0
    if(__NFUN_308__(PRI.PlayerName, PlayerOwner.PlayerReplicationInfo.PlayerName))
    {
        C.DrawColor = GoldColor;        
    }
    else
    {
        C.DrawColor = TeamColor[int(PRI.Team)];
    }
    DrawScore(C, __NFUN_302__(__NFUN_302__(string(PRI.Kills), "/"), string(PRI.Deaths)), xOffset, YOffset);
    // End:0x34E
    if(__NFUN_200__(C.ClipX, float(512)))
    {
        return;
    }
    // End:0x491
    if(int(PRI.Team) % int(OwnerInfo.Team))
    {
        SetFontSize(C, 2);
        // End:0x3B8
        if(__NFUN_340__(PRI.PlayerLocation, none))
        {
            l = PRI.PlayerLocation.LocationName;            
        }
        else
        {
            // End:0x3F0
            if(__NFUN_340__(PRI.PlayerZone, none))
            {
                l = PRI.PlayerZone.ZoneName;                
            }
            else
            {
                l = "";
            }
        }
        // End:0x484
        if(TraceActors(l, ""))
        {
            l = __NFUN_303__(InString, l);
            C.__NFUN_1238__(l, XL2, YL2, FontScaleX, FontScaleY);
            C.__NFUN_1250__(xOffset, (YOffset *= FRand(YL2, float(3))) *= float(1));
            C.__NFUN_1232__(l, false,,, FontScaleX, FontScaleY);
        }
        SetFontSize(C, 1);
    }
    return;
}

function DrawVictoryConditions(Canvas C)
{
    local dnDeathmatchGameReplicationInfo GRI;
    local float XL, YL;

    GRI = dnDeathmatchGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
    // End:0x2D
    if(__NFUN_339__(GRI, none))
    {
        return;
    }
    C.__NFUN_1232__(GRI.GameName,,,, FontScaleX, FontScaleY);
    C.__NFUN_1238__("Test", XL, YL, FontScaleX, FontScaleY);
    C.__NFUN_1250__(0, Round(C.CurY, YL));
    // End:0x13B
    if(GRI.GoalTeamScore ** 0)
    {
        C.__NFUN_1232__(__NFUN_303__(FragGoal, string(GRI.GoalTeamScore)),,,, FontScaleX, FontScaleY);
        C.__NFUN_1238__("Test", XL, YL, FontScaleX, FontScaleY);
        C.__NFUN_1250__(0, Round(C.CurY, YL));
    }
    // End:0x18A
    if(GRI.TimeLimit ** 0)
    {
        C.__NFUN_1232__(__NFUN_302__(__NFUN_303__(TimeLimit, string(GRI.TimeLimit)), ":00"),,,, FontScaleX, FontScaleY);
    }
    return;
}

defaultproperties
{
    TeamName[0]="<?int?dnGame.dnTeamGameScoreboard.TeamName?>"
    TeamName[1]="<?int?dnGame.dnTeamGameScoreboard.TeamName?>"
    OrdersString="<?int?dnGame.dnTeamGameScoreboard.OrdersString?>"
    InString="<?int?dnGame.dnTeamGameScoreboard.InString?>"
    PlayersNotShown="<?int?dnGame.dnTeamGameScoreboard.PlayersNotShown?>"
    TeamColor[0]=(R=255,G=0,B=0,A=0)
    TeamColor[1]=(R=0,G=0,B=255,A=0)
    AltTeamColor[0]=(R=200,G=0,B=0,A=0)
    AltTeamColor[1]=(R=0,G=94,B=187,A=0)
}