/*******************************************************************************
 * TriggerAssignVehicle generated by Eliot.UELib using UELib.CLI.
 * Eliot.UELib © 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class TriggerAssignVehicle extends TriggerAssign
	collapsecategories
	hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound,Collision,Interpolation,movement);

struct SVehiclePhysicsWheelPropertiesModifier
{
	var() Engine.Object.EFloatModifier SteerRatioModifier;
	var() float SteerRatio;
	var() Engine.Object.EFloatModifier BrakeRatioModifier;
	var() float BrakeRatio;
	var() Engine.Object.EFloatModifier HandbrakeRatioModifier;
	var() float HandbrakeRatio;
	var() Engine.Object.EFloatModifier FrictionStaticModifier;
	var() float FrictionStatic;
	var() Engine.Object.EFloatModifier FrictionDynamicModifier;
	var() float FrictionDynamic;
	var() Engine.Object.EFloatModifier FrictionRollingModifier;
	var() float FrictionRolling;
	var() Engine.Object.EFloatModifier StiffnessLateralModifier;
	var() float StiffnessLateral;
	var() Engine.Object.EFloatModifier StiffnessLongitudinalModifier;
	var() float StiffnessLongitudinal;
	var() Engine.Object.EFloatModifier RestitutionModifier;
	var() float Restitution;
	var() Engine.Object.EFloatModifier SuspensionSpringLengthModifier;
	var() float SuspensionSpringLength;
	var() Engine.Object.EFloatModifier SuspensionSpringDampingModifier;
	var() float SuspensionSpringDamping;
	var() Engine.Object.EFloatModifier SuspensionSpringStiffnessModifier;
	var() float SuspensionSpringStiffness;
	var() Engine.Object.EFloatModifier RadiusModifier;
	var() float Radius;
	var() Engine.Object.EFloatModifier MassModifier;
	var() float Mass;
};

struct SCarWheelAxleModifier
{
	var() SVehiclePhysicsWheelPropertiesModifier WheelPropsModifier;
	var() SVehiclePhysicsWheelPropertiesModifier HandbrakeWheelPropsModifier;
};

struct SVehiclePhysicsMotorPropertiesModifier
{
	var() Engine.Object.EFloatModifier MotorConstantsModifiers[6];
	var() float MotorConstants[6];
};

var(TriggerAssignVehicleControl) bool bAssignControlType;
var(TriggerAssignVehicleControl) bool bAssignZMotionType;
var(TriggerAssignVehicleView) bool bAssignViewActor;
var(TriggerAssignVehicleWheel) bool bAssignWheelMaterialType;
var(TriggerAssignVehicleWheel) bool bAssignWheelMassType;
var() Engine.Object.EBitModifier AllowDismountWhileMovingModifier;
var() Engine.Object.EBitModifier AllowPlayerReflipModifier;
var() Engine.Object.EFloatModifier StoppedSpeedModifier;
var() float StoppedSpeed;
var() Engine.Object.EFloatModifier ForwardVelocityThresholdModifier;
var() float ForwardVelocityThreshold;
var() Engine.Object.EFloatModifier TickCutoffSpeedModifier;
var() float TickCutoffSpeed;
var() Engine.Object.EFloatModifier DrivenAvoidRangeModifier;
var() float DrivenAvoidRange;
var() Engine.Object.EFloatModifier PassedDamageScaleModifier;
var() float PassedDamageScale;
var() Engine.Object.EFloatModifier PassedDamageScaleAIModifier;
var() float PassedDamageScaleAI;
var() Engine.Object.EFloatModifier VehicleMinNeutralTransitionTimeModifier;
var() float VehicleMinNeutralTransitionTime;
var() SVehiclePhysicsMotorPropertiesModifier MotorPropsModifier;
var(TriggerAssignVehicleAxle) SCarWheelAxleModifier FrontAxleModifier;
var(TriggerAssignVehicleAxle) SCarWheelAxleModifier RearAxleModifier;
var(TriggerAssignVehicleBraking) Engine.Object.EBitModifier HandbrakeAlwaysOnModifier;
var(TriggerAssignVehicleBraking) Engine.Object.EFloatModifier BrakeTorqueModifier;
var(TriggerAssignVehicleBraking) float BrakeTorque;
var(TriggerAssignVehicleBraking) Engine.Object.EFloatModifier LowSpeedModifier;
var(TriggerAssignVehicleBraking) float LowSpeed;
var(TriggerAssignVehicleBraking) Engine.Object.EFloatModifier LowSpeedBrakeTorqueModifier;
var(TriggerAssignVehicleBraking) float LowSpeedBrakeTorque;
var(TriggerAssignVehicleBraking) Engine.Object.EFloatModifier NeutralBrakeTorqueModifier;
var(TriggerAssignVehicleBraking) float NeutralBrakeTorque;
var(TriggerAssignVehicleBraking) Engine.Object.EFloatModifier NoDriverBrakeTorqueModifier;
var(TriggerAssignVehicleBraking) float NoDriverBrakeTorque;
var(TriggerAssignVehicleBraking) Engine.Object.EFloatModifier HandbrakeTorqueModifier;
var(TriggerAssignVehicleBraking) float HandbrakeTorque;
var(TriggerAssignVehicleControl) dnGame.VehicleBase.EVehicleControlType ControlType;
var(TriggerAssignVehicleControl) Engine.Object.EFloatModifier ControlStiffnessModifier;
var(TriggerAssignVehicleControl) float ControlStiffness;
var(TriggerAssignVehicleControl) dnGame.VehicleBase.EVehicleZMotionType ZMotionType;
var(TriggerAssignVehicleControl) Engine.Object.EFloatModifier ZMotionPowerModifier;
var(TriggerAssignVehicleControl) float ZMotionPower;
var(TriggerAssignVehicleFlip) Engine.Object.EFloatModifier FlipThresholdModifier;
var(TriggerAssignVehicleFlip) float FlipThreshold;
var(TriggerAssignVehicleFlip) Engine.Object.EFloatModifier FlipTotalTimeModifier;
var(TriggerAssignVehicleFlip) float FlipTotalTime;
var(TriggerAssignVehicleFlip) Engine.Object.EFloatModifier FlipTorqueModifier;
var(TriggerAssignVehicleFlip) float FlipTorque;
var(TriggerAssignVehicleFlip) Engine.Object.EFloatModifier FlipLiftModifier;
var(TriggerAssignVehicleFlip) float FlipLift;
var(TriggerAssignVehicleFlip) Engine.Object.EFloatModifier FlipKickMinimumSpeedModifier;
var(TriggerAssignVehicleFlip) float FlipKickMinimumSpeed;
var(TriggerAssignVehiclePhysics) Engine.Object.EFloatModifier ExplosionMomentumScalarModifier;
var(TriggerAssignVehiclePhysics) float ExplosionMomentumScalar;
var(TriggerAssignVehiclePhysics) Engine.Object.EFloatModifier UpwardCorpseBoostModifier;
var(TriggerAssignVehiclePhysics) float UpwardCorpseBoost;
var(TriggerAssignVehiclePhysics) Engine.Object.EFloatModifier UpwardCorpseBoostRndModifier;
var(TriggerAssignVehiclePhysics) float UpwardCorpseBoostRnd;
var(TriggerAssignVehiclePhysics) Engine.Object.EFloatModifier ForwardCorpseBoostModifier;
var(TriggerAssignVehiclePhysics) float ForwardCorpseBoost;
var(TriggerAssignVehiclePhysics) Engine.Object.EFloatModifier ForwardCorpseBoostRndModifier;
var(TriggerAssignVehiclePhysics) float ForwardCorpseBoostRnd;
var(TriggerAssignVehiclePhysics) Engine.Object.EFloatModifier LowFrictionModifier;
var(TriggerAssignVehiclePhysics) float LowFriction;
var(TriggerAssignVehiclePhysics) Engine.Object.EFloatModifier HighFrictionModifier;
var(TriggerAssignVehiclePhysics) float HighFriction;
var(TriggerAssignVehicleSteering) Engine.Object.EFloatModifier NeutralSteeringAdjustModifier;
var(TriggerAssignVehicleSteering) float NeutralSteeringAdjust;
var(TriggerAssignVehicleSteering) Engine.Object.ERotModifier SteerMaxAnglesModifier;
var(TriggerAssignVehicleSteering) Rotator SteerMaxAngles;
var(TriggerAssignVehicleSteering) Engine.Object.EFloatModifier MinDirectionalChangeSteerAlphaModifier;
var(TriggerAssignVehicleSteering) float MinDirectionalChangeSteerAlpha;
var(TriggerAssignVehicleView) Engine.Object.EFloatModifier ViewDistModifier;
var(TriggerAssignVehicleView) float ViewDist;
var(TriggerAssignVehicleView) Engine.Object.EIntModifier ViewElevationAngleModifier;
var(TriggerAssignVehicleView) int ViewElevationAngle;
var(TriggerAssignVehicleView) Engine.Object.EVectModifier ViewFocusOffsetModifier;
var(TriggerAssignVehicleView) Vector ViewFocusOffset;
var(TriggerAssignVehicleWheel) class<PhysicsMaterial> WheelMaterialType;
var(TriggerAssignVehicleWheel) Engine.Object.EPhysicsMassType WheelMassType;
var(TriggerAssignVehicleWheel) Engine.Object.EFloatModifier WheelSkidMinTimeModifier;
var(TriggerAssignVehicleWheel) float WheelSkidMinTime;
var(TriggerAssignVehicleBoost) bool bResetBoost;

function ApplyWheelPropsModifier(out SVehiclePhysicsWheelProperties WheelProps, SVehiclePhysicsWheelPropertiesModifier WheelPropsModifier)
{
	WheelProps.SteerRatio = __NFUN_348__(WheelPropsModifier.SteerRatioModifier, WheelProps.SteerRatio, WheelPropsModifier.SteerRatio);
	WheelProps.BrakeRatio = __NFUN_348__(WheelPropsModifier.BrakeRatioModifier, WheelProps.BrakeRatio, WheelPropsModifier.BrakeRatio);
	WheelProps.HandbrakeRatio = __NFUN_348__(WheelPropsModifier.HandbrakeRatioModifier, WheelProps.HandbrakeRatio, WheelPropsModifier.HandbrakeRatio);
	WheelProps.FrictionStatic = __NFUN_348__(WheelPropsModifier.FrictionStaticModifier, WheelProps.FrictionStatic, WheelPropsModifier.FrictionStatic);
	WheelProps.FrictionDynamic = __NFUN_348__(WheelPropsModifier.FrictionDynamicModifier, WheelProps.FrictionDynamic, WheelPropsModifier.FrictionDynamic);
	WheelProps.FrictionRolling = __NFUN_348__(WheelPropsModifier.FrictionRollingModifier, WheelProps.FrictionRolling, WheelPropsModifier.FrictionRolling);
	WheelProps.StiffnessLateral = __NFUN_348__(WheelPropsModifier.StiffnessLateralModifier, WheelProps.StiffnessLateral, WheelPropsModifier.StiffnessLateral);
	WheelProps.StiffnessLongitudinal = __NFUN_348__(WheelPropsModifier.StiffnessLongitudinalModifier, WheelProps.StiffnessLongitudinal, WheelPropsModifier.StiffnessLongitudinal);
	WheelProps.Restitution = __NFUN_348__(WheelPropsModifier.RestitutionModifier, WheelProps.Restitution, WheelPropsModifier.Restitution);
	WheelProps.SuspensionSpringLength = __NFUN_348__(WheelPropsModifier.SuspensionSpringLengthModifier, WheelProps.SuspensionSpringLength, WheelPropsModifier.SuspensionSpringLength);
	WheelProps.SuspensionSpringDamping = __NFUN_348__(WheelPropsModifier.SuspensionSpringDampingModifier, WheelProps.SuspensionSpringDamping, WheelPropsModifier.SuspensionSpringDamping);
	WheelProps.SuspensionSpringStiffness = __NFUN_348__(WheelPropsModifier.SuspensionSpringStiffnessModifier, WheelProps.SuspensionSpringStiffness, WheelPropsModifier.SuspensionSpringStiffness);
	WheelProps.Radius = __NFUN_348__(WheelPropsModifier.RadiusModifier, WheelProps.Radius, WheelPropsModifier.Radius);
	WheelProps.Mass = __NFUN_348__(WheelPropsModifier.MassModifier, WheelProps.Mass, WheelPropsModifier.Mass);
	return;
}

function ApplyAxleModifier(out SCarWheelAxle AxleProps, SCarWheelAxleModifier AxlePropsModifier)
{
	ApplyWheelPropsModifier(AxleProps.WheelProps, AxlePropsModifier.WheelPropsModifier);
	ApplyWheelPropsModifier(AxleProps.HandbrakeWheelProps, AxlePropsModifier.HandbrakeWheelPropsModifier);
	return;
}

function DoAssign(Actor A)
{
	local VehicleBase Vehicle;
	local Vehicle_MeqonWheeled MeqonVehicle;
	local Veh_CarTemplate CarVehicle;
	local int i;

	super.DoAssign(A);
	Vehicle = VehicleBase(A);
	// End:0x29
	if(__NFUN_339__(Vehicle, none))
	{
		return;
	}
	Vehicle.bAllowDismountWhileMoving = __NFUN_346__(AllowDismountWhileMovingModifier, Vehicle.bAllowDismountWhileMoving);
	Vehicle.bAllowPlayerReflip = __NFUN_346__(AllowPlayerReflipModifier, Vehicle.bAllowPlayerReflip);
	Vehicle.StoppedSpeed = __NFUN_348__(StoppedSpeedModifier, Vehicle.StoppedSpeed, StoppedSpeed);
	Vehicle.ForwardVelocityThreshold = __NFUN_348__(ForwardVelocityThresholdModifier, Vehicle.ForwardVelocityThreshold, ForwardVelocityThreshold);
	Vehicle.TickCutoffSpeed = __NFUN_348__(TickCutoffSpeedModifier, Vehicle.TickCutoffSpeed, TickCutoffSpeed);
	Vehicle.DrivenAvoidRange = __NFUN_348__(DrivenAvoidRangeModifier, Vehicle.DrivenAvoidRange, DrivenAvoidRange);
	Vehicle.PassedDamageScale = __NFUN_348__(PassedDamageScaleModifier, Vehicle.PassedDamageScale, PassedDamageScale);
	Vehicle.PassedDamageScaleAI = __NFUN_348__(PassedDamageScaleAIModifier, Vehicle.PassedDamageScaleAI, PassedDamageScaleAI);
	Vehicle.bHandbrakeAlwaysOn = __NFUN_346__(HandbrakeAlwaysOnModifier, Vehicle.bHandbrakeAlwaysOn);
	// End:0x1CA
	if(bAssignControlType)
	{
		Vehicle.ControlType = ControlType;
	}
	// End:0x1E8
	if(bAssignZMotionType)
	{
		Vehicle.ZMotionType = ZMotionType;
	}
	Vehicle.ControlStiffness = __NFUN_348__(ControlStiffnessModifier, Vehicle.ControlStiffness, ControlStiffness);
	Vehicle.ZMotionPower = __NFUN_348__(ZMotionPowerModifier, Vehicle.ZMotionPower, ZMotionPower);
	Vehicle.FlipThreshold = __NFUN_348__(FlipThresholdModifier, Vehicle.FlipThreshold, FlipThreshold);
	Vehicle.FlipTotalTime = __NFUN_348__(FlipTotalTimeModifier, Vehicle.FlipTotalTime, FlipTotalTime);
	Vehicle.FlipTorque = __NFUN_348__(FlipTorqueModifier, Vehicle.FlipTorque, FlipTorque);
	Vehicle.FlipLift = __NFUN_348__(FlipLiftModifier, Vehicle.FlipLift, FlipLift);
	Vehicle.FlipKickMinimumSpeed = __NFUN_348__(FlipKickMinimumSpeedModifier, Vehicle.FlipKickMinimumSpeed, FlipKickMinimumSpeed);
	Vehicle.ExplosionMomentumScalar = __NFUN_348__(ExplosionMomentumScalarModifier, Vehicle.ExplosionMomentumScalar, ExplosionMomentumScalar);
	Vehicle.UpwardCorpseBoost = __NFUN_348__(UpwardCorpseBoostModifier, Vehicle.UpwardCorpseBoost, UpwardCorpseBoost);
	Vehicle.UpwardCorpseBoostRnd = __NFUN_348__(UpwardCorpseBoostRndModifier, Vehicle.UpwardCorpseBoostRnd, UpwardCorpseBoostRnd);
	Vehicle.ForwardCorpseBoost = __NFUN_348__(ForwardCorpseBoostModifier, Vehicle.ForwardCorpseBoost, ForwardCorpseBoost);
	Vehicle.ForwardCorpseBoostRnd = __NFUN_348__(ForwardCorpseBoostRndModifier, Vehicle.ForwardCorpseBoostRnd, ForwardCorpseBoostRnd);
	Vehicle.ViewDist = __NFUN_348__(ViewDistModifier, Vehicle.ViewDist, ViewDist);
	Vehicle.ViewElevationAngle = __NFUN_347__(ViewElevationAngleModifier, Vehicle.ViewElevationAngle, ViewElevationAngle);
	Vehicle.ViewFocusOffset = __NFUN_349__(ViewFocusOffsetModifier, Vehicle.ViewFocusOffset, ViewFocusOffset);
	MeqonVehicle = Vehicle_MeqonWheeled(Vehicle);
	// End:0x49A
	if(__NFUN_339__(MeqonVehicle, none))
	{
		return;
	}
	MeqonVehicle.VehicleMinNeutralTransitionTime = __NFUN_348__(VehicleMinNeutralTransitionTimeModifier, MeqonVehicle.VehicleMinNeutralTransitionTime, VehicleMinNeutralTransitionTime);
	MeqonVehicle.BrakeTorque = __NFUN_348__(BrakeTorqueModifier, MeqonVehicle.BrakeTorque, BrakeTorque);
	MeqonVehicle.LowSpeed = __NFUN_348__(LowSpeedModifier, MeqonVehicle.LowSpeed, LowSpeed);
	MeqonVehicle.LowSpeedBrakeTorque = __NFUN_348__(LowSpeedBrakeTorqueModifier, MeqonVehicle.LowSpeedBrakeTorque, LowSpeedBrakeTorque);
	MeqonVehicle.NeutralBrakeTorque = __NFUN_348__(NeutralBrakeTorqueModifier, MeqonVehicle.NeutralBrakeTorque, NeutralBrakeTorque);
	MeqonVehicle.NoDriverBrakeTorque = __NFUN_348__(NoDriverBrakeTorqueModifier, MeqonVehicle.NoDriverBrakeTorque, NoDriverBrakeTorque);
	MeqonVehicle.HandbrakeTorque = __NFUN_348__(HandbrakeTorqueModifier, MeqonVehicle.HandbrakeTorque, HandbrakeTorque);
	MeqonVehicle.LowFriction = __NFUN_348__(LowFrictionModifier, MeqonVehicle.LowFriction, LowFriction);
	MeqonVehicle.HighFriction = __NFUN_348__(HighFrictionModifier, MeqonVehicle.HighFriction, HighFriction);
	MeqonVehicle.NeutralSteeringAdjust = __NFUN_348__(NeutralSteeringAdjustModifier, MeqonVehicle.NeutralSteeringAdjust, NeutralSteeringAdjust);
	MeqonVehicle.SteerMaxAngles = __NFUN_350__(SteerMaxAnglesModifier, MeqonVehicle.SteerMaxAngles, SteerMaxAngles);
	MeqonVehicle.MinDirectionalChangeSteerAlpha = __NFUN_348__(MinDirectionalChangeSteerAlphaModifier, MeqonVehicle.MinDirectionalChangeSteerAlpha, MinDirectionalChangeSteerAlpha);
	// End:0x6C8
	if(bAssignWheelMaterialType)
	{
		MeqonVehicle.WheelMaterialType = WheelMaterialType;
	}
	// End:0x6E6
	if(bAssignWheelMassType)
	{
		MeqonVehicle.WheelMassType = WheelMassType;
	}
	MeqonVehicle.WheelSkidMinTime = __NFUN_348__(WheelSkidMinTimeModifier, MeqonVehicle.WheelSkidMinTime, WheelSkidMinTime);
	CarVehicle = Veh_CarTemplate(MeqonVehicle);
	// End:0x730
	if(__NFUN_339__(CarVehicle, none))
	{
		return;
	}
	ApplyAxleModifier(CarVehicle.FrontAxle, FrontAxleModifier);
	ApplyAxleModifier(CarVehicle.RearAxle, RearAxleModifier);
	i = 0;
	J0x76B:

	// End:0x7D9 [Loop If]
	if(__NFUN_169__(i, 6))
	{
		CarVehicle.MotorProps.MotorConstants[i] = __NFUN_348__(MotorPropsModifier.MotorConstantsModifiers[i], CarVehicle.MotorProps.MotorConstants[i], MotorPropsModifier.MotorConstants[i]);
		__NFUN_184__(i);
		// [Loop Continue]
		goto J0x76B;
	}
	// End:0x805
	if(__NFUN_201__(CarVehicle.HandbrakeActive, 0))
	{
		CarVehicle.HandBrakeEnabled();		
	}
	else
	{
		CarVehicle.HandBrakeDisabled();
	}
	// End:0x848
	if(bResetBoost)
	{
		CarVehicle.BoostMeter = 1;
		CarVehicle.BoostOverheatTimer = 0;
	}
	return;
}
