/*******************************************************************************
 * TriggerTeleportVehicle generated by Eliot.UELib using UELib.CLI.
 * Eliot.UELib © 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class TriggerTeleportVehicle extends Triggers
	collapsecategories
	hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound);

var Actor TeleportDestActor;
var VehicleBase Vehicle;
var PlayerPawn Player;
var Engine.Object.EPhysics PlayerPhysics;
var() noexport deprecated name TeleportVehicleTag "When triggered, we will teleport this vehicle to the event actor";
var() noexport deprecated name TeleportedEvent "This event will be triggered when the teleport occurs (while screen is completely white).";
var() SScreenFlash FadeToScreenFlash;
var() SScreenFlash FadeFromScreenFlash;
var bool bInUse;
var bool bPlayerTriggered;

function PostVerifySelf()
{
	super(Actor).PostVerifySelf();
	FadeToScreenFlash.FlashFuncActor = self;
	return;
}

event Trigger(Actor Other, Pawn EventInstigator)
{
	super(Actor).Trigger(Other, EventInstigator);
	MaybeStartTeleport(Other);
	return;
}

function Touch(Actor Other)
{
	super(Actor).Touch(Other);
	MaybeStartTeleport(Other);
	return;
}

final function MaybeStartTeleport(Actor Other)
{
	// End:0x0B
	if(bInUse)
	{
		return;
	}
	Vehicle = VehicleBase(Other);
	Player = PlayerPawn(Other);
	// End:0x52
	if(__NFUN_339__(Vehicle, none))
	{
		Vehicle = VehicleBase(FindActor(class'Actor', TeleportVehicleTag));
	}
	bPlayerTriggered = false;
	// End:0x7C
	if(__NFUN_339__(Player, none))
	{
		Player = Level.__NFUN_1161__();		
	}
	else
	{
		bPlayerTriggered = true;
	}
	StartVehicleTeleport();
	return;
}

final function StartVehicleTeleport()
{
	// End:0x46
	if(__NFUN_150__(__NFUN_150__(__NFUN_150__(__NFUN_339__(Vehicle, none), Vehicle.bTeleporting), __NFUN_339__(Player, none)), Player.IsDead()))
	{
		return;
	}
	TeleportDestActor = FindActor(class'Actor', Event);
	// End:0xB5
	if(__NFUN_339__(TeleportDestActor, none))
	{
		BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_303__("Could not find teleport destination for", string(self)), ". Event=:"), string(Event)));
		return;
	}
	bInUse = true;
	Vehicle.__NFUN_642__(0);
	Vehicle.bTeleporting = true;
	Vehicle.__NFUN_790__(__NFUN_232__(0, 0, 0));
	Vehicle.__NFUN_791__(__NFUN_232__(0, 0, 0));
	Player.MyHUD.AddScreenFlash(FadeToScreenFlash);
	Player.__NFUN_621__(false);
	PlayerPhysics = Player.Physics;
	Player.__NFUN_642__(0);
	return;
}

function FinishVehicleTeleport()
{
	local Veh_CarTemplate CarVehicle;

	// End:0xED
	if(__NFUN_340__(Vehicle, none))
	{
		// End:0x64
		if(__NFUN_150__(__NFUN_145__(bPlayerTriggered), Vehicle.ShouldTeleportFromPlayerTrigger()))
		{
			Vehicle.__NFUN_645__(TeleportDestActor.Location);
			Vehicle.__NFUN_652__(TeleportDestActor.Rotation);
		}
		Vehicle.__NFUN_642__(18);
		Vehicle.__NFUN_817__();
		CarVehicle = Veh_CarTemplate(Vehicle);
		// End:0xDB
		if(__NFUN_340__(CarVehicle, none))
		{
			CarVehicle.BoostMeter = 1;
			CarVehicle.BoostOverheatTimer = 0;
			CarVehicle.FindAndStopSound('OverheatWarn');
		}
		Vehicle.bTeleporting = false;
	}
	// End:0x1F7
	if(__NFUN_340__(Player, none))
	{
		Player.__NFUN_645__(Vehicle.Location);
		Player.MyHUD.AddScreenFlash(FadeFromScreenFlash);
		Player.__NFUN_621__(true);
		Player.__NFUN_642__(PlayerPhysics);
		// End:0x1F7
		if(__NFUN_148__(__NFUN_340__(Vehicle, none), __NFUN_339__(Vehicle.VehicleGetDriver(), none)))
		{
			Vehicle.obWasFlipped = Vehicle.obIsFlipped;
			Vehicle.obIsFlipped = false;
			// End:0x1E1
			if(Vehicle.obWasFlipped)
			{
				Vehicle.Righted();
				Vehicle.obWasFlipped = false;
			}
			Vehicle.AttachPlayerToDriverSeat(Player, true);
		}
	}
	GlobalTrigger(TeleportedEvent, Player, self);
	Vehicle = none;
	Player = none;
	bInUse = false;
	return;
}

defaultproperties
{
	FadeToScreenFlash=(bAlwaysTick=false,bOnlyReplace=false,bResumeFlash=false,Priority=999,ReplaceMin=0,FlashID=VehiclePort,FlashType=2,FlashStyle=8,ColorStart=(B=97,G=2,R=1,A=0),G=0,B=0,A=0)
	FadeFromScreenFlash=(bAlwaysTick=false,bOnlyReplace=false,bResumeFlash=true,Priority=999,ReplaceMin=0,FlashID=VehiclePort,FlashType=0,FlashStyle=8,ColorStart=(B=97,G=2,R=1,A=255),G=255,B=255,A=255)
	bCollideActors=true
	TouchClasses=/* Array type was not detected. */
}