/*******************************************************************************
 * Veh_MineCart generated by Eliot.UELib using UELib.CLI.
 * Eliot.UELib © 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Veh_MineCart extends Vehicle_MeqonWheeled_Custom
	collapsecategories;

var() noexport name SE_LockToTrack "Trigger this to play the lock to track sound.";
var() noexport name SE_UnlockFromTrack "Trigger this to play the unlock from track sound.";
var() noexport name SE_Jump "Trigger this to play the jump sound.  Also disables auto-rolling sound until SE_Land is called.";
var() noexport name SE_Land "Trigger this to play the land sound.  Also enables auto-rolling sound.";
var() noexport name SE_Crash "Trigger this to play the crash sound.";

simulated event PreBeginPlay()
{
	super.PreBeginPlay();
	__NFUN_718__('LockToTrack', SE_LockToTrack);
	__NFUN_718__('UnlockFromTrack', SE_UnlockFromTrack);
	__NFUN_718__('Jump', SE_Jump);
	__NFUN_718__('Land', SE_Land);
	__NFUN_718__('Crash', SE_Crash);
	return;
}

function TriggerFunc_LockToTrack()
{
	FindAndPlaySound('Lock');
	return;
}

function TriggerFunc_UnlockFromTrack()
{
	FindAndPlaySound('Release');
	return;
}

function TriggerFunc_Jump()
{
	NotifyJumped();
	return;
}

function TriggerFunc_Land()
{
	NotifyLanded();
	return;
}

function TriggerFunc_Crash()
{
	FindAndPlaySound('Crash');
	return;
}

function NotifyJumped()
{
	// End:0x21
	if(__NFUN_145__(bInAir))
	{
		FindAndPlaySound('Jump');
		FindAndStopSound('Squeak');
	}
	super.NotifyJumped();
	return;
}

function NotifyLanded()
{
	// End:0x14
	if(bInAir)
	{
		FindAndPlaySound('Land');
	}
	super.NotifyLanded();
	return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
	super.RegisterPrecacheComponents(PrecacheIndex);
	PrecacheIndex.__NFUN_1277__(VoicePack, 'Lock');
	PrecacheIndex.__NFUN_1277__(VoicePack, 'Release');
	PrecacheIndex.__NFUN_1277__(VoicePack, 'Crash');
	PrecacheIndex.__NFUN_1277__(VoicePack, 'Jump');
	PrecacheIndex.__NFUN_1277__(VoicePack, 'Squeak');
	PrecacheIndex.__NFUN_1277__(VoicePack, 'Land');
	return;
}

defaultproperties
{
	WheelDefs(0)=
/* Exception thrown while deserializing WheelDefs
System.ArgumentOutOfRangeException: Non-negative number required.
Parameter name: value
   at System.IO.MemoryStream.set_Position(Int64 value)
   at UELib.Core.UDefaultProperty.Deserialize() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 184
   at UELib.Core.UDefaultProperty.DeserializeDefaultPropertyValue(PropertyType type, DeserializeFlags& deserializeFlags) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 767 */
}