/*******************************************************************************
 * Veh_MonsterTruck generated by Eliot.UELib using UELib.CLI.
 * Eliot.UELib © 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Veh_MonsterTruck extends Veh_MonsterTruck_NativeBase
	collapsecategories;

var() class<SoftParticleSystem> WheelEffectClass;
var() class<SoftParticleSystem> WheelWaterEffectClass;
var() class<SoftParticleSystem> WheelMudEffectClass;
var() class<SoftParticleSystem> ExhaustClass;
var() class<SoftParticleSystem> BoostExhaustClass;
var() noexport bool bOutOfGas "Should the monster truck start with no gas";
var() noexport name OutOfGasEvent "Event that will cause the monster truck to run out of gas";
var dnControl_GasTank GasTank[2];
var dnFriendFX_Spawners WaterSplash;

simulated event PostVerifySelf()
{
	local int i;

	super(Veh_CarTemplate).PostVerifySelf();
	// End:0x3C
	if(__NFUN_340__(RadioActor, none))
	{
		RadioActor.AmbientMusicInnerRadius = 100;
		RadioActor.AmbientMusicRadius = 300;
	}
	Suspension = MonsterTruckSpecialPart_Suspension(FindMountedActor(, class'MonsterTruckSpecialPart_Suspension'));
	// End:0x127
	if(__NFUN_340__(ExhaustClass, none))
	{
		Exhaust[0] = __NFUN_615__(ExhaustClass);
		Exhaust[0].MountOrigin = __NFUN_234__(__NFUN_232__(-115, 23, 34), DrawScale);
		Exhaust[0].MountAngles = __NFUN_265__(0, 32768, 0);
		Exhaust[0].__NFUN_635__(self);
		Exhaust[1] = __NFUN_615__(ExhaustClass);
		Exhaust[1].MountOrigin = __NFUN_234__(__NFUN_232__(-115, -23, 34), DrawScale);
		Exhaust[1].MountAngles = __NFUN_265__(0, 32768, 0);
		Exhaust[1].__NFUN_635__(self);
	}
	// End:0x1FB
	if(__NFUN_340__(BoostExhaustClass, none))
	{
		BoostExhaust[0] = __NFUN_615__(BoostExhaustClass);
		BoostExhaust[0].MountOrigin = __NFUN_234__(__NFUN_232__(-115, 23, 34), DrawScale);
		BoostExhaust[0].MountAngles = __NFUN_265__(0, 32768, 0);
		BoostExhaust[0].__NFUN_635__(self);
		BoostExhaust[1] = __NFUN_615__(BoostExhaustClass);
		BoostExhaust[1].MountOrigin = __NFUN_234__(__NFUN_232__(-115, -23, 34), DrawScale);
		BoostExhaust[1].MountAngles = __NFUN_265__(0, 32768, 0);
		BoostExhaust[1].__NFUN_635__(self);
	}
	__NFUN_718__('OutOfGas', OutOfGasEvent);
	GasTank[0] = dnControl_GasTank(FindMountedActor('GasTank1', class'dnControl_GasTank'));
	GasTank[1] = dnControl_GasTank(FindMountedActor('GasTank2', class'dnControl_GasTank'));
	// End:0x259
	if(bOutOfGas)
	{
		bOutOfGas = false;
		TriggerFunc_OutOfGas();
	}
	WaterSplash = dnFriendFX_Spawners(FindOwnedActor(class'Actor', 'WaterSplash_Large_Spawner'));
	return;
}

simulated event PostBeginPlay()
{
	super(VehicleBase).PostBeginPlay();
	// End:0x8A
	if(__NFUN_150__(__NFUN_150__(__NFUN_340__(WheelEffectClass, none), __NFUN_340__(WheelWaterEffectClass, none)), __NFUN_340__(WheelMudEffectClass, none)))
	{
		bHasWheelEffects = true;
		CreateWheelEffect(WheelEffects[0], VWheels[3]);
		CreateWheelEffect(WheelEffects[1], VWheels[2]);
		CreateWheelEffect(WheelEffects[2], VWheels[1]);
		CreateWheelEffect(WheelEffects[3], VWheels[0]);
	}
	return;
}

simulated event bool CanAccelerateForwards()
{
	return true;
	return;
}

simulated event bool CanAccelerateReverse()
{
	return true;
	return;
}

simulated event DriverEntered(VehicleSpaceBase Space)
{
	super(Vehicle_MeqonWheeled).DriverEntered(Space);
	FixedPhysicsDamageToNotPlayer = -1;
	return;
}

simulated event DriverLeft(VehicleSpaceBase Space)
{
	super(Veh_CarTemplate).DriverLeft(Space);
	// End:0x21
	if(__NFUN_173__(NumFilledSpaces, 0))
	{
		FixedPhysicsDamageToNotPlayer = 0;
	}
	return;
}

final simulated function CreateWheelEffect(out SWheelEffect WheelEffect, VWheel Wheel)
{
	WheelEffect.Wheel = Wheel;
	// End:0x6E
	if(__NFUN_340__(WheelEffectClass, none))
	{
		WheelEffect.Effect = __NFUN_615__(WheelEffectClass);
		// End:0x6E
		if(__NFUN_340__(WheelEffect.Effect, none))
		{
			WheelEffect.Effect.DisableTickWhenEmpty = true;
			WheelEffect.Effect.Enabled = false;
		}
	}
	// End:0xCC
	if(__NFUN_340__(WheelWaterEffectClass, none))
	{
		WheelEffect.WaterEffect = __NFUN_615__(WheelWaterEffectClass);
		// End:0xCC
		if(__NFUN_340__(WheelEffect.WaterEffect, none))
		{
			WheelEffect.WaterEffect.DisableTickWhenEmpty = true;
			WheelEffect.WaterEffect.Enabled = false;
		}
	}
	// End:0x12A
	if(__NFUN_340__(WheelMudEffectClass, none))
	{
		WheelEffect.MudEffect = __NFUN_615__(WheelMudEffectClass);
		// End:0x12A
		if(__NFUN_340__(WheelEffect.MudEffect, none))
		{
			WheelEffect.MudEffect.DisableTickWhenEmpty = true;
			WheelEffect.MudEffect.Enabled = false;
		}
	}
	return;
}

simulated function UpdateWheelEffectScale(SoftParticleSystem Effect, float EffectScale, float DeltaTime)
{
	// End:0x95
	if(__NFUN_206__(Effect.SystemSizeScale, EffectScale))
	{
		// End:0x4A
		if(__NFUN_201__(EffectScale, Effect.SystemSizeScale))
		{
			Effect.SystemSizeScale = EffectScale;			
		}
		else
		{
			__NFUN_210__(Effect.SystemSizeScale, __NFUN_195__(0.5, DeltaTime));
			// End:0x95
			if(__NFUN_200__(Effect.SystemSizeScale, EffectScale))
			{
				Effect.SystemSizeScale = EffectScale;
			}
		}
	}
	return;
}

event float GetVehicleFloorHeight()
{
	return 10;
	return;
}

function StartEngine()
{
	// End:0x14
	if(bOutOfGas)
	{
		EngineStartSoundName = 'None';
	}
	super(Veh_CarTemplate).StartEngine();
	EngineStartSoundName = default.EngineStartSoundName;
	return;
}

simulated function TurnIgnitionOff()
{
	// End:0x14
	if(bOutOfGas)
	{
		EngineStopSoundName = 'None';
	}
	super(Veh_CarTemplate).TurnIgnitionOff();
	EngineStopSoundName = default.EngineStopSoundName;
	return;
}

function TriggerFunc_OutOfGas()
{
	local int i;

	// End:0x0B
	if(bOutOfGas)
	{
		return;
	}
	bOutOfGas = true;
	FindAndPlaySound('GasOut');
	FindAndPlaySound('Stall');
	ForcePowerOff();
	// End:0x79
	if(__NFUN_340__(GasTank[0], none))
	{
		GasTank[0].bUsable = true;
		GasTank[0].bTraceUsable = true;
		GasTank[0].bDoOverlayEffect = true;
	}
	// End:0xC3
	if(__NFUN_340__(GasTank[1], none))
	{
		GasTank[1].bUsable = true;
		GasTank[1].bTraceUsable = true;
		GasTank[1].bDoOverlayEffect = true;
	}
	i = __NFUN_166__(string(VehicleSpaces), 1);
	J0xD2:

	// End:0x111 [Loop If]
	if(__NFUN_172__(i, 0))
	{
		// End:0x107
		if(__NFUN_340__(VehicleSpaces[i], none))
		{
			VehicleSpaces[i].bTraceUsable = false;
		}
		__NFUN_185__(i);
		// [Loop Continue]
		goto J0xD2;
	}
	bHasBoost = false;
	return;
}

function GasFilled()
{
	local int i;

	bOutOfGas = false;
	// End:0x52
	if(__NFUN_340__(GasTank[0], none))
	{
		GasTank[0].bUsable = false;
		GasTank[0].bTraceUsable = false;
		GasTank[0].bDoOverlayEffect = false;
	}
	// End:0x9C
	if(__NFUN_340__(GasTank[1], none))
	{
		GasTank[1].bUsable = false;
		GasTank[1].bTraceUsable = false;
		GasTank[1].bDoOverlayEffect = false;
	}
	ForcePowerOn();
	i = __NFUN_166__(string(VehicleSpaces), 1);
	J0xB1:

	// End:0xDE [Loop If]
	if(__NFUN_172__(i, 0))
	{
		VehicleSpaces[i].bTraceUsable = true;
		__NFUN_185__(i);
		// [Loop Continue]
		goto J0xB1;
	}
	bHasBoost = true;
	return;
}

simulated function TickDriving_Throttle(float DeltaTime, Pawn P)
{
	local float ThrottleRelative;

	// End:0x47
	if(__NFUN_148__(__NFUN_340__(CurrentDrivingVehicleSpace, none), bEngineForcedOff))
	{
		ThrottleRelative = CurrentDrivingVehicleSpace.GetThrottleInput();
		// End:0x47
		if(__NFUN_206__(ThrottleRelative, 0))
		{
			FindAndPlaySound('TurnOver');
		}
	}
	super(VehicleBase).TickDriving_Throttle(DeltaTime, P);
	return;
}

function bool ShouldTeleportFromPlayerTrigger()
{
	// End:0x0B
	if(bOutOfGas)
	{
		return false;
	}
	return super(VehicleBase).ShouldTeleportFromPlayerTrigger();
	return;
}

event DoLandingEffects()
{
	local float Speed;
	local PlayerPawn Driver;
	local int i, Flag, flag2;

	Driver = PlayerPawn(VehicleGetDriver());
	Speed = __NFUN_211__(__NFUN_251__(InAirVelocity));
	// End:0x286
	if(__NFUN_201__(__NFUN_244__(__NFUN_253__(__NFUN_640__()), __NFUN_253__(InAirVelocity)), VelDotGravity))
	{
		// End:0x87
		if(__NFUN_148__(__NFUN_201__(Speed, BounceVelocity), __NFUN_202__(Speed, CrashVelocity)))
		{
			FindAndPlaySound('ShockBounce');
			// End:0x84
			if(__NFUN_340__(Driver, none))
			{
				Driver.AddRumble(BounceRumble);
			}			
		}
		else
		{
			// End:0x270
			if(__NFUN_201__(Speed, CrashVelocity))
			{
				// End:0xDA
				if(__NFUN_148__(__NFUN_340__(CurrentDrivingVehicleSpace, none), __NFUN_340__(CurrentDrivingVehicleSpace.User, none)))
				{
					CurrentDrivingVehicleSpace.User.ShakeView(LandingShake, true);
				}
				i = 0;
				J0xE1:

				// End:0x12F [Loop If]
				if(__NFUN_169__(i, 4))
				{
					GetGroundMaterialInfo(WheelEffects[i].Wheel.GroundMaterialType, Flag, flag2);
					// End:0x125
					if(__NFUN_174__(Flag, 0))
					{
						// [Explicit Break]
						goto J0x12F;
					}
					__NFUN_182__(i);
					// [Loop Continue]
					goto J0xE1;
				}
				J0x12F:

				// End:0x1B6
				if(__NFUN_174__(Flag, 0))
				{
					// End:0x1B3
					if(__NFUN_340__(WaterSplash, none))
					{
						// End:0x180
						if(__NFUN_339__(WaterSplash.MountParent, none))
						{
							WaterSplash.__NFUN_645__(Location);
							WaterSplash.__NFUN_645__(Location);
						}
						WaterSplash.ExecuteEffect(true);
						WaterSplash.ExecuteEffect(true);
						WaterSplash.ExecuteEffect(true);
					}					
				}
				else
				{
					// End:0x22F
					if(__NFUN_340__(DustCloud, none))
					{
						// End:0x1FC
						if(__NFUN_339__(DustCloud.MountParent, none))
						{
							DustCloud.__NFUN_645__(Location);
							DustCloud.__NFUN_652__(Rotation);
						}
						DustCloud.ExecuteEffect(true);
						DustCloud.ExecuteEffect(true);
						DustCloud.ExecuteEffect(true);
					}
				}
				FindAndPlaySound('Landing');
				// End:0x270
				if(__NFUN_340__(Driver, none))
				{
					Driver.AddRumble(LandingRumble);
					Driver.AddRumble(AccelRumble);
				}
			}
		}
		bLandingEffectsThrottled = true;
		__NFUN_607__(0.5, false, 'UnThrottleLandingEffects');
	}
	return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
	super.RegisterPrecacheComponents(PrecacheIndex);
	PrecacheIndex.__NFUN_1266__(WheelEffectClass);
	PrecacheIndex.__NFUN_1266__(WheelWaterEffectClass);
	PrecacheIndex.__NFUN_1266__(WheelMudEffectClass);
	PrecacheIndex.__NFUN_1266__(ExhaustClass);
	PrecacheIndex.__NFUN_1266__(BoostExhaustClass);
	PrecacheIndex.__NFUN_1277__(VoicePack, 'TurnOver');
	PrecacheIndex.__NFUN_1277__(VoicePack, 'GasOut');
	PrecacheIndex.__NFUN_1277__(VoicePack, 'Stall');
	PrecacheIndex.__NFUN_1277__(VoicePack, 'ShockBounce');
	PrecacheIndex.__NFUN_1277__(VoicePack, 'Landing');
	PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Jump');
	PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Body_Move');
	PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'ButtSeat');
	PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'ST_Getup_StandShift');
	PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Veh_HandPat');
	PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Veh_SteerGrab');
	return;
}

defaultproperties
{
	WheelEffectClass='p_Vehicles.MonsterTruck_Driving.MonsterTruck_Driving_Main'
	WheelWaterEffectClass='p_Vehicles.MonsterTruck_Driving.MonsterTruck_Driving_Water_main'
	WheelMudEffectClass='p_Vehicles.MonsterTruck_Driving.MonsterTruck_Driving_Mud_main'
	ExhaustClass='p_Vehicles.MonsterTruck_Driving_Exhaust.MonsterTruck_Driving_Exhaust_Main'
	BoostExhaustClass='p_Vehicles.MonsterTruck_DrivingBoost_Exhaust.MonsterTruck_DrivingBoost_Exhaust_Main'
	OutOfGasEvent=MonsterTruckOutOfGas
	MudSplatterClass='dnHUDEffects_MonsterTruckMudSplatter'
	WaterSplatterClass='dnHUDEffects_MonsterTruckWaterSplatter'
	WheelWaterSoundName=TireSprayLoop
	FrontAxle=(DifferentialClass=none,WheelClass=none,AxleBaseTag=None,AxleWidth=60,AxleOffset=72,AxleHeight=13,DifferentialLock=0.5,AxleProps=(MomentOfInertia=4),WheelProps=(SteerRatio=1,BrakeRatio=5,HandbrakeRatio=0,FrictionStatic=3,FrictionDynamic=3,FrictionRolling=0.002,StiffnessLateral=18.75,StiffnessLongitudinal=18.75,Restitution=0.4,SuspensionSpringLength=16,SuspensionSpringDamping=7000,SuspensionSpringStiffness=70000,Radius=36,Mass=10,WheelClass='MonsterTruckSpecialPart_Tire'),HandbrakeWheelProps=(SteerRatio=1,BrakeRatio=1,HandbrakeRatio=0,FrictionStatic=5.6,FrictionDynamic=5.4,FrictionRolling=0.002,StiffnessLateral=9.375,StiffnessLongitudinal=9.375,Restitution=0.4,SuspensionSpringLength=16,SuspensionSpringDamping=7000,SuspensionSpringStiffness=70000,Radius=36,Mass=10,WheelClass='CarSpecialPart_Tire'),AxleDifferential=none,Wheels=none,Wheels[1]=none)
	RearAxle=(DifferentialClass=none,WheelClass=none,AxleBaseTag=None,AxleWidth=60,AxleOffset=-72,AxleHeight=3,DifferentialLock=0.5,AxleProps=(MomentOfInertia=4),WheelProps=(SteerRatio=0,BrakeRatio=5,HandbrakeRatio=1,FrictionStatic=16,FrictionDynamic=16,FrictionRolling=0.002,StiffnessLateral=25,StiffnessLongitudinal=25,Restitution=0.4,SuspensionSpringLength=16,SuspensionSpringDamping=7000,SuspensionSpringStiffness=70000,Radius=36,Mass=10,WheelClass='MonsterTruckSpecialPart_Tire'),HandbrakeWheelProps=(SteerRatio=-1,BrakeRatio=1,HandbrakeRatio=1,FrictionStatic=5.6,FrictionDynamic=5.4,FrictionRolling=0.002,StiffnessLateral=2.5,StiffnessLongitudinal=2.5,Restitution=0.4,SuspensionSpringLength=16,SuspensionSpringDamping=7000,SuspensionSpringStiffness=70000,Radius=36,Mass=10,WheelClass='CarSpecialPart_Tire'),AxleDifferential=none,Wheels=none,Wheels[1]=none)
	FrontRearDifferential=0.5
	FrontRearDifferentialLock=0.5
	GearSounds(0)=(Z=/* Unknown default property type! */,Vector=false,StopOnFootOffRule=0,UpshiftLoopName=First_UpShiftLoop,DownshiftLoopName=None,FootOffSlowName=FootOffSlow,FootOffFastName=FootOffFast)
	GearSounds(1)=(bStopOnFootOff=false,StopOnFootOffRule=0,UpshiftLoopName=First_UpShiftLoop,DownshiftLoopName=None,FootOffSlowName=FootOffSlow,FootOffFastName=FootOffFast)
	GearSounds(2)=(EngineSoundVolume=0.9,MinRPMPitchAdjust=-0.3,MaxRPMPitchAdjust=0.3,BoostPitchAdjust=0.1,InAirPitchAdjust=0.15,EngineSoundOffset=(X=1.291997E-41,Y=2.81364E-17,Z=0),Z=54)
	GearSounds(3)=(GearboxProps=(GearRatios=/* Array type was not detected. */,Yaw=-1082130432))
	GearSounds(4)=none
	GearSounds(5)=(bNoDoppler="",bNoDoppler=/* Unknown default property type! */,VolumePrefab=/* Unknown default property type! */)
	GearSounds(6)=none
	GearSounds(7)=none
	GearSounds(8)=none
	GearSounds(9)=(MotorProps=(MotorConstants=70000,MotorConstants[1]=0,MotorConstants[2]=0,MotorConstants[3]=0,MotorConstants[4]=714,MotorConstants[5]=0),bHasBoost=true,BoostMotorProps=(MotorConstants=280000,MotorConstants[1]=0,MotorConstants[2]=0,MotorConstants[3]=0,MotorConstants[4]=3150,MotorConstants[5]=0),CrashVelocity=1000,VelDotGravity=0.45,ImpactRumbleThreshold=850,bPerformImpactEffects=true,bPerformLandingEffects=true,NeutralSteeringAdjust=0.0001,SteerMaxAngles=(Pitch=8710,Yaw=571015168,Roll=6060),Roll=0)
	GearSounds(10)=(NeutralBrakeTorque=1500000,VehicleMinNeutralTransitionTime=0.125,LowSpeed=150,LowSpeedBrakeTorque=4E+07,HighSpeed=300,WheelMassType=2,bAdjustWheelFrictionForSlope=true,bIgnition=false,ControlStiffness=9216,ForwardVelocityThreshold=100,DrivenAvoidRangeMin=150,DrivenAvoidRange=700,UpwardCorpseBoost=0.5,UpwardCorpseBoostRnd=0,ForwardCorpseBoost=0.5,ForwardCorpseBoostRnd=0,VehicleKillLineChance=0.4,VehicleKillLine=MT_KillLines,FlipThreshold=0.3,FlipTotalTime=0.75,FlipTorque=2,FlipLift=0.15,ViewDist=320,ViewElevationAngle=2560,ViewFocusOffset=(X=1.291997E-41,Y=2.802832E-17,Z=0),Z=68)
	GearSounds(11)=(DriverLegsIdleAnim=MonsterTruck_LegsIdle,VehicleSensorRadius=120,VehicleSensorHeight=40,GravityRange=(Min=0.733333,Max=1.2),GravityTimestepRange=(Min=0.006667,Max=0.026667),DecoActivities_Default=/* Array type was not detected. */,Z=SDecoActivitiesData,SoundLocationOverride=/* Unknown default property type! */,dnVehicles=/* Unknown default property type! */)
	GearSounds(12)=none
	GearSounds(13)=none
	GearSounds(14)=none
	GearSounds(15)=(NextPerformTime=0,NextPerformTime_Failure=0)
	GearSounds(16)=(ActivityIDScript=/* Array type was not detected. */,Vector=87,StructProperty=(Yaw=/* Unknown default property type! */),ActivityMethod=0,ActivityStates_Success=/* Array type was not detected. */)
	GearSounds(17)=(ActivityStates_Failure=/* Array type was not detected. */)
	GearSounds(18)=(ActivityDebugID="",Activities=/* Array type was not detected. */,ActivityRules=/* Array type was not detected. */)
	GearSounds(19)=(ActivityElements=/* Array type was not detected. */,Y=/* Unknown default property type! */,Roll=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=/* Array type was not detected. */)
	GearSounds(20)=(FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))
	GearSounds(21)=(bDisabled=false)
	GearSounds(22)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=/* Array type was not detected. */,Vector=66,X=(Yaw=/* Unknown default property type! */),ActivityMethod=0,ActivityStates_Success=/* Array type was not detected. */)
	GearSounds(23)=(ActivityStates_Failure=/* Array type was not detected. */)
	GearSounds(24)=(ActivityDebugID="",Activities=/* Array type was not detected. */,ActivityRules=/* Array type was not detected. */)
	GearSounds(25)=(ActivityElements=/* Array type was not detected. */,Y=/* Unknown default property type! */,Roll=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=/* Array type was not detected. */)
	GearSounds(26)=(FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))
	GearSounds(27)=(bDisabled=false)
	GearSounds(28)=(MountOnSpawn=/* Array type was not detected. */,Yaw=2,dnVehicles=/* Unknown default property type! */,SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=1.291997E-41,Y=2.797242E-17,Z=0),Z=66),MountOriginVariance=(X=1.291997E-41,Y=2.797242E-17,Z=0),Z=0)
	GearSounds(29)=(MountAngles=(Pitch=8710,Yaw=571015168,Roll=0),Roll=0)
	GearSounds(30)=(MountAnglesVariance=(Pitch=8710,Yaw=571015168,Roll=0),Roll=0)
	GearSounds(31)=(MountType=0,DismountPhysics=0)
	GearSounds(32)=(RenderObject=none,DrawScale=0)
	GearSounds(33)=(bSkipVerifySelf=false,SpawnClass='MonsterTruckSpecialPart_SteeringWheel',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-1.593777E-23,Y=2.802859E-17,Z=0),Z=62.8),MountOriginVariance=(X=1.291997E-41,Y=2.797242E-17,Z=0),Z=0)
	GearSounds(34)=(MountAngles=(Pitch=775496198,Yaw=571015168,Roll=0),Roll=0)
	GearSounds(35)=(MountAnglesVariance=(Pitch=8710,Yaw=571015168,Roll=0),Roll=0)
	GearSounds(36)=(MountType=0,DismountPhysics=0)
	GearSounds(37)=(RenderObject=none,DrawScale=0)
	GearSounds(38)=(bSkipVerifySelf=false,SpawnClass='dnGame.VehicleSensor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=1.291997E-41,Y=2.797242E-17,Z=0),Z=30),MountOriginVariance=(X=1.291997E-41,Y=2.797242E-17,Z=0),Z=0)
	GearSounds(39)=(MountAngles=(Pitch=8710,Yaw=571015168,Roll=0),Roll=0)
	GearSounds(40)=(MountAnglesVariance=(Pitch=8710,Yaw=571015168,Roll=0),Roll=0)
	GearSounds(41)=(MountType=0,DismountPhysics=0)
	GearSounds(42)=(RenderObject=none,DrawScale=0)
	GearSounds(43)=(bSkipVerifySelf=false,SpawnClass=none,SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=1.291997E-41,Y=2.797242E-17,Z=0),Z=0),MountOriginVariance=(X=1.291997E-41,Y=2.797242E-17,Z=0),Z=0)
	GearSounds(44)=(MountAngles=(Pitch=8710,Yaw=571015168,Roll=0),Roll=0)
	GearSounds(45)=(MountAnglesVariance=(Pitch=8710,Yaw=571015168,Roll=0),Roll=0)
	GearSounds(46)=(MountType=0,DismountPhysics=0)
	GearSounds(47)=(RenderObject=none,DrawScale=0)
	GearSounds(48)=(bSkipVerifySelf=false,SpawnClass='MonsterTruckSpecialPart_Suspension',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=1.291997E-41,Y=2.797242E-17,Z=0),Z=25),MountOriginVariance=(X=1.291997E-41,Y=2.797242E-17,Z=0),Z=0)
	GearSounds(49)=(MountAngles=(Pitch=8710,Yaw=571015168,Roll=0),Roll=0)
	GearSounds(50)=(MountAnglesVariance=(Pitch=8710,Yaw=571015168,Roll=0),Roll=0)
	GearSounds(51)=(MountType=0,DismountPhysics=0)
	GearSounds(52)=(RenderObject=none,DrawScale=0)
	GearSounds(53)=(bSkipVerifySelf=false,SpawnClass='dnDecorations.dnControl_GasTank',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=GasTank1,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=1.291997E-41,Y=2.813589E-17,Z=-42),Z=34.75),MountOriginVariance=(X=1.291997E-41,Y=2.797242E-17,Z=0),Z=0)
	GearSounds(54)=(MountAngles=(Pitch=8710,Yaw=571015168,Roll=-16384),Roll=0)
	GearSounds(55)=(MountAnglesVariance=(Pitch=8710,Yaw=571015168,Roll=0),Roll=0)
	GearSounds(56)=(MountType=0,DismountPhysics=0)
	GearSounds(57)=(RenderObject=none,DrawScale=0)
	GearSounds(58)=(bSkipVerifySelf=false,SpawnClass='dnDecorations.dnControl_GasTank',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=GasTank2,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=1.291997E-41,Y=2.813589E-17,Z=42),Z=34.75),MountOriginVariance=(X=1.291997E-41,Y=2.797242E-17,Z=0),Z=0)
	GearSounds(59)=(MountAngles=(Pitch=8710,Yaw=571015168,Roll=16384),Roll=0)
	GearSounds(60)=(MountAnglesVariance=(Pitch=8710,Yaw=571015168,Roll=0),Roll=0)
}