/*******************************************************************************
 * Veh_TankTemplate generated by Eliot.UELib using UELib.CLI.
 * Eliot.UELib © 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Veh_TankTemplate extends Vehicle_MeqonWheeled
	collapsecategories;

const NUM_VWHEEL_PER_TREAD = 4;

struct STankTreadMaterialProperties
{
	var() noexport MaterialEx TreadMaterial "Material to use in the TexPanner for this tread.";
	var() noexport int TreadSectionIndex "Section on the mesh for this tread.";
	var() noexport float PanRate "Rate at which this tread's texture would pan for maximum forward.  (Scaled by input given to tread which will be -1.0 to 1.0).";
	var() noexport Rotator PanDirection "Direction to pan the texture.";
};

struct SWheelInfo
{
	var() Vector WheelOffset;
	var() bool bUseWheelClass;
};

struct STankTreadInfo
{
	var() noexport SWheelInfo WheelInfo[4] "Offset from origin of vehicle to place virtual wheel. 0 - front, 1 - mid, 2 - back.";
	var() noexport SVehiclePhysicsWheelProperties WheelProps "Properties to apply to all the wheels.";
	var() noexport SVehiclePhysicsAxleProperties WheelAxleProps "Axle properties to apply to all the wheels.";
	var() noexport SVehiclePhysicsAxleProperties PrimaryAxleProps "Axle properties to apply to the primary axle for this tread.";
	var() noexport SVehiclePhysicsMotorProperties MotorProps "Properties to apply to the motor.";
	var() noexport SVehiclePhysicsAxleProperties MotorAxleProps "Axle properties to apply to all the wheels.";
	var() noexport SVehiclePhysicsGearboxProperties GearboxProps "Properties to apply to the gearbox.";
	var() noexport STankTreadMaterialProperties MaterialProps "Properties about the material for this tread.";
	var array<VehicleComponent> Components;
	var TexPanner TreadPanner;
};

var() STankTreadInfo RightTread;
var() STankTreadInfo LeftTread;
var() noexport float PivotInputScale "Used to scale down inputs when turning in place.  Anything over 1.0 is ignored.";
var() noexport float DriveTurnRatio "The ratio of the turning wheels' acceleration to the outer wheels' acceleration.";
var() noexport float TurnSpeedScale "Scales the speed while turning";
var() const class<VDifferential> DifferentialClass;
var() const class<VMotor> MotorClass;
var() const class<VGearbox> GearboxClass;
var() const class<VAxle> AxleClass;
var() const class<VWheel> WheelClass;
var float DriverAccel;
var float DriverHeading;
var float RightInput;
var float LeftInput;
var float DesiredRightInput;
var float DesiredLeftInput;
var bool bIsMoving;
var(VehicleSound) noexport name EngineStartSoundName "VoicePack entry to play when we start our engine.";
var(VehicleSound) noexport name EngineStopSoundName "VoicePack entry to play when we stop our engine.";
var(VehicleSound) array<SVehicleGearSounds> GearSounds;
var(VehicleSound) float EngineSoundVolume;
var Engine.Object.ESoundSlot LastEngineSlot;
var float EngineSoundStartTime;
var VGearbox Gearbox;
var bool bWasAccel;
var int LastGearIndex;
var float SpinRateThreshold;

function PreBeginPlay()
{
	super.PreBeginPlay();
	InitializeTread(RightTread, RightTread.Components, RightTread.TreadPanner);
	InitializeTread(LeftTread, LeftTread.Components, LeftTread.TreadPanner);
	return;
}

function InitializeTread(STankTreadInfo TreadInfo, out array<VehicleComponent> Components, out TexPanner TreadPanner)
{
	local class<VMotor> LocalMotorClass;
	local class<VGearbox> LocalGearboxClass;
	local class<VAxle> LocalAxleClass;
	local class<VDifferential> LocalDifferentialClass;
	local class<VWheel> LocalWheelClass;
	local int i, j;
	local VDifferential PrimaryDifferential, SecondaryDifferentialA, SecondaryDifferentialB;
	local VAxle PrimaryAxle, SecondaryAxleA, SecondaryAxleB;
	local VWheel Wheel[4];
	local VMotor motor;

	LocalMotorClass = MotorClass;
	LocalGearboxClass = GearboxClass;
	LocalAxleClass = AxleClass;
	LocalDifferentialClass = DifferentialClass;
	LocalWheelClass = WheelClass;
	// End:0x4E
	if(__NFUN_339__(LocalMotorClass, none))
	{
		LocalMotorClass = class'VMotor';
	}
	// End:0x65
	if(__NFUN_339__(LocalGearboxClass, none))
	{
		LocalGearboxClass = class'VGearbox';
	}
	// End:0x7C
	if(__NFUN_339__(LocalAxleClass, none))
	{
		LocalAxleClass = class'VAxle';
	}
	// End:0x93
	if(__NFUN_339__(LocalDifferentialClass, none))
	{
		LocalDifferentialClass = class'VDifferential';
	}
	// End:0xAA
	if(__NFUN_339__(LocalWheelClass, none))
	{
		LocalWheelClass = class'VWheel';
	}
	i = 0;
	J0xB1:

	// End:0x213 [Loop If]
	if(__NFUN_169__(i, 4))
	{
		Wheel[i] = new (Level.XLevel) LocalWheelClass;
		Wheel[i].SetWheelOffsets(self, TreadInfo.WheelInfo[i].WheelOffset);
		Wheel[i].WheelProps = TreadInfo.WheelProps;
		Wheel[i].AxleProps = TreadInfo.WheelAxleProps;
		Wheel[i].bCaresAboutAcceleration = false;
		Components[Components.Add(1)] = Wheel[i];
		// End:0x209
		if(__NFUN_148__(__NFUN_148__(TreadInfo.WheelInfo[i].bUseWheelClass, __NFUN_340__(TreadInfo.WheelProps.WheelClass, none)), __NFUN_357__(TreadInfo.WheelProps.WheelClass, class'VehicleSpecialPart_TireEx')))
		{
			MountOnSpawn[MountOnSpawn.Add(1)].SpawnClass = class<VehicleSpecialPart_TireEx>(TreadInfo.WheelProps.WheelClass);
			Wheel[i].bHasTireActor = true;
		}
		__NFUN_184__(i);
		// [Loop Continue]
		goto J0xB1;
	}
	motor = new (Level.XLevel) LocalMotorClass;
	motor.AxleProps = TreadInfo.MotorAxleProps;
	motor.MotorProps = TreadInfo.MotorProps;
	motor.bCaresAboutAcceleration = false;
	Components[Components.Add(1)] = motor;
	Gearbox = new (Level.XLevel) LocalGearboxClass;
	Gearbox.GearboxProps = TreadInfo.GearboxProps;
	Gearbox.bCaresAboutAcceleration = false;
	Components[Components.Add(1)] = Gearbox;
	PrimaryAxle = new (Level.XLevel) LocalAxleClass;
	PrimaryAxle.AxleProps = TreadInfo.PrimaryAxleProps;
	Gearbox.PrimaryAxle = motor;
	Gearbox.SecondaryAxle = PrimaryAxle;
	SecondaryAxleA = new (Level.XLevel) LocalAxleClass;
	SecondaryAxleA.AxleProps = TreadInfo.PrimaryAxleProps;
	SecondaryAxleB = new (Level.XLevel) LocalAxleClass;
	SecondaryAxleB.AxleProps = TreadInfo.PrimaryAxleProps;
	PrimaryDifferential = new (Level.XLevel) LocalDifferentialClass;
	PrimaryDifferential.Ratio = 0.5;
	PrimaryDifferential.Lock = 1;
	PrimaryDifferential.InputAxle = PrimaryAxle;
	PrimaryDifferential.PrimaryOutputAxle = SecondaryAxleA;
	PrimaryDifferential.SecondaryOutputAxle = SecondaryAxleB;
	SecondaryDifferentialA = new (Level.XLevel) LocalDifferentialClass;
	SecondaryDifferentialA.Ratio = 0.5;
	SecondaryDifferentialA.Lock = 1;
	SecondaryDifferentialA.InputAxle = SecondaryAxleA;
	SecondaryDifferentialA.PrimaryOutputAxle = Wheel[0];
	SecondaryDifferentialA.SecondaryOutputAxle = Wheel[1];
	SecondaryDifferentialB = new (Level.XLevel) LocalDifferentialClass;
	SecondaryDifferentialB.Ratio = 0.5;
	SecondaryDifferentialB.Lock = 1;
	SecondaryDifferentialB.InputAxle = SecondaryAxleB;
	SecondaryDifferentialB.PrimaryOutputAxle = Wheel[2];
	SecondaryDifferentialB.SecondaryOutputAxle = Wheel[3];
	i = 0;
	J0x557:

	// End:0x57E [Loop If]
	if(__NFUN_169__(i, 4))
	{
		MaybeInitializeVehicleComponent(Wheel[i]);
		__NFUN_184__(i);
		// [Loop Continue]
		goto J0x557;
	}
	MaybeInitializeVehicleComponent(PrimaryAxle);
	MaybeInitializeVehicleComponent(SecondaryAxleA);
	MaybeInitializeVehicleComponent(SecondaryAxleB);
	MaybeInitializeVehicleComponent(PrimaryDifferential);
	MaybeInitializeVehicleComponent(SecondaryDifferentialA);
	MaybeInitializeVehicleComponent(SecondaryDifferentialB);
	MaybeInitializeVehicleComponent(Gearbox);
	MaybeInitializeVehicleComponent(motor);
	// End:0x672
	if(__NFUN_172__(TreadInfo.MaterialProps.TreadSectionIndex, 0))
	{
		TreadPanner = new (Level.XLevel) class'TexPanner';
		TreadPanner.Material = TreadInfo.MaterialProps.TreadMaterial;
		TreadPanner.PanDirection = TreadInfo.MaterialProps.PanDirection;
		TreadPanner.PanRate = 0;
		__NFUN_741__(TreadInfo.MaterialProps.TreadSectionIndex, TreadPanner);
	}
	return;
}

final simulated function PlayEngineSound(name EngineSoundName, optional bool bStopLast, optional Engine.Object.EStopSoundRule StopSoundRule, optional float FadeOutTime)
{
	local int Index;

	// End:0x1A
	if(__NFUN_204__(FadeOutTime, 0))
	{
		FadeOutTime = 0.2;
	}
	// End:0x52
	if(__NFUN_684__(LastEngineSlot))
	{
		// End:0x3E
		if(bStopLast)
		{
			__NFUN_695__(LastEngineSlot, StopSoundRule);			
		}
		else
		{
			__NFUN_698__(LastEngineSlot, FadeOutTime, 0, 1);
		}
	}
	// End:0x161
	if(__NFUN_148__(__NFUN_342__(EngineSoundName, 'None'), FindSoundIndex(EngineSoundName, Index)))
	{
		// End:0x90
		if(__NFUN_173__(int(LastEngineSlot), int(22)))
		{
			LastEngineSlot = 23;			
		}
		else
		{
			LastEngineSlot = 22;
		}
		// End:0xDE
		if(__NFUN_170__(string(VoicePack.default.CharacterSounds[Index].SoundInfo.Slots), 1))
		{
			VoicePack.default.CharacterSounds[Index].SoundInfo.Slots.Empty();
		}
		VoicePack.default.CharacterSounds[Index].SoundInfo.Slots[0] = LastEngineSlot;
		VoicePack.default.CharacterSounds[Index].SoundInfo.Volume = EngineSoundVolume;
		PlaySoundInfo(1, VoicePack.default.CharacterSounds[Index].SoundInfo);
		EngineSoundStartTime = Level.GameTimeSeconds;
	}
	return;
}

simulated function TurnIgnitionOn()
{
	super(VehicleBase).TurnIgnitionOn();
	PlayEngineSound(EngineStartSoundName);
	return;
}

simulated function TurnIgnitionOff()
{
	super(VehicleBase).TurnIgnitionOff();
	PlayEngineSound(EngineStopSoundName);
	return;
}

final simulated function UpdateInputs(float DeltaTime)
{
	local int i;
	local Pawn Driver;
	local float LastLeftInput, LastRightInput;

	// End:0x28
	if(__NFUN_204__(DriverHeading, 0))
	{
		DesiredLeftInput = DriverAccel;
		DesiredRightInput = DriverAccel;		
	}
	else
	{
		// End:0x60
		if(__NFUN_204__(DriverAccel, 0))
		{
			DesiredLeftInput = __NFUN_195__(__NFUN_194__(DriverHeading), PivotInputScale);
			DesiredRightInput = __NFUN_195__(DriverHeading, PivotInputScale);			
		}
		else
		{
			// End:0x10E
			if(__NFUN_201__(DriverAccel, 0))
			{
				// End:0xC4
				if(__NFUN_201__(DriverHeading, 0))
				{
					DesiredLeftInput = __NFUN_195__(DriverAccel, __NFUN_228__(DriverHeading, 1, __NFUN_195__(DriveTurnRatio, TurnSpeedScale)));
					DesiredRightInput = __NFUN_195__(DriverAccel, __NFUN_228__(DriverHeading, 1, TurnSpeedScale));					
				}
				else
				{
					DesiredLeftInput = __NFUN_195__(DriverAccel, __NFUN_228__(__NFUN_194__(DriverHeading), 1, TurnSpeedScale));
					DesiredRightInput = __NFUN_195__(DriverAccel, __NFUN_228__(__NFUN_194__(DriverHeading), 1, __NFUN_195__(DriveTurnRatio, TurnSpeedScale)));
				}				
			}
			else
			{
				// End:0x163
				if(__NFUN_201__(DriverHeading, 0))
				{
					DesiredLeftInput = __NFUN_195__(DriverAccel, __NFUN_228__(DriverHeading, 1, __NFUN_195__(DriveTurnRatio, TurnSpeedScale)));
					DesiredRightInput = __NFUN_195__(DriverAccel, __NFUN_228__(DriverHeading, 1, TurnSpeedScale));					
				}
				else
				{
					DesiredLeftInput = __NFUN_195__(DriverAccel, __NFUN_228__(__NFUN_194__(DriverHeading), 1, TurnSpeedScale));
					DesiredRightInput = __NFUN_195__(DriverAccel, __NFUN_228__(__NFUN_194__(DriverHeading), 1, __NFUN_195__(DriveTurnRatio, TurnSpeedScale)));
				}
			}
		}
	}
	LastRightInput = RightInput;
	LastLeftInput = LeftInput;
	// End:0x202
	if(__NFUN_206__(RightInput, DesiredRightInput))
	{
		RightInput = __NFUN_227__(__NFUN_198__(RightInput, __NFUN_195__(__NFUN_195__(__NFUN_199__(DesiredRightInput, RightInput), 10), DeltaTime)), -1, 1);
	}
	// End:0x244
	if(__NFUN_206__(LeftInput, DesiredLeftInput))
	{
		LeftInput = __NFUN_227__(__NFUN_198__(LeftInput, __NFUN_195__(__NFUN_195__(__NFUN_199__(DesiredLeftInput, LeftInput), 10), DeltaTime)), -1, 1);
	}
	// End:0x28C
	if(__NFUN_150__(__NFUN_148__(__NFUN_201__(LastRightInput, 0), __NFUN_200__(RightInput, 0)), __NFUN_148__(__NFUN_200__(LastRightInput, 0), __NFUN_201__(RightInput, 0))))
	{
		RightTreadChangedDirection();
	}
	// End:0x2D4
	if(__NFUN_150__(__NFUN_148__(__NFUN_201__(LastLeftInput, 0), __NFUN_200__(LeftInput, 0)), __NFUN_148__(__NFUN_200__(LastLeftInput, 0), __NFUN_201__(LeftInput, 0))))
	{
		LeftTreadChangedDirection();
	}
	Driver = VehicleGetDriver();
	// End:0x342
	if(__NFUN_200__(__NFUN_211__(RightInput), 1E-05))
	{
		i = __NFUN_166__(string(RightTread.Components), 1);
		J0x305:

		// End:0x33F [Loop If]
		if(__NFUN_172__(i, 0))
		{
			RightTread.Components[i].AcceleratorNeutral(self, __NFUN_339__(Driver, none));
			__NFUN_185__(i);
			// [Loop Continue]
			goto J0x305;
		}		
	}
	else
	{
		i = __NFUN_166__(string(RightTread.Components), 1);
		J0x356:

		// End:0x38C [Loop If]
		if(__NFUN_172__(i, 0))
		{
			RightTread.Components[i].AcceleratorAdjust(self, RightInput);
			__NFUN_185__(i);
			// [Loop Continue]
			goto J0x356;
		}
	}
	// End:0x3EE
	if(__NFUN_200__(__NFUN_211__(LeftInput), 1E-05))
	{
		i = __NFUN_166__(string(LeftTread.Components), 1);
		J0x3B1:

		// End:0x3EB [Loop If]
		if(__NFUN_172__(i, 0))
		{
			LeftTread.Components[i].AcceleratorNeutral(self, __NFUN_339__(Driver, none));
			__NFUN_185__(i);
			// [Loop Continue]
			goto J0x3B1;
		}		
	}
	else
	{
		i = __NFUN_166__(string(LeftTread.Components), 1);
		J0x402:

		// End:0x438 [Loop If]
		if(__NFUN_172__(i, 0))
		{
			LeftTread.Components[i].AcceleratorAdjust(self, LeftInput);
			__NFUN_185__(i);
			// [Loop Continue]
			goto J0x402;
		}
	}
	// End:0x461
	if(__NFUN_148__(__NFUN_204__(LeftInput, 0), __NFUN_204__(RightInput, 0)))
	{
		EnableHandBrake();		
	}
	else
	{
		DisableHandBrake();
	}
	// End:0x4A3
	if(__NFUN_340__(RightTread.TreadPanner, none))
	{
		RightTread.TreadPanner.PanRate = __NFUN_195__(RightTread.MaterialProps.PanRate, RightInput);
	}
	// End:0x4DF
	if(__NFUN_340__(LeftTread.TreadPanner, none))
	{
		LeftTread.TreadPanner.PanRate = __NFUN_195__(LeftTread.MaterialProps.PanRate, LeftInput);
	}
	return;
}

simulated function Tick_Internal(float DeltaTime)
{
	local Vector KAngVelocity;
	local float CurrentSpinRate;
	local bool bWasMoving, bIsAccel;
	local int GearIndex;
	local SVehicleGearSounds GearSound;

	bWasMoving = bIsMoving;
	super(VehicleBase).Tick_Internal(DeltaTime);
	UpdateInputs(DeltaTime);
	__NFUN_795__(KAngVelocity);
	CurrentSpinRate = __NFUN_211__(KAngVelocity.Z);
	bIsMoving = __NFUN_150__(__NFUN_201__(CurrentSpinRate, SpinRateThreshold), __NFUN_174__(int(oVehicleDirection), int(1)));
	// End:0x121
	if(__NFUN_148__(__NFUN_172__(GearIndex, 0), __NFUN_169__(GearIndex, string(GearSounds))))
	{
		GearSound.bStopOnFootOff = GearSounds[GearIndex].bStopOnFootOff;
		GearSound.StopOnFootOffRule = GearSounds[GearIndex].StopOnFootOffRule;
		GearSound.UpshiftLoopName = GearSounds[GearIndex].UpshiftLoopName;
		GearSound.DownshiftLoopName = GearSounds[GearIndex].DownshiftLoopName;
		GearSound.FootOffFastName = GearSounds[GearIndex].FootOffFastName;
		GearSound.FootOffSlowName = GearSounds[GearIndex].FootOffSlowName;
	}
	// End:0x1C6
	if(__NFUN_147__(bIsMoving, bWasMoving))
	{
		// End:0x154
		if(bIsMoving)
		{
			HandleTankStartedMoving();
			PlayEngineSound(GearSound.UpshiftLoopName);			
		}
		else
		{
			HandleTankStoppedMoving();
			// End:0x1A1
			if(__NFUN_148__(__NFUN_684__(LastEngineSlot), __NFUN_203__(__NFUN_689__(LastEngineSlot), 0)))
			{
				PlayEngineSound(GearSound.FootOffFastName, GearSound.bStopOnFootOff, GearSound.StopOnFootOffRule);				
			}
			else
			{
				PlayEngineSound(GearSound.FootOffSlowName, GearSound.bStopOnFootOff, GearSound.StopOnFootOffRule);
			}
		}
	}
	GearIndex = Gearbox.CurrentGear;
	bWasAccel = bIsAccel;
	LastGearIndex = GearIndex;
	return;
}

simulated function HandleTankStartedMoving()
{
	DecoActivity(0, 'TankStartedMoving');
	return;
}

simulated function HandleTankStoppedMoving()
{
	DecoActivity(0, 'TankStoppedMoving');
	return;
}

function RightTreadChangedDirection()
{
	return;
}

function LeftTreadChangedDirection()
{
	return;
}

simulated function Accelerator_Adjust(float DeltaTime, float RelativeAcceleration, Pawn Driver)
{
	super.Accelerator_Adjust(DeltaTime, RelativeAcceleration, Driver);
	DriverAccel = RelativeAcceleration;
	return;
}

simulated function Accelerator_Neutral(float DeltaTime, optional bool bNoDriver)
{
	super.Accelerator_Neutral(DeltaTime, bNoDriver);
	DriverAccel = 0;
	return;
}

simulated function Heading_Adjust(float DeltaTime, float TurnPercent)
{
	super.Heading_Adjust(DeltaTime, TurnPercent);
	DriverHeading = TurnPercent;
	return;
}

simulated function Heading_Neutral(float DeltaTime)
{
	super.Heading_Neutral(DeltaTime);
	DriverHeading = 0;
	return;
}

simulated event bool CanAccelerateForwards()
{
	return true;
	return;
}

simulated event bool CanAccelerateReverse()
{
	return true;
	return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
	local int i;

	super(VehicleBase).RegisterPrecacheComponents(PrecacheIndex);
	PrecacheIndex.__NFUN_1266__(RightTread.WheelProps.WheelClass);
	PrecacheIndex.__NFUN_1269__(RightTread.MaterialProps.TreadMaterial);
	PrecacheIndex.__NFUN_1266__(LeftTread.WheelProps.WheelClass);
	PrecacheIndex.__NFUN_1269__(LeftTread.MaterialProps.TreadMaterial);
	PrecacheIndex.__NFUN_1277__(VoicePack, EngineStartSoundName);
	PrecacheIndex.__NFUN_1277__(VoicePack, EngineStopSoundName);
	i = __NFUN_166__(string(GearSounds), 1);
	J0xB8:

	// End:0x155 [Loop If]
	if(__NFUN_172__(i, 0))
	{
		PrecacheIndex.__NFUN_1277__(VoicePack, GearSounds[i].UpshiftLoopName);
		PrecacheIndex.__NFUN_1277__(VoicePack, GearSounds[i].DownshiftLoopName);
		PrecacheIndex.__NFUN_1277__(VoicePack, GearSounds[i].FootOffSlowName);
		PrecacheIndex.__NFUN_1277__(VoicePack, GearSounds[i].FootOffFastName);
		__NFUN_185__(i);
		// [Loop Continue]
		goto J0xB8;
	}
	return;
}

defaultproperties
{
	PivotInputScale=0.7
	DriveTurnRatio=0.25
	TurnSpeedScale=1
	EngineStartSoundName=EngineStart
	EngineStopSoundName=EngineStop
	EngineSoundVolume=1
	LastEngineSlot=23
	SpinRateThreshold=0.25
	ControlStiffness=16384
	ForwardVelocityThreshold=100
	HealthPrefab=0
	Mass=1000
}