/*******************************************************************************
 * Vehicle_MeqonWheeled generated by Eliot.UELib using UELib.CLI.
 * Eliot.UELib © 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Vehicle_MeqonWheeled extends VehicleBase
	native
	collapsecategories
	dependson(PhysicsAction_RightVehicle)
	dependson(VehicleComponent)
	dependson(VGearbox);

var(Vehicle) float NeutralSteeringAdjust;
var(Vehicle) Rotator SteerMaxAngles;
var(Vehicle) float BrakeTorque;
var(Vehicle) float NeutralBrakeTorque;
var(Vehicle) float NoDriverBrakeTorque;
var(Vehicle) float HandbrakeTorque;
var(Vehicle) float VehicleMinNeutralTransitionTime;
var(Vehicle) float MinDirectionalChangeSteerAlpha;
var(Vehicle) const export array<export VehicleComponent> VehicleComponents;
var array<VWheel> VWheels;
var(Vehicle) const float KLinearToleranceScale;
var(Vehicle) const float KAngularToleranceScale;
var(Vehicle) const int KMaximumIterations;
var(Vehicle) name EnableDriveTrainTag;
var(Vehicle) name DisableDriveTrainTag;
var(Vehicle) noexport float LowFriction "Low friction setting used when being driven or when being righted.";
var(Vehicle) noexport float HighFriction "High friction setting used when not being driven or when upside-down.";
var() noexport float LowSpeed "Absolute value of speed that we consider to be our low speed.";
var() noexport float LowSpeedBrakeTorque "Additional brake torque to apply at low vehicle speeds.";
var float LowSpeedPct;
var() noexport float HighSpeed "Absolute value of high speed";
var() float HighSpeedSteerPct;
var float HandbrakeActive;
var float SavedDisableThreshold;
var float AverageSteerAngle;
var float SteerAlpha;
var() class<PhysicsMaterial> WheelMaterialType;
var() Engine.Object.EPhysicsMassType WheelMassType;
var() noexport float WheelSkidMinTime "Car must be skidding for this much time before the sound will start playing";
var transient int WheelSkidDBIndex;
var const editconst transient pointer WheelSkidOverrideEntry;
var transient float WheelSkidStartTime;
var(Vehicle_SlopeSlip) noexport bool bAdjustWheelFrictionForSlope "If true, wheel friction will be adjusted based on the slope of the surface, so that steeper slope can give less friction";
var(Vehicle_SlopeSlip) noexport float FullTractionAngle "When using bAdjustWheelFrictionForSlope, this is the max angle of incline (in degrees) to provide full traction.  Acceptable values are 0 - 90.  Should be smaller than NoTractionAngle.";
var(Vehicle_SlopeSlip) noexport float NoTractionAngle "When using bAdjustWheelFrictionForSlope, this is the angle of incline (in degrees) when there will be no traction.  Acceptable values are 0 - 90.  Should be larger than FullTractionAngle.";

simulated event PreBeginPlay()
{
	super(dnDecoration).PreBeginPlay();
	FullTractionAngle = __NFUN_227__(FullTractionAngle, 0, 90);
	NoTractionAngle = __NFUN_227__(NoTractionAngle, FullTractionAngle, 90);
	__NFUN_808__(HighFriction);
	return;
}

simulated event PreGameInit()
{
	local int i, WheelIndex;
	local VWheel Wheel;
	local VehicleSpecialPart_TireEx Tire;

	super(dnDecoration).PreGameInit();
	i = __NFUN_166__(string(VehicleComponents), 1);
	J0x15:

	// End:0x3B [Loop If]
	if(__NFUN_172__(i, 0))
	{
		MaybeInitializeVehicleComponent(VehicleComponents[i]);
		__NFUN_185__(i);
		// [Loop Continue]
		goto J0x15;
	}
	WheelIndex = __NFUN_166__(string(VehicleParts), 1);
	i = __NFUN_166__(string(VWheels), 1);
	J0x59:

	// End:0x108 [Loop If]
	if(__NFUN_172__(i, 0))
	{
		Wheel = VWheels[i];
		// End:0x8D
		if(__NFUN_145__(Wheel.bHasTireActor))
		{
			// [Explicit Continue]
			goto J0xFE;
		}
		Tire = none;
		J0x94:

		// End:0xCD [Loop If]
		if(__NFUN_148__(__NFUN_172__(WheelIndex, 0), __NFUN_339__(Tire, none)))
		{
			Tire = VehicleSpecialPart_TireEx(VehicleParts[__NFUN_185__(WheelIndex)].Actor);
			// [Loop Continue]
			goto J0x94;
		}
		// End:0xDC
		if(__NFUN_339__(Tire, none))
		{
			// [Explicit Break]
			goto J0x108;
		}
		Tire.UpdateFromVWheel(Wheel);
		Tire.__NFUN_630__();
		J0xFE:

		__NFUN_185__(i);
		// [Loop Continue]
		goto J0x59;
	}
	J0x108:

	return;
}

simulated event PostVerifySelf()
{
	super(dnDecoration).PostVerifySelf();
	__NFUN_718__('EnableDriveTrain', EnableDriveTrainTag);
	__NFUN_718__('DisableDriveTrain', DisableDriveTrainTag);
	return;
}

function TriggerFunc_EnableDriveTrain()
{
	local int i;
	local VGearbox Gearbox;

	i = __NFUN_166__(string(VehicleComponents), 1);
	J0x0F:

	// End:0x65 [Loop If]
	if(__NFUN_172__(i, 0))
	{
		Gearbox = VGearbox(VehicleComponents[i]);
		// End:0x5B
		if(__NFUN_340__(Gearbox, none))
		{
			Gearbox.MaximumClutchTorque = Gearbox.default.MaximumClutchTorque;
		}
		__NFUN_185__(i);
		// [Loop Continue]
		goto J0x0F;
	}
	return;
}

function TriggerFunc_DisableDriveTrain()
{
	local int i;
	local VGearbox Gearbox;

	i = __NFUN_166__(string(VehicleComponents), 1);
	J0x0F:

	// End:0x5B [Loop If]
	if(__NFUN_172__(i, 0))
	{
		Gearbox = VGearbox(VehicleComponents[i]);
		// End:0x51
		if(__NFUN_340__(Gearbox, none))
		{
			Gearbox.MaximumClutchTorque = 0;
		}
		__NFUN_185__(i);
		// [Loop Continue]
		goto J0x0F;
	}
	return;
}

simulated function AddVehicleComponent(VehicleComponent Component)
{
	local VWheel Wheel;
	local int i;

	__NFUN_354__(__NFUN_340__(Component, none));
	i = __NFUN_166__(string(VehicleComponents), 1);
	J0x1B:

	// End:0x49 [Loop If]
	if(__NFUN_172__(i, 0))
	{
		// End:0x3F
		if(__NFUN_339__(VehicleComponents[i], Component))
		{
			// [Explicit Break]
			goto J0x49;
		}
		__NFUN_185__(i);
		// [Loop Continue]
		goto J0x1B;
	}
	J0x49:

	// End:0x6B
	if(__NFUN_173__(i, -1))
	{
		VehicleComponents[VehicleComponents.Add(1)] = Component;
	}
	Wheel = VWheel(Component);
	// End:0xE6
	if(__NFUN_340__(Wheel, none))
	{
		i = __NFUN_166__(string(VWheels), 1);
		J0x96:

		// End:0xC4 [Loop If]
		if(__NFUN_172__(i, 0))
		{
			// End:0xBA
			if(__NFUN_339__(VWheels[i], Wheel))
			{
				// [Explicit Break]
				goto J0xC4;
			}
			__NFUN_185__(i);
			// [Loop Continue]
			goto J0x96;
		}
		J0xC4:

		// End:0xE6
		if(__NFUN_173__(i, -1))
		{
			VWheels[VWheels.Add(1)] = Wheel;
		}
	}
	return;
}

simulated event DriverEntered(VehicleSpaceBase Space)
{
	super.DriverEntered(Space);
	__NFUN_808__(LowFriction);
	__NFUN_817__();
	return;
}

simulated event DriverLeft(VehicleSpaceBase Space)
{
	super.DriverLeft(Space);
	__NFUN_808__(HighFriction);
	return;
}

simulated function Heading_Adjust(float DeltaTime, float TurnPercent)
{
	local VWheel Wheel;
	local int i;
	local float DesiredAngle, diff;

	// End:0x51
	if(__NFUN_150__(__NFUN_148__(__NFUN_200__(SteerAlpha, __NFUN_194__(MinDirectionalChangeSteerAlpha)), __NFUN_201__(TurnPercent, 0)), __NFUN_148__(__NFUN_201__(SteerAlpha, MinDirectionalChangeSteerAlpha), __NFUN_200__(TurnPercent, 0))))
	{
		Heading_Neutral(DeltaTime);
		return;
	}
	i = __NFUN_166__(string(VWheels), 1);
	J0x60:

	// End:0x191 [Loop If]
	if(__NFUN_172__(i, 0))
	{
		Wheel = VWheels[i];
		// End:0xCD
		if(__NFUN_148__(__NFUN_148__(__NFUN_206__(HighSpeed, float(0)), __NFUN_206__(HighSpeedSteerPct, float(0))), __NFUN_201__(__NFUN_211__(oForwardVelocity), HighSpeed)))
		{
			DesiredAngle = __NFUN_195__(Wheel.WheelProps.SteerRatio, HighSpeedSteerPct);			
		}
		else
		{
			DesiredAngle = Wheel.WheelProps.SteerRatio;
		}
		__NFUN_207__(DesiredAngle, __NFUN_195__(TurnPercent, float(SteerMaxAngles.Yaw)));
		diff = __NFUN_199__(DesiredAngle, Wheel.CurrentSteeringAngle);
		// End:0x154
		if(__NFUN_200__(diff, 0))
		{
			__NFUN_209__(Wheel.CurrentSteeringAngle, __NFUN_225__(__NFUN_195__(__NFUN_194__(ControlStiffness), DeltaTime), diff));
			// [Explicit Continue]
			goto J0x187;
		}
		// End:0x187
		if(__NFUN_201__(diff, 0))
		{
			__NFUN_209__(Wheel.CurrentSteeringAngle, __NFUN_224__(__NFUN_195__(ControlStiffness, DeltaTime), diff));
		}
		J0x187:

		__NFUN_185__(i);
		// [Loop Continue]
		goto J0x60;
	}
	UpdateAverageSteeringAngle();
	return;
}

// Export UVehicle_MeqonWheeled::execHeading_NeutralNative(FFrame&, void* const)
native function Heading_NeutralNative(float DeltaTime)
{
	//native.DeltaTime;	
}

simulated function Heading_Neutral(float DeltaTime)
{
	Heading_NeutralNative(DeltaTime);
	return;
}

// Export UVehicle_MeqonWheeled::execUpdateAverageSteeringAngle(FFrame&, void* const)
native function UpdateAverageSteeringAngle();

simulated function Accelerator_Adjust(float DeltaTime, float RelativeAcceleration, Pawn Driver)
{
	local VehicleComponent Component;
	local int i;

	__NFUN_817__();
	LowSpeedPct = 0;
	i = __NFUN_166__(string(VehicleComponents), 1);
	J0x1D:

	// End:0x8F [Loop If]
	if(__NFUN_172__(i, 0))
	{
		Component = VehicleComponents[i];
		// End:0x85
		if(__NFUN_148__(__NFUN_148__(__NFUN_340__(Component, none), Component.bCaresAboutAcceleration), Component.bComponentInitialized))
		{
			Component.AcceleratorAdjust(self, RelativeAcceleration);
		}
		__NFUN_185__(i);
		// [Loop Continue]
		goto J0x1D;
	}
	return;
}

// Export UVehicle_MeqonWheeled::execAccelerator_NeutralNative(FFrame&, void* const)
native function Accelerator_NeutralNative(float DeltaTime, optional bool bNoDriver)
{
	//native.DeltaTime;
	//native.bNoDriver;	
}

simulated function Accelerator_Neutral(float DeltaTime, optional bool bNoDriver)
{
	Accelerator_NeutralNative(DeltaTime, bNoDriver);
	return;
}

simulated event bool CanAccelerateForwards()
{
	return __NFUN_150__(__NFUN_173__(int(oVehicleDirection), int(0)), __NFUN_148__(__NFUN_173__(int(oVehicleDirection), int(1)), __NFUN_203__(oVehicleNeutralTimer, VehicleMinNeutralTransitionTime)));
	return;
}

simulated event bool CanAccelerateReverse()
{
	return __NFUN_150__(__NFUN_173__(int(oVehicleDirection), int(2)), __NFUN_148__(__NFUN_173__(int(oVehicleDirection), int(1)), __NFUN_203__(oVehicleNeutralTimer, VehicleMinNeutralTransitionTime)));
	return;
}

simulated function HandBrakeEnabled()
{
	super.HandBrakeEnabled();
	__NFUN_817__();
	HandbrakeActive = 1;
	return;
}

simulated function HandBrakeDisabled()
{
	super.HandBrakeDisabled();
	__NFUN_817__();
	HandbrakeActive = 0;
	return;
}

simulated function bool IsHandbrakeEnabled()
{
	return __NFUN_201__(HandbrakeActive, 0);
	return;
}

final simulated function MaybeInitializeVehicleComponent(VehicleComponent Component)
{
	// End:0x28
	if(__NFUN_340__(Component, none))
	{
		Component.AttachToMeqonVehicle(self);
		AddVehicleComponent(Component);
	}
	return;
}

function StartFlip(Vector NewFlipAxis)
{
	local PhysicsAction_RightVehicle Action;

	__NFUN_808__(LowFriction);
	SavedDisableThreshold = EnableDisableThreshold;
	__NFUN_814__(0);
	Action = PhysicsAction_RightVehicle(__NFUN_824__(class'PhysicsAction_RightVehicle', true));
	Action.FlipRotationAxis = __NFUN_240__(NewFlipAxis, __NFUN_265__(Rotation.Pitch, Rotation.Yaw, 0));
	Action.FlipTorque = FlipTorque;
	Action.FlipLift = FlipLift;
	Action.FlipTimeLeft = FlipTotalTime;
	__NFUN_817__();
	__NFUN_607__(FlipTotalTime, false, 'FlipTimerEnded');
	return;
}

final function FlipTimerEnded()
{
	// End:0x26
	if(__NFUN_150__(__NFUN_339__(VehicleGetDriver(), none), __NFUN_200__(oUpness, FlipThreshold)))
	{
		__NFUN_808__(HighFriction);
	}
	// End:0x3D
	if(__NFUN_204__(EnableDisableThreshold, 0))
	{
		__NFUN_814__(SavedDisableThreshold);
	}
	return;
}

simulated event bool HasGroundContact()
{
	local int i;

	i = __NFUN_166__(string(VWheels), 1);
	J0x0F:

	// End:0x3F [Loop If]
	if(__NFUN_172__(i, 0))
	{
		// End:0x35
		if(VWheels[i].bOnGround)
		{
			return true;
		}
		__NFUN_185__(i);
		// [Loop Continue]
		goto J0x0F;
	}
	return false;
	return;
}

defaultproperties
{
	NeutralSteeringAdjust=0.001
	SteerMaxAngles=(Pitch=8710,Yaw=571015168,Roll=8192)
	BrakeTorque=5000000
	NeutralBrakeTorque=50000
	NoDriverBrakeTorque=2000000
	VehicleMinNeutralTransitionTime=0.25
	MinDirectionalChangeSteerAlpha=0.175
	KLinearToleranceScale=1
	KAngularToleranceScale=1
	KMaximumIterations=-1
	LowFriction=0.1
	HighFriction=0.65
	LowSpeed=5
	LowSpeedBrakeTorque=1000000
	WheelMaterialType='dnMaterial.dnPhysicsMaterial_Rubber'
	WheelMassType=1
	WheelSkidMinTime=0.07
	FullTractionAngle=30
	NoTractionAngle=50
	ControlType=1
	Physics=18
	bBlockKarma=true
	TransientSoundVolume=1
	TransientSoundRadius=1024
	TransientSoundInnerRadius=512
}