/*******************************************************************************
 * Vehicle_MeqonWheeled_Custom generated by Eliot.UELib using UELib.CLI.
 * Eliot.UELib © 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Vehicle_MeqonWheeled_Custom extends Vehicle_MeqonWheeled
	collapsecategories;

struct SCustomWheelDef
{
	var() bool bFlipWheel;
	var() Vector LocationOffset;
	var() Rotator RotationOffset;
	var() noexport float DrawScaleOverride "Set to something non-zero to override the default scale of the wheel class specified by WheelProps.";
};

var() noexport array<SCustomWheelDef> WheelDefs "A list of custom wheel definitions.";
var() noexport SVehiclePhysicsAxleProperties AxleProps "Axle properties.";
var() noexport SVehiclePhysicsWheelProperties WheelProps "Wheel properties.";
var() noexport name RollingSoundName "VoicePack entry to use for rolling sound.";
var() noexport float MaxRollingVelocity "Maximum input for velocity in rolling sound volume/pitch computations.";
var() noexport Range RollingVolumeRange "Min/Max output volume for rolling sound.";
var() noexport Range RollingPitchRange "Min/Max output pitch for rolling sound.";
var() noexport float RollingPitchFadeRate "Rate to transition rolling sound pitch.";
var bool bInAir;
var bool bJustLanded;

simulated event PreBeginPlay()
{
	local int i, j;
	local VWheel Wheel;

	i = 0;
	J0x07:

	// End:0x137 [Loop If]
	if(__NFUN_169__(i, string(WheelDefs)))
	{
		Wheel = new (Level.XLevel) class'VWheel';
		Wheel.SetWheelOffsets(self, WheelDefs[i].LocationOffset, WheelDefs[i].RotationOffset);
		Wheel.bFlipWheel = WheelDefs[i].bFlipWheel;
		Wheel.AxleProps = AxleProps;
		Wheel.WheelProps = WheelProps;
		// End:0x122
		if(__NFUN_340__(WheelProps.WheelClass, none))
		{
			Wheel.bHasTireActor = true;
			j = MountOnSpawn.Add(1);
			MountOnSpawn[j].SpawnClass = WheelProps.WheelClass;
			MountOnSpawn[j].MountPrefab.DrawScaleOverride = WheelDefs[i].DrawScaleOverride;
		}
		MaybeInitializeVehicleComponent(Wheel);
		__NFUN_184__(i);
		// [Loop Continue]
		goto J0x07;
	}
	super.PreBeginPlay();
	FindAndPlaySound(RollingSoundName);
	UpdateRollingVolumeAndPitch();
	return;
}

simulated function Tick_Internal(float DeltaTime)
{
	super(VehicleBase).Tick_Internal(DeltaTime);
	// End:0x47
	if(__NFUN_173__(int(Physics), int(18)))
	{
		// End:0x38
		if(__NFUN_145__(HasGroundContact()))
		{
			// End:0x35
			if(__NFUN_145__(bInAir))
			{
				NotifyJumped();
			}			
		}
		else
		{
			// End:0x47
			if(bInAir)
			{
				NotifyLanded();
			}
		}
	}
	UpdateRollingVolumeAndPitch();
	return;
}

function NotifyJumped()
{
	bInAir = true;
	return;
}

function NotifyLanded()
{
	bInAir = false;
	return;
}

final simulated function UpdateRollingVolumeAndPitch()
{
	local float Scale;
	local byte TargetSoundVolume, TargetSoundPitch;

	// End:0x0E
	if(__NFUN_339__(AmbientSound, none))
	{
		return;
	}
	// End:0x2A
	if(bInAir)
	{
		SoundVolume = 0;
		SoundPitch = 64;		
	}
	else
	{
		Scale = __NFUN_224__(1, __NFUN_196__(__NFUN_251__(Velocity), MaxRollingVelocity));
		SoundVolume = byte(__NFUN_195__(255, __NFUN_228__(Scale, RollingVolumeRange.Min, RollingVolumeRange.Max)));
		TargetSoundPitch = byte(__NFUN_195__(64, __NFUN_228__(Scale, RollingPitchRange.Min, RollingPitchRange.Max)));
		// End:0xAE
		if(bJustLanded)
		{
			SoundPitch = TargetSoundPitch;			
		}
		else
		{
			// End:0xF3
			if(__NFUN_145__(Level.bPaused))
			{
				__NFUN_153__(SoundPitch, byte(int(__NFUN_195__(__NFUN_195__(float(__NFUN_166__(int(TargetSoundPitch), int(SoundPitch))), RollingPitchFadeRate), Level.TimeDeltaSeconds))));
			}
		}
	}
	bJustLanded = false;
	return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
	super(VehicleBase).RegisterPrecacheComponents(PrecacheIndex);
	PrecacheIndex.__NFUN_1266__(WheelProps.WheelClass);
	PrecacheIndex.__NFUN_1277__(VoicePack, RollingSoundName);
	return;
}

defaultproperties
{
	AxleProps=(MomentOfInertia=4)
	WheelProps=(SteerRatio=0,BrakeRatio=0,HandbrakeRatio=0,FrictionStatic=6,FrictionDynamic=6,FrictionRolling=0.002,StiffnessLateral=250,StiffnessLongitudinal=250,Restitution=0,SuspensionSpringLength=1,SuspensionSpringDamping=1250,SuspensionSpringStiffness=50000,Radius=0,Mass=0,WheelClass=none)
	MaxRollingVelocity=450
	RollingVolumeRange=(Min=0,Max=1)
	RollingPitchRange=(Min=1,Max=1.5)
	RollingPitchFadeRate=4
	NeutralBrakeTorque=0
	NoDriverBrakeTorque=0
	LowSpeedBrakeTorque=0
	WheelMaterialType=none
	HealthPrefab=0
}