/*******************************************************************************
 * dnControl_RCCar_RemoteControl generated by Eliot.UELib using UELib.CLI.
 * Eliot.UELib © 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnControl_RCCar_RemoteControl extends VehicleSpaceBase
	collapsecategories;

var() SMountPrefab RemoteUserMount;
var() noexport name RemoteGridName "Name of the AnimationGrid to use for the Remote.";
var() noexport name UserGridName "Name of the AnimationGrid to use for the player.";
var() noexport float StickMoveRate "Rate at which sticks will move.";
var() noexport bool bStaticCam "If true, we will never follow the car with the camera.";
var dnControlHelper_RCCar_RemoteControl HelperRemote;
var float ThrottleAlpha;
var float SteeringAlpha;
var float FrontBackScalar;
var bool bTrackCar;
var bool bCamFollow;
var bool bTrackInput;
var bool bUseHelper;
var int ViewPitch;

function PostVerifySelf()
{
	super(dnControl).PostVerifySelf();
	// End:0x34
	if(bUseHelper)
	{
		HelperRemote = dnControlHelper_RCCar_RemoteControl(FindMountedActor(, class'dnControlHelper_RCCar_RemoteControl'));
		HelperRemote.__NFUN_590__(true);
	}
	return;
}

function SetVehicle(VehicleBase Vehicle)
{
	super.SetVehicle(Vehicle);
	PretendSelf = self;
	return;
}

simulated function AttachToUser()
{
	// End:0x1B
	if(__NFUN_150__(__NFUN_339__(HelperRemote, none), __NFUN_145__(bUseHelper)))
	{
		return;
	}
	__NFUN_590__(true);
	HelperRemote.__NFUN_590__(false);
	HelperRemote.__NFUN_633__(RemoteUserMount, User);
	return;
}

simulated function DetachFromUser()
{
	super(Decoration).DetachFromUser();
	// End:0x21
	if(__NFUN_150__(__NFUN_339__(HelperRemote, none), __NFUN_145__(bUseHelper)))
	{
		return;
	}
	__NFUN_590__(false);
	HelperRemote.__NFUN_631__();
	HelperRemote.__NFUN_590__(true);
	return;
}

simulated function DetachComplete()
{
	super.DetachComplete();
	// End:0x21
	if(__NFUN_150__(__NFUN_339__(HelperRemote, none), __NFUN_145__(bUseHelper)))
	{
		return;
	}
	__NFUN_590__(false);
	HelperRemote.__NFUN_631__();
	HelperRemote.__NFUN_590__(true);
	return;
}

simulated function VehicleSpaceTick_FullyEntered(float DeltaTime)
{
	local float SteeringTarget, ThrottleTarget, UpdateRate, GridY;
	local int DesiredPitch, DesiredYaw;
	local name UnUsed;
	local Rotator VehicleDirection;

	super.VehicleSpaceTick_FullyEntered(DeltaTime);
	// End:0x2F
	if(bTrackInput)
	{
		ThrottleTarget = GetThrottleInput();
		SteeringTarget = GetSteeringInput();		
	}
	else
	{
		ThrottleTarget = 0;
		SteeringTarget = 0;
	}
	ThrottleAlpha = UpdateStickAlpha(ThrottleAlpha, ThrottleTarget, DeltaTime, StickMoveRate);
	SteeringAlpha = UpdateStickAlpha(SteeringAlpha, SteeringTarget, DeltaTime, StickMoveRate);
	// End:0xD3
	if(__NFUN_148__(__NFUN_340__(User, none), __NFUN_342__(UserGridName, 'None')))
	{
		User.AnimationController.SetAnimGridState(UserGridName, SteeringAlpha, __NFUN_195__(FrontBackScalar, ThrottleAlpha));
	}
	// End:0x12F
	if(__NFUN_148__(__NFUN_148__(bUseHelper, __NFUN_340__(HelperRemote, none)), __NFUN_342__(RemoteGridName, 'None')))
	{
		HelperRemote.AnimationController.SetAnimGridState(RemoteGridName, SteeringAlpha, __NFUN_195__(FrontBackScalar, ThrottleAlpha));		
	}
	else
	{
		AnimationController.SetAnimGridState(RemoteGridName, SteeringAlpha, __NFUN_195__(FrontBackScalar, ThrottleAlpha));
	}
	// End:0x2EA
	if(__NFUN_148__(__NFUN_340__(Vehicle, none), bCamFollow))
	{
		// End:0x1E9
		if(bTrackCar)
		{
			VehicleDirection = Rotator(__NFUN_253__(__NFUN_239__(Vehicle.Location, User.__NFUN_872__())));
			DesiredYaw = __NFUN_166__(VehicleDirection.Yaw, Rotation.Yaw);
			DesiredPitch = __NFUN_175__(VehicleDirection.Pitch, 65535);
			// End:0x1E6
			if(__NFUN_170__(DesiredPitch, 32768))
			{
				__NFUN_181__(DesiredPitch, 65536);
			}			
		}
		else
		{
			DesiredYaw = UserMountPrefab.MountAngles.Pitch;
			DesiredPitch = 0;
		}
		InternalControlRemapper.__NFUN_666__(DesiredYaw, 5,,,, 20000,,,, true);
		// End:0x256
		if(__NFUN_169__(ViewPitch, DesiredPitch))
		{
			__NFUN_180__(ViewPitch, __NFUN_188__(__NFUN_166__(DesiredPitch, ViewPitch), int(__NFUN_195__(float(7000), DeltaTime))));			
		}
		else
		{
			// End:0x288
			if(__NFUN_170__(ViewPitch, DesiredPitch))
			{
				__NFUN_180__(ViewPitch, __NFUN_189__(__NFUN_166__(DesiredPitch, ViewPitch), int(__NFUN_195__(float(-7000), DeltaTime))));
			}
		}
		// End:0x2C1
		if(__NFUN_340__(PlayerUser, none))
		{
			PlayerUser.GetLookAnimGrid(none, none, __NFUN_175__(__NFUN_165__(ViewPitch, 65536), 65535), UnUsed, GridY);
		}
		User.AnimationController.SetAnimGridState('RCCar_Remote_Idle', 0, GridY);
	}
	return;
}

simulated function bool CanFlipVehicle()
{
	return __NFUN_148__(__NFUN_148__(__NFUN_340__(Vehicle, none), Vehicle.obIsFlipped), Vehicle.bAllowPlayerReflip);
	return;
}

function CREvent_KeyChange(ControlRemapperEx CR, Pawn InputActor, Engine.Actor.EControlRemapperKeyType KeyType, Engine.Actor.EControlRemapperEventType EventType)
{
	super(dnControl).CREvent_KeyChange(CR, InputActor, KeyType, EventType);
	// End:0x61
	if(__NFUN_148__(__NFUN_173__(int(KeyType), int(9)), __NFUN_173__(int(EventType), int(2))))
	{
		// End:0x61
		if(CanFlipVehicle())
		{
			Vehicle.StartFlip(Vector(User.Rotation));
		}
	}
	return;
}

simulated function bool ShouldReceiveDamageFromVehicle()
{
	return false;
	return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
	local class<AnimationControllerEx> RemoteAnimationController;
	local Mesh RemoteMesh;

	super(dnControl).RegisterPrecacheComponents(PrecacheIndex);
	PrecacheIndex.__NFUN_1281__(UserGridName);
	PrecacheIndex.__NFUN_1281__('RCCar_Remote_Idle');
	// End:0x65
	if(bUseHelper)
	{
		RemoteAnimationController = class'dnControlHelper_RCCar_RemoteControl'.default.AnimationControllerClass;
		RemoteMesh = class'dnControlHelper_RCCar_RemoteControl'.default.Mesh;		
	}
	else
	{
		RemoteAnimationController = AnimationControllerClass;
		RemoteMesh = Mesh;
	}
	PrecacheIndex.__NFUN_1283__(RemoteGridName, RemoteAnimationController, RemoteMesh);
	return;
}

state() idle
{
	simulated function BeginState()
	{
		super.BeginState();
		// End:0x19
		if(__NFUN_145__(bStaticCam))
		{
			bCamFollow = true;
		}
		bTrackCar = true;
		bTrackInput = true;
		return;
	}

	simulated function EndState()
	{
		bTrackCar = false;
		bCamFollow = false;
		super(Object).EndState();
		return;
	}

	simulated event QueryInteractKeyInfoState(HUD HUD)
	{
		// End:0x20
		if(CanFlipVehicle())
		{
			SetHUDKeyInfoState(HUD, 1, true, 27,, true, FlipMessage);
		}
		return;
	}
	stop;
}

state() DetachUser
{
	simulated function BeginState()
	{
		super.BeginState();
		SteeringAlpha = 0;
		ThrottleAlpha = 0;
		// End:0x71
		if(__NFUN_148__(__NFUN_148__(bUseHelper, __NFUN_340__(HelperRemote, none)), __NFUN_342__(RemoteGridName, 'None')))
		{
			HelperRemote.AnimationController.SetAnimGridState(RemoteGridName, 0, 0);			
		}
		else
		{
			AnimationController.SetAnimGridState(RemoteGridName, 0, 0);
		}
		// End:0xA9
		if(__NFUN_145__(bUseHomePose))
		{
			__NFUN_605__(0.3, false, 'DetachFromUser');
		}
		return;
	}
	stop;
}

defaultproperties
{
	RemoteUserMount=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_handright,MountOrigin=(X=1.291997E-41,Y=2.797242E-17,Z=0),Z=0)
	RemoteGridName=Control_Grid
	UserGridName=RCCar_Remote_Control_Grid
	StickMoveRate=4
	FrontBackScalar=-1
	bUseHelper=true
	bVehicleRelative=false
	bEjectWhenFlipped=false
	bAllowUserItemPickup=false
}