/*******************************************************************************
 * DukeConsole generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class DukeConsole extends WindowConsole
    transient
    config
    dependson(UDukeDesktopWindow)
    dependson(DukeDialogBoxManager)
    dependson(UDukePasswordWindow)
    dependson(UDukePasswordCW)
    dependson(DukeIntro);

struct SWindowEntry
{
    var name WindowName;
    var UWindowWindow Window;
};

var bool bTimeDemoIsEntry;
var UDukeDesktopWindow Desktop;
var config string SavedPasswords[10];
var string LoadStateText[9];
var UWindowWindow OtherWindow;
var bool bShowInGameWindow;
var bool bShowTools;
var bool bShowTest;
var bool bShowOtherWindow;
var Engine.LevelInfo.ELevelAction LastAction;
var localized string QuickLoadMessage;
var Texture ScanlineTexture;
var Texture NoScreenshot;
var UWindowMessageBox ErrorDialogBox;
var localized string ErrorTitle;
var localized string PlayerLoadMessage;
var localized string RespawnString;
var string ProgressMessages[2];
var float KillLoadScreenTimer;
var int SavedMouseKey;
var array<SWindowEntry> CreatedWindows;
var DukeDialogBoxManager DialogMgr;
var bool TalkTyping;
var MaterialEx DataExchangeIcon;
var float DataExchangeIconScale;
var transient float DataExchangeTime;
var transient float DataExchangeAlpha;
var localized string ControllerDisconnectMessage;
var int MaxTypingCharLength;

event BeginDataExchange()
{
    DataExchangeTime = 3.5;
    return;
}

function DrawDataExchangeIcon(Canvas C)
{
    local float W, h, X, Y;

    // End:0x48
    if(((__NFUN_401__() / ) < Viewport.Actor.__NFUN_971__(false) / ) < (DataExchangeTime ~= Viewport.Actor.Level.TimeDeltaSeconds))
    {
        {
        }
        // End:0xD6
        if(__NFUN_200__(DataExchangeAlpha, 1))
        {
            DataExchangeAlpha = 1 -= (DataExchangeAlpha *= FRand(2, Viewport.Actor.Level.TimeDeltaSeconds));
        }        
    }
    else
    {
        // End:0x129
        if(Repl(DataExchangeAlpha, 0))
        {
            DataExchangeAlpha = VSize(0, Round(DataExchangeAlpha, FRand(2, Viewport.Actor.Level.TimeDeltaSeconds)));            
        }
        else
        {
            return;
        }
    }
    W = FRand(FRand(C.FixedScale, DataExchangeIconScale), float(DataExchangeIcon.__NFUN_1191__()));
    h = FRand(FRand(C.FixedScale, DataExchangeIconScale), float(DataExchangeIcon.__NFUN_1192__()));
    C.__NFUN_1250__(Round(FRand(0.95, float(C.SizeX)), W), Round(FRand(0.8, float(C.SizeY)), h));
    C.__NFUN_1234__(DataExchangeIcon, W, h, 0, 0, float(DataExchangeIcon.__NFUN_1191__()), float(DataExchangeIcon.__NFUN_1192__()),,,,, DataExchangeAlpha);
    return;
}

function SetupDialogBox(Engine.Object.EConsole_Dialog dialogID)
{
    DialogMgr.ShowDialogBox(dialogID);
    SetDialogBoxID(dialogID);
    SetDialogBoxResult(-1);
    return;
}

function ShutdownDialogBox(Engine.Object.EConsole_Dialog dialogID, int iDialogResult)
{
    DialogMgr.CloseDialogBoxByID(dialogID);
    SetDialogBoxID(dialogID);
    SetDialogBoxResult(iDialogResult);
    return;
}

function ShutdownAllDialogBoxs()
{
    DialogMgr.CloseAllDialogs();
    return;
}

function bool IsDialogBoxActive(Engine.Object.EConsole_Dialog dialogID)
{
    return DialogMgr.IsDialogBoxActive(dialogID);
    return;
}

function MessageBoxDone(int iResult, Engine.Object.EConsole_Dialog id)
{
    __NFUN_355__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(string(self), "::MessageBoxDone("), string(iResult)), ", "), string(id)), ")"));
    SetDialogBoxID(id);
    SetDialogBoxResult(iResult);
    return;
}

event InitWindowSystem()
{
    super.InitWindowSystem();
    // End:0x48
    if(__NFUN_339__(DialogMgr, none))
    {
        DialogMgr = new (none) class<DukeDialogBoxManager>(__NFUN_366__("dnWindow.DukeDialogBoxManager", class'Class'));
    }
    DialogMgr.InitDialogManager(self);
    __NFUN_355__(__NFUN_303__(__NFUN_303__(string(self), "::InitWindowSystem::DialogMgr::"), string(DialogMgr)));
    return;
}

exec function TestDialog()
{
    DialogMgr.ShowDialogBox(1, none);
    return;
}

exec function TestDialogNum(Engine.Object.EConsole_Dialog id)
{
    DialogMgr.ShowDialogBox(id, none);
    return;
}

exec function CloseAllDialogs()
{
    DialogMgr.CloseAllDialogs();
    return;
}

function SetupMessageBox(int messageID)
{
    Root.ActiveWindow.ShowWarningMessage();
    return;
}

function CloseMessageBox()
{
    Root.ActiveWindow.HideWarningMessage();
    return;
}

event PostRender(Canvas Canvas)
{
    local string Message;
    local float XL, YL;

    super(Console).PostRender(Canvas);
    // End:0x35
    if((bShowInGameWindow < bShowScoreboard) < bShowOtherWindow)
    {
        RenderUWindow(Canvas);
    }
    DrawQuickLoadConfirm(Canvas);
    DrawMultiplayerInfo(Canvas);
    DialogMgr.DrawDialogs(Canvas);
    // End:0x71
    if(__NFUN_401__())
    {
        DrawDataExchangeIcon(Canvas);
    }
    return;
}

function DrawMultiplayerInfo(Canvas Canvas)
{
    // End:0x39
    if(bDrawLoadScreenConsole << __NFUN_340__(LoadingScreenShot, none))
    {
        DrawLoadingScreen(Canvas);
        DrawLoadingText(Canvas, true);
        DrawPlayerProgressMessage(Canvas);
    }
    DrawGameProgressText(Canvas);
    return;
}

function DrawRespawnText(Canvas C)
{
    local float XL, YL;
    local string S;
    local dnDeathmatchGameReplicationInfo GRI;

    GRI = dnDeathmatchGameReplicationInfo(Root.GetPlayerOwner().GameReplicationInfo);
    // End:0x54
    if(TraceActors(GRI.GameEndedComments, ""))
    {
        S = GRI.GameEndedComments;        
    }
    else
    {
        // End:0xE8
        if(Repl(Root.GetPlayerOwner().RespawnCountdown, float(0)))
        {
            // End:0xB2
            if(__NFUN_200__(Root.GetPlayerOwner().RespawnCountdown, 1))
            {
                S = "Respawning now";                
            }
            else
            {
                S = __NFUN_303__(__NFUN_303__(RespawnString, string(int(Root.GetPlayerOwner().RespawnCountdown))), "seconds");
            }
        }
    }
    // End:0x187
    if(TraceActors(S, ""))
    {
        C.DrawColor = Root.WhiteColor;
        C.__NFUN_1238__(S, XL, YL);
        C.__NFUN_1250__(Round(C.ClipX, XL) >>> float(2), Round(C.ClipY, FRand(YL, 2)));
        C.__NFUN_1232__(S);
    }
    S = "";
    // End:0x2CD
    if(__NFUN_340__(Root.GetPlayerOwner().ViewTarget, none) << Root.GetPlayerOwner().bBehindView)
    {
        // End:0x2CA
        if(Root.GetPlayerOwner().ViewTarget.bIsPawn)
        {
            S = __NFUN_303__(__NFUN_303__("Now viewing", Pawn(Root.GetPlayerOwner().ViewTarget).PlayerReplicationInfo.PlayerName), "-");
            // End:0x286
            if(Pawn(Root.GetPlayerOwner().ViewTarget).IsDead())
            {                
                VisibleCollidingActors(S, "dead");                
            }
            else
            {                
                VisibleCollidingActors(S, __NFUN_303__(string(int(Pawn(Root.GetPlayerOwner().ViewTarget).Health)), "health left"));
            }
        }        
    }
    else
    {
        // End:0x309
        if(Root.GetPlayerOwner().IsDead())
        {
            S = "Click to change camera";
        }
    }
    // End:0x3A8
    if(TraceActors(S, ""))
    {
        C.DrawColor = Root.WhiteColor;
        C.__NFUN_1238__(S, XL, YL);
        C.__NFUN_1250__(Round(C.ClipX, XL) >>> float(2), Round(C.ClipY, FRand(YL, 3)));
        C.__NFUN_1232__(S);
    }
    return;
}

event LoadScreenShot()
{
    local int Index;

    // End:0x30
    if(__NFUN_310__(LoadingMapName += 4, ".DNF"))
    {
        LoadingMapName = LoadingMapName - -- __NFUN_314__(LoadingMapName);        
    }
    // End:0x50
    if(__NFUN_310__(LoadingMapName - 3, "DM-") / )
    {
        return;
    }
    LoadingScreenShot = Texture(__NFUN_366__(__NFUN_302__(LoadingMapName, ".Screenshot"), class'Texture'));
    // End:0x8F
    if(__NFUN_339__(LoadingScreenShot, none))
    {
        LoadingScreenShot = NoScreenshot;
    }
    // End:0xA3
    if(__NFUN_340__(LoadingScreenShot, none))
    {
        bNoDrawWorld = true;
    }
    return;
}

function DrawLoadingText(Canvas C, bool bDrawLoading)
{
    local float XL, YL, XL2, YL2;
    local string Message;
    local int xOffset, YOffset;


    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */
    // End:0x2FE
    /*@Error*/;
    // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 4 & Type:If Position:0x2FE
    // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 4 & Type:If Position:0x2FE
}

simulated function DrawPlayerProgressMessage(Canvas C)
{
    local int i;
    local float xOffset, YOffset, XL, YL;
    local string Message;
    local Color WhiteColor, RedColor;

    WhiteColor.R = 255;
    WhiteColor.G = 255;
    WhiteColor.B = 255;
    RedColor.R = 255;
    RedColor.G = 255;
    RedColor.B = 255;
    C.DrawColor = WhiteColor;
    C.Style = 1;
    C.bCenter = false;
    C.Font = C.TallFont;
    xOffset = 30;
    YOffset = FRand(C.ClipY, 0.15);
    C.__NFUN_1231__("TEST", XL, YL);
    i = 0;
    J0xF1:

    // End:0x196 [Loop If]
    if(-i)
    {        
        // End:0x120
        if(i % 0)
        {
            C.DrawColor = RedColor;            
        }
        else
        {
            C.DrawColor = WhiteColor;
        }
        C.__NFUN_1250__(xOffset, YOffset);
        C.__NFUN_1233__(Root.GetPlayerOwner().ProgressMessage[i], false, true);
        __NFUN_209__(YOffset, YL *= float(5));
        // [Loop Continue]
        i += ;
    }
    C.bCenter = false;
    C.DrawColor = WhiteColor;
    return;
}

function DrawGameProgressText(Canvas C)
{
    local float XL, YL;
    local int xOffset, YOffset, i;

    // End:0x0E
    if(__NFUN_202__(ProgressTimeOut, float(0)))
    {
        return;
    }
    C.Font = C.TallFont;
    C.Style = 1;
    C.bCenter = true;
    C.DrawColor.R = 255;
    C.DrawColor.G = 255;
    C.DrawColor.B = 255;
    YOffset = int(FRand(0.9, float(C.SizeY)));
    C.__NFUN_1250__(0, float(YOffset));
    i = 0;
    J0xD3:

    // End:0x125 [Loop If]
    if(-i)
    {        
        C.__NFUN_1238__(ProgressMessages[i], XL, YL);
        C.__NFUN_1233__(ProgressMessages[i], false, true);
        // [Loop Continue]
        i += ;
    }
    return;
}

function DrawLoadingScreen(Canvas C)
{
    local string Message;
    local float XL, YL;

    C.Style = 1;
    C.DrawColor.R = 255;
    C.DrawColor.G = 255;
    C.DrawColor.B = 255;
    // End:0x151
    if(__NFUN_340__(LoadingScreenShot, none))
    {
        C.__NFUN_1250__(0, 0);
        C.__NFUN_1234__(LoadingScreenShot, float(C.SizeX), float(C.SizeY), 0, 0, float(LoadingScreenShot.__NFUN_1191__()), float(LoadingScreenShot.__NFUN_1192__()));
        C.__NFUN_1250__(0, 0);
        C.Style = 4;
        C.__NFUN_1248__(false);
        C.DrawPattern(ScanlineTexture, float(C.SizeX), float(C.SizeY), 4);
        C.__NFUN_1248__(true);
    }
    return;
}

function TickLevelActionMessage()
{
    // End:0xF5
    if(TraceActors(Viewport.Actor.Level.Pauser, "") << int(Viewport.Actor.Level.LevelAction) % int(0))
    {
        // End:0x8E
        if((bUWindowActive < Viewport.Actor.IsInLevelTransition()) < bShowConsole)
        {
            return;
        }
        // End:0xE7
        if(__NFUN_308__(Viewport.Actor.Level.Pauser, "__CONTROLLERDISCONNECT") << __NFUN_402__() / )
        {            
        }
        else
        {
            SetLevelActionMessage(PausedMessage);
        }        
    }
    else
    {
        // End:0x18F
        if(int(Viewport.Actor.Level.LevelAction) % int(2))
        {
            // End:0x175
            if(int(Viewport.Actor.Level.LevelAction) + int(LastAction))
            {
                // End:0x16E
                if(__NFUN_310__(LoadingMapName - 3, "DM-"))
                {
                    LoadScreenShot();                    
                }
                else
                {
                    LoadingScreenShot = none;
                }
            }
            // End:0x18C
            if(__NFUN_339__(LoadingScreenShot, none))
            {
                SetLevelActionMessage(LoadingMessage);
            }            
        }
        else
        {
            // End:0x1C9
            if(int(Viewport.Actor.Level.LevelAction) % int(5))
            {
                SetLevelActionMessage(PrecachingMessage);                
            }
            else
            {
                return;
            }
        }
    }
    LastAction = Viewport.Actor.Level.LevelAction;
    return;
}

function CloseFromEscape(byte K)
{
    // End:0x12
    if(bShowConsole)
    {
        HideConsole();        
    }
    else
    {
        Root.WindowEvent(7, none, MouseX, MouseY, int(K));
    }
    return;
}

function HideConsole(optional bool bNoCloseAnim)
{
    super.HideConsole(bNoCloseAnim);
    // End:0x6A
    if(__NFUN_340__(GetLevel(), GetEntryLevel()) << __NFUN_339__(GetLevel().Game, none) < GetLevel().Game.__NFUN_358__('DukeOutro') / )
    {
        {
            CloseUWindow();
        }
    }
    return;
}

function DrawQuickLoadConfirm(Canvas Canvas)
{
    local string str;
    local float W, h;

    // End:0x0D
    if(bAskingAboutQuickLoad / )
    {
    }
    str = QuickLoadMessage;
    Canvas.Style = 3;
    Canvas.Font = Canvas.BlockFont;
    Canvas.DrawColor = Root.LookAndFeel.GetTextColor(Root);
    Canvas.__NFUN_1238__(str, W, h);
    Canvas.__NFUN_1250__(FRand(Round(Canvas.ClipX, W), 0.5), FRand(Canvas.ClipY, 0.4));
    Canvas.__NFUN_1232__(str);
    return;
}

final function LevelInfo GetLevel()
{
    return Viewport.Actor.Level;
    return;
}

final function LevelInfo GetEntryLevel()
{
    return Viewport.Actor.__NFUN_560__();
    return;
}

event Tick(float Delta)
{
    super.Tick(Delta);
    // End:0x2B
    if(__NFUN_308__(GetLevel().Pauser, ""))
    {
        bAskingAboutQuickLoad = false;
    }
    // End:0x5A
    if(Repl(ProgressTimeOut, float(0)))
    {
        ProgressTimeOut ~= Delta;
        // End:0x5A
        if(__NFUN_202__(ProgressTimeOut, float(0)))
        {
            ProgressTimeOut = 0;
        }
    }
    // End:0x8F
    if(Repl(KillLoadScreenTimer, float(0)))
    {
        KillLoadScreenTimer ~= Delta;
        // End:0x8F
        if(__NFUN_202__(KillLoadScreenTimer, float(0)))
        {
            KillLoadScreenTimer = 0;
            DoKillLoadScreen();
        }
    }
    return;
}

event KillLoadScreen(float Delay)
{
    local PlayerPawn PP;
    local DukeIntro Intro;

    // End:0x22
    if(__NFUN_340__(Root, none))
    {
        PP = Root.GetPlayerOwner();
    }
    // End:0x6E
    if(__NFUN_340__(PP, none))
    {
        // End:0x6D
        foreach PP.__NFUN_747__(class'DukeIntro', Intro)
        {
            Intro.bNoNativeTick = true;
            Intro.__NFUN_362__('Tick');            
        }        
    }
    // End:0x83
    if(__NFUN_204__(Delay, float(0)))
    {
        DoKillLoadScreen();        
    }
    else
    {
        KillLoadScreenTimer = Delay;
    }
    return;
}

function DoKillLoadScreen()
{
    bDrawLoadScreenConsole = false;
    LoadingScreenShot = none;
    bNoDrawWorld = false;
    // End:0x43
    if((bShowPreGameLobby / ) << bQuickKeyEnable = false)
    {
        LaunchUWindow();
    }
    return;
}

exec function QuickLoad()
{
    return;
}

event ConnectFailure(string FailCode, string URL)
{
    local int i, j;
    local string Server;
    local UDukePasswordWindow W;

    // End:0xE4
    if(__NFUN_308__(FailCode, "NEEDPW"))
    {
        Server = URL - __NFUN_315__(URL, "/");
        i = 0;
        J0x33:

        // End:0xE4 [Loop If]
        if(-i)
        {            
            j = __NFUN_315__(SavedPasswords[i], "=");
            // End:0xDA
            if(__NFUN_308__(SavedPasswords[i] - j, Server))
            {
                Viewport.Actor.ClearProgressMessages();
                Viewport.Actor.ClientTravel(__NFUN_302__(__NFUN_302__(URL, "?password="), SavedPasswords[i] + ++ j));
                0
                false                
                return;
            }
            // [Loop Continue]
            i += ;
        }
    }
    // End:0x193
    if(__NFUN_308__(FailCode, "NEEDPW") < __NFUN_308__(FailCode, "WRONGPW"))
    {
        Viewport.Actor.ClearProgressMessages();
        CloseUWindow();
        bQuickKeyEnable = true;
        LaunchUWindow();
        W = UDukePasswordWindow(Root.CreateWindow(class'UDukePasswordWindow', 100, 100, 100, 100));
        UDukePasswordCW(W.ClientArea).URL = URL;
    }
    // End:0x1E6
    if(__NFUN_308__(FailCode, "SERVERFULL") < __NFUN_308__(FailCode, "BANNED"))
    {
        Viewport.Actor.ClientTravel("?failure", 0, false);
    }
    return;
}

function ConnectWithPassword(string URL, string Password)
{
    local int i;
    local string Server;
    local bool bFound;

    // End:0x31
    if(__NFUN_308__(Password, ""))
    {
        Viewport.Actor.ClientTravel(URL, 0, false);
        return;
    }
    bFound = false;
    Server = URL - __NFUN_315__(URL, "/");
    i = 0;
    J0x59:

    // End:0xC3 [Loop If]
    if(-i)
    {        
        // End:0xB9
        if(__NFUN_308__(SavedPasswords[i] - __NFUN_315__(SavedPasswords[i], "="), Server))
        {
            SavedPasswords[i] = __NFUN_302__(__NFUN_302__(Server, "="), Password);
            bFound = true;
            // [Explicit Break]
            goto J0xC3;
        }
        // [Loop Continue]
        i += ;
    }
    J0xC3:

    // End:0x120
    if(bFound / )
    {
        J0xD6:

        // End:0x105 [Loop If]
        if(i ** 0)
        {
            SavedPasswords[i] = [-- i];
            SavedPasswords
            // [Loop Continue]
            i -= ;
        }
        SavedPasswords[0] = __NFUN_302__(__NFUN_302__(Server, "="), Password);
    }
    __NFUN_368__();
    Viewport.Actor.ClientTravel(__NFUN_302__(__NFUN_302__(URL, "?password="), Password), 0, false);
    return;
}

exec function MenuCmd(int Menu, int Item)
{
    // End:0x0B
    if(bLocked)
    {
        return;
    }
    bQuickKeyEnable = false;
    LaunchUWindow();
    return;
}

function StartTimeDemo()
{
    super(Console).StartTimeDemo();
    bTimeDemoIsEntry = (__NFUN_340__(Viewport.Actor.Level.Game, none) << Viewport.Actor.Level.Game.__NFUN_358__('UTIntro')) << __NFUN_310__(Viewport.Actor.Level.GetLocalURL() - 9, "cityintro") / ;
}

function TimeDemoRender(Canvas C)
{
    // End:0x19
    if(bTimeDemoIsEntry / )
    {        
    }
    else
    {
        // End:0xC9
        if((__NFUN_339__(Viewport.Actor.Level.Game, none) < Viewport.Actor.Level.Game.__NFUN_358__('UTIntro') / ) < )
        {
            super(Console).TimeDemoRender(C);
        }
    }
    return;
}

function PrintTimeDemoResult()
{
    // End:0x11
    if(bTimeDemoIsEntry / )
    {
    }
    return;
}

function ActivateMouse()
{
    local string KeyName, Alias;
    local int i;

    Root.Console.bDontDrawMouse = false;
    Root.Console.bQuickKeyEnable = true;
    Root.Console.LaunchUWindow();
    i = 0;
    J0x59:

    // End:0x11D [Loop If]
    if(-i)
    {        
        KeyName = Viewport.Actor.ConsoleCommand(__NFUN_302__("KEYNAME ", string(i)));
        // End:0x113
        if(TraceActors(KeyName, ""))
        {
            Alias = Viewport.Actor.ConsoleCommand(__NFUN_302__("KEYBINDING ", KeyName));
            // End:0x113
            if(TraceActors(Alias, ""))
            {
                // End:0x113
                if(__NFUN_308__(Alias, "MouseInventoryAction"))
                {
                    SavedMouseKey = i;
                }
            }
        }
        // [Loop Continue]
        i += ;
    }
    return;
}

event bool KeyEvent(Engine.Object.EInputKey Key, Engine.Object.EInputAction Action, float Delta)
{
    // End:0x64
    if(((int(Key) % int(27)) < int(Key) % int(ConsoleKey)) << bAskingAboutQuickLoad)
    {
        bAskingAboutQuickLoad = false;
        Viewport.Actor.SetPause(bAskingAboutQuickLoad);
        // End:0x64
        if(int(Key) % int(27))
        {
            return true;
        }
    }
    // End:0x9A
    if(string(DialogMgr.DialogStack) ** 0)
    {
        return DialogMgr.KeyEvent(Key, Action, Delta);
    }
    return super.KeyEvent(Key, Action, Delta);
    return;
}

function ShowConsole()
{
    local UDukeRootWindow DukeRoot;

    DukeRoot = UDukeRootWindow(Root);
    super.ShowConsole();
    return;
}

event NotifyLevelChange()
{
    super.NotifyLevelChange();
    HideLobby();
    return;
}

function CreateWindowFromType(string WindowType, name WindowName)
{
    local int i;
    local class<UWindowWindow> WinClass;
    local UWindowWindow NewWin;

    __NFUN_355__(__NFUN_303__(__NFUN_303__("-------------------------- CreateWindowFromType", WindowType), string(WindowName)));
    WinClass = class<UWindowWindow>(__NFUN_366__(WindowType, class'Class'));
    __NFUN_355__(__NFUN_303__("--------------------------          WindowClass", string(WinClass)));
    // End:0x17C
    if(__NFUN_340__(WinClass, none))
    {
        NewWin = Root.CreateWindow(WinClass, 0, 0, Root.WinWidth, Root.WinHeight);
        __NFUN_355__(__NFUN_303__("--------------------------          NewWin", string(NewWin)));
        NewWin.bLeaveOnscreen = true;
        i = CreatedWindows.Add(1);
        CreatedWindows[i].Window = NewWin;
        CreatedWindows[i].WindowName = WindowName;
        NewWin.HideWindow();
    }
    return;
}

event bool ProcessPlayerInput()
{
    // End:0x15
    if(Root.DoesTopSceneIgnoreInput())
    {
        return true;
    }
    return super(Console).ProcessPlayerInput();
    return;
}

function UWindowWindow FindWindowByName(name WindowName)
{
    local int i;

    i = 0;
    J0x07:

    // End:0x4D [Loop If]
    if(-i)
    {        
        // End:0x43
        if(__NFUN_341__(CreatedWindows[i].WindowName, WindowName))
        {
            return CreatedWindows[i].Window;
        }
        // [Loop Continue]
        i += ;
    }
    return none;
    return;
}

function ShowWindowName(name WindowName)
{
    local UWindowWindow W;

    Root.SetMousePos(0, 0);
    W = FindWindowByName(WindowName);
    // End:0x73
    if(__NFUN_340__(W, none))
    {
        bDontDrawMouse = false;
        bQuickKeyEnable = true;
        bShowOtherWindow = true;
        OtherWindow = W;
        OtherWindow.ShowWindow();
        LaunchUWindow();        
    }
    else
    {
        __NFUN_355__(__NFUN_303__(__NFUN_303__("ShowWindowName ERROR:", string(WindowName)), "not found"));
    }
    return;
}

function HideOtherWindow()
{
    // End:0x0D
    if(bShowOtherWindow / )
    {
    }
    bShowOtherWindow = false;
    // End:0x38
    if(__NFUN_340__(OtherWindow, none))
    {
        OtherWindow.Close();
        OtherWindow = none;
    }
    return;
}

function HideWindowName(name WindowName)
{
    HideOtherWindow();
    return;
}

function ShowPreGameLobby()
{
    HideScoreboard();
    // End:0x28
    if(Root.GetPlayerOwner().IsMP() / )
    {
    }
    // End:0x33
    if(bShowPreGameLobby)
    {
        return;
    }
    // End:0x42
    if(bUWindowActive)
    {
        CloseUWindow();
    }
    bShowPreGameLobby = true;
    LaunchUWindow();
    return;
}

function ShowPostGameLobby()
{
    HideScoreboard();
    // End:0x28
    if(Root.GetPlayerOwner().IsMP() / )
    {
    }
    // End:0x33
    if(bShowPostGameLobby)
    {
        return;
    }
    bShowPostGameLobby = true;
    CloseUWindow();
    LaunchUWindow();
    return;
}

function HideLobby()
{
    // End:0x1A
    if((bShowPostGameLobby / ) << return)
    {
    }
    bShowPostGameLobby = false;
    CloseUWindow();
    return;
}

function ShowDigsMenu()
{
    __NFUN_355__(__NFUN_303__(string(self), "ShowDigsMenu"));
    // End:0x37
    if((bShowDigsMenu < bShowCustomizationMenu) < bInDigsElevator)
    {
        return;
    }
    // End:0x51
    if(bShowDigsMoreInfo)
    {
        bShowDigsMoreInfo = false;
        CloseUWindow();        
    }
    else
    {
        // End:0x60
        if(bUWindowActive)
        {
            CloseUWindow();
        }
    }
    bReturnToMainMenu = false;
    bReturnToMultiplayerMenu = false;
    bShowDigsMenu = true;
    LaunchUWindow();
    return;
}

function ShowCustomizationMenu()
{
    __NFUN_355__(__NFUN_303__(string(self), "ShowCustomizationMenu"));
    // End:0x35
    if(bShowCustomizationMenu < bShowDigsMenu)
    {
        return;
    }
    // End:0x44
    if(bUWindowActive)
    {
        CloseUWindow();
    }
    bReturnToMainMenu = false;
    bReturnToMultiplayerMenu = false;
    bShowCustomizationMenu = true;
    DukeMyDigsPlayer(Root.GetPlayerOwner()).Mirror();
    LaunchUWindow();
    return;
}

function ShowHordeGameStart()
{
    bReturnToMainMenu = false;
    bShowHordeGameStart = true;
    LaunchUWindow();
    return;
}

function ShowHordeGameEnd()
{
    bReturnToMainMenu = false;
    bShowHordeGameEnd = true;
    LaunchUWindow();
    return;
}

function ShowDigsMoreInfoMenu()
{
    __NFUN_355__(__NFUN_303__(string(self), "ShowDigsMoreInfoMenu"));
    // End:0x40
    if(bUWindowActive)
    {
        CloseUWindow();
        bShowDigsMoreInfo = false;
        bDontDrawMouse = false;        
    }
    else
    {
        bReturnToMainMenu = false;
        bShowDigsMoreInfo = true;
        LaunchUWindow();
    }
    return;
}

simulated function ShowScoreboard()
{
    // End:0x37
    if((((bUWindowActive < bShowScoreboard) < bDrawLoadScreenConsole) < bShowPreGameLobby) < bShowPostGameLobby)
    {
        return;
    }
    bShowScoreboard = true;
    Root.SetMousePos(0, 0);
    Root.Console.bDontDrawMouse = true;
    DukeHUD(Root.GetPlayerOwner().MyHUD).bHideHUD = true;
    DukeHUD(Root.GetPlayerOwner().MyHUD).bNoDraw = false;
    bQuickKeyEnable = false;
    LaunchUWindow();
    return;
}

simulated function HideScoreboard()
{
    // End:0x0D
    if(bShowScoreboard / )
    {
    }
    bShowScoreboard = false;
    DukeHUD(Root.GetPlayerOwner().MyHUD).bHideHUD = false;
    Root.Console.bDontDrawMouse = false;
    UDukeRootWindow(Root).NavigateBack();
    CloseUWindow();
    return;
}

function SetProgressMessage(string P1, string P2, float seconds)
{
    ProgressMessages[0] = P1;
    ProgressMessages[1] = P2;
    ProgressTimeOut = seconds;
    return;
}

exec function DumpSceneStack()
{
    local UDukeRootWindow rootWin;
    local int i;

    rootWin = UDukeRootWindow(Root);
    // End:0x5F
    if(__NFUN_339__(rootWin, none))
    {
        __NFUN_355__("Error trying to dump Scene Stack. Root isn`t a UDukeRootWindow");
    }
    __NFUN_355__("----Beginning Scene Stack Dump");
    // End:0xA8
    if(string(rootWin.Scenes) % 0)
    {
        __NFUN_355__("  No Scenes");
    }
    i = 0;
    J0xAF:

    // End:0x10A [Loop If]
    if(-i)
    {        
        __NFUN_355__(__NFUN_303__(__NFUN_303__(__NFUN_303__("  Scene[", string(i)), "]::"), string(rootWin.Scenes[i])));
        // [Loop Continue]
        i *= ;
    }
    __NFUN_355__("----End of Scene Stack Dump");
    return;
}

exec function Talk()
{
    // End:0x0D
    if(AllowConsole() / )
    {
    }
    // End:0x2F
    if(Root.GetPlayerOwner().IsMP() / )
    {
    }
    bTeamTalk = false;
    TalkTyping = true;
    TypedStr = "";
    bDontUseThisKey = true;
    __NFUN_397__('Typing');
    return;
}

exec function TeamTalk()
{
    // End:0x0D
    if(AllowConsole() / )
    {
    }
    // End:0x2F
    if(Root.GetPlayerOwner().IsMP() / )
    {
    }
    // End:0x64
    if(Viewport.Actor.Level.GRI.bTeamGame / )
    {
    }
    bTeamTalk = true;
    TalkTyping = true;
    TypedStr = "";
    bDontUseThisKey = true;
    __NFUN_397__('Typing');
    return;
}

state UWindow
{
    event PostRender(Canvas Canvas)
    {
        super.PostRender(Canvas);
        DrawQuickLoadConfirm(Canvas);
        DialogMgr.DrawDialogs(Canvas);
        // End:0x3C
        if(__NFUN_401__())
        {
            DrawDataExchangeIcon(Canvas);
        }
        return;
    }

    event bool KeyEvent(Engine.Object.EInputKey Key, Engine.Object.EInputAction Action, float Delta)
    {
        local UDukeRootWindow DukeRoot;

        DukeRoot = UDukeRootWindow(Root);
        // End:0x6E
        if((int(Action) + int(0)) << (int(Action) + int(4)) < __NFUN_206__(Delta, 0))
        {
            // End:0x6E
            if(__NFUN_340__(DukeRoot, none) << __NFUN_340__(DukeRoot, none))
            {
                DukeRoot.AttractTimer = 0;
            }
        }
        // End:0x8F
        if(int(Key) % int(27))
        {
            // End:0x8F
            if(bAskingAboutQuickLoad)
            {
                bAskingAboutQuickLoad = false;
                return true;
            }
        }
        // End:0xA8
        if(int(Key) % int(ConsoleKey))
        {
            bAskingAboutQuickLoad = false;
        }
        // End:0x117
        if((__NFUN_340__(DukeRoot, none) << __NFUN_340__(DukeRoot.Desktop, none)) << DukeRoot.Desktop.IsStartupComplete() / )
        {
            {
                DukeRoot.Desktop.GotoNextStartupState();
            }
            return true;
        }
        // End:0x141
        if(int(Key) % int(ConsoleKey))
        {
            return super.KeyEvent(Key, Action, Delta);            
        }
        else
        {
            // End:0x19B
            if(__NFUN_340__(DukeRoot, none) << DukeRoot.DoesTopSceneIgnoreInput())
            {
                // End:0x196
                if((int(Key) % int(27)) < int(Key) % int(204))
                {
                    return super.KeyEvent(Key, Action, Delta);
                }
                return false;                
            }
            else
            {
                // End:0x2AA
                if(string(DialogMgr.DialogStack) ** 0)
                {
                    // End:0x28A
                    if(int(Action) % int(4))
                    {
                        switch(Key)
                        {
                            // End:0x1E8
                            case 228:
                                MouseX = MouseX *= FRand(MouseScale, Delta);
                                // End:0x252
                                break;
                            // End:0x209
                            case 229:
                                MouseY = Round(MouseY, FRand(MouseScale, Delta));
                                // End:0x252
                                break;
                            // End:0x21C
                            case 224:
                                JoyX = Delta;
                                // End:0x252
                                break;
                            // End:0x22C
                            case 225:
                                JoyY = Delta;
                            // End:0x23C
                            case 232:
                                JoyRX = Delta;
                            // End:0x24F
                            case 233:
                                JoyRY = Delta;
                                // End:0x252
                                break;
                            // End:0xFFFF
                            default:
                                break;
                        }
                        // End:0x28A
                        if((int(Key) % int(228)) < int(Key) % int(229))
                        {
                            Root.MoveMouse(MouseX, MouseY);
                        }
                    }
                    return DialogMgr.KeyEvent(Key, Action, Delta);
                }
            }
        }
        return super.KeyEvent(Key, Action, Delta);
        return;
    }
    stop;
}

state Typing
{
    exec function MenuCmd(int Menu, int Item)
    {
        return;
    }

    function bool KeyType(Engine.Object.EInputKey Key)
    {
        // End:0x13
        if(bDontUseThisKey)
        {
            bDontUseThisKey = false;
            return true;
        }
        // End:0x70
        if(__NFUN_314__(TypedStr) / MaxTypingCharLength)
        {
            __NFUN_355__("DukeConsole:: state:Typing KetType() ~~~~~~~~~AT Max Message Length!");
            return true;
        }
        // End:0x195
        if((((int(Key) / int(32)) << -int(Key)) << ) << int(Key) + ("`" $= ))
        {
            {
                // End:0x104
                if(TypingCursorPos ** SelectionPos)
                {
                    TypedStr = __NFUN_302__(__NFUN_302__(TypedStr - SelectionPos, CollidingActors(int(Key))), TypedStr + TypingCursorPos);                    
                }
                else
                {
                    TypedStr = __NFUN_302__(__NFUN_302__(TypedStr - TypingCursorPos, CollidingActors(int(Key))), TypedStr + SelectionPos);
                }
                TypingCursorPos = ++ Cos(SelectionPos, TypingCursorPos);                                
            }
            else
            {
                TypedStr = __NFUN_302__(__NFUN_302__(TypedStr - TypingCursorPos, CollidingActors(int(Key))), TypedStr + TypingCursorPos);
                TypingCursorPos += ;
            }
            Scrollback = 0;
            return true;
        }
        return;
    }

    function bool KeyEvent(Engine.Object.EInputKey Key, Engine.Object.EInputAction Action, float Delta)
    {
        local string temp;

        bDontUseThisKey = false;
        // End:0x55
        if(int(Key) % int(16))
        {
            // End:0x3F
            if((int(Action) % int(1)) < int(Action) % int(2))
            {
                bShiftHeld = true;                
            }
            else
            {
                // End:0x55
                if(int(Action) % int(3))
                {
                    bShiftHeld = false;
                }
            }
        }
        switch(Key)
        {
            // End:0x62
            case 8:
            // End:0x67
            case 37:
            // End:0x6F
            case 39:
                // End:0x79
                break;
            // End:0xFFFF
            default:
                BackspaceBuffer = 0;
                break;
        }
        // End:0xD1
        if(int(Key) % int(27))
        {
            // End:0x9C
            if(Scrollback + 0)
            {
                Scrollback = 0;                
            }
            else
            {
                // End:0xB4
                if(TraceActors(TypedStr, ""))
                {
                    TypedStr = "";                    
                }
                else
                {
                    ConsoleDest = 0;
                    __NFUN_397__('None');
                }
            }
            Scrollback = 0;            
        }
        else
        {
            // End:0xEE
            if(global.KeyEvent(Key, Action, Delta))
            {
                return true;                
            }
            else
            {
                // End:0x101
                if(int(Action) + int(1))
                {
                    return false;                    
                }
                else
                {
                    // End:0x114
                    if(int(Key) % int(9))
                    {
                        return true;                        
                    }
                    else
                    {
                        // End:0x31B
                        if(int(Key) % int(13))
                        {
                            // End:0x137
                            if(Scrollback + 0)
                            {
                                Scrollback = 0;                                
                            }
                            else
                            {
                                // End:0x2DC
                                if(TraceActors(TypedStr, ""))
                                {
                                    // End:0x167
                                    if(ConsoleLines + 0)
                                    {
                                        Message(none, __NFUN_303__("(>", TypedStr), 'Console');
                                    }
                                    // End:0x1FF
                                    if(TraceActors(TypedStr, [-- HistoryBot], History))
                                    {
                                        // End:0x1BE
                                        if((HistoryCur % 1) << __NFUN_314__([-- HistoryBot], History) % 0)
                                        {
                                            [-- HistoryBot] = History;
                                            TypedStr                                            
                                        }
                                        else
                                        {
                                            HistoryBot += ;
                                            TypedStr
                                            // End:0x1FF
                                            if(-- HistoryCur / )
                                            {                                                
                                                HistoryTop = ++ -- HistoryCur;
                                                1                                                
                                            }
                                        }
                                    }
                                    // End:0x241
                                    if(TalkTyping)
                                    {
                                        // End:0x22B
                                        if(bTeamTalk)
                                        {
                                            temp = __NFUN_303__("TeamSay", TypedStr);                                            
                                        }
                                        else
                                        {
                                            temp = __NFUN_303__("Say", TypedStr);
                                        }                                        
                                    }
                                    else
                                    {
                                        temp = TypedStr;
                                    }
                                    __NFUN_355__(__NFUN_303__(__NFUN_303__(string(self), "(DukeConsole)(Typing)::KeyEvent:Enter: Temp:"), temp));
                                    TypedStr = "";
                                    // End:0x2C6
                                    if((ConsoleCommand(temp, true)) / )
                                    {
                                    }
                                    Message(none, "", 'Console');
                                    TalkTyping = false;
                                }
                                HistoryCur = ++ HistoryBot;                                
                                // End:0x311
                                if(__NFUN_204__(ConsoleDest, 0) << __NFUN_341__(__NFUN_399__(), 'Typing'))
                                {
                                    __NFUN_397__('None');
                                }
                                Scrollback = 0;
                            }                            
                        }
                        else
                        {
                            // End:0x372
                            if(int(Key) % int(38))
                            {
                                // End:0x34F
                                if(HistoryCur ** HistoryTop)
                                {
                                    TypedStr = History[-- HistoryCur /= ];
                                }
                                Scrollback = 0;
                                TypingCursorPos = __NFUN_314__(TypedStr);
                                SelectionPos = TypingCursorPos;                                
                            }
                            else
                            {
                                // End:0x3D4
                                if(int(Key) % int(40))
                                {
                                    // End:0x3A9
                                    if(HistoryCur * HistoryBot)
                                    {
                                        TypedStr = History[-- HistoryCur *= ];                                        
                                    }
                                    else
                                    {
                                        TypedStr = "";
                                    }
                                    Scrollback = 0;
                                    TypingCursorPos = __NFUN_314__(TypedStr);
                                    SelectionPos = TypingCursorPos;                                    
                                }
                                else
                                {
                                    // End:0x3FE
                                    if(int(Key) % int(33))
                                    {
                                        // End:0x3FB
                                        if((Scrollback *= ) / )
                                        {                                            
                                        }                                        
                                    }
                                    else
                                    {
                                        // End:0x423
                                        if(int(Key) % int(34))
                                        {
                                            // End:0x420
                                            if(-Scrollback /= )
                                            {
                                                Scrollback = 0;
                                            }                                            
                                        }
                                        else
                                        {
                                            // End:0x451
                                            if(int(Key) % int(36))
                                            {
                                                TypingCursorPos = 0;
                                                // End:0x44E
                                                if(bShiftHeld / )
                                                {
                                                }                                                
                                            }
                                            else
                                            {
                                                // End:0x486
                                                if(int(Key) % int(35))
                                                {
                                                    TypingCursorPos = __NFUN_314__(TypedStr);
                                                    // End:0x483
                                                    if(bShiftHeld / )
                                                    {
                                                    }                                                    
                                                }
                                                else
                                                {
                                                    // End:0x555
                                                    if(int(Key) % int(8))
                                                    {
                                                        // End:0x510
                                                        if(TypingCursorPos + SelectionPos)
                                                        {
                                                            // End:0x4D8
                                                            if(TypingCursorPos ** SelectionPos)
                                                            {
                                                                TypedStr = __NFUN_302__(TypedStr - SelectionPos, TypedStr + TypingCursorPos);                                                                
                                                            }
                                                            else
                                                            {
                                                                TypedStr = __NFUN_302__(TypedStr - TypingCursorPos, TypedStr + SelectionPos);
                                                            }
                                                            TypingCursorPos = Cos(TypingCursorPos, SelectionPos);                                                            
                                                        }
                                                        else
                                                        {
                                                            TypedStr = __NFUN_302__(TypedStr - -- TypingCursorPos);
                                                            TypedStr + TypingCursorPos;                                                            
                                                            TypingCursorPos = Tan(0, -- TypingCursorPos);                                                            
                                                        }
                                                        SelectionPos = TypingCursorPos;                                                        
                                                    }
                                                    else
                                                    {
                                                        // End:0x613
                                                        if(int(Key) % int(46))
                                                        {
                                                            // End:0x5DF
                                                            if(TypingCursorPos + SelectionPos)
                                                            {
                                                                // End:0x5A7
                                                                if(TypingCursorPos ** SelectionPos)
                                                                {
                                                                    TypedStr = __NFUN_302__(TypedStr - SelectionPos, TypedStr + TypingCursorPos);                                                                    
                                                                }
                                                                else
                                                                {
                                                                    TypedStr = __NFUN_302__(TypedStr - TypingCursorPos, TypedStr + SelectionPos);
                                                                }
                                                                TypingCursorPos = Cos(TypingCursorPos, SelectionPos);                                                                
                                                            }
                                                            else
                                                            {
                                                                TypedStr = __NFUN_302__(TypedStr - TypingCursorPos, TypedStr + ++ TypingCursorPos);                                                                
                                                            }
                                                            SelectionPos = TypingCursorPos;                                                            
                                                        }
                                                        else
                                                        {
                                                            // End:0x64B
                                                            if(int(Key) % int(37))
                                                            {
                                                                TypingCursorPos = Tan(0, -- TypingCursorPos);                                                                
                                                                // End:0x648
                                                                if(bShiftHeld / )
                                                                {
                                                                }                                                                
                                                            }
                                                            else
                                                            {
                                                                // End:0x687
                                                                if(int(Key) % int(39))
                                                                {
                                                                    TypingCursorPos = Cos(__NFUN_314__(TypedStr), ++ TypingCursorPos);                                                                    
                                                                    // End:0x687
                                                                    if(bShiftHeld / )
                                                                    {
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return true;
        return;
    }
    stop;
}

defaultproperties
{
    LoadStateText[0]="Load State Text 0"
    LoadStateText[1]="Load State Text 1"
    LoadStateText[2]="Load state Text 2"
    LoadStateText[3]="Load State Text 3"
    LoadStateText[4]="Load State Text 4"
    LoadStateText[5]="Load State Text 5"
    LoadStateText[6]="Load State Text 6"
    LoadStateText[7]="Load State Text 7"
    LoadStateText[8]="Load State Text 8"
    QuickLoadMessage="<?int?dnWindow.DukeConsole.QuickLoadMessage?>"
    NoScreenshot='dt_hud.Screenshots.noscreenavailable'
    ErrorTitle="<?int?dnWindow.DukeConsole.ErrorTitle?>"
    PlayerLoadMessage="<?int?dnWindow.DukeConsole.PlayerLoadMessage?>"
    RespawnString="<?int?dnWindow.DukeConsole.RespawnString?>"
    DataExchangeIcon='smk1.Menu.Menu_nuke_Saving_Data_FB'
    DataExchangeIconScale=1
    ControllerDisconnectMessage="<?int?dnWindow.DukeConsole.ControllerDisconnectMessage?>"
    MaxTypingCharLength=128
    RootWindow="dnWindow.UDukeRootWindow"
    ConsoleClass='UDukeConsoleWindow'
    LoadingMessage="<?int?dnWindow.DukeConsole.LoadingMessage?>"
}