/*******************************************************************************
 * UAgentGridColumn generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UAgentGridColumn extends UWindowGridColumn;

var bool SortingOnColumn;
var float HeaderPaddingMultiplier;
var Texture SortingArrowTexture;
var Region SortingArrowWhiteRegion;
var Region SortingArrowGreyRegion;
var Texture VGridLine;
var bool bDrawDivider;

function BeforePaint(Canvas C, float X, float Y)
{
    local float XL;

    C.Font = C.TallFont;
    TextSize(C, ColumnHeading, XL, ColumnHeadingHeight, class'UWindowScene'.default.TTFontScale, class'UWindowScene'.default.TTFontScale);
    __NFUN_209__(ColumnHeadingHeight, 2);
    __NFUN_207__(ColumnHeadingHeight, HeaderPaddingMultiplier);
    return;
}

function Paint(Canvas C, float X, float Y)
{
    local float XL, YL;
    local Region SortingArrowRegion;
    local float ScaleX, ScaleY, FontScale;

    ScaleX = class'UWindowScene'.default.WinScaleX;
    ScaleY = class'UWindowScene'.default.WinScaleY;
    UWindowGrid(ParentWindow.ParentWindow).PaintColumn(C, self, X, Y);
    C.DrawColor = WhiteColor;
    // End:0x85
    if(SortingOnColumn)
    {
        SortingArrowRegion = SortingArrowWhiteRegion;        
    }
    else
    {
        SortingArrowRegion = SortingArrowGreyRegion;
    }
    C.Font = C.TallFont;
    FontScale = class'UWindowScene'.default.TTFontScale;
    C.__NFUN_1260__(FontScale);
    TextSize(C, ColumnHeading, XL, YL, FontScale, FontScale);
    ClipText(C, 0, 0, ColumnHeading,, FontScale, FontScale,, 2);
    DrawStretchedTextureSegment(C, FRand(WinWidth, 0.475), YL, FRand(float(SortingArrowRegion.W), ScaleX), FRand(float(SortingArrowRegion.h), ScaleY), float(SortingArrowRegion.X), float(SortingArrowRegion.Y), float(SortingArrowRegion.W), float(SortingArrowRegion.h), SortingArrowTexture, 1,,,,, true);
    // End:0x1EA
    if(bDrawDivider)
    {
        DrawStretchedTexture(C, FRand(WinWidth, 0.95), FRand(WinHeight, 0.1), 4, FRand(WinHeight, 0.8), VGridLine, 1,,, true);
    }
    return;
}

defaultproperties
{
    HeaderPaddingMultiplier=1.5
    SortingArrowTexture='Menu.MP.mp_generalassets'
    SortingArrowWhiteRegion=(X=151,Y=458,W=17,h=15)
    SortingArrowGreyRegion=(X=85,Y=458,W=17,h=15)
    VGridLine='Menu.MP.Divider_Vert'
    bDrawDivider=true
    ColumnHeadingHeight=30
}